# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class MediaUpdate(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'codec': 'str',
        'fps': 'float',
        'height': 'int',
        'last_edit_end': 'datetime',
        'last_edit_start': 'datetime',
        'media_files': 'MediaFiles',
        'multi': 'MultiDefinition',
        'name': 'str',
        'num_frames': 'int',
        'width': 'int'
    }

    attribute_map = {
        'attributes': 'attributes',
        'codec': 'codec',
        'fps': 'fps',
        'height': 'height',
        'last_edit_end': 'last_edit_end',
        'last_edit_start': 'last_edit_start',
        'media_files': 'media_files',
        'multi': 'multi',
        'name': 'name',
        'num_frames': 'num_frames',
        'width': 'width'
    }

    def __init__(self, attributes=None, codec=None, fps=None, height=None, last_edit_end=None, last_edit_start=None, media_files=None, multi=None, name=None, num_frames=None, width=None, local_vars_configuration=None):  # noqa: E501
        """MediaUpdate - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._codec = None
        self._fps = None
        self._height = None
        self._last_edit_end = None
        self._last_edit_start = None
        self._media_files = None
        self._multi = None
        self._name = None
        self._num_frames = None
        self._width = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if codec is not None:
            self.codec = codec
        if fps is not None:
            self.fps = fps
        if height is not None:
            self.height = height
        if last_edit_end is not None:
            self.last_edit_end = last_edit_end
        if last_edit_start is not None:
            self.last_edit_start = last_edit_start
        if media_files is not None:
            self.media_files = media_files
        if multi is not None:
            self.multi = multi
        if name is not None:
            self.name = name
        if num_frames is not None:
            self.num_frames = num_frames
        if width is not None:
            self.width = width

    @property
    def attributes(self):
        """
        Object containing attribute values.

        :return: The attributes of this MediaUpdate. 
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Object containing attribute values.

        :param attributes: The attributes of this MediaUpdate.
        :type: dict(str, object)
        """

        self._attributes = attributes

    @property
    def codec(self):
        """
        Codec of the original video.

        :return: The codec of this MediaUpdate. 
        :rtype: str
        """
        return self._codec

    @codec.setter
    def codec(self, codec):
        """
        Codec of the original video.

        :param codec: The codec of this MediaUpdate.
        :type: str
        """

        self._codec = codec

    @property
    def fps(self):
        """
        Frame rate of the video.

        :return: The fps of this MediaUpdate. 
        :rtype: float
        """
        return self._fps

    @fps.setter
    def fps(self, fps):
        """
        Frame rate of the video.

        :param fps: The fps of this MediaUpdate.
        :type: float
        """

        self._fps = fps

    @property
    def height(self):
        """
        Pixel height of the video.

        :return: The height of this MediaUpdate. 
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """
        Pixel height of the video.

        :param height: The height of this MediaUpdate.
        :type: int
        """

        self._height = height

    @property
    def last_edit_end(self):
        """
        Datetime of the end of the session when this media or its annotations were last edited.

        :return: The last_edit_end of this MediaUpdate. 
        :rtype: datetime
        """
        return self._last_edit_end

    @last_edit_end.setter
    def last_edit_end(self, last_edit_end):
        """
        Datetime of the end of the session when this media or its annotations were last edited.

        :param last_edit_end: The last_edit_end of this MediaUpdate.
        :type: datetime
        """

        self._last_edit_end = last_edit_end

    @property
    def last_edit_start(self):
        """
        Datetime of the start of the session when this media or its annotations were last edited.

        :return: The last_edit_start of this MediaUpdate. 
        :rtype: datetime
        """
        return self._last_edit_start

    @last_edit_start.setter
    def last_edit_start(self, last_edit_start):
        """
        Datetime of the start of the session when this media or its annotations were last edited.

        :param last_edit_start: The last_edit_start of this MediaUpdate.
        :type: datetime
        """

        self._last_edit_start = last_edit_start

    @property
    def media_files(self):
        """

        :return: The media_files of this MediaUpdate. 
        :rtype: MediaFiles
        """
        return self._media_files

    @media_files.setter
    def media_files(self, media_files):
        """

        :param media_files: The media_files of this MediaUpdate.
        :type: MediaFiles
        """

        self._media_files = media_files

    @property
    def multi(self):
        """

        :return: The multi of this MediaUpdate. 
        :rtype: MultiDefinition
        """
        return self._multi

    @multi.setter
    def multi(self, multi):
        """

        :param multi: The multi of this MediaUpdate.
        :type: MultiDefinition
        """

        self._multi = multi

    @property
    def name(self):
        """
        Name of the media.

        :return: The name of this MediaUpdate. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the media.

        :param name: The name of this MediaUpdate.
        :type: str
        """

        self._name = name

    @property
    def num_frames(self):
        """
        Number of frames in the video.

        :return: The num_frames of this MediaUpdate. 
        :rtype: int
        """
        return self._num_frames

    @num_frames.setter
    def num_frames(self, num_frames):
        """
        Number of frames in the video.

        :param num_frames: The num_frames of this MediaUpdate.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                num_frames is not None and num_frames < 0):  # noqa: E501
            raise ValueError("Invalid value for `num_frames`, must be a value greater than or equal to `0`")  # noqa: E501

        self._num_frames = num_frames

    @property
    def width(self):
        """
        Pixel width of the video.

        :return: The width of this MediaUpdate. 
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """
        Pixel width of the video.

        :param width: The width of this MediaUpdate.
        :type: int
        """

        self._width = width

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MediaUpdate):
            return True

        return self.to_dict() != other.to_dict()
