# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Section(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'annotation_bools': 'list[dict(str, object)]',
        'id': 'int',
        'lucene_string': 'str',
        'media_bools': 'list[dict(str, object)]',
        'name': 'str',
        'project': 'int',
        'tator_user_sections': 'str',
        'visible': 'bool'
    }

    attribute_map = {
        'annotation_bools': 'annotation_bools',
        'id': 'id',
        'lucene_string': 'lucene_string',
        'media_bools': 'media_bools',
        'name': 'name',
        'project': 'project',
        'tator_user_sections': 'tator_user_sections',
        'visible': 'visible'
    }

    def __init__(self, annotation_bools=None, id=None, lucene_string=None, media_bools=None, name=None, project=None, tator_user_sections=None, visible=None, local_vars_configuration=None):  # noqa: E501
        """Section - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._annotation_bools = None
        self._id = None
        self._lucene_string = None
        self._media_bools = None
        self._name = None
        self._project = None
        self._tator_user_sections = None
        self._visible = None
        self.discriminator = None

        if annotation_bools is not None:
            self.annotation_bools = annotation_bools
        if id is not None:
            self.id = id
        if lucene_string is not None:
            self.lucene_string = lucene_string
        if media_bools is not None:
            self.media_bools = media_bools
        if name is not None:
            self.name = name
        if project is not None:
            self.project = project
        if tator_user_sections is not None:
            self.tator_user_sections = tator_user_sections
        if visible is not None:
            self.visible = visible

    @property
    def annotation_bools(self):
        """
        List of elasticsearch boolean queries that should be applied to annotations. These are applied to the boolean query \"filter\" list.

        :return: The annotation_bools of this Section. 
        :rtype: list[dict(str, object)]
        """
        return self._annotation_bools

    @annotation_bools.setter
    def annotation_bools(self, annotation_bools):
        """
        List of elasticsearch boolean queries that should be applied to annotations. These are applied to the boolean query \"filter\" list.

        :param annotation_bools: The annotation_bools of this Section.
        :type: list[dict(str, object)]
        """

        self._annotation_bools = annotation_bools

    @property
    def id(self):
        """
        Unique integer identifying the section.

        :return: The id of this Section. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying the section.

        :param id: The id of this Section.
        :type: int
        """

        self._id = id

    @property
    def lucene_string(self):
        """
        Lucene query syntax search string.

        :return: The lucene_string of this Section. 
        :rtype: str
        """
        return self._lucene_string

    @lucene_string.setter
    def lucene_string(self, lucene_string):
        """
        Lucene query syntax search string.

        :param lucene_string: The lucene_string of this Section.
        :type: str
        """

        self._lucene_string = lucene_string

    @property
    def media_bools(self):
        """
        List of elasticsearch boolean queries that should be applied to media. These are applied to the boolean query \"filter\" list.

        :return: The media_bools of this Section. 
        :rtype: list[dict(str, object)]
        """
        return self._media_bools

    @media_bools.setter
    def media_bools(self, media_bools):
        """
        List of elasticsearch boolean queries that should be applied to media. These are applied to the boolean query \"filter\" list.

        :param media_bools: The media_bools of this Section.
        :type: list[dict(str, object)]
        """

        self._media_bools = media_bools

    @property
    def name(self):
        """
        Unique name of the algorithm workflow.

        :return: The name of this Section. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Unique name of the algorithm workflow.

        :param name: The name of this Section.
        :type: str
        """

        self._name = name

    @property
    def project(self):
        """
        Unique integer identifying the project associated with the section.

        :return: The project of this Section. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying the project associated with the section.

        :param project: The project of this Section.
        :type: int
        """

        self._project = project

    @property
    def tator_user_sections(self):
        """
        Attribute that is applied to media to identify membership to a section.

        :return: The tator_user_sections of this Section. 
        :rtype: str
        """
        return self._tator_user_sections

    @tator_user_sections.setter
    def tator_user_sections(self, tator_user_sections):
        """
        Attribute that is applied to media to identify membership to a section.

        :param tator_user_sections: The tator_user_sections of this Section.
        :type: str
        """

        self._tator_user_sections = tator_user_sections

    @property
    def visible(self):
        """
        Determines the visibility in the UI.

        :return: The visible of this Section. 
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Determines the visibility in the UI.

        :param visible: The visible of this Section.
        :type: bool
        """

        self._visible = visible

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Section):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Section):
            return True

        return self.to_dict() != other.to_dict()
