# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class StateTrimUpdate(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'endpoint': 'str',
        'frame': 'int'
    }

    attribute_map = {
        'endpoint': 'endpoint',
        'frame': 'frame'
    }

    def __init__(self, endpoint=None, frame=None, local_vars_configuration=None):  # noqa: E501
        """StateTrimUpdate - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._endpoint = None
        self._frame = None
        self.discriminator = None

        self.endpoint = endpoint
        self.frame = frame

    @property
    def endpoint(self):
        """
        End point to trim to using the provided frame number.

        :return: The endpoint of this StateTrimUpdate. 
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """
        End point to trim to using the provided frame number.

        :param endpoint: The endpoint of this StateTrimUpdate.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and endpoint is None:  # noqa: E501
            raise ValueError("Invalid value for `endpoint`, must not be `None`")  # noqa: E501
        allowed_values = ["start", "end"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and endpoint not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `endpoint` ({0}), must be one of {1}"  # noqa: E501
                .format(endpoint, allowed_values)
            )

        self._endpoint = endpoint

    @property
    def frame(self):
        """
        Frame number of new end point

        :return: The frame of this StateTrimUpdate. 
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """
        Frame number of new end point

        :param frame: The frame of this StateTrimUpdate.
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and frame is None:  # noqa: E501
            raise ValueError("Invalid value for `frame`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                frame is not None and frame < 0):  # noqa: E501
            raise ValueError("Invalid value for `frame`, must be a value greater than or equal to `0`")  # noqa: E501

        self._frame = frame

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StateTrimUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StateTrimUpdate):
            return True

        return self.to_dict() != other.to_dict()
