# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class StateType(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'association': 'str',
        'attribute_types': 'list[AttributeType]',
        'delete_child_localizations': 'bool',
        'description': 'str',
        'dtype': 'str',
        'grouping_default': 'bool',
        'id': 'int',
        'interpolation': 'str',
        'media': 'list[int]',
        'name': 'str',
        'project': 'int',
        'visible': 'bool'
    }

    attribute_map = {
        'association': 'association',
        'attribute_types': 'attribute_types',
        'delete_child_localizations': 'delete_child_localizations',
        'description': 'description',
        'dtype': 'dtype',
        'grouping_default': 'grouping_default',
        'id': 'id',
        'interpolation': 'interpolation',
        'media': 'media',
        'name': 'name',
        'project': 'project',
        'visible': 'visible'
    }

    def __init__(self, association=None, attribute_types=None, delete_child_localizations=False, description=None, dtype=None, grouping_default=True, id=None, interpolation='latest', media=None, name=None, project=None, visible=None, local_vars_configuration=None):  # noqa: E501
        """StateType - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._association = None
        self._attribute_types = None
        self._delete_child_localizations = None
        self._description = None
        self._dtype = None
        self._grouping_default = None
        self._id = None
        self._interpolation = None
        self._media = None
        self._name = None
        self._project = None
        self._visible = None
        self.discriminator = None

        if association is not None:
            self.association = association
        if attribute_types is not None:
            self.attribute_types = attribute_types
        if delete_child_localizations is not None:
            self.delete_child_localizations = delete_child_localizations
        if description is not None:
            self.description = description
        if dtype is not None:
            self.dtype = dtype
        if grouping_default is not None:
            self.grouping_default = grouping_default
        if id is not None:
            self.id = id
        if interpolation is not None:
            self.interpolation = interpolation
        if media is not None:
            self.media = media
        if name is not None:
            self.name = name
        if project is not None:
            self.project = project
        if visible is not None:
            self.visible = visible

    @property
    def association(self):
        """
        Type of object this state type is associated with.

        :return: The association of this StateType. 
        :rtype: str
        """
        return self._association

    @association.setter
    def association(self, association):
        """
        Type of object this state type is associated with.

        :param association: The association of this StateType.
        :type: str
        """
        allowed_values = ["Media", "Frame", "Localization"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and association not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `association` ({0}), must be one of {1}"  # noqa: E501
                .format(association, allowed_values)
            )

        self._association = association

    @property
    def attribute_types(self):
        """
        Attribute type definitions.

        :return: The attribute_types of this StateType. 
        :rtype: list[AttributeType]
        """
        return self._attribute_types

    @attribute_types.setter
    def attribute_types(self, attribute_types):
        """
        Attribute type definitions.

        :param attribute_types: The attribute_types of this StateType.
        :type: list[AttributeType]
        """

        self._attribute_types = attribute_types

    @property
    def delete_child_localizations(self):
        """
        True if child localizations should be deleted when this state is deleted. Localizations will only be deleted if they are not associated with another state. 

        :return: The delete_child_localizations of this StateType. 
        :rtype: bool
        """
        return self._delete_child_localizations

    @delete_child_localizations.setter
    def delete_child_localizations(self, delete_child_localizations):
        """
        True if child localizations should be deleted when this state is deleted. Localizations will only be deleted if they are not associated with another state. 

        :param delete_child_localizations: The delete_child_localizations of this StateType.
        :type: bool
        """

        self._delete_child_localizations = delete_child_localizations

    @property
    def description(self):
        """
        Description of the state type.

        :return: The description of this StateType. 
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Description of the state type.

        :param description: The description of this StateType.
        :type: str
        """

        self._description = description

    @property
    def dtype(self):
        """
        String indicating data type. Always equal to \"state\".

        :return: The dtype of this StateType. 
        :rtype: str
        """
        return self._dtype

    @dtype.setter
    def dtype(self, dtype):
        """
        String indicating data type. Always equal to \"state\".

        :param dtype: The dtype of this StateType.
        :type: str
        """

        self._dtype = dtype

    @property
    def grouping_default(self):
        """
        Whether to group elements in the UI by default.

        :return: The grouping_default of this StateType. 
        :rtype: bool
        """
        return self._grouping_default

    @grouping_default.setter
    def grouping_default(self, grouping_default):
        """
        Whether to group elements in the UI by default.

        :param grouping_default: The grouping_default of this StateType.
        :type: bool
        """

        self._grouping_default = grouping_default

    @property
    def id(self):
        """
        Unique integer identifying a state type.

        :return: The id of this StateType. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying a state type.

        :param id: The id of this StateType.
        :type: int
        """

        self._id = id

    @property
    def interpolation(self):
        """
        Interpolation method used by the web interface.

        :return: The interpolation of this StateType. 
        :rtype: str
        """
        return self._interpolation

    @interpolation.setter
    def interpolation(self, interpolation):
        """
        Interpolation method used by the web interface.

        :param interpolation: The interpolation of this StateType.
        :type: str
        """
        allowed_values = ["none", "latest", "attr_style_range"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and interpolation not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `interpolation` ({0}), must be one of {1}"  # noqa: E501
                .format(interpolation, allowed_values)
            )

        self._interpolation = interpolation

    @property
    def media(self):
        """
        List of integers identifying media types that this state type may apply to.

        :return: The media of this StateType. 
        :rtype: list[int]
        """
        return self._media

    @media.setter
    def media(self, media):
        """
        List of integers identifying media types that this state type may apply to.

        :param media: The media of this StateType.
        :type: list[int]
        """

        self._media = media

    @property
    def name(self):
        """
        Name of the state type.

        :return: The name of this StateType. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the state type.

        :param name: The name of this StateType.
        :type: str
        """

        self._name = name

    @property
    def project(self):
        """
        Unique integer identifying project for this state type.

        :return: The project of this StateType. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying project for this state type.

        :param project: The project of this StateType.
        :type: int
        """

        self._project = project

    @property
    def visible(self):
        """
        Whether this state type should be displayed.

        :return: The visible of this StateType. 
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Whether this state type should be displayed.

        :param visible: The visible of this StateType.
        :type: bool
        """

        self._visible = visible

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StateType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StateType):
            return True

        return self.to_dict() != other.to_dict()
