# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class VideoClip(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file': 'TemporaryFile',
        'segment_end_frames': 'list[int]',
        'segment_start_frames': 'list[int]'
    }

    attribute_map = {
        'file': 'file',
        'segment_end_frames': 'segment_end_frames',
        'segment_start_frames': 'segment_start_frames'
    }

    def __init__(self, file=None, segment_end_frames=None, segment_start_frames=None, local_vars_configuration=None):  # noqa: E501
        """VideoClip - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._file = None
        self._segment_end_frames = None
        self._segment_start_frames = None
        self.discriminator = None

        if file is not None:
            self.file = file
        if segment_end_frames is not None:
            self.segment_end_frames = segment_end_frames
        if segment_start_frames is not None:
            self.segment_start_frames = segment_start_frames

    @property
    def file(self):
        """

        :return: The file of this VideoClip. 
        :rtype: TemporaryFile
        """
        return self._file

    @file.setter
    def file(self, file):
        """

        :param file: The file of this VideoClip.
        :type: TemporaryFile
        """

        self._file = file

    @property
    def segment_end_frames(self):
        """
        List of end frames of segments that form the clip. Index associated with segment_start_frames.

        :return: The segment_end_frames of this VideoClip. 
        :rtype: list[int]
        """
        return self._segment_end_frames

    @segment_end_frames.setter
    def segment_end_frames(self, segment_end_frames):
        """
        List of end frames of segments that form the clip. Index associated with segment_start_frames.

        :param segment_end_frames: The segment_end_frames of this VideoClip.
        :type: list[int]
        """

        self._segment_end_frames = segment_end_frames

    @property
    def segment_start_frames(self):
        """
        List of start frames of segments that form the clip. Index associated with segment_end_frames.

        :return: The segment_start_frames of this VideoClip. 
        :rtype: list[int]
        """
        return self._segment_start_frames

    @segment_start_frames.setter
    def segment_start_frames(self, segment_start_frames):
        """
        List of start frames of segments that form the clip. Index associated with segment_end_frames.

        :param segment_start_frames: The segment_start_frames of this VideoClip.
        :type: list[int]
        """

        self._segment_start_frames = segment_start_frames

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoClip):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoClip):
            return True

        return self.to_dict() != other.to_dict()
