// Copyright 2020 Kaggle Inc
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

function renderer({
  act,
  agents,
  environment,
  height = 400,
  interactive,
  isInteractive,
  parent,
  step,
  update,
  width = 400,
}) {
  // Configuration.
  const { rows, columns } = environment.configuration;

  const colors = {
    orange: "#FFB345",
    red: "#FF2615",
    green: "#1EFF71",
    blue: "#30DFFC",
    purple: "#FF48D8",
    players: [
      "#FFFFFF",
      "#68DCFB",
      "#7BDF4F",
      "#EC7E79",
      "#AD59EA",
      "#F4AFF8",
      "#F0E524",
      "#90AAFF",
    ],
  };

  // SVG Paths (based on 300x300 grid).
  // Path2D variant of these are all cached. new Path2D("")
  let paths = {
    // Head with neck starting from S.
    head: [
      "M179.6,72.2c-0.4-0.3-1.1-0.3-1.4,0.2c-0.3,0.4-0.3,1.1,0.2,1.4c25.2,19.4,9.5,44.8,2,56.9c-1.1,1.8-2.1,3.4-2.7,4.6  c-5.6,11.1-14.7,25.7-28.7,25c-7.2-0.4-12.8-5.6-17.9-10.2c-2.2-2-4.2-3.9-6.3-5.3l-1.5-1c-16.5-11.4-29.6-20.5-29.6-41.5  c0-16.5,8.3-31.7,22.1-40.7c1.5-0.9,3-2.2,4.7-3.6c3.8-3.1,8.1-6.6,11.5-6.3c1.3,0.1,2.4,0.8,3.4,2.1c0.3,0.4,1,0.5,1.4,0.1  c0.4-0.3,0.5-1,0.1-1.4c-1.4-1.7-3-2.6-4.8-2.8c-4.3-0.4-8.9,3.4-13,6.7c-1.6,1.3-3.1,2.6-4.5,3.4c-14.4,9.3-23,25.2-23,42.4  c0,22.1,13.5,31.4,30.5,43.2l1.5,1c1.7,1.2,3.5,2.7,5.3,4.4c0,0,0,0.1,0,0.1v149c0,0.6,0.4,1,1,1s1-0.4,1-1V152.7  c5,4.5,10.6,9.2,17.9,9.6c0.4,0,0.7,0,1.1,0c7.8,0,14-4.2,19-9.9V300c0,0.6,0.4,1,1,1s1-0.4,1-1V150c3.4-4.4,6.2-9.4,8.5-13.8  c0.6-1.1,1.5-2.6,2.6-4.4C189.9,119.1,206.3,92.8,179.6,72.2z",
      "M137.3,78c-2.7,0-5,2.2-5,5s2.2,5,5,5s5-2.2,5-5S140,78,137.3,78z",
      "M126.5,90c-0.2-4.4,2.8-7.2,2.9-7.2c6.4-6.4,9.6-12.3,9.5-17.3c0-3.3-1.6-5.2-2-5.6c-1-1.5-2.3-2.3-3.9-2.4   c-3.5-0.2-6.8,3.7-6.9,3.8c-0.4,0.4-0.3,1.1,0.1,1.4c0.4,0.4,1.1,0.3,1.4-0.1c0.8-0.9,3.2-3.2,5.3-3.1c0.9,0,1.7,0.6,2.4,1.6   l0.1,0.2c0.1,0.1,6.1,6.4-7.4,20.1c-0.2,0.1-3.7,3.4-3.5,8.8c0.2,4.8,3.5,9.7,9.8,14.3c0.2,0.1,0.4,0.2,0.6,0.2   c0.3,0,0.6-0.1,0.8-0.4c0.3-0.4,0.2-1.1-0.2-1.4C129.8,98.5,126.8,94.2,126.5,90z",
    ],
    headBeak: [
      "M178.5,49l-6.9-20.7c-0.3-5.6-0.9-11.6-1.7-17.9c0,0,0,0,0,0l-0.2-1.7c-0.1-0.8-0.7-7.9-4.5-8c0,0,0,0,0,0   c-2.7,0-4.8,5.3-5.6,8.4c-0.7,2.8-1.4,6.1-2.1,9.6c-1.5,7.3-3.2,15.6-5.5,19.5c-2.3,3.8-6.1,6.7-9.5,9.3c-4.3,3.2-8.3,6.3-8.3,10.7   c0,3.8,5.8,7,12.4,10.7c4.2,2.4,8.6,4.8,11.6,7.4c2.9,2.5,5.9,3.8,8.8,3.8c0.5,0,0.9,0,1.4-0.1c4.8-0.7,7.7-4.6,8.2-5.3   c0.8-0.8,5.5-5.8,5.5-9.5C182,58,178.6,49.3,178.5,49z M175,73.3c0,0-0.1,0.1-0.1,0.2c0,0-2.6,3.9-6.9,4.5   c-2.8,0.4-5.6-0.7-8.5-3.2c-3.2-2.8-7.7-5.3-12-7.7c-5.6-3.1-11.4-6.4-11.4-8.9c0-3.4,3.5-6,7.5-9.1c3.5-2.7,7.5-5.7,10-9.8   c2.5-4.2,4.2-12.3,5.7-20.1c0.7-3.5,1.4-6.7,2.1-9.5c1.2-4.5,3-6.9,3.7-6.9c0,0,0,0,0,0c1.4,0,2.3,3.7,2.5,6.1l1.8,19.4   c0,0.1,0,0.2,0,0.2l0.1,0.3c1.4,25.2-1.7,42.2-1.9,43.2c-0.1,0.2-0.1,0.4,0,0.5c0.1,0.5,0.5,0.8,1,0.8c0.1,0,0.1,0,0.2,0   c0.8-0.1,0.9-0.1,1.6-5.5c0.4-2.7,0.9-7.2,1.2-12.9c0.3-5.1,0.5-11.6,0.3-19.2l4.7,14.1c0,0.1,3.5,8.7,3.5,15.5   C180,67.8,176.4,71.9,175,73.3z",
      "M149.5,56.7c-1.5,0-2.7,1.2-2.7,2.7c0,1.5,1.2,2.7,2.7,2.7c1.5,0,2.7-1.2,2.7-2.7   C152.2,57.9,151,56.7,149.5,56.7z M149.5,60c-0.4,0-0.7-0.3-0.7-0.7c0-0.4,0.3-0.7,0.7-0.7c0.4,0,0.7,0.3,0.7,0.7   C150.2,59.7,149.9,60,149.5,60z",
    ],
    // Curve from N to E.
    neckNE: [
      "M300,169H157c-14.3,0-26-11.7-26-26V0c0-0.6-0.4-1-1-1s-1,0.4-1,1v144c0,0.1,0,0.1,0,0.1c0.6,14.9,12.9,26.9,28,26.9h143c0.6,0,1-0.4,1-1S300.6,169,300,169z",
      "M190,131h110c0.6,0,1-0.4,1-1s-0.4-1-1-1H190c-10.5,0-19-8.5-19-19V0c0-0.6-0.4-1-1-1s-1,0.4-1,1v110C169,121.6,178.4,131,190,131z",
    ],
    // Straight from N to S.
    neckNS: [
      "M130-1c-0.6,0-1,0.4-1,1v300c0,0.6,0.4,1,1,1s1-0.4,1-1V0C131-0.6,130.6-1,130-1z",
      "M170-1c-0.6,0-1,0.4-1,1v300c0,0.6,0.4,1,1,1s1-0.4,1-1V0C171-0.6,170.6-1,170-1z",
    ],
    body: [
      "M222.4,232c-3.9-15.3-17.9-27.9-28.9-35.7c-10.2-7.2-19.8-11.9-22.5-13.1V110c0-0.6-0.4-1-1-1s-1,0.4-1,1v73.3  c0,0,0,0,0,0.1c-0.1,0.3-0.1,0.6,0,0.8v8.8c0,0.6,0.4,1,1,1s1-0.4,1-1v-7.6c7.8,3.7,43.1,21.8,49.5,47.1c2.5,10,0.2,20-6.8,29.8  c-0.7,0.9-1.5,1.8-2.5,3.1l-1,1.2c-6.6,7.9-22.7,18.6-33.6,23.7c-17.1,7.9-37.1,9.7-56.3,5c-18.9-4.7-34.4-14.2-44.6-27.4  C65,254,60.3,236.4,62.1,216.8l0-0.5c0.3-2.9,1.2-11.8-6-16.1c-1.4-0.9-2.8-1.7-4.2-2.5c-7.4-4.3-13.7-8-13.4-10.4  c0.1-0.9,1.4-2.4,6.9-4.2c0,0,0.1,0,0.1,0c1.4,0.8,2.8,1.6,4.4,2.4c0.2,0.1,0.3,0.1,0.5,0.1c0.4,0,0.7-0.2,0.9-0.5  c0.3-0.5,0.1-1.1-0.4-1.4c-26.6-14.3-28.3-19.2-27.7-20.7c1.5-4.1,22.6-2.1,37.2,0.7c0.5,0.1,1.1-0.3,1.2-0.8  c0.1-0.5-0.3-1.1-0.8-1.2c-2.1-0.4-7.2-1.3-13-2.1c-0.4-0.6-0.8-1.3-1.2-1.9c-1.3-1.9-2.6-3.9-2.2-5.7c0.4-1.6,1.4-2.8,3-3.6  c9.2-5,36.7,0.6,81.8,16.6v9c0,0.6,0.4,1,1,1s1-0.4,1-1v-9.2c0-0.1,0.1-0.1,0.1-0.2c0.1-0.3,0.1-0.6-0.1-0.8v-54.3  c2,1,4.1,2,6.3,2.9c0.1,0,0.2,0.1,0.4,0.1c0.4,0,0.8-0.2,0.9-0.6c0.2-0.5-0.1-1.1-0.6-1.3c-6.5-2.5-12.1-6.1-16.3-8.6  c-1.8-1.1-3.4-2.1-4.6-2.7c-11.1-5.6-25.7-14.7-25-28.7c0.4-7.2,5.6-12.8,10.2-17.9c2-2.2,3.9-4.2,5.3-6.3l1-1.5  c11.4-16.5,20.5-29.6,41.5-29.6c16.5,0,31.7,8.3,40.7,22.1c0.9,1.5,2.2,3,3.6,4.7c3.1,3.8,6.6,8.1,6.3,11.5  c-0.1,1.3-0.8,2.4-2.1,3.4c-0.4,0.3-0.5,1-0.1,1.4c0.3,0.4,1,0.5,1.4,0.1c1.7-1.4,2.6-3,2.8-4.8c0.4-4.3-3.4-8.9-6.7-13  c-1.3-1.6-2.6-3.1-3.4-4.5c-9.3-14.4-25.2-23-42.4-23c-22.1,0-31.4,13.5-43.2,30.5l-1,1.5c-1.3,1.9-3.2,3.9-5.1,6.1  c-4.8,5.3-10.3,11.2-10.7,19.1c-0.8,15.2,14.5,24.7,26.1,30.5c1.1,0.6,2.6,1.5,4.4,2.6c2.4,1.5,5.2,3.2,8.4,4.9  c-0.1,0.1-0.1,0.3-0.1,0.5v53.8c-45.8-16.2-72.9-21.5-82.7-16.2c-2.1,1.1-3.5,2.8-4,4.9c-0.7,2.7,1,5.1,2.5,7.3  c0.1,0.2,0.2,0.3,0.3,0.5c-10.5-1.2-22.3-1.5-23.9,2.9c-0.9,2.6,0.6,7.4,22,19.5c-4.4,1.6-6.5,3.3-6.7,5.4  c-0.4,3.7,5.2,6.9,14.4,12.4c1.3,0.8,2.7,1.6,4.2,2.5c6.2,3.7,5.4,11.3,5.1,14.1l0,0.5c-3.6,39.7,19.3,70.6,59.7,80.6  c7.2,1.8,14.5,2.7,21.8,2.7c12.5,0,24.7-2.6,35.8-7.8c11.1-5.1,27.3-15.9,34.3-24.2l1-1.2c0.2-0.3,0.5-0.6,0.7-0.8  c0.1-0.1,0.3-0.2,0.4-0.3c0.5-0.7,1.1-1.4,1.6-2.1c0.2-0.2,0.3-0.4,0.5-0.7c0-0.1,0.1-0.1,0.1-0.2C222.8,252.5,225,242.2,222.4,232z",
      "M162.7,114.2c-0.4,0-0.8-0.3-0.9-0.7c-0.2-0.5,0.1-1.1,0.6-1.3c6-2,11.5-6.2,16.3-12.4c0.3-0.4,1-0.5,1.4-0.2  c0.4,0.3,0.5,1,0.2,1.4c-5,6.5-10.8,10.9-17.3,13C162.9,114.2,162.8,114.2,162.7,114.2z",
      "M174.5,58.8c0-2.7-2.2-5-5-5s-5,2.2-5,5s2.2,5,5,5S174.5,61.5,174.5,58.8z M166.5,58.8c0-1.6,1.3-3,3-3s3,1.3,3,3  s-1.3,3-3,3S166.5,60.4,166.5,58.8z",
      "M187,60.4c3.3,0,5.2-1.6,5.6-2c1.5-1,2.3-2.3,2.4-3.9c0.2-3.5-3.7-6.8-3.8-6.9c-0.4-0.4-1.1-0.3-1.4,0.1  c-0.4,0.4-0.3,1.1,0.1,1.4c0.9,0.8,3.2,3.2,3.1,5.3c0,0.9-0.6,1.7-1.6,2.4l-0.2,0.1c-0.1,0.1-6.4,6.1-20.1-7.4  c-0.1-0.2-3.4-3.7-8.8-3.5c-4.8,0.2-9.7,3.5-14.3,9.8c-0.3,0.4-0.2,1.1,0.2,1.4s1.1,0.2,1.4-0.2c4.3-5.7,8.6-8.7,12.8-9  c4.4-0.2,7.2,2.8,7.2,2.9c6.4,6.3,12.1,9.5,17.1,9.5C186.9,60.4,187,60.4,187,60.4z",
    ],
    bodyBeak: [
      "M187.3,103.5c-3.7,0-8.6-4.7-9.5-5.5c-0.7-0.5-4.6-3.4-5.3-8.2c-0.5-3.3,0.8-6.7,3.7-10.1  c2.7-3.1,5.1-7.4,7.4-11.6c3.7-6.7,6.9-12.4,10.7-12.4c4.4,0,7.4,4,10.7,8.3c2.5,3.4,5.4,7.2,9.3,9.5c3.9,2.3,12.2,4,19.5,5.5  c3.5,0.7,6.8,1.4,9.6,2.1c3.2,0.8,8.5,2.9,8.4,5.7c-0.1,3.8-7.2,4.4-8,4.5l-19.3,1.8l-21.1,7C203.2,100.1,194.5,103.5,187.3,103.5z   M194.3,57.6c-2.6,0-5.8,5.8-8.9,11.4c-2.4,4.3-4.9,8.8-7.7,12c-2.5,2.9-3.6,5.8-3.2,8.5c0.6,4.2,4.5,6.9,4.5,6.9  c0.1,0,0.1,0.1,0.2,0.1c1.4,1.4,5.6,5,8.1,5c6.8,0,15.4-3.4,15.5-3.5L224,91c0.1,0,0.1,0,0.2,0l19.4-1.8c2.5-0.2,6.1-1.1,6.1-2.5  c0-0.6-2.4-2.5-6.9-3.7c-2.7-0.7-6-1.4-9.5-2.1c-7.8-1.6-16-3.2-20.1-5.7c-4.2-2.5-7.2-6.5-9.8-10C200.4,61.1,197.7,57.6,194.3,57.6  z",
      "M210.4,93.5c-4.9,0-9.1-0.2-12.7-0.4c-5.8-0.3-10.2-0.8-12.9-1.2c-5.3-0.7-5.4-0.8-5.5-1.6   c-0.1-0.5,0.3-1,0.8-1.2c0.2,0,0.4,0,0.5,0c1.2,0.2,26.4,4.8,61.3,0.1c0.5-0.1,1.1,0.3,1.1,0.9s-0.3,1.1-0.9,1.1   C230.1,93,219.2,93.5,210.4,93.5z",
      "M193.1,73.7c-1.5,0-2.7-1.2-2.7-2.7c0-1.5,1.2-2.7,2.7-2.7c1.5,0,2.7,1.2,2.7,2.7   C195.8,72.5,194.6,73.7,193.1,73.7z M193.1,70.4c-0.4,0-0.7,0.3-0.7,0.7c0,0.4,0.3,0.7,0.7,0.7c0.4,0,0.7-0.3,0.7-0.7   C193.8,70.7,193.5,70.4,193.1,70.4z",
    ],
    bodyN: [
      "M215.9,262.5c6.9-10,9.1-20.3,6.5-30.6c-3.9-15.3-17.9-27.9-28.9-35.7c-10.2-7.2-19.8-11.9-22.5-13.1V0   c0-0.6-0.4-1-1-1s-1,0.4-1,1v183.3c0,0,0,0,0,0.1c-0.1,0.3-0.1,0.6,0,0.8v8.8c0,0.6,0.4,1,1,1s1-0.4,1-1v-7.6   c7.8,3.7,43.1,21.8,49.5,47.1c2.5,10,0.2,20-6.8,29.8c-0.7,0.9-1.5,1.8-2.5,3.1l-1,1.2c-6.6,7.9-22.7,18.6-33.6,23.7   c-17.1,7.9-37.1,9.7-56.3,5c-18.9-4.7-34.4-14.2-44.6-27.4C65,254,60.3,236.4,62.1,216.8l0-0.5c0.3-2.9,1.2-11.8-6-16.1   c-1.4-0.9-2.8-1.7-4.2-2.5c-7.4-4.3-13.7-8-13.4-10.4c0.1-0.9,1.4-2.4,6.9-4.2c0,0,0.1,0,0.1,0c1.4,0.8,2.8,1.6,4.4,2.4   c0.2,0.1,0.3,0.1,0.5,0.1c0.4,0,0.7-0.2,0.9-0.5c0.3-0.5,0.1-1.1-0.4-1.4c-26.6-14.3-28.3-19.2-27.7-20.7   c1.5-4.1,22.6-2.1,37.2,0.7c0.5,0.1,1.1-0.3,1.2-0.8c0.1-0.5-0.3-1.1-0.8-1.2c-2.1-0.4-7.2-1.3-13-2.1c-0.4-0.6-0.8-1.3-1.2-1.9   c-1.3-1.9-2.6-3.9-2.2-5.7c0.4-1.6,1.4-2.8,3-3.6c9.3-5,37.1,0.7,82.6,16.8c0.1,0,0.2,0.1,0.3,0.1c0.4,0,0.8-0.3,0.9-0.7   c0.1-0.3,0.1-0.6-0.1-0.8V0c0-0.6-0.4-1-1-1s-1,0.4-1,1v162.8c-45.8-16.2-72.9-21.5-82.7-16.2c-2.1,1.1-3.5,2.8-4,4.9   c-0.7,2.7,1,5.1,2.5,7.3c0.1,0.2,0.2,0.3,0.3,0.5c-10.5-1.2-22.3-1.5-23.9,2.9c-0.9,2.6,0.6,7.4,22,19.5c-4.4,1.6-6.5,3.3-6.7,5.4   c-0.4,3.7,5.2,6.9,14.4,12.4c1.3,0.8,2.7,1.6,4.2,2.5c6.2,3.7,5.4,11.3,5.1,14.1l0,0.5c-3.6,39.7,19.2,70.6,59.7,80.6   c7.2,1.8,14.5,2.7,21.8,2.7c12.5,0,24.7-2.6,35.8-7.8c11.1-5.1,27.3-15.9,34.3-24.2l1-1.2c0.2-0.3,0.5-0.6,0.7-0.8   c0.1-0.1,0.3-0.2,0.4-0.3c0.5-0.7,1.1-1.4,1.6-2.1c0.2-0.2,0.3-0.4,0.5-0.7C215.9,262.7,215.9,262.6,215.9,262.5z",
    ],
    bodyS: [
      "M268.2,80.4c0-38.9-31.6-70.5-70.5-70.5C159.9,10,129,42.3,129,82c0,0,0,0,0,0c0,0,0,0,0,0l0.3,80.9   c-46-16.3-73.1-21.6-83-16.3c-2.1,1.1-3.5,2.8-4,4.9c-0.7,2.7,1,5.1,2.5,7.3c0.1,0.2,0.2,0.3,0.3,0.5c-10.5-1.2-22.3-1.5-23.9,2.9   c-0.9,2.6,0.6,7.4,22,19.5c-4.4,1.6-6.5,3.3-6.7,5.4c-0.4,3.7,5.2,6.9,14.4,12.4c1.3,0.8,2.7,1.6,4.2,2.5   c6.2,3.7,5.4,11.3,5.1,14.1l0,0.5c-3.6,39.7,19.2,70.6,59.7,80.6c7.2,1.8,14.5,2.7,21.8,2.7c12.5,0,24.7-2.6,35.8-7.8   c11.1-5.1,27.3-15.9,34.3-24.2l1-1.2c0.2-0.3,0.5-0.6,0.7-0.8c0.1-0.1,0.3-0.2,0.4-0.3c0.5-0.7,1.1-1.4,1.6-2.1   c0.2-0.2,0.3-0.4,0.5-0.7c0-0.1,0.1-0.1,0.1-0.2c6.9-10,9.1-20.3,6.5-30.6c-3.9-15.3-17.9-27.9-28.9-35.7   c-3.9-2.8-7.8-5.2-11.2-7.2l67.4-61c0,0,0,0,0,0c0,0,0,0,0,0C261.7,115,268.2,98.1,268.2,80.4z M170.9,183.1v-30.6l54.2-47.7   c0,0,0,0,0,0c0,0,0,0,0,0c6-6,9.3-14,9.3-22.5c0-17.5-14.3-31.8-31.8-31.8c-18.1,0-33.4,13.8-33.7,30.2c0,0,0,0.1,0,0.1v103   c0,0,0,0,0,0v8.7c0,0.6,0.4,1,1,1s1-0.4,1-1v-7.1c7.5,3.6,43.2,21.7,49.6,47.1c2.5,10,0.2,20-6.8,29.8c-0.7,0.9-1.5,1.8-2.5,3.1   l-1,1.2c-6.6,7.9-22.7,18.6-33.6,23.7c-17.1,7.9-37.1,9.7-56.3,5c-18.9-4.7-34.4-14.2-44.6-27.4C65,254,60.3,236.4,62.1,216.8   l0-0.5c0.3-2.9,1.2-11.8-6-16.1c-1.4-0.9-2.8-1.7-4.2-2.5c-7.4-4.3-13.7-8-13.4-10.4c0.1-0.9,1.4-2.4,6.9-4.2c0,0,0.1,0,0.1,0   c1.4,0.8,2.8,1.6,4.4,2.4c0.2,0.1,0.3,0.1,0.5,0.1c0.4,0,0.7-0.2,0.9-0.5c0.3-0.5,0.1-1.1-0.4-1.4c-26.6-14.3-28.3-19.2-27.7-20.7   c1.5-4.1,22.6-2.1,37.2,0.7c0.5,0.1,1.1-0.3,1.2-0.8c0.1-0.5-0.3-1.1-0.8-1.2c-2.1-0.4-7.2-1.3-13-2.1c-0.4-0.6-0.8-1.3-1.2-1.9   c-1.3-1.9-2.6-3.9-2.2-5.7c0.4-1.6,1.4-2.8,3-3.6c9.2-5,36.8,0.6,82,16.7l0,8.9c0,0.6,0.4,1,1,1c0,0,0,0,0,0c0.6,0,1-0.5,1-1   L131,82c0-38.6,30-70,66.8-70c37.8,0,68.5,30.7,68.5,68.5c0,17.2-6.4,33.6-18,46.2l-67.8,61.4C175.8,185.4,172.2,183.7,170.9,183.1   z M223.7,103.3l-52.8,46.5V81.2c0-15.6,14.5-28.7,31.7-28.7c16.4,0,29.8,13.4,29.8,29.8C232.4,90.2,229.3,97.7,223.7,103.3z",
    ],
    bodyW: [
      "M215.9,262.5c6.8-9.9,9-20,6.6-30c-6.3-26.7-43.4-45.5-50.7-48.9c-0.1-0.1-0.3-0.1-0.4-0.1V166   c0-0.2,0-0.3-0.1-0.4c-0.2-20.2-16.7-36.5-36.9-36.6c0,0,0,0,0,0H0.4c-0.6,0-1,0.4-1,1s0.4,1,1,1h133.9c19.3,0,35,15.7,35,35   c0,0.2,0,0.3,0.1,0.4V192c0,0.6,0.4,1,1,1s1-0.4,1-1v-6.5c8,3.9,43.2,22,49.2,47.4c2.3,9.8,0,19.7-6.9,29.3   c-0.7,0.9-1.5,1.8-2.5,3.1l-1,1.2c-6.6,7.9-22.7,18.6-33.6,23.7c-17.1,7.9-37.1,9.7-56.3,5c-18.9-4.7-34.4-14.2-44.6-27.4   C65,254,60.3,236.4,62.1,216.8l0-0.5c0.3-2.9,1.2-11.8-6-16.1c-1.4-0.9-2.8-1.7-4.2-2.5c-7.4-4.3-13.7-8-13.5-10.4   c0.1-0.9,1.4-2.4,6.9-4.2c0,0,0.1,0,0.1,0c1.4,0.8,2.9,1.6,4.4,2.4c0.2,0.1,0.3,0.1,0.5,0.1c0.4,0,0.7-0.2,0.9-0.5   c0.3-0.5,0.1-1.1-0.4-1.4c-9.2-4.9-16.2-9.2-20.9-12.7h80.5c8,0,15.2,5,17.9,12.5c0.1,0.4,0.5,0.7,0.9,0.7c0.1,0,0.2,0,0.3-0.1   c0.5-0.2,0.8-0.8,0.6-1.3c-3-8.3-10.9-13.9-19.8-13.9H0.4c-0.6,0-1,0.4-1,1s0.4,1,1,1h26.3c3.6,3,9.2,6.6,16.6,10.8   c-4.4,1.6-6.5,3.3-6.7,5.4c-0.4,3.7,5.2,6.9,14.4,12.4c1.3,0.8,2.7,1.6,4.2,2.5c6.2,3.7,5.4,11.3,5.1,14.1l0,0.5   c-3.6,39.7,19.3,70.6,59.7,80.6c7.2,1.8,14.5,2.7,21.8,2.7c12.5,0,24.7-2.6,35.8-7.8c11.1-5.1,27.3-15.9,34.3-24.2l1-1.2   c0.3-0.3,0.5-0.6,0.7-0.8c0.1-0.1,0.3-0.2,0.4-0.3c0.5-0.7,1-1.4,1.5-2.1c0.2-0.2,0.4-0.5,0.5-0.7   C215.9,262.7,215.9,262.6,215.9,262.5z",
    ],
    bodyE: [
      "M300,169H190c-11.6,0-21,9.4-21,21v10c0,0.6,0.4,1,1,1s1-0.4,1-1v-10c0-1.5,0.2-3,0.5-4.4   c8.4,4,43.1,22.1,49.1,47.3c2.3,9.8,0,19.7-6.9,29.3c-0.7,0.8-1.4,1.8-2.5,3l-1,1.3c-6.6,7.9-22.7,18.6-33.6,23.7   c-17.1,7.9-37.1,9.7-56.3,5c-18.9-4.7-34.4-14.2-44.6-27.4C65,254,60.3,236.4,62.1,216.8l0-0.5c0.3-2.9,1.2-11.8-6-16.1   c-1.4-0.9-2.8-1.7-4.2-2.5c-7.4-4.3-13.7-8-13.4-10.4c0.1-0.9,1.4-2.4,6.9-4.2c0,0,0.1,0,0.1,0c1.4,0.8,2.8,1.6,4.4,2.4   c0.2,0.1,0.3,0.1,0.5,0.1c0.4,0,0.7-0.2,0.9-0.5c0.3-0.5,0.1-1.1-0.4-1.4c-26.6-14.3-28.3-19.2-27.7-20.7   c1.5-4.1,22.6-2.1,37.2,0.7c0.5,0.1,1.1-0.3,1.2-0.8c0.1-0.5-0.3-1.1-0.8-1.2c-2.1-0.4-7.2-1.3-13-2.1c-0.4-0.6-0.8-1.3-1.2-1.9   c-1.3-1.9-2.6-3.9-2.2-5.7c0.4-1.6,1.4-2.8,3-3.6c9.2-5,36.7,0.6,81.6,16.5c0,0,0,0,0,0c0,0.4,0,0.7,0,1.1c0,0.2,0.1,0.4,0.2,0.5   V180c0,0.6,0.4,1,1,1s1-0.4,1-1v-16c0-0.1,0-0.3-0.1-0.4c1.2-18.2,16.4-32.6,34.9-32.6c0,0,0.1,0,0.1,0c0,0,0.1,0,0.1,0h134   c0.6,0,1-0.4,1-1s-0.4-1-1-1H166c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c-19.3,0-35.2,14.9-36.9,33.8c-45.8-16.2-72.9-21.5-82.7-16.2   c-2.1,1.1-3.5,2.8-4,4.9c-0.7,2.7,1,5.1,2.5,7.3c0.1,0.2,0.2,0.3,0.3,0.5c-10.5-1.2-22.3-1.5-23.9,2.9c-0.9,2.6,0.6,7.4,22,19.5   c-4.4,1.6-6.5,3.3-6.7,5.4c-0.4,3.7,5.2,6.9,14.4,12.4c1.3,0.8,2.7,1.6,4.2,2.5c6.2,3.7,5.4,11.3,5.1,14.1l0,0.5   c-3.6,39.7,19.3,70.6,59.7,80.6c7.2,1.8,14.5,2.7,21.8,2.7c12.5,0,24.7-2.6,35.8-7.8c11.1-5.1,27.3-15.9,34.3-24.2l1-1.3   c0.2-0.3,0.5-0.5,0.7-0.8c0.1-0.1,0.3-0.2,0.4-0.3c0.5-0.7,1-1.4,1.5-2.1c0.2-0.2,0.4-0.5,0.5-0.7c0-0.1,0.1-0.1,0.1-0.2   c6.8-9.9,9-20,6.6-30c-6.3-26.4-42.5-45-50.4-48.8c2.6-7.4,9.6-12.7,17.9-12.7h110c0.6,0,1-0.4,1-1S300.6,169,300,169z",
    ],
    wing: [
      "M74.5,207.4c-3.4,5.7,1.3,16.3,14.4,32.3c22.5,27.6,40.6,34.5,53.1,34.5c8,0,13.7-2.9,16.7-4.9c0,0,0,0,0.1,0  c7.6-4.6,13-11.8,15.1-20.2c2.4-9.6,0.2-19.8-6-27.9c-0.3-0.4-1-0.5-1.4-0.2c-0.4,0.3-0.5,1-0.2,1.4c5.8,7.7,7.9,17.2,5.6,26.2  c-1.9,7.7-6.8,14.3-13.6,18.6c-0.1,0-0.1,0-0.2,0.1c-6.5,4.6-30.6,16.3-67.5-28.9c-15.4-18.8-16.2-26.7-14.2-30  c2.6-4.3,11.3-3.6,18.5-2.3c1,2.1,2.3,4.5,4,7.2c0.3,0.4,7.3,11,10.6,16.1l1.7,2.5c0.2,0.3,0.5,0.4,0.8,0.4c0.2,0,0.4-0.1,0.6-0.2  c0.5-0.3,0.6-0.9,0.3-1.4l-1.7-2.5c-3.1-4.7-10.4-15.6-10.6-16c-1.8-2.8-3.1-5.2-4-7.1c0-0.2-0.1-0.4-0.2-0.6  c-2.4-5.3-1.7-7.5-1-8.4c2.6-2.9,12.8,0.5,18.6,3.3c0,0,0.1,0,0.1,0c1,2.5,2.6,5.4,4.7,8.8c0.3,0.5,0.7,1.1,1.1,1.6  c0.2,0.3,0.5,0.4,0.8,0.4c0.2,0,0.4-0.1,0.5-0.2c0.5-0.3,0.6-0.9,0.3-1.4c-0.4-0.6-0.7-1.1-1-1.6c-7-11.1-6.3-14.8-5.2-16.1  c2.6-2.9,12.8,0.5,18.6,3.3c0.5,0.2,1.1,0,1.3-0.5c0.2-0.5,0-1.1-0.5-1.3c-1.7-0.8-16.5-7.8-21-2.8c-1.4,1.5-1.6,3.9-0.7,7.1  c-4.4-2-15.5-6.3-19.3-2c-1.6,1.8-1.6,4.8,0,9C83.5,202.2,77,203.3,74.5,207.4z",
    ],
    feet: [
      "M209.2,299.8h-63.5c-0.6,0-1-0.4-1-1s0.4-1,1-1h63.5c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2h-35.5c-0.6,0-1-0.4-1-1   s0.4-1,1-1h35.5c2.2,0,4,1.8,4,4C213.3,298,211.5,299.8,209.2,299.8z",
      "M141.2,299.8h-40c-2.6,0-4.7-1.8-4.7-4c0-2.2,2.1-4,4.7-4h7.3c0.6,0,1,0.4,1,1s-0.4,1-1,1h-7.3   c-1.5,0-2.7,0.9-2.7,2s1.2,2,2.7,2h40c0.6,0,1,0.4,1,1S141.8,299.8,141.2,299.8z",
    ],
    pizzaCrust: [
      "M197.3,85.2h-94.7c-5.8,0-10.5,4.7-10.5,10.5V98c0,4.5,2.9,8.4,6.9,9.9c0,0,0,0,0,0.1l49.7,106.3  c0.2,0.4,0.5,0.6,0.9,0.6c0,0,0,0,0,0c0.4,0,0.7-0.2,0.9-0.6l50.5-106.3c0,0,0-0.1,0-0.1c3.9-1.5,6.7-5.3,6.7-9.8v-2.3  C207.8,90,203.1,85.2,197.3,85.2z M198.6,108.5l-48.9,102.9l-48.1-102.9h1.1h94.7H198.6z M205.8,98c0,4.7-3.8,8.5-8.5,8.5h-94.7  c-4.7,0-8.5-3.8-8.5-8.5v-2.3c0-4.7,3.8-8.5,8.5-8.5h94.7c4.7,0,8.5,3.8,8.5,8.5V98z",
    ],
    pizzaPepperoni: [
      "M122.9,131.1c-3.6,0-7,1.6-9.4,4.3c-0.4,0.4-0.3,1,0.1,1.4c0.4,0.4,1,0.3,1.4-0.1c2-2.3,4.8-3.6,7.9-3.6   c5.7,0,10.4,4.7,10.4,10.4s-4.7,10.4-10.4,10.4c-0.6,0-1,0.4-1,1s0.4,1,1,1c6.9,0,12.4-5.6,12.4-12.4S129.8,131.1,122.9,131.1z",
      "M175.6,138c-6.9,0-12.4,5.6-12.4,12.4c0,6.1,4.3,11.2,10.3,12.2c0.1,0,0.1,0,0.2,0c0.5,0,0.9-0.3,1-0.8   c0.1-0.5-0.3-1.1-0.8-1.2c-5-0.9-8.6-5.2-8.6-10.3c0-5.7,4.7-10.4,10.4-10.4c2.5,0,5,0.9,6.9,2.6c0.4,0.4,1,0.3,1.4-0.1   c0.4-0.4,0.3-1-0.1-1.4C181.6,139.1,178.7,138,175.6,138z",
      "M151.9,143.2c6.9,0,12.4-5.6,12.4-12.4c0-6.9-5.6-12.4-12.4-12.4s-12.4,5.6-12.4,12.4   C139.4,137.6,145,143.2,151.9,143.2z M151.9,120.4c5.7,0,10.4,4.7,10.4,10.4c0,5.7-4.7,10.4-10.4,10.4s-10.4-4.7-10.4-10.4   C141.4,125,146.1,120.4,151.9,120.4z",
      "M123.3,121c6.9,0,12.4-5.6,12.4-12.4c0-0.6-0.4-1-1-1s-1,0.4-1,1c0,5.7-4.7,10.4-10.4,10.4   s-10.4-4.7-10.4-10.4c0-0.6-0.4-1-1-1s-1,0.4-1,1C110.9,115.4,116.5,121,123.3,121z",
      "M188,107.5c-0.6,0-1,0.4-1,1c0,5.7-4.7,10.4-10.4,10.4s-10.4-4.7-10.4-10.4c0-0.6-0.4-1-1-1s-1,0.4-1,1   c0,6.9,5.6,12.4,12.4,12.4s12.4-5.6,12.4-12.4C189,108,188.6,107.5,188,107.5z",
      "M159.1,166.3c0-6.9-5.6-12.4-12.4-12.4s-12.4,5.6-12.4,12.4s5.6,12.4,12.4,12.4S159.1,173.2,159.1,166.3z    M136.2,166.3c0-5.7,4.7-10.4,10.4-10.4s10.4,4.7,10.4,10.4s-4.7,10.4-10.4,10.4S136.2,172.1,136.2,166.3z",
      "M163.3,181.6c-1.5-0.6-3.2-1-4.8-1c-6.9,0-12.4,5.6-12.4,12.4c0,5,3,9.5,7.6,11.4c0.1,0.1,0.3,0.1,0.4,0.1   c0.4,0,0.8-0.2,0.9-0.6c0.2-0.5,0-1.1-0.5-1.3c-3.9-1.6-6.4-5.4-6.4-9.6c0-5.7,4.7-10.4,10.4-10.4c1.4,0,2.8,0.3,4.1,0.8   c0.5,0.2,1.1,0,1.3-0.5C164,182.4,163.8,181.8,163.3,181.6z",
    ],
    chiliBody: [
      "M194.4,161.3c1-3.1,1.6-6.3,1.6-9.7c0-16.7-13.6-30.3-30.3-30.3c-9.2,0-17.7,4.1-23.5,11.2c0,0,0,0.1,0,0.1   c0,0,0,0,0,0c-0.2,0.4-24,40.3-54.8,35.3c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c-5.4,0-9.8,4.4-9.8,9.8c0,5.4,4.3,9.7,9.7,9.8   c0.9,0.2,18.1,3,38.3,3c3.1,0,6.3-0.1,9.5-0.2c25.3-1.2,43.4-7.5,53.2-18.3c0.2-0.1,0.3-0.1,0.4-0.3c2.7-3.1,4.7-6.6,6-10.4   C194.3,161.4,194.3,161.4,194.4,161.3C194.4,161.3,194.4,161.3,194.4,161.3z M87.2,185.6C87.1,185.6,87.1,185.6,87.2,185.6   c-0.1,0-0.1,0-0.2,0c-4.3,0-7.8-3.5-7.8-7.8c0-4.3,3.5-7.7,7.7-7.8c1.9,0.3,3.7,0.4,5.5,0.4c29,0,50.4-35.4,51.2-36.7   c5.4-6.6,13.4-10.4,21.9-10.4c15.6,0,28.3,12.7,28.3,28.3c0,3.1-0.5,6.2-1.5,9.1C177.8,200.9,88.1,185.7,87.2,185.6z",
      "M180.3,153.4c-0.5-0.3-1.1-0.1-1.4,0.4c-12.9,24.4-52.6,24.9-53,24.9c-0.6,0-1,0.5-1,1s0.4,1,1,1c0,0,0,0,0,0   c0.1,0,10.4-0.1,22.2-3.3c15.7-4.2,27-12.1,32.6-22.7C181,154.3,180.8,153.6,180.3,153.4z",
      "M108.8,179.3c-9.7,0-17-0.6-17.1-0.6c-0.6-0.1-1,0.4-1.1,0.9c0,0.6,0.4,1,0.9,1.1c0.1,0,7.5,0.6,17.2,0.6   c0,0,0,0,0,0c0.6,0,1-0.4,1-1C109.8,179.7,109.3,179.3,108.8,179.3z",
      "M119.4,179.2c-2,0.1-4,0.1-6,0.1c-0.6,0-1,0.5-1,1c0,0.5,0.5,1,1,1c0,0,0,0,0,0c2,0,4-0.1,6-0.1   c0.6,0,1-0.5,1-1C120.4,179.6,119.9,179.2,119.4,179.2z",
    ],
    chiliStem: [
      "M207.6,104.2c0.3-2.7-0.6-5.5-2.6-7.4c-1.7-1.6-3.9-2.4-6.1-2.3c-2.3,0.1-4.4,1-6,2.7  c-1.5,1.7-2.4,3.8-2.3,6.1c0,0,0,0,0,0c0,0,0,0,0,0c0,0,0,0.1,0,0.1c0,0,0,0.1,0,0.1c2.2,10.6-4.8,19.9-7.3,22.7  c-5.1-3.5-11.2-5.6-17.7-5.6c-3.6,0-7.1,0.6-10.4,1.8c-3.1,1.1-4.1,1.5-3.8,2.9c0.3,1.4,1.5,1.3,3.3,1.1c3.1-0.3,10.3-0.9,13.4,1.9  c1,0.9,1.5,2.1,1.5,3.7l0,1.7c0,4.6,0,6.9,1.6,8.5c1.5,1.5,3.9,1.6,8.4,1.6c0.4,0,0.8,0,1.3,0c8.1,0,11.3,7,12.6,12.9  c0.2,1.1,0.7,1.6,1.5,1.6c0.1,0,0.2,0,0.2,0c1.4-0.2,1.3-1.5,1.3-2.3c0-0.8-0.1-2.3-0.1-4.6c0-4.2-0.8-8.2-2.4-12  c-1-2.4-2.3-4.6-3.8-6.5C194.7,130.1,207.6,120.1,207.6,104.2z M193.2,148.1c-2.9-4.6-7.1-7.1-12.4-7.1c0,0,0,0,0,0  c-4,0-6.8,0-7.6-0.7c-0.7-0.7-0.7-2.9-0.7-6.4l0-1.7c0-2.4-0.8-4.4-2.4-5.9c-1.5-1.4-3.5-2.1-5.6-2.5c0.4,0,0.7,0,1.1,0  c8.4,0,16.1,3.7,21.3,9.9c0,0,0.1,0.1,0.1,0.1c1.7,2.1,3.2,4.4,4.3,7C192.2,143.2,192.9,145.6,193.2,148.1z M188.3,130.8  c-0.8-0.9-1.7-1.8-2.6-2.5c2.9-3.3,10.3-13.2,7.9-25c0-1.5,0.5-2.9,1.5-3.9c1-1.1,2.4-1.7,3.9-1.8c1.5-0.1,2.9,0.5,4,1.5  c1.4,1.3,2,3.1,1.7,4.9c0,0,0,0.1,0,0.1c0,0,0,0,0,0c0,0,0,0,0,0c0,0,0,0.1,0,0.1C204.5,118.9,192,128.3,188.3,130.8z",
    ],
    donutBody: [
      "M141.9,202.4c-10.3,0-20.8-2.2-30-8.3c-11.5-7.7-15.4-17.7-15.6-18.1c-0.2-0.5,0.1-1.1,0.6-1.3    c0.5-0.2,1.1,0.1,1.3,0.6c0,0.1,3.9,9.9,14.9,17.2c14.6,9.7,35.3,10.5,59.6,2.4c0.4-0.1,31.4-8.9,44.1-32.3    c6.2-11.5,7.1-24.7,2.5-39.2c-0.2-0.5,0.1-1.1,0.7-1.3c0.5-0.2,1.1,0.1,1.3,0.7c4.7,15,3.8,28.7-2.7,40.7    c-13.1,24.1-44.9,33.2-45.2,33.3C164.3,199.8,153.2,202.4,141.9,202.4z",
      "M133.6,145.3c-0.3,0-0.5-0.1-0.7-0.3c-0.4-0.4-0.4-1,0-1.4c3.8-3.6,9.1-6.8,15.1-9c9.1-3.3,18.4-3.8,24.2-1.2    c0.5,0.2,0.7,0.8,0.5,1.3c-0.2,0.5-0.8,0.7-1.3,0.5c-5.4-2.4-14.1-1.9-22.8,1.3c-5.7,2.1-10.9,5.1-14.4,8.6    C134.1,145.2,133.8,145.3,133.6,145.3z",
    ],
    donutGlaze: [
      "M130.9,190c-4.7,0-10.3-1.5-15.8-6.7l0,0c0,0-3.3-2.6-10.5-4.6c-1.2-0.2-19.6-4.4-17-29.8    c0-0.8,0.2-8.7,6.8-18.9c11.3-17.5,32.5-28,48.3-33.8c0.5-0.2,44.3-13.7,70.3,10.3c0.2,0.2,16.4,16.4,4.8,41.1    c-0.1,0.1-2,4.9-5.7,9.5c-5,6.2-10.7,8.9-16.7,8c-0.4-0.1-9.4-2-13.2,8.6c0,0.1-1,3.3-4.9,5.3c-4.3,2.2-10.2,2.1-17.5-0.3    c0,0-6.9-1.8-16.8,7.9c0,0-0.1,0.1-0.1,0.1C142.9,186.7,137.8,190,130.9,190z M171.1,94.3c-15.2,0-27.5,3.8-27.7,3.9    C90,117.6,89.6,148.7,89.6,149c0,0,0,0.1,0,0.1c-2.5,24.2,14.7,27.5,15.4,27.7c0,0,0.1,0,0.1,0c7.7,2.1,11.2,4.9,11.3,5    c11.9,11.3,24.1,4,25.3,3.3c10.8-10.5,18.4-8.4,18.8-8.3c6.7,2.2,12.3,2.4,16,0.5c3.1-1.6,4-4.1,4-4.2c4.4-12.4,15.3-9.9,15.4-9.9    c12.6,2,20-16.1,20.1-16.3c11-23.4-3.7-38.2-4.4-38.8C199.9,97.2,184.4,94.3,171.1,94.3z",
      "M142.3,146.8c-7.2,0-12.8-2.4-14.4-6.8c-2.6-7.3,6.2-16.9,20.1-22c6.5-2.4,13.1-3.3,18.6-2.7    c5.7,0.7,9.6,3,10.9,6.6l0,0c1.3,3.6-0.2,7.9-4.1,12.1c-3.8,4-9.5,7.5-16,9.9C152.1,145.9,146.8,146.8,142.3,146.8z M163.1,117.2    c-4.4,0-9.4,0.9-14.4,2.7c-12.4,4.5-21.1,13.4-18.9,19.4c2.2,6,14.5,7.3,27,2.7c6.2-2.3,11.6-5.6,15.2-9.4c3.4-3.6,4.7-7.2,3.7-10    c0,0,0,0,0,0c-1-2.8-4.3-4.7-9.3-5.3C165.3,117.2,164.2,117.2,163.1,117.2z",
    ],
    donutSprinkles: [
      "M119.2,139.2c-1.4,0-2.5-1.1-2.6-2.4l-0.6-11.7c-0.1-1.4,1-2.6,2.4-2.7c0.7,0,1.3,0.2,1.9,0.7    c0.5,0.5,0.8,1.1,0.9,1.8l0.6,11.7c0.1,1.4-1,2.6-2.4,2.7l0,0C119.3,139.2,119.2,139.2,119.2,139.2z M119.2,138.2L119.2,138.2    L119.2,138.2z M118.5,124.4C118.5,124.4,118.5,124.4,118.5,124.4c-0.2,0-0.3,0.1-0.4,0.2c-0.1,0.1-0.2,0.3-0.1,0.4l0.6,11.7    c0,0.3,0.3,0.5,0.6,0.5l0,0c0.3,0,0.6-0.3,0.5-0.6l-0.6-11.7c0-0.2-0.1-0.3-0.2-0.4C118.8,124.4,118.6,124.4,118.5,124.4z",
      "M126.9,165.6c-0.2,0-0.3,0-0.5,0c-0.7-0.1-1.3-0.5-1.6-1.1c0,0,0,0,0,0c-0.4-0.6-0.5-1.3-0.4-1.9    c0.1-0.7,0.5-1.3,1.1-1.6l9.6-6.6c1.2-0.8,2.8-0.5,3.6,0.7c0.8,1.2,0.5,2.8-0.7,3.6l-9.6,6.6C127.9,165.5,127.4,165.6,126.9,165.6    z M126.4,163.4c0.1,0.1,0.2,0.2,0.4,0.2c0.1,0,0.3,0,0.4-0.1l9.6-6.6c0.3-0.2,0.3-0.5,0.1-0.8c-0.2-0.3-0.5-0.3-0.8-0.1l-9.6,6.6    c-0.1,0.1-0.2,0.2-0.2,0.4C126.3,163.1,126.3,163.3,126.4,163.4z",
      "M191.4,138.4c-0.6,0-1.2-0.2-1.7-0.6c-0.5-0.4-0.8-1.1-0.9-1.8c0-0.7,0.2-1.4,0.6-1.9l7.6-8.8    c0.9-1.1,2.6-1.2,3.6-0.3c0.5,0.4,0.8,1.1,0.9,1.8s-0.2,1.4-0.6,1.9l-7.6,8.8c-0.4,0.5-1.1,0.8-1.8,0.9    C191.5,138.4,191.5,138.4,191.4,138.4z M199,126.4c-0.2,0-0.3,0.1-0.4,0.2l-7.6,8.8c-0.2,0.2-0.2,0.6,0.1,0.8c0,0,0,0,0,0    c0.1,0.1,0.3,0.1,0.4,0.1c0.2,0,0.3-0.1,0.4-0.2l7.6-8.8c0.1-0.1,0.1-0.3,0.1-0.4c0-0.2-0.1-0.3-0.2-0.4    C199.3,126.5,199.2,126.4,199,126.4z",
      "M165.2,162.5c-0.6,0-1.2-0.2-1.7-0.6c0,0,0,0,0,0c-1.1-0.9-1.2-2.6-0.3-3.6l7.6-8.8c0.4-0.5,1.1-0.8,1.8-0.9    c0.7-0.1,1.3,0.2,1.9,0.6c0.5,0.4,0.8,1.1,0.9,1.8s-0.2,1.4-0.6,1.9l-7.6,8.8C166.6,162.2,165.9,162.5,165.2,162.5z M164.8,160.3    c0.2,0.2,0.6,0.2,0.8-0.1l7.6-8.8c0.1-0.1,0.1-0.3,0.1-0.4c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.1-0.4-0.1    c-0.2,0-0.3,0.1-0.4,0.2l-7.6,8.8C164.5,159.7,164.6,160.1,164.8,160.3L164.8,160.3z",
      "M178.4,114.2c-0.6,0-1.2-0.2-1.7-0.6c0,0,0,0,0,0c-1.1-0.9-1.2-2.6-0.3-3.6l7.6-8.8c0.9-1.1,2.6-1.2,3.6-0.3    c1.1,0.9,1.2,2.6,0.3,3.6l-7.6,8.8C179.9,113.9,179.2,114.2,178.4,114.2z M178.1,112.1c0.2,0.2,0.6,0.2,0.8-0.1l7.6-8.8    c0.2-0.2,0.2-0.6-0.1-0.8c-0.2-0.2-0.6-0.2-0.8,0.1l-7.6,8.8C177.8,111.5,177.8,111.9,178.1,112.1L178.1,112.1z",
      "M144.8,114.2c-0.6,0-1.2-0.2-1.7-0.6c-0.5-0.4-0.8-1.1-0.9-1.8c0-0.7,0.2-1.4,0.6-1.9l7.6-8.8    c0.9-1.1,2.6-1.2,3.6-0.3c1.1,0.9,1.2,2.6,0.3,3.6l-7.6,8.8C146.2,113.9,145.5,114.2,144.8,114.2z M152.4,102.2    c-0.2,0-0.3,0.1-0.4,0.2l-7.6,8.8c-0.2,0.2-0.2,0.6,0.1,0.8c0.2,0.2,0.6,0.2,0.8-0.1l7.6-8.8c0.2-0.2,0.2-0.6-0.1-0.8    C152.7,102.3,152.6,102.2,152.4,102.2z",
    ],
    cakeBase: [
      "M200.1,193.7c-0.1,0-0.2,0-0.3,0l-97.9-26c-0.4-0.1-0.7-0.5-0.7-1V123c0-0.6,0.4-1,1-1s1,0.4,1,1v43    l95.9,25.4v-37.6c0-0.6,0.4-1,1-1s1,0.4,1,1v38.9c0,0.3-0.1,0.6-0.4,0.8C200.5,193.7,200.3,193.7,200.1,193.7z",
    ],
    cakeLayers: [
      "M200.1,167.7c-0.1,0-0.2,0-0.3,0l-97.9-28.2c-0.5-0.2-0.8-0.7-0.7-1.2c0.2-0.5,0.7-0.8,1.2-0.7l97.9,28.2    c0.5,0.2,0.8,0.7,0.7,1.2C200.9,167.5,200.5,167.7,200.1,167.7z",
      "M200.1,179.9c-0.1,0-0.2,0-0.3,0l-97.9-28.2c-0.5-0.2-0.8-0.7-0.7-1.2c0.2-0.5,0.7-0.8,1.2-0.7l97.9,28.2    c0.5,0.2,0.8,0.7,0.7,1.2C200.9,179.6,200.5,179.9,200.1,179.9z",
    ],
    cakeFrosting: [
      "M200.9,153.3l-22-39.2c2.2-1.2,3.6-3.5,3.6-6.1c0-3.8-3.1-6.9-6.9-6.9c-2.9,0-5.4,1.8-6.4,4.4   c-1.3-1.2-3-2-4.9-2c-2.9,0-5.4,1.8-6.4,4.3c-1.3-1.4-3.1-2.4-5.2-2.4c-2.7,0-5.1,1.6-6.2,3.9c-1.3-1.8-3.3-2.9-5.6-2.9   c-2.9,0-5.4,1.8-6.4,4.4c-1.3-1.5-3.1-2.4-5.2-2.4c-2.7,0-5.1,1.6-6.2,3.9c-1.3-1.8-3.3-2.9-5.6-2.9c-2.9,0-5.4,1.8-6.4,4.3   c-1.3-1.4-3.1-2.3-5.2-2.3c-3.8,0-6.9,3.1-6.9,6.9c0,3.8,3.1,6.9,6.9,6.9c0,0,0.1,0,0.1,0l93.8,29.6c0.1,0,0.2,0,0.3,0   c0.3,0,0.6-0.1,0.8-0.4C201.1,154.1,201.2,153.7,200.9,153.3z M100.9,118.3c0-2.7,2.2-4.9,4.9-4.9c2.7,0,4.9,2.2,4.9,4.9   c0,0.6,0.4,1,1,1s1-0.4,1-1c0-0.7-0.1-1.3-0.3-1.9c0,0,0-0.1,0-0.1c0-2.7,2.2-4.9,4.9-4.9c2.7,0,4.9,2.2,4.9,4.9c0,0.6,0.4,1,1,1   s1-0.4,1-1c0-0.3,0-0.5,0-0.8c0-0.1,0-0.1,0-0.2c0-2.7,2.2-4.9,4.9-4.9c2.7,0,4.9,2.2,4.9,4.9c0,0.6,0.4,1,1,1s1-0.4,1-1   c0-0.6-0.1-1.2-0.2-1.8c0-0.1,0-0.1,0-0.2c0-2.7,2.2-4.9,4.9-4.9c2.7,0,4.9,2.2,4.9,4.9c0,0.6,0.4,1,1,1s1-0.4,1-1   c0-0.3,0-0.5,0-0.8c0-0.1,0-0.1,0-0.2c0-2.7,2.2-4.9,4.9-4.9c2.7,0,4.9,2.2,4.9,4.9c0,0.6,0.4,1,1,1s1-0.4,1-1   c0-0.7-0.1-1.3-0.3-1.9c0,0,0,0,0-0.1c0-2.7,2.2-4.9,4.9-4.9c2,0,3.6,1.2,4.4,2.8c0,0.1,0.1,0.2,0.2,0.3c0.2,0.6,0.3,1.1,0.3,1.8   c0,0.6,0.4,1,1,1s1-0.4,1-1c0-0.9-0.2-1.8-0.5-2.6c0.1-2.6,2.3-4.7,4.9-4.7c2.7,0,4.9,2.2,4.9,4.9c0,2.2-1.5,4.1-3.5,4.7   l-71.1,10.5c0,0,0,0-0.1,0c-0.1,0-0.1,0-0.2,0C103.1,123.2,100.9,121,100.9,118.3z M110.7,124.6l65-9.6c0,0,0,0,0,0   c0.5,0,0.9,0,1.4-0.1l20.9,37.3L110.7,124.6z",
      "M179.3,132.5c-6.4-4.1-11.6-1.9-13.7-0.6c-5.6-8.2-15.3-5-15.4-4.9c-0.5,0.2-0.8,0.8-0.6,1.3   c0.2,0.5,0.7,0.8,1.3,0.6c0.4-0.1,8.9-3,13.6,5c0.2,0.3,0.4,0.4,0.7,0.5c0.3,0,0.6,0,0.8-0.2c0,0,5.2-4.5,12.2,0.1   c0.2,0.1,0.4,0.2,0.5,0.2c0.3,0,0.6-0.2,0.8-0.5C179.9,133.4,179.8,132.8,179.3,132.5z",
    ],
    cakeCherry: [
      "M167.2,132.5c-4.6,0-8.3-3.7-8.3-8.3c0-4.6,3.7-8.3,8.3-8.3c1.1,0,2.2,0.2,3.2,0.7c3.1,1.3,5.1,4.3,5.1,7.6    C175.5,128.8,171.8,132.5,167.2,132.5z M167.2,117.9c-3.5,0-6.3,2.8-6.3,6.3c0,3.5,2.8,6.3,6.3,6.3c3.5,0,6.3-2.8,6.3-6.3    c0-2.5-1.5-4.8-3.8-5.8C168.9,118.1,168,117.9,167.2,117.9z",
    ],
  };

  const getRowCol = (cell) => [Math.floor(cell / columns), cell % columns];

  // Observation.
  const { geese, food } = environment.steps[step][0].observation;

  // Organize the geese positions for rendering.
  const geesePositions = {};
  geese.forEach((goose, index) => {
    const active = goose.length > 0;
    let s = step;
    if (!active) {
      // Find the last step where the goose existed.
      while (s >= 0 && !goose.length) {
        goose = environment.steps[--s][0].observation.geese[index];
      }
    }
    goose.forEach((pos, posIndex) => {
      if (!active && pos in geesePositions) return;
      const [r, c] = getRowCol(pos);
      const [br, bc] = posIndex === 0 ? [r, c] : getRowCol(goose[posIndex - 1]);
      const [ar, ac] =
        posIndex === goose.length - 1 ? [r, c] : getRowCol(goose[posIndex + 1]);
      geesePositions[pos] = {
        index,
        head: posIndex === 0,
        tail: posIndex === goose.length - 1,
        east: bc > c || ac > c,
        west: bc < c || ac < c,
        south: br > r || ar > r,
        north: br < r || ar < r,
        active,
      };
    });
  });

  // Common Dimensions.
  const unit = 8;
  const minCanvasSize = Math.min(height, width);
  const minOffset = minCanvasSize > 400 ? 30 : unit / 2;
  const cellSize = Math.min(
    (width - minOffset * 2) / columns,
    (height - minOffset * 2) / rows
  );
  const cellInset = 0.9;
  const cellOffset = (cellSize * (1 - cellInset)) / 2;
  const xOffset = Math.max(0, (width - cellSize * columns) / 2);
  const yOffset = Math.max(0, (height - cellSize * rows) / 2);

  // Helper Functions.
  const getCanvas = (id, options = {}) => {
    let canvas = document.querySelector(`#${id}`);
    if (!canvas) {
      canvas = document.createElement("canvas");
      canvas.id = id;
      canvas.width = options.width || width;
      canvas.height = options.height || height;
      canvas.style.cssText = `
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%; 
        `;
      parent.appendChild(canvas);
    }
    return [canvas, canvas.getContext("2d")];
  };

  const drawImage = (canvas, ctx, sRow, sCol, dRow, dCol, angle = 0, flip) => {
    const middle = cellSize / 2;
    ctx.save();
    ctx.translate(xOffset + cellSize * dCol, yOffset + cellSize * dRow);
    if (angle) ctx.translate(middle, middle);
    if (flip) ctx.scale(-1, 1);
    if (angle) {
      ctx.rotate((Math.PI * angle) / 180);
      ctx.translate(-middle, -middle);
    }
    ctx.drawImage(
      canvas,
      sCol * cellSize,
      sRow * cellSize,
      cellSize,
      cellSize,
      0,
      0,
      cellSize,
      cellSize
    );
    ctx.restore();
  };

  // First time setup
  if (!parent.querySelector("#buffer")) {
    if (interactive) {
      const keyCodes = { 37: "W", 38: "N", 39: "E", 40: "S" };
      document.addEventListener("keydown", (evt) => {
        if (
          !isInteractive() ||
          evt.ctrlKey ||
          evt.shiftKey ||
          evt.altKey ||
          evt.metaKey
        )
          return;
        if (evt.keyCode in keyCodes) {
          act(keyCodes[evt.keyCode]);
          evt.preventDefault();
          return false;
        }
      });
    }

    const c = getCanvas("buffer", {
      width: cellSize * (colors.players.length + 1),
      height: cellSize * 8,
    })[1];

    const drawPath = (paths, col, row, color = "#000") => {
      c.save();
      c.translate(col * cellSize + cellOffset, row * cellSize + cellOffset);
      c.scale((cellSize * cellInset) / 300, (cellSize * cellInset) / 300);
      c.strokeStyle = color;
      c.shadowColor = color;
      c.lineWidth = 2;
      c.shadowBlur = 10;
      paths.forEach((p) => c.stroke(new Path2D(p)));
      c.restore();
    };

    // Draw player geese (1 player per column).
    colors.players.forEach((color, index) => {
      drawPath(paths.head, index, 0, color);
      drawPath(paths.headBeak, index, 0, colors.orange);
      drawPath(paths.neckNS, index, 1, color);
      drawPath(paths.neckNE, index, 2, color);
      drawPath(paths.body, index, 3, color);
      drawPath(paths.bodyBeak, index, 3, colors.orange);
      drawPath(paths.bodyS, index, 4, color);
      drawPath(paths.bodyW, index, 5, color);
      drawPath(paths.bodyE, index, 6, color);
      drawPath(paths.bodyN, index, 7, color);
    });

    // Draw Food.
    const foodCol = colors.players.length;
    drawPath(paths.pizzaCrust, foodCol, 0, colors.orange);
    drawPath(paths.pizzaPepperoni, foodCol, 0, colors.red);
    drawPath(paths.cakeBase, foodCol, 1, colors.purple);
    drawPath(paths.cakeLayers, foodCol, 1, colors.orange);
    drawPath(paths.cakeFrosting, foodCol, 1, colors.blue);
    drawPath(paths.cakeCherry, foodCol, 1, colors.red);
    drawPath(paths.donutBody, foodCol, 2, colors.orange);
    drawPath(paths.donutGlaze, foodCol, 2, colors.purple);
    drawPath(paths.donutSprinkles, foodCol, 2, colors.blue);
    drawPath(paths.chiliBody, foodCol, 3, colors.red);
    drawPath(paths.chiliStem, foodCol, 3, colors.green);
  }

  // Canvas setup and reset.
  const [bufferCanvas] = getCanvas("buffer");
  const [canvas, c] = getCanvas("battlegeese");
  c.fillStyle = "#000B2A";
  c.fillRect(0, 0, canvas.width, canvas.height);

  // Render the board.
  for (let i = 0; i < rows * columns; i++) {
    const [row, col] = getRowCol(i);

    // Draw background tile.
    c.save();
    c.translate(xOffset + cellSize * col, yOffset + cellSize * row);
    c.strokeStyle = "#0361B2";
    c.strokeRect(
      cellOffset,
      cellOffset,
      cellSize - cellOffset * 2,
      cellSize - cellOffset * 2
    );
    c.restore();

    const drawPiece = (sRow, sCol, angle, flip) =>
      drawImage(bufferCanvas, c, sRow, sCol, row, col, angle, flip);

    // Draw Pieces.
    if (i in geesePositions) {
      const {
        active,
        index,
        head,
        tail,
        north,
        south,
        west,
        east,
      } = geesePositions[i];

      if (!active) c.globalAlpha = 0.15;
      if (head && tail) {
        // Full Goose.
        drawPiece(3, index);
      } else if (head) {
        // Goose Head.
        drawPiece(0, index, north ? 180 : east || west ? 90 : 0, east);
      } else if (tail) {
        // Goose Body.
        drawPiece(north ? 7 : east ? 6 : west ? 5 : 4, index);
      } else if ((north && south) || (west && east)) {
        // Straight Neck.
        drawPiece(1, index, east && west ? 90 : 0);
      } else {
        // Curved Neck.
        drawPiece(
          2,
          index,
          east && south ? 90 : west && south ? 180 : west && north ? 270 : 0
        );
      }
      if (!active) c.globalAlpha = 1;

      // Draw Food.
    } else if (food.includes(i)) {
      drawPiece(i % 4, colors.players.length);
    }
  }

  // Upgrade the legend.
  if (agents.length && (!agents[0].color || !agents[0].image)) {
    agents.forEach((agent) => {
      const [canvas, ctx] = getCanvas(`agent_${agent.index}`, {
        width: 100,
        height: 100,
      });
      canvas.style.marginLeft = "10000px";
      ctx.drawImage(
        bufferCanvas,
        cellSize * agent.index,
        cellSize * 3,
        cellSize,
        cellSize,
        0,
        0,
        100,
        100
      );
      agent.image = canvas.toDataURL();
      parent.removeChild(canvas);
      agent.color = colors.players[agent.index];
    });
    update({ agents });
  }
}
