from ama_xiv_combat_sim.example_rotations.specific_rotations import SpecificRotations


all_drg_rotations = SpecificRotations()

ALL_DRG_ROTATIONS = {
    "DRG": {
        90: {
            "stats": {
                "wd": 132,
                "main_stat": 3379,
                "det_stat": 1818,
                "crit_stat": 2567,
                "dh_stat": 1818,
                "speed_stat": 400,
                "job_class": "DRG",
            },
            "skills": (
                "True Thrust",
                "Grade 8 Tincture",
                "Disembowel",
                "Lance Charge",
                "Dragon Sight",
                "Chaotic Spring",
                "Battle Litany",
                "Wheeling Thrust",
                "Geirskogul",
                "Life Surge",
                "Fang and Claw",
                "High Jump",
                "Mirage Dive",
                "Raiden Thrust",
                "Dragonfire Dive",
                "Vorpal Thrust",
                "Spineshatter Dive",
                "Life Surge",
                "Heavens' Thrust",
                "Fang and Claw",
                "Wheeling Thrust",
                "Raiden Thrust",
                "Wyrmwind Thrust",
                "Disembowel",
                "Chaotic Spring",
                "Wheeling Thrust",
            ),
            "start_version": "6.55",
            "end_version": "6.55",
        },
        100: {
            "stats": {
                "wd": 146,
                "main_stat": 4883,
                "det_stat": 2150,
                "crit_stat": 3120,
                "dh_stat": 2132,
                "speed_stat": 420,
                "job_class": "DRG",
            },
            "skills": (
                "True Thrust",
                "Spiral Blow",
                "Lance Charge",
                "Grade 2 Gemdraught",
                "Chaotic Spring",
                "Battle Litany",
                "Geirskogul",
                "Wheeling Thrust",
                "High Jump",
                "Life Surge",
                "Drakesbane",
                "Dragonfire Dive",
                "Nastrond",
                "Raiden Thrust",
                "Stardiver",
                "Lance Barrage",
                "Starcross",
                "Life Surge",
                "Heavens' Thrust",
                "Nastrond",
                "Rise of the Dragon",
                "Fang and Claw",
                "Nastrond",
                "Mirage Dive",
                "Drakesbane",
                "Raiden Thrust",
                "Wyrmwind Thrust",
                "Spiral Blow",
            ),
            "start_version": "7.05",
        },
    },
}

for k, v in ALL_DRG_ROTATIONS.items():
    all_drg_rotations.add_rotation_data(k, v)
