import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelConditionConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Access Level to add this condition to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#access_level AccessContextManagerAccessLevelCondition#access_level}
     *
     * @stability stable
     */
    readonly accessLevel: string;
    /**
     * A list of CIDR block IP subnetwork specification.
     *
     * May be IPv4
     * or IPv6.
     * Note that for a CIDR IP address block, the specified IP address
     * portion must be properly truncated (i.e. all the host bits must
     * be zero) or the input is considered malformed. For example,
     * "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
     * for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
     * is not. The originating IP of a request must be in one of the
     * listed subnets in order for this Condition to be true.
     * If empty, all IP addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#ip_subnetworks AccessContextManagerAccessLevelCondition#ip_subnetworks}
     *
     * @stability stable
     */
    readonly ipSubnetworks?: string[];
    /**
     * An allowed list of members (users, service accounts). Using groups is not supported yet.
     *
     * The signed-in user originating the request must be a part of one
     * of the provided members. If not specified, a request may come
     * from any user (logged in/not logged in, not present in any
     * groups, etc.).
     * Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#members AccessContextManagerAccessLevelCondition#members}
     *
     * @stability stable
     */
    readonly members?: string[];
    /**
     * Whether to negate the Condition.
     *
     * If true, the Condition becomes
     * a NAND over its non-empty fields, each field must be false for
     * the Condition overall to be satisfied. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#negate AccessContextManagerAccessLevelCondition#negate}
     *
     * @stability stable
     */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
     * The request must originate from one of the provided countries/regions. Format: A valid ISO 3166-1 alpha-2 code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#regions AccessContextManagerAccessLevelCondition#regions}
     *
     * @stability stable
     */
    readonly regions?: string[];
    /**
     * A list of other access levels defined in the same Policy, referenced by resource name.
     *
     * Referencing an AccessLevel which
     * does not exist is an error. All access levels listed must be
     * granted for the Condition to be true.
     * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#required_access_levels AccessContextManagerAccessLevelCondition#required_access_levels}
     *
     * @stability stable
     */
    readonly requiredAccessLevels?: string[];
    /**
     * device_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#device_policy AccessContextManagerAccessLevelCondition#device_policy}
     *
     * @stability stable
     */
    readonly devicePolicy?: AccessContextManagerAccessLevelConditionDevicePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#timeouts AccessContextManagerAccessLevelCondition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerAccessLevelConditionTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelConditionDevicePolicyOsConstraints {
    /**
     * The minimum allowed OS version.
     *
     * If not set, any version
     * of this OS satisfies the constraint.
     * Format: "major.minor.patch" such as "10.5.301", "9.2.1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#minimum_version AccessContextManagerAccessLevelCondition#minimum_version}
     *
     * @stability stable
     */
    readonly minimumVersion?: string;
    /**
     * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#os_type AccessContextManagerAccessLevelCondition#os_type}
     *
     * @stability stable
     */
    readonly osType: string;
}
export declare function accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform(struct?: AccessContextManagerAccessLevelConditionDevicePolicyOsConstraints | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelConditionDevicePolicy {
    /**
     * A list of allowed device management levels. An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#allowed_device_management_levels AccessContextManagerAccessLevelCondition#allowed_device_management_levels}
     *
     * @stability stable
     */
    readonly allowedDeviceManagementLevels?: string[];
    /**
     * A list of allowed encryptions statuses. An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#allowed_encryption_statuses AccessContextManagerAccessLevelCondition#allowed_encryption_statuses}
     *
     * @stability stable
     */
    readonly allowedEncryptionStatuses?: string[];
    /**
     * Whether the device needs to be approved by the customer admin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#require_admin_approval AccessContextManagerAccessLevelCondition#require_admin_approval}
     *
     * @stability stable
     */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
     * Whether the device needs to be corp owned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#require_corp_owned AccessContextManagerAccessLevelCondition#require_corp_owned}
     *
     * @stability stable
     */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
     * Whether or not screenlock is required for the DevicePolicy to be true. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#require_screen_lock AccessContextManagerAccessLevelCondition#require_screen_lock}
     *
     * @stability stable
     */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
     * os_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#os_constraints AccessContextManagerAccessLevelCondition#os_constraints}
     *
     * @stability stable
     */
    readonly osConstraints?: AccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelConditionDevicePolicyToTerraform(struct?: AccessContextManagerAccessLevelConditionDevicePolicyOutputReference | AccessContextManagerAccessLevelConditionDevicePolicy): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelConditionDevicePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelConditionDevicePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelConditionDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    /**
     * @stability stable
     */
    get allowedDeviceManagementLevels(): string[];
    /**
     * @stability stable
     */
    set allowedDeviceManagementLevels(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedDeviceManagementLevels(): void;
    /**
     * @stability stable
     */
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    /**
     * @stability stable
     */
    get allowedEncryptionStatuses(): string[];
    /**
     * @stability stable
     */
    set allowedEncryptionStatuses(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedEncryptionStatuses(): void;
    /**
     * @stability stable
     */
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    /**
     * @stability stable
     */
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireAdminApproval(): void;
    /**
     * @stability stable
     */
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    /**
     * @stability stable
     */
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireCorpOwned(): void;
    /**
     * @stability stable
     */
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    /**
     * @stability stable
     */
    get requireScreenLock(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireScreenLock(): void;
    /**
     * @stability stable
     */
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints?;
    /**
     * @stability stable
     */
    get osConstraints(): AccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set osConstraints(value: AccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOsConstraints(): void;
    /**
     * @stability stable
     */
    get osConstraintsInput(): cdktf.IResolvable | AccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelConditionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#create AccessContextManagerAccessLevelCondition#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition#delete AccessContextManagerAccessLevelCondition#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function accessContextManagerAccessLevelConditionTimeoutsToTerraform(struct?: AccessContextManagerAccessLevelConditionTimeoutsOutputReference | AccessContextManagerAccessLevelConditionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelConditionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelConditionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelConditionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition google_access_context_manager_access_level_condition}.
 *
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelCondition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition google_access_context_manager_access_level_condition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessLevelConditionConfig);
    private _accessLevel?;
    /**
     * @stability stable
     */
    get accessLevel(): string;
    /**
     * @stability stable
     */
    set accessLevel(value: string);
    /**
     * @stability stable
     */
    get accessLevelInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipSubnetworks?;
    /**
     * @stability stable
     */
    get ipSubnetworks(): string[];
    /**
     * @stability stable
     */
    set ipSubnetworks(value: string[]);
    /**
     * @stability stable
     */
    resetIpSubnetworks(): void;
    /**
     * @stability stable
     */
    get ipSubnetworksInput(): string[] | undefined;
    private _members?;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    resetMembers(): void;
    /**
     * @stability stable
     */
    get membersInput(): string[] | undefined;
    private _negate?;
    /**
     * @stability stable
     */
    get negate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegate(): void;
    /**
     * @stability stable
     */
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _regions?;
    /**
     * @stability stable
     */
    get regions(): string[];
    /**
     * @stability stable
     */
    set regions(value: string[]);
    /**
     * @stability stable
     */
    resetRegions(): void;
    /**
     * @stability stable
     */
    get regionsInput(): string[] | undefined;
    private _requiredAccessLevels?;
    /**
     * @stability stable
     */
    get requiredAccessLevels(): string[];
    /**
     * @stability stable
     */
    set requiredAccessLevels(value: string[]);
    /**
     * @stability stable
     */
    resetRequiredAccessLevels(): void;
    /**
     * @stability stable
     */
    get requiredAccessLevelsInput(): string[] | undefined;
    private _devicePolicy;
    /**
     * @stability stable
     */
    get devicePolicy(): AccessContextManagerAccessLevelConditionDevicePolicyOutputReference;
    /**
     * @stability stable
     */
    putDevicePolicy(value: AccessContextManagerAccessLevelConditionDevicePolicy): void;
    /**
     * @stability stable
     */
    resetDevicePolicy(): void;
    /**
     * @stability stable
     */
    get devicePolicyInput(): AccessContextManagerAccessLevelConditionDevicePolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerAccessLevelConditionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AccessContextManagerAccessLevelConditionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerAccessLevelConditionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
