import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudSchedulerJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * The deadline for job attempts.
     *
     * If the request handler does not respond by this deadline then the request is
     * cancelled and the attempt is marked as a DEADLINE_EXCEEDED failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according to the RetryConfig.
     * The allowed duration for this deadline is:
     * For HTTP targets, between 15 seconds and 30 minutes.
     * For App Engine HTTP targets, between 15 seconds and 24 hours.
     * **Note**: For PubSub targets, this field is ignored - setting it will introduce an unresolvable diff.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#attempt_deadline CloudSchedulerJob#attempt_deadline}
     *
     * @stability stable
     */
    readonly attemptDeadline?: string;
    /**
     * A human-readable description for the job.  This string must not contain more than 500 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#description CloudSchedulerJob#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#name CloudSchedulerJob#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#project CloudSchedulerJob#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the scheduler job resides. If it is not provided, Terraform will use the provider default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#region CloudSchedulerJob#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Describes the schedule on which the job will be executed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#schedule CloudSchedulerJob#schedule}
     *
     * @stability stable
     */
    readonly schedule?: string;
    /**
     * Specifies the time zone to be used in interpreting schedule.
     *
     * The value of this field must be a time zone name from the tz database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#time_zone CloudSchedulerJob#time_zone}
     *
     * @stability stable
     */
    readonly timeZone?: string;
    /**
     * app_engine_http_target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#app_engine_http_target CloudSchedulerJob#app_engine_http_target}
     *
     * @stability stable
     */
    readonly appEngineHttpTarget?: CloudSchedulerJobAppEngineHttpTarget;
    /**
     * http_target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#http_target CloudSchedulerJob#http_target}
     *
     * @stability stable
     */
    readonly httpTarget?: CloudSchedulerJobHttpTarget;
    /**
     * pubsub_target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#pubsub_target CloudSchedulerJob#pubsub_target}
     *
     * @stability stable
     */
    readonly pubsubTarget?: CloudSchedulerJobPubsubTarget;
    /**
     * retry_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#retry_config CloudSchedulerJob#retry_config}
     *
     * @stability stable
     */
    readonly retryConfig?: CloudSchedulerJobRetryConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#timeouts CloudSchedulerJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudSchedulerJobTimeouts;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobAppEngineHttpTargetAppEngineRouting {
    /**
     * App instance. By default, the job is sent to an instance which is available when the job is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#instance CloudSchedulerJob#instance}
     *
     * @stability stable
     */
    readonly instance?: string;
    /**
     * App service.
     *
     * By default, the job is sent to the service which is the default service when the job is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#service CloudSchedulerJob#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * App version.
     *
     * By default, the job is sent to the version which is the default version when the job is attempted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#version CloudSchedulerJob#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
export declare function cloudSchedulerJobAppEngineHttpTargetAppEngineRoutingToTerraform(struct?: CloudSchedulerJobAppEngineHttpTargetAppEngineRoutingOutputReference | CloudSchedulerJobAppEngineHttpTargetAppEngineRouting): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobAppEngineHttpTargetAppEngineRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobAppEngineHttpTargetAppEngineRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobAppEngineHttpTargetAppEngineRouting | undefined);
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    resetInstance(): void;
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    resetService(): void;
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobAppEngineHttpTarget {
    /**
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST or PUT.
     * It will result in invalid argument error to set a body on a job with an incompatible HttpMethod.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#body CloudSchedulerJob#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the job is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#headers CloudSchedulerJob#headers}
     *
     * @stability stable
     */
    readonly headers?: {
        [key: string]: string;
    };
    /**
     * Which HTTP method to use for the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#http_method CloudSchedulerJob#http_method}
     *
     * @stability stable
     */
    readonly httpMethod?: string;
    /**
     * The relative URI.
     *
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and \# fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#relative_uri CloudSchedulerJob#relative_uri}
     *
     * @stability stable
     */
    readonly relativeUri: string;
    /**
     * app_engine_routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#app_engine_routing CloudSchedulerJob#app_engine_routing}
     *
     * @stability stable
     */
    readonly appEngineRouting?: CloudSchedulerJobAppEngineHttpTargetAppEngineRouting;
}
export declare function cloudSchedulerJobAppEngineHttpTargetToTerraform(struct?: CloudSchedulerJobAppEngineHttpTargetOutputReference | CloudSchedulerJobAppEngineHttpTarget): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobAppEngineHttpTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobAppEngineHttpTarget | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobAppEngineHttpTarget | undefined);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set headers(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    /**
     * @stability stable
     */
    get httpMethod(): string;
    /**
     * @stability stable
     */
    set httpMethod(value: string);
    /**
     * @stability stable
     */
    resetHttpMethod(): void;
    /**
     * @stability stable
     */
    get httpMethodInput(): string | undefined;
    private _relativeUri?;
    /**
     * @stability stable
     */
    get relativeUri(): string;
    /**
     * @stability stable
     */
    set relativeUri(value: string);
    /**
     * @stability stable
     */
    get relativeUriInput(): string | undefined;
    private _appEngineRouting;
    /**
     * @stability stable
     */
    get appEngineRouting(): CloudSchedulerJobAppEngineHttpTargetAppEngineRoutingOutputReference;
    /**
     * @stability stable
     */
    putAppEngineRouting(value: CloudSchedulerJobAppEngineHttpTargetAppEngineRouting): void;
    /**
     * @stability stable
     */
    resetAppEngineRouting(): void;
    /**
     * @stability stable
     */
    get appEngineRoutingInput(): CloudSchedulerJobAppEngineHttpTargetAppEngineRouting | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobHttpTargetOauthToken {
    /**
     * OAuth scope to be used for generating OAuth access token. If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#scope CloudSchedulerJob#scope}
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Service account email to be used for generating OAuth token.
     *
     * The service account must be within the same project as the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#service_account_email CloudSchedulerJob#service_account_email}
     *
     * @stability stable
     */
    readonly serviceAccountEmail: string;
}
export declare function cloudSchedulerJobHttpTargetOauthTokenToTerraform(struct?: CloudSchedulerJobHttpTargetOauthTokenOutputReference | CloudSchedulerJobHttpTargetOauthToken): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobHttpTargetOauthTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobHttpTargetOauthToken | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobHttpTargetOauthToken | undefined);
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _serviceAccountEmail?;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string;
    /**
     * @stability stable
     */
    set serviceAccountEmail(value: string);
    /**
     * @stability stable
     */
    get serviceAccountEmailInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobHttpTargetOidcToken {
    /**
     * Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#audience CloudSchedulerJob#audience}
     *
     * @stability stable
     */
    readonly audience?: string;
    /**
     * Service account email to be used for generating OAuth token.
     *
     * The service account must be within the same project as the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#service_account_email CloudSchedulerJob#service_account_email}
     *
     * @stability stable
     */
    readonly serviceAccountEmail: string;
}
export declare function cloudSchedulerJobHttpTargetOidcTokenToTerraform(struct?: CloudSchedulerJobHttpTargetOidcTokenOutputReference | CloudSchedulerJobHttpTargetOidcToken): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobHttpTargetOidcTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobHttpTargetOidcToken | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobHttpTargetOidcToken | undefined);
    private _audience?;
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    set audience(value: string);
    /**
     * @stability stable
     */
    resetAudience(): void;
    /**
     * @stability stable
     */
    get audienceInput(): string | undefined;
    private _serviceAccountEmail?;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string;
    /**
     * @stability stable
     */
    set serviceAccountEmail(value: string);
    /**
     * @stability stable
     */
    get serviceAccountEmailInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobHttpTarget {
    /**
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST, PUT, or PATCH.
     * It is an error to set body on a job with an incompatible HttpMethod.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#body CloudSchedulerJob#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * This map contains the header field names and values.
     *
     * Repeated headers are not supported, but a header value can contain commas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#headers CloudSchedulerJob#headers}
     *
     * @stability stable
     */
    readonly headers?: {
        [key: string]: string;
    };
    /**
     * Which HTTP method to use for the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#http_method CloudSchedulerJob#http_method}
     *
     * @stability stable
     */
    readonly httpMethod?: string;
    /**
     * The full URI path that the request will be sent to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#uri CloudSchedulerJob#uri}
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * oauth_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#oauth_token CloudSchedulerJob#oauth_token}
     *
     * @stability stable
     */
    readonly oauthToken?: CloudSchedulerJobHttpTargetOauthToken;
    /**
     * oidc_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#oidc_token CloudSchedulerJob#oidc_token}
     *
     * @stability stable
     */
    readonly oidcToken?: CloudSchedulerJobHttpTargetOidcToken;
}
export declare function cloudSchedulerJobHttpTargetToTerraform(struct?: CloudSchedulerJobHttpTargetOutputReference | CloudSchedulerJobHttpTarget): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobHttpTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobHttpTarget | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobHttpTarget | undefined);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set headers(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    /**
     * @stability stable
     */
    get httpMethod(): string;
    /**
     * @stability stable
     */
    set httpMethod(value: string);
    /**
     * @stability stable
     */
    resetHttpMethod(): void;
    /**
     * @stability stable
     */
    get httpMethodInput(): string | undefined;
    private _uri?;
    /**
     * @stability stable
     */
    get uri(): string;
    /**
     * @stability stable
     */
    set uri(value: string);
    /**
     * @stability stable
     */
    get uriInput(): string | undefined;
    private _oauthToken;
    /**
     * @stability stable
     */
    get oauthToken(): CloudSchedulerJobHttpTargetOauthTokenOutputReference;
    /**
     * @stability stable
     */
    putOauthToken(value: CloudSchedulerJobHttpTargetOauthToken): void;
    /**
     * @stability stable
     */
    resetOauthToken(): void;
    /**
     * @stability stable
     */
    get oauthTokenInput(): CloudSchedulerJobHttpTargetOauthToken | undefined;
    private _oidcToken;
    /**
     * @stability stable
     */
    get oidcToken(): CloudSchedulerJobHttpTargetOidcTokenOutputReference;
    /**
     * @stability stable
     */
    putOidcToken(value: CloudSchedulerJobHttpTargetOidcToken): void;
    /**
     * @stability stable
     */
    resetOidcToken(): void;
    /**
     * @stability stable
     */
    get oidcTokenInput(): CloudSchedulerJobHttpTargetOidcToken | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobPubsubTarget {
    /**
     * Attributes for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#attributes CloudSchedulerJob#attributes}
     *
     * @stability stable
     */
    readonly attributes?: {
        [key: string]: string;
    };
    /**
     * The message payload for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#data CloudSchedulerJob#data}
     *
     * @stability stable
     */
    readonly data?: string;
    /**
     * The full resource name for the Cloud Pub/Sub topic to which messages will be published when a job is delivered.
     *
     * ~>**NOTE:**
     * The topic name must be in the same format as required by PubSub's
     * PublishRequest.name, e.g. 'projects/my-project/topics/my-topic'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#topic_name CloudSchedulerJob#topic_name}
     *
     * @stability stable
     */
    readonly topicName: string;
}
export declare function cloudSchedulerJobPubsubTargetToTerraform(struct?: CloudSchedulerJobPubsubTargetOutputReference | CloudSchedulerJobPubsubTarget): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobPubsubTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobPubsubTarget | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobPubsubTarget | undefined);
    private _attributes?;
    /**
     * @stability stable
     */
    get attributes(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set attributes(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAttributes(): void;
    /**
     * @stability stable
     */
    get attributesInput(): {
        [key: string]: string;
    } | undefined;
    private _data?;
    /**
     * @stability stable
     */
    get data(): string;
    /**
     * @stability stable
     */
    set data(value: string);
    /**
     * @stability stable
     */
    resetData(): void;
    /**
     * @stability stable
     */
    get dataInput(): string | undefined;
    private _topicName?;
    /**
     * @stability stable
     */
    get topicName(): string;
    /**
     * @stability stable
     */
    set topicName(value: string);
    /**
     * @stability stable
     */
    get topicNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobRetryConfig {
    /**
     * The maximum amount of time to wait before retrying a job after it fails.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#max_backoff_duration CloudSchedulerJob#max_backoff_duration}
     *
     * @stability stable
     */
    readonly maxBackoffDuration?: string;
    /**
     * The time between retries will double maxDoublings times.
     *
     * A job's retry interval starts at minBackoffDuration,
     * then doubles maxDoublings times, then increases linearly,
     * and finally retries retries at intervals of maxBackoffDuration up to retryCount times.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#max_doublings CloudSchedulerJob#max_doublings}
     *
     * @stability stable
     */
    readonly maxDoublings?: number;
    /**
     * The time limit for retrying a failed job, measured from time when an execution was first attempted.
     *
     * If specified with retryCount, the job will be retried until both limits are reached.
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#max_retry_duration CloudSchedulerJob#max_retry_duration}
     *
     * @stability stable
     */
    readonly maxRetryDuration?: string;
    /**
     * The minimum amount of time to wait before retrying a job after it fails.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#min_backoff_duration CloudSchedulerJob#min_backoff_duration}
     *
     * @stability stable
     */
    readonly minBackoffDuration?: string;
    /**
     * The number of attempts that the system will make to run a  job using the exponential backoff procedure described by maxDoublings.
     *
     * Values greater than 5 and negative values are not allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#retry_count CloudSchedulerJob#retry_count}
     *
     * @stability stable
     */
    readonly retryCount?: number;
}
export declare function cloudSchedulerJobRetryConfigToTerraform(struct?: CloudSchedulerJobRetryConfigOutputReference | CloudSchedulerJobRetryConfig): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobRetryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobRetryConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobRetryConfig | undefined);
    private _maxBackoffDuration?;
    /**
     * @stability stable
     */
    get maxBackoffDuration(): string;
    /**
     * @stability stable
     */
    set maxBackoffDuration(value: string);
    /**
     * @stability stable
     */
    resetMaxBackoffDuration(): void;
    /**
     * @stability stable
     */
    get maxBackoffDurationInput(): string | undefined;
    private _maxDoublings?;
    /**
     * @stability stable
     */
    get maxDoublings(): number;
    /**
     * @stability stable
     */
    set maxDoublings(value: number);
    /**
     * @stability stable
     */
    resetMaxDoublings(): void;
    /**
     * @stability stable
     */
    get maxDoublingsInput(): number | undefined;
    private _maxRetryDuration?;
    /**
     * @stability stable
     */
    get maxRetryDuration(): string;
    /**
     * @stability stable
     */
    set maxRetryDuration(value: string);
    /**
     * @stability stable
     */
    resetMaxRetryDuration(): void;
    /**
     * @stability stable
     */
    get maxRetryDurationInput(): string | undefined;
    private _minBackoffDuration?;
    /**
     * @stability stable
     */
    get minBackoffDuration(): string;
    /**
     * @stability stable
     */
    set minBackoffDuration(value: string);
    /**
     * @stability stable
     */
    resetMinBackoffDuration(): void;
    /**
     * @stability stable
     */
    get minBackoffDurationInput(): string | undefined;
    private _retryCount?;
    /**
     * @stability stable
     */
    get retryCount(): number;
    /**
     * @stability stable
     */
    set retryCount(value: number);
    /**
     * @stability stable
     */
    resetRetryCount(): void;
    /**
     * @stability stable
     */
    get retryCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CloudSchedulerJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#create CloudSchedulerJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#delete CloudSchedulerJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job#update CloudSchedulerJob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudSchedulerJobTimeoutsToTerraform(struct?: CloudSchedulerJobTimeoutsOutputReference | CloudSchedulerJobTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class CloudSchedulerJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudSchedulerJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudSchedulerJobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job google_cloud_scheduler_job}.
 *
 * @stability stable
 */
export declare class CloudSchedulerJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_scheduler_job google_cloud_scheduler_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudSchedulerJobConfig);
    private _attemptDeadline?;
    /**
     * @stability stable
     */
    get attemptDeadline(): string;
    /**
     * @stability stable
     */
    set attemptDeadline(value: string);
    /**
     * @stability stable
     */
    resetAttemptDeadline(): void;
    /**
     * @stability stable
     */
    get attemptDeadlineInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): string;
    /**
     * @stability stable
     */
    set schedule(value: string);
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): string | undefined;
    private _timeZone?;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    set timeZone(value: string);
    /**
     * @stability stable
     */
    resetTimeZone(): void;
    /**
     * @stability stable
     */
    get timeZoneInput(): string | undefined;
    private _appEngineHttpTarget;
    /**
     * @stability stable
     */
    get appEngineHttpTarget(): CloudSchedulerJobAppEngineHttpTargetOutputReference;
    /**
     * @stability stable
     */
    putAppEngineHttpTarget(value: CloudSchedulerJobAppEngineHttpTarget): void;
    /**
     * @stability stable
     */
    resetAppEngineHttpTarget(): void;
    /**
     * @stability stable
     */
    get appEngineHttpTargetInput(): CloudSchedulerJobAppEngineHttpTarget | undefined;
    private _httpTarget;
    /**
     * @stability stable
     */
    get httpTarget(): CloudSchedulerJobHttpTargetOutputReference;
    /**
     * @stability stable
     */
    putHttpTarget(value: CloudSchedulerJobHttpTarget): void;
    /**
     * @stability stable
     */
    resetHttpTarget(): void;
    /**
     * @stability stable
     */
    get httpTargetInput(): CloudSchedulerJobHttpTarget | undefined;
    private _pubsubTarget;
    /**
     * @stability stable
     */
    get pubsubTarget(): CloudSchedulerJobPubsubTargetOutputReference;
    /**
     * @stability stable
     */
    putPubsubTarget(value: CloudSchedulerJobPubsubTarget): void;
    /**
     * @stability stable
     */
    resetPubsubTarget(): void;
    /**
     * @stability stable
     */
    get pubsubTargetInput(): CloudSchedulerJobPubsubTarget | undefined;
    private _retryConfig;
    /**
     * @stability stable
     */
    get retryConfig(): CloudSchedulerJobRetryConfigOutputReference;
    /**
     * @stability stable
     */
    putRetryConfig(value: CloudSchedulerJobRetryConfig): void;
    /**
     * @stability stable
     */
    resetRetryConfig(): void;
    /**
     * @stability stable
     */
    get retryConfigInput(): CloudSchedulerJobRetryConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudSchedulerJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudSchedulerJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudSchedulerJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
