import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeAttachedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance.
     *
     * This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disks-x, where x is a number assigned by Google Compute Engine.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#device_name ComputeAttachedDisk#device_name}
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * name or self_link of the disk that will be attached.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#disk ComputeAttachedDisk#disk}
     *
     * @stability stable
     */
    readonly disk: string;
    /**
     * name or self_link of the compute instance that the disk will be attached to.
     *
     * If the self_link is provided then zone and project are extracted from the self link. If only the name is used then zone and project must be defined as properties on the resource or provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#instance ComputeAttachedDisk#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
     *
     * If not specified, the default is to attach the disk in READ_WRITE mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#mode ComputeAttachedDisk#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The project that the referenced compute instance is a part of.
     *
     * If instance is referenced by its self_link the project defined in the link will take precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#project ComputeAttachedDisk#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The zone that the referenced compute instance is located within.
     *
     * If instance is referenced by its self_link the zone defined in the link will take precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#zone ComputeAttachedDisk#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#timeouts ComputeAttachedDisk#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeAttachedDiskTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeAttachedDiskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#create ComputeAttachedDisk#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk#delete ComputeAttachedDisk#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeAttachedDiskTimeoutsToTerraform(struct?: ComputeAttachedDiskTimeoutsOutputReference | ComputeAttachedDiskTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeAttachedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeAttachedDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeAttachedDiskTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk google_compute_attached_disk}.
 *
 * @stability stable
 */
export declare class ComputeAttachedDisk extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_attached_disk google_compute_attached_disk} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeAttachedDiskConfig);
    private _deviceName?;
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    set deviceName(value: string);
    /**
     * @stability stable
     */
    resetDeviceName(): void;
    /**
     * @stability stable
     */
    get deviceNameInput(): string | undefined;
    private _disk?;
    /**
     * @stability stable
     */
    get disk(): string;
    /**
     * @stability stable
     */
    set disk(value: string);
    /**
     * @stability stable
     */
    get diskInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeAttachedDiskTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeAttachedDiskTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeAttachedDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
