import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInterconnectAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether the VLAN attachment is enabled or disabled.  When using PARTNER type this will Pre-Activate the interconnect attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#admin_enabled ComputeInterconnectAttachment#admin_enabled}
     *
     * @stability stable
     */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
     * Provisioned bandwidth capacity for the interconnect attachment.
     *
     * For attachments of type DEDICATED, the user can set the bandwidth.
     * For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     * Defaults to BPS_10G Possible values: ["BPS_50M", "BPS_100M", "BPS_200M", "BPS_300M", "BPS_400M", "BPS_500M", "BPS_1G", "BPS_2G", "BPS_5G", "BPS_10G", "BPS_20G", "BPS_50G"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#bandwidth ComputeInterconnectAttachment#bandwidth}
     *
     * @stability stable
     */
    readonly bandwidth?: string;
    /**
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     *
     * All prefixes must be within link-local address space (169.254.0.0/16)
     * and must be /29 or shorter (/28, /27, etc). Google will attempt to select
     * an unused /29 from the supplied candidate prefix(es). The request will
     * fail if all possible /29s are in use on Google's edge. If not supplied,
     * Google will randomly select an unused /29 from all of link-local space.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#candidate_subnets ComputeInterconnectAttachment#candidate_subnets}
     *
     * @stability stable
     */
    readonly candidateSubnets?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#description ComputeInterconnectAttachment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Desired availability domain for the attachment.
     *
     * Only available for type
     * PARTNER, at creation time. For improved reliability, customers should
     * configure a pair of attachments with one per availability domain. The
     * selected availability domain will be provided to the Partner via the
     * pairing key so that the provisioned circuit will lie in the specified
     * domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#edge_availability_domain ComputeInterconnectAttachment#edge_availability_domain}
     *
     * @stability stable
     */
    readonly edgeAvailabilityDomain?: string;
    /**
     * Indicates the user-supplied encryption option of this interconnect attachment:.
     *
     * NONE is the default value, which means that the attachment carries
     * unencrypted traffic. VMs can send traffic to, or receive traffic
     * from, this type of attachment.
     *
     * IPSEC indicates that the attachment carries only traffic encrypted by
     * an IPsec device such as an HA VPN gateway. VMs cannot directly send
     * traffic to, or receive traffic from, such an attachment. To use
     * IPsec-encrypted Cloud Interconnect create the attachment using this
     * option.
     *
     * Not currently available publicly. Default value: "NONE" Possible values: ["NONE", "IPSEC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#encryption ComputeInterconnectAttachment#encryption}
     *
     * @stability stable
     */
    readonly encryption?: string;
    /**
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     *
     * Required if type is DEDICATED, must not
     * be set if type is PARTNER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#interconnect ComputeInterconnectAttachment#interconnect}
     *
     * @stability stable
     */
    readonly interconnect?: string;
    /**
     * URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC.
     *
     * The addresses must be RFC 1918 IP address ranges. When creating HA
     * VPN gateway over the interconnect attachment, if the attachment is
     * configured to use an RFC 1918 IP address, then the VPN gateway's IP
     * address will be allocated from the IP address range specified
     * here.
     *
     * For example, if the HA VPN gateway's interface 0 is paired to this
     * interconnect attachment, then an RFC 1918 IP address for the VPN
     * gateway interface 0 will be allocated from the IP address specified
     * for this interconnect attachment.
     *
     * If this field is not specified for interconnect attachment that has
     * encryption option as IPSEC, later on when creating HA VPN gateway on
     * this interconnect attachment, the HA VPN gateway's IP address will be
     * allocated from regional external IP address pool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#ipsec_internal_addresses ComputeInterconnectAttachment#ipsec_internal_addresses}
     *
     * @stability stable
     */
    readonly ipsecInternalAddresses?: string[];
    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
     *
     * Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#mtu ComputeInterconnectAttachment#mtu}
     *
     * @stability stable
     */
    readonly mtu?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is created. The
     * name must be 1-63 characters long, and comply with RFC1035. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a
     * lowercase letter, and all following characters must be a dash, lowercase
     * letter, or digit, except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#name ComputeInterconnectAttachment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#project ComputeInterconnectAttachment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the regional interconnect attachment resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#region ComputeInterconnectAttachment#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * URL of the cloud router to be used for dynamic routing.
     *
     * This router must be in
     * the same region as this InterconnectAttachment. The InterconnectAttachment will
     * automatically connect the Interconnect to the network & region within which the
     * Cloud Router is configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#router ComputeInterconnectAttachment#router}
     *
     * @stability stable
     */
    readonly router: string;
    /**
     * The type of InterconnectAttachment you wish to create. Defaults to DEDICATED. Possible values: ["DEDICATED", "PARTNER", "PARTNER_PROVIDER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#type ComputeInterconnectAttachment#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When using PARTNER type this will be managed upstream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#vlan_tag8021q ComputeInterconnectAttachment#vlan_tag8021q}
     *
     * @stability stable
     */
    readonly vlanTag8021Q?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#timeouts ComputeInterconnectAttachment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInterconnectAttachmentTimeouts;
}
/**
 * @stability stable
 */
export declare class ComputeInterconnectAttachmentPrivateInterconnectInfo extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get tag8021Q(): number;
}
/**
 * @stability stable
 */
export interface ComputeInterconnectAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#create ComputeInterconnectAttachment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#delete ComputeInterconnectAttachment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment#update ComputeInterconnectAttachment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeInterconnectAttachmentTimeoutsToTerraform(struct?: ComputeInterconnectAttachmentTimeoutsOutputReference | ComputeInterconnectAttachmentTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeInterconnectAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInterconnectAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInterconnectAttachmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment google_compute_interconnect_attachment}.
 *
 * @stability stable
 */
export declare class ComputeInterconnectAttachment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment google_compute_interconnect_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInterconnectAttachmentConfig);
    private _adminEnabled?;
    /**
     * @stability stable
     */
    get adminEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set adminEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdminEnabled(): void;
    /**
     * @stability stable
     */
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bandwidth?;
    /**
     * @stability stable
     */
    get bandwidth(): string;
    /**
     * @stability stable
     */
    set bandwidth(value: string);
    /**
     * @stability stable
     */
    resetBandwidth(): void;
    /**
     * @stability stable
     */
    get bandwidthInput(): string | undefined;
    private _candidateSubnets?;
    /**
     * @stability stable
     */
    get candidateSubnets(): string[];
    /**
     * @stability stable
     */
    set candidateSubnets(value: string[]);
    /**
     * @stability stable
     */
    resetCandidateSubnets(): void;
    /**
     * @stability stable
     */
    get candidateSubnetsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get cloudRouterIpAddress(): string;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    /**
     * @stability stable
     */
    get customerRouterIpAddress(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _edgeAvailabilityDomain?;
    /**
     * @stability stable
     */
    get edgeAvailabilityDomain(): string;
    /**
     * @stability stable
     */
    set edgeAvailabilityDomain(value: string);
    /**
     * @stability stable
     */
    resetEdgeAvailabilityDomain(): void;
    /**
     * @stability stable
     */
    get edgeAvailabilityDomainInput(): string | undefined;
    private _encryption?;
    /**
     * @stability stable
     */
    get encryption(): string;
    /**
     * @stability stable
     */
    set encryption(value: string);
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get googleReferenceId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _interconnect?;
    /**
     * @stability stable
     */
    get interconnect(): string;
    /**
     * @stability stable
     */
    set interconnect(value: string);
    /**
     * @stability stable
     */
    resetInterconnect(): void;
    /**
     * @stability stable
     */
    get interconnectInput(): string | undefined;
    private _ipsecInternalAddresses?;
    /**
     * @stability stable
     */
    get ipsecInternalAddresses(): string[];
    /**
     * @stability stable
     */
    set ipsecInternalAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetIpsecInternalAddresses(): void;
    /**
     * @stability stable
     */
    get ipsecInternalAddressesInput(): string[] | undefined;
    private _mtu?;
    /**
     * @stability stable
     */
    get mtu(): string;
    /**
     * @stability stable
     */
    set mtu(value: string);
    /**
     * @stability stable
     */
    resetMtu(): void;
    /**
     * @stability stable
     */
    get mtuInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get pairingKey(): string;
    /**
     * @stability stable
     */
    get partnerAsn(): string;
    /**
     * @stability stable
     */
    privateInterconnectInfo(index: string): ComputeInterconnectAttachmentPrivateInterconnectInfo;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _router?;
    /**
     * @stability stable
     */
    get router(): string;
    /**
     * @stability stable
     */
    set router(value: string);
    /**
     * @stability stable
     */
    get routerInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get state(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _vlanTag8021Q?;
    /**
     * @stability stable
     */
    get vlanTag8021Q(): number;
    /**
     * @stability stable
     */
    set vlanTag8021Q(value: number);
    /**
     * @stability stable
     */
    resetVlanTag8021Q(): void;
    /**
     * @stability stable
     */
    get vlanTag8021QInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInterconnectAttachmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeInterconnectAttachmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInterconnectAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
