import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#minimal_action ComputeRegionPerInstanceConfig#minimal_action}.
     *
     * @stability stable
     */
    readonly minimalAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#most_disruptive_allowed_action ComputeRegionPerInstanceConfig#most_disruptive_allowed_action}.
     *
     * @stability stable
     */
    readonly mostDisruptiveAllowedAction?: string;
    /**
     * The name for this per-instance config and its corresponding instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#name ComputeRegionPerInstanceConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#project ComputeRegionPerInstanceConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the containing instance group manager is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#region ComputeRegionPerInstanceConfig#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The region instance group manager this instance config is part of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#region_instance_group_manager ComputeRegionPerInstanceConfig#region_instance_group_manager}
     *
     * @stability stable
     */
    readonly regionInstanceGroupManager: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#remove_instance_state_on_destroy ComputeRegionPerInstanceConfig#remove_instance_state_on_destroy}.
     *
     * @stability stable
     */
    readonly removeInstanceStateOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * preserved_state block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#preserved_state ComputeRegionPerInstanceConfig#preserved_state}
     *
     * @stability stable
     */
    readonly preservedState?: ComputeRegionPerInstanceConfigPreservedState;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#timeouts ComputeRegionPerInstanceConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionPerInstanceConfigTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigPreservedStateDisk {
    /**
     * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
     *
     * The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
     * 'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
     * 'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
     * deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#delete_rule ComputeRegionPerInstanceConfig#delete_rule}
     *
     * @stability stable
     */
    readonly deleteRule?: string;
    /**
     * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#device_name ComputeRegionPerInstanceConfig#device_name}
     *
     * @stability stable
     */
    readonly deviceName: string;
    /**
     * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#mode ComputeRegionPerInstanceConfig#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The URI of an existing persistent disk to attach under the specified device-name in the format 'projects/project-id/zones/zone/disks/disk-name'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#source ComputeRegionPerInstanceConfig#source}
     *
     * @stability stable
     */
    readonly source: string;
}
export declare function computeRegionPerInstanceConfigPreservedStateDiskToTerraform(struct?: ComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigPreservedState {
    /**
     * Preserved metadata defined for this instance. This is a list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#metadata ComputeRegionPerInstanceConfig#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#disk ComputeRegionPerInstanceConfig#disk}
     *
     * @stability stable
     */
    readonly disk?: ComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
}
export declare function computeRegionPerInstanceConfigPreservedStateToTerraform(struct?: ComputeRegionPerInstanceConfigPreservedStateOutputReference | ComputeRegionPerInstanceConfigPreservedState): any;
/**
 * @stability stable
 */
export declare class ComputeRegionPerInstanceConfigPreservedStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionPerInstanceConfigPreservedState | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionPerInstanceConfigPreservedState | undefined);
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _disk?;
    /**
     * @stability stable
     */
    get disk(): ComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disk(value: ComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisk(): void;
    /**
     * @stability stable
     */
    get diskInput(): cdktf.IResolvable | ComputeRegionPerInstanceConfigPreservedStateDisk[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#create ComputeRegionPerInstanceConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#delete ComputeRegionPerInstanceConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#update ComputeRegionPerInstanceConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeRegionPerInstanceConfigTimeoutsToTerraform(struct?: ComputeRegionPerInstanceConfigTimeoutsOutputReference | ComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeRegionPerInstanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionPerInstanceConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionPerInstanceConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config google_compute_region_per_instance_config}.
 *
 * @stability stable
 */
export declare class ComputeRegionPerInstanceConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config google_compute_region_per_instance_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionPerInstanceConfigConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _minimalAction?;
    /**
     * @stability stable
     */
    get minimalAction(): string;
    /**
     * @stability stable
     */
    set minimalAction(value: string);
    /**
     * @stability stable
     */
    resetMinimalAction(): void;
    /**
     * @stability stable
     */
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    /**
     * @stability stable
     */
    get mostDisruptiveAllowedAction(): string;
    /**
     * @stability stable
     */
    set mostDisruptiveAllowedAction(value: string);
    /**
     * @stability stable
     */
    resetMostDisruptiveAllowedAction(): void;
    /**
     * @stability stable
     */
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _regionInstanceGroupManager?;
    /**
     * @stability stable
     */
    get regionInstanceGroupManager(): string;
    /**
     * @stability stable
     */
    set regionInstanceGroupManager(value: string);
    /**
     * @stability stable
     */
    get regionInstanceGroupManagerInput(): string | undefined;
    private _removeInstanceStateOnDestroy?;
    /**
     * @stability stable
     */
    get removeInstanceStateOnDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set removeInstanceStateOnDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRemoveInstanceStateOnDestroy(): void;
    /**
     * @stability stable
     */
    get removeInstanceStateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _preservedState;
    /**
     * @stability stable
     */
    get preservedState(): ComputeRegionPerInstanceConfigPreservedStateOutputReference;
    /**
     * @stability stable
     */
    putPreservedState(value: ComputeRegionPerInstanceConfigPreservedState): void;
    /**
     * @stability stable
     */
    resetPreservedState(): void;
    /**
     * @stability stable
     */
    get preservedStateInput(): ComputeRegionPerInstanceConfigPreservedState | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionPerInstanceConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRegionPerInstanceConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionPerInstanceConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
