import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRouterInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name or resource link to the VLAN interconnect for this interface.
     *
     * Changing this forces a new interface to be created. Only one of vpn_tunnel and interconnect_attachment can be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#interconnect_attachment ComputeRouterInterface#interconnect_attachment}
     *
     * @stability stable
     */
    readonly interconnectAttachment?: string;
    /**
     * IP address and range of the interface.
     *
     * The IP range must be in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#ip_range ComputeRouterInterface#ip_range}
     *
     * @stability stable
     */
    readonly ipRange?: string;
    /**
     * A unique name for the interface, required by GCE. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#name ComputeRouterInterface#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which this interface's router belongs.
     *
     * If it is not provided, the provider project is used. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#project ComputeRouterInterface#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region this interface's router sits in.
     *
     * If not specified, the project region will be used. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#region ComputeRouterInterface#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The name of the router this interface will be attached to.
     *
     * Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#router ComputeRouterInterface#router}
     *
     * @stability stable
     */
    readonly router: string;
    /**
     * The name or resource link to the VPN tunnel this interface will be linked to.
     *
     * Changing this forces a new interface to be created. Only one of vpn_tunnel and interconnect_attachment can be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#vpn_tunnel ComputeRouterInterface#vpn_tunnel}
     *
     * @stability stable
     */
    readonly vpnTunnel?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#timeouts ComputeRouterInterface#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRouterInterfaceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRouterInterfaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#create ComputeRouterInterface#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface#delete ComputeRouterInterface#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeRouterInterfaceTimeoutsToTerraform(struct?: ComputeRouterInterfaceTimeoutsOutputReference | ComputeRouterInterfaceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeRouterInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRouterInterfaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRouterInterfaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface google_compute_router_interface}.
 *
 * @stability stable
 */
export declare class ComputeRouterInterface extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface google_compute_router_interface} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRouterInterfaceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _interconnectAttachment?;
    /**
     * @stability stable
     */
    get interconnectAttachment(): string;
    /**
     * @stability stable
     */
    set interconnectAttachment(value: string);
    /**
     * @stability stable
     */
    resetInterconnectAttachment(): void;
    /**
     * @stability stable
     */
    get interconnectAttachmentInput(): string | undefined;
    private _ipRange?;
    /**
     * @stability stable
     */
    get ipRange(): string;
    /**
     * @stability stable
     */
    set ipRange(value: string);
    /**
     * @stability stable
     */
    resetIpRange(): void;
    /**
     * @stability stable
     */
    get ipRangeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _router?;
    /**
     * @stability stable
     */
    get router(): string;
    /**
     * @stability stable
     */
    set router(value: string);
    /**
     * @stability stable
     */
    get routerInput(): string | undefined;
    private _vpnTunnel?;
    /**
     * @stability stable
     */
    get vpnTunnel(): string;
    /**
     * @stability stable
     */
    set vpnTunnel(value: string);
    /**
     * @stability stable
     */
    resetVpnTunnel(): void;
    /**
     * @stability stable
     */
    get vpnTunnelInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRouterInterfaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRouterInterfaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRouterInterfaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
