import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRouterPeerConfig extends cdktf.TerraformMetaArguments {
    /**
     * User-specified flag to indicate which mode to use for advertisement.
     *
     * Valid values of this enum field are: 'DEFAULT', 'CUSTOM' Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertise_mode ComputeRouterPeer#advertise_mode}
     *
     * @stability stable
     */
    readonly advertiseMode?: string;
    /**
     * User-specified list of prefix groups to advertise in custom mode, which can take one of the following options:.
     *
     * 'ALL_SUBNETS': Advertises all available subnets, including peer VPC subnets.
     * 'ALL_VPC_SUBNETS': Advertises the router's own VPC subnets.
     * 'ALL_PEER_VPC_SUBNETS': Advertises peer subnets of the router's VPC network.
     *
     *
     * Note that this field can only be populated if advertiseMode is 'CUSTOM'
     * and overrides the list defined for the router (in the "bgp" message).
     * These groups are advertised in addition to any specified prefixes.
     * Leave this field blank to advertise no custom groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_groups ComputeRouterPeer#advertised_groups}
     *
     * @stability stable
     */
    readonly advertisedGroups?: string[];
    /**
     * The priority of routes advertised to this BGP peer.
     *
     * Where there is more than one matching route of maximum
     * length, the routes with the lowest priority value win.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_route_priority ComputeRouterPeer#advertised_route_priority}
     *
     * @stability stable
     */
    readonly advertisedRoutePriority?: number;
    /**
     * The status of the BGP peer connection.
     *
     * If set to false, any active session
     * with the peer is terminated and all associated routing information is removed.
     * If set to true, the peer connection can be established with routing information.
     * The default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#enable ComputeRouterPeer#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
     * Name of the interface the BGP peer is associated with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#interface ComputeRouterPeer#interface}
     *
     * @stability stable
     */
    readonly interface: string;
    /**
     * IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#ip_address ComputeRouterPeer#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Name of this BGP peer.
     *
     * The name must be 1-63 characters long,
     * and comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
     * means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#name ComputeRouterPeer#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_asn ComputeRouterPeer#peer_asn}
     *
     * @stability stable
     */
    readonly peerAsn: number;
    /**
     * IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_ip_address ComputeRouterPeer#peer_ip_address}
     *
     * @stability stable
     */
    readonly peerIpAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#project ComputeRouterPeer#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the router and BgpPeer reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#region ComputeRouterPeer#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The name of the Cloud Router in which this BgpPeer will be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#router ComputeRouterPeer#router}
     *
     * @stability stable
     */
    readonly router: string;
    /**
     * advertised_ip_ranges block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_ip_ranges ComputeRouterPeer#advertised_ip_ranges}
     *
     * @stability stable
     */
    readonly advertisedIpRanges?: ComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#timeouts ComputeRouterPeer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRouterPeerTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRouterPeerAdvertisedIpRanges {
    /**
     * User-specified description for the IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#description ComputeRouterPeer#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The IP range to advertise. The value must be a CIDR-formatted string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#range ComputeRouterPeer#range}
     *
     * @stability stable
     */
    readonly range: string;
}
export declare function computeRouterPeerAdvertisedIpRangesToTerraform(struct?: ComputeRouterPeerAdvertisedIpRanges | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ComputeRouterPeerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#create ComputeRouterPeer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#delete ComputeRouterPeer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#update ComputeRouterPeer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeRouterPeerTimeoutsToTerraform(struct?: ComputeRouterPeerTimeoutsOutputReference | ComputeRouterPeerTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeRouterPeerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRouterPeerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRouterPeerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer google_compute_router_peer}.
 *
 * @stability stable
 */
export declare class ComputeRouterPeer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer google_compute_router_peer} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRouterPeerConfig);
    private _advertiseMode?;
    /**
     * @stability stable
     */
    get advertiseMode(): string;
    /**
     * @stability stable
     */
    set advertiseMode(value: string);
    /**
     * @stability stable
     */
    resetAdvertiseMode(): void;
    /**
     * @stability stable
     */
    get advertiseModeInput(): string | undefined;
    private _advertisedGroups?;
    /**
     * @stability stable
     */
    get advertisedGroups(): string[];
    /**
     * @stability stable
     */
    set advertisedGroups(value: string[]);
    /**
     * @stability stable
     */
    resetAdvertisedGroups(): void;
    /**
     * @stability stable
     */
    get advertisedGroupsInput(): string[] | undefined;
    private _advertisedRoutePriority?;
    /**
     * @stability stable
     */
    get advertisedRoutePriority(): number;
    /**
     * @stability stable
     */
    set advertisedRoutePriority(value: number);
    /**
     * @stability stable
     */
    resetAdvertisedRoutePriority(): void;
    /**
     * @stability stable
     */
    get advertisedRoutePriorityInput(): number | undefined;
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _interface?;
    /**
     * @stability stable
     */
    get interface(): string;
    /**
     * @stability stable
     */
    set interface(value: string);
    /**
     * @stability stable
     */
    get interfaceInput(): string | undefined;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    set ipAddress(value: string);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    /**
     * @stability stable
     */
    get managementType(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peerAsn?;
    /**
     * @stability stable
     */
    get peerAsn(): number;
    /**
     * @stability stable
     */
    set peerAsn(value: number);
    /**
     * @stability stable
     */
    get peerAsnInput(): number | undefined;
    private _peerIpAddress?;
    /**
     * @stability stable
     */
    get peerIpAddress(): string;
    /**
     * @stability stable
     */
    set peerIpAddress(value: string);
    /**
     * @stability stable
     */
    get peerIpAddressInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _router?;
    /**
     * @stability stable
     */
    get router(): string;
    /**
     * @stability stable
     */
    set router(value: string);
    /**
     * @stability stable
     */
    get routerInput(): string | undefined;
    private _advertisedIpRanges?;
    /**
     * @stability stable
     */
    get advertisedIpRanges(): ComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set advertisedIpRanges(value: ComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdvertisedIpRanges(): void;
    /**
     * @stability stable
     */
    get advertisedIpRangesInput(): cdktf.IResolvable | ComputeRouterPeerAdvertisedIpRanges[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRouterPeerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRouterPeerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRouterPeerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
