import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetHttpProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#description ComputeTargetHttpProxy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#name ComputeTargetHttpProxy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#project ComputeTargetHttpProxy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#proxy_bind ComputeTargetHttpProxy#proxy_bind}
     *
     * @stability stable
     */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
     * A reference to the UrlMap resource that defines the mapping from URL to the BackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#url_map ComputeTargetHttpProxy#url_map}
     *
     * @stability stable
     */
    readonly urlMap: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#timeouts ComputeTargetHttpProxy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetHttpProxyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetHttpProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#create ComputeTargetHttpProxy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#delete ComputeTargetHttpProxy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy#update ComputeTargetHttpProxy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeTargetHttpProxyTimeoutsToTerraform(struct?: ComputeTargetHttpProxyTimeoutsOutputReference | ComputeTargetHttpProxyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeTargetHttpProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeTargetHttpProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeTargetHttpProxyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy google_compute_target_http_proxy}.
 *
 * @stability stable
 */
export declare class ComputeTargetHttpProxy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_http_proxy google_compute_target_http_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetHttpProxyConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _proxyBind?;
    /**
     * @stability stable
     */
    get proxyBind(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set proxyBind(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProxyBind(): void;
    /**
     * @stability stable
     */
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get proxyId(): number;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _urlMap?;
    /**
     * @stability stable
     */
    get urlMap(): string;
    /**
     * @stability stable
     */
    set urlMap(value: string);
    /**
     * @stability stable
     */
    get urlMapInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetHttpProxyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeTargetHttpProxyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetHttpProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
