import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventarcTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optional. User labels attached to the triggers that can be used to group resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#labels EventarcTrigger#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#location EventarcTrigger#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Required.
     *
     * The resource name of the trigger. Must be unique within the location on the project and must be in `projects/{project}/locations/{location}/triggers/{trigger}` format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#name EventarcTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The project for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#project EventarcTrigger#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Optional.
     *
     * The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#service_account EventarcTrigger#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#destination EventarcTrigger#destination}
     *
     * @stability stable
     */
    readonly destination: EventarcTriggerDestination;
    /**
     * matching_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#matching_criteria EventarcTrigger#matching_criteria}
     *
     * @stability stable
     */
    readonly matchingCriteria: EventarcTriggerMatchingCriteria[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#timeouts EventarcTrigger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventarcTriggerTimeouts;
    /**
     * transport block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#transport EventarcTrigger#transport}
     *
     * @stability stable
     */
    readonly transport?: EventarcTriggerTransport;
}
/**
 * @stability stable
 */
export interface EventarcTriggerDestinationCloudRunService {
    /**
     * Optional.
     *
     * The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#path EventarcTrigger#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Required. The region the Cloud Run service is deployed in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#region EventarcTrigger#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Required.
     *
     * The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#service EventarcTrigger#service}
     *
     * @stability stable
     */
    readonly service: string;
}
export declare function eventarcTriggerDestinationCloudRunServiceToTerraform(struct?: EventarcTriggerDestinationCloudRunServiceOutputReference | EventarcTriggerDestinationCloudRunService): any;
/**
 * @stability stable
 */
export declare class EventarcTriggerDestinationCloudRunServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventarcTriggerDestinationCloudRunService | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventarcTriggerDestinationCloudRunService | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventarcTriggerDestination {
    /**
     * The Cloud Function resource name. Only Cloud Functions V2 is supported. Format: projects/{project}/locations/{location}/functions/{function}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#cloud_function EventarcTrigger#cloud_function}
     *
     * @stability stable
     */
    readonly cloudFunction?: string;
    /**
     * cloud_run_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#cloud_run_service EventarcTrigger#cloud_run_service}
     *
     * @stability stable
     */
    readonly cloudRunService?: EventarcTriggerDestinationCloudRunService;
}
export declare function eventarcTriggerDestinationToTerraform(struct?: EventarcTriggerDestinationOutputReference | EventarcTriggerDestination): any;
/**
 * @stability stable
 */
export declare class EventarcTriggerDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventarcTriggerDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventarcTriggerDestination | undefined);
    private _cloudFunction?;
    /**
     * @stability stable
     */
    get cloudFunction(): string;
    /**
     * @stability stable
     */
    set cloudFunction(value: string);
    /**
     * @stability stable
     */
    resetCloudFunction(): void;
    /**
     * @stability stable
     */
    get cloudFunctionInput(): string | undefined;
    private _cloudRunService;
    /**
     * @stability stable
     */
    get cloudRunService(): EventarcTriggerDestinationCloudRunServiceOutputReference;
    /**
     * @stability stable
     */
    putCloudRunService(value: EventarcTriggerDestinationCloudRunService): void;
    /**
     * @stability stable
     */
    resetCloudRunService(): void;
    /**
     * @stability stable
     */
    get cloudRunServiceInput(): EventarcTriggerDestinationCloudRunService | undefined;
}
/**
 * @stability stable
 */
export interface EventarcTriggerMatchingCriteria {
    /**
     * Required.
     *
     * The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#attribute EventarcTrigger#attribute}
     *
     * @stability stable
     */
    readonly attribute: string;
    /**
     * Required. The value for the attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#value EventarcTrigger#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function eventarcTriggerMatchingCriteriaToTerraform(struct?: EventarcTriggerMatchingCriteria | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventarcTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#create EventarcTrigger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#delete EventarcTrigger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#update EventarcTrigger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventarcTriggerTimeoutsToTerraform(struct?: EventarcTriggerTimeoutsOutputReference | EventarcTriggerTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class EventarcTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventarcTriggerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventarcTriggerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventarcTriggerTransportPubsub {
    /**
     * Optional.
     *
     * The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#topic EventarcTrigger#topic}
     *
     * @stability stable
     */
    readonly topic?: string;
}
export declare function eventarcTriggerTransportPubsubToTerraform(struct?: EventarcTriggerTransportPubsubOutputReference | EventarcTriggerTransportPubsub): any;
/**
 * @stability stable
 */
export declare class EventarcTriggerTransportPubsubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventarcTriggerTransportPubsub | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventarcTriggerTransportPubsub | undefined);
    /**
     * @stability stable
     */
    get subscription(): string;
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    resetTopic(): void;
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventarcTriggerTransport {
    /**
     * pubsub block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger#pubsub EventarcTrigger#pubsub}
     *
     * @stability stable
     */
    readonly pubsub?: EventarcTriggerTransportPubsub;
}
export declare function eventarcTriggerTransportToTerraform(struct?: EventarcTriggerTransportOutputReference | EventarcTriggerTransport): any;
/**
 * @stability stable
 */
export declare class EventarcTriggerTransportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventarcTriggerTransport | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventarcTriggerTransport | undefined);
    private _pubsub;
    /**
     * @stability stable
     */
    get pubsub(): EventarcTriggerTransportPubsubOutputReference;
    /**
     * @stability stable
     */
    putPubsub(value: EventarcTriggerTransportPubsub): void;
    /**
     * @stability stable
     */
    resetPubsub(): void;
    /**
     * @stability stable
     */
    get pubsubInput(): EventarcTriggerTransportPubsub | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger google_eventarc_trigger}.
 *
 * @stability stable
 */
export declare class EventarcTrigger extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger google_eventarc_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventarcTriggerConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    /**
     * @stability stable
     */
    get uid(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _destination;
    /**
     * @stability stable
     */
    get destination(): EventarcTriggerDestinationOutputReference;
    /**
     * @stability stable
     */
    putDestination(value: EventarcTriggerDestination): void;
    /**
     * @stability stable
     */
    get destinationInput(): EventarcTriggerDestination | undefined;
    private _matchingCriteria?;
    /**
     * @stability stable
     */
    get matchingCriteria(): EventarcTriggerMatchingCriteria[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set matchingCriteria(value: EventarcTriggerMatchingCriteria[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get matchingCriteriaInput(): cdktf.IResolvable | EventarcTriggerMatchingCriteria[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventarcTriggerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventarcTriggerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventarcTriggerTimeouts | undefined;
    private _transport;
    /**
     * @stability stable
     */
    get transport(): EventarcTriggerTransportOutputReference;
    /**
     * @stability stable
     */
    putTransport(value: EventarcTriggerTransport): void;
    /**
     * @stability stable
     */
    resetTransport(): void;
    /**
     * @stability stable
     */
    get transportInput(): EventarcTriggerTransport | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
