import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FolderIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#folder FolderIamAuditConfig#folder}.
     *
     * @stability stable
     */
    readonly folder: string;
    /**
     * Service which will be enabled for audit logging. The special value allServices covers all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#service FolderIamAuditConfig#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * audit_log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#audit_log_config FolderIamAuditConfig#audit_log_config}
     *
     * @stability stable
     */
    readonly auditLogConfig: FolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface FolderIamAuditConfigAuditLogConfig {
    /**
     * Identities that do not cause logging for this type of permission.
     *
     * Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#exempted_members FolderIamAuditConfig#exempted_members}
     *
     * @stability stable
     */
    readonly exemptedMembers?: string[];
    /**
     * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config#log_type FolderIamAuditConfig#log_type}
     *
     * @stability stable
     */
    readonly logType: string;
}
export declare function folderIamAuditConfigAuditLogConfigToTerraform(struct?: FolderIamAuditConfigAuditLogConfig | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config google_folder_iam_audit_config}.
 *
 * @stability stable
 */
export declare class FolderIamAuditConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_iam_audit_config google_folder_iam_audit_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FolderIamAuditConfigConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _auditLogConfig?;
    /**
     * @stability stable
     */
    get auditLogConfig(): FolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set auditLogConfig(value: FolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get auditLogConfigInput(): cdktf.IResolvable | FolderIamAuditConfigAuditLogConfig[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
