# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pelican', 'pelican.plugins.graphviz']

package_data = \
{'': ['*']}

install_requires = \
['pelican>=4.5']

extras_require = \
{'markdown': ['markdown>=3.2']}

setup_kwargs = {
    'name': 'pelican-graphviz',
    'version': '1.1.0',
    'description': 'Pelican plugin supporting Graphviz images in articles',
    'long_description': 'Graphviz: A Plugin for Pelican\n==============================\n\n[![Build Status](https://img.shields.io/github/workflow/status/pelican-plugins/graphviz/build)](https://github.com/pelican-plugins/graphviz/actions)\n[![PyPI Version](https://img.shields.io/pypi/v/pelican-graphviz)](https://pypi.org/project/pelican-graphviz/)\n![License](https://img.shields.io/pypi/l/pelican-graphviz?color=blue)\n\nGraphviz is a Pelican plugin that allows the inclusion of [Graphviz][] images using the Markdown markup format. The code for the Graphviz figure is included as a block in the article’s source, and the image is embedded in HTML using the Base64 format.\n\n[Graphviz]: https://www.graphviz.org\n\n\nInstallation\n------------\n\nThis plugin can be installed via:\n\n    python -m pip install pelican-graphviz\n\nGraphviz must be installed on the system, otherwise this plugin will be deactivated. Graphviz can be installed on Debian-based systems via:\n\n    sudo aptitude install graphviz\n\nFor macOS, Graphviz can be installed via Homebrew:\n\n    brew install graphviz\n\n\nUsage\n-----\n\nIn the Markdown source, the Graphviz code must be inserted as an individual block (i.e., separated from the rest of the material by blank lines), like the following:\n\n```markdwon\n..graphviz dot\ndigraph G {\n  graph [rankdir = LR];\n  Hello -> World\n}\n```\n\nThis will insert an image in your article like this:\n\n![figure](hello-world.png)\n\nThe block must start with `..graphviz` (this is configurable — see below). The word `dot` in the first line indicates the program that will be run to produce the image. The available programs are: `dot`, `neato`, `twopi`, `circo`, `fdp`, `sfdp`, and `patchwork` (see the [Graphviz documentation][] for details). The Graphviz code must start in the second line of the block. Notice that *newlines are not allowed inside the Graphviz block*.\n\n[Graphviz documentation]: https://www.graphviz.org/documentation/\n\n\nStyling with CSS\n----------------\n\nThe image is generated in HTML with an `<img>` element inside an HTML element (by default a `<div>`, but this is configurable — see below). The latter has class `graphviz` (this is also configurable — see below). A possible CSS styling would be:\n\n```css\ndiv.graphviz  {\n    margin: 10px;\n}\ndiv.graphviz img {\n    display: block;\n    padding: 5px;\n    margin-left: auto;\n    margin-right: auto;\n    text-align: center;\n    border-style: solid;\n    border-width: 1px;\n    border-color: rgb(192, 177, 177);\n    -webkit-border-radius: 5px;\n}\n```\n\n\nConfiguration\n-------------\n\nThe following variables can be set in the Pelican settings file:\n\n- `GRAPHVIZ_HTML_ELEMENT`: The HTML inside which the generated Graphviz image is inserted (defaults to `\'div\'`; another sensible possibility would be `\'span\'`).\n\n- `GRAPHVIZ_IMAGE_CLASS`: Class of the `<div>` element including the generated Graphviz image (defaults to `\'graphviz\'`).\n\n- `GRAPHVIZ_BLOCK_START`: Starting tag for the Graphviz block in Markdown (defaults to `\'..graphviz\'`).\n\n- `GRAPHVIZ_COMPRESS`: Compress the resulting SVG XML to an image (defaults to `True`). Without compression, more SVG features are available, for instance including clickable URLs inside the Graphviz diagram.\n\n\nOutput Image Format\n-------------------\n\nThe format of the embedded image is SVG, and there is currently no way to change it. This format was chosen over others (like PNG) for two reasons. First, the generated SRC string in Base64 seem to be shorter for SVG than for PNG. Second, the image will be available in the browser in a high-quality vectorized format. As a caveat, notice that this choice may prevent display in browsers lacking proper SVG support.\n\n\nAlternatives\n------------\n\nAn alternative to this plugin is the [Graphviz tag][] provided by the [Liquid Tags plugin][], which differs from this plugin in several respects. First, the Liquid Tags version uses the syntax `{% graphviz { <program> […] } %}`, while this Graphviz plugin uses the Markdown extension syntax `..graphviz <program> […]`. Regarding the rendered output, the differences are:\n\n- Both plugins output an element with `class="graphviz"`. However, only the Graphviz plugin allows you to change the class name via a configuration variable (`GRAPHVIZ_IMAGE_CLASS`).\n- Liquid Tags encodes the image as `src="data:image/png;base64,[…]"`, while the Graphviz plugin encodes it as `src="data:image/svg+xml;base64,[…]"`. This has two impacts. First, the size of the HTML code produced by this Graphviz plugin is much smaller. For example, the Base64 string for the Graphviz code `digraph graphname {a -> b -> c; b -> d;}` is four times smaller. Second, the Liquid Tags version generates a raster image file, whereas this Graphviz plugin produces a vector image that can be zoomed without image quality loss.\n- Liquid Tags outputs the Graphviz image inside a `<span>`, whereas this Graphviz plugin offers a choice for the container element.\n\n[Graphviz tag]: https://github.com/pelican-plugins/liquid-tags/blob/main/pelican/plugins/liquid_tags/graphviz.py\n[Liquid Tags plugin]: https://github.com/pelican-plugins/liquid-tags\n\n\nTo-Do\n-----\n\nContributions that make this plugin work with [reStructuredText][] content would be welcome.\n\n[reStructuredText]: https://docutils.sourceforge.io/rst.html\n\n\nContributing\n------------\n\nContributions are welcome and much appreciated. Every little bit helps. You can contribute by improving the documentation, adding missing features, and fixing bugs. You can also help out by reviewing and commenting on [existing issues][].\n\nTo start contributing to this plugin, review the [Contributing to Pelican][] documentation, beginning with the **Contributing Code** section.\n\n[existing issues]: https://github.com/pelican-plugins/graphviz/issues\n[Contributing to Pelican]: https://docs.getpelican.com/en/latest/contribute.html\n\n\nLicense\n-------\n\nCopyright © 2015, 2021  Rafael Laboissière <rafael@laboissiere.net>\n\nThis project is licensed under the AGPL 3.0 license.\n',
    'author': 'Rafael Laboissière',
    'author_email': 'rafael@laboissiere.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pelican-plugins/graphviz',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.2,<4.0',
}


setup(**setup_kwargs)
