"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mgn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
 *
 * @experimental
 */
class Mgn extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'mgn';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'BatchCreateVolumeSnapshotGroupForMgn',
                'BatchDeleteSnapshotRequestForMgn',
                'ChangeServerLifeCycleState',
                'CreateReplicationConfigurationTemplate',
                'DeleteJob',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DisconnectFromService',
                'FinalizeCutover',
                'InitializeService',
                'MarkAsArchived',
                'NotifyAgentAuthenticationForMgn',
                'NotifyAgentConnectedForMgn',
                'NotifyAgentDisconnectedForMgn',
                'NotifyAgentReplicationProgressForMgn',
                'RegisterAgentForMgn',
                'RetryDataReplication',
                'SendAgentLogsForMgn',
                'SendAgentMetricsForMgn',
                'SendChannelCommandResultForMgn',
                'SendClientLogsForMgn',
                'SendClientMetricsForMgn',
                'StartCutover',
                'StartTest',
                'TerminateTargetInstances',
                'UpdateAgentBacklogForMgn',
                'UpdateAgentConversionInfoForMgn',
                'UpdateAgentReplicationInfoForMgn',
                'UpdateAgentReplicationProcessStateForMgn',
                'UpdateAgentSourcePropertiesForMgn',
                'UpdateLaunchConfiguration',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeReplicationServerAssociationsForMgn',
                'DescribeSnapshotRequestsForMgn',
                'GetAgentCommandForMgn',
                'GetAgentConfirmedResumeInfoForMgn',
                'GetAgentInstallationAssetsForMgn',
                'GetAgentReplicationInfoForMgn',
                'GetAgentRuntimeConfigurationForMgn',
                'GetAgentSnapshotCreditsForMgn',
                'GetChannelCommandsForMgn',
                'GetLaunchConfiguration',
                'GetReplicationConfiguration',
                'ListTagsForResource'
            ],
            List: [
                'DescribeJobs',
                'DescribeReplicationConfigurationTemplates',
                'DescribeSourceServers'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * (experimental) Grants permission to create volume snapshot group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toBatchCreateVolumeSnapshotGroupForMgn() {
        return this.to('BatchCreateVolumeSnapshotGroupForMgn');
    }
    /**
     * (experimental) Grants permission to batch delete snapshot request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toBatchDeleteSnapshotRequestForMgn() {
        return this.to('BatchDeleteSnapshotRequestForMgn');
    }
    /**
     * (experimental) Grants permission to change source server life cycle state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ChangeServerLifeCycleState.html
     *
     * @experimental
     */
    toChangeServerLifeCycleState() {
        return this.to('ChangeServerLifeCycleState');
    }
    /**
     * (experimental) Grants permission to create replication configuration template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     *
     * @experimental
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * (experimental) Grants permission to delete job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteJob.html
     *
     * @experimental
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * (experimental) Grants permission to delete replication configuration template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     *
     * @experimental
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * (experimental) Grants permission to delete source server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteSourceServer.html
     *
     * @experimental
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * (experimental) Grants permission to describe job log items.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobLogItems.html
     *
     * @experimental
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * (experimental) Grants permission to describe jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobs.html
     *
     * @experimental
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * (experimental) Grants permission to describe replication configuration template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     *
     * @experimental
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * (experimental) Grants permission to describe replication server associations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toDescribeReplicationServerAssociationsForMgn() {
        return this.to('DescribeReplicationServerAssociationsForMgn');
    }
    /**
     * (experimental) Grants permission to describe snapshots requests.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toDescribeSnapshotRequestsForMgn() {
        return this.to('DescribeSnapshotRequestsForMgn');
    }
    /**
     * (experimental) Grants permission to describe source servers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeSourceServers.html
     *
     * @experimental
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * (experimental) Grants permission to disconnect source server from service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisconnectFromService.html
     *
     * @experimental
     */
    toDisconnectFromService() {
        return this.to('DisconnectFromService');
    }
    /**
     * (experimental) Grants permission to finalize cutover.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_FinalizeCutover.html
     *
     * @experimental
     */
    toFinalizeCutover() {
        return this.to('FinalizeCutover');
    }
    /**
     * (experimental) Grants permission to get agent command.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetAgentCommandForMgn() {
        return this.to('GetAgentCommandForMgn');
    }
    /**
     * (experimental) Grants permission to get agent confirmed resume info.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetAgentConfirmedResumeInfoForMgn() {
        return this.to('GetAgentConfirmedResumeInfoForMgn');
    }
    /**
     * (experimental) Grants permission to get agent installation assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetAgentInstallationAssetsForMgn() {
        return this.to('GetAgentInstallationAssetsForMgn');
    }
    /**
     * (experimental) Grants permission to get agent replication info.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetAgentReplicationInfoForMgn() {
        return this.to('GetAgentReplicationInfoForMgn');
    }
    /**
     * (experimental) Grants permission to get agent runtime configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetAgentRuntimeConfigurationForMgn() {
        return this.to('GetAgentRuntimeConfigurationForMgn');
    }
    /**
     * (experimental) Grants permission to get agent snapshots credits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetAgentSnapshotCreditsForMgn() {
        return this.to('GetAgentSnapshotCreditsForMgn');
    }
    /**
     * (experimental) Grants permission to get channel commands.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toGetChannelCommandsForMgn() {
        return this.to('GetChannelCommandsForMgn');
    }
    /**
     * (experimental) Grants permission to get launch configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetLaunchConfiguration.html
     *
     * @experimental
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to get replication configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetReplicationConfiguration.html
     *
     * @experimental
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to initialize service.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_InitializeService.html
     *
     * @experimental
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to mark source server as archived.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_MarkAsArchived.html
     *
     * @experimental
     */
    toMarkAsArchived() {
        return this.to('MarkAsArchived');
    }
    /**
     * (experimental) Grants permission to notify agent authentication.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toNotifyAgentAuthenticationForMgn() {
        return this.to('NotifyAgentAuthenticationForMgn');
    }
    /**
     * (experimental) Grants permission to notify agent is connected.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toNotifyAgentConnectedForMgn() {
        return this.to('NotifyAgentConnectedForMgn');
    }
    /**
     * (experimental) Grants permission to notify agent is disconnected.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toNotifyAgentDisconnectedForMgn() {
        return this.to('NotifyAgentDisconnectedForMgn');
    }
    /**
     * (experimental) Grants permission to notify agent replication progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toNotifyAgentReplicationProgressForMgn() {
        return this.to('NotifyAgentReplicationProgressForMgn');
    }
    /**
     * (experimental) Grants permission to register agent.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toRegisterAgentForMgn() {
        return this.to('RegisterAgentForMgn');
    }
    /**
     * (experimental) Grants permission to retry replication.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RetryDataReplication.html
     *
     * @experimental
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * (experimental) Grants permission to send agent logs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toSendAgentLogsForMgn() {
        return this.to('SendAgentLogsForMgn');
    }
    /**
     * (experimental) Grants permission to send agent metrics.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toSendAgentMetricsForMgn() {
        return this.to('SendAgentMetricsForMgn');
    }
    /**
     * (experimental) Grants permission to send channel command result.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toSendChannelCommandResultForMgn() {
        return this.to('SendChannelCommandResultForMgn');
    }
    /**
     * (experimental) Grants permission to send client logs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toSendClientLogsForMgn() {
        return this.to('SendClientLogsForMgn');
    }
    /**
     * (experimental) Grants permission to send client metrics.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toSendClientMetricsForMgn() {
        return this.to('SendClientMetricsForMgn');
    }
    /**
     * (experimental) Grants permission to start cutover.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartCutover.html
     *
     * @experimental
     */
    toStartCutover() {
        return this.to('StartCutover');
    }
    /**
     * (experimental) Grants permission to start test.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartTest.html
     *
     * @experimental
     */
    toStartTest() {
        return this.to('StartTest');
    }
    /**
     * (experimental) Grants permission to assign a resource tag.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to terminate target instances.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TerminateTargetInstances.html
     *
     * @experimental
     */
    toTerminateTargetInstances() {
        return this.to('TerminateTargetInstances');
    }
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update agent backlog.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toUpdateAgentBacklogForMgn() {
        return this.to('UpdateAgentBacklogForMgn');
    }
    /**
     * (experimental) Grants permission to update agent conversion info.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toUpdateAgentConversionInfoForMgn() {
        return this.to('UpdateAgentConversionInfoForMgn');
    }
    /**
     * (experimental) Grants permission to update agent replication info.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toUpdateAgentReplicationInfoForMgn() {
        return this.to('UpdateAgentReplicationInfoForMgn');
    }
    /**
     * (experimental) Grants permission to update agent replication process state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toUpdateAgentReplicationProcessStateForMgn() {
        return this.to('UpdateAgentReplicationProcessStateForMgn');
    }
    /**
     * (experimental) Grants permission to update agent source properties.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     *
     * @experimental
     */
    toUpdateAgentSourcePropertiesForMgn() {
        return this.to('UpdateAgentSourcePropertiesForMgn');
    }
    /**
     * (experimental) Grants permission to update launch configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfiguration.html
     *
     * @experimental
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to update replication configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfiguration.html
     *
     * @experimental
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to update replication configuration template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     *
     * @experimental
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * (experimental) Adds a resource of type JobResource to the statement.
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/launching-target-servers.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mgn:${region || '*'}:${account || '*'}:job/${jobID}`);
    }
    /**
     * (experimental) Adds a resource of type ReplicationConfigurationTemplateResource to the statement.
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mgn:${region || '*'}:${account || '*'}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * (experimental) Adds a resource of type SourceServerResource to the statement.
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:mgn:${region || '*'}:${account || '*'}:source-server/${sourceServerID}`);
    }
}
exports.Mgn = Mgn;
_a = JSII_RTTI_SYMBOL_1;
Mgn[_a] = { fqn: "iam-floyd.Mgn", version: "0.273.0" };
//# sourceMappingURL=data:application/json;base64,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