import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
 *
 * @experimental
 */
export declare class Apprunner extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate your own domain name with the AWS App Runner subdomain URL of your App Runner service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html
     *
     * @experimental
     */
    toAssociateCustomDomain(): this;
    /**
     * (experimental) Grants permission to create an AWS App Runner automatic scaling configuration resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateAutoScalingConfiguration.html
     *
     * @experimental
     */
    toCreateAutoScalingConfiguration(): this;
    /**
     * (experimental) Grants permission to create an AWS App Runner connection resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateConnection.html
     *
     * @experimental
     */
    toCreateConnection(): this;
    /**
     * (experimental) Grants permission to create an AWS App Runner service.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html
     *
     * @experimental
     */
    toCreateService(): this;
    /**
     * (experimental) Grants permission to delete an AWS App Runner automatic scaling configuration resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteAutoScalingConfiguration.html
     *
     * @experimental
     */
    toDeleteAutoScalingConfiguration(): this;
    /**
     * (experimental) Grants permission to delete an AWS App Runner connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteConnection.html
     *
     * @experimental
     */
    toDeleteConnection(): this;
    /**
     * (experimental) Grants permission to delete an AWS App Runner service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html
     *
     * @experimental
     */
    toDeleteService(): this;
    /**
     * (experimental) Grants permission to retrieve descriptions of an AWS App Runner automatic scaling configuration resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeAutoScalingConfiguration.html
     *
     * @experimental
     */
    toDescribeAutoScalingConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve descriptions of custom domain names associated with an AWS App Runner service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeCustomDomains.html
     *
     * @experimental
     */
    toDescribeCustomDomains(): this;
    /**
     * (experimental) Grants permission to retrieve description of an operation that occurred on an AWS App Runner service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeOperation.html
     *
     * @experimental
     */
    toDescribeOperation(): this;
    /**
     * (experimental) Grants permission to retrieve description of an AWS App Runner service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html
     *
     * @experimental
     */
    toDescribeService(): this;
    /**
     * (experimental) Grants permission to disassociate a custom domain name from an AWS App Runner service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DisassociateCustomDomain.html
     *
     * @experimental
     */
    toDisassociateCustomDomain(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS App Runner automatic scaling configurations in your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListAutoScalingConfigurations.html
     *
     * @experimental
     */
    toListAutoScalingConfigurations(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS App Runner connections associated with your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListConnections.html
     *
     * @experimental
     */
    toListConnections(): this;
    /**
     * (experimental) Grants permission to retrieve a list of operations that occurred on an AWS App Runner service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html
     *
     * @experimental
     */
    toListOperations(): this;
    /**
     * (experimental) Grants permission to retrieve a list of running AWS App Runner services in your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html
     *
     * @experimental
     */
    toListServices(): this;
    /**
     * (experimental) Grants permission to list tags associated with an AWS App Runner resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to pause an active AWS App Runner service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_PauseService.html
     *
     * @experimental
     */
    toPauseService(): this;
    /**
     * (experimental) Grants permission to resume an active AWS App Runner service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ResumeService.html
     *
     * @experimental
     */
    toResumeService(): this;
    /**
     * (experimental) Grants permission to initiate a manual deployemnt to an AWS App Runner service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_StartDeployment.html
     *
     * @experimental
     */
    toStartDeployment(): this;
    /**
     * (experimental) Grants permission to add tags to, or update tag values of, an App Runner resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from an App Runner resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an AWS App Runner service.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UpdateService.html
     *
     * @experimental
     */
    toUpdateService(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type service to the statement.
     *
     * @param serviceName - Identifier for the serviceName.
     * @param serviceId - Identifier for the serviceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onService(serviceName: string, serviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type connection to the statement.
     *
     * @param connectionName - Identifier for the connectionName.
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConnection(connectionName: string, connectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type autoscalingconfiguration to the statement.
     *
     * @param autoscalingConfigurationName - Identifier for the autoscalingConfigurationName.
     * @param autoscalingConfigurationVersion - Identifier for the autoscalingConfigurationVersion.
     * @param autoscalingConfigurationId - Identifier for the autoscalingConfigurationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAutoscalingconfiguration(autoscalingConfigurationName: string, autoscalingConfigurationVersion: string, autoscalingConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access to the CreateService and UpdateService actions based on the ARN of an associated AutoScalingConfiguration resource.
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifAutoScalingConfigurationArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access to the CreateService and UpdateService actions based on the ARN of an associated Connection resource.
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifConnectionArn(value: string | string[], operator?: Operator | string): this;
}
