import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [codeartifact](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodeartifact.html).
 *
 * @experimental
 */
export declare class Codeartifact extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [codeartifact](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodeartifact.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add an external connection to a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssociateExternalConnection.html
     *
     * @experimental
     */
    toAssociateExternalConnection(): this;
    /**
     * (experimental) Grants permission to associate an existing repository as an upstream repository to another repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/repos-upstream.html
     *
     * @experimental
     */
    toAssociateWithDownstreamRepository(): this;
    /**
     * (experimental) Grants permission to copy package versions from one repository to another repository in the same domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CopyPackageVersions.html
     *
     * @experimental
     */
    toCopyPackageVersions(): this;
    /**
     * (experimental) Grants permission to create a new domain.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CreateDomain.html
     *
     * @experimental
     */
    toCreateDomain(): this;
    /**
     * (experimental) Grants permission to create a new repository.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CreateRepository.html
     *
     * @experimental
     */
    toCreateRepository(): this;
    /**
     * (experimental) Grants permission to delete a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeleteDomain.html
     *
     * @experimental
     */
    toDeleteDomain(): this;
    /**
     * (experimental) Grants permission to delete the resource policy set on a domain.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeleteDomainPermissionsPolicy.html
     *
     * @experimental
     */
    toDeleteDomainPermissionsPolicy(): this;
    /**
     * (experimental) Grants permission to delete package versions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeletePackageVersions.html
     *
     * @experimental
     */
    toDeletePackageVersions(): this;
    /**
     * (experimental) Grants permission to delete a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeleteRepository.html
     *
     * @experimental
     */
    toDeleteRepository(): this;
    /**
     * (experimental) Grants permission to delete the resource policy set on a repository.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeleteRepositoryPermissionsPolicy.html
     *
     * @experimental
     */
    toDeleteRepositoryPermissionsPolicy(): this;
    /**
     * (experimental) Grants permission to return information about a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribeDomain.html
     *
     * @experimental
     */
    toDescribeDomain(): this;
    /**
     * (experimental) Grants permission to return information about a package version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html
     *
     * @experimental
     */
    toDescribePackageVersion(): this;
    /**
     * (experimental) Grants permission to return detailed information about a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribeRepository.html
     *
     * @experimental
     */
    toDescribeRepository(): this;
    /**
     * (experimental) Grants permission to disassociate an external connection from a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisassociateExternalConnection.html
     *
     * @experimental
     */
    toDisassociateExternalConnection(): this;
    /**
     * (experimental) Grants permission to set the status of package versions to Disposed and delete their assets.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html
     *
     * @experimental
     */
    toDisposePackageVersions(): this;
    /**
     * (experimental) Grants permission to generate a temporary authentication token for accessing repositories in a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_GetAuthorizationToken.html
     *
     * @experimental
     */
    toGetAuthorizationToken(): this;
    /**
     * (experimental) Grants permission to return a domain's resource policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_GetDomainPermissionsPolicy.html
     *
     * @experimental
     */
    toGetDomainPermissionsPolicy(): this;
    /**
     * (experimental) Grants permission to return an asset (or file) that is part of a package version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_GetPackageVersionAsset.html
     *
     * @experimental
     */
    toGetPackageVersionAsset(): this;
    /**
     * (experimental) Grants permission to return a package version's readme file.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_GetPackageVersionReadme.html
     *
     * @experimental
     */
    toGetPackageVersionReadme(): this;
    /**
     * (experimental) Grants permission to return an endpoint for a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_GetRepositoryEndpoint.html
     *
     * @experimental
     */
    toGetRepositoryEndpoint(): this;
    /**
     * (experimental) Grants permission to return a repository's resource policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_GetRepositoryPermissionsPolicy.html
     *
     * @experimental
     */
    toGetRepositoryPermissionsPolicy(): this;
    /**
     * (experimental) Grants permission to list the domains in the current user's AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListDomains.html
     *
     * @experimental
     */
    toListDomains(): this;
    /**
     * (experimental) Grants permission to list a package version's assets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersionAssets.html
     *
     * @experimental
     */
    toListPackageVersionAssets(): this;
    /**
     * (experimental) Grants permission to list the direct dependencies of a package version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersionDependencies.html
     *
     * @experimental
     */
    toListPackageVersionDependencies(): this;
    /**
     * (experimental) Grants permission to list a package's versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html
     *
     * @experimental
     */
    toListPackageVersions(): this;
    /**
     * (experimental) Grants permission to list the packages in a repository.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackages.html
     *
     * @experimental
     */
    toListPackages(): this;
    /**
     * (experimental) Grants permission to list the repositories administered by the calling account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html
     *
     * @experimental
     */
    toListRepositories(): this;
    /**
     * (experimental) Grants permission to list the repositories in a domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositoriesInDomain.html
     *
     * @experimental
     */
    toListRepositoriesInDomain(): this;
    /**
     * (experimental) Grants permission to list tags for a CodeArtifact resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to publish assets and metadata to a repository endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/repo-policies.html
     *
     * @experimental
     */
    toPublishPackageVersion(): this;
    /**
     * (experimental) Grants permission to attach a resource policy to a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PutDomainPermissionsPolicy.html
     *
     * @experimental
     */
    toPutDomainPermissionsPolicy(): this;
    /**
     * (experimental) Grants permission to add, modify or remove package metadata using a repository endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/repo-policies.html
     *
     * @experimental
     */
    toPutPackageMetadata(): this;
    /**
     * (experimental) Grants permission to attach a resource policy to a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PutRepositoryPermissionsPolicy.html
     *
     * @experimental
     */
    toPutRepositoryPermissionsPolicy(): this;
    /**
     * (experimental) Grants permission to return package assets and metadata from a repository endpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/repo-policies.html
     *
     * @experimental
     */
    toReadFromRepository(): this;
    /**
     * (experimental) Grants permission to tag a CodeArtifact resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove a tag from a CodeArtifact resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to modify the status of one or more versions of a package.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html
     *
     * @experimental
     */
    toUpdatePackageVersionsStatus(): this;
    /**
     * (experimental) Grants permission to modify the properties of a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdateRepository.html
     *
     * @experimental
     */
    toUpdateRepository(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type domain to the statement.
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDomain(domainName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type repository to the statement.
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/repo-policies.html
     *
     * @param domainName - Identifier for the domainName.
     * @param repositoryName - Identifier for the repositoryName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRepository(domainName: string, repositoryName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type package to the statement.
     *
     * https://docs.aws.amazon.com/codeartifact/latest/userguide/repo-policies.html
     *
     * @param domainName - Identifier for the domainName.
     * @param repositoryName - Identifier for the repositoryName.
     * @param packageFormat - Identifier for the packageFormat.
     * @param packageNamespace - Identifier for the packageNamespace.
     * @param packageName - Identifier for the packageName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPackage(domainName: string, repositoryName: string, packageFormat: string, packageNamespace: string, packageName: string, account?: string, region?: string, partition?: string): this;
}
