"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Glacier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [glacier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonglacier.html).
 *
 * @experimental
 */
class Glacier extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [glacier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonglacier.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'glacier';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AbortMultipartUpload',
                'CompleteMultipartUpload',
                'CreateVault',
                'DeleteArchive',
                'DeleteVault',
                'DeleteVaultNotifications',
                'InitiateJob',
                'InitiateMultipartUpload',
                'PurchaseProvisionedCapacity',
                'SetVaultNotifications',
                'UploadArchive',
                'UploadMultipartPart'
            ],
            'Permissions management': [
                'AbortVaultLock',
                'CompleteVaultLock',
                'DeleteVaultAccessPolicy',
                'InitiateVaultLock',
                'SetDataRetrievalPolicy',
                'SetVaultAccessPolicy'
            ],
            Tagging: [
                'AddTagsToVault',
                'RemoveTagsFromVault'
            ],
            Read: [
                'DescribeJob',
                'DescribeVault',
                'GetDataRetrievalPolicy',
                'GetJobOutput',
                'GetVaultAccessPolicy',
                'GetVaultLock',
                'GetVaultNotifications'
            ],
            List: [
                'ListJobs',
                'ListMultipartUploads',
                'ListParts',
                'ListProvisionedCapacity',
                'ListTagsForVault',
                'ListVaults'
            ]
        };
    }
    /**
     * (experimental) Aborts a multipart upload identified by the upload ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html
     *
     * @experimental
     */
    toAbortMultipartUpload() {
        return this.to('AbortMultipartUpload');
    }
    /**
     * (experimental) Aborts the vault locking process if the vault lock is not in the Locked state.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-AbortVaultLock.html
     *
     * @experimental
     */
    toAbortVaultLock() {
        return this.to('AbortVaultLock');
    }
    /**
     * (experimental) Adds the specified tags to a vault.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-AddTagsToVault.html
     *
     * @experimental
     */
    toAddTagsToVault() {
        return this.to('AddTagsToVault');
    }
    /**
     * (experimental) Completes a multipart upload process.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html
     *
     * @experimental
     */
    toCompleteMultipartUpload() {
        return this.to('CompleteMultipartUpload');
    }
    /**
     * (experimental) Completes the vault locking process.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-CompleteVaultLock.html
     *
     * @experimental
     */
    toCompleteVaultLock() {
        return this.to('CompleteVaultLock');
    }
    /**
     * (experimental) Creates a new vault with the specified name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html
     *
     * @experimental
     */
    toCreateVault() {
        return this.to('CreateVault');
    }
    /**
     * (experimental) Deletes an archive from a vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifArchiveAgeInDays()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html
     *
     * @experimental
     */
    toDeleteArchive() {
        return this.to('DeleteArchive');
    }
    /**
     * (experimental) Deletes a vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html
     *
     * @experimental
     */
    toDeleteVault() {
        return this.to('DeleteVault');
    }
    /**
     * (experimental) Deletes the access policy associated with the specified vault.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-DeleteVaultAccessPolicy.html
     *
     * @experimental
     */
    toDeleteVaultAccessPolicy() {
        return this.to('DeleteVaultAccessPolicy');
    }
    /**
     * (experimental) Deletes the notification configuration set for a vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html
     *
     * @experimental
     */
    toDeleteVaultNotifications() {
        return this.to('DeleteVaultNotifications');
    }
    /**
     * (experimental) Returns information about a job you previously initiated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html
     *
     * @experimental
     */
    toDescribeJob() {
        return this.to('DescribeJob');
    }
    /**
     * (experimental) Returns information about a vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get..html
     *
     * @experimental
     */
    toDescribeVault() {
        return this.to('DescribeVault');
    }
    /**
     * (experimental) Returns the current data retrieval policy for the account and region specified in the GET request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetDataRetrievalPolicy.html
     *
     * @experimental
     */
    toGetDataRetrievalPolicy() {
        return this.to('GetDataRetrievalPolicy');
    }
    /**
     * (experimental) Downloads the output of the job you initiated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html
     *
     * @experimental
     */
    toGetJobOutput() {
        return this.to('GetJobOutput');
    }
    /**
     * (experimental) Retrieves the access-policy subresource set on the vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetVaultAccessPolicy.html
     *
     * @experimental
     */
    toGetVaultAccessPolicy() {
        return this.to('GetVaultAccessPolicy');
    }
    /**
     * (experimental) Retrieves attributes from the lock-policy subresource set on the specified vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetVaultLock.html
     *
     * @experimental
     */
    toGetVaultLock() {
        return this.to('GetVaultLock');
    }
    /**
     * (experimental) Retrieves the notification-configuration subresource set on the vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html
     *
     * @experimental
     */
    toGetVaultNotifications() {
        return this.to('GetVaultNotifications');
    }
    /**
     * (experimental) Initiates a job of the specified type.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifArchiveAgeInDays()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html
     *
     * @experimental
     */
    toInitiateJob() {
        return this.to('InitiateJob');
    }
    /**
     * (experimental) Initiates a multipart upload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html
     *
     * @experimental
     */
    toInitiateMultipartUpload() {
        return this.to('InitiateMultipartUpload');
    }
    /**
     * (experimental) Initiates the vault locking process.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-InitiateVaultLock.html
     *
     * @experimental
     */
    toInitiateVaultLock() {
        return this.to('InitiateVaultLock');
    }
    /**
     * (experimental) Lists jobs for a vault that are in-progress and jobs that have recently finished.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html
     *
     * @experimental
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * (experimental) Lists in-progress multipart uploads for the specified vault.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html
     *
     * @experimental
     */
    toListMultipartUploads() {
        return this.to('ListMultipartUploads');
    }
    /**
     * (experimental) Lists the parts of an archive that have been uploaded in a specific multipart upload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html
     *
     * @experimental
     */
    toListParts() {
        return this.to('ListParts');
    }
    /**
     * (experimental) This operation lists the provisioned capacity for the specified AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-ListProvisionedCapacity.html
     *
     * @experimental
     */
    toListProvisionedCapacity() {
        return this.to('ListProvisionedCapacity');
    }
    /**
     * (experimental) Lists all the tags attached to a vault.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-ListTagsForVault.html
     *
     * @experimental
     */
    toListTagsForVault() {
        return this.to('ListTagsForVault');
    }
    /**
     * (experimental) Lists all vaults.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html
     *
     * @experimental
     */
    toListVaults() {
        return this.to('ListVaults');
    }
    /**
     * (experimental) This operation purchases a provisioned capacity unit for an AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-PurchaseProvisionedCapacity.html
     *
     * @experimental
     */
    toPurchaseProvisionedCapacity() {
        return this.to('PurchaseProvisionedCapacity');
    }
    /**
     * (experimental) Removes one or more tags from the set of tags attached to a vault.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-RemoveTagsFromVault.html
     *
     * @experimental
     */
    toRemoveTagsFromVault() {
        return this.to('RemoveTagsFromVault');
    }
    /**
     * (experimental) Sets and then enacts a data retrieval policy in the region specified in the PUT request.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetDataRetrievalPolicy.html
     *
     * @experimental
     */
    toSetDataRetrievalPolicy() {
        return this.to('SetDataRetrievalPolicy');
    }
    /**
     * (experimental) Configures an access policy for a vault and will overwrite an existing policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html
     *
     * @experimental
     */
    toSetVaultAccessPolicy() {
        return this.to('SetVaultAccessPolicy');
    }
    /**
     * (experimental) Configures vault notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html
     *
     * @experimental
     */
    toSetVaultNotifications() {
        return this.to('SetVaultNotifications');
    }
    /**
     * (experimental) Adds an archive to a vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html
     *
     * @experimental
     */
    toUploadArchive() {
        return this.to('UploadArchive');
    }
    /**
     * (experimental) Uploads a part of an archive.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html
     *
     * @experimental
     */
    toUploadMultipartPart() {
        return this.to('UploadMultipartPart');
    }
    /**
     * (experimental) Adds a resource of type vault to the statement.
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-vaults.html
     *
     * @param vaultName - Identifier for the vaultName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVault(vaultName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:glacier:${region || '*'}:${account || '*'}:vaults/${vaultName}`);
    }
    /**
     * (experimental) How long an archive has been stored in the vault, in days.
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/access-control-overview.html#specifying-conditions
     *
     * Applies to actions:
     * - .toDeleteArchive()
     * - .toInitiateJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifArchiveAgeInDays(value, operator) {
        return this.if(`ArchiveAgeInDays`, value, operator || 'StringLike');
    }
    /**
     * (experimental) A customer-defined tag.
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/access-control-overview.html#specifying-conditions
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTagExists(value, operator) {
        return this.if(`ResourceTag/`, value, operator || 'StringLike');
    }
}
exports.Glacier = Glacier;
_a = JSII_RTTI_SYMBOL_1;
Glacier[_a] = { fqn: "iam-floyd.Glacier", version: "0.273.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xhY2llci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdsYWNpZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBc0Q7Ozs7OztBQUd0RCxNQUFhLE9BQVEsU0FBUSx3QkFBZTs7Ozs7OztJQUkxQyxZQUFZLEdBQVk7UUFDdEIsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDOzs7Ozs7UUFKTixrQkFBYSxHQUFHLFNBQVMsQ0FBQzs7OztRQTRLdkIsb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLHNCQUFzQjtnQkFDdEIseUJBQXlCO2dCQUN6QixhQUFhO2dCQUNiLGVBQWU7Z0JBQ2YsYUFBYTtnQkFDYiwwQkFBMEI7Z0JBQzFCLGFBQWE7Z0JBQ2IseUJBQXlCO2dCQUN6Qiw2QkFBNkI7Z0JBQzdCLHVCQUF1QjtnQkFDdkIsZUFBZTtnQkFDZixxQkFBcUI7YUFDdEI7WUFDRCx3QkFBd0IsRUFBRTtnQkFDeEIsZ0JBQWdCO2dCQUNoQixtQkFBbUI7Z0JBQ25CLHlCQUF5QjtnQkFDekIsbUJBQW1CO2dCQUNuQix3QkFBd0I7Z0JBQ3hCLHNCQUFzQjthQUN2QjtZQUNELE9BQU8sRUFBRTtnQkFDUCxnQkFBZ0I7Z0JBQ2hCLHFCQUFxQjthQUN0QjtZQUNELElBQUksRUFBRTtnQkFDSixhQUFhO2dCQUNiLGVBQWU7Z0JBQ2Ysd0JBQXdCO2dCQUN4QixjQUFjO2dCQUNkLHNCQUFzQjtnQkFDdEIsY0FBYztnQkFDZCx1QkFBdUI7YUFDeEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osVUFBVTtnQkFDVixzQkFBc0I7Z0JBQ3RCLFdBQVc7Z0JBQ1gseUJBQXlCO2dCQUN6QixrQkFBa0I7Z0JBQ2xCLFlBQVk7YUFDYjtTQUNGLENBQUM7SUFuTkYsQ0FBQzs7Ozs7Ozs7OztJQUdNLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7Ozs7Ozs7O0lBR00sZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7Ozs7Ozs7Ozs7SUFHTSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7Ozs7O0lBR00sbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDOzs7Ozs7Ozs7Ozs7O0lBR00sZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDOzs7Ozs7Ozs7O0lBR00sYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQzs7Ozs7Ozs7Ozs7OztJQUdNLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDOzs7Ozs7Ozs7O0lBR00sVUFBVTtRQUNmLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QixDQUFDOzs7Ozs7Ozs7O0lBR00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDOzs7Ozs7Ozs7O0lBR00seUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7OztJQUdNLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7Ozs7Ozs7Ozs7SUFHTSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7OztJQUdNLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDOzs7Ozs7Ozs7O0lBR00sd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7Ozs7Ozs7O0lBR00sZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDOzs7Ozs7Ozs7Ozs7SUFpRE0sT0FBTyxDQUFDLFNBQWlCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDckYsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sWUFBYSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLFdBQVksU0FBVSxFQUFFLENBQUMsQ0FBQztJQUNySCxDQUFDOzs7Ozs7Ozs7Ozs7OztJQUdNLGtCQUFrQixDQUFDLEtBQXdCLEVBQUUsUUFBNEI7UUFDOUUsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixFQUFFLEtBQUssRUFBRSxRQUFRLElBQUksWUFBWSxDQUFDLENBQUM7SUFDdEUsQ0FBQzs7Ozs7Ozs7OztJQUdNLG1CQUFtQixDQUFDLEtBQXdCLEVBQUUsUUFBNEI7UUFDL0UsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxLQUFLLEVBQUUsUUFBUSxJQUFJLFlBQVksQ0FBQyxDQUFDO0lBQ2xFLENBQUM7O0FBeE9ILDBCQXlPQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBHbGFjaWVyIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnZ2xhY2llcic7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Fib3J0TXVsdGlwYXJ0VXBsb2FkKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBYm9ydE11bHRpcGFydFVwbG9hZCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9BYm9ydFZhdWx0TG9jaygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQWJvcnRWYXVsdExvY2snKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9BZGRUYWdzVG9WYXVsdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQWRkVGFnc1RvVmF1bHQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NvbXBsZXRlTXVsdGlwYXJ0VXBsb2FkKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDb21wbGV0ZU11bHRpcGFydFVwbG9hZCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9Db21wbGV0ZVZhdWx0TG9jaygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ29tcGxldGVWYXVsdExvY2snKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZVZhdWx0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVWYXVsdCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWxldGVBcmNoaXZlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVBcmNoaXZlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVZhdWx0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVWYXVsdCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVZhdWx0QWNjZXNzUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVWYXVsdEFjY2Vzc1BvbGljeScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVZhdWx0Tm90aWZpY2F0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlVmF1bHROb3RpZmljYXRpb25zJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVKb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlSm9iJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlVmF1bHQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlVmF1bHQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldERhdGFSZXRyaWV2YWxQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldERhdGFSZXRyaWV2YWxQb2xpY3knKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldEpvYk91dHB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0Sm9iT3V0cHV0Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldFZhdWx0QWNjZXNzUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRWYXVsdEFjY2Vzc1BvbGljeScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0VmF1bHRMb2NrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRWYXVsdExvY2snKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldFZhdWx0Tm90aWZpY2F0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0VmF1bHROb3RpZmljYXRpb25zJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0luaXRpYXRlSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbml0aWF0ZUpvYicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0luaXRpYXRlTXVsdGlwYXJ0VXBsb2FkKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbml0aWF0ZU11bHRpcGFydFVwbG9hZCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9Jbml0aWF0ZVZhdWx0TG9jaygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnSW5pdGlhdGVWYXVsdExvY2snKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdEpvYnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RKb2JzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdE11bHRpcGFydFVwbG9hZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RNdWx0aXBhcnRVcGxvYWRzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0UGFydHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RQYXJ0cycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RQcm92aXNpb25lZENhcGFjaXR5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UHJvdmlzaW9uZWRDYXBhY2l0eScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RUYWdzRm9yVmF1bHQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RUYWdzRm9yVmF1bHQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RWYXVsdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RWYXVsdHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvUHVyY2hhc2VQcm92aXNpb25lZENhcGFjaXR5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdQdXJjaGFzZVByb3Zpc2lvbmVkQ2FwYWNpdHknKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9SZW1vdmVUYWdzRnJvbVZhdWx0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSZW1vdmVUYWdzRnJvbVZhdWx0Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1NldERhdGFSZXRyaWV2YWxQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NldERhdGFSZXRyaWV2YWxQb2xpY3knKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2V0VmF1bHRBY2Nlc3NQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NldFZhdWx0QWNjZXNzUG9saWN5Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2V0VmF1bHROb3RpZmljYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTZXRWYXVsdE5vdGlmaWNhdGlvbnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGxvYWRBcmNoaXZlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGxvYWRBcmNoaXZlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1VwbG9hZE11bHRpcGFydFBhcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwbG9hZE11bHRpcGFydFBhcnQnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0Fib3J0TXVsdGlwYXJ0VXBsb2FkJyxcbiAgICAgICdDb21wbGV0ZU11bHRpcGFydFVwbG9hZCcsXG4gICAgICAnQ3JlYXRlVmF1bHQnLFxuICAgICAgJ0RlbGV0ZUFyY2hpdmUnLFxuICAgICAgJ0RlbGV0ZVZhdWx0JyxcbiAgICAgICdEZWxldGVWYXVsdE5vdGlmaWNhdGlvbnMnLFxuICAgICAgJ0luaXRpYXRlSm9iJyxcbiAgICAgICdJbml0aWF0ZU11bHRpcGFydFVwbG9hZCcsXG4gICAgICAnUHVyY2hhc2VQcm92aXNpb25lZENhcGFjaXR5JyxcbiAgICAgICdTZXRWYXVsdE5vdGlmaWNhdGlvbnMnLFxuICAgICAgJ1VwbG9hZEFyY2hpdmUnLFxuICAgICAgJ1VwbG9hZE11bHRpcGFydFBhcnQnXG4gICAgXSxcbiAgICAnUGVybWlzc2lvbnMgbWFuYWdlbWVudCc6IFtcbiAgICAgICdBYm9ydFZhdWx0TG9jaycsXG4gICAgICAnQ29tcGxldGVWYXVsdExvY2snLFxuICAgICAgJ0RlbGV0ZVZhdWx0QWNjZXNzUG9saWN5JyxcbiAgICAgICdJbml0aWF0ZVZhdWx0TG9jaycsXG4gICAgICAnU2V0RGF0YVJldHJpZXZhbFBvbGljeScsXG4gICAgICAnU2V0VmF1bHRBY2Nlc3NQb2xpY3knXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnQWRkVGFnc1RvVmF1bHQnLFxuICAgICAgJ1JlbW92ZVRhZ3NGcm9tVmF1bHQnXG4gICAgXSxcbiAgICBSZWFkOiBbXG4gICAgICAnRGVzY3JpYmVKb2InLFxuICAgICAgJ0Rlc2NyaWJlVmF1bHQnLFxuICAgICAgJ0dldERhdGFSZXRyaWV2YWxQb2xpY3knLFxuICAgICAgJ0dldEpvYk91dHB1dCcsXG4gICAgICAnR2V0VmF1bHRBY2Nlc3NQb2xpY3knLFxuICAgICAgJ0dldFZhdWx0TG9jaycsXG4gICAgICAnR2V0VmF1bHROb3RpZmljYXRpb25zJ1xuICAgIF0sXG4gICAgTGlzdDogW1xuICAgICAgJ0xpc3RKb2JzJyxcbiAgICAgICdMaXN0TXVsdGlwYXJ0VXBsb2FkcycsXG4gICAgICAnTGlzdFBhcnRzJyxcbiAgICAgICdMaXN0UHJvdmlzaW9uZWRDYXBhY2l0eScsXG4gICAgICAnTGlzdFRhZ3NGb3JWYXVsdCcsXG4gICAgICAnTGlzdFZhdWx0cydcbiAgICBdXG4gIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgb25WYXVsdCh2YXVsdE5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCAnYXdzJyB9OmdsYWNpZXI6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06dmF1bHRzLyR7IHZhdWx0TmFtZSB9YCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBpZkFyY2hpdmVBZ2VJbkRheXModmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYEFyY2hpdmVBZ2VJbkRheXNgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgaWZSZXNvdXJjZVRhZ0V4aXN0cyh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgUmVzb3VyY2VUYWcvYCwgdmFsdWUsIG9wZXJhdG9yIHx8ICdTdHJpbmdMaWtlJyk7XG4gIH1cbn1cbiJdfQ==