import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [groundstation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsgroundstation.html).
 *
 * @experimental
 */
export declare class Groundstation extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [groundstation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsgroundstation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel a contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CancelContact.html
     *
     * @experimental
     */
    toCancelContact(): this;
    /**
     * (experimental) Grants permission to create a configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateConfig.html
     *
     * @experimental
     */
    toCreateConfig(): this;
    /**
     * (experimental) Grants permission to create a data flow endpoint group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateDataflowEndpointGroup.html
     *
     * @experimental
     */
    toCreateDataflowEndpointGroup(): this;
    /**
     * (experimental) Grants permission to create a mission profile.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateMissionProfile.html
     *
     * @experimental
     */
    toCreateMissionProfile(): this;
    /**
     * (experimental) Grants permission to delete a config.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_DeleteConfig.html
     *
     * @experimental
     */
    toDeleteConfig(): this;
    /**
     * (experimental) Grants permission to delete a data flow endpoint group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_DeleteDataflowEndpointGroup.html
     *
     * @experimental
     */
    toDeleteDataflowEndpointGroup(): this;
    /**
     * (experimental) Grants permission to delete a mission profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_DeleteMissionProfile.html
     *
     * @experimental
     */
    toDeleteMissionProfile(): this;
    /**
     * (experimental) Grants permission to describe a contact.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_DescribeContact.html
     *
     * @experimental
     */
    toDescribeContact(): this;
    /**
     * (experimental) Grants permission to return a configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GetConfig.html
     *
     * @experimental
     */
    toGetConfig(): this;
    /**
     * (experimental) Grants permission to return a data flow endpoint group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GetDataflowEndpointGroup.html
     *
     * @experimental
     */
    toGetDataflowEndpointGroup(): this;
    /**
     * (experimental) Grants permission to return minutes usage.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GetMinuteUsage.html
     *
     * @experimental
     */
    toGetMinuteUsage(): this;
    /**
     * (experimental) Grants permission to retrieve a mission profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GetMissionProfile.html
     *
     * @experimental
     */
    toGetMissionProfile(): this;
    /**
     * (experimental) Grants permission to return information about a satellite.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GetSatellite.html
     *
     * @experimental
     */
    toGetSatellite(): this;
    /**
     * (experimental) Grants permission to return a list of past configurations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListConfigs.html
     *
     * @experimental
     */
    toListConfigs(): this;
    /**
     * (experimental) Grants permission to return a list of contacts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListContacts.html
     *
     * @experimental
     */
    toListContacts(): this;
    /**
     * (experimental) Grants permission to list data flow endpoint groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListDataflowEndpointGroups.html
     *
     * @experimental
     */
    toListDataflowEndpointGroups(): this;
    /**
     * (experimental) Grants permission to list ground stations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListGroundStations.html
     *
     * @experimental
     */
    toListGroundStations(): this;
    /**
     * (experimental) Grants permission to return a list of mission profiles.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListMissionProfiles.html
     *
     * @experimental
     */
    toListMissionProfiles(): this;
    /**
     * (experimental) Grants permission to list satellites.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListSatellites.html
     *
     * @experimental
     */
    toListSatellites(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to reserve a contact.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ReserveContact.html
     *
     * @experimental
     */
    toReserveContact(): this;
    /**
     * (experimental) Grants permission to assign a resource tag.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to deassign a resource tag.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_UpdateConfig.html
     *
     * @experimental
     */
    toUpdateConfig(): this;
    /**
     * (experimental) Grants permission to update a mission profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_UpdateMissionProfile.html
     *
     * @experimental
     */
    toUpdateMissionProfile(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Config to the statement.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ConfigListItem.html
     *
     * @param configType - Identifier for the configType.
     * @param configId - Identifier for the configId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConfig(configType: string, configId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Contact to the statement.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ContactData.html
     *
     * @param contactId - Identifier for the contactId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onContact(contactId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type DataflowEndpointGroup to the statement.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_DataflowEndpoint.html
     *
     * @param dataflowEndpointGroupId - Identifier for the dataflowEndpointGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDataflowEndpointGroup(dataflowEndpointGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type GroundStationResource to the statement.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GroundStationData.html
     *
     * @param groundStationId - Identifier for the groundStationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGroundStationResource(groundStationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type MissionProfile to the statement.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_MissionProfileListItem.html
     *
     * @param missionProfileId - Identifier for the missionProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMissionProfile(missionProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Satellite to the statement.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_SatelliteListItem.html
     *
     * @param satelliteId - Identifier for the satelliteId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSatellite(satelliteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the ID of a config.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateConfig.html#groundstation-CreateConfig-response-configId
     *
     * Applies to resource types:
     * - Config
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifConfigId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the type of a config.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateConfig.html#groundstation-CreateConfig-response-configType
     *
     * Applies to resource types:
     * - Config
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifConfigType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of a contact.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_ReserveContact.html#groundstation-ReserveContact-response-contactId
     *
     * Applies to resource types:
     * - Contact
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifContactId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of a dataflow endpoint group.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateDataflowEndpointGroup.html#groundstation-CreateDataflowEndpointGroup-response-dataflowEndpointGroupId
     *
     * Applies to resource types:
     * - DataflowEndpointGroup
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifDataflowEndpointGroupId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of a ground station.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_GroundStationData.html#groundstation-Type-GroundStationData-groundStationId
     *
     * Applies to resource types:
     * - GroundStationResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifGroundStationId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of a mission profile.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_CreateMissionProfile.html#groundstation-CreateMissionProfile-response-missionProfileId
     *
     * Applies to resource types:
     * - MissionProfile
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifMissionProfileId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of a satellite.
     *
     * https://docs.aws.amazon.com/ground-station/latest/APIReference/API_SatelliteListItem.html#groundstation-Type-SatelliteListItem-satelliteId
     *
     * Applies to resource types:
     * - Satellite
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifSatelliteId(value: string | string[], operator?: Operator | string): this;
}
