from .__info__ import __authors__, __version__
from .analysis import DataAnalyzer
from .core import MadMiner
from .delphes import DelphesReader
from .fisherinformation import FisherInformation, InformationGeometry, profile_information, project_information
from .lhe import LHEReader
from .likelihood import HistoLikelihood, NeuralLikelihood, fix_params, project_log_likelihood, profile_log_likelihood
from .limits import AsymptoticLimits
from .ml import (
    ParameterizedRatioEstimator,
    DoubleParameterizedRatioEstimator,
    LikelihoodEstimator,
    ScoreEstimator,
    MorphingAwareRatioEstimator,
    Ensemble,
    load_estimator,
)
from .plotting import (
    plot_uncertainty,
    plot_systematics,
    plot_pvalue_limits,
    plot_distribution_of_information,
    plot_fisher_information_contours_2d,
    plot_fisherinfo_barplot,
    plot_nd_morphing_basis_slices,
    plot_nd_morphing_basis_scatter,
    plot_2d_morphing_basis,
    plot_histograms,
    plot_distributions,
)
from .sampling import (
    SampleAugmenter,
    combine_and_shuffle,
    benchmark,
    benchmarks,
    morphing_point,
    morphing_points,
    random_morphing_points,
    iid_nuisance_parameters,
    nominal_nuisance_parameters,
)


import logging

logging.getLogger("madminer").addHandler(logging.NullHandler())
logger = logging.getLogger(__name__)

logger.info("")
logger.info("|{}|".format("-" * 74))
logger.info("|{}|".format(" " * 74))
logger.info("|{}|".format(" MadMiner v{}".format(__version__).ljust(74)))
logger.info("|{}|".format(" " * 74))
logger.info("|{}|".format(" {}".format(__authors__).ljust(74)))
logger.info("|{}|".format(" " * 74))
logger.info("|{}|".format("-" * 74))
logger.info("")
