# pylint: disable=duplicate-code
# -*- coding: utf-8 -*-
#
#       ramstk.models.failure_definition.record.py is part of The RAMSTK Project
#
# All rights reserved.
# Copyright since 2007 Doyle "weibullguy" Rowland doyle.rowland <AT> reliaqual <DOT> com
"""Failure Definition Record Model."""

# Third Party Imports
from sqlalchemy import Column, ForeignKey, Integer, String

# RAMSTK Package Imports
from ramstk.db import RAMSTK_BASE
from ramstk.models import RAMSTKBaseRecord


class RAMSTKFailureDefinitionRecord(RAMSTK_BASE, RAMSTKBaseRecord):
    """Class representing ramstk_failure_definition table in RAMSTK Program db.

    This table shares a Many-to-One relationship with ramstk_revision.
    """

    __defaults__ = {"definition": "Failure Definition"}
    __tablename__ = "ramstk_failure_definition"
    __table_args__ = {"extend_existing": True}

    revision_id = Column(
        "fld_revision_id",
        Integer,
        ForeignKey("ramstk_revision.fld_revision_id", ondelete="CASCADE"),
        nullable=False,
    )
    definition_id = Column(
        "fld_definition_id",
        Integer,
        primary_key=True,
        autoincrement=True,
        nullable=False,
    )

    definition = Column("fld_definition", String, default=__defaults__["definition"])

    # Define the relationships to other tables in the RAMSTK Program database.

    def get_attributes(self):
        """Retrieve current values of the RAMSTKFailureDefinition attributes.

        :return: {revision_id, definition_id, definition} pairs.
        :rtype: (int, int, str)
        """
        _attributes = {
            "revision_id": self.revision_id,
            "definition_id": self.definition_id,
            "definition": self.definition,
        }

        return _attributes
