from copy import deepcopy

from spid_cie_oidc.entity.utils import exp_from_now, iat_now

TOKEN_REQUEST = {
    "client_id": "https://rp.cie.it",
    "client_assertion": "head.payload.verifysignature",
    "client_assertion_type": "urn:ietf:params:oauth:client-assertion-type:jwt-bearer",
}

TOKEN_AUTHN_CODE_REQUEST = deepcopy(TOKEN_REQUEST)
TOKEN_AUTHN_CODE_REQUEST["code"] = "usDwMnEzJPpG5oaV8x3j&"
TOKEN_AUTHN_CODE_REQUEST["code_verifier"] = "9g8S40MozM3NSqjHnhi7OnsE38jklFv2&"
TOKEN_AUTHN_CODE_REQUEST["grant_type"] = "authorization_code"

TOKEN_AUTHN_CODE_REQUEST_NO_CLIENT_ID = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_CLIENT_ID.pop("client_id")

TOKEN_AUTHN_CODE_REQUEST_NO_CLIENT_ASSERTION = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_CLIENT_ASSERTION.pop("client_assertion")

TOKEN_AUTHN_CODE_REQUEST_NO_CORRECT_CLIENT_ASSERTION = deepcopy(
    TOKEN_AUTHN_CODE_REQUEST
)
TOKEN_AUTHN_CODE_REQUEST_NO_CORRECT_CLIENT_ASSERTION["client_assertion"] = "head..sign"

TOKEN_AUTHN_CODE_REQUEST_NO_CLIENT_ASSERTION_TYPE = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_CLIENT_ASSERTION_TYPE.pop("client_assertion_type")

TOKEN_AUTHN_CODE_REQUEST_NO_CORRECT_CLIENT_ASSERTION_TYPE = deepcopy(
    TOKEN_AUTHN_CODE_REQUEST
)
TOKEN_AUTHN_CODE_REQUEST_NO_CORRECT_CLIENT_ASSERTION_TYPE[
    "client_assertion_type"
] = ":params:oauth:client-assertion-type:"

TOKEN_AUTHN_CODE_REQUEST_NO_CODE = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_CODE.pop("code")

TOKEN_AUTHN_CODE_REQUEST_NO_CODE_VERIFY = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_CODE_VERIFY.pop("code_verifier")

TOKEN_AUTHN_CODE_REQUEST_NO_GRANT_TYPE = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_GRANT_TYPE.pop("grant_type")

TOKEN_AUTHN_CODE_REQUEST_NO_CORRECT_GRANT_TYPE = deepcopy(TOKEN_AUTHN_CODE_REQUEST)
TOKEN_AUTHN_CODE_REQUEST_NO_CORRECT_GRANT_TYPE["grant_type"] = "refresh_token"

TOKEN_REFRESH_REQUEST = deepcopy(TOKEN_REQUEST)
TOKEN_REFRESH_REQUEST["grant_type"] = "refresh_token"
TOKEN_REFRESH_REQUEST["refresh_token"] = "8xLOxBtZp8"

TOKEN_REFRESH_REQUEST_NO_GRANT_TYPE = deepcopy(TOKEN_REFRESH_REQUEST)
TOKEN_REFRESH_REQUEST_NO_GRANT_TYPE.pop("grant_type")

TOKEN_REFRESH_REQUEST_NO_CORRECT_GRANT_TYPE = deepcopy(TOKEN_REFRESH_REQUEST)
TOKEN_REFRESH_REQUEST_NO_CORRECT_GRANT_TYPE["grant_type"] = "authorization_code"

# TODO: we need factory function to get fresh now
IAT = iat_now()
EXP = exp_from_now()

JWT_CLIENT_ASSERTION = {
    "iss": "https://rp.cie.it",
    "sub": "https://rp.cie.it",
    "iat": IAT,
    "exp": EXP,
    "aud": ["https://rp.spid.agid.gov.it/auth"],
    "jti": "a72d5df0-2415-4c7c-a44f-3988b354040b",
}


JWT_CLIENT_ASSERTION_NO_ISS = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_ISS.pop("iss")

JWT_CLIENT_ASSERTION_NO_CORRECT_ISS = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_CORRECT_ISS["iss"] = "https://idserve.i"

JWT_CLIENT_ASSERTION_NO_SUB = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_SUB.pop("sub")

JWT_CLIENT_ASSERTION_NO_CORRECT_SUB = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_CORRECT_SUB["sub"] = "https://idserver"

JWT_CLIENT_ASSERTION_NO_IAT = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_IAT.pop("iat")

JWT_CLIENT_ASSERTION_NO_CORRECT_IAT = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_CORRECT_IAT["iat"] = str(IAT + 400)

JWT_CLIENT_ASSERTION_NO_EXP = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_EXP.pop("exp")

JWT_CLIENT_ASSERTION_NO_CORRECT_EXP = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_CORRECT_EXP["exp"] = 1000

JWT_CLIENT_ASSERTION_NO_JTI = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_JTI.pop("jti")

JWT_CLIENT_ASSERTION_NO_CORRECT_JTI = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_CORRECT_JTI["jti"] = []

JWT_CLIENT_ASSERTION_NO_AUD = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_AUD.pop("aud")

JWT_CLIENT_ASSERTION_NO_CORRECT_AUD = deepcopy(JWT_CLIENT_ASSERTION)
JWT_CLIENT_ASSERTION_NO_CORRECT_AUD["aud"] = "https://rp.spid.agid.gov.it/auth"
