# Python 3.5
# Script for VESIcal python library
# Copyright Kayla Iacovino, Simon Matthews, and Penny Weiser
# This script contains pandas dataframes with calibration data for all VESIcal models

import pandas as pd

model_names = ['Shishkina'       
			   'Dixon'              
			   'IaconoMarziano'     
			   'Liu'				
			   'ShishkinaCarbon'    
			   'ShishkinaWater'     
			   'DixonCarbon'        
			   'DixonWater'         
			   'IaconoMarzianoCarbon'
			   'IaconoMarzianoWater' 
			   #'EguchiCarbon'       
			   'AllisonCarbon'       
			   'MooreWater'          
			   'LiuWater'			
			   'LiuCarbon',
			   'MagmaSat']			

# These hard-coded pandas DataFrames are generated in the 'Calibration_Ploting.ipynb' from PEW's Excel spreadsheet.
"""
The code to generate these:
#CO2 only
df_Eguchi_CO2= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Eguchi_CO2', index_col=0)
df_Allison_CO2= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Allison_CO2', index_col=0)
df_Dixon_CO2= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Dixon_CO2', index_col=0)
df_MagmaSat_CO2= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='MagmaSat_CO2', index_col=0)
df_Shishkina_CO2=pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Shishkina_CO2', index_col=0)

#H2O Only
df_Iacono_H2O= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Iacono_H2O', index_col=0)
df_Shishkina_H2O=pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Shishkina_H2O', index_col=0)
df_MagmaSat_H2O= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='MagmSat_H2OExt', index_col=0)
df_Dixon_H2O=pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Dixon_H2O', index_col=0)
df_Moore_H2O=pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Moore_H2O', index_col=0)

#Mixed CO2-H2O
df_Iacono_CO2H2O= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='Iacono_H2O-CO2', index_col=0)
df_MagmaSat_CO2H2O= pd.read_excel('Solubility_Datasets_V1.xlsx', sheet_name='MagmaSat_CO2H2O', index_col=0)

import math
f= open("hard_coded_calibrations.py","w+")
list_of_models=[df_Eguchi_CO2,
df_Allison_CO2,
df_Dixon_CO2,
df_MagmaSat_CO2,
df_Shishkina_CO2,
df_Iacono_H2O,
df_Shishkina_H2O,
df_MagmaSat_H2O,
df_Dixon_H2O,
df_Moore_H2O,
df_Iacono_CO2H2O,
df_MagmaSat_CO2H2O]

list_of_modelnames=['df_Eguchi_CO2',
'df_Allison_CO2',
'df_Dixon_CO2',
'df_MagmaSat_CO2',
'df_Shishkina_CO2',
'df_Iacono_H2O',
'df_Shishkina_H2O',
'df_MagmaSat_H2O',
'df_Dixon_H2O',
'df_Moore_H2O',
'df_Iacono_CO2H2O',
'df_MagmaSat_CO2H2O']

for i in range(len(list_of_models)):
	current = list_of_models[i]
	oxides = ['SiO2', 'TiO2', 'Al2O3', 'Fe2O3', 'Cr2O3', 'FeO', 'MnO', 'MgO', 'NiO', 'CoO', 'CaO', 'Na2O', 'K2O', 'P2O5',
			  'H2O', 'CO2', 'Na2O+K2O']

	f.write("\n")
	f.write(str(list_of_modelnames[i])+" = pd.DataFrame({ \n")
	for oxide in oxides:
		iterno = 1
		if oxide in current.columns.values:
			f.write("'" + (str(oxide)+"': ["))
			for index, row in current.iterrows():
				if math.isnan(row[oxide]):
					f.write("float('nan')")
				else:
					f.write(str(row[oxide]))
				if iterno < len(current.index):
					f.write(",")
				iterno += 1
			f.write("], \n")
	f.write(" }) \n")
"""
df_Eguchi_CO2 = pd.DataFrame({ 
'SiO2': [44.10437603256261,44.10437603256261,44.10438088624972,44.104409634992706,44.10440889218369,44.10436830013397,44.1043908020398,44.10439205840465,44.10437458664902,44.104388016125164,44.10447339134081,44.10442257149313,44.10439334203017,44.104402908626135,44.104425065494524,44.10441928699617,49.984948661156025,49.98499547623014,49.985029494522195,49.985031104485095,49.9849724794392,60.38457666364644,60.06856912372693,49.0716670160065,49.071645200314904,49.071672361546916,49.07162501392976,49.071691233246476,49.071655338090046,49.07171166635172,49.07161924790047,49.07160094364064,51.59093897447411,51.5909788127466,51.59095838098362,51.59099133547149,51.59100608163437,51.59095482119933,60.86363920223774,60.862118521429586,60.327879081134796,61.05994103109784,60.228427280402116,60.47698580099399,60.319480827024755,60.925128442593945,60.676923007691116,60.74231466084237,60.81293844084079,53.70694014420282,53.7011529445255,53.700006611804454,53.700006611804454,53.69779064013701,46.009076546324664,46.94337872454186,46.19147403334632,45.5331365691128,46.29926453155094,46.718172953814054,46.33633424705815,46.17411358425308,46.61310804908212,46.02227057679376,39.36064809475989,39.36061937169125,39.36059448345091,39.36063250847917,70.45563962403973,70.60153988170781,70.75487983697325,70.56116686712926,50.70163037927418,49.53836756003234,49.67254110627778,48.92225228928746,48.88581292600512,48.96852346436122,48.45841806843705,46.84110554778804,46.109654468263564,47.945539201443445,45.47202864851899,46.77080053524734,45.70582888892893,76.84189901373412,76.84190833699662,76.84187166776081,76.8418702682207,76.84185768068464,76.84191800075739,76.84189165812349,76.8418501683941,76.84187528983503,76.8418958389256,76.84186241566731,76.84191960932424,76.84191433100298,76.84188441598513,76.84190170839541,76.84191145437651], 
'TiO2': [2.690268213432,2.6902665836219954,2.6902701309802457,2.690274906342437,2.690271533761955,2.6902707150845067,2.690270432970082,2.690268523082201,2.690263723499102,2.6902733037622313,2.690270490949935,2.690267953545623,2.690264827804798,2.6902722286816454,2.6902722320815946,2.690265142530156,1.5807931813008906,1.5807880140550246,1.5807853249525181,1.580794637312985,1.5807922704215438,0.865800865800866,0.9276999092467481,2.2858822169731696,2.2858818846064337,2.285889808155342,2.285880041947775,2.2858833128219436,2.285886539454862,2.2858836036713224,2.285883189841385,2.2858876466189257,2.251347148681408,2.2513450154422125,2.251351047286928,2.251355539422762,2.251355654175135,2.251350303660984,5.752110903081306,5.720794903465135,5.6866937810054985,5.715813669073002,5.793253359398885,5.635850919640084,5.773919091975937,5.828564338063339,5.8130226682031125,5.6646116872430765,5.831824194271488,0.41803029763834665,0.4179852527186936,0.41797633018824815,0.41797633018824815,0.417959082076678,0.349537156310259,0.3391574323490062,0.36913272985611534,0.35947213080878526,0.5142165219223941,0.46738061490618577,0.4856642520012512,0.5245933590493919,0.36939066134419335,0.46637488510334335,2.8970980733565943,2.8970994429662817,2.8971022128255637,2.897102115371429,0.5199678201036143,0.5100111237913737,0.49996382021603475,0.5297084764812822,1.6037254402874543,1.515056714109641,1.2767239481131638,1.028365711387063,0.7697766043563179,1.0493255028077404,1.2962128289911146,0.5992465528501668,0.612075059313233,0.5780301819764979,0.49198557699824874,0.571495708045789,0.5366229627961853,0.08041007321690058,0.08041010590993206,0.08041008868107676,0.08041010276404402,0.08041010506177101,0.08041008979366979,0.08041008727729339,0.08041005363587471,0.08041012630129299,0.08041009960083902,0.0804100859710292,0.08041005072060478,0.08041011847243194,0.08041008559987275,0.0804100774481765,0.08041017271736982], 
'Al2O3': [12.801260981983829,12.801308029518763,12.80125461218185,12.80124534941731,12.801300814313873,12.801312577888954,12.801295585320169,12.801311603700288,12.80129779238513,12.801277634271816,12.801248531482972,12.801269867887925,12.801303593997382,12.801297324764718,12.801240256533797,12.801247682421222,14.327154140663575,14.327138961101024,14.327161449585162,14.32712119748842,14.32719045980049,18.46370683579986,18.221236260966016,13.306030896370014,13.306070774601142,13.306054992574332,13.306049395075409,13.306023969010234,13.306014046721337,13.306028752685512,13.306068899465428,13.306078138168784,10.98658941587768,10.986583036041798,10.986620619788935,10.986563283821415,10.986559789680452,10.98655632039697,13.189132803619064,12.842600803697243,13.193665736343455,13.080791883918666,13.122273441466106,13.464757661692076,13.128913109419083,12.669323606828106,12.916697191297057,13.173468729209686,12.725091324862783,16.591821575312473,16.590033721001486,16.589679581519277,16.589679581519277,16.588994995757673,7.510055472723279,7.551240479064638,7.731834206445659,7.38914935551392,9.928334384809299,9.993989744270568,9.941249893005203,10.016763761471408,7.397796758271548,9.7244124978995,9.79020599400708,9.790216205672051,9.790208991886233,9.790201872449169,15.829020369692723,15.760343746964804,15.828854548039658,15.391529316625933,15.738423575491788,15.648941060211422,13.265959773363342,10.992530565409284,8.997388882086833,11.092869601110399,10.17028527362259,8.689075016327418,8.875088360041879,10.920641652341692,10.823682693961473,11.184987428896157,10.670541221754915,12.624382697470981,12.62437279918979,12.62440761866925,12.624404366311637,12.62442597045107,12.624350210501184,12.62438931306306,12.62442247024945,12.624403989427751,12.624381917625325,12.624410784222379,12.624370053755962,12.6243579451528,12.624392063837183,12.624370720973454,12.624362048954701], 
'Fe2O3': [2.690268213432,2.6902665836219954,2.6902701309802457,2.690274906342437,2.690271533761955,2.6902707150845067,2.690270432970082,2.690268523082201,2.690263723499102,2.6902733037622313,2.690270490949935,2.690267953545623,2.690264827804798,2.6902722286816454,2.6902722320815946,2.690265142530156,1.3706895943810466,1.3706886608144353,1.3706829727196617,1.3706866137437732,1.3706832311167003,5.406221685291453,5.283856004840174,1.716913022043569,1.7169052574122723,1.716911945651357,1.7169092742809553,1.7169112185406363,1.7169063451004238,1.71690758947682,1.71691277048081,1.7169077472662067,1.6810090984496424,1.6810115384532773,1.681014041053261,1.6810095756266215,1.681005617117395,1.681013484039537,1.055512481019495,1.3926553365919638,1.3340140657792703,1.4313668803696702,1.5377086758869927,1.3146521439703067,1.3676930451525446,1.2324722667906367,0.8989653657417279,0.987854119349583,0.6127009573823089,5.678469053162345,5.792351464670604,5.814909375567489,5.814909375567489,5.858515992133967,0.15773780100695695,0.3197404485356566,0.2766852782682356,0.18918884700285665,1.4350183874816669,0.7190733768370382,1.1416675788236141,1.2906628821578894,0.21248521758172562,0.9823633187374728,1.198801855287382,1.1988063119937484,1.1988035652603102,1.1987971067208332,0.061940649005579516,0.07796627190890817,0.0724616518848846,0.05143396143821129,0.7144703159648002,1.047021206487892,0.9872061049566863,0.9372071967845106,0.8533515809874168,1.1197582345457264,1.0296978578594347,1.3217827786265184,0.957138681310875,6.086197698174137,7.117728885153587,6.554532671823017,7.130791697808797,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0], 
'FeO': [6.62066453508415,6.62065386994935,6.620663695117241,6.620664022554089,6.620664922788732,6.620658323427069,6.62066221038185,6.620659852957779,6.620655137693368,6.620668099934811,6.620665823429905,6.620669254478686,6.62065793341363,6.620667827234607,6.620664285378888,6.620655066656629,10.015054339609316,10.014989315130139,10.014955497452263,10.014962289603343,10.01501070543189,0.6141145676029398,0.6251890692749823,9.66261095267001,9.662597270294935,9.66261509749148,9.66260685497561,9.662601553154275,9.66260639172581,9.662622825932914,9.662597051947715,9.66259897585849,10.036029360735354,10.036013796140933,10.036021859483315,10.036027106058313,10.036023570774974,10.036025284972776,3.898672516579569,3.939984879509819,4.372768342698207,3.481596840386103,3.862039664417835,4.0972133950131,4.15267166878813,4.210713125014137,4.592340054909809,4.379809458471979,4.917859050907027,0.8917594246671696,0.7879445527013593,0.7673808273590452,0.7673808273590452,0.7276291637285043,23.09388944915473,21.424669646230424,22.44487889834071,24.331649020119155,20.2359610327629,20.810704660935045,20.27983875044335,20.436048752510185,21.127270978880475,22.05585776931505,10.289711345796759,10.289714185369855,10.289715051140067,10.289698845423631,0.22423046497055138,0.27986044461564885,0.2647504262507384,0.17347696851199676,4.506352265804591,6.0361453137089915,6.460282062683598,6.360116781575888,5.853722810529995,5.910002216688476,8.05592849028686,19.877295521576535,20.697253726595275,11.637399077992546,13.609786548724323,12.532900877444153,13.63476391086215,1.0252313393579953,1.0252254933919982,1.0252323456938446,1.0252294613971586,1.0252273867497153,1.0252252862361046,1.0252238037614918,1.0252276069003448,1.0252332027179658,1.0252315094241933,1.0252274130326264,1.0252257188087177,1.0252300624114146,1.0252310484228015,1.0252309457147883,1.0252320383166151], 
'MnO': [0.19001901523084572,0.19001911543045566,0.19001922247342398,0.19001867865608085,0.19001961304445167,0.19001948357803916,0.1900195357382036,0.19001873270712227,0.19001883790984817,0.1900188509632356,0.19001872739133158,0.19001936604825118,0.19001891859403217,0.19001914174121304,0.19001891944374172,0.19001871590402808,0.18008993193714057,0.18009030570086257,0.18009030328968412,0.18009016088407356,0.18009003060233353,0.060404711567502274,0.08066955732580418,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.32956360452110134,0.34913265094750634,0.33920304905697085,0.29956010900732105,0.3164409365676271,0.3182165888722967,0.3171684911028579,0.3365315888241382,0.34942359856883154,0.2976860968744745,0.3995998858286041,0.39960061590204693,0.39960045662351074,0.399599764170631,0.3699771027660333,0.35000763397447215,0.33997539774690366,0.32981848535626995,0.3785190480181569,0.3388942649982092,0.3491042045621932,0.3494446592091961,0.3598955552834733,0.35976874381979673,0.3788929807820181,0.49937212737513903,0.4080500395421554,0.41287870141178423,0.3873077946581958,0.38780065903107114,0.412786894458604,0.08041007321690058,0.08041010590993206,0.08041008868107676,0.08041010276404402,0.08041010506177101,0.08041008979366979,0.08041008727729339,0.08041005363587471,0.08041012630129299,0.08041009960083902,0.0804100859710292,0.08041005072060478,0.08041011847243194,0.08041008559987275,0.0804100774481765,0.08041017271736982], 
'MgO': [9.140908719455581,9.140905375606588,9.14091258949217,9.140923354102917,9.140916859484944,9.140916737198957,9.140913113355552,9.140913820121185,9.140912607627046,9.140917355772341,9.14091551810824,9.140918926527641,9.140905945894534,9.140920929582395,9.140908132247969,9.140915049459766,7.113554312027283,7.1135610717736535,7.113553972987054,7.113555849994602,7.113550203388994,2.5873351454746807,2.6822627810829887,10.391346969683735,10.391299975469781,10.39128696614173,10.39130745610599,10.39129008695797,10.391332485075488,10.391291853459805,10.391327938129388,10.391311033019159,9.645792224100443,9.645785096954322,9.64578808249812,9.645790393987271,9.645788860296184,9.645791636746361,1.7574497914645968,1.6551857935511183,1.6892932087980217,1.7072185780228077,1.7117904095584113,1.7555539857774396,1.6369253563603963,1.655946812815888,1.6316363749132534,1.6358617365861028,1.6369854113876474,8.808495557379446,8.807546396572473,8.807358386109515,8.807358386109515,8.806994943758571,14.181221770301935,15.042629646538275,14.27645774119192,13.659940970733839,10.541438699409078,10.36192767515416,10.62514445194574,10.511663156801022,15.41457246257931,10.13125016362795,16.283731611241517,16.28371226318154,16.2837548313394,16.283706236938393,0.4299733897010657,0.4100089426558102,0.40997033257714843,0.3897854826937736,11.45518171633896,11.392827790969207,15.360585000736501,19.96826624052549,24.29294998163445,15.98972194754652,23.83037431760587,7.9899540380022245,8.058988280957568,10.796778041918158,10.614327129281367,10.827802611367538,10.484787119248542,0.06030755491267543,0.060307629536324195,0.060307566510807584,0.0603075269841409,0.06030752870019498,0.06030761747410586,0.060307565457970044,0.060307565311995506,0.06030756961936557,0.0603075998337806,0.060307589650569676,0.060307513010773244,0.060307638944224314,0.06030751405654897,0.0603076082545107,0.060307554177699944], 
'CaO': [14.341449180393983,14.341458914482738,14.341479053739963,14.341442144014877,14.341402423736445,14.341439709241405,14.341437522405931,14.341423748581636,14.341477865568706,14.341430535927383,14.341394207043958,14.341414152485521,14.341463420853499,14.341399819778248,14.341465225498725,14.341466260543346,12.25612592491715,12.256162480782082,12.256153978339915,12.25616792211182,12.25612708265881,5.748515050840633,6.100635272763941,10.910329000088517,10.91037971273099,10.910342831011842,10.910404220882516,10.910378641986975,10.9103825911749,10.910329607108988,10.910371943668155,10.91039998414847,11.50691232187879,11.506901413209922,11.506864898345844,11.506878899916138,11.506879476441327,11.506928512588631,4.353764052251076,4.363397754777596,4.3395806991173345,4.351902269418341,4.430454302970469,4.291469688568333,4.425385051500375,4.427457300520106,4.422620117902736,4.318674984587311,4.417925158175623,12.92907991981458,12.927686744799596,12.927410783679392,12.927410783679392,12.926877324228684,6.032012640325613,5.825527661524106,6.015865840628042,5.881363473510403,7.65391515322948,7.50792264370575,7.721070455285198,7.710532579235402,6.089954146485349,7.392538072382784,13.386589581853528,13.386612820215257,13.386608710718273,13.386658766343459,1.489907792219972,1.4600318445792266,1.4198972494135387,1.5091694329938414,11.654402267927463,11.46260013964531,9.974405844634092,9.385085133046982,8.397562956614378,13.491327893242378,4.825900071013072,11.785182206053282,11.935463656608043,8.381437638659218,8.342819252502217,8.000939912641046,8.266057561533545,0.25128122829914934,0.2512819567476013,0.2512812761141679,0.25128194680432836,0.2512812025970348,0.2512819065716195,0.2512815227415418,0.2512813548993848,0.25128195852409274,0.2512812470882302,0.25128195917467744,0.25128197166969773,0.25128199590060246,0.25128139214121337,0.25128136660460576,0.2512814757404164], 
'Na2O': [3.2003202565195075,3.200321944091885,3.200323746920825,3.2003216307232685,3.200320082197751,3.2003178817473015,3.200318769700866,3.2003226642295775,3.2003139571210553,3.20032461636163,3.2003225063177396,3.200322798035618,3.200315273776478,3.200319054699145,3.2003153223096366,3.2003223535700016,2.921465119678774,2.9214596227825105,2.921462251939224,2.9214643892673116,2.9214584946367945,4.590758079130172,4.870424523545426,2.1461362748358335,2.1461365744613428,2.146142449308934,2.1461340734531897,2.1461364915304824,2.14613293137553,2.1461395526058693,2.146135891340161,2.1461321489736007,1.891135235755848,1.8911354598375674,1.8911344751764794,1.8911370359725677,1.8911351102009695,1.8911338506670723,3.132095848212957,3.183139927520362,3.0956792662892623,3.1736204296746395,3.2530331489247457,3.030869861394881,3.171289012353298,3.0079281105475246,3.023056789452503,3.109647325731982,3.017268692302559,0.9754040278228089,0.9752989230102852,0.975278103772579,0.975278103772579,0.9752378581789153,1.8675270922862413,1.745663254737532,1.8656167698133397,1.8572726758453906,2.5513050510764934,2.5258441741738547,2.6067285362516133,2.4942929524612594,1.9268215578224137,2.3517201653083486,3.6963066362200827,3.6963073712017867,3.6963009306828067,3.6963038295037505,3.849761744997914,3.870084409946307,3.7797264808332223,4.13772281628775,2.689477446444799,2.4918695955750674,2.0946252273731596,1.537556500520463,1.0496953695767972,1.4990364325824863,1.4058923760595932,1.7977396585505006,1.73421266805416,2.590813851358946,2.5541378890972912,2.479883161698692,2.54895907328188,4.23157804890934,4.23158290074349,4.231577252034389,4.231579729535471,4.231580301039768,4.231587066047575,4.231580442215564,4.231583675701826,4.231577536345553,4.231578211617903,4.231584084382569,4.231577830380732,4.231584763702196,4.23157772102029,4.231582307361233,4.231582864920837], 
'K2O': [3.4503402655365436,3.4503470959740636,3.4503490396490144,3.450347562292973,3.4503458888351872,3.450348649396663,3.450344474619556,3.4503434539106896,3.450345369723631,3.450350790732644,3.4503433258258616,3.4503496825895366,3.4503362522917795,3.450350906243311,3.450341600045136,3.4503483525180254,0.14006972478330595,0.14007057129013853,0.14006990238029784,0.140070347553322,0.140070023801815,0.9161381254404513,0.9377836039124735,0.5090836513286414,0.5090833501082068,0.5090835481180798,0.5090836693488043,0.5090834927510388,0.5090833312816084,0.509084548707058,0.5090830672264944,0.5090833823057269,0.41024622004672534,0.410245831173365,0.41024659538349145,0.4102468297234197,0.4102458396791627,0.4102457857283433,5.390853344803133,5.420865825134274,5.352261229830276,5.380390371627715,5.431805231740579,5.306155580225488,5.395151624282124,5.451933666174435,5.405876972653954,5.380726758186288,5.420285858116784,0.0,0.0,0.0,0.0,0.0,0.07989420715663063,0.07980174878800145,0.09976560266381496,0.07988269573528561,0.11866535121286016,0.1392197576316298,0.10902666881660741,0.10887786697251531,0.0898517824891281,0.1190744387497898,1.398603996003254,1.3986055038728697,1.3986059889618434,1.3986002674927382,6.579592800541889,6.510141991925182,6.399536898765244,6.626353205794151,0.17929849642965326,0.18938208926370512,0.20946252273731594,0.1697302630444667,0.17994777764173664,0.1598972194754652,0.1695047545603765,0.19974885095005562,0.2040250197710777,0.11354164288824066,0.09421000410604763,0.13266864651062957,0.103196723614651,4.804499970881956,4.804500671574305,4.804502095854586,4.80450649521848,4.8044997196540224,4.804509732824701,4.804505520082279,4.804507051271152,4.80450020092765,4.804503476283282,4.804505581927835,4.80449720160865,4.804503025940898,4.804505673337088,4.8045051877996245,4.804502218078508], 
'P2O5': [0.7700770617250065,0.7700764551395485,0.7700768922152873,0.7700778105608997,0.7700774358910171,0.770076907218645,0.7700771204978916,0.7700770192226521,0.7700763983239911,0.7700774923865181,0.7700769871592907,0.7700774733624342,0.7700756635389112,0.7700776299669373,0.7700767288843868,0.7700769468705029,0.11005506954548758,0.11005552033999474,0.11005485183201716,0.11005548755525832,0.11005501870142605,0.3624282694050136,0.20167389331451044,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6067690567310788,0.6192562543228957,0.6081645890038677,0.6173580464112115,0.6292144852338417,0.6264909627243133,0.6285712131433531,0.5905323306518957,0.6188614572347212,0.607030539791643,0.6071209117529793,0.0,0.0,0.0,0.0,0.0,0.3894842598885743,0.3790583067430069,0.38908585038887833,0.4193841526102494,0.4054399499772722,0.4375478096994079,0.43610667526642966,0.395919516263692,0.4093247868949169,0.4564520152075276,1.2987029256453182,1.298705907933309,1.298704777111077,1.2986986871067856,0.18998824196093603,0.1700037079304579,0.229983357299376,0.2998349866875181,0.3785190480181569,0.3388942649982092,0.3491042045621932,0.3494446592091961,0.3598955552834733,0.35976874381979673,0.3788929807820181,0.39949770190011125,0.4080500395421554,0.5367423118353195,0.49198557699824874,0.5561877872945625,0.5056639457117899,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0], 
 }) 

df_Allison_CO2 = pd.DataFrame({ 
'SiO2': [53.3,52.63,53.12,52.82,48.21,48.2,48.13,48.38,48.47,48.61,49.2,49.26,49.11,49.37,48.77,48.8,48.45,48.91,49.06,50.03,49.72,49.81,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,48.95301072036869,50.447938486129694,49.8692668518768,52.527102591959064,51.26458855758292,51.56543272403147,50.19903321846306,50.49412754559146,50.75098903450673], 
'TiO2': [1.14,1.16,1.14,1.19,1.86,1.87,1.84,2.81,2.86,2.86,0.98,0.99,0.99,0.98,1.79,1.69,1.79,1.79,1.69,0.82,0.81,0.78,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.7332932571886581,1.76,1.7997981821390527,0.85,0.8919183387695364,0.883477878733368,1.0639715364588869,1.072709547736303,1.0539879403989068], 
'Al2O3': [16.75,17.17,16.59,17.29,16.44,16.56,16.62,19.27,19.47,19.65,15.5,15.37,15.38,15.38,16.98,17.37,17.16,16.94,17.22,16.74,16.89,16.65,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.801923654944392,16.7,16.762139054255364,16.04,15.651136478953578,15.812845056927655,14.474241963508803,14.616619257931736,14.522953020054992], 
'MnO': [0.17,0.19,0.18,0.17,0.18,0.19,0.17,0.25,0.27,0.26,0.22,0.24,0.22,0.21,0.18,0.18,0.18,0.19,0.19,0.2,0.2,0.2,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18798103076104006,0.16521095969565713,0.11038520765928282,0.10842362981113386,0.16333643003162682,0.12390652527108464,0.17536536453430002,0.10515384332333053], 
'MgO': [6.42,6.34,6.75,6.2,8.58,8.56,8.75,3.19,3.27,3.26,6.79,6.89,6.79,6.75,6.33,6.41,6.21,6.36,6.37,8.03,8.0,8.16,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.662659052199178,6.573845671009167,6.51743983783349,7.912076072034486,7.938423633624311,8.817210119140716,6.876747685050258,6.910479298679446,7.388588435442469], 
'CaO': [9.32,9.44,9.3,9.26,10.06,10.08,10.09,6.93,7.04,7.07,11.77,11.89,11.86,11.7,11.26,11.42,11.16,11.18,11.42,12.74,12.62,12.75,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,9.87876966235848,11.377950594839639,10.811452321474093,12.713439308748944,12.632383515866023,12.815560684323863,13.173932590606736,13.483131868623943,13.009332556510678], 
'Na2O': [3.22,3.3,3.21,3.36,3.46,3.47,3.47,6.16,6.1,6.18,1.94,1.9,1.89,1.94,3.65,3.75,3.64,3.67,3.68,2.46,2.45,2.42,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.626891093076846,3.6987817063713675,3.577358579092456,2.4463518407896685,2.413131338210803,2.5413253432519434,1.9748370401749877,1.958700741532088,1.8291390546962452], 
'K2O': [1.35,1.41,1.32,1.42,0.82,0.82,0.81,2.89,2.95,2.98,5.93,6.01,6.01,5.89,1.79,1.87,1.87,1.78,1.82,1.99,1.96,1.88,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,1.9336739805630696,2.1449449527434896,2.10087739123963,2.0620532093580355,1.9448594539420045,1.9458272632485887,5.832261408644236,6.049455119898912,5.768627031703093], 
'P2O5': [0.74,0.79,0.7,0.82,0.47,0.49,0.49,1.19,1.29,1.27,0.64,0.65,0.67,0.65,0.53,float('nan'),0.57,0.53,float('nan'),0.41,0.41,0.39,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.6812944594729986,0.0,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'H2O': [5.27,2.39,4.77,3.9,2.61,3.32,4.12,2.52,2.32,2.12,3.43,2.74,3.95,4.62,2.68,3.35,4.24,5.19,4.53,2.33,2.64,4.16,5.27,2.12,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'CO2': [2040.0,3049.0,4963.0,5520.0,3176.0,4535.0,6086.0,3368.0,5386.0,6754.0,4963.0,6845.0,8501.0,9542.0,3996.0,4426.0,5395.0,7072.0,7659.0,3568.0,5272.0,6086.0,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
 }) 

df_Dixon_CO2 = pd.DataFrame({ 
'SiO2': [49.1,49.1,49.2,49.2,46.0,46.0,44.1,44.1], 
'TiO2': [float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'Al2O3': [16.4,16.4,13.3,13.3,15.2,15.2,12.8,12.8], 
'MnO': [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0], 
'MgO': [10.2,10.2,10.4,10.4,9.06,9.06,9.14,9.14], 
'CaO': [11.7,11.7,10.9,10.9,8.22,8.22,14.3,14.3], 
'Na2O': [2.13,2.13,2.15,2.15,4.33,4.33,3.2,3.2], 
'K2O': [0.07,0.07,0.51,0.51,1.32,1.32,3.45,3.45], 
'P2O5': [0.0,0.0,0.0,0.0,0.27,0.27,0.77,0.77], 
'H2O': [float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'CO2': [484.0,14800.0,543.0,16000.0,807.0,23000.0,2200.0,57699.99999999999], 
 }) 

df_MagmaSat_CO2 = pd.DataFrame({ 
'SiO2': [42.2025942029871,47.6325471869388,48.0722037626588,53.6131741196415,56.2676751964803,58.7713811179646,56.4639356977304,57.3898569821825,56.7936913155256,59.3997733813062,60.4232711041654,68.697805825107,57.9069066176986,50.0824893699278,46.0307464391203,44.1107585953934,46.4039103860015,51.6328471161645,49.0673252023488,51.5015145044706,46.0957270726974,53.9933530212838,39.4028273023035,74.5000742804593,78.5367387506117,81.4144457720747], 
'Na2O+K2O': [21.8279027119068,21.5160042416403,17.6737704507978,18.7685385317097,19.4644629206327,16.7415462558648,15.880763837052,15.3035134948404,13.899184163082,15.288718797017,13.093031363772,11.8284209430084,5.31206859610539,3.07577485987727,5.86342821712618,6.65452919151162,11.9910043870029,2.28435742136726,2.66201779601825,0.00510368022965579,-0.0160400790927468,0.998168103109982,5.13107089586284,9.63431456452966,8.15375234803721,7.07174125245057], 
 }) 

df_Shishkina_CO2 = pd.DataFrame({ 
'SiO2': [50.17501750175016,47.32742008984209,43.666155003356245,42.355137489425296,48.34218170890513,50.68766882628917,50.17501750175016,46.23738305757031,47.32742008984209,43.666155003356245,42.355137489425296,50.17501750175016,47.32742008984209,43.666155003356245,42.355137489425296,48.34218170890513,50.17501750175016,43.666155003356245,42.355137489425296,49.031221764883036,50.17501750175016,46.23738305757031,47.32742008984209,43.666155003356245,42.355137489425296,48.88259682475478,49.031221764883036,48.34218170890513,50.68766882628917,50.63039414548781,49.80214070665472,50.72391412880678,51.28334172118771,53.51281024819856,50.63039414548781,49.15606751459883,49.80214070665472,46.198654213116406,44.22897594529284,51.28334172118771,50.72391412880678,53.51281024819856,51.28334172118771,48.88259682475478,53.51281024819856,53.51281024819856,54.01401401401401,44.11,float('nan'),float('nan'),float('nan')], 
'TiO2': [0.9200920092009198,2.3531282911652007,2.6386554986744777,2.260615195877407,1.7730141240108181,1.4613248167028863,0.9200920092009198,2.700444574472452,2.3531282911652007,2.6386554986744777,2.260615195877407,0.9200920092009198,2.3531282911652007,2.6386554986744777,2.260615195877407,1.7730141240108181,0.9200920092009198,2.6386554986744777,2.260615195877407,2.7607669912659367,0.9200920092009198,2.700444574472452,2.3531282911652007,2.6386554986744777,2.260615195877407,2.8921023359288096,2.7607669912659367,1.7730141240108181,1.4613248167028863,2.008511315276618,1.590929686949342,1.8372441337993006,1.2380473074987415,0.7105684547638111,2.008511315276618,2.2898168146548277,1.590929686949342,3.1836898664256306,2.6972556176113747,1.2380473074987415,1.8372441337993006,0.7105684547638111,1.2380473074987415,2.8921023359288096,0.7105684547638111,0.7105684547638111,0.4204204204204204,2.69,float('nan'),float('nan'),float('nan')], 
'Al2O3': [18.281828182818277,14.179889962346142,12.659386108426583,11.805434911804234,16.397876389862766,16.952787030079005,18.281828182818277,14.656611392747433,14.179889962346142,12.659386108426583,11.805434911804234,18.281828182818277,14.179889962346142,12.659386108426583,11.805434911804234,16.397876389862766,18.281828182818277,12.659386108426583,11.805434911804234,16.20319245055717,18.281828182818277,14.656611392747433,14.179889962346142,12.659386108426583,11.805434911804234,14.7739913034685,16.20319245055717,16.397876389862766,16.952787030079005,13.632024818040808,14.419058934882644,13.67948077883175,14.282838449924506,15.492393915132107,13.632024818040808,13.328933685305175,14.419058934882644,15.26564226172542,12.834524871905426,14.282838449924506,13.67948077883175,15.492393915132107,14.282838449924506,14.7739913034685,15.492393915132107,15.492393915132107,16.686686686686688,12.8,float('nan'),float('nan'),float('nan')], 
'Fe2O3': [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.1732887881318856,1.3794770070383535,0.0,0.0,0.0,1.1732887881318856,1.7198624110071195,1.3794770070383535,0.0,2.6972556176113747,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.69,float('nan'),float('nan'),float('nan')], 
'FeO': [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,11.822376009227222,10.079244409090451,0.0,0.0,0.0,11.822376009227222,9.679225661947045,10.079244409090451,0.0,6.637855832188587,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,6.62,float('nan'),float('nan'),float('nan')], 
'MnO': [0.17001700170016998,0.17317394350566412,0.195075698345584,0.18838459965645055,0.20034057898427324,0.13290310132623842,0.17001700170016998,0.16491264576931006,0.17317394350566412,0.195075698345584,0.18838459965645055,0.17001700170016998,0.17317394350566412,0.195075698345584,0.18838459965645055,0.20034057898427324,0.17001700170016998,0.195075698345584,0.18838459965645055,0.17066559582371246,0.17001700170016998,0.16491264576931006,0.17317394350566412,0.195075698345584,0.18838459965645055,0.0,0.17066559582371246,0.20034057898427324,0.13290310132623842,0.1889193811398799,0.1812451542094187,0.21967049425861204,0.1811776547559134,0.10008006405124101,0.1889193811398799,0.0,0.1812451542094187,0.0,0.19051247856734618,0.1811776547559134,0.21967049425861204,0.10008006405124101,0.1811776547559134,0.0,0.10008006405124101,0.10008006405124101,0.0,0.19,float('nan'),float('nan'),float('nan')], 
'MgO': [7.0007000700069995,10.370063205221534,12.07415901338983,13.322977520147862,5.970149253731343,7.480591323598106,7.0007000700069995,8.719756145052271,10.370063205221534,12.07415901338983,13.322977520147862,7.0007000700069995,10.370063205221534,12.07415901338983,13.322977520147862,5.970149253731343,7.0007000700069995,12.07415901338983,13.322977520147862,5.882943479570323,7.0007000700069995,8.719756145052271,10.370063205221534,12.07415901338983,13.322977520147862,6.471837395085449,5.882943479570323,5.970149253731343,7.480591323598106,7.069562104760769,7.159183591272039,6.66000998502246,8.032209360845494,4.883907125700561,7.069562104760769,10.40916726661867,7.159183591272039,9.09912624284423,9.164652916344968,8.032209360845494,6.660009985022465,4.883907125700561,8.032209360845494,6.471837395085449,4.883907125700561,4.883907125700561,8.858858858858857,9.14,float('nan'),float('nan'),float('nan')], 
'CaO': [11.371137113711368,9.94222169773695,11.827747604953302,13.239251031411666,10.828408294099969,12.027337165140036,11.371137113711368,10.636865652120498,9.94222169773695,11.827747604953302,13.239251031411666,11.371137113711368,9.94222169773695,11.827747604953302,13.239251031411666,10.828408294099969,11.371137113711368,11.827747604953302,13.239251031411666,9.798213030820197,11.371137113711368,10.636865652120498,9.94222169773695,11.827747604953302,13.239251031411666,10.992011325715442,9.798213030820197,10.828408294099969,12.027337165140036,10.818120351588913,12.334739661474329,11.48277583624563,12.068444891796675,8.51681345076061,10.818120351588913,10.929125669946405,12.334739661474329,8.255498644169933,14.378678645556548,12.068444891796675,11.48277583624563,8.51681345076061,12.068444891796675,10.992011325715442,8.51681345076061,8.51681345076061,13.003003003003002,14.34,float('nan'),float('nan'),float('nan')], 
'Na2O': [2.3302330233023296,3.5245990854682216,3.685903984529719,3.7258287487609105,3.4558749874787136,2.52292483295083,2.3302330233023296,3.5147007629584213,3.5245990854682216,3.685903984529719,3.7258287487609105,2.3302330233023296,3.5245990854682216,3.685903984529719,3.7258287487609105,3.4558749874787136,2.3302330233023296,3.685903984529719,3.7258287487609105,3.1322156409998994,2.3302330233023296,3.5147007629584213,3.5245990854682216,3.685903984529719,3.7258287487609105,2.6291839417534635,3.1322156409998994,3.4558749874787136,2.52292483295083,2.615041959988864,2.9401991682861257,2.6759860209685464,2.154001006542526,3.662930344275421,2.615041959988864,2.149828013758899,2.9401991682861257,4.348699407452044,3.2086312179763565,2.154001006542526,2.6759860209685464,3.662930344275421,2.154001006542526,2.6291839417534635,3.662930344275421,3.662930344275421,0.980980980980981,3.2,float('nan'),float('nan'),float('nan')], 
'K2O': [0.23002300230022996,0.8353096098508503,1.0061799177824857,0.9628546204663029,1.9633376740458777,0.22277453947234802,0.23002300230022996,1.0616251571399333,0.8353096098508503,1.0061799177824857,0.9628546204663029,0.23002300230022996,0.8353096098508503,1.0061799177824857,0.9628546204663029,1.9633376740458777,0.23002300230022996,1.0061799177824857,0.9628546204663029,1.1243851018973998,0.23002300230022996,1.0616251571399333,0.8353096098508503,1.0061799177824857,0.9628546204663029,0.3033673778946304,1.1243851018973998,1.9633376740458777,0.22277453947234802,0.15909000517042518,0.14096845327399235,0.1497753369945082,0.040261701056869645,4.723779023218575,0.15909000517042518,0.5099592032637389,0.14096845327399235,1.3257005122024708,3.4593055318807595,0.040261701056869645,0.1497753369945082,4.723779023218575,0.040261701056869645,0.3033673778946304,4.723779023218575,4.723779023218575,0.0,3.45,float('nan'),float('nan'),float('nan')], 
'P2O5': [0.15001500150014999,0.46858831772120874,0.698165657236827,1.1303075979387034,0.591004708003606,0.0,0.15001500150014999,0.5565801794714216,0.46858831772120874,0.698165657236827,1.1303075979387034,0.15001500150014999,0.46858831772120874,0.698165657236827,1.1303075979387034,0.591004708003606,0.15001500150014999,0.698165657236827,1.1303075979387034,0.0,0.15001500150014999,0.5565801794714216,0.46858831772120874,0.698165657236827,1.1303075979387034,0.0,0.0,0.591004708003606,0.0,0.0,0.11076092757242254,0.1897154268597104,0.15098137896326116,0.0,0.0,0.0,0.11076092757242254,0.27116601385959627,0.7720768868255607,0.15098137896326116,0.1897154268597104,0.0,0.15098137896326116,0.0,0.0,0.0,0.0,0.77,float('nan'),float('nan'),float('nan')], 
 }) 

df_Iacono_H2O = pd.DataFrame({ 
'SiO2': [48.86,48.86,48.86,48.86,48.86,48.86,48.02,48.02,48.02,48.02,48.02,48.02,48.02,48.02,48.02,48.02,48.02,47.59,47.59,47.59,47.59,47.59,47.59,47.59,47.59,47.59,49.4,49.4,49.4,49.4,49.4,49.4,49.4,49.4,53.6,53.6,55.3,55.3,55.3,55.3,62.6,62.6,62.6,62.6,50.6,50.6,50.6,50.6,50.71,50.71,58.41,58.41,51.8,51.8,51.8,51.8,51.8,51.8,51.8,51.8,51.8,51.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,53.8,47.47,47.98,47.73,47.16,47.82,47.64,47.65,47.91,46.7,48.28,49.64,49.64,49.64,49.64,49.64,49.64,49.64,49.64,49.64,49.64,49.64,49.64,50.8,50.8,50.8,50.8,50.8,50.8,53.47,53.47,53.47,53.47,53.47], 
'TiO2': [1.73,1.73,1.73,1.73,1.73,1.73,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.96,0.96,1.66,1.66,1.66,1.66,1.66,1.66,1.66,1.66,1.66,0.8,0.8,0.8,0.8,0.8,0.8,0.8,0.8,1.76,1.76,0.74,0.74,0.74,0.74,0.63,0.63,0.63,0.63,1.27,1.27,1.27,1.27,1.7,1.7,1.15,1.15,0.84,0.84,0.84,0.84,0.84,0.84,0.84,0.84,0.84,0.84,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,1.58,1.55,1.52,1.55,1.49,1.64,1.72,1.56,1.62,1.76,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,0.87,1.84,1.84,1.84,1.84,1.84,1.84,0.71,0.71,0.71,0.71,0.71], 
'Al2O3': [16.77,16.77,16.77,16.77,16.77,16.77,14.52,14.52,14.52,14.52,14.52,14.52,14.52,14.52,14.52,14.52,14.52,17.19,17.19,17.19,17.19,17.19,17.19,17.19,17.19,17.19,15.8,15.8,15.8,15.8,15.8,15.8,15.8,15.8,13.8,13.8,17.4,17.4,17.4,17.4,17.3,17.3,17.3,17.3,19.1,19.1,19.1,19.1,14.48,14.48,18.25,18.25,15.39,15.39,15.39,15.39,15.39,15.39,15.39,15.39,15.39,15.39,17.67,17.67,17.67,17.67,17.67,17.67,17.67,17.67,17.67,17.67,17.67,17.67,17.67,14.92,14.93,14.93,15.09,15.0,16.83,17.3,16.0,15.73,16.38,16.07,16.07,16.07,16.07,16.07,16.07,16.07,16.07,16.07,16.07,16.07,16.07,13.7,13.7,13.7,13.7,13.7,13.7,15.48,15.48,15.48,15.48,15.48], 
'MgO': [6.65,6.65,6.65,6.65,6.65,6.65,6.82,6.82,6.82,6.82,6.82,6.82,6.82,6.82,6.82,6.82,6.82,5.72,5.72,5.72,5.72,5.72,5.72,5.72,5.72,5.72,8.0,8.0,8.0,8.0,8.0,8.0,8.0,8.0,5.34,5.34,6.68,6.68,6.68,6.68,2.65,2.65,2.65,2.65,4.32,4.32,4.32,4.32,4.68,4.68,3.39,3.39,5.7,5.7,5.7,5.7,5.7,5.7,5.7,5.7,5.7,5.7,2.43,2.43,2.43,2.43,2.43,2.43,2.43,2.43,2.43,2.43,2.43,2.43,2.43,7.4,7.21,7.02,6.35,6.46,5.09,4.57,6.09,6.03,5.29,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,9.91000000000001,6.67,6.67,6.67,6.67,6.67,6.67,4.88,4.88,4.88,4.88,4.88], 
'CaO': [9.86,9.86,9.86,9.86,9.86,9.86,12.77,12.77,12.77,12.77,12.77,12.77,12.77,12.77,12.77,12.77,12.77,10.85,10.85,10.85,10.85,10.85,10.85,10.85,10.85,10.85,12.7,12.7,12.7,12.7,12.7,12.7,12.7,12.7,6.85,6.85,7.28,7.28,7.28,7.28,5.64,5.64,5.64,5.64,8.85,8.85,8.85,8.85,8.83,8.83,6.7,6.7,10.9,10.9,10.9,10.9,10.9,10.9,10.9,10.9,10.9,10.9,5.83,5.83,5.83,5.83,5.83,5.83,5.83,5.83,5.83,5.83,5.83,5.83,5.83,12.24,12.33,12.28,12.45,12.18,10.8,10.52,11.46,11.64,10.86,12.44,12.44,12.44,12.44,12.44,12.44,12.44,12.44,12.44,12.44,12.44,12.44,11.5,11.5,11.5,11.5,11.5,11.5,8.51,8.51,8.51,8.51,8.51], 
'Na2O': [3.62,3.62,3.62,3.62,3.62,3.62,1.8,1.8,1.8,1.8,1.8,1.8,1.8,1.8,1.8,1.8,1.8,3.42,3.42,3.42,3.42,3.42,3.42,3.42,3.42,3.42,2.3,2.3,2.3,2.3,2.3,2.3,2.3,2.3,3.33,3.33,3.97,3.97,3.97,3.97,4.05,4.05,4.05,4.05,4.23,4.23,4.23,4.23,3.16,3.16,4.35,4.35,2.04,2.04,2.04,2.04,2.04,2.04,2.04,2.04,2.04,2.04,4.34,4.34,4.34,4.34,4.34,4.34,4.34,4.34,4.34,4.34,4.34,4.34,4.34,2.54,2.56,2.61,2.52,2.62,2.89,2.88,2.93,2.85,3.26,2.28,2.28,2.28,2.28,2.28,2.28,2.28,2.28,2.28,2.28,2.28,2.28,2.68,2.68,2.68,2.68,2.68,2.68,3.66,3.66,3.66,3.66,3.66], 
'K2O': [1.93,1.93,1.93,1.93,1.93,1.93,5.55,5.55,5.55,5.55,5.55,5.55,5.55,5.55,5.55,5.55,5.55,1.98,1.98,1.98,1.98,1.98,1.98,1.98,1.98,1.98,1.9,1.9,1.9,1.9,1.9,1.9,1.9,1.9,6.27,6.27,1.18,1.18,1.18,1.18,1.61,1.61,1.61,1.61,1.0,1.0,1.0,1.0,0.77,0.77,0.82,0.82,3.28,3.28,3.28,3.28,3.28,3.28,3.28,3.28,3.28,3.28,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,1.26,1.26,1.17,1.11,1.21,1.44,1.38,1.36,1.21,1.58,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.15,0.15,0.15,0.15,0.15,0.15,4.72,4.72,4.72,4.72,4.72], 
'P2O5': [0.68,0.68,0.68,0.68,0.68,0.68,0.65,0.65,0.65,0.65,0.65,0.65,0.65,0.65,0.65,0.65,0.65,0.51,0.51,0.51,0.51,0.51,0.51,0.51,0.51,0.51,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,1.37,1.37,0.27,0.27,0.27,0.27,0.24,0.24,0.24,0.24,0.37,0.37,0.37,0.37,0.36,0.36,0.26,0.26,0.47,0.47,0.47,0.47,0.47,0.47,0.47,0.47,0.47,0.47,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.58,0.37,0.38,0.33,0.31,0.32,0.4,0.36,0.36,0.23,0.46,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.08,0.19,0.19,0.19,0.19,0.19,0.19,float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'H2O': [3.81,5.09,4.46,4.87,2.22,2.02,5.3,2.18,5.31,3.46,2.08,1.56,1.18,1.08,1.32,6.58,8.23,3.28,2.38,1.68,5.07,3.59,1.36,1.08,6.18,8.96,4.92,3.14,2.21,5.19,0.98,1.53,5.99,8.47,4.55,3.41,5.06,3.67,6.37,6.59,2.62,5.03,6.76,6.82,4.51,4.65,5.43,6.4,9.4,5.93,10.1,7.4,2.26,2.05,2.0,1.12,1.01,3.24,2.67,4.13,3.86,4.4,2.57,2.52,2.49,2.43,2.43,2.37,3.27,3.45,4.79,4.73,5.04,5.2,4.23,2.6,2.5,2.5,3.1,3.1,2.8,3.1,1.6,1.3,2.2,2.2,2.28,2.23,3.32,4.8,6.27,9.38,2.23,2.14,3.05,3.18,4.46,1.28,1.43,1.74,2.49,1.71,2.23,2.29,3.32,5.12,6.95,7.92], 
'CO2': [float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
 }) 

df_Shishkina_H2O = pd.DataFrame({ 
'SiO2': [50.175017501750176,50.175017501750176,46.23738305757031,47.32742008984209,43.666155003356245,42.355137489425296,50.175017501750176,50.175017501750176,50.175017501750176,48.88259682475478,49.03122176488304,48.34218170890514,50.68766882628917,48.6327729390318,48.6327729390318,47.954453849254335,49.8285253177325,53.512810248198555,49.48913798234302,50.72391412880679,55.37834127432771,57.690947844797115,54.379010756176434,60.135721931613936,52.97065139584824,55.8149185600166,69.19,54.55552199738246,49.64,49.64,54.326971624760176,54.326971624760176,48.03646563814867,48.6327729390318,47.954453849254335,47.954453849254335,49.8285253177325,53.512810248198555,49.48913798234302,55.37834127432771,58.71498578256399,57.618075624987355,57.690947844797115,55.315060180034386,56.68532558633885,56.484612182318465,54.379010756176434,60.25576477696103,60.135721931613936,52.97065139584824,49.64,54.326971624760176,54.326971624760176,48.03646563814867,48.6327729390318,49.8285253177325,53.512810248198555,49.48913798234302,48.88259682475478,55.37834127432771,55.37834127432771,58.71498578256399,57.618075624987355,57.690947844797115,55.315060180034386,56.68532558633885,56.484612182318465,54.379010756176434,60.25576477696103,60.135721931613936,48.34218170890514,48.34218170890514,52.97065139584824,55.8149185600166,69.19,60.31032637774211,55.321707757065546,62.241157237689485,54.55552199738246,49.64,54.326971624760176,48.03646563814867,53.512810248198555,55.37834127432771,57.690947844797115,54.379010756176434,49.64,54.326971624760176,49.48913798234302,69.19,60.31032637774211,55.321707757065546,54.55552199738246,48.45657568238214,49.64,49.65,50.99,53.47,58.29,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'TiO2': [0.9200920092009202,0.9200920092009202,2.700444574472452,2.3531282911652007,2.6386554986744777,2.260615195877407,0.9200920092009202,0.9200920092009202,0.9200920092009202,2.8921023359288096,2.760766991265937,1.7730141240108184,1.4613248167028863,0.9722503544662752,0.9722503544662752,1.6727126158806933,0.8069396812588259,0.710568454763811,0.8828489237178851,1.8372441337993008,0.3230234999596221,0.33335690402351686,0.35482203140681867,0.19186880213277327,0.8589835361488904,0.902583255524432,0.0,0.0,0.87,0.87,1.0501868120771483,1.0501868120771483,1.6730114205570028,0.9722503544662752,1.6727126158806933,1.6727126158806933,0.8069396812588259,0.710568454763811,0.8828489237178851,0.3230234999596221,0.3327485026317382,0.33346132859077215,0.33335690402351686,0.33377161929806815,0.3137937666386615,0.314762354422411,0.35482203140681867,0.6545161615144497,0.19186880213277327,0.8589835361488904,0.87,1.0501868120771483,1.0501868120771483,1.6730114205570028,0.9722503544662752,0.8069396812588259,0.710568454763811,0.8828489237178851,2.8921023359288096,0.3230234999596221,0.3230234999596221,0.3327485026317382,0.33346132859077215,0.33335690402351686,0.33377161929806815,0.3137937666386615,0.314762354422411,0.35482203140681867,0.6545161615144497,0.19186880213277327,1.7730141240108184,1.7730141240108184,0.8589835361488904,0.902583255524432,0.0,0.0,0.0,0.0,0.0,0.87,1.0501868120771483,1.6730114205570028,0.710568454763811,0.3230234999596221,0.33335690402351686,0.35482203140681867,0.87,1.0501868120771483,0.8828489237178851,0.0,0.0,0.0,0.0,0.0,0.87,0.84,0.87,0.71,0.52,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'Al2O3': [18.281828182818284,18.281828182818284,14.656611392747433,14.179889962346142,12.659386108426583,11.805434911804234,18.281828182818284,18.281828182818284,18.281828182818284,14.7739913034685,16.20319245055717,16.397876389862766,16.952787030079005,14.70528661130241,14.70528661130241,17.321644498186217,15.937058704861812,15.492393915132105,15.444896339648844,13.679480778831751,20.441330856819835,20.55700908145021,20.80270881276548,22.630420293660258,15.737805501585028,18.33177715530657,18.83,15.987113661532266,16.07,16.07,16.35867918812481,16.35867918812481,17.351232217992386,14.70528661130241,17.321644498186217,17.321644498186217,15.937058704861812,15.492393915132105,15.444896339648844,20.441330856819835,20.428741403997023,19.90663082799458,20.55700908145021,20.693840396480226,19.526070188579936,19.43403697949983,20.80270881276548,18.79971805457658,22.630420293660258,15.737805501585028,16.07,16.35867918812481,16.35867918812481,17.351232217992386,14.70528661130241,15.937058704861812,15.492393915132105,15.444896339648844,14.7739913034685,20.441330856819835,20.441330856819835,20.428741403997023,19.90663082799458,20.55700908145021,20.693840396480226,19.526070188579936,19.43403697949983,20.80270881276548,18.79971805457658,22.630420293660258,16.397876389862766,16.397876389862766,15.737805501585028,18.33177715530657,18.83,24.9438202247191,28.302264982962516,10.551867631031406,15.987113661532266,16.07,16.35867918812481,17.351232217992386,15.492393915132105,20.441330856819835,20.55700908145021,20.80270881276548,16.07,16.35867918812481,15.444896339648844,18.83,24.9438202247191,28.302264982962516,15.987113661532266,20.843672456575682,16.07,14.99,15.54,15.48,16.5,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'Fe2O3': [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.199305499475087,4.313436303577021,4.75461522085137,1.2521963928665203,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.199305499475087,4.093814911166233,4.223843495483114,4.313436303577021,4.551431172246384,4.342500835096315,4.599591824301683,4.75461522085137,3.3229282046118214,1.2521963928665203,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.199305499475087,4.199305499475087,4.093814911166233,4.223843495483114,4.313436303577021,4.551431172246384,4.342500835096315,4.599591824301683,4.75461522085137,3.3229282046118214,1.2521963928665203,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.199305499475087,4.313436303577021,4.75461522085137,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'FeO': [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.7564402810304451,1.7880052124897723,1.540941393538184,0.5251146163633795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.7564402810304451,1.986407727831892,1.6976213091893855,1.7880052124897723,1.65874380499646,1.4778674170724055,1.3301247880430918,1.540941393538184,0.5336824086194744,0.5251146163633795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.7564402810304451,1.7564402810304451,1.986407727831892,1.6976213091893855,1.7880052124897723,1.65874380499646,1.4778674170724055,1.3301247880430918,1.540941393538184,0.5336824086194744,0.5251146163633795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.7564402810304451,1.7880052124897723,1.540941393538184,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'MnO': [0.17001700170017003,0.17001700170017003,0.16491264576931006,0.17317394350566412,0.195075698345584,0.18838459965645055,0.17001700170017003,0.17001700170017003,0.17001700170017003,0.0,0.1706655958237125,0.20034057898427327,0.13290310132623842,0.1417865100263318,0.1417865100263318,0.1713018943974204,0.20173492031470647,0.100080064051241,0.01983930165658169,0.21967049425861207,0.1009448437373819,0.10101724364348996,0.11151549558500015,0.35344253024458233,0.1636159116474077,0.1556178026766262,0.0,0.0,0.15,0.15,0.14137130162577,0.14137130162577,0.0,0.1417865100263318,0.1713018943974204,0.1713018943974204,0.20173492031470647,0.100080064051241,0.01983930165658169,0.1009448437373819,0.0907495916268377,0.09094399870657423,0.10101724364348996,0.10114291493880853,0.09110141612090172,0.09138261902586126,0.11151549558500015,0.1711811499345484,0.35344253024458233,0.1636159116474077,0.15,0.14137130162577,0.14137130162577,0.0,0.1417865100263318,0.20173492031470647,0.100080064051241,0.01983930165658169,0.0,0.1009448437373819,0.1009448437373819,0.0907495916268377,0.09094399870657423,0.10101724364348996,0.10114291493880853,0.09110141612090172,0.09138261902586126,0.11151549558500015,0.1711811499345484,0.35344253024458233,0.20034057898427327,0.20034057898427327,0.1636159116474077,0.1556178026766262,0.0,0.0,0.0,0.0,0.0,0.15,0.14137130162577,0.0,0.100080064051241,0.1009448437373819,0.10101724364348996,0.11151549558500015,0.15,0.14137130162577,0.01983930165658169,0.0,0.0,0.0,0.0,0.0,0.15,0.06,0.04,0.16,0.11,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'MgO': [7.000700070007001,7.000700070007001,8.719756145052271,10.370063205221534,12.07415901338983,13.322977520147862,7.000700070007001,7.000700070007001,7.000700070007001,6.471837395085449,5.882943479570324,5.970149253731344,7.480591323598106,6.9070285598541625,6.9070285598541625,5.763804917372028,8.06939681258826,4.88390712570056,5.703799226267235,6.660009985022466,0.5551966405556006,0.5757982887678927,0.5981285672286372,0.07068850604891648,5.8288168524389,2.521008403361345,0.0,8.124433705829055,9.76,9.76,5.6548520650307985,5.6548520650307985,5.770386696052896,6.9070285598541625,5.763804917372028,5.763804917372028,8.06939681258826,4.88390712570056,5.703799226267235,0.5551966405556006,0.5545808377195638,0.5456639922394454,0.5757982887678927,0.5866289066450894,0.5364861171564212,0.5381420898189607,0.5981285672286372,0.3423622998690968,0.07068850604891648,5.8288168524389,9.76,5.6548520650307985,5.6548520650307985,5.770386696052896,6.9070285598541625,8.06939681258826,4.88390712570056,5.703799226267235,6.471837395085449,0.5551966405556006,0.5551966405556006,0.5545808377195638,0.5456639922394454,0.5757982887678927,0.5866289066450894,0.5364861171564212,0.5381420898189607,0.5981285672286372,0.3423622998690968,0.07068850604891648,5.970149253731344,5.970149253731344,5.8288168524389,2.521008403361345,0.0,0.0,0.0,8.09471911225602,8.124433705829055,9.76,5.6548520650307985,5.770386696052896,4.88390712570056,0.5551966405556006,0.5757982887678927,0.5981285672286372,9.76,5.6548520650307985,5.703799226267235,0.0,0.0,0.0,8.124433705829055,7.39454094292804,9.76,5.49,6.03,4.88,2.23,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'CaO': [11.371137113711372,11.371137113711372,10.636865652120498,9.94222169773695,11.827747604953302,13.239251031411666,11.371137113711372,11.371137113711372,11.371137113711372,10.992011325715442,9.798213030820198,10.82840829409997,12.027337165140036,12.932955235973264,12.932955235973264,10.933091495364772,12.81016743998386,8.516813450760608,11.308401944251562,11.482775836245631,3.2504239683436973,3.6669259442586855,0.385235348384546,0.7169834184961528,11.14633398097965,6.048345264031538,0.0,18.282492701097354,12.44,12.44,7.876401090578613,7.876401090578613,10.949709477058706,12.932955235973264,10.933091495364772,10.933091495364772,12.81016743998386,8.516813450760608,11.308401944251562,3.2504239683436973,3.4888176336539827,3.5771306157919196,3.6669259442586855,2.751087286335592,1.9333744976769143,1.1372059256551625,0.385235348384546,0.775349914409425,0.7169834184961528,11.14633398097965,12.44,7.876401090578613,7.876401090578613,10.949709477058706,12.932955235973264,12.81016743998386,8.516813450760608,11.308401944251562,10.992011325715442,3.2504239683436973,3.2504239683436973,3.4888176336539827,3.5771306157919196,3.6669259442586855,2.751087286335592,1.9333744976769143,1.1372059256551625,0.385235348384546,0.775349914409425,0.7169834184961528,10.82840829409997,10.82840829409997,11.14633398097965,6.048345264031538,0.0,7.244515783841626,10.613349368610944,12.771227583473694,18.282492701097354,12.44,7.876401090578613,10.949709477058706,8.516813450760608,3.2504239683436973,3.6669259442586855,0.385235348384546,12.44,7.876401090578613,11.308401944251562,0.0,7.244515783841626,10.613349368610944,18.282492701097354,23.23573200992556,12.44,11.41,11.32,8.51,5.14,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'Na2O': [2.3302330233023305,2.3302330233023305,3.5147007629584213,3.5245990854682216,3.685903984529719,3.7258287487609105,2.3302330233023305,2.3302330233023305,2.3302330233023305,2.6291839417534635,3.1322156409999,3.455874987478714,2.52292483295083,1.8229694146242659,1.8229694146242659,3.4461910519951635,2.3199515836191242,3.6629303442754204,1.9343319115167146,2.675986020968547,2.0491803278688523,8.283413978766175,5.8292190873977345,9.452063094540831,2.0861028735044482,4.502541757443718,11.96,3.0504379341588646,2.28,2.28,3.534282540644249,3.534282540644249,3.4562211981566824,1.8229694146242659,3.4461910519951635,3.4461910519951635,2.3199515836191242,3.6629303442754204,1.9343319115167146,2.0491803278688523,4.245064230544297,6.244821244518096,8.283413978766175,4.581774046728026,5.020700266218584,5.411881771198228,5.8292190873977345,9.787533984493002,9.452063094540831,2.0861028735044482,2.28,3.534282540644249,3.534282540644249,3.4562211981566824,1.8229694146242659,2.3199515836191242,3.6629303442754204,1.9343319115167146,2.6291839417534635,2.0491803278688523,2.0491803278688523,4.245064230544297,6.244821244518096,8.283413978766175,4.581774046728026,5.020700266218584,5.411881771198228,5.8292190873977345,9.787533984493002,9.452063094540831,3.455874987478714,3.455874987478714,2.0861028735044482,4.502541757443718,11.96,7.469234884965222,5.762677891360994,6.34102843554939,3.0504379341588646,2.28,3.534282540644249,3.4562211981566824,3.6629303442754204,2.0491803278688523,8.283413978766175,5.8292190873977345,2.28,3.534282540644249,1.9343319115167146,11.96,7.469234884965222,5.762677891360994,3.0504379341588646,0.06947890818858561,2.28,4.63,7.23,3.66,4.08,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'K2O': [0.23002300230023004,0.23002300230023004,1.0616251571399333,0.8353096098508503,1.0061799177824857,0.9628546204663029,0.23002300230023004,0.23002300230023004,0.23002300230023004,0.3033673778946304,1.1243851018974,1.9633376740458781,0.22277453947234802,5.620822361758153,5.620822361758153,1.995163240628779,1.9164817429897114,4.723779023218575,7.459577422874714,0.14977533699450823,12.365743357829283,3.1214328285838397,11.719264808750925,4.796720053319332,3.3541261887718576,3.9630667081647473,0.02,0.0,0.08,0.08,1.0905786125416541,1.0905786125416541,1.993588459226608,5.620822361758153,1.995163240628779,1.995163240628779,1.9164817429897114,4.723779023218575,7.459577422874714,12.365743357829283,6.47347086938109,6.184191912047047,3.1214328285838397,9.881662789521593,10.507029992610665,11.118218648146453,11.719264808750925,5.689255865471755,4.796720053319332,3.3541261887718576,0.08,1.0905786125416541,1.0905786125416541,1.993588459226608,5.620822361758153,1.9164817429897114,4.723779023218575,7.459577422874714,0.3033673778946304,12.365743357829283,12.365743357829283,6.47347086938109,6.184191912047047,3.1214328285838397,9.881662789521593,10.507029992610665,11.118218648146453,11.719264808750925,5.689255865471755,4.796720053319332,1.9633376740458781,1.9633376740458781,3.3541261887718576,3.9630667081647473,0.02,0.03210272873194221,0.0,0.0,0.0,0.08,1.0905786125416541,1.993588459226608,4.723779023218575,12.365743357829283,3.1214328285838397,11.719264808750925,0.08,1.0905786125416541,7.459577422874714,0.02,0.03210272873194221,0.0,0.0,0.0,0.08,4.71,1.89,4.72,5.36,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
'P2O5': [0.15001500150015,0.15001500150015,0.5565801794714216,0.46858831772120874,0.698165657236827,1.1303075979387034,0.15001500150015,0.15001500150015,0.15001500150015,0.0,0.0,0.5910047080036062,0.0,0.6582945108365404,0.6582945108365404,0.5139056831922613,0.40346984062941293,0.0,float('nan'),0.18971542685971043,0.0,0.0,0.0,0.0,0.4806217404642601,0.6017221703496213,0.0,0.0,0.08,0.08,0.0,0.0,0.5109196553796834,0.6582945108365404,0.5139056831922613,0.5139056831922613,0.40346984062941293,0.0,float('nan'),0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.4806217404642601,0.08,0.0,0.0,0.5109196553796834,0.6582945108365404,0.40346984062941293,0.0,float('nan'),0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.5910047080036062,0.5910047080036062,0.4806217404642601,0.6017221703496213,0.0,0.0,0.0,0.0,0.0,0.08,0.0,0.5109196553796834,0.0,0.0,0.0,0.0,0.08,0.0,float('nan'),0.0,0.0,0.0,0.0,0.0,0.08,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
 }) 

df_MagmaSat_H2O = pd.DataFrame({ 
'SiO2': [43.7180643020584,46.8911737930336,49.1397285446517,48.8722119963278,47.7844154560348,49.7617466661966,49.8887710484411,50.3602680069825,50.8135844152261,50.8498209915047,50.9404938519471,51.0311667123894,52.0285394408743,54.5143417529652,48.798685176472,48.7805046261741,48.7260874995976,48.7262407602956,47.8368785087121,48.5260822887339,49.1786280255577,48.5068863863119,48.0351116427554,48.0533113506405,51.1920425513001,52.7710396286186,53.569240501285,54.2948436970771,55.1474712751136,54.3676329498239,55.8365505308184,55.3280027985403,57.4696103193493,57.5965676500383,58.5579049569107,58.5034782515406,60.0281731478061,62.2232016006547,63.0031644502615,63.4012974284387,63.4557241338088,62.9475691320693,62.2395813377513,65.8863047006588,68.3547310811162,67.2092223092402,60.2609282540694,58.7893669260348,58.5705106493196,53.5836949008633,50.1542281561358,49.9723843379827,49.5006862247752,56.8099092236885,54.271730068063,57.5175426026425,58.950003295105,57.4439774676121,60.4911449800224,60.4731368480098,62.3232712576419,60.4899188944386,55.2104614219834,55.1922904504791,54.683311672488,56.5518756810522,56.4057607631156,55.9883456733738,58.6369300043066,54.1913639895598,48.1872516218813,72.2980522097893,74.60529622994,74.7142166922356,76.1660457054053,64.5336162014949,65.5494281077054,65.1140527799191,64.6240112769221,65.4592341869443,65.9855122662199,66.0042675441352,67.1119592387847,66.7126193326109,66.9852317991426,67.5844619706567,68.5646695009678,68.4923879242831,69.0189342097801,69.2186712144224,69.3094207052137,69.055927510755,68.402395158188,68.7652111242745,68.8740741138083,68.8197336175808,76.122519667179,76.53990602054,76.6306746689185,76.7577182087502,76.4310047158316,64.5681764888893,63.6792452830188,42.234864739771,46.1175425260121,48.4941178544115,99.9999712636191,99.9999712636191,92.1958694709287,84.3735679703532,83.0487346030471,88.5770299762599,85.3625400968301,79.4967359302847,82.1382894266977,82.3584867345202,82.0677128752779,81.6498475822358,80.1993308637926,77.8412521858807,77.1338486979737,70.8922780363626,71.7986809618028,73.2504046082426,74.7922934390627,74.2661781992787,74.6108998242099,75.3013871625774,75.1741137316987,76.2618432204363,76.0436957744493,74.5376220529883,73.9387175604575,74.9362435496403,75.0808450181843,73.6655207875147,73.6652525812933,72.7581791402994,74.7524169212071,75.3517333018638,75.4791791510277,76.1325390853095,77.765225300889,79.4521945399343,79.4341576715408,78.2737826119607,77.4394026357774,76.6048023473408,76.5501170145429,75.9877364620993,76.5871390518986,81.0323889664558,80.1261009865391,79.4909024449679,78.5295651380955,78.3120019985194,77.4235593111238,77.5858432326972,76.8055834404881,76.8597036244622,78.3290522511697,78.818576499311,80.1792824487381,80.1973576323061,80.1791291880401,80.3244107509314,80.0527753213493,79.653933512444,79.2004255283279,79.1093790949342,75.7050117163546,75.3266826279169,75.0373831046598,76.789244679342,76.751321969308,77.4946563103304,77.532406069924,77.5827745597288,77.6457484758649,77.4060125576707,78.6407855751712,78.2625363100137,78.504766705714,62.5188663919213,61.4300679098152,58.571645736364,59.4336333922365,60.2649928554971,59.448352805105,59.8113012778366,76.8265753667145,76.7357125268653,76.4786975292842,76.5694326518852,77.0839176397443,77.3707785617914,77.4917427606032], 
'Na2O+K2O': [4.68215417106652,6.44984160506863,7.52375923970432,2.9429778247096,2.21119324181626,2.38225976768743,2.35374868004223,2.5533262935586,2.79091869060189,2.83843717001055,2.87645195353748,2.91446673706441,3.3611404435058,3.04751847940865,3.89334741288278,3.93136219640971,3.92185850052798,3.76979936642027,4.15945089757127,4.35902851108764,4.92925026399154,5.40443505807813,5.48046462513199,5.4234424498416,5.29989440337909,4.68215417106652,4.73917634635691,4.8247096092925,4.88173178458289,4.60612460401267,5.20485744456177,5.76557550158394,4.94825765575501,4.98627243928194,5.1858500527983,5.1858500527983,4.44456177402322,4.62513199577613,4.77719112988384,5.76557550158394,5.76557550158394,5.93664202745511,6.37381203801478,6.24076029567053,5.16684266103484,7.6948257655755,7.51425554382259,9.53854276663146,10.6789862724392,8.39809926082365,8.97782470960929,9.39598732840549,9.39598732840549,11.4772967265047,9.75712777191129,11.3917634635691,12.1615628299894,12.3801478352692,13.1024287222808,12.9693769799366,13.3400211193241,14.3189017951425,14.3854276663146,14.4139387539598,15.4023231256599,15.4878563885955,16.4572333685322,16.5997888067581,16.780359028511,17.4931362196409,16.533262935586,16.7613516367476,13.6061246040126,13.5395987328405,13.0929250263991,16.3241816261879,16.4762407602956,16.4382259767687,16.6378035902851,15.9630411826821,15.8109820485744,15.2027455121436,14.19535374868,14.4044350580781,13.9292502639915,13.3970432946145,12.8743400211193,12.5892291446673,12.1710665258711,11.9999999999999,11.961985216473,11.467793030623,11.8764519535374,11.9049630411826,11.8954593453009,11.8099260823653,2.27771911298838,2.1636747624076,2.10665258711721,2.05913410770855,2.21119324181626,0.0348468848996788,0.0,0.253431890179513,0.015839493136216,0.0728616684266079,0.0253431890179491,0.0253431890179491,2.9429778247096,5.91763463569165,6.36430834213304,11.4107708553326,14.6990496304118,20.5153115100316,9.67159450897571,7.20063357972544,7.6948257655755,8.28405491024286,7.42872228088701,7.02006335797254,6.87750791974656,7.51425554382259,8.21752903907074,7.8753959873284,8.07497360084477,8.06546990496303,8.04646251319957,6.97254487856388,7.2481520591341,8.04646251319957,8.48363252375923,8.74973600844772,8.95881731784582,9.25343189017951,9.78563885955649,10.013727560718,10.2798310454065,10.2418162618796,11.6388595564941,11.0211193241816,10.5744456177402,10.3368532206969,10.4508975712777,10.7074973600844,10.6029567053854,9.88067581837381,9.71911298838437,9.77613516367476,10.0327349524815,10.0042238648363,9.30095036958817,8.90179514255543,8.0844772967265,8.30306230200633,8.10348468848996,7.96092925026398,7.43822597676874,8.42661034846884,8.56916578669482,8.87328405491024,9.04435058078141,9.35797254487856,9.31995776135163,9.38648363252375,9.47201689545934,9.32946145723336,8.83526927138331,8.55015839493136,8.5026399155227,8.83526927138331,9.0124076029567,9.3753959873284,8.90681098204857,8.27983104540654,8.40522703273495,8.39862724392819,8.4448257655755,8.47122492080253,8.4910242872228,8.84741288278774,8.75501583949313,9.03880675818373,6.20749736008447,20.8783526927138,21.1406546990496,15.552798310454,15.3231256599788,15.481520591341,15.7191129883843,15.6161562829989,8.74181626187961,8.8922914466737,8.8922914466737,8.86853220696937,8.41710665258711,8.80517423442449,8.78933474128827], 
 }) 

df_Dixon_H2O = pd.DataFrame({ 
'SiO2': [50.8,50.8,50.8,50.8,50.8,50.8,float('nan')], 
'TiO2': [1.84,1.84,1.84,1.84,1.84,1.84,float('nan')], 
'Al2O3': [13.7,13.7,13.7,13.7,13.7,13.7,float('nan')], 
'MgO': [6.67,6.67,6.67,6.67,6.67,6.67,float('nan')], 
'CaO': [11.5,11.5,11.5,11.5,11.5,11.5,float('nan')], 
'Na2O': [2.68,2.68,2.68,2.68,2.68,2.68,float('nan')], 
'K2O': [0.15,0.15,0.15,0.15,0.15,0.15,float('nan')], 
'P2O5': [0.19,0.19,0.19,0.19,0.19,0.19,float('nan')], 
'H2O': [1.28,1.43,1.74,2.49,1.71,2.23,float('nan')], 
'CO2': [float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan')], 
 }) 

df_Moore_H2O = pd.DataFrame({ 
'SiO2': [62.6,62.6,62.6,62.6,55.3,55.3,55.3,55.3,59.3,59.3,59.3,59.3,59.3,6.3,6.3,46.9,71.8,71.8,71.8,53.6,53.6,50.8,50.8,50.8,50.6,50.6,50.6,50.6,77.5,77.5,77.5,77.5,77.5,76.6,76.6,75.0,75.0,50.71,58.41,50.71,58.41], 
'TiO2': [0.63,0.63,0.63,0.63,0.74,0.74,0.74,0.74,0.69,0.69,0.69,0.69,0.69,1.7,1.7,1.1,0.24,0.24,0.24,1.76,1.76,1.84,1.84,1.84,1.27,1.27,1.27,1.27,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.1,0.1,0.07,0.07,1.7,1.15,1.7,1.15], 
'Al2O3': [17.3,17.3,17.3,17.3,17.4,17.4,17.4,17.4,19.2,19.2,19.2,19.2,19.2,18.1,18.1,20.91,9.7,9.7,9.7,13.8,13.8,13.7,13.7,13.7,19.1,19.1,19.1,19.1,12.5,12.5,12.5,12.5,12.5,12.7,12.7,12.29,12.29,14.48,18.25,14.48,18.25], 
'Fe2O3': [2.01,2.01,2.01,2.01,1.96,1.96,1.96,1.96,1.01,1.01,1.01,1.01,1.01,2.02,2.02,2.99,1.8,1.8,1.8,4.8,4.8,float('nan'),float('nan'),float('nan'),3.74,3.74,3.74,3.74,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.58,0.58,0.33,0.33,4.89,1.5,4.89,1.5], 
'FeO': [2.01,2.01,2.01,2.01,4.22,4.22,4.22,4.22,2.37,2.37,2.37,2.37,2.37,3.2,3.2,3.26,3.97,3.97,3.97,1.62,1.62,float('nan'),float('nan'),float('nan'),5.33,5.33,5.33,5.33,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.56,0.56,0.71,0.71,9.07,4.96,9.07,4.96], 
'MnO': [0.06,0.06,0.06,0.06,0.12,0.12,0.12,0.12,0.19,0.19,0.19,0.19,0.19,0.14,0.14,0.2,0.14,0.14,0.14,0.09,0.09,0.22,0.22,0.22,0.17,0.17,0.17,0.17,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.05,0.05,0.22,0.1,0.22,0.1], 
'MgO': [2.65,2.65,2.65,2.65,6.68,6.68,6.68,6.68,0.44,0.44,0.44,0.44,0.44,1.68,1.68,1.28,0.01,0.01,0.01,5.34,5.34,6.67,6.67,6.67,4.32,4.32,4.32,4.32,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.02,0.02,0.04,0.04,4.68,3.39,4.68,3.39], 
'CaO': [5.64,5.64,5.64,5.64,7.28,7.28,7.28,7.28,0.86,0.86,0.86,0.86,0.86,4.1,4.1,4.33,0.2,0.2,0.2,6.85,6.85,11.5,11.5,11.5,8.85,8.85,8.85,8.85,0.5,0.5,0.5,0.5,0.5,0.31,0.31,0.58,0.58,8.83,6.7,8.83,6.7], 
'Na2O': [4.05,4.05,4.05,4.05,3.97,3.97,3.97,3.97,9.8,9.8,9.8,9.8,9.8,5.42,5.42,6.9,5.3,5.3,5.3,3.33,3.33,2.68,2.68,2.68,4.23,4.23,4.23,4.23,3.6,3.6,3.6,3.6,3.6,4.1,4.1,4.03,4.03,3.16,4.35,3.16,4.35], 
'K2O': [1.61,1.61,1.61,1.61,1.18,1.18,1.18,1.18,5.84,5.84,5.84,5.84,5.84,5.94,5.94,9.15,4.47,4.47,4.47,6.27,6.27,0.15,0.15,0.15,1.0,1.0,1.0,1.0,4.8,4.8,4.8,4.8,4.8,4.6,4.6,4.66,4.66,0.77,0.82,0.77,0.82], 
'P2O5': [0.24,0.24,0.24,0.24,0.27,0.27,0.27,0.27,0.1,0.1,0.1,0.1,0.1,0.58,0.58,0.41,0.02,0.02,0.02,1.37,1.37,0.19,0.19,0.19,0.37,0.37,0.37,0.37,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.36,0.26,0.36,0.26], 
 }) 

df_Iacono_CO2H2O = pd.DataFrame({ 
'SiO2': [49.46,49.46,49.46,49.46,49.46,49.46,49.46,49.46,49.46,49.46,48.34,48.34,48.34,48.34,48.34,48.34,48.34,48.34,48.34,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,57.44,50.8,50.8,50.8,50.8,50.8,50.8,50.8,50.8,50.8,50.8,50.8,50.8,50.8,48.02,48.02,48.02,48.02,47.59,47.59,47.59,47.59,49.4,49.4,49.4,49.4,49.18,46.84,50.26,49.07,47.76,45.04,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,48.86,54.6694228682763,52.00609521407532,47.583633130072144,54.6694228682763,52.00609521407532,47.583633130072144,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,49.89,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,50.17,54.55,54.55,54.55,54.55,54.55,54.55,54.55,54.55,52.0,52.0,52.0,52.0,52.0,52.0,52.0,52.0,52.0,52.0,52.0,50.92,50.92,50.92,50.92,50.92,50.92,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,54.8,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47,53.47], 
'TiO2': [1.58,1.58,1.58,1.58,1.58,1.58,1.58,1.58,1.58,1.58,2.86,2.86,2.86,2.86,2.86,2.86,2.86,2.86,2.86,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.06,1.84,1.84,1.84,1.84,1.84,1.84,1.84,1.84,1.84,1.84,1.84,1.84,1.84,0.96,0.96,0.96,0.96,1.66,1.66,1.66,1.66,0.8,0.8,0.8,0.8,0.9,0.71,0.99,0.86,0.86,0.79,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.73,1.3874365676450244,1.2256187201524469,1.2293858626310246,1.3874365676450244,1.2256187201524469,1.2293858626310246,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.89,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,0.92,2.02,2.02,2.02,2.02,2.02,2.02,2.02,2.02,1.26,1.26,1.26,1.26,1.26,1.26,1.26,1.26,1.26,1.26,1.26,2.02,2.02,2.02,2.02,2.02,2.02,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71,0.71], 
'Al2O3': [14.32,14.32,14.32,14.32,14.32,14.32,14.32,14.32,14.32,14.32,14.61,14.61,14.61,14.61,14.61,14.61,14.61,14.61,14.61,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,17.53,13.3,13.3,13.3,13.3,13.3,13.3,13.3,13.3,13.3,13.3,13.3,13.3,13.3,14.52,14.52,14.52,14.52,17.19,17.19,17.19,17.19,15.8,15.8,15.8,15.8,14.7,14.48,15.44,14.8,15.13,14.31,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,16.77,13.046199179471685,12.451561350855613,11.608583979905855,13.046199179471685,12.451561350855613,11.608583979905855,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,15.57,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,18.28,14.5,14.5,14.5,14.5,14.5,14.5,14.5,14.5,14.33,14.33,14.33,14.33,14.33,14.33,14.33,14.33,14.33,14.33,14.33,13.71,13.71,13.71,13.71,13.71,13.71,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,21.1,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48,15.48], 
'MgO': [7.11,7.11,7.11,7.11,7.11,7.11,7.11,7.11,7.11,7.11,6.4,6.4,6.4,6.4,6.4,6.4,6.4,6.4,6.4,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,4.31,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.67,6.82,6.82,6.82,6.82,5.72,5.72,5.72,5.72,8.0,8.0,8.0,8.0,7.65,6.86,7.27,7.55,6.66,6.64,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,6.65,8.456176980518327,9.325462051530584,10.953270976472194,8.456176980518327,9.325462051530584,10.953270976472194,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,5.75,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0,2.95,2.95,2.95,2.95,2.95,2.95,2.95,2.95,7.7,7.7,7.7,7.7,7.7,7.7,7.7,7.7,7.7,7.7,7.7,7.11,7.11,7.11,7.11,7.11,7.11,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88,4.88], 
'CaO': [12.25,12.25,12.25,12.25,12.25,12.25,12.25,12.25,12.25,12.25,10.87,10.87,10.87,10.87,10.87,10.87,10.87,10.87,10.87,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,7.42,11.5,11.5,11.5,11.5,11.5,11.5,11.5,11.5,11.5,11.5,11.5,11.5,11.5,12.77,12.77,12.77,12.77,10.85,10.85,10.85,10.85,12.7,12.7,12.7,12.7,15.41,19.45,13.46,15.84,17.26,21.85,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,9.86,8.096445860978557,11.47729365836789,15.994517462644044,8.096445860978557,11.47729365836789,15.994517462644044,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.4,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,11.37,6.96,6.96,6.96,6.96,6.96,6.96,6.96,6.96,11.7,11.7,11.7,11.7,11.7,11.7,11.7,11.7,11.7,11.7,11.7,10.88,10.88,10.88,10.88,10.88,10.88,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,12.9,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51,8.51], 
'Na2O': [2.92,2.92,2.92,2.92,2.92,2.92,2.92,2.92,2.92,2.92,2.6,2.6,2.6,2.6,2.6,2.6,2.6,2.6,2.6,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,3.32,2.68,2.68,2.68,2.68,2.68,2.68,2.68,2.68,2.68,2.68,2.68,2.68,2.68,1.8,1.8,1.8,1.8,3.42,3.42,3.42,3.42,2.3,2.3,2.3,2.3,2.2,2.32,2.32,2.24,2.47,2.37,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,0.8599266454632133,0.8211677323740195,0.8374903283779769,0.8599266454632133,0.8211677323740195,0.8374903283779769,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,1.95,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,2.33,3.95,3.95,3.95,3.95,3.95,3.95,3.95,3.95,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.63,2.63,2.63,2.63,2.63,2.63,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.2,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66,3.66], 
'K2O': [0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.14,0.3,0.3,0.3,0.3,0.3,0.3,0.3,0.3,0.3,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,1.61,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,5.55,5.55,5.55,5.55,1.98,1.98,1.98,1.98,1.9,1.9,1.9,1.9,1.89,1.77,2.04,1.8,1.98,1.88,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,1.93,7.894857426102221,7.250361323734428,6.614150428735263,7.894857426102221,7.250361323734428,6.614150428735263,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,7.72,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,0.23,1.28,1.28,1.28,1.28,1.28,1.28,1.28,1.28,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.16,0.16,0.16,0.16,0.16,0.16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72,4.72], 
'P2O5': [0.11,0.11,0.11,0.11,0.11,0.11,0.11,0.11,0.11,0.11,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.19,0.65,0.65,0.65,0.65,0.51,0.51,0.51,0.51,0.4,0.4,0.4,0.4,0.65,0.62,0.69,0.66,0.66,0.62,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.68,0.6,0.6,0.6,0.6,0.6,0.6,float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),float('nan'),0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,0.15,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0], 
'H2O': [0.0583,0.0148,0.0148,0.7743,0.702,2.0,2.0,2.0,2.54,2.54,2.9,2.43,1.85,2.0,1.14,0.94,0.97,0.82,0.72,2.82,2.12,7.97,7.97,7.97,5.57,3.11,3.33,3.04,1.78,7.81,4.05,2.24,1.26,7.72,4.56,3.1,0.48,1.83,1.02,1.41,0.83,0.86,1.67,1.67,1.58,0.37,1.58,1.58,0.37,0.8,0.82,0.85,1.02,1.49,1.55,0.73,1.51,1.58,0.71,0.98,0.91,2.6,2.8,2.4,1.9,2.3,1.5,0.99,2.09,2.7,1.43,3.01,0.95,1.18,1.64,0.7987433766381808,0.8677874141271976,1.14,1.04,0.9873751145213252,0.95,2.0785175378465297,3.453686057192372,2.815484147662085,3.536622548554782,2.11581136868401,1.3623921585745011,1.465932360818308,3.3061210747806355,2.1568867803709026,3.078120531153614,2.292292382508472,1.8293198829221402,3.078120531153614,2.292292382508472,1.8293198829221402,0.94,0.87,1.37,2.28,2.82,3.21,3.55,5.54,5.59,6.91,6.87,9.27,2.67,1.41,4.64,2.78,1.97,1.57,2.84,0.94,0.94,0.87,1.37,2.28,2.82,3.21,3.55,5.54,5.59,6.91,6.87,9.27,2.67,1.41,4.64,2.78,1.97,1.57,2.84,1.5,0.9,1.98,1.21,0.84,0.84,2.18,0.78,0.55,4.12,3.88,2.95,0.52,5.68,4.13,2.99,0.52,6.68,5.04,2.97,3.1,5.75,1.63,2.74,4.01,6.87,8.69,8.19,7.75,6.27,4.76,4.07,4.01,1.22,0.27,0.37,0.37,0.36,0.3,0.44,0.52,0.62,0.44,0.29,0.38,0.06,0.33,0.11,0.35,0.29,0.65,2.601394455037413,2.548348952230044,2.440629877267051,2.475327154959472,1.2426329467709332,2.0221968544387585,1.3096217124394185,1.6542204836415362,4.005000181972694,2.7920938001033537,1.32,3.66,2.601394455037413,2.548348952230044,2.440629877267051,2.475327154959472,1.2426329467709332,2.0221968544387585,1.3096217124394185,1.6542204836415362,4.005000181972694,2.7920938001033537,1.32,3.66,2.05,1.53,1.0,0.64,0.64,3.25,2.92,2.5,1.67,4.56,3.12,2.22,0.84,5.71,1.6,1.6,0.97,0.97,7.31,5.43,2.23,0.95], 
'CO2': [255.0,567.0,535.0,895.0,901.0,103.0,110.0,105.0,294.0,267.0,814.0,782.0,794.0,992.0,1033.0,1006.0,976.0,1061.0,1059.0,1460.0,1170.0,3210.0,3210.0,3210.0,3630.0,3740.0,1010.0,1300.0,1570.0,3300.0,4030.0,4140.0,3700.0,4540.0,4290.0,4450.0,306.0,293.0,72.0,125.0,204.0,197.0,62.0,62.0,64.0,223.0,64.0,64.0,223.0,2094.0,582.0,215.0,1022.0,1429.0,661.0,383.0,504.0,1170.0,279.0,73.0,613.0,1950.0,4300.0,1300.0,2050.0,2800.0,6000.0,680.0,532.0,1326.0,1150.0,940.0,281.0,170.0,2270.0,808.0,1706.0,1853.0,2816.0,843.0,306.0,534.0,1408.0,1489.0,2416.0,548.0,3673.0,3965.0,4061.0,4230.0,3176.0,5367.0,9749.0,3176.0,5367.0,9749.0,9040.0,2860.0,2650.0,8240.0,9150.0,7340.0,960.0,7360.0,6180.0,5300.0,4800.0,3990.0,2760.0,3640.0,760.0,2570.0,3030.0,2870.0,2640.0,9040.0,9040.0,2860.0,2650.0,8240.0,9150.0,7340.0,960.0,7360.0,6180.0,5300.0,4800.0,3990.0,2760.0,3640.0,760.0,2570.0,3030.0,2870.0,2640.0,61.0,94.0,199.0,116.0,179.0,178.0,160.0,297.0,346.0,36.0,301.0,608.0,1008.0,382.0,1036.0,1417.0,1655.0,693.0,1294.0,2221.0,3334.0,2463.0,3376.0,3227.0,3082.0,2228.0,10800.0,10600.0,11900.0,11500.0,11800.0,10300.0,10500.0,11400.0,125.69050791007493,178.4585345545379,257.24412989175687,244.05212323064112,366.07818484596174,535.0091590341382,651.1721065778518,484.43980016652785,541.6051623646962,740.218151540383,960.0849292256453,27.0,73.0,201.0,184.0,443.0,549.0,1404.0,1232.0,1408.0,1197.0,514.0,1129.0,1224.0,1044.0,1257.0,1320.0,681.0,818.0,1404.0,1232.0,1408.0,1197.0,514.0,1129.0,1224.0,1044.0,1257.0,1320.0,681.0,818.0,0.0,169.0,281.0,307.0,328.0,0.0,215.0,324.0,511.0,461.0,1011.0,1262.0,1401.0,800.0,1955.0,2050.0,2242.0,2230.0,1173.0,2114.0,2503.0,2933.0], 
 }) 

df_MagmaSat_CO2H2O = pd.DataFrame({ 
'SiO2': [42.4312473145893,43.7713289510724,46.2835254482269,47.3924662811199,49.0880818801249,49.9256007500218,50.0100214174358,49.4251472140048,48.4429145492049,48.0454017538921,48.0241551142565,49.1409669782977,48.7670158317817,50.171711946188,49.9637726788586,49.5241267168108,49.5660026603056,55.7611729544373,53.5617599172934,58.841987146246,57.4655341436071,57.5911619740916,54.8284300410404,54.7586710983144,54.4236121057076,54.046728614254,49.8589799308254,48.811464007678,48.8742264782722,50.2967224408962,50.7371915173125,50.8210977382463,60.0214071469374,60.1071653752002,60.400039756424,61.8431650229072,65.9916614398904,66.2848959336504,77.6819432577879,76.992945086748], 
'Na2O+K2O': [4.69413543359195,4.70850392378619,4.59915832440254,4.36799694295323,4.2592532459515,4.25863591017517,4.45820513327044,4.87325540909607,5.42680496634285,5.51923556545487,5.42711363423102,7.54545505054745,8.42103781552031,8.97282796580453,9.40295666796718,9.41863699668614,9.41860612989732,8.67693892820631,8.40214734076441,9.54997518310179,4.92875389538874,4.92866129502229,5.25317927924813,3.18013487552041,3.16502558239456,3.16530338349392,3.12232138006647,2.93881832055036,2.92341579293076,2.53846063620155,2.76847994646463,2.81448689519613,5.35684538948948,5.95567652593057,5.87867932122696,5.40157136648508,6.22775183595659,6.25824822330763,8.27687447835126,8.86092042294908], 
 }) 

df_Liu_H2O = pd.DataFrame({ 
'SiO2': [77.19,75.03,76.47,77.24,76.62,0.38,77.5,77.7,77.04,76.14,77.3,77.71,77.38], 
'TiO2': [0.06,0.2,0.07,0.07,0.03,0.02,0.0,0.07,0.11,'No Data',0.06,0.12,0.17], 
'Al2O3': [12.8,13.42,12.44,12.67,13.53,0.15,12.5,13.0,12.76,13.53,13.0,12.13,12.33], 
'FeO': [0.94,1.46,1.02,0.55,0.02,0.05,1.0,0.38,0.68,'No Data',0.75,0.66,1.26], 
'MgO': [0.03,0.13,0.03,0.05,0.01,0.01,0.0,0.05,0.08,'No Data',0.05,0.17,0.17], 
'CaO': [0.53,0.62,0.53,0.51,0.01,0.03,0.5,0.52,0.58,'No Data',0.52,0.54,1.11], 
'Na2O': [3.98,4.24,4.18,4.3,4.57,0.26,3.6,4.08,4.07,4.65,4.12,3.42,3.39], 
'K2O': [4.65,4.99,4.61,4.13,5.19,0.12,4.8,4.19,4.79,5.67,4.16,5.22,3.58]
 }) 

df_Liu_CO2 = pd.DataFrame({ 
'SiO2': [76.45,77.7,77.04], 
'TiO2': [0.08,0.07,0.11], 
'Al2O3': [12.56,13.0,12.76], 
'FeO': [1.02,0.38,0.68], 
'MgO': [0.06,0.05,0.08], 
'CaO': [0.25,0.52,0.58], 
'Na2O': [4.21,4.08,4.07], 
'K2O': [4.78,4.19,4.79]
 }) 

def return_calibration_type(model_name):
	"""
	Returns metadata for the calibration dataset for specified model

	Parameters
	----------
	model: string
		String of model name.
		
	Returns
	-------
	dict
		Metadata on the dataset. A dict is returned with parameters CO2, H2O, or mixed set to True or False.
		True indicates that experiments where performed using that fluid type. For example, a model may be
		able to calculate mixed H2O-CO2 solubilities, but it's dataset may be made up only of pure-CO2 and
		pure-H2O data. In this case, a model's metadata would be {'CO2': True, 'H2O': True, 'Mixed': False}.
	"""
	if model_name == 'Shishkina':
		return {'CO2': True, 'H2O': True, 'Mixed': False}

	if model_name == 'Dixon':
		return {'CO2': True, 'H2O': True, 'Mixed': False}

	if model_name == 'IaconoMarziano':
		return {'CO2': False, 'H2O': True, 'Mixed': True}

	if model_name == 'Liu':
		return {'CO2': True, 'H2O': True, 'Mixed': False}

	if model_name == 'ShishkinaCarbon':
		return {'CO2': True, 'H2O': False, 'Mixed': False}

	if model_name == 'ShishkinaWater':
		return {'CO2': False, 'H2O': True, 'Mixed': False}

	if model_name == 'DixonCarbon':
		return {'CO2': True, 'H2O': False, 'Mixed': False}

	if model_name == 'DixonWater':
		return {'CO2': False, 'H2O': True, 'Mixed': False}

	if model_name == 'IaconoMarzianoCarbon':
		return {'CO2': True, 'H2O': False, 'Mixed': False}

	if model_name == 'IaconoMarzianoWater':
		return {'CO2': False, 'H2O': True, 'Mixed': False}

	if model_name == 'AllisonCarbon':
		return {'CO2': True, 'H2O': False, 'Mixed': False}

	if model_name == 'MooreWater':
		return {'CO2': False, 'H2O': True, 'Mixed': False}

	if model_name == 'LiuCarbon':
		return {'CO2': True, 'H2O': False, 'Mixed': False}

	if model_name == 'LiuWater':
		return {'CO2': False, 'H2O': True, 'Mixed': False}

def return_calibration(model_name):
	"""
	Returns the calibration dataset for specified model

	Parameters
	----------
	model: string
		String of model name.

	Returns
	-------
	dict
		Dictionary with keys 'CO2', 'H2O', and 'Mixed' and corresponding datasets. If a dataset
		for a particular key is nonexistent, None will be returned for that value.
	"""

	if model_name == 'Shishkina':
		return {'CO2': df_Shishkina_CO2, 'H2O': df_Shishkina_H2O, 'marker':'d', 'facecolor':'darkorange'}

	if model_name == 'Dixon':
		return {'CO2': df_Dixon_CO2, 'H2O': df_Dixon_H2O, 'marker':'d', 'facecolor':'blue'}

	if model_name == 'IaconoMarziano':
		return {'H2O': df_Iacono_H2O, 'Mixed': df_Iacono_CO2H2O, 'marker':'d', 'facecolor':'magenta'}

	if model_name == 'Liu':
		return {'CO2': df_Liu_CO2, 'H2O': df_Liu_H2O, 'marker':'d', 'facecolor':'deepskyblue'}

	if model_name == 'ShishkinaCarbon':
		return {'CO2': df_Shishkina_CO2, 'marker':'o', 'facecolor':'darkorange'}

	if model_name == 'ShishkinaWater':
		return {'H2O': df_Shishkina_H2O, 'marker':'s', 'facecolor':'darkorange'}

	if model_name == 'DixonCarbon':
		return {'CO2': df_Dixon_CO2,'marker':'o', 'facecolor':'blue'}

	if model_name == 'DixonWater':
		return {'H2O': df_Dixon_H2O, 'marker':'s', 'facecolor':'blue'}

	if model_name == 'IaconoMarzianoCarbon':
		return "No CO2-only data for this model. Try 'IaconoMarziano' or 'IaconoMarzianoWater'"

	if model_name == 'IaconoMarzianoWater':
		return {'H2O': df_Iacono_H2O, 'marker':'s', 'facecolor':'magenta'}

	if model_name == 'AllisonCarbon':
		return {'CO2': df_Allison_CO2, 'marker':'o', 'facecolor':'yellow'}

	if model_name == 'MooreWater':
		return {'H2O': df_Moore_H2O, 'marker':'s', 'facecolor':'lime'}

	if model_name == 'LiuCarbon':
		return {'CO2': df_Liu_CO2, 'marker':'o', 'facecolor':'deepskyblue'}

	if model_name == 'LiuWater':
		return {'H2O': df_Liu_H2O, 'marker':'s', 'facecolor':'deepskyblue'}

	if model_name == 'MagmaSat':
		return {'CO2': df_MagmaSat_CO2, 'H2O': df_MagmaSat_H2O, 'Mixed': df_MagmaSat_CO2H2O, 'marker':'d', 'facecolor':'silver'}


	




