# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class GroupMemberEntityIds(pulumi.CustomResource):
    exclusive: pulumi.Output[bool]
    """
    Defaults to `true`.
    """
    group_id: pulumi.Output[str]
    """
    Group ID to assign member entities to.
    """
    group_name: pulumi.Output[str]
    """
    The name of the group that are assigned the member entities.
    """
    member_entity_ids: pulumi.Output[list]
    """
    List of member entities that belong to the group
    """
    def __init__(__self__, resource_name, opts=None, exclusive=None, group_id=None, member_entity_ids=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages member entities for an Identity Group for Vault. The [Identity secrets engine](https://www.vaultproject.io/docs/secrets/identity/index.html) is the identity management solution for Vault.

        ## Example Usage
        ### Exclusive Member Entities

        ```python
        import pulumi
        import pulumi_vault as vault

        internal = vault.identity.Group("internal",
            type="internal",
            external_member_entity_ids=True,
            metadata={
                "version": "2",
            })
        user = vault.identity.Entity("user")
        members = vault.identity.GroupMemberEntityIds("members",
            exclusive=True,
            member_entity_ids=[user.id],
            group_id=internal.id)
        ```
        ### Non-exclusive Member Entities

        ```python
        import pulumi
        import pulumi_vault as vault

        internal = vault.identity.Group("internal",
            type="internal",
            external_member_entity_ids=True,
            metadata={
                "version": "2",
            })
        test_user = vault.identity.Entity("testUser")
        second_test_user = vault.identity.Entity("secondTestUser")
        dev_user = vault.identity.Entity("devUser")
        test = vault.identity.GroupMemberEntityIds("test",
            member_entity_ids=[
                test_user.id,
                second_test_user.id,
            ],
            exclusive=False,
            group_id=internal.id)
        others = vault.identity.GroupMemberEntityIds("others",
            member_entity_ids=[dev_user.id],
            exclusive=False,
            group_id=internal.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] exclusive: Defaults to `true`.
        :param pulumi.Input[str] group_id: Group ID to assign member entities to.
        :param pulumi.Input[list] member_entity_ids: List of member entities that belong to the group
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['exclusive'] = exclusive
            if group_id is None:
                raise TypeError("Missing required property 'group_id'")
            __props__['group_id'] = group_id
            __props__['member_entity_ids'] = member_entity_ids
            __props__['group_name'] = None
        super(GroupMemberEntityIds, __self__).__init__(
            'vault:identity/groupMemberEntityIds:GroupMemberEntityIds',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, exclusive=None, group_id=None, group_name=None, member_entity_ids=None):
        """
        Get an existing GroupMemberEntityIds resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] exclusive: Defaults to `true`.
        :param pulumi.Input[str] group_id: Group ID to assign member entities to.
        :param pulumi.Input[str] group_name: The name of the group that are assigned the member entities.
        :param pulumi.Input[list] member_entity_ids: List of member entities that belong to the group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["exclusive"] = exclusive
        __props__["group_id"] = group_id
        __props__["group_name"] = group_name
        __props__["member_entity_ids"] = member_entity_ids
        return GroupMemberEntityIds(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
