# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class OidcKey(pulumi.CustomResource):
    algorithm: pulumi.Output[str]
    """
    Signing algorithm to use. Signing algorithm to use.
    Allowed values are: RS256 (default), RS384, RS512, ES256, ES384, ES512, EdDSA.
    """
    allowed_client_ids: pulumi.Output[list]
    """
    Array of role client ids allowed to use this key for signing. If empty, no roles are allowed. If "*", all roles are
    allowed.
    """
    name: pulumi.Output[str]
    """
    Name of the OIDC Key to create.
    """
    rotation_period: pulumi.Output[float]
    """
    How often to generate a new signing key in number of seconds
    """
    verification_ttl: pulumi.Output[float]
    """
    "Controls how long the public portion of a signing key will be
    available for verification after being rotated in seconds.
    """
    def __init__(__self__, resource_name, opts=None, algorithm=None, allowed_client_ids=None, name=None, rotation_period=None, verification_ttl=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a OidcKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: Signing algorithm to use. Signing algorithm to use.
               Allowed values are: RS256 (default), RS384, RS512, ES256, ES384, ES512, EdDSA.
        :param pulumi.Input[list] allowed_client_ids: Array of role client ids allowed to use this key for signing. If empty, no roles are allowed. If "*", all roles are
               allowed.
        :param pulumi.Input[str] name: Name of the OIDC Key to create.
        :param pulumi.Input[float] rotation_period: How often to generate a new signing key in number of seconds
        :param pulumi.Input[float] verification_ttl: "Controls how long the public portion of a signing key will be
               available for verification after being rotated in seconds.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['algorithm'] = algorithm
            __props__['allowed_client_ids'] = allowed_client_ids
            __props__['name'] = name
            __props__['rotation_period'] = rotation_period
            __props__['verification_ttl'] = verification_ttl
        super(OidcKey, __self__).__init__(
            'vault:identity/oidcKey:OidcKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, algorithm=None, allowed_client_ids=None, name=None, rotation_period=None, verification_ttl=None):
        """
        Get an existing OidcKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: Signing algorithm to use. Signing algorithm to use.
               Allowed values are: RS256 (default), RS384, RS512, ES256, ES384, ES512, EdDSA.
        :param pulumi.Input[list] allowed_client_ids: Array of role client ids allowed to use this key for signing. If empty, no roles are allowed. If "*", all roles are
               allowed.
        :param pulumi.Input[str] name: Name of the OIDC Key to create.
        :param pulumi.Input[float] rotation_period: How often to generate a new signing key in number of seconds
        :param pulumi.Input[float] verification_ttl: "Controls how long the public portion of a signing key will be
               available for verification after being rotated in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["algorithm"] = algorithm
        __props__["allowed_client_ids"] = allowed_client_ids
        __props__["name"] = name
        __props__["rotation_period"] = rotation_period
        __props__["verification_ttl"] = verification_ttl
        return OidcKey(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
