# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class Transformation(pulumi.CustomResource):
    allowed_roles: pulumi.Output[list]
    """
    The set of roles allowed to perform this transformation.
    """
    masking_character: pulumi.Output[str]
    """
    The character used to replace data when in masking mode
    """
    name: pulumi.Output[str]
    """
    The name of the transformation.
    """
    path: pulumi.Output[str]
    """
    The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
    """
    template: pulumi.Output[str]
    """
    The name of the template to use.
    """
    templates: pulumi.Output[list]
    """
    Templates configured for transformation.
    """
    tweak_source: pulumi.Output[str]
    """
    The source of where the tweak value comes from. Only valid when in FPE mode.
    """
    type: pulumi.Output[str]
    """
    The type of transformation to perform.
    """
    def __init__(__self__, resource_name, opts=None, allowed_roles=None, masking_character=None, name=None, path=None, template=None, templates=None, tweak_source=None, type=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Transformation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] allowed_roles: The set of roles allowed to perform this transformation.
        :param pulumi.Input[str] masking_character: The character used to replace data when in masking mode
        :param pulumi.Input[str] name: The name of the transformation.
        :param pulumi.Input[str] path: The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
        :param pulumi.Input[str] template: The name of the template to use.
        :param pulumi.Input[list] templates: Templates configured for transformation.
        :param pulumi.Input[str] tweak_source: The source of where the tweak value comes from. Only valid when in FPE mode.
        :param pulumi.Input[str] type: The type of transformation to perform.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['allowed_roles'] = allowed_roles
            __props__['masking_character'] = masking_character
            __props__['name'] = name
            if path is None:
                raise TypeError("Missing required property 'path'")
            __props__['path'] = path
            __props__['template'] = template
            __props__['templates'] = templates
            __props__['tweak_source'] = tweak_source
            __props__['type'] = type
        super(Transformation, __self__).__init__(
            'vault:transform/transformation:Transformation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, allowed_roles=None, masking_character=None, name=None, path=None, template=None, templates=None, tweak_source=None, type=None):
        """
        Get an existing Transformation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] allowed_roles: The set of roles allowed to perform this transformation.
        :param pulumi.Input[str] masking_character: The character used to replace data when in masking mode
        :param pulumi.Input[str] name: The name of the transformation.
        :param pulumi.Input[str] path: The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
        :param pulumi.Input[str] template: The name of the template to use.
        :param pulumi.Input[list] templates: Templates configured for transformation.
        :param pulumi.Input[str] tweak_source: The source of where the tweak value comes from. Only valid when in FPE mode.
        :param pulumi.Input[str] type: The type of transformation to perform.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["allowed_roles"] = allowed_roles
        __props__["masking_character"] = masking_character
        __props__["name"] = name
        __props__["path"] = path
        __props__["template"] = template
        __props__["templates"] = templates
        __props__["tweak_source"] = tweak_source
        __props__["type"] = type
        return Transformation(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
