# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class ApplicationResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'uri': 'str',
        'date_created': 'str',
        'date_updated': 'str',
        'revision': 'int',
        'account_id': 'str',
        'application_id': 'str',
        'alias': 'str',
        'voice_url': 'str',
        'voice_fallback_url': 'str',
        'call_connect_url': 'str',
        'status_callback_url': 'str',
        'sms_url': 'str',
        'sms_fallback_url': 'str'
    }

    attribute_map = {
        'uri': 'uri',
        'date_created': 'dateCreated',
        'date_updated': 'dateUpdated',
        'revision': 'revision',
        'account_id': 'accountId',
        'application_id': 'applicationId',
        'alias': 'alias',
        'voice_url': 'voiceUrl',
        'voice_fallback_url': 'voiceFallbackUrl',
        'call_connect_url': 'callConnectUrl',
        'status_callback_url': 'statusCallbackUrl',
        'sms_url': 'smsUrl',
        'sms_fallback_url': 'smsFallbackUrl'
    }

    def __init__(self, uri=None, date_created=None, date_updated=None, revision=None, account_id=None, application_id=None, alias=None, voice_url=None, voice_fallback_url=None, call_connect_url=None, status_callback_url=None, sms_url=None, sms_fallback_url=None, local_vars_configuration=None):  # noqa: E501
        """ApplicationResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._uri = None
        self._date_created = None
        self._date_updated = None
        self._revision = None
        self._account_id = None
        self._application_id = None
        self._alias = None
        self._voice_url = None
        self._voice_fallback_url = None
        self._call_connect_url = None
        self._status_callback_url = None
        self._sms_url = None
        self._sms_fallback_url = None
        self.discriminator = None

        if uri is not None:
            self.uri = uri
        if date_created is not None:
            self.date_created = date_created
        if date_updated is not None:
            self.date_updated = date_updated
        if revision is not None:
            self.revision = revision
        if account_id is not None:
            self.account_id = account_id
        if application_id is not None:
            self.application_id = application_id
        if alias is not None:
            self.alias = alias
        if voice_url is not None:
            self.voice_url = voice_url
        if voice_fallback_url is not None:
            self.voice_fallback_url = voice_fallback_url
        if call_connect_url is not None:
            self.call_connect_url = call_connect_url
        if status_callback_url is not None:
            self.status_callback_url = status_callback_url
        if sms_url is not None:
            self.sms_url = sms_url
        if sms_fallback_url is not None:
            self.sms_fallback_url = sms_fallback_url

    @property
    def uri(self):
        """Gets the uri of this ApplicationResult.  # noqa: E501

        The URI for this resource, relative to /apiserver.  # noqa: E501

        :return: The uri of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this ApplicationResult.

        The URI for this resource, relative to /apiserver.  # noqa: E501

        :param uri: The uri of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def date_created(self):
        """Gets the date_created of this ApplicationResult.  # noqa: E501

        The date that this resource was created (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :return: The date_created of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this ApplicationResult.

        The date that this resource was created (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :param date_created: The date_created of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._date_created = date_created

    @property
    def date_updated(self):
        """Gets the date_updated of this ApplicationResult.  # noqa: E501

        The date that this resource was last updated (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :return: The date_updated of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._date_updated

    @date_updated.setter
    def date_updated(self, date_updated):
        """Sets the date_updated of this ApplicationResult.

        The date that this resource was last updated (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :param date_updated: The date_updated of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._date_updated = date_updated

    @property
    def revision(self):
        """Gets the revision of this ApplicationResult.  # noqa: E501

        Revision count for the resource. This count is set to 1 on creation and is incremented every time it is updated.  # noqa: E501

        :return: The revision of this ApplicationResult.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this ApplicationResult.

        Revision count for the resource. This count is set to 1 on creation and is incremented every time it is updated.  # noqa: E501

        :param revision: The revision of this ApplicationResult.  # noqa: E501
        :type: int
        """

        self._revision = revision

    @property
    def account_id(self):
        """Gets the account_id of this ApplicationResult.  # noqa: E501

        ID of the account that owns this phone number.  # noqa: E501

        :return: The account_id of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this ApplicationResult.

        ID of the account that owns this phone number.  # noqa: E501

        :param account_id: The account_id of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def application_id(self):
        """Gets the application_id of this ApplicationResult.  # noqa: E501

        ID of the Application that FreeClimb should contact if a Call or SMS arrives for this phone number or a Call from this number is placed. An incoming phone number is not useful until associated with an applicationId.  # noqa: E501

        :return: The application_id of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._application_id

    @application_id.setter
    def application_id(self, application_id):
        """Sets the application_id of this ApplicationResult.

        ID of the Application that FreeClimb should contact if a Call or SMS arrives for this phone number or a Call from this number is placed. An incoming phone number is not useful until associated with an applicationId.  # noqa: E501

        :param application_id: The application_id of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._application_id = application_id

    @property
    def alias(self):
        """Gets the alias of this ApplicationResult.  # noqa: E501

        Description for this phone number. Typically the conventionally-formatted version of the phone number.  # noqa: E501

        :return: The alias of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this ApplicationResult.

        Description for this phone number. Typically the conventionally-formatted version of the phone number.  # noqa: E501

        :param alias: The alias of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._alias = alias

    @property
    def voice_url(self):
        """Gets the voice_url of this ApplicationResult.  # noqa: E501

        The URL FreeClimb will request when a phone number assigned to this Application receives a Call. Used for inbound calls only.  # noqa: E501

        :return: The voice_url of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._voice_url

    @voice_url.setter
    def voice_url(self, voice_url):
        """Sets the voice_url of this ApplicationResult.

        The URL FreeClimb will request when a phone number assigned to this Application receives a Call. Used for inbound calls only.  # noqa: E501

        :param voice_url: The voice_url of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._voice_url = voice_url

    @property
    def voice_fallback_url(self):
        """Gets the voice_fallback_url of this ApplicationResult.  # noqa: E501

        The URL that FreeClimb will request if it times out waiting for a response from the voiceUrl. Used for inbound calls only.  # noqa: E501

        :return: The voice_fallback_url of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._voice_fallback_url

    @voice_fallback_url.setter
    def voice_fallback_url(self, voice_fallback_url):
        """Sets the voice_fallback_url of this ApplicationResult.

        The URL that FreeClimb will request if it times out waiting for a response from the voiceUrl. Used for inbound calls only.  # noqa: E501

        :param voice_fallback_url: The voice_fallback_url of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._voice_fallback_url = voice_fallback_url

    @property
    def call_connect_url(self):
        """Gets the call_connect_url of this ApplicationResult.  # noqa: E501

        The URL to which FreeClimb will make a POST request informing the result of the outbound Call request. The status property of the request message specifies if the Call was connected or not.  # noqa: E501

        :return: The call_connect_url of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._call_connect_url

    @call_connect_url.setter
    def call_connect_url(self, call_connect_url):
        """Sets the call_connect_url of this ApplicationResult.

        The URL to which FreeClimb will make a POST request informing the result of the outbound Call request. The status property of the request message specifies if the Call was connected or not.  # noqa: E501

        :param call_connect_url: The call_connect_url of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._call_connect_url = call_connect_url

    @property
    def status_callback_url(self):
        """Gets the status_callback_url of this ApplicationResult.  # noqa: E501

        A URL to which FreeClimb will make a POST request when the Call ends to notify this app.  # noqa: E501

        :return: The status_callback_url of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._status_callback_url

    @status_callback_url.setter
    def status_callback_url(self, status_callback_url):
        """Sets the status_callback_url of this ApplicationResult.

        A URL to which FreeClimb will make a POST request when the Call ends to notify this app.  # noqa: E501

        :param status_callback_url: The status_callback_url of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._status_callback_url = status_callback_url

    @property
    def sms_url(self):
        """Gets the sms_url of this ApplicationResult.  # noqa: E501

        The URL FreeClimb will request when a phone number assigned to this Application receives an incoming SMS message. Used for inbound SMS only.  # noqa: E501

        :return: The sms_url of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._sms_url

    @sms_url.setter
    def sms_url(self, sms_url):
        """Sets the sms_url of this ApplicationResult.

        The URL FreeClimb will request when a phone number assigned to this Application receives an incoming SMS message. Used for inbound SMS only.  # noqa: E501

        :param sms_url: The sms_url of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._sms_url = sms_url

    @property
    def sms_fallback_url(self):
        """Gets the sms_fallback_url of this ApplicationResult.  # noqa: E501

        The URL that FreeClimb will request if it times out waiting for a response from the smsUrl. Used for inbound SMS only.  # noqa: E501

        :return: The sms_fallback_url of this ApplicationResult.  # noqa: E501
        :rtype: str
        """
        return self._sms_fallback_url

    @sms_fallback_url.setter
    def sms_fallback_url(self, sms_fallback_url):
        """Sets the sms_fallback_url of this ApplicationResult.

        The URL that FreeClimb will request if it times out waiting for a response from the smsUrl. Used for inbound SMS only.  # noqa: E501

        :param sms_fallback_url: The sms_fallback_url of this ApplicationResult.  # noqa: E501
        :type: str
        """

        self._sms_fallback_url = sms_fallback_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationResult):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
