# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class LogResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'timestamp': 'int',
        'level': 'str',
        'request_id': 'str',
        'account_id': 'str',
        'call_id': 'str',
        'message': 'str',
        'metadata': 'object'
    }

    attribute_map = {
        'timestamp': 'timestamp',
        'level': 'level',
        'request_id': 'requestId',
        'account_id': 'accountId',
        'call_id': 'callId',
        'message': 'message',
        'metadata': 'metadata'
    }

    def __init__(self, timestamp=None, level=None, request_id=None, account_id=None, call_id=None, message=None, metadata=None, local_vars_configuration=None):  # noqa: E501
        """LogResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._timestamp = None
        self._level = None
        self._request_id = None
        self._account_id = None
        self._call_id = None
        self._message = None
        self._metadata = None
        self.discriminator = None

        if timestamp is not None:
            self.timestamp = timestamp
        if level is not None:
            self.level = level
        if request_id is not None:
            self.request_id = request_id
        if account_id is not None:
            self.account_id = account_id
        if call_id is not None:
            self.call_id = call_id
        if message is not None:
            self.message = message
        if metadata is not None:
            self.metadata = metadata

    @property
    def timestamp(self):
        """Gets the timestamp of this LogResult.  # noqa: E501

        Time that the log was generated. The time is represented as microseconds since the Unix Epoch.  # noqa: E501

        :return: The timestamp of this LogResult.  # noqa: E501
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this LogResult.

        Time that the log was generated. The time is represented as microseconds since the Unix Epoch.  # noqa: E501

        :param timestamp: The timestamp of this LogResult.  # noqa: E501
        :type: int
        """

        self._timestamp = timestamp

    @property
    def level(self):
        """Gets the level of this LogResult.  # noqa: E501

        Level of the log. Possible values are info, warning, and error.  # noqa: E501

        :return: The level of this LogResult.  # noqa: E501
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """Sets the level of this LogResult.

        Level of the log. Possible values are info, warning, and error.  # noqa: E501

        :param level: The level of this LogResult.  # noqa: E501
        :type: str
        """
        allowed_values = ["info", "warning", "error"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and level not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `level` ({0}), must be one of {1}"  # noqa: E501
                .format(level, allowed_values)
            )

        self._level = level

    @property
    def request_id(self):
        """Gets the request_id of this LogResult.  # noqa: E501

        ID of the request associated with the log. The requestId is propagated across all logs generated by FreeClimb when processing a request.  # noqa: E501

        :return: The request_id of this LogResult.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this LogResult.

        ID of the request associated with the log. The requestId is propagated across all logs generated by FreeClimb when processing a request.  # noqa: E501

        :param request_id: The request_id of this LogResult.  # noqa: E501
        :type: str
        """

        self._request_id = request_id

    @property
    def account_id(self):
        """Gets the account_id of this LogResult.  # noqa: E501

        ID of the account that this log was generated under.  # noqa: E501

        :return: The account_id of this LogResult.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this LogResult.

        ID of the account that this log was generated under.  # noqa: E501

        :param account_id: The account_id of this LogResult.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def call_id(self):
        """Gets the call_id of this LogResult.  # noqa: E501

        ID of the Call associated with the log. Can be set to null if the log was generated without regard to a specific Call.  # noqa: E501

        :return: The call_id of this LogResult.  # noqa: E501
        :rtype: str
        """
        return self._call_id

    @call_id.setter
    def call_id(self, call_id):
        """Sets the call_id of this LogResult.

        ID of the Call associated with the log. Can be set to null if the log was generated without regard to a specific Call.  # noqa: E501

        :param call_id: The call_id of this LogResult.  # noqa: E501
        :type: str
        """

        self._call_id = call_id

    @property
    def message(self):
        """Gets the message of this LogResult.  # noqa: E501

        A simple string describing the event being logged.  # noqa: E501

        :return: The message of this LogResult.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this LogResult.

        A simple string describing the event being logged.  # noqa: E501

        :param message: The message of this LogResult.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def metadata(self):
        """Gets the metadata of this LogResult.  # noqa: E501

        JSON document containing metadata about the event. Some log messages may include request and response header content in this field.  # noqa: E501

        :return: The metadata of this LogResult.  # noqa: E501
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this LogResult.

        JSON document containing metadata about the event. Some log messages may include request and response header content in this field.  # noqa: E501

        :param metadata: The metadata of this LogResult.  # noqa: E501
        :type: object
        """

        self._metadata = metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LogResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LogResult):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
