# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class QueueMember(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'uri': 'str',
        'call_id': 'str',
        'wait_time': 'int',
        'position': 'int',
        'date_enqueued': 'str'
    }

    attribute_map = {
        'uri': 'uri',
        'call_id': 'callId',
        'wait_time': 'waitTime',
        'position': 'position',
        'date_enqueued': 'dateEnqueued'
    }

    def __init__(self, uri=None, call_id=None, wait_time=None, position=None, date_enqueued=None, local_vars_configuration=None):  # noqa: E501
        """QueueMember - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._uri = None
        self._call_id = None
        self._wait_time = None
        self._position = None
        self._date_enqueued = None
        self.discriminator = None

        if uri is not None:
            self.uri = uri
        if call_id is not None:
            self.call_id = call_id
        if wait_time is not None:
            self.wait_time = wait_time
        if position is not None:
            self.position = position
        if date_enqueued is not None:
            self.date_enqueued = date_enqueued

    @property
    def uri(self):
        """Gets the uri of this QueueMember.  # noqa: E501

        URI for this Queue Member resource, relative to the API base URL.  # noqa: E501

        :return: The uri of this QueueMember.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this QueueMember.

        URI for this Queue Member resource, relative to the API base URL.  # noqa: E501

        :param uri: The uri of this QueueMember.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def call_id(self):
        """Gets the call_id of this QueueMember.  # noqa: E501

        ID of the Call associated with this Queue Member.  # noqa: E501

        :return: The call_id of this QueueMember.  # noqa: E501
        :rtype: str
        """
        return self._call_id

    @call_id.setter
    def call_id(self, call_id):
        """Sets the call_id of this QueueMember.

        ID of the Call associated with this Queue Member.  # noqa: E501

        :param call_id: The call_id of this QueueMember.  # noqa: E501
        :type: str
        """

        self._call_id = call_id

    @property
    def wait_time(self):
        """Gets the wait_time of this QueueMember.  # noqa: E501

        Number of seconds the Member has been in the queue.  # noqa: E501

        :return: The wait_time of this QueueMember.  # noqa: E501
        :rtype: int
        """
        return self._wait_time

    @wait_time.setter
    def wait_time(self, wait_time):
        """Sets the wait_time of this QueueMember.

        Number of seconds the Member has been in the queue.  # noqa: E501

        :param wait_time: The wait_time of this QueueMember.  # noqa: E501
        :type: int
        """

        self._wait_time = wait_time

    @property
    def position(self):
        """Gets the position of this QueueMember.  # noqa: E501

        Member's current position in the Queue, 1 indexed.  # noqa: E501

        :return: The position of this QueueMember.  # noqa: E501
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """Sets the position of this QueueMember.

        Member's current position in the Queue, 1 indexed.  # noqa: E501

        :param position: The position of this QueueMember.  # noqa: E501
        :type: int
        """

        self._position = position

    @property
    def date_enqueued(self):
        """Gets the date_enqueued of this QueueMember.  # noqa: E501

        Date that the Member was enqueued (GMT), given in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :return: The date_enqueued of this QueueMember.  # noqa: E501
        :rtype: str
        """
        return self._date_enqueued

    @date_enqueued.setter
    def date_enqueued(self, date_enqueued):
        """Sets the date_enqueued of this QueueMember.

        Date that the Member was enqueued (GMT), given in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :param date_enqueued: The date_enqueued of this QueueMember.  # noqa: E501
        :type: str
        """

        self._date_enqueued = date_enqueued

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueueMember):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueueMember):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
