# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class RecordingResultAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'recording_id': 'str',
        'account_id': 'str',
        'call_id': 'str',
        'duration_sec': 'int',
        'conference_id': 'str'
    }

    attribute_map = {
        'recording_id': 'recordingId',
        'account_id': 'accountId',
        'call_id': 'callId',
        'duration_sec': 'durationSec',
        'conference_id': 'conferenceId'
    }

    def __init__(self, recording_id=None, account_id=None, call_id=None, duration_sec=None, conference_id=None, local_vars_configuration=None):  # noqa: E501
        """RecordingResultAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._recording_id = None
        self._account_id = None
        self._call_id = None
        self._duration_sec = None
        self._conference_id = None
        self.discriminator = None

        if recording_id is not None:
            self.recording_id = recording_id
        if account_id is not None:
            self.account_id = account_id
        if call_id is not None:
            self.call_id = call_id
        if duration_sec is not None:
            self.duration_sec = duration_sec
        if conference_id is not None:
            self.conference_id = conference_id

    @property
    def recording_id(self):
        """Gets the recording_id of this RecordingResultAllOf.  # noqa: E501

        String that uniquely identifies this recording resource.  # noqa: E501

        :return: The recording_id of this RecordingResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._recording_id

    @recording_id.setter
    def recording_id(self, recording_id):
        """Sets the recording_id of this RecordingResultAllOf.

        String that uniquely identifies this recording resource.  # noqa: E501

        :param recording_id: The recording_id of this RecordingResultAllOf.  # noqa: E501
        :type: str
        """

        self._recording_id = recording_id

    @property
    def account_id(self):
        """Gets the account_id of this RecordingResultAllOf.  # noqa: E501

        ID of the account that created this recording.  # noqa: E501

        :return: The account_id of this RecordingResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this RecordingResultAllOf.

        ID of the account that created this recording.  # noqa: E501

        :param account_id: The account_id of this RecordingResultAllOf.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def call_id(self):
        """Gets the call_id of this RecordingResultAllOf.  # noqa: E501

        ID of the Call that was recorded. If a Conference was recorded, this value is empty and the conferenceId property is populated.  # noqa: E501

        :return: The call_id of this RecordingResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._call_id

    @call_id.setter
    def call_id(self, call_id):
        """Sets the call_id of this RecordingResultAllOf.

        ID of the Call that was recorded. If a Conference was recorded, this value is empty and the conferenceId property is populated.  # noqa: E501

        :param call_id: The call_id of this RecordingResultAllOf.  # noqa: E501
        :type: str
        """

        self._call_id = call_id

    @property
    def duration_sec(self):
        """Gets the duration_sec of this RecordingResultAllOf.  # noqa: E501

        Length of the recording in seconds.  # noqa: E501

        :return: The duration_sec of this RecordingResultAllOf.  # noqa: E501
        :rtype: int
        """
        return self._duration_sec

    @duration_sec.setter
    def duration_sec(self, duration_sec):
        """Sets the duration_sec of this RecordingResultAllOf.

        Length of the recording in seconds.  # noqa: E501

        :param duration_sec: The duration_sec of this RecordingResultAllOf.  # noqa: E501
        :type: int
        """

        self._duration_sec = duration_sec

    @property
    def conference_id(self):
        """Gets the conference_id of this RecordingResultAllOf.  # noqa: E501

        ID of the Conference that was recorded. If a Call was recorded, this value is empty and the callId property is populated.  # noqa: E501

        :return: The conference_id of this RecordingResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._conference_id

    @conference_id.setter
    def conference_id(self, conference_id):
        """Sets the conference_id of this RecordingResultAllOf.

        ID of the Conference that was recorded. If a Call was recorded, this value is empty and the callId property is populated.  # noqa: E501

        :param conference_id: The conference_id of this RecordingResultAllOf.  # noqa: E501
        :type: str
        """

        self._conference_id = conference_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RecordingResultAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RecordingResultAllOf):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
