"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.instanceUserValidator = void 0;
var NAME = /^[\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*$/;
var CLIENTREQUESTTOKEN = /^[-_a-zA-Z0-9]*$/;
function instanceUserValidator(props) {
    if (props.name) {
        if (props.name.length < 1 || props.name.length > 256) {
            throw new Error('Name length must be >1 and <256');
        }
        if (!NAME.test(props.name)) {
            throw new Error('Invalid name.  Must fit pattern: [\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*');
        }
    }
    if (props.clientRequestToken) {
        if (props.clientRequestToken.length < 2 ||
            props.clientRequestToken.length > 64) {
            throw new Error('ClientRequestToken length must be >2 and <64');
        }
        if (!CLIENTREQUESTTOKEN.test(props.clientRequestToken)) {
            throw new Error('Invlaid Client Request Token.  Must fit pattern: [-_a-zA-Z0-9]*');
        }
    }
    return true;
}
exports.instanceUserValidator = instanceUserValidator;
//# sourceMappingURL=data:application/json;base64,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