
![Tests](https://github.com/CiscoAandI/cx_releaser/actions/workflows/tests.yml/badge.svg)
![localpdb](https://img.shields.io/pypi/v/cx_releaser)

# CX Releaser

Package to interact with docker registries

To interact with AWS registry we should
export credentials as:

Examples:
```
export AWS_ACCESS_KEY_ID=my_access_id
export AWS_SECRET_ACCESS_KEY=my_secrte_key
```
1. Create new release with recently build image

```python
from cx_releaser.src.release import Release
from cx_releaser.src.docker_registry import AwsRegistry
new_release = Release.from_remote('my_image', AwsRegistry())
new_release.next().push()
```

2. Rollback recently created release

```python
from cx_releaser.src.release import Release
from cx_releaser.src.docker_registry import AwsRegistry
all_releases = Release.get_all_from_remote('my_image', AwsRegistry())
last, prev = all_releases[0], all_releases[1]
last.rollback(prev)
```

## Command line script
After executing 
```pip install cx_releaser```
executable should be available under cx_releaser

Examples:
Push:
```
cx_releaser --all_tenants --config_path my_conf.yml --version 1.0.0 push --equal_tags latest
```

Rollback
```
cx_releaser --all_tenants --config_path my_conf.yml --version 1.0.0 rollback --prev_release 0.9.0
```

Example Config File for --config_path:
```yaml
aws_envs:
  dev:
    account_id: '131413450532'
    aws_access_key_id: my_access_key
    aws_secret_access_key: my_secret
    image_name: my_image
    check_is_newest_version: true #this will force to push images only with greater versions
    check_is_new_hash: true  #this will force to push images only with new content (different sha256 hash)
    version: 0.0.0-beta
    equal_tags: [beta] #this will add tag beta to all release versions
    tags_to_move: [beta] #this will move release tag beta during rollback to pointed release
```