EXPECTED = {'LPP-PDU-Definitions': {'extensibility-implied': False,
                         'imports': {},
                         'object-classes': {},
                         'object-sets': {},
                         'tags': 'AUTOMATIC',
                         'types': {'A-GNSS-Error': {'members': [{'name': 'locationServerErrorCauses',
                                                                 'type': 'GNSS-LocationServerErrorCauses'},
                                                                {'name': 'targetDeviceErrorCauses',
                                                                 'type': 'GNSS-TargetDeviceErrorCauses'},
                                                                None],
                                                    'type': 'CHOICE'},
                                   'A-GNSS-ProvideAssistanceData': {'members': [{'name': 'gnss-CommonAssistData',
                                                                                 'optional': True,
                                                                                 'type': 'GNSS-CommonAssistData'},
                                                                                {'name': 'gnss-GenericAssistData',
                                                                                 'optional': True,
                                                                                 'type': 'GNSS-GenericAssistData'},
                                                                                {'name': 'gnss-Error',
                                                                                 'optional': True,
                                                                                 'type': 'A-GNSS-Error'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'A-GNSS-ProvideCapabilities': {'members': [{'name': 'gnss-SupportList',
                                                                               'optional': True,
                                                                               'type': 'GNSS-SupportList'},
                                                                              {'name': 'assistanceDataSupportList',
                                                                               'optional': True,
                                                                               'type': 'AssistanceDataSupportList'},
                                                                              {'name': 'locationCoordinateTypes',
                                                                               'optional': True,
                                                                               'type': 'LocationCoordinateTypes'},
                                                                              {'name': 'velocityTypes',
                                                                               'optional': True,
                                                                               'type': 'VelocityTypes'},
                                                                              None,
                                                                              [{'name': 'periodicalReportingNotSupported-r14',
                                                                                'optional': True,
                                                                                'type': 'PositioningModes'},
                                                                               {'name': 'idleStateForMeasurements-r14',
                                                                                'optional': True,
                                                                                'type': 'ENUMERATED',
                                                                                'values': [('required',
                                                                                            0)]}]],
                                                                  'type': 'SEQUENCE'},
                                   'A-GNSS-ProvideLocationInformation': {'members': [{'name': 'gnss-SignalMeasurementInformation',
                                                                                      'optional': True,
                                                                                      'type': 'GNSS-SignalMeasurementInformation'},
                                                                                     {'name': 'gnss-LocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'GNSS-LocationInformation'},
                                                                                     {'name': 'gnss-Error',
                                                                                      'optional': True,
                                                                                      'type': 'A-GNSS-Error'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'A-GNSS-RequestAssistanceData': {'members': [{'name': 'gnss-CommonAssistDataReq',
                                                                                 'optional': True,
                                                                                 'type': 'GNSS-CommonAssistDataReq'},
                                                                                {'name': 'gnss-GenericAssistDataReq',
                                                                                 'optional': True,
                                                                                 'type': 'GNSS-GenericAssistDataReq'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'A-GNSS-RequestCapabilities': {'members': [{'name': 'gnss-SupportListReq',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'assistanceDataSupportListReq',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'locationVelocityTypesReq',
                                                                               'type': 'BOOLEAN'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'A-GNSS-RequestLocationInformation': {'members': [{'name': 'gnss-PositioningInstructions',
                                                                                      'type': 'GNSS-PositioningInstructions'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'ARFCN-ValueEUTRA': {'restricted-to': [(0,
                                                                           'maxEARFCN')],
                                                        'type': 'INTEGER'},
                                   'ARFCN-ValueEUTRA-r14': {'restricted-to': [(0,
                                                                               'maxEARFCN2')],
                                                            'type': 'INTEGER'},
                                   'ARFCN-ValueEUTRA-v9a0': {'restricted-to': [('maxEARFCN-Plus1',
                                                                                'maxEARFCN2')],
                                                             'type': 'INTEGER'},
                                   'ARFCN-ValueUTRA': {'restricted-to': [(0,
                                                                          16383)],
                                                       'type': 'INTEGER'},
                                   'Abort': {'members': [{'members': [{'members': [{'name': 'abort-r9',
                                                                                    'type': 'Abort-r9-IEs'},
                                                                                   {'name': 'spare3',
                                                                                    'type': 'NULL'},
                                                                                   {'name': 'spare2',
                                                                                    'type': 'NULL'},
                                                                                   {'name': 'spare1',
                                                                                    'type': 'NULL'}],
                                                                       'name': 'c1',
                                                                       'type': 'CHOICE'},
                                                                      {'members': [],
                                                                       'name': 'criticalExtensionsFuture',
                                                                       'type': 'SEQUENCE'}],
                                                          'name': 'criticalExtensions',
                                                          'type': 'CHOICE'}],
                                             'type': 'SEQUENCE'},
                                   'Abort-r9-IEs': {'members': [{'name': 'commonIEsAbort',
                                                                 'optional': True,
                                                                 'type': 'CommonIEsAbort'},
                                                                None,
                                                                {'name': 'epdu-Abort',
                                                                 'optional': True,
                                                                 'type': 'EPDU-Sequence'}],
                                                    'type': 'SEQUENCE'},
                                   'AccessTypes': {'members': [{'name': 'accessTypes',
                                                                'named-bits': [('eutra',
                                                                                '0'),
                                                                               ('utra',
                                                                                '1'),
                                                                               ('gsm',
                                                                                '2'),
                                                                               ('nb-iot',
                                                                                '3')],
                                                                'size': [(1,
                                                                          8)],
                                                                'type': 'BIT '
                                                                        'STRING'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                   'Acknowledgement': {'members': [{'name': 'ackRequested',
                                                                    'type': 'BOOLEAN'},
                                                                   {'name': 'ackIndicator',
                                                                    'optional': True,
                                                                    'type': 'SequenceNumber'}],
                                                       'type': 'SEQUENCE'},
                                   'Add-PRSconfigNeighbourElement-r14': {'members': [{'name': 'add-prsInfo-r14',
                                                                                      'optional': True,
                                                                                      'type': 'PRS-Info'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'AdditionalInformation': {'type': 'ENUMERATED',
                                                             'values': [('onlyReturnInformationRequested',
                                                                         0),
                                                                        ('mayReturnAditionalInformation',
                                                                         1),
                                                                        None]},
                                   'AdditionalPath-r14': {'members': [{'name': 'relativeTimeDifference-r14',
                                                                       'restricted-to': [(-256,
                                                                                          255)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'path-Quality-r14',
                                                                       'optional': True,
                                                                       'type': 'OTDOA-MeasQuality'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'AdditionalPathList-r14': {'element': {'type': 'AdditionalPath-r14'},
                                                              'size': [(1,
                                                                        'maxPaths-r14')],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                   'AlmanacBDS-AlmanacSet-r12': {'members': [{'name': 'svID',
                                                                              'type': 'SV-ID'},
                                                                             {'name': 'bdsAlmToa-r12',
                                                                              'optional': True,
                                                                              'restricted-to': [(0,
                                                                                                 255)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmSqrtA-r12',
                                                                              'restricted-to': [(0,
                                                                                                 16777215)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmE-r12',
                                                                              'restricted-to': [(0,
                                                                                                 131071)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmW-r12',
                                                                              'restricted-to': [(-8388608,
                                                                                                 8388607)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmM0-r12',
                                                                              'restricted-to': [(-8388608,
                                                                                                 8388607)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmOmega0-r12',
                                                                              'restricted-to': [(-8388608,
                                                                                                 8388607)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmOmegaDot-r12',
                                                                              'restricted-to': [(-65536,
                                                                                                 65535)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmDeltaI-r12',
                                                                              'restricted-to': [(-32768,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmA0-r12',
                                                                              'restricted-to': [(-1024,
                                                                                                 1023)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsAlmA1-r12',
                                                                              'restricted-to': [(-1024,
                                                                                                 1023)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'bdsSvHealth-r12',
                                                                              'optional': True,
                                                                              'size': [9],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'AlmanacECEF-SBAS-AlmanacSet': {'members': [{'name': 'sbasAlmDataID',
                                                                                'restricted-to': [(0,
                                                                                                   3)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'svID',
                                                                                'type': 'SV-ID'},
                                                                               {'name': 'sbasAlmHealth',
                                                                                'size': [8],
                                                                                'type': 'BIT '
                                                                                        'STRING'},
                                                                               {'name': 'sbasAlmXg',
                                                                                'restricted-to': [(-16384,
                                                                                                   16383)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'sbasAlmYg',
                                                                                'restricted-to': [(-16384,
                                                                                                   16383)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'sbasAlmZg',
                                                                                'restricted-to': [(-256,
                                                                                                   255)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'sbasAlmXgdot',
                                                                                'restricted-to': [(-4,
                                                                                                   3)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'sbasAlmYgDot',
                                                                                'restricted-to': [(-4,
                                                                                                   3)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'sbasAlmZgDot',
                                                                                'restricted-to': [(-8,
                                                                                                   7)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'sbasAlmTo',
                                                                                'restricted-to': [(0,
                                                                                                   2047)],
                                                                                'type': 'INTEGER'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                   'AlmanacGLONASS-AlmanacSet': {'members': [{'name': 'gloAlm-NA',
                                                                              'restricted-to': [(1,
                                                                                                 1461)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmnA',
                                                                              'restricted-to': [(1,
                                                                                                 24)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmHA',
                                                                              'restricted-to': [(0,
                                                                                                 31)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmLambdaA',
                                                                              'restricted-to': [(-1048576,
                                                                                                 1048575)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmtlambdaA',
                                                                              'restricted-to': [(0,
                                                                                                 2097151)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmDeltaIa',
                                                                              'restricted-to': [(-131072,
                                                                                                 131071)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmDeltaTA',
                                                                              'restricted-to': [(-2097152,
                                                                                                 2097151)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmDeltaTdotA',
                                                                              'restricted-to': [(-64,
                                                                                                 63)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmEpsilonA',
                                                                              'restricted-to': [(0,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmOmegaA',
                                                                              'restricted-to': [(-32768,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmTauA',
                                                                              'restricted-to': [(-512,
                                                                                                 511)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmCA',
                                                                              'restricted-to': [(0,
                                                                                                 1)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gloAlmMA',
                                                                              'optional': True,
                                                                              'size': [2],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'AlmanacKeplerianSet': {'members': [{'name': 'svID',
                                                                        'type': 'SV-ID'},
                                                                       {'name': 'kepAlmanacE',
                                                                        'restricted-to': [(0,
                                                                                           2047)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacDeltaI',
                                                                        'restricted-to': [(-1024,
                                                                                           1023)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacOmegaDot',
                                                                        'restricted-to': [(-1024,
                                                                                           1023)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepSV-StatusINAV',
                                                                        'size': [4],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'kepSV-StatusFNAV',
                                                                        'optional': True,
                                                                        'size': [2],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'kepAlmanacAPowerHalf',
                                                                        'restricted-to': [(-4096,
                                                                                           4095)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacOmega0',
                                                                        'restricted-to': [(-32768,
                                                                                           32767)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacW',
                                                                        'restricted-to': [(-32768,
                                                                                           32767)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacM0',
                                                                        'restricted-to': [(-32768,
                                                                                           32767)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacAF0',
                                                                        'restricted-to': [(-32768,
                                                                                           32767)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'kepAlmanacAF1',
                                                                        'restricted-to': [(-4096,
                                                                                           4095)],
                                                                        'type': 'INTEGER'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'AlmanacMidiAlmanacSet': {'members': [{'name': 'svID',
                                                                          'type': 'SV-ID'},
                                                                         {'name': 'midiAlmE',
                                                                          'restricted-to': [(0,
                                                                                             2047)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmDeltaI',
                                                                          'restricted-to': [(-1024,
                                                                                             1023)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmOmegaDot',
                                                                          'restricted-to': [(-1024,
                                                                                             1023)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmSqrtA',
                                                                          'restricted-to': [(0,
                                                                                             131071)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmOmega0',
                                                                          'restricted-to': [(-32768,
                                                                                             32767)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmOmega',
                                                                          'restricted-to': [(-32768,
                                                                                             32767)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmMo',
                                                                          'restricted-to': [(-32768,
                                                                                             32767)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmaf0',
                                                                          'restricted-to': [(-1024,
                                                                                             1023)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmaf1',
                                                                          'restricted-to': [(-512,
                                                                                             511)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'midiAlmL1Health',
                                                                          'type': 'BOOLEAN'},
                                                                         {'name': 'midiAlmL2Health',
                                                                          'type': 'BOOLEAN'},
                                                                         {'name': 'midiAlmL5Health',
                                                                          'type': 'BOOLEAN'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'AlmanacNAV-KeplerianSet': {'members': [{'name': 'svID',
                                                                            'type': 'SV-ID'},
                                                                           {'name': 'navAlmE',
                                                                            'restricted-to': [(0,
                                                                                               65535)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmDeltaI',
                                                                            'restricted-to': [(-32768,
                                                                                               32767)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmOMEGADOT',
                                                                            'restricted-to': [(-32768,
                                                                                               32767)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmSVHealth',
                                                                            'restricted-to': [(0,
                                                                                               255)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmSqrtA',
                                                                            'restricted-to': [(0,
                                                                                               16777215)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmOMEGAo',
                                                                            'restricted-to': [(-8388608,
                                                                                               8388607)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmOmega',
                                                                            'restricted-to': [(-8388608,
                                                                                               8388607)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmMo',
                                                                            'restricted-to': [(-8388608,
                                                                                               8388607)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmaf0',
                                                                            'restricted-to': [(-1024,
                                                                                               1023)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'navAlmaf1',
                                                                            'restricted-to': [(-1024,
                                                                                               1023)],
                                                                            'type': 'INTEGER'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                   'AlmanacReducedKeplerianSet': {'members': [{'name': 'svID',
                                                                               'type': 'SV-ID'},
                                                                              {'name': 'redAlmDeltaA',
                                                                               'restricted-to': [(-128,
                                                                                                  127)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'redAlmOmega0',
                                                                               'restricted-to': [(-64,
                                                                                                  63)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'redAlmPhi0',
                                                                               'restricted-to': [(-64,
                                                                                                  63)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'redAlmL1Health',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'redAlmL2Health',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'redAlmL5Health',
                                                                               'type': 'BOOLEAN'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'AssistanceDataSupportList': {'members': [{'name': 'gnss-CommonAssistanceDataSupport',
                                                                              'type': 'GNSS-CommonAssistanceDataSupport'},
                                                                             {'name': 'gnss-GenericAssistanceDataSupport',
                                                                              'type': 'GNSS-GenericAssistanceDataSupport'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'BDS-ClockModel-r12': {'members': [{'name': 'bdsAODC-r12',
                                                                       'restricted-to': [(0,
                                                                                          31)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'bdsToc-r12',
                                                                       'restricted-to': [(0,
                                                                                          131071)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'bdsA0-r12',
                                                                       'restricted-to': [(-8388608,
                                                                                          8388607)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'bdsA1-r12',
                                                                       'restricted-to': [(-2097152,
                                                                                          2097151)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'bdsA2-r12',
                                                                       'restricted-to': [(-1024,
                                                                                          1023)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'bdsTgd1-r12',
                                                                       'restricted-to': [(-512,
                                                                                          511)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'BDS-DifferentialCorrections-r12': {'members': [{'name': 'dbds-RefTime-r12',
                                                                                    'restricted-to': [(0,
                                                                                                       3599)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'bds-SgnTypeList-r12',
                                                                                    'type': 'BDS-SgnTypeList-r12'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'BDS-DifferentialCorrectionsReq-r12': {'members': [{'name': 'dgnss-SignalsReq',
                                                                                       'type': 'GNSS-SignalIDs'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                   'BDS-DifferentialCorrectionsSupport-r12': {'members': [{'name': 'gnssSignalIDs',
                                                                                           'type': 'GNSS-SignalIDs'},
                                                                                          None],
                                                                              'type': 'SEQUENCE'},
                                   'BDS-GridModelParameter-r12': {'members': [{'name': 'bds-RefTime-r12',
                                                                               'restricted-to': [(0,
                                                                                                  3599)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'gridIonList-r12',
                                                                               'type': 'GridIonList-r12'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'BDS-GridModelReq-r12': {'members': [None],
                                                            'type': 'SEQUENCE'},
                                   'BDS-GridModelSupport-r12': {'members': [None],
                                                                'type': 'SEQUENCE'},
                                   'BDS-SgnTypeElement-r12': {'members': [{'name': 'gnss-SignalID',
                                                                           'optional': True,
                                                                           'type': 'GNSS-SignalID'},
                                                                          {'name': 'dbds-CorrectionList-r12',
                                                                           'type': 'DBDS-CorrectionList-r12'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'BDS-SgnTypeList-r12': {'element': {'type': 'BDS-SgnTypeElement-r12'},
                                                           'size': [(1, 3)],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                                   'BT-Error-r13': {'members': [{'name': 'locationServerErrorCauses-r13',
                                                                 'type': 'BT-LocationServerErrorCauses-r13'},
                                                                {'name': 'targetDeviceErrorCauses-r13',
                                                                 'type': 'BT-TargetDeviceErrorCauses-r13'},
                                                                None],
                                                    'type': 'CHOICE'},
                                   'BT-LocationServerErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                     'type': 'ENUMERATED',
                                                                                     'values': [('undefined',
                                                                                                 0),
                                                                                                None]},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                   'BT-MeasurementElement-r13': {'members': [{'name': 'btAddr-r13',
                                                                              'size': [48],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             {'name': 'rssi-r13',
                                                                              'optional': True,
                                                                              'restricted-to': [(-128,
                                                                                                 127)],
                                                                              'type': 'INTEGER'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'BT-MeasurementInformation-r13': {'members': [{'name': 'measurementReferenceTime-r13',
                                                                                  'optional': True,
                                                                                  'type': 'UTCTime'},
                                                                                 {'name': 'bt-MeasurementList-r13',
                                                                                  'optional': True,
                                                                                  'type': 'BT-MeasurementList-r13'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'BT-MeasurementList-r13': {'element': {'type': 'BT-MeasurementElement-r13'},
                                                              'size': [(1,
                                                                        'maxBT-Beacon-r13')],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                   'BT-ProvideCapabilities-r13': {'members': [{'name': 'bt-Modes-r13',
                                                                               'named-bits': [('standalone',
                                                                                               '0'),
                                                                                              ('ue-assisted',
                                                                                               '1')],
                                                                               'size': [(1,
                                                                                         8)],
                                                                               'type': 'BIT '
                                                                                       'STRING'},
                                                                              {'name': 'bt-MeasSupported-r13',
                                                                               'named-bits': [('rssi-r13',
                                                                                               '0')],
                                                                               'size': [(1,
                                                                                         8)],
                                                                               'type': 'BIT '
                                                                                       'STRING'},
                                                                              None,
                                                                              [{'name': 'idleStateForMeasurements-r14',
                                                                                'optional': True,
                                                                                'type': 'ENUMERATED',
                                                                                'values': [('required',
                                                                                            0)]},
                                                                               {'name': 'periodicalReportingSupported-r14',
                                                                                'optional': True,
                                                                                'type': 'PositioningModes'}]],
                                                                  'type': 'SEQUENCE'},
                                   'BT-ProvideLocationInformation-r13': {'members': [{'name': 'bt-MeasurementInformation-r13',
                                                                                      'optional': True,
                                                                                      'type': 'BT-MeasurementInformation-r13'},
                                                                                     {'name': 'bt-Error-r13',
                                                                                      'optional': True,
                                                                                      'type': 'BT-Error-r13'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'BT-RequestCapabilities-r13': {'members': [None],
                                                                  'type': 'SEQUENCE'},
                                   'BT-RequestLocationInformation-r13': {'members': [{'name': 'requestedMeasurements-r13',
                                                                                      'named-bits': [('rssi',
                                                                                                      '0')],
                                                                                      'size': [(1,
                                                                                                8)],
                                                                                      'type': 'BIT '
                                                                                              'STRING'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'BT-TargetDeviceErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                   'type': 'ENUMERATED',
                                                                                   'values': [('undefined',
                                                                                               0),
                                                                                              ('requestedMeasurementsNotAvailable',
                                                                                               1),
                                                                                              ('notAllrequestedMeasurementsPossible',
                                                                                               2),
                                                                                              None]},
                                                                                  {'name': 'bt-Beacon-rssiMeasurementNotPossible-r13',
                                                                                   'optional': True,
                                                                                   'type': 'NULL'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'BadSignalElement': {'members': [{'name': 'badSVID',
                                                                     'type': 'SV-ID'},
                                                                    {'name': 'badSignalID',
                                                                     'optional': True,
                                                                     'type': 'GNSS-SignalIDs'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                   'CNAV-ClockModel': {'members': [{'name': 'cnavToc',
                                                                    'restricted-to': [(0,
                                                                                       2015)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavTop',
                                                                    'restricted-to': [(0,
                                                                                       2015)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavURA0',
                                                                    'restricted-to': [(-16,
                                                                                       15)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavURA1',
                                                                    'restricted-to': [(0,
                                                                                       7)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavURA2',
                                                                    'restricted-to': [(0,
                                                                                       7)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavAf2',
                                                                    'restricted-to': [(-512,
                                                                                       511)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavAf1',
                                                                    'restricted-to': [(-524288,
                                                                                       524287)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavAf0',
                                                                    'restricted-to': [(-33554432,
                                                                                       33554431)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavTgd',
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavISCl1cp',
                                                                    'optional': True,
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavISCl1cd',
                                                                    'optional': True,
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavISCl1ca',
                                                                    'optional': True,
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavISCl2c',
                                                                    'optional': True,
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavISCl5i5',
                                                                    'optional': True,
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'cnavISCl5q5',
                                                                    'optional': True,
                                                                    'restricted-to': [(-4096,
                                                                                       4095)],
                                                                    'type': 'INTEGER'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                   'CarrierFreq-NB-r14': {'members': [{'name': 'carrierFreq-r14',
                                                                       'type': 'ARFCN-ValueEUTRA-r14'},
                                                                      {'name': 'carrierFreqOffset-r14',
                                                                       'optional': True,
                                                                       'type': 'CarrierFreqOffsetNB-r14'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'CarrierFreqOffsetNB-r14': {'type': 'ENUMERATED',
                                                               'values': [('v-10',
                                                                           0),
                                                                          ('v-9',
                                                                           1),
                                                                          ('v-8',
                                                                           2),
                                                                          ('v-7',
                                                                           3),
                                                                          ('v-6',
                                                                           4),
                                                                          ('v-5',
                                                                           5),
                                                                          ('v-4',
                                                                           6),
                                                                          ('v-3',
                                                                           7),
                                                                          ('v-2',
                                                                           8),
                                                                          ('v-1',
                                                                           9),
                                                                          ('v-0dot5',
                                                                           10),
                                                                          ('v0',
                                                                           11),
                                                                          ('v1',
                                                                           12),
                                                                          ('v2',
                                                                           13),
                                                                          ('v3',
                                                                           14),
                                                                          ('v4',
                                                                           15),
                                                                          ('v5',
                                                                           16),
                                                                          ('v6',
                                                                           17),
                                                                          ('v7',
                                                                           18),
                                                                          ('v8',
                                                                           19),
                                                                          ('v9',
                                                                           20)]},
                                   'CellGlobalIdEUTRA-AndUTRA': {'members': [{'members': [{'element': {'restricted-to': [(0,
                                                                                                                          9)],
                                                                                                       'type': 'INTEGER'},
                                                                                           'name': 'mcc',
                                                                                           'size': [3],
                                                                                           'type': 'SEQUENCE '
                                                                                                   'OF'},
                                                                                          {'element': {'restricted-to': [(0,
                                                                                                                          9)],
                                                                                                       'type': 'INTEGER'},
                                                                                           'name': 'mnc',
                                                                                           'size': [(2,
                                                                                                     3)],
                                                                                           'type': 'SEQUENCE '
                                                                                                   'OF'}],
                                                                              'name': 'plmn-Identity',
                                                                              'type': 'SEQUENCE'},
                                                                             {'members': [{'name': 'eutra',
                                                                                           'size': [28],
                                                                                           'type': 'BIT '
                                                                                                   'STRING'},
                                                                                          {'name': 'utra',
                                                                                           'size': [32],
                                                                                           'type': 'BIT '
                                                                                                   'STRING'}],
                                                                              'name': 'cellIdentity',
                                                                              'type': 'CHOICE'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'CellGlobalIdGERAN': {'members': [{'members': [{'element': {'restricted-to': [(0,
                                                                                                                  9)],
                                                                                               'type': 'INTEGER'},
                                                                                   'name': 'mcc',
                                                                                   'size': [3],
                                                                                   'type': 'SEQUENCE '
                                                                                           'OF'},
                                                                                  {'element': {'restricted-to': [(0,
                                                                                                                  9)],
                                                                                               'type': 'INTEGER'},
                                                                                   'name': 'mnc',
                                                                                   'size': [(2,
                                                                                             3)],
                                                                                   'type': 'SEQUENCE '
                                                                                           'OF'}],
                                                                      'name': 'plmn-Identity',
                                                                      'type': 'SEQUENCE'},
                                                                     {'name': 'locationAreaCode',
                                                                      'size': [16],
                                                                      'type': 'BIT '
                                                                              'STRING'},
                                                                     {'name': 'cellIdentity',
                                                                      'size': [16],
                                                                      'type': 'BIT '
                                                                              'STRING'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'CommonIEsAbort': {'members': [{'name': 'abortCause',
                                                                   'type': 'ENUMERATED',
                                                                   'values': [('undefined',
                                                                               0),
                                                                              ('stopPeriodicReporting',
                                                                               1),
                                                                              ('targetDeviceAbort',
                                                                               2),
                                                                              ('networkAbort',
                                                                               3),
                                                                              None]}],
                                                      'type': 'SEQUENCE'},
                                   'CommonIEsError': {'members': [{'name': 'errorCause',
                                                                   'type': 'ENUMERATED',
                                                                   'values': [('undefined',
                                                                               0),
                                                                              ('lppMessageHeaderError',
                                                                               1),
                                                                              ('lppMessageBodyError',
                                                                               2),
                                                                              ('epduError',
                                                                               3),
                                                                              ('incorrectDataValue',
                                                                               4),
                                                                              None]}],
                                                      'type': 'SEQUENCE'},
                                   'CommonIEsProvideAssistanceData': {'members': [None],
                                                                      'type': 'SEQUENCE'},
                                   'CommonIEsProvideCapabilities': {'members': [None],
                                                                    'type': 'SEQUENCE'},
                                   'CommonIEsProvideLocationInformation': {'members': [{'name': 'locationEstimate',
                                                                                        'optional': True,
                                                                                        'type': 'LocationCoordinates'},
                                                                                       {'name': 'velocityEstimate',
                                                                                        'optional': True,
                                                                                        'type': 'Velocity'},
                                                                                       {'name': 'locationError',
                                                                                        'optional': True,
                                                                                        'type': 'LocationError'},
                                                                                       None,
                                                                                       [{'name': 'earlyFixReport-r12',
                                                                                         'optional': True,
                                                                                         'type': 'EarlyFixReport-r12'}],
                                                                                       [{'name': 'locationSource-r13',
                                                                                         'optional': True,
                                                                                         'type': 'LocationSource-r13'},
                                                                                        {'name': 'locationTimestamp-r13',
                                                                                         'optional': True,
                                                                                         'type': 'UTCTime'}]],
                                                                           'type': 'SEQUENCE'},
                                   'CommonIEsRequestAssistanceData': {'members': [{'name': 'primaryCellID',
                                                                                   'optional': True,
                                                                                   'type': 'ECGI'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'CommonIEsRequestCapabilities': {'members': [None],
                                                                    'type': 'SEQUENCE'},
                                   'CommonIEsRequestLocationInformation': {'members': [{'name': 'locationInformationType',
                                                                                        'type': 'LocationInformationType'},
                                                                                       {'name': 'triggeredReporting',
                                                                                        'optional': True,
                                                                                        'type': 'TriggeredReportingCriteria'},
                                                                                       {'name': 'periodicalReporting',
                                                                                        'optional': True,
                                                                                        'type': 'PeriodicalReportingCriteria'},
                                                                                       {'name': 'additionalInformation',
                                                                                        'optional': True,
                                                                                        'type': 'AdditionalInformation'},
                                                                                       {'name': 'qos',
                                                                                        'optional': True,
                                                                                        'type': 'QoS'},
                                                                                       {'name': 'environment',
                                                                                        'optional': True,
                                                                                        'type': 'Environment'},
                                                                                       {'name': 'locationCoordinateTypes',
                                                                                        'optional': True,
                                                                                        'type': 'LocationCoordinateTypes'},
                                                                                       {'name': 'velocityTypes',
                                                                                        'optional': True,
                                                                                        'type': 'VelocityTypes'},
                                                                                       None,
                                                                                       [{'name': 'messageSizeLimitNB-r14',
                                                                                         'optional': True,
                                                                                         'type': 'MessageSizeLimitNB-r14'}]],
                                                                           'type': 'SEQUENCE'},
                                   'DBDS-CorrectionElement-r12': {'members': [{'name': 'svID',
                                                                               'type': 'SV-ID'},
                                                                              {'name': 'bds-UDREI-r12',
                                                                               'restricted-to': [(0,
                                                                                                  15)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'bds-RURAI-r12',
                                                                               'restricted-to': [(0,
                                                                                                  15)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'bds-ECC-DeltaT-r12',
                                                                               'restricted-to': [(-4096,
                                                                                                  4095)],
                                                                               'type': 'INTEGER'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'DBDS-CorrectionList-r12': {'element': {'type': 'DBDS-CorrectionElement-r12'},
                                                               'size': [(1,
                                                                         64)],
                                                               'type': 'SEQUENCE '
                                                                       'OF'},
                                   'DGNSS-CorrectionsElement': {'members': [{'name': 'svID',
                                                                             'type': 'SV-ID'},
                                                                            {'name': 'iod',
                                                                             'size': [11],
                                                                             'type': 'BIT '
                                                                                     'STRING'},
                                                                            {'name': 'udre',
                                                                             'restricted-to': [(0,
                                                                                                3)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'pseudoRangeCor',
                                                                             'restricted-to': [(-2047,
                                                                                                2047)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'rangeRateCor',
                                                                             'restricted-to': [(-127,
                                                                                                127)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'udreGrowthRate',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                7)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'udreValidityTime',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                7)],
                                                                             'type': 'INTEGER'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'DGNSS-SatList': {'element': {'type': 'DGNSS-CorrectionsElement'},
                                                     'size': [(1, 64)],
                                                     'type': 'SEQUENCE OF'},
                                   'DGNSS-SgnTypeElement': {'members': [{'name': 'gnss-SignalID',
                                                                         'type': 'GNSS-SignalID'},
                                                                        {'name': 'gnss-StatusHealth',
                                                                         'restricted-to': [(0,
                                                                                            7)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'dgnss-SatList',
                                                                         'type': 'DGNSS-SatList'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                   'DGNSS-SgnTypeList': {'element': {'type': 'DGNSS-SgnTypeElement'},
                                                         'size': [(1, 3)],
                                                         'type': 'SEQUENCE OF'},
                                   'ECGI': {'members': [{'element': {'restricted-to': [(0,
                                                                                        9)],
                                                                     'type': 'INTEGER'},
                                                         'name': 'mcc',
                                                         'size': [3],
                                                         'type': 'SEQUENCE OF'},
                                                        {'element': {'restricted-to': [(0,
                                                                                        9)],
                                                                     'type': 'INTEGER'},
                                                         'name': 'mnc',
                                                         'size': [(2, 3)],
                                                         'type': 'SEQUENCE OF'},
                                                        {'name': 'cellidentity',
                                                         'size': [28],
                                                         'type': 'BIT STRING'}],
                                            'type': 'SEQUENCE'},
                                   'ECID-Error': {'members': [{'name': 'locationServerErrorCauses',
                                                               'type': 'ECID-LocationServerErrorCauses'},
                                                              {'name': 'targetDeviceErrorCauses',
                                                               'type': 'ECID-TargetDeviceErrorCauses'},
                                                              None],
                                                  'type': 'CHOICE'},
                                   'ECID-LocationServerErrorCauses': {'members': [{'name': 'cause',
                                                                                   'type': 'ENUMERATED',
                                                                                   'values': [('undefined',
                                                                                               0),
                                                                                              None]},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'ECID-ProvideCapabilities': {'members': [{'name': 'ecid-MeasSupported',
                                                                             'named-bits': [('rsrpSup',
                                                                                             '0'),
                                                                                            ('rsrqSup',
                                                                                             '1'),
                                                                                            ('ueRxTxSup',
                                                                                             '2'),
                                                                                            ('nrsrpSup-r14',
                                                                                             '3'),
                                                                                            ('nrsrqSup-r14',
                                                                                             '4')],
                                                                             'size': [(1,
                                                                                       8)],
                                                                             'type': 'BIT '
                                                                                     'STRING'},
                                                                            None,
                                                                            [{'name': 'ueRxTxSupTDD-r13',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('true',
                                                                                          0)]}],
                                                                            [{'name': 'periodicalReporting-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'triggeredReporting-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'idleStateForMeasurements-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('required',
                                                                                          0)]}]],
                                                                'type': 'SEQUENCE'},
                                   'ECID-ProvideLocationInformation': {'members': [{'name': 'ecid-SignalMeasurementInformation',
                                                                                    'optional': True,
                                                                                    'type': 'ECID-SignalMeasurementInformation'},
                                                                                   {'name': 'ecid-Error',
                                                                                    'optional': True,
                                                                                    'type': 'ECID-Error'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'ECID-RequestCapabilities': {'members': [None],
                                                                'type': 'SEQUENCE'},
                                   'ECID-RequestLocationInformation': {'members': [{'name': 'requestedMeasurements',
                                                                                    'named-bits': [('rsrpReq',
                                                                                                    '0'),
                                                                                                   ('rsrqReq',
                                                                                                    '1'),
                                                                                                   ('ueRxTxReq',
                                                                                                    '2'),
                                                                                                   ('nrsrpReq-r14',
                                                                                                    '3'),
                                                                                                   ('nrsrqReq-r14',
                                                                                                    '4')],
                                                                                    'size': [(1,
                                                                                              8)],
                                                                                    'type': 'BIT '
                                                                                            'STRING'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'ECID-SignalMeasurementInformation': {'members': [{'name': 'primaryCellMeasuredResults',
                                                                                      'optional': True,
                                                                                      'type': 'MeasuredResultsElement'},
                                                                                     {'name': 'measuredResultsList',
                                                                                      'type': 'MeasuredResultsList'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'ECID-TargetDeviceErrorCauses': {'members': [{'name': 'cause',
                                                                                 'type': 'ENUMERATED',
                                                                                 'values': [('undefined',
                                                                                             0),
                                                                                            ('requestedMeasurementNotAvailable',
                                                                                             1),
                                                                                            ('notAllrequestedMeasurementsPossible',
                                                                                             2),
                                                                                            None]},
                                                                                {'name': 'rsrpMeasurementNotPossible',
                                                                                 'optional': True,
                                                                                 'type': 'NULL'},
                                                                                {'name': 'rsrqMeasurementNotPossible',
                                                                                 'optional': True,
                                                                                 'type': 'NULL'},
                                                                                {'name': 'ueRxTxMeasurementNotPossible',
                                                                                 'optional': True,
                                                                                 'type': 'NULL'},
                                                                                None,
                                                                                [{'name': 'nrsrpMeasurementNotPossible-r14',
                                                                                  'optional': True,
                                                                                  'type': 'NULL'},
                                                                                 {'name': 'nrsrqMeasurementNotPossible-r14',
                                                                                  'optional': True,
                                                                                  'type': 'NULL'}]],
                                                                    'type': 'SEQUENCE'},
                                   'EPDU': {'members': [{'name': 'ePDU-Identifier',
                                                         'type': 'EPDU-Identifier'},
                                                        {'name': 'ePDU-Body',
                                                         'type': 'EPDU-Body'}],
                                            'type': 'SEQUENCE'},
                                   'EPDU-Body': {'type': 'OCTET STRING'},
                                   'EPDU-ID': {'restricted-to': [(1, 256)],
                                               'type': 'INTEGER'},
                                   'EPDU-Identifier': {'members': [{'name': 'ePDU-ID',
                                                                    'type': 'EPDU-ID'},
                                                                   {'name': 'ePDU-Name',
                                                                    'optional': True,
                                                                    'type': 'EPDU-Name'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                   'EPDU-Name': {'size': [(1, 32)],
                                                 'type': 'VisibleString'},
                                   'EPDU-Sequence': {'element': {'type': 'EPDU'},
                                                     'size': [(1, 'maxEPDU')],
                                                     'type': 'SEQUENCE OF'},
                                   'EarlyFixReport-r12': {'type': 'ENUMERATED',
                                                          'values': [('noMoreMessages',
                                                                      0),
                                                                     ('moreMessagesOnTheWay',
                                                                      1)]},
                                   'Ellipsoid-Point': {'members': [{'name': 'latitudeSign',
                                                                    'type': 'ENUMERATED',
                                                                    'values': [('north',
                                                                                0),
                                                                               ('south',
                                                                                1)]},
                                                                   {'name': 'degreesLatitude',
                                                                    'restricted-to': [(0,
                                                                                       8388607)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'degreesLongitude',
                                                                    'restricted-to': [(-8388608,
                                                                                       8388607)],
                                                                    'type': 'INTEGER'}],
                                                       'type': 'SEQUENCE'},
                                   'Ellipsoid-PointWithUncertaintyCircle': {'members': [{'name': 'latitudeSign',
                                                                                         'type': 'ENUMERATED',
                                                                                         'values': [('north',
                                                                                                     0),
                                                                                                    ('south',
                                                                                                     1)]},
                                                                                        {'name': 'degreesLatitude',
                                                                                         'restricted-to': [(0,
                                                                                                            8388607)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'degreesLongitude',
                                                                                         'restricted-to': [(-8388608,
                                                                                                            8388607)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'uncertainty',
                                                                                         'restricted-to': [(0,
                                                                                                            127)],
                                                                                         'type': 'INTEGER'}],
                                                                            'type': 'SEQUENCE'},
                                   'EllipsoidArc': {'members': [{'name': 'latitudeSign',
                                                                 'type': 'ENUMERATED',
                                                                 'values': [('north',
                                                                             0),
                                                                            ('south',
                                                                             1)]},
                                                                {'name': 'degreesLatitude',
                                                                 'restricted-to': [(0,
                                                                                    8388607)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'degreesLongitude',
                                                                 'restricted-to': [(-8388608,
                                                                                    8388607)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'innerRadius',
                                                                 'restricted-to': [(0,
                                                                                    65535)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'uncertaintyRadius',
                                                                 'restricted-to': [(0,
                                                                                    127)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'offsetAngle',
                                                                 'restricted-to': [(0,
                                                                                    179)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'includedAngle',
                                                                 'restricted-to': [(0,
                                                                                    179)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'confidence',
                                                                 'restricted-to': [(0,
                                                                                    100)],
                                                                 'type': 'INTEGER'}],
                                                    'type': 'SEQUENCE'},
                                   'EllipsoidPointWithAltitude': {'members': [{'name': 'latitudeSign',
                                                                               'type': 'ENUMERATED',
                                                                               'values': [('north',
                                                                                           0),
                                                                                          ('south',
                                                                                           1)]},
                                                                              {'name': 'degreesLatitude',
                                                                               'restricted-to': [(0,
                                                                                                  8388607)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'degreesLongitude',
                                                                               'restricted-to': [(-8388608,
                                                                                                  8388607)],
                                                                               'type': 'INTEGER'},
                                                                              {'name': 'altitudeDirection',
                                                                               'type': 'ENUMERATED',
                                                                               'values': [('height',
                                                                                           0),
                                                                                          ('depth',
                                                                                           1)]},
                                                                              {'name': 'altitude',
                                                                               'restricted-to': [(0,
                                                                                                  32767)],
                                                                               'type': 'INTEGER'}],
                                                                  'type': 'SEQUENCE'},
                                   'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid': {'members': [{'name': 'latitudeSign',
                                                                                                      'type': 'ENUMERATED',
                                                                                                      'values': [('north',
                                                                                                                  0),
                                                                                                                 ('south',
                                                                                                                  1)]},
                                                                                                     {'name': 'degreesLatitude',
                                                                                                      'restricted-to': [(0,
                                                                                                                         8388607)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'degreesLongitude',
                                                                                                      'restricted-to': [(-8388608,
                                                                                                                         8388607)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'altitudeDirection',
                                                                                                      'type': 'ENUMERATED',
                                                                                                      'values': [('height',
                                                                                                                  0),
                                                                                                                 ('depth',
                                                                                                                  1)]},
                                                                                                     {'name': 'altitude',
                                                                                                      'restricted-to': [(0,
                                                                                                                         32767)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'uncertaintySemiMajor',
                                                                                                      'restricted-to': [(0,
                                                                                                                         127)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'uncertaintySemiMinor',
                                                                                                      'restricted-to': [(0,
                                                                                                                         127)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'orientationMajorAxis',
                                                                                                      'restricted-to': [(0,
                                                                                                                         179)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'uncertaintyAltitude',
                                                                                                      'restricted-to': [(0,
                                                                                                                         127)],
                                                                                                      'type': 'INTEGER'},
                                                                                                     {'name': 'confidence',
                                                                                                      'restricted-to': [(0,
                                                                                                                         100)],
                                                                                                      'type': 'INTEGER'}],
                                                                                         'type': 'SEQUENCE'},
                                   'EllipsoidPointWithUncertaintyEllipse': {'members': [{'name': 'latitudeSign',
                                                                                         'type': 'ENUMERATED',
                                                                                         'values': [('north',
                                                                                                     0),
                                                                                                    ('south',
                                                                                                     1)]},
                                                                                        {'name': 'degreesLatitude',
                                                                                         'restricted-to': [(0,
                                                                                                            8388607)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'degreesLongitude',
                                                                                         'restricted-to': [(-8388608,
                                                                                                            8388607)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'uncertaintySemiMajor',
                                                                                         'restricted-to': [(0,
                                                                                                            127)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'uncertaintySemiMinor',
                                                                                         'restricted-to': [(0,
                                                                                                            127)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'orientationMajorAxis',
                                                                                         'restricted-to': [(0,
                                                                                                            179)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'confidence',
                                                                                         'restricted-to': [(0,
                                                                                                            100)],
                                                                                         'type': 'INTEGER'}],
                                                                            'type': 'SEQUENCE'},
                                   'Environment': {'type': 'ENUMERATED',
                                                   'values': [('badArea', 0),
                                                              ('notBadArea', 1),
                                                              ('mixedArea', 2),
                                                              None]},
                                   'Error': {'members': [{'name': 'error-r9',
                                                          'type': 'Error-r9-IEs'},
                                                         {'members': [],
                                                          'name': 'criticalExtensionsFuture',
                                                          'type': 'SEQUENCE'}],
                                             'type': 'CHOICE'},
                                   'Error-r9-IEs': {'members': [{'name': 'commonIEsError',
                                                                 'optional': True,
                                                                 'type': 'CommonIEsError'},
                                                                None,
                                                                {'name': 'epdu-Error',
                                                                 'optional': True,
                                                                 'type': 'EPDU-Sequence'}],
                                                    'type': 'SEQUENCE'},
                                   'GLONASS-ClockModel': {'members': [{'name': 'gloTau',
                                                                       'restricted-to': [(-2097152,
                                                                                          2097151)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'gloGamma',
                                                                       'restricted-to': [(-1024,
                                                                                          1023)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'gloDeltaTau',
                                                                       'optional': True,
                                                                       'restricted-to': [(-16,
                                                                                          15)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'GNSS-AcquisitionAssistElement': {'members': [{'name': 'svID',
                                                                                  'type': 'SV-ID'},
                                                                                 {'name': 'doppler0',
                                                                                  'restricted-to': [(-2048,
                                                                                                     2047)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'doppler1',
                                                                                  'restricted-to': [(0,
                                                                                                     63)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'dopplerUncertainty',
                                                                                  'restricted-to': [(0,
                                                                                                     4)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'codePhase',
                                                                                  'restricted-to': [(0,
                                                                                                     1022)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'intCodePhase',
                                                                                  'restricted-to': [(0,
                                                                                                     127)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'codePhaseSearchWindow',
                                                                                  'restricted-to': [(0,
                                                                                                     31)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'azimuth',
                                                                                  'restricted-to': [(0,
                                                                                                     511)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'elevation',
                                                                                  'restricted-to': [(0,
                                                                                                     127)],
                                                                                  'type': 'INTEGER'},
                                                                                 None,
                                                                                 {'name': 'codePhase1023',
                                                                                  'optional': True,
                                                                                  'type': 'BOOLEAN'},
                                                                                 {'name': 'dopplerUncertaintyExt-r10',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('d60',
                                                                                              0),
                                                                                             ('d80',
                                                                                              1),
                                                                                             ('d100',
                                                                                              2),
                                                                                             ('d120',
                                                                                              3),
                                                                                             ('noInformation',
                                                                                              4),
                                                                                             None]}],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-AcquisitionAssistList': {'element': {'type': 'GNSS-AcquisitionAssistElement'},
                                                                  'size': [(1,
                                                                            64)],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                                   'GNSS-AcquisitionAssistance': {'members': [{'name': 'gnss-SignalID',
                                                                               'type': 'GNSS-SignalID'},
                                                                              {'name': 'gnss-AcquisitionAssistList',
                                                                               'type': 'GNSS-AcquisitionAssistList'},
                                                                              None,
                                                                              {'name': 'confidence-r10',
                                                                               'optional': True,
                                                                               'restricted-to': [(0,
                                                                                                  100)],
                                                                               'type': 'INTEGER'}],
                                                                  'type': 'SEQUENCE'},
                                   'GNSS-AcquisitionAssistanceReq': {'members': [{'name': 'gnss-SignalID-Req',
                                                                                  'type': 'GNSS-SignalID'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-AcquisitionAssistanceSupport': {'members': [None,
                                                                                     {'name': 'confidenceSupport-r10',
                                                                                      'optional': True,
                                                                                      'type': 'ENUMERATED',
                                                                                      'values': [('true',
                                                                                                  0)]},
                                                                                     {'name': 'dopplerUncertaintyExtSupport-r10',
                                                                                      'optional': True,
                                                                                      'type': 'ENUMERATED',
                                                                                      'values': [('true',
                                                                                                  0)]}],
                                                                         'type': 'SEQUENCE'},
                                   'GNSS-Almanac': {'members': [{'name': 'weekNumber',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    255)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'toa',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    255)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'ioda',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    3)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'completeAlmanacProvided',
                                                                 'type': 'BOOLEAN'},
                                                                {'name': 'gnss-AlmanacList',
                                                                 'type': 'GNSS-AlmanacList'},
                                                                None,
                                                                [{'name': 'toa-ext-v1240',
                                                                  'optional': True,
                                                                  'restricted-to': [(256,
                                                                                     1023)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'ioda-ext-v1240',
                                                                  'optional': True,
                                                                  'restricted-to': [(4,
                                                                                     15)],
                                                                  'type': 'INTEGER'}]],
                                                    'type': 'SEQUENCE'},
                                   'GNSS-AlmanacElement': {'members': [{'name': 'keplerianAlmanacSet',
                                                                        'type': 'AlmanacKeplerianSet'},
                                                                       {'name': 'keplerianNAV-Almanac',
                                                                        'type': 'AlmanacNAV-KeplerianSet'},
                                                                       {'name': 'keplerianReducedAlmanac',
                                                                        'type': 'AlmanacReducedKeplerianSet'},
                                                                       {'name': 'keplerianMidiAlmanac',
                                                                        'type': 'AlmanacMidiAlmanacSet'},
                                                                       {'name': 'keplerianGLONASS',
                                                                        'type': 'AlmanacGLONASS-AlmanacSet'},
                                                                       {'name': 'ecef-SBAS-Almanac',
                                                                        'type': 'AlmanacECEF-SBAS-AlmanacSet'},
                                                                       None,
                                                                       {'name': 'keplerianBDS-Almanac-r12',
                                                                        'type': 'AlmanacBDS-AlmanacSet-r12'}],
                                                           'type': 'CHOICE'},
                                   'GNSS-AlmanacList': {'element': {'type': 'GNSS-AlmanacElement'},
                                                        'size': [(1, 64)],
                                                        'type': 'SEQUENCE OF'},
                                   'GNSS-AlmanacReq': {'members': [{'name': 'modelID',
                                                                    'optional': True,
                                                                    'restricted-to': [(1,
                                                                                       8)],
                                                                    'type': 'INTEGER'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                   'GNSS-AlmanacSupport': {'members': [{'name': 'almanacModel',
                                                                        'named-bits': [('model-1',
                                                                                        '0'),
                                                                                       ('model-2',
                                                                                        '1'),
                                                                                       ('model-3',
                                                                                        '2'),
                                                                                       ('model-4',
                                                                                        '3'),
                                                                                       ('model-5',
                                                                                        '4'),
                                                                                       ('model-6',
                                                                                        '5'),
                                                                                       ('model-7',
                                                                                        '6')],
                                                                        'optional': True,
                                                                        'size': [(1,
                                                                                  8)],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'GNSS-AuxiliaryInformation': {'members': [{'name': 'gnss-ID-GPS',
                                                                              'type': 'GNSS-ID-GPS'},
                                                                             {'name': 'gnss-ID-GLONASS',
                                                                              'type': 'GNSS-ID-GLONASS'},
                                                                             None],
                                                                 'type': 'CHOICE'},
                                   'GNSS-AuxiliaryInformationReq': {'members': [None],
                                                                    'type': 'SEQUENCE'},
                                   'GNSS-AuxiliaryInformationSupport': {'members': [None],
                                                                        'type': 'SEQUENCE'},
                                   'GNSS-BadSignalList': {'element': {'type': 'BadSignalElement'},
                                                          'size': [(1, 64)],
                                                          'type': 'SEQUENCE '
                                                                  'OF'},
                                   'GNSS-ClockModel': {'members': [{'name': 'standardClockModelList',
                                                                    'type': 'StandardClockModelList'},
                                                                   {'name': 'nav-ClockModel',
                                                                    'type': 'NAV-ClockModel'},
                                                                   {'name': 'cnav-ClockModel',
                                                                    'type': 'CNAV-ClockModel'},
                                                                   {'name': 'glonass-ClockModel',
                                                                    'type': 'GLONASS-ClockModel'},
                                                                   {'name': 'sbas-ClockModel',
                                                                    'type': 'SBAS-ClockModel'},
                                                                   None,
                                                                   {'name': 'bds-ClockModel-r12',
                                                                    'type': 'BDS-ClockModel-r12'}],
                                                       'type': 'CHOICE'},
                                   'GNSS-CommonAssistData': {'members': [{'name': 'gnss-ReferenceTime',
                                                                          'optional': True,
                                                                          'type': 'GNSS-ReferenceTime'},
                                                                         {'name': 'gnss-ReferenceLocation',
                                                                          'optional': True,
                                                                          'type': 'GNSS-ReferenceLocation'},
                                                                         {'name': 'gnss-IonosphericModel',
                                                                          'optional': True,
                                                                          'type': 'GNSS-IonosphericModel'},
                                                                         {'name': 'gnss-EarthOrientationParameters',
                                                                          'optional': True,
                                                                          'type': 'GNSS-EarthOrientationParameters'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'GNSS-CommonAssistDataReq': {'members': [{'name': 'gnss-ReferenceTimeReq',
                                                                             'optional': True,
                                                                             'type': 'GNSS-ReferenceTimeReq'},
                                                                            {'name': 'gnss-ReferenceLocationReq',
                                                                             'optional': True,
                                                                             'type': 'GNSS-ReferenceLocationReq'},
                                                                            {'name': 'gnss-IonosphericModelReq',
                                                                             'optional': True,
                                                                             'type': 'GNSS-IonosphericModelReq'},
                                                                            {'name': 'gnss-EarthOrientationParametersReq',
                                                                             'optional': True,
                                                                             'type': 'GNSS-EarthOrientationParametersReq'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'GNSS-CommonAssistanceDataSupport': {'members': [{'name': 'gnss-ReferenceTimeSupport',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-ReferenceTimeSupport'},
                                                                                    {'name': 'gnss-ReferenceLocationSupport',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-ReferenceLocationSupport'},
                                                                                    {'name': 'gnss-IonosphericModelSupport',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-IonosphericModelSupport'},
                                                                                    {'name': 'gnss-EarthOrientationParametersSupport',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-EarthOrientationParametersSupport'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                   'GNSS-DataBitAssistance': {'members': [{'name': 'gnss-TOD',
                                                                           'restricted-to': [(0,
                                                                                              3599)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'gnss-TODfrac',
                                                                           'optional': True,
                                                                           'restricted-to': [(0,
                                                                                              999)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'gnss-DataBitsSatList',
                                                                           'type': 'GNSS-DataBitsSatList'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'GNSS-DataBitAssistanceReq': {'members': [{'name': 'gnss-TOD-Req',
                                                                              'restricted-to': [(0,
                                                                                                 3599)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gnss-TOD-FracReq',
                                                                              'optional': True,
                                                                              'restricted-to': [(0,
                                                                                                 999)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'dataBitInterval',
                                                                              'restricted-to': [(0,
                                                                                                 15)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'gnss-SignalType',
                                                                              'type': 'GNSS-SignalIDs'},
                                                                             {'name': 'gnss-DataBitsReq',
                                                                              'optional': True,
                                                                              'type': 'GNSS-DataBitsReqSatList'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'GNSS-DataBitAssistanceSupport': {'members': [None],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-DataBitsReqSatElement': {'members': [{'name': 'svID',
                                                                               'type': 'SV-ID'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'GNSS-DataBitsReqSatList': {'element': {'type': 'GNSS-DataBitsReqSatElement'},
                                                               'size': [(1,
                                                                         64)],
                                                               'type': 'SEQUENCE '
                                                                       'OF'},
                                   'GNSS-DataBitsSatElement': {'members': [{'name': 'svID',
                                                                            'type': 'SV-ID'},
                                                                           {'name': 'gnss-DataBitsSgnList',
                                                                            'type': 'GNSS-DataBitsSgnList'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                   'GNSS-DataBitsSatList': {'element': {'type': 'GNSS-DataBitsSatElement'},
                                                            'size': [(1, 64)],
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                                   'GNSS-DataBitsSgnElement': {'members': [{'name': 'gnss-SignalType',
                                                                            'type': 'GNSS-SignalID'},
                                                                           {'name': 'gnss-DataBits',
                                                                            'size': [(1,
                                                                                      1024)],
                                                                            'type': 'BIT '
                                                                                    'STRING'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                   'GNSS-DataBitsSgnList': {'element': {'type': 'GNSS-DataBitsSgnElement'},
                                                            'size': [(1, 8)],
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                                   'GNSS-DifferentialCorrections': {'members': [{'name': 'dgnss-RefTime',
                                                                                 'restricted-to': [(0,
                                                                                                    3599)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'dgnss-SgnTypeList',
                                                                                 'type': 'DGNSS-SgnTypeList'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'GNSS-DifferentialCorrectionsReq': {'members': [{'name': 'dgnss-SignalsReq',
                                                                                    'type': 'GNSS-SignalIDs'},
                                                                                   {'name': 'dgnss-ValidityTimeReq',
                                                                                    'type': 'BOOLEAN'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'GNSS-DifferentialCorrectionsSupport': {'members': [{'name': 'gnssSignalIDs',
                                                                                        'type': 'GNSS-SignalIDs'},
                                                                                       {'name': 'dgnss-ValidityTimeSup',
                                                                                        'type': 'BOOLEAN'},
                                                                                       None],
                                                                           'type': 'SEQUENCE'},
                                   'GNSS-EarthOrientationParameters': {'members': [{'name': 'teop',
                                                                                    'restricted-to': [(0,
                                                                                                       65535)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'pmX',
                                                                                    'restricted-to': [(-1048576,
                                                                                                       1048575)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'pmXdot',
                                                                                    'restricted-to': [(-16384,
                                                                                                       16383)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'pmY',
                                                                                    'restricted-to': [(-1048576,
                                                                                                       1048575)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'pmYdot',
                                                                                    'restricted-to': [(-16384,
                                                                                                       16383)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'deltaUT1',
                                                                                    'restricted-to': [(-1073741824,
                                                                                                       1073741823)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'deltaUT1dot',
                                                                                    'restricted-to': [(-262144,
                                                                                                       262143)],
                                                                                    'type': 'INTEGER'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'GNSS-EarthOrientationParametersReq': {'members': [None],
                                                                          'type': 'SEQUENCE'},
                                   'GNSS-EarthOrientationParametersSupport': {'members': [None],
                                                                              'type': 'SEQUENCE'},
                                   'GNSS-GenericAssistData': {'element': {'type': 'GNSS-GenericAssistDataElement'},
                                                              'size': [(1, 16)],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                   'GNSS-GenericAssistDataElement': {'members': [{'name': 'gnss-ID',
                                                                                  'type': 'GNSS-ID'},
                                                                                 {'name': 'sbas-ID',
                                                                                  'optional': True,
                                                                                  'type': 'SBAS-ID'},
                                                                                 {'name': 'gnss-TimeModels',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-TimeModelList'},
                                                                                 {'name': 'gnss-DifferentialCorrections',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-DifferentialCorrections'},
                                                                                 {'name': 'gnss-NavigationModel',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-NavigationModel'},
                                                                                 {'name': 'gnss-RealTimeIntegrity',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-RealTimeIntegrity'},
                                                                                 {'name': 'gnss-DataBitAssistance',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-DataBitAssistance'},
                                                                                 {'name': 'gnss-AcquisitionAssistance',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-AcquisitionAssistance'},
                                                                                 {'name': 'gnss-Almanac',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-Almanac'},
                                                                                 {'name': 'gnss-UTC-Model',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-UTC-Model'},
                                                                                 {'name': 'gnss-AuxiliaryInformation',
                                                                                  'optional': True,
                                                                                  'type': 'GNSS-AuxiliaryInformation'},
                                                                                 None,
                                                                                 [{'name': 'bds-DifferentialCorrections-r12',
                                                                                   'optional': True,
                                                                                   'type': 'BDS-DifferentialCorrections-r12'},
                                                                                  {'name': 'bds-GridModel-r12',
                                                                                   'optional': True,
                                                                                   'type': 'BDS-GridModelParameter-r12'}]],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-GenericAssistDataReq': {'element': {'type': 'GNSS-GenericAssistDataReqElement'},
                                                                 'size': [(1,
                                                                           16)],
                                                                 'type': 'SEQUENCE '
                                                                         'OF'},
                                   'GNSS-GenericAssistDataReqElement': {'members': [{'name': 'gnss-ID',
                                                                                     'type': 'GNSS-ID'},
                                                                                    {'name': 'sbas-ID',
                                                                                     'optional': True,
                                                                                     'type': 'SBAS-ID'},
                                                                                    {'name': 'gnss-TimeModelsReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-TimeModelListReq'},
                                                                                    {'name': 'gnss-DifferentialCorrectionsReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-DifferentialCorrectionsReq'},
                                                                                    {'name': 'gnss-NavigationModelReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-NavigationModelReq'},
                                                                                    {'name': 'gnss-RealTimeIntegrityReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-RealTimeIntegrityReq'},
                                                                                    {'name': 'gnss-DataBitAssistanceReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-DataBitAssistanceReq'},
                                                                                    {'name': 'gnss-AcquisitionAssistanceReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-AcquisitionAssistanceReq'},
                                                                                    {'name': 'gnss-AlmanacReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-AlmanacReq'},
                                                                                    {'name': 'gnss-UTCModelReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-UTC-ModelReq'},
                                                                                    {'name': 'gnss-AuxiliaryInformationReq',
                                                                                     'optional': True,
                                                                                     'type': 'GNSS-AuxiliaryInformationReq'},
                                                                                    None,
                                                                                    [{'name': 'bds-DifferentialCorrectionsReq-r12',
                                                                                      'optional': True,
                                                                                      'type': 'BDS-DifferentialCorrectionsReq-r12'},
                                                                                     {'name': 'bds-GridModelReq-r12',
                                                                                      'optional': True,
                                                                                      'type': 'BDS-GridModelReq-r12'}]],
                                                                        'type': 'SEQUENCE'},
                                   'GNSS-GenericAssistDataSupportElement': {'members': [{'name': 'gnss-ID',
                                                                                         'type': 'GNSS-ID'},
                                                                                        {'name': 'sbas-ID',
                                                                                         'optional': True,
                                                                                         'type': 'SBAS-ID'},
                                                                                        {'name': 'gnss-TimeModelsSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-TimeModelListSupport'},
                                                                                        {'name': 'gnss-DifferentialCorrectionsSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-DifferentialCorrectionsSupport'},
                                                                                        {'name': 'gnss-NavigationModelSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-NavigationModelSupport'},
                                                                                        {'name': 'gnss-RealTimeIntegritySupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-RealTimeIntegritySupport'},
                                                                                        {'name': 'gnss-DataBitAssistanceSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-DataBitAssistanceSupport'},
                                                                                        {'name': 'gnss-AcquisitionAssistanceSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-AcquisitionAssistanceSupport'},
                                                                                        {'name': 'gnss-AlmanacSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-AlmanacSupport'},
                                                                                        {'name': 'gnss-UTC-ModelSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-UTC-ModelSupport'},
                                                                                        {'name': 'gnss-AuxiliaryInformationSupport',
                                                                                         'optional': True,
                                                                                         'type': 'GNSS-AuxiliaryInformationSupport'},
                                                                                        None,
                                                                                        [{'name': 'bds-DifferentialCorrectionsSupport-r12',
                                                                                          'optional': True,
                                                                                          'type': 'BDS-DifferentialCorrectionsSupport-r12'},
                                                                                         {'name': 'bds-GridModelSupport-r12',
                                                                                          'optional': True,
                                                                                          'type': 'BDS-GridModelSupport-r12'}]],
                                                                            'type': 'SEQUENCE'},
                                   'GNSS-GenericAssistanceDataSupport': {'element': {'type': 'GNSS-GenericAssistDataSupportElement'},
                                                                         'size': [(1,
                                                                                   16)],
                                                                         'type': 'SEQUENCE '
                                                                                 'OF'},
                                   'GNSS-ID': {'members': [{'name': 'gnss-id',
                                                            'type': 'ENUMERATED',
                                                            'values': [('gps',
                                                                        0),
                                                                       ('sbas',
                                                                        1),
                                                                       ('qzss',
                                                                        2),
                                                                       ('galileo',
                                                                        3),
                                                                       ('glonass',
                                                                        4),
                                                                       None,
                                                                       ('bds',
                                                                        5)]},
                                                           None],
                                               'type': 'SEQUENCE'},
                                   'GNSS-ID-Bitmap': {'members': [{'name': 'gnss-ids',
                                                                   'named-bits': [('gps',
                                                                                   '0'),
                                                                                  ('sbas',
                                                                                   '1'),
                                                                                  ('qzss',
                                                                                   '2'),
                                                                                  ('galileo',
                                                                                   '3'),
                                                                                  ('glonass',
                                                                                   '4'),
                                                                                  ('bds',
                                                                                   '5')],
                                                                   'size': [(1,
                                                                             16)],
                                                                   'type': 'BIT '
                                                                           'STRING'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                   'GNSS-ID-GLONASS': {'element': {'type': 'GNSS-ID-GLONASS-SatElement'},
                                                       'size': [(1, 64)],
                                                       'type': 'SEQUENCE OF'},
                                   'GNSS-ID-GLONASS-SatElement': {'members': [{'name': 'svID',
                                                                               'type': 'SV-ID'},
                                                                              {'name': 'signalsAvailable',
                                                                               'type': 'GNSS-SignalIDs'},
                                                                              {'name': 'channelNumber',
                                                                               'optional': True,
                                                                               'restricted-to': [(-7,
                                                                                                  13)],
                                                                               'type': 'INTEGER'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'GNSS-ID-GPS': {'element': {'type': 'GNSS-ID-GPS-SatElement'},
                                                   'size': [(1, 64)],
                                                   'type': 'SEQUENCE OF'},
                                   'GNSS-ID-GPS-SatElement': {'members': [{'name': 'svID',
                                                                           'type': 'SV-ID'},
                                                                          {'name': 'signalsAvailable',
                                                                           'type': 'GNSS-SignalIDs'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'GNSS-IonosphericModel': {'members': [{'name': 'klobucharModel',
                                                                          'optional': True,
                                                                          'type': 'KlobucharModelParameter'},
                                                                         {'name': 'neQuickModel',
                                                                          'optional': True,
                                                                          'type': 'NeQuickModelParameter'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'GNSS-IonosphericModelReq': {'members': [{'name': 'klobucharModelReq',
                                                                             'optional': True,
                                                                             'size': [2],
                                                                             'type': 'BIT '
                                                                                     'STRING'},
                                                                            {'name': 'neQuickModelReq',
                                                                             'optional': True,
                                                                             'type': 'NULL'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'GNSS-IonosphericModelSupport': {'members': [{'name': 'ionoModel',
                                                                                 'named-bits': [('klobuchar',
                                                                                                 '0'),
                                                                                                ('neQuick',
                                                                                                 '1')],
                                                                                 'size': [(1,
                                                                                           8)],
                                                                                 'type': 'BIT '
                                                                                         'STRING'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'GNSS-LocationInformation': {'members': [{'name': 'measurementReferenceTime',
                                                                             'type': 'MeasurementReferenceTime'},
                                                                            {'name': 'agnss-List',
                                                                             'type': 'GNSS-ID-Bitmap'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'GNSS-LocationServerErrorCauses': {'members': [{'name': 'cause',
                                                                                   'type': 'ENUMERATED',
                                                                                   'values': [('undefined',
                                                                                               0),
                                                                                              ('undeliveredAssistanceDataIsNotSupportedByServer',
                                                                                               1),
                                                                                              ('undeliveredAssistanceDataIsSupportedButCurrentlyNotAvailableByServer',
                                                                                               2),
                                                                                              ('undeliveredAssistanceDataIsPartlyNotSupportedAndPartlyNotAvailableByServer',
                                                                                               3),
                                                                                              None]},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'GNSS-MeasurementForOneGNSS': {'members': [{'name': 'gnss-ID',
                                                                               'type': 'GNSS-ID'},
                                                                              {'name': 'gnss-SgnMeasList',
                                                                               'type': 'GNSS-SgnMeasList'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'GNSS-MeasurementList': {'element': {'type': 'GNSS-MeasurementForOneGNSS'},
                                                            'size': [(1, 16)],
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                                   'GNSS-NavModelSatelliteElement': {'members': [{'name': 'svID',
                                                                                  'type': 'SV-ID'},
                                                                                 {'name': 'svHealth',
                                                                                  'size': [8],
                                                                                  'type': 'BIT '
                                                                                          'STRING'},
                                                                                 {'name': 'iod',
                                                                                  'size': [11],
                                                                                  'type': 'BIT '
                                                                                          'STRING'},
                                                                                 {'name': 'gnss-ClockModel',
                                                                                  'type': 'GNSS-ClockModel'},
                                                                                 {'name': 'gnss-OrbitModel',
                                                                                  'type': 'GNSS-OrbitModel'},
                                                                                 None,
                                                                                 [{'name': 'svHealthExt-v1240',
                                                                                   'optional': True,
                                                                                   'size': [4],
                                                                                   'type': 'BIT '
                                                                                           'STRING'}]],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-NavModelSatelliteList': {'element': {'type': 'GNSS-NavModelSatelliteElement'},
                                                                  'size': [(1,
                                                                            64)],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                                   'GNSS-NavigationModel': {'members': [{'name': 'nonBroadcastIndFlag',
                                                                         'restricted-to': [(0,
                                                                                            1)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'gnss-SatelliteList',
                                                                         'type': 'GNSS-NavModelSatelliteList'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                   'GNSS-NavigationModelReq': {'members': [{'name': 'storedNavList',
                                                                            'type': 'StoredNavListInfo'},
                                                                           {'name': 'reqNavList',
                                                                            'type': 'ReqNavListInfo'},
                                                                           None],
                                                               'type': 'CHOICE'},
                                   'GNSS-NavigationModelSupport': {'members': [{'name': 'clockModel',
                                                                                'named-bits': [('model-1',
                                                                                                '0'),
                                                                                               ('model-2',
                                                                                                '1'),
                                                                                               ('model-3',
                                                                                                '2'),
                                                                                               ('model-4',
                                                                                                '3'),
                                                                                               ('model-5',
                                                                                                '4'),
                                                                                               ('model-6',
                                                                                                '5')],
                                                                                'optional': True,
                                                                                'size': [(1,
                                                                                          8)],
                                                                                'type': 'BIT '
                                                                                        'STRING'},
                                                                               {'name': 'orbitModel',
                                                                                'named-bits': [('model-1',
                                                                                                '0'),
                                                                                               ('model-2',
                                                                                                '1'),
                                                                                               ('model-3',
                                                                                                '2'),
                                                                                               ('model-4',
                                                                                                '3'),
                                                                                               ('model-5',
                                                                                                '4'),
                                                                                               ('model-6',
                                                                                                '5')],
                                                                                'optional': True,
                                                                                'size': [(1,
                                                                                          8)],
                                                                                'type': 'BIT '
                                                                                        'STRING'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                   'GNSS-OrbitModel': {'members': [{'name': 'keplerianSet',
                                                                    'type': 'NavModelKeplerianSet'},
                                                                   {'name': 'nav-KeplerianSet',
                                                                    'type': 'NavModelNAV-KeplerianSet'},
                                                                   {'name': 'cnav-KeplerianSet',
                                                                    'type': 'NavModelCNAV-KeplerianSet'},
                                                                   {'name': 'glonass-ECEF',
                                                                    'type': 'NavModel-GLONASS-ECEF'},
                                                                   {'name': 'sbas-ECEF',
                                                                    'type': 'NavModel-SBAS-ECEF'},
                                                                   None,
                                                                   {'name': 'bds-KeplerianSet-r12',
                                                                    'type': 'NavModel-BDS-KeplerianSet-r12'}],
                                                       'type': 'CHOICE'},
                                   'GNSS-PositioningInstructions': {'members': [{'name': 'gnss-Methods',
                                                                                 'type': 'GNSS-ID-Bitmap'},
                                                                                {'name': 'fineTimeAssistanceMeasReq',
                                                                                 'type': 'BOOLEAN'},
                                                                                {'name': 'adrMeasReq',
                                                                                 'type': 'BOOLEAN'},
                                                                                {'name': 'multiFreqMeasReq',
                                                                                 'type': 'BOOLEAN'},
                                                                                {'name': 'assistanceAvailability',
                                                                                 'type': 'BOOLEAN'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'GNSS-RealTimeIntegrity': {'members': [{'name': 'gnss-BadSignalList',
                                                                           'type': 'GNSS-BadSignalList'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'GNSS-RealTimeIntegrityReq': {'members': [None],
                                                                 'type': 'SEQUENCE'},
                                   'GNSS-RealTimeIntegritySupport': {'members': [None],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-ReferenceLocation': {'members': [{'name': 'threeDlocation',
                                                                           'type': 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'GNSS-ReferenceLocationReq': {'members': [None],
                                                                 'type': 'SEQUENCE'},
                                   'GNSS-ReferenceLocationSupport': {'members': [None],
                                                                     'type': 'SEQUENCE'},
                                   'GNSS-ReferenceTime': {'members': [{'name': 'gnss-SystemTime',
                                                                       'type': 'GNSS-SystemTime'},
                                                                      {'name': 'referenceTimeUnc',
                                                                       'optional': True,
                                                                       'restricted-to': [(0,
                                                                                          127)],
                                                                       'type': 'INTEGER'},
                                                                      {'element': {'type': 'GNSS-ReferenceTimeForOneCell'},
                                                                       'name': 'gnss-ReferenceTimeForCells',
                                                                       'optional': True,
                                                                       'size': [(1,
                                                                                 16)],
                                                                       'type': 'SEQUENCE '
                                                                               'OF'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'GNSS-ReferenceTimeForOneCell': {'members': [{'name': 'networkTime',
                                                                                 'type': 'NetworkTime'},
                                                                                {'name': 'referenceTimeUnc',
                                                                                 'restricted-to': [(0,
                                                                                                    127)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'bsAlign',
                                                                                 'optional': True,
                                                                                 'type': 'ENUMERATED',
                                                                                 'values': [('true',
                                                                                             0)]},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'GNSS-ReferenceTimeReq': {'members': [{'element': {'type': 'GNSS-ID'},
                                                                          'name': 'gnss-TimeReqPrefList',
                                                                          'size': [(1,
                                                                                    8)],
                                                                          'type': 'SEQUENCE '
                                                                                  'OF'},
                                                                         {'name': 'gps-TOW-assistReq',
                                                                          'optional': True,
                                                                          'type': 'BOOLEAN'},
                                                                         {'name': 'notOfLeapSecReq',
                                                                          'optional': True,
                                                                          'type': 'BOOLEAN'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'GNSS-ReferenceTimeSupport': {'members': [{'name': 'gnss-SystemTime',
                                                                              'type': 'GNSS-ID-Bitmap'},
                                                                             {'name': 'fta-Support',
                                                                              'optional': True,
                                                                              'type': 'AccessTypes'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'GNSS-SatMeasElement': {'members': [{'name': 'svID',
                                                                        'type': 'SV-ID'},
                                                                       {'name': 'cNo',
                                                                        'restricted-to': [(0,
                                                                                           63)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'mpathDet',
                                                                        'type': 'ENUMERATED',
                                                                        'values': [('notMeasured',
                                                                                    0),
                                                                                   ('low',
                                                                                    1),
                                                                                   ('medium',
                                                                                    2),
                                                                                   ('high',
                                                                                    3),
                                                                                   None]},
                                                                       {'name': 'carrierQualityInd',
                                                                        'optional': True,
                                                                        'restricted-to': [(0,
                                                                                           3)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'codePhase',
                                                                        'restricted-to': [(0,
                                                                                           2097151)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'integerCodePhase',
                                                                        'optional': True,
                                                                        'restricted-to': [(0,
                                                                                           127)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'codePhaseRMSError',
                                                                        'restricted-to': [(0,
                                                                                           63)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'doppler',
                                                                        'optional': True,
                                                                        'restricted-to': [(-32768,
                                                                                           32767)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'adr',
                                                                        'optional': True,
                                                                        'restricted-to': [(0,
                                                                                           33554431)],
                                                                        'type': 'INTEGER'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'GNSS-SatMeasList': {'element': {'type': 'GNSS-SatMeasElement'},
                                                        'size': [(1, 64)],
                                                        'type': 'SEQUENCE OF'},
                                   'GNSS-SgnMeasElement': {'members': [{'name': 'gnss-SignalID',
                                                                        'type': 'GNSS-SignalID'},
                                                                       {'name': 'gnss-CodePhaseAmbiguity',
                                                                        'optional': True,
                                                                        'restricted-to': [(0,
                                                                                           127)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'gnss-SatMeasList',
                                                                        'type': 'GNSS-SatMeasList'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'GNSS-SgnMeasList': {'element': {'type': 'GNSS-SgnMeasElement'},
                                                        'size': [(1, 8)],
                                                        'type': 'SEQUENCE OF'},
                                   'GNSS-SignalID': {'members': [{'name': 'gnss-SignalID',
                                                                  'restricted-to': [(0,
                                                                                     7)],
                                                                  'type': 'INTEGER'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'GNSS-SignalIDs': {'members': [{'name': 'gnss-SignalIDs',
                                                                   'size': [8],
                                                                   'type': 'BIT '
                                                                           'STRING'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                   'GNSS-SignalMeasurementInformation': {'members': [{'name': 'measurementReferenceTime',
                                                                                      'type': 'MeasurementReferenceTime'},
                                                                                     {'name': 'gnss-MeasurementList',
                                                                                      'type': 'GNSS-MeasurementList'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'GNSS-SupportElement': {'members': [{'name': 'gnss-ID',
                                                                        'type': 'GNSS-ID'},
                                                                       {'name': 'sbas-IDs',
                                                                        'optional': True,
                                                                        'type': 'SBAS-IDs'},
                                                                       {'name': 'agnss-Modes',
                                                                        'type': 'PositioningModes'},
                                                                       {'name': 'gnss-Signals',
                                                                        'type': 'GNSS-SignalIDs'},
                                                                       {'members': [{'name': 'cellTime',
                                                                                     'type': 'AccessTypes'},
                                                                                    {'name': 'mode',
                                                                                     'type': 'PositioningModes'},
                                                                                    None],
                                                                        'name': 'fta-MeasSupport',
                                                                        'optional': True,
                                                                        'type': 'SEQUENCE'},
                                                                       {'name': 'adr-Support',
                                                                        'type': 'BOOLEAN'},
                                                                       {'name': 'velocityMeasurementSupport',
                                                                        'type': 'BOOLEAN'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'GNSS-SupportList': {'element': {'type': 'GNSS-SupportElement'},
                                                        'size': [(1, 16)],
                                                        'type': 'SEQUENCE OF'},
                                   'GNSS-SystemTime': {'members': [{'name': 'gnss-TimeID',
                                                                    'type': 'GNSS-ID'},
                                                                   {'name': 'gnss-DayNumber',
                                                                    'restricted-to': [(0,
                                                                                       32767)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'gnss-TimeOfDay',
                                                                    'restricted-to': [(0,
                                                                                       86399)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'gnss-TimeOfDayFrac-msec',
                                                                    'optional': True,
                                                                    'restricted-to': [(0,
                                                                                       999)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'notificationOfLeapSecond',
                                                                    'optional': True,
                                                                    'size': [2],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'gps-TOW-Assist',
                                                                    'optional': True,
                                                                    'type': 'GPS-TOW-Assist'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                   'GNSS-TargetDeviceErrorCauses': {'members': [{'name': 'cause',
                                                                                 'type': 'ENUMERATED',
                                                                                 'values': [('undefined',
                                                                                             0),
                                                                                            ('thereWereNotEnoughSatellitesReceived',
                                                                                             1),
                                                                                            ('assistanceDataMissing',
                                                                                             2),
                                                                                            ('notAllRequestedMeasurementsPossible',
                                                                                             3),
                                                                                            None]},
                                                                                {'name': 'fineTimeAssistanceMeasurementsNotPossible',
                                                                                 'optional': True,
                                                                                 'type': 'NULL'},
                                                                                {'name': 'adrMeasurementsNotPossible',
                                                                                 'optional': True,
                                                                                 'type': 'NULL'},
                                                                                {'name': 'multiFrequencyMeasurementsNotPossible',
                                                                                 'optional': True,
                                                                                 'type': 'NULL'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'GNSS-TimeModelElement': {'members': [{'name': 'gnss-TimeModelRefTime',
                                                                          'restricted-to': [(0,
                                                                                             65535)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'tA0',
                                                                          'restricted-to': [(-67108864,
                                                                                             67108863)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'tA1',
                                                                          'optional': True,
                                                                          'restricted-to': [(-4096,
                                                                                             4095)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'tA2',
                                                                          'optional': True,
                                                                          'restricted-to': [(-64,
                                                                                             63)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gnss-TO-ID',
                                                                          'restricted-to': [(1,
                                                                                             15)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'weekNumber',
                                                                          'optional': True,
                                                                          'restricted-to': [(0,
                                                                                             8191)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'deltaT',
                                                                          'optional': True,
                                                                          'restricted-to': [(-128,
                                                                                             127)],
                                                                          'type': 'INTEGER'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'GNSS-TimeModelElementReq': {'members': [{'name': 'gnss-TO-IDsReq',
                                                                             'restricted-to': [(1,
                                                                                                15)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'deltaTreq',
                                                                             'type': 'BOOLEAN'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'GNSS-TimeModelList': {'element': {'type': 'GNSS-TimeModelElement'},
                                                          'size': [(1, 15)],
                                                          'type': 'SEQUENCE '
                                                                  'OF'},
                                   'GNSS-TimeModelListReq': {'element': {'type': 'GNSS-TimeModelElementReq'},
                                                             'size': [(1, 15)],
                                                             'type': 'SEQUENCE '
                                                                     'OF'},
                                   'GNSS-TimeModelListSupport': {'members': [None],
                                                                 'type': 'SEQUENCE'},
                                   'GNSS-UTC-Model': {'members': [{'name': 'utcModel1',
                                                                   'type': 'UTC-ModelSet1'},
                                                                  {'name': 'utcModel2',
                                                                   'type': 'UTC-ModelSet2'},
                                                                  {'name': 'utcModel3',
                                                                   'type': 'UTC-ModelSet3'},
                                                                  {'name': 'utcModel4',
                                                                   'type': 'UTC-ModelSet4'},
                                                                  None,
                                                                  {'name': 'utcModel5-r12',
                                                                   'type': 'UTC-ModelSet5-r12'}],
                                                      'type': 'CHOICE'},
                                   'GNSS-UTC-ModelReq': {'members': [{'name': 'modelID',
                                                                      'optional': True,
                                                                      'restricted-to': [(1,
                                                                                         8)],
                                                                      'type': 'INTEGER'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'GNSS-UTC-ModelSupport': {'members': [{'name': 'utc-Model',
                                                                          'named-bits': [('model-1',
                                                                                          '0'),
                                                                                         ('model-2',
                                                                                          '1'),
                                                                                         ('model-3',
                                                                                          '2'),
                                                                                         ('model-4',
                                                                                          '3'),
                                                                                         ('model-5',
                                                                                          '4')],
                                                                          'optional': True,
                                                                          'size': [(1,
                                                                                    8)],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'GPS-TOW-Assist': {'element': {'type': 'GPS-TOW-AssistElement'},
                                                      'size': [(1, 64)],
                                                      'type': 'SEQUENCE OF'},
                                   'GPS-TOW-AssistElement': {'members': [{'name': 'satelliteID',
                                                                          'restricted-to': [(1,
                                                                                             64)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'tlmWord',
                                                                          'restricted-to': [(0,
                                                                                             16383)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'antiSpoof',
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'alert',
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'tlmRsvdBits',
                                                                          'restricted-to': [(0,
                                                                                             3)],
                                                                          'type': 'INTEGER'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'GridIonElement-r12': {'members': [{'name': 'igp-ID-r12',
                                                                       'restricted-to': [(1,
                                                                                          320)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'dt-r12',
                                                                       'restricted-to': [(0,
                                                                                          511)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'givei-r12',
                                                                       'restricted-to': [(0,
                                                                                          15)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'GridIonList-r12': {'element': {'type': 'GridIonElement-r12'},
                                                       'size': [(1, 320)],
                                                       'type': 'SEQUENCE OF'},
                                   'HorizontalAccuracy': {'members': [{'name': 'accuracy',
                                                                       'restricted-to': [(0,
                                                                                          127)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'confidence',
                                                                       'restricted-to': [(0,
                                                                                          100)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'HorizontalVelocity': {'members': [{'name': 'bearing',
                                                                       'restricted-to': [(0,
                                                                                          359)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'horizontalSpeed',
                                                                       'restricted-to': [(0,
                                                                                          2047)],
                                                                       'type': 'INTEGER'}],
                                                          'type': 'SEQUENCE'},
                                   'HorizontalVelocityWithUncertainty': {'members': [{'name': 'bearing',
                                                                                      'restricted-to': [(0,
                                                                                                         359)],
                                                                                      'type': 'INTEGER'},
                                                                                     {'name': 'horizontalSpeed',
                                                                                      'restricted-to': [(0,
                                                                                                         2047)],
                                                                                      'type': 'INTEGER'},
                                                                                     {'name': 'uncertaintySpeed',
                                                                                      'restricted-to': [(0,
                                                                                                         255)],
                                                                                      'type': 'INTEGER'}],
                                                                         'type': 'SEQUENCE'},
                                   'HorizontalWithVerticalVelocity': {'members': [{'name': 'bearing',
                                                                                   'restricted-to': [(0,
                                                                                                      359)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'horizontalSpeed',
                                                                                   'restricted-to': [(0,
                                                                                                      2047)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'verticalDirection',
                                                                                   'type': 'ENUMERATED',
                                                                                   'values': [('upward',
                                                                                               0),
                                                                                              ('downward',
                                                                                               1)]},
                                                                                  {'name': 'verticalSpeed',
                                                                                   'restricted-to': [(0,
                                                                                                      255)],
                                                                                   'type': 'INTEGER'}],
                                                                      'type': 'SEQUENCE'},
                                   'HorizontalWithVerticalVelocityAndUncertainty': {'members': [{'name': 'bearing',
                                                                                                 'restricted-to': [(0,
                                                                                                                    359)],
                                                                                                 'type': 'INTEGER'},
                                                                                                {'name': 'horizontalSpeed',
                                                                                                 'restricted-to': [(0,
                                                                                                                    2047)],
                                                                                                 'type': 'INTEGER'},
                                                                                                {'name': 'verticalDirection',
                                                                                                 'type': 'ENUMERATED',
                                                                                                 'values': [('upward',
                                                                                                             0),
                                                                                                            ('downward',
                                                                                                             1)]},
                                                                                                {'name': 'verticalSpeed',
                                                                                                 'restricted-to': [(0,
                                                                                                                    255)],
                                                                                                 'type': 'INTEGER'},
                                                                                                {'name': 'horizontalUncertaintySpeed',
                                                                                                 'restricted-to': [(0,
                                                                                                                    255)],
                                                                                                 'type': 'INTEGER'},
                                                                                                {'name': 'verticalUncertaintySpeed',
                                                                                                 'restricted-to': [(0,
                                                                                                                    255)],
                                                                                                 'type': 'INTEGER'}],
                                                                                    'type': 'SEQUENCE'},
                                   'Initiator': {'type': 'ENUMERATED',
                                                 'values': [('locationServer',
                                                             0),
                                                            ('targetDevice', 1),
                                                            None]},
                                   'KlobucharModelParameter': {'members': [{'name': 'dataID',
                                                                            'size': [2],
                                                                            'type': 'BIT '
                                                                                    'STRING'},
                                                                           {'name': 'alfa0',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'alfa1',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'alfa2',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'alfa3',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'beta0',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'beta1',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'beta2',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'beta3',
                                                                            'restricted-to': [(-128,
                                                                                               127)],
                                                                            'type': 'INTEGER'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                   'LPP-Message': {'members': [{'name': 'transactionID',
                                                                'optional': True,
                                                                'type': 'LPP-TransactionID'},
                                                               {'name': 'endTransaction',
                                                                'type': 'BOOLEAN'},
                                                               {'name': 'sequenceNumber',
                                                                'optional': True,
                                                                'type': 'SequenceNumber'},
                                                               {'name': 'acknowledgement',
                                                                'optional': True,
                                                                'type': 'Acknowledgement'},
                                                               {'name': 'lpp-MessageBody',
                                                                'optional': True,
                                                                'type': 'LPP-MessageBody'}],
                                                   'type': 'SEQUENCE'},
                                   'LPP-MessageBody': {'members': [{'members': [{'name': 'requestCapabilities',
                                                                                 'type': 'RequestCapabilities'},
                                                                                {'name': 'provideCapabilities',
                                                                                 'type': 'ProvideCapabilities'},
                                                                                {'name': 'requestAssistanceData',
                                                                                 'type': 'RequestAssistanceData'},
                                                                                {'name': 'provideAssistanceData',
                                                                                 'type': 'ProvideAssistanceData'},
                                                                                {'name': 'requestLocationInformation',
                                                                                 'type': 'RequestLocationInformation'},
                                                                                {'name': 'provideLocationInformation',
                                                                                 'type': 'ProvideLocationInformation'},
                                                                                {'name': 'abort',
                                                                                 'type': 'Abort'},
                                                                                {'name': 'error',
                                                                                 'type': 'Error'},
                                                                                {'name': 'spare7',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare6',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare5',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare4',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare3',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare2',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare1',
                                                                                 'type': 'NULL'},
                                                                                {'name': 'spare0',
                                                                                 'type': 'NULL'}],
                                                                    'name': 'c1',
                                                                    'type': 'CHOICE'},
                                                                   {'members': [],
                                                                    'name': 'messageClassExtension',
                                                                    'type': 'SEQUENCE'}],
                                                       'type': 'CHOICE'},
                                   'LPP-TransactionID': {'members': [{'name': 'initiator',
                                                                      'type': 'Initiator'},
                                                                     {'name': 'transactionNumber',
                                                                      'type': 'TransactionNumber'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'LocationCoordinateTypes': {'members': [{'name': 'ellipsoidPoint',
                                                                            'type': 'BOOLEAN'},
                                                                           {'name': 'ellipsoidPointWithUncertaintyCircle',
                                                                            'type': 'BOOLEAN'},
                                                                           {'name': 'ellipsoidPointWithUncertaintyEllipse',
                                                                            'type': 'BOOLEAN'},
                                                                           {'name': 'polygon',
                                                                            'type': 'BOOLEAN'},
                                                                           {'name': 'ellipsoidPointWithAltitude',
                                                                            'type': 'BOOLEAN'},
                                                                           {'name': 'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid',
                                                                            'type': 'BOOLEAN'},
                                                                           {'name': 'ellipsoidArc',
                                                                            'type': 'BOOLEAN'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                   'LocationCoordinates': {'members': [{'name': 'ellipsoidPoint',
                                                                        'type': 'Ellipsoid-Point'},
                                                                       {'name': 'ellipsoidPointWithUncertaintyCircle',
                                                                        'type': 'Ellipsoid-PointWithUncertaintyCircle'},
                                                                       {'name': 'ellipsoidPointWithUncertaintyEllipse',
                                                                        'type': 'EllipsoidPointWithUncertaintyEllipse'},
                                                                       {'name': 'polygon',
                                                                        'type': 'Polygon'},
                                                                       {'name': 'ellipsoidPointWithAltitude',
                                                                        'type': 'EllipsoidPointWithAltitude'},
                                                                       {'name': 'ellipsoidPointWithAltitudeAndUncertaintyEllipsoid',
                                                                        'type': 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid'},
                                                                       {'name': 'ellipsoidArc',
                                                                        'type': 'EllipsoidArc'},
                                                                       None],
                                                           'type': 'CHOICE'},
                                   'LocationDataLCI-r14': {'members': [{'name': 'latitudeUncertainty-r14',
                                                                        'size': [6],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'latitude-r14',
                                                                        'size': [34],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'longitudeUncertainty-r14',
                                                                        'size': [6],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'longitude-r14',
                                                                        'size': [34],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'altitudeUncertainty-r14',
                                                                        'optional': True,
                                                                        'size': [6],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'altitude-r14',
                                                                        'optional': True,
                                                                        'size': [30],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'datum-r14',
                                                                        'size': [8],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'LocationError': {'members': [{'name': 'locationfailurecause',
                                                                  'type': 'LocationFailureCause'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'LocationFailureCause': {'type': 'ENUMERATED',
                                                            'values': [('undefined',
                                                                        0),
                                                                       ('requestedMethodNotSupported',
                                                                        1),
                                                                       ('positionMethodFailure',
                                                                        2),
                                                                       ('periodicLocationMeasurementsNotAvailable',
                                                                        3),
                                                                       None]},
                                   'LocationInformationType': {'type': 'ENUMERATED',
                                                               'values': [('locationEstimateRequired',
                                                                           0),
                                                                          ('locationMeasurementsRequired',
                                                                           1),
                                                                          ('locationEstimatePreferred',
                                                                           2),
                                                                          ('locationMeasurementsPreferred',
                                                                           3),
                                                                          None]},
                                   'LocationSource-r13': {'named-bits': [('a-gnss',
                                                                          '0'),
                                                                         ('wlan',
                                                                          '1'),
                                                                         ('bt',
                                                                          '2'),
                                                                         ('tbs',
                                                                          '3'),
                                                                         ('sensor',
                                                                          '4')],
                                                          'size': [(1, 16)],
                                                          'type': 'BIT STRING'},
                                   'MBS-AcquisitionAssistance-r14': {'members': [{'name': 'transmitterID-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     32767)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'mbsConfiguration-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('tb1',
                                                                                              0),
                                                                                             ('tb2',
                                                                                              1),
                                                                                             ('tb3',
                                                                                              2),
                                                                                             ('tb4',
                                                                                              3),
                                                                                             None]},
                                                                                 {'name': 'pnCodeIndex-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(1,
                                                                                                     128)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'freq-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(919750000,
                                                                                                     927250000)],
                                                                                  'type': 'INTEGER'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'MBS-AlmanacAssistance-r14': {'members': [{'name': 'transmitterID-r14',
                                                                              'restricted-to': [(0,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'transmitterLatitude-r14',
                                                                              'size': [26],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             {'name': 'transmitterLongitude-r14',
                                                                              'size': [27],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             {'name': 'transmitterAltitude-r14',
                                                                              'size': [15],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             {'name': 'timeCorrection-r14',
                                                                              'optional': True,
                                                                              'restricted-to': [(0,
                                                                                                 25)],
                                                                              'type': 'INTEGER'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'MBS-AssistanceDataElement-r14': {'members': [{'name': 'mbs-AlmanacAssistance-r14',
                                                                                  'optional': True,
                                                                                  'type': 'MBS-AlmanacAssistance-r14'},
                                                                                 {'name': 'mbs-AcquisitionAssistance-r14',
                                                                                  'optional': True,
                                                                                  'type': 'MBS-AcquisitionAssistance-r14'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'MBS-AssistanceDataList-r14': {'element': {'type': 'MBS-AssistanceDataElement-r14'},
                                                                  'size': [(1,
                                                                            'maxMBS-r14')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                                   'MBS-AssistanceDataSupportList-r14': {'members': [{'name': 'mbs-AcquisitionAssistanceDataSupport-r14',
                                                                                      'type': 'BOOLEAN'},
                                                                                     {'name': 'mbs-AlmanacAssistanceDataSupport-r14',
                                                                                      'type': 'BOOLEAN'},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'MBS-BeaconMeasElement-r13': {'members': [{'name': 'transmitterID-r13',
                                                                              'restricted-to': [(0,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'codePhase-r13',
                                                                              'restricted-to': [(0,
                                                                                                 2097151)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'codePhaseRMSError-r13',
                                                                              'restricted-to': [(0,
                                                                                                 63)],
                                                                              'type': 'INTEGER'},
                                                                             None,
                                                                             [{'name': 'rssi-r14',
                                                                               'optional': True,
                                                                               'restricted-to': [(-130,
                                                                                                  -30)],
                                                                               'type': 'INTEGER'}]],
                                                                 'type': 'SEQUENCE'},
                                   'MBS-BeaconMeasList-r13': {'element': {'type': 'MBS-BeaconMeasElement-r13'},
                                                              'size': [(1, 64)],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                   'MeasuredResultsElement': {'members': [{'name': 'physCellId',
                                                                           'restricted-to': [(0,
                                                                                              503)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'cellGlobalId',
                                                                           'optional': True,
                                                                           'type': 'CellGlobalIdEUTRA-AndUTRA'},
                                                                          {'name': 'arfcnEUTRA',
                                                                           'type': 'ARFCN-ValueEUTRA'},
                                                                          {'name': 'systemFrameNumber',
                                                                           'optional': True,
                                                                           'size': [10],
                                                                           'type': 'BIT '
                                                                                   'STRING'},
                                                                          {'name': 'rsrp-Result',
                                                                           'optional': True,
                                                                           'restricted-to': [(0,
                                                                                              97)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'rsrq-Result',
                                                                           'optional': True,
                                                                           'restricted-to': [(0,
                                                                                              34)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'ue-RxTxTimeDiff',
                                                                           'optional': True,
                                                                           'restricted-to': [(0,
                                                                                              4095)],
                                                                           'type': 'INTEGER'},
                                                                          None,
                                                                          [{'name': 'arfcnEUTRA-v9a0',
                                                                            'optional': True,
                                                                            'type': 'ARFCN-ValueEUTRA-v9a0'}],
                                                                          [{'name': 'nrsrp-Result-r14',
                                                                            'optional': True,
                                                                            'restricted-to': [(0,
                                                                                               113)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'nrsrq-Result-r14',
                                                                            'optional': True,
                                                                            'restricted-to': [(0,
                                                                                               74)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'carrierFreqOffsetNB-r14',
                                                                            'optional': True,
                                                                            'type': 'CarrierFreqOffsetNB-r14'},
                                                                           {'name': 'hyperSFN-r14',
                                                                            'optional': True,
                                                                            'size': [10],
                                                                            'type': 'BIT '
                                                                                    'STRING'}]],
                                                              'type': 'SEQUENCE'},
                                   'MeasuredResultsList': {'element': {'type': 'MeasuredResultsElement'},
                                                           'size': [(1, 32)],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                                   'MeasurementReferenceTime': {'members': [{'name': 'gnss-TOD-msec',
                                                                             'restricted-to': [(0,
                                                                                                3599999)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'gnss-TOD-frac',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                3999)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'gnss-TOD-unc',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                127)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'gnss-TimeID',
                                                                             'type': 'GNSS-ID'},
                                                                            {'members': [{'members': [{'name': 'physCellId',
                                                                                                       'restricted-to': [(0,
                                                                                                                          503)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'cellGlobalId',
                                                                                                       'optional': True,
                                                                                                       'type': 'CellGlobalIdEUTRA-AndUTRA'},
                                                                                                      {'name': 'systemFrameNumber',
                                                                                                       'size': [10],
                                                                                                       'type': 'BIT '
                                                                                                               'STRING'},
                                                                                                      None],
                                                                                          'name': 'eUTRA',
                                                                                          'type': 'SEQUENCE'},
                                                                                         {'members': [{'members': [{'members': [{'name': 'primary-CPICH-Info',
                                                                                                                                 'restricted-to': [(0,
                                                                                                                                                    511)],
                                                                                                                                 'type': 'INTEGER'},
                                                                                                                                None],
                                                                                                                    'name': 'fdd',
                                                                                                                    'type': 'SEQUENCE'},
                                                                                                                   {'members': [{'name': 'cellParameters',
                                                                                                                                 'restricted-to': [(0,
                                                                                                                                                    127)],
                                                                                                                                 'type': 'INTEGER'},
                                                                                                                                None],
                                                                                                                    'name': 'tdd',
                                                                                                                    'type': 'SEQUENCE'}],
                                                                                                       'name': 'mode',
                                                                                                       'type': 'CHOICE'},
                                                                                                      {'name': 'cellGlobalId',
                                                                                                       'optional': True,
                                                                                                       'type': 'CellGlobalIdEUTRA-AndUTRA'},
                                                                                                      {'name': 'referenceSystemFrameNumber',
                                                                                                       'restricted-to': [(0,
                                                                                                                          4095)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      None],
                                                                                          'name': 'uTRA',
                                                                                          'type': 'SEQUENCE'},
                                                                                         {'members': [{'name': 'bcchCarrier',
                                                                                                       'restricted-to': [(0,
                                                                                                                          1023)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'bsic',
                                                                                                       'restricted-to': [(0,
                                                                                                                          63)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'cellGlobalId',
                                                                                                       'optional': True,
                                                                                                       'type': 'CellGlobalIdGERAN'},
                                                                                                      {'members': [{'name': 'referenceFN',
                                                                                                                    'restricted-to': [(0,
                                                                                                                                       65535)],
                                                                                                                    'type': 'INTEGER'},
                                                                                                                   {'name': 'referenceFNMSB',
                                                                                                                    'optional': True,
                                                                                                                    'restricted-to': [(0,
                                                                                                                                       63)],
                                                                                                                    'type': 'INTEGER'},
                                                                                                                   None],
                                                                                                       'name': 'referenceFrame',
                                                                                                       'type': 'SEQUENCE'},
                                                                                                      {'name': 'deltaGNSS-TOD',
                                                                                                       'optional': True,
                                                                                                       'restricted-to': [(0,
                                                                                                                          127)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      None],
                                                                                          'name': 'gSM',
                                                                                          'type': 'SEQUENCE'},
                                                                                         None,
                                                                                         {'members': [{'name': 'nbPhysCellId-r14',
                                                                                                       'restricted-to': [(0,
                                                                                                                          503)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'nbCellGlobalId-r14',
                                                                                                       'optional': True,
                                                                                                       'type': 'ECGI'},
                                                                                                      {'name': 'sfn-r14',
                                                                                                       'size': [10],
                                                                                                       'type': 'BIT '
                                                                                                               'STRING'},
                                                                                                      {'name': 'hyperSFN-r14',
                                                                                                       'optional': True,
                                                                                                       'size': [10],
                                                                                                       'type': 'BIT '
                                                                                                               'STRING'},
                                                                                                      None],
                                                                                          'name': 'nbIoT-r14',
                                                                                          'type': 'SEQUENCE'}],
                                                                             'name': 'networkTime',
                                                                             'optional': True,
                                                                             'type': 'CHOICE'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'MessageSizeLimitNB-r14': {'members': [{'name': 'measurementLimit-r14',
                                                                           'optional': True,
                                                                           'restricted-to': [(1,
                                                                                              512)],
                                                                           'type': 'INTEGER'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'NAV-ClockModel': {'members': [{'name': 'navToc',
                                                                   'restricted-to': [(0,
                                                                                      37799)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'navaf2',
                                                                   'restricted-to': [(-128,
                                                                                      127)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'navaf1',
                                                                   'restricted-to': [(-32768,
                                                                                      32767)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'navaf0',
                                                                   'restricted-to': [(-2097152,
                                                                                      2097151)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'navTgd',
                                                                   'restricted-to': [(-128,
                                                                                      127)],
                                                                   'type': 'INTEGER'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                   'NPRS-Info-r14': {'members': [{'name': 'operationModeInfoNPRS-r14',
                                                                  'type': 'ENUMERATED',
                                                                  'values': [('inband',
                                                                              0),
                                                                             ('standalone',
                                                                              1)]},
                                                                 {'name': 'nprs-carrier-r14',
                                                                  'optional': True,
                                                                  'type': 'CarrierFreq-NB-r14'},
                                                                 {'name': 'nprsSequenceInfo-r14',
                                                                  'optional': True,
                                                                  'restricted-to': [(0,
                                                                                     174)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'nprsID-r14',
                                                                  'optional': True,
                                                                  'restricted-to': [(0,
                                                                                     4095)],
                                                                  'type': 'INTEGER'},
                                                                 {'members': [{'members': [{'name': 'subframePattern10-r14',
                                                                                            'size': [10],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'subframePattern40-r14',
                                                                                            'size': [40],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'}],
                                                                               'name': 'nprsBitmap-r14',
                                                                               'type': 'CHOICE'},
                                                                              {'members': [{'name': 'po2-r14',
                                                                                            'size': [2],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'po4-r14',
                                                                                            'size': [4],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'po8-r14',
                                                                                            'size': [8],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'po16-r14',
                                                                                            'size': [16],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           None],
                                                                               'name': 'nprs-MutingInfoA-r14',
                                                                               'optional': True,
                                                                               'type': 'CHOICE'},
                                                                              None],
                                                                  'name': 'partA-r14',
                                                                  'optional': True,
                                                                  'type': 'SEQUENCE'},
                                                                 {'members': [{'name': 'nprs-Period-r14',
                                                                               'type': 'ENUMERATED',
                                                                               'values': [('ms160',
                                                                                           0),
                                                                                          ('ms320',
                                                                                           1),
                                                                                          ('ms640',
                                                                                           2),
                                                                                          ('ms1280',
                                                                                           3),
                                                                                          None]},
                                                                              {'name': 'nprs-startSF-r14',
                                                                               'type': 'ENUMERATED',
                                                                               'values': [('zero',
                                                                                           0),
                                                                                          ('one-eighth',
                                                                                           1),
                                                                                          ('two-eighths',
                                                                                           2),
                                                                                          ('three-eighths',
                                                                                           3),
                                                                                          ('four-eighths',
                                                                                           4),
                                                                                          ('five-eighths',
                                                                                           5),
                                                                                          ('six-eighths',
                                                                                           6),
                                                                                          ('seven-eighths',
                                                                                           7),
                                                                                          None]},
                                                                              {'name': 'nprs-NumSF-r14',
                                                                               'type': 'ENUMERATED',
                                                                               'values': [('sf10',
                                                                                           0),
                                                                                          ('sf20',
                                                                                           1),
                                                                                          ('sf40',
                                                                                           2),
                                                                                          ('sf80',
                                                                                           3),
                                                                                          ('sf160',
                                                                                           4),
                                                                                          ('sf320',
                                                                                           5),
                                                                                          ('sf640',
                                                                                           6),
                                                                                          ('sf1280',
                                                                                           7),
                                                                                          None]},
                                                                              {'members': [{'name': 'po2-r14',
                                                                                            'size': [2],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'po4-r14',
                                                                                            'size': [4],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'po8-r14',
                                                                                            'size': [8],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           {'name': 'po16-r14',
                                                                                            'size': [16],
                                                                                            'type': 'BIT '
                                                                                                    'STRING'},
                                                                                           None],
                                                                               'name': 'nprs-MutingInfoB-r14',
                                                                               'optional': True,
                                                                               'type': 'CHOICE'},
                                                                              None],
                                                                  'name': 'partB-r14',
                                                                  'optional': True,
                                                                  'type': 'SEQUENCE'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'NavModel-BDS-KeplerianSet-r12': {'members': [{'name': 'bdsAODE-r12',
                                                                                  'restricted-to': [(0,
                                                                                                     31)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsURAI-r12',
                                                                                  'restricted-to': [(0,
                                                                                                     15)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsToe-r12',
                                                                                  'restricted-to': [(0,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsAPowerHalf-r12',
                                                                                  'restricted-to': [(0,
                                                                                                     4294967295)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsE-r12',
                                                                                  'restricted-to': [(0,
                                                                                                     4294967295)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsW-r12',
                                                                                  'restricted-to': [(-2147483648,
                                                                                                     2147483647)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsDeltaN-r12',
                                                                                  'restricted-to': [(-32768,
                                                                                                     32767)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsM0-r12',
                                                                                  'restricted-to': [(-2147483648,
                                                                                                     2147483647)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsOmega0-r12',
                                                                                  'restricted-to': [(-2147483648,
                                                                                                     2147483647)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsOmegaDot-r12',
                                                                                  'restricted-to': [(-8388608,
                                                                                                     8388607)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsI0-r12',
                                                                                  'restricted-to': [(-2147483648,
                                                                                                     2147483647)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsIDot-r12',
                                                                                  'restricted-to': [(-8192,
                                                                                                     8191)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsCuc-r12',
                                                                                  'restricted-to': [(-131072,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsCus-r12',
                                                                                  'restricted-to': [(-131072,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsCrc-r12',
                                                                                  'restricted-to': [(-131072,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsCrs-r12',
                                                                                  'restricted-to': [(-131072,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsCic-r12',
                                                                                  'restricted-to': [(-131072,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'bdsCis-r12',
                                                                                  'restricted-to': [(-131072,
                                                                                                     131071)],
                                                                                  'type': 'INTEGER'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'NavModel-GLONASS-ECEF': {'members': [{'name': 'gloEn',
                                                                          'restricted-to': [(0,
                                                                                             31)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloP1',
                                                                          'size': [2],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'gloP2',
                                                                          'type': 'BOOLEAN'},
                                                                         {'name': 'gloM',
                                                                          'restricted-to': [(0,
                                                                                             3)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloX',
                                                                          'restricted-to': [(-67108864,
                                                                                             67108863)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloXdot',
                                                                          'restricted-to': [(-8388608,
                                                                                             8388607)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloXdotdot',
                                                                          'restricted-to': [(-16,
                                                                                             15)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloY',
                                                                          'restricted-to': [(-67108864,
                                                                                             67108863)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloYdot',
                                                                          'restricted-to': [(-8388608,
                                                                                             8388607)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloYdotdot',
                                                                          'restricted-to': [(-16,
                                                                                             15)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloZ',
                                                                          'restricted-to': [(-67108864,
                                                                                             67108863)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloZdot',
                                                                          'restricted-to': [(-8388608,
                                                                                             8388607)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'gloZdotdot',
                                                                          'restricted-to': [(-16,
                                                                                             15)],
                                                                          'type': 'INTEGER'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'NavModel-SBAS-ECEF': {'members': [{'name': 'sbasTo',
                                                                       'optional': True,
                                                                       'restricted-to': [(0,
                                                                                          5399)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasAccuracy',
                                                                       'size': [4],
                                                                       'type': 'BIT '
                                                                               'STRING'},
                                                                      {'name': 'sbasXg',
                                                                       'restricted-to': [(-536870912,
                                                                                          536870911)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasYg',
                                                                       'restricted-to': [(-536870912,
                                                                                          536870911)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasZg',
                                                                       'restricted-to': [(-16777216,
                                                                                          16777215)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasXgDot',
                                                                       'restricted-to': [(-65536,
                                                                                          65535)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasYgDot',
                                                                       'restricted-to': [(-65536,
                                                                                          65535)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasZgDot',
                                                                       'restricted-to': [(-131072,
                                                                                          131071)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasXgDotDot',
                                                                       'restricted-to': [(-512,
                                                                                          511)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbagYgDotDot',
                                                                       'restricted-to': [(-512,
                                                                                          511)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'sbasZgDotDot',
                                                                       'restricted-to': [(-512,
                                                                                          511)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'NavModelCNAV-KeplerianSet': {'members': [{'name': 'cnavTop',
                                                                              'restricted-to': [(0,
                                                                                                 2015)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavURAindex',
                                                                              'restricted-to': [(-16,
                                                                                                 15)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavDeltaA',
                                                                              'restricted-to': [(-33554432,
                                                                                                 33554431)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavAdot',
                                                                              'restricted-to': [(-16777216,
                                                                                                 16777215)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavDeltaNo',
                                                                              'restricted-to': [(-65536,
                                                                                                 65535)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavDeltaNoDot',
                                                                              'restricted-to': [(-4194304,
                                                                                                 4194303)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavMo',
                                                                              'restricted-to': [(-4294967296,
                                                                                                 4294967295)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavE',
                                                                              'restricted-to': [(0,
                                                                                                 8589934591)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavOmega',
                                                                              'restricted-to': [(-4294967296,
                                                                                                 4294967295)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavOMEGA0',
                                                                              'restricted-to': [(-4294967296,
                                                                                                 4294967295)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavDeltaOmegaDot',
                                                                              'restricted-to': [(-65536,
                                                                                                 65535)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavIo',
                                                                              'restricted-to': [(-4294967296,
                                                                                                 4294967295)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavIoDot',
                                                                              'restricted-to': [(-16384,
                                                                                                 16383)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavCis',
                                                                              'restricted-to': [(-32768,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavCic',
                                                                              'restricted-to': [(-32768,
                                                                                                 32767)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavCrs',
                                                                              'restricted-to': [(-8388608,
                                                                                                 8388607)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavCrc',
                                                                              'restricted-to': [(-8388608,
                                                                                                 8388607)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavCus',
                                                                              'restricted-to': [(-1048576,
                                                                                                 1048575)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'cnavCuc',
                                                                              'restricted-to': [(-1048576,
                                                                                                 1048575)],
                                                                              'type': 'INTEGER'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'NavModelKeplerianSet': {'members': [{'name': 'keplerToe',
                                                                         'restricted-to': [(0,
                                                                                            16383)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerW',
                                                                         'restricted-to': [(-2147483648,
                                                                                            2147483647)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerDeltaN',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerM0',
                                                                         'restricted-to': [(-2147483648,
                                                                                            2147483647)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerOmegaDot',
                                                                         'restricted-to': [(-8388608,
                                                                                            8388607)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerE',
                                                                         'restricted-to': [(0,
                                                                                            4294967295)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerIDot',
                                                                         'restricted-to': [(-8192,
                                                                                            8191)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerAPowerHalf',
                                                                         'restricted-to': [(0,
                                                                                            4294967295)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerI0',
                                                                         'restricted-to': [(-2147483648,
                                                                                            2147483647)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerOmega0',
                                                                         'restricted-to': [(-2147483648,
                                                                                            2147483647)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerCrs',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerCis',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerCus',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerCrc',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerCic',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        {'name': 'keplerCuc',
                                                                         'restricted-to': [(-32768,
                                                                                            32767)],
                                                                         'type': 'INTEGER'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                   'NavModelNAV-KeplerianSet': {'members': [{'name': 'navURA',
                                                                             'restricted-to': [(0,
                                                                                                15)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navFitFlag',
                                                                             'restricted-to': [(0,
                                                                                                1)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navToe',
                                                                             'restricted-to': [(0,
                                                                                                37799)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navOmega',
                                                                             'restricted-to': [(-2147483648,
                                                                                                2147483647)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navDeltaN',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navM0',
                                                                             'restricted-to': [(-2147483648,
                                                                                                2147483647)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navOmegaADot',
                                                                             'restricted-to': [(-8388608,
                                                                                                8388607)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navE',
                                                                             'restricted-to': [(0,
                                                                                                4294967295)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navIDot',
                                                                             'restricted-to': [(-8192,
                                                                                                8191)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navAPowerHalf',
                                                                             'restricted-to': [(0,
                                                                                                4294967295)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navI0',
                                                                             'restricted-to': [(-2147483648,
                                                                                                2147483647)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navOmegaA0',
                                                                             'restricted-to': [(-2147483648,
                                                                                                2147483647)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navCrs',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navCis',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navCus',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navCrc',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navCic',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'navCuc',
                                                                             'restricted-to': [(-32768,
                                                                                                32767)],
                                                                             'type': 'INTEGER'},
                                                                            {'members': [{'name': 'ephemCodeOnL2',
                                                                                          'restricted-to': [(0,
                                                                                                             3)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'ephemL2Pflag',
                                                                                          'restricted-to': [(0,
                                                                                                             1)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'members': [{'name': 'reserved1',
                                                                                                       'restricted-to': [(0,
                                                                                                                          8388607)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'reserved2',
                                                                                                       'restricted-to': [(0,
                                                                                                                          16777215)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'reserved3',
                                                                                                       'restricted-to': [(0,
                                                                                                                          16777215)],
                                                                                                       'type': 'INTEGER'},
                                                                                                      {'name': 'reserved4',
                                                                                                       'restricted-to': [(0,
                                                                                                                          65535)],
                                                                                                       'type': 'INTEGER'}],
                                                                                          'name': 'ephemSF1Rsvd',
                                                                                          'type': 'SEQUENCE'},
                                                                                         {'name': 'ephemAODA',
                                                                                          'restricted-to': [(0,
                                                                                                             31)],
                                                                                          'type': 'INTEGER'}],
                                                                             'name': 'addNAVparam',
                                                                             'optional': True,
                                                                             'type': 'SEQUENCE'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'NeQuickModelParameter': {'members': [{'name': 'ai0',
                                                                          'restricted-to': [(0,
                                                                                             2047)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ai1',
                                                                          'restricted-to': [(-1024,
                                                                                             1023)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ai2',
                                                                          'restricted-to': [(-8192,
                                                                                             8191)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ionoStormFlag1',
                                                                          'optional': True,
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ionoStormFlag2',
                                                                          'optional': True,
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ionoStormFlag3',
                                                                          'optional': True,
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ionoStormFlag4',
                                                                          'optional': True,
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         {'name': 'ionoStormFlag5',
                                                                          'optional': True,
                                                                          'restricted-to': [(0,
                                                                                             1)],
                                                                          'type': 'INTEGER'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                   'NeighbourMeasurementElement': {'members': [{'name': 'physCellIdNeighbour',
                                                                                'restricted-to': [(0,
                                                                                                   503)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'cellGlobalIdNeighbour',
                                                                                'optional': True,
                                                                                'type': 'ECGI'},
                                                                               {'name': 'earfcnNeighbour',
                                                                                'optional': True,
                                                                                'type': 'ARFCN-ValueEUTRA'},
                                                                               {'name': 'rstd',
                                                                                'restricted-to': [(0,
                                                                                                   12711)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'rstd-Quality',
                                                                                'type': 'OTDOA-MeasQuality'},
                                                                               None,
                                                                               [{'name': 'earfcnNeighbour-v9a0',
                                                                                 'optional': True,
                                                                                 'type': 'ARFCN-ValueEUTRA-v9a0'}],
                                                                               [{'name': 'tpIdNeighbour-r14',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(0,
                                                                                                    4095)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'prsIdNeighbour-r14',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(0,
                                                                                                    4095)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'delta-rstd-r14',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(0,
                                                                                                    5)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'additionalPathsNeighbour-r14',
                                                                                 'optional': True,
                                                                                 'type': 'AdditionalPathList-r14'},
                                                                                {'name': 'nprsIdNeighbour-r14',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(0,
                                                                                                    4095)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'carrierFreqOffsetNB-Neighbour-r14',
                                                                                 'optional': True,
                                                                                 'type': 'CarrierFreqOffsetNB-r14'}]],
                                                                   'type': 'SEQUENCE'},
                                   'NeighbourMeasurementElement-NB-r14': {'members': [{'name': 'physCellIdNeighbour-r14',
                                                                                       'restricted-to': [(0,
                                                                                                          503)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'cellGlobalIdNeighbour-r14',
                                                                                       'optional': True,
                                                                                       'type': 'ECGI'},
                                                                                      {'name': 'earfcnNeighbour-r14',
                                                                                       'optional': True,
                                                                                       'type': 'ARFCN-ValueEUTRA-r14'},
                                                                                      {'name': 'rstd-r14',
                                                                                       'restricted-to': [(0,
                                                                                                          12711)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'rstd-Quality-r14',
                                                                                       'type': 'OTDOA-MeasQuality'},
                                                                                      {'name': 'tpIdNeighbour-r14',
                                                                                       'optional': True,
                                                                                       'restricted-to': [(0,
                                                                                                          4095)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'prsIdNeighbour-r14',
                                                                                       'optional': True,
                                                                                       'restricted-to': [(0,
                                                                                                          4095)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'delta-rstd-r14',
                                                                                       'optional': True,
                                                                                       'restricted-to': [(0,
                                                                                                          5)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'additionalPathsNeighbour-r14',
                                                                                       'optional': True,
                                                                                       'type': 'AdditionalPathList-r14'},
                                                                                      {'name': 'nprsIdNeighbour-r14',
                                                                                       'optional': True,
                                                                                       'restricted-to': [(0,
                                                                                                          4095)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'carrierFreqOffsetNB-Neighbour-r14',
                                                                                       'optional': True,
                                                                                       'type': 'CarrierFreqOffsetNB-r14'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                   'NeighbourMeasurementList': {'element': {'type': 'NeighbourMeasurementElement'},
                                                                'size': [(1,
                                                                          24)],
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                                   'NeighbourMeasurementList-NB-r14': {'element': {'type': 'NeighbourMeasurementElement-NB-r14'},
                                                                       'size': [(1,
                                                                                 24)],
                                                                       'type': 'SEQUENCE '
                                                                               'OF'},
                                   'NetworkTime': {'members': [{'name': 'secondsFromFrameStructureStart',
                                                                'restricted-to': [(0,
                                                                                   12533)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'fractionalSecondsFromFrameStructureStart',
                                                                'restricted-to': [(0,
                                                                                   3999999)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'frameDrift',
                                                                'optional': True,
                                                                'restricted-to': [(-64,
                                                                                   63)],
                                                                'type': 'INTEGER'},
                                                               {'members': [{'members': [{'name': 'physCellId',
                                                                                          'restricted-to': [(0,
                                                                                                             503)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'cellGlobalIdEUTRA',
                                                                                          'optional': True,
                                                                                          'type': 'CellGlobalIdEUTRA-AndUTRA'},
                                                                                         {'name': 'earfcn',
                                                                                          'type': 'ARFCN-ValueEUTRA'},
                                                                                         None,
                                                                                         [{'name': 'earfcn-v9a0',
                                                                                           'optional': True,
                                                                                           'type': 'ARFCN-ValueEUTRA-v9a0'}]],
                                                                             'name': 'eUTRA',
                                                                             'type': 'SEQUENCE'},
                                                                            {'members': [{'members': [{'members': [{'name': 'primary-CPICH-Info',
                                                                                                                    'restricted-to': [(0,
                                                                                                                                       511)],
                                                                                                                    'type': 'INTEGER'},
                                                                                                                   None],
                                                                                                       'name': 'fdd',
                                                                                                       'type': 'SEQUENCE'},
                                                                                                      {'members': [{'name': 'cellParameters',
                                                                                                                    'restricted-to': [(0,
                                                                                                                                       127)],
                                                                                                                    'type': 'INTEGER'},
                                                                                                                   None],
                                                                                                       'name': 'tdd',
                                                                                                       'type': 'SEQUENCE'}],
                                                                                          'name': 'mode',
                                                                                          'type': 'CHOICE'},
                                                                                         {'name': 'cellGlobalIdUTRA',
                                                                                          'optional': True,
                                                                                          'type': 'CellGlobalIdEUTRA-AndUTRA'},
                                                                                         {'name': 'uarfcn',
                                                                                          'type': 'ARFCN-ValueUTRA'},
                                                                                         None],
                                                                             'name': 'uTRA',
                                                                             'type': 'SEQUENCE'},
                                                                            {'members': [{'name': 'bcchCarrier',
                                                                                          'restricted-to': [(0,
                                                                                                             1023)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'bsic',
                                                                                          'restricted-to': [(0,
                                                                                                             63)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'cellGlobalIdGERAN',
                                                                                          'optional': True,
                                                                                          'type': 'CellGlobalIdGERAN'},
                                                                                         None],
                                                                             'name': 'gSM',
                                                                             'type': 'SEQUENCE'},
                                                                            None,
                                                                            {'members': [{'name': 'nbPhysCellId-r14',
                                                                                          'restricted-to': [(0,
                                                                                                             503)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'nbCellGlobalId-r14',
                                                                                          'optional': True,
                                                                                          'type': 'ECGI'},
                                                                                         {'name': 'nbCarrierFreq-r14',
                                                                                          'type': 'CarrierFreq-NB-r14'},
                                                                                         None],
                                                                             'name': 'nBIoT-r14',
                                                                             'type': 'SEQUENCE'}],
                                                                'name': 'cellID',
                                                                'type': 'CHOICE'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                   'OTDOA-Error': {'members': [{'name': 'locationServerErrorCauses',
                                                                'type': 'OTDOA-LocationServerErrorCauses'},
                                                               {'name': 'targetDeviceErrorCauses',
                                                                'type': 'OTDOA-TargetDeviceErrorCauses'},
                                                               None],
                                                   'type': 'CHOICE'},
                                   'OTDOA-LocationServerErrorCauses': {'members': [{'name': 'cause',
                                                                                    'type': 'ENUMERATED',
                                                                                    'values': [('undefined',
                                                                                                0),
                                                                                               ('assistanceDataNotSupportedByServer',
                                                                                                1),
                                                                                               ('assistanceDataSupportedButCurrentlyNotAvailableByServer',
                                                                                                2),
                                                                                               None]},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'OTDOA-MeasQuality': {'members': [{'name': 'error-Resolution',
                                                                      'size': [2],
                                                                      'type': 'BIT '
                                                                              'STRING'},
                                                                     {'name': 'error-Value',
                                                                      'size': [5],
                                                                      'type': 'BIT '
                                                                              'STRING'},
                                                                     {'name': 'error-NumSamples',
                                                                      'optional': True,
                                                                      'size': [3],
                                                                      'type': 'BIT '
                                                                              'STRING'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'OTDOA-NeighbourCellInfoElement': {'members': [{'name': 'physCellId',
                                                                                   'restricted-to': [(0,
                                                                                                      503)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'cellGlobalId',
                                                                                   'optional': True,
                                                                                   'type': 'ECGI'},
                                                                                  {'name': 'earfcn',
                                                                                   'optional': True,
                                                                                   'type': 'ARFCN-ValueEUTRA'},
                                                                                  {'name': 'cpLength',
                                                                                   'optional': True,
                                                                                   'type': 'ENUMERATED',
                                                                                   'values': [('normal',
                                                                                               0),
                                                                                              ('extended',
                                                                                               1),
                                                                                              None]},
                                                                                  {'name': 'prsInfo',
                                                                                   'optional': True,
                                                                                   'type': 'PRS-Info'},
                                                                                  {'name': 'antennaPortConfig',
                                                                                   'optional': True,
                                                                                   'type': 'ENUMERATED',
                                                                                   'values': [('ports-1-or-2',
                                                                                               0),
                                                                                              ('ports-4',
                                                                                               1),
                                                                                              None]},
                                                                                  {'name': 'slotNumberOffset',
                                                                                   'optional': True,
                                                                                   'restricted-to': [(0,
                                                                                                      19)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'prs-SubframeOffset',
                                                                                   'optional': True,
                                                                                   'restricted-to': [(0,
                                                                                                      1279)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'expectedRSTD',
                                                                                   'restricted-to': [(0,
                                                                                                      16383)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'expectedRSTD-Uncertainty',
                                                                                   'restricted-to': [(0,
                                                                                                      1023)],
                                                                                   'type': 'INTEGER'},
                                                                                  None,
                                                                                  [{'name': 'earfcn-v9a0',
                                                                                    'optional': True,
                                                                                    'type': 'ARFCN-ValueEUTRA-v9a0'}],
                                                                                  [{'name': 'tpId-r14',
                                                                                    'optional': True,
                                                                                    'restricted-to': [(0,
                                                                                                       4095)],
                                                                                    'type': 'INTEGER'},
                                                                                   {'name': 'prs-only-tp-r14',
                                                                                    'optional': True,
                                                                                    'type': 'ENUMERATED',
                                                                                    'values': [('true',
                                                                                                0)]},
                                                                                   {'name': 'cpLengthCRS-r14',
                                                                                    'optional': True,
                                                                                    'type': 'ENUMERATED',
                                                                                    'values': [('normal',
                                                                                                0),
                                                                                               ('extended',
                                                                                                1),
                                                                                               None]},
                                                                                   {'name': 'sameMBSFNconfigNeighbour-r14',
                                                                                    'optional': True,
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'dlBandwidth-r14',
                                                                                    'optional': True,
                                                                                    'type': 'ENUMERATED',
                                                                                    'values': [('n6',
                                                                                                0),
                                                                                               ('n15',
                                                                                                1),
                                                                                               ('n25',
                                                                                                2),
                                                                                               ('n50',
                                                                                                3),
                                                                                               ('n75',
                                                                                                4),
                                                                                               ('n100',
                                                                                                5)]},
                                                                                   {'element': {'type': 'Add-PRSconfigNeighbourElement-r14'},
                                                                                    'name': 'addPRSconfigNeighbour-r14',
                                                                                    'optional': True,
                                                                                    'size': [(1,
                                                                                              'maxAddPRSconfig-r14')],
                                                                                    'type': 'SEQUENCE '
                                                                                            'OF'}]],
                                                                      'type': 'SEQUENCE'},
                                   'OTDOA-NeighbourCellInfoList': {'element': {'type': 'OTDOA-NeighbourFreqInfo'},
                                                                   'size': [(1,
                                                                             'maxFreqLayers')],
                                                                   'type': 'SEQUENCE '
                                                                           'OF'},
                                   'OTDOA-NeighbourCellInfoListNB-r14': {'element': {'type': 'OTDOA-NeighbourCellInfoNB-r14'},
                                                                         'size': [(1,
                                                                                   'maxCells-r14')],
                                                                         'type': 'SEQUENCE '
                                                                                 'OF'},
                                   'OTDOA-NeighbourCellInfoNB-r14': {'members': [{'name': 'physCellIdNB-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     503)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'cellGlobalIdNB-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ECGI'},
                                                                                 {'name': 'carrierFreq-r14',
                                                                                  'optional': True,
                                                                                  'type': 'CarrierFreq-NB-r14'},
                                                                                 {'name': 'earfcn-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ARFCN-ValueEUTRA-r14'},
                                                                                 {'name': 'eutra-NumCRS-Ports-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('ports-1-or-2',
                                                                                              0),
                                                                                             ('ports-4',
                                                                                              1),
                                                                                             None]},
                                                                                 {'name': 'otdoa-SIB1-NB-repetitions-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('r4',
                                                                                              0),
                                                                                             ('r8',
                                                                                              1),
                                                                                             ('r16',
                                                                                              2)]},
                                                                                 {'name': 'nprsInfo-r14',
                                                                                  'optional': True,
                                                                                  'type': 'PRS-Info-NB-r14'},
                                                                                 {'name': 'nprs-slotNumberOffset-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     19)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'nprs-SFN-Offset-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     63)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'nprs-SubframeOffset-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     1279)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'expectedRSTD-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     16383)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'expectedRSTD-Uncertainty-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     1023)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'prsNeighbourCellIndex-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(1,
                                                                                                     72)],
                                                                                  'type': 'INTEGER'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'OTDOA-NeighbourFreqInfo': {'element': {'type': 'OTDOA-NeighbourCellInfoElement'},
                                                               'size': [(1,
                                                                         24)],
                                                               'type': 'SEQUENCE '
                                                                       'OF'},
                                   'OTDOA-ProvideAssistanceData': {'members': [{'name': 'otdoa-ReferenceCellInfo',
                                                                                'optional': True,
                                                                                'type': 'OTDOA-ReferenceCellInfo'},
                                                                               {'name': 'otdoa-NeighbourCellInfo',
                                                                                'optional': True,
                                                                                'type': 'OTDOA-NeighbourCellInfoList'},
                                                                               {'name': 'otdoa-Error',
                                                                                'optional': True,
                                                                                'type': 'OTDOA-Error'},
                                                                               None,
                                                                               [{'name': 'otdoa-ReferenceCellInfoNB-r14',
                                                                                 'optional': True,
                                                                                 'type': 'OTDOA-ReferenceCellInfoNB-r14'},
                                                                                {'name': 'otdoa-NeighbourCellInfoNB-r14',
                                                                                 'optional': True,
                                                                                 'type': 'OTDOA-NeighbourCellInfoListNB-r14'}]],
                                                                   'type': 'SEQUENCE'},
                                   'OTDOA-ProvideCapabilities': {'members': [{'name': 'otdoa-Mode',
                                                                              'named-bits': [('ue-assisted',
                                                                                              '0'),
                                                                                             ('ue-assisted-NB-r14',
                                                                                              '1')],
                                                                              'size': [(1,
                                                                                        8)],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             None,
                                                                             {'element': {'type': 'SupportedBandEUTRA'},
                                                                              'name': 'supportedBandListEUTRA',
                                                                              'optional': True,
                                                                              'size': [(1,
                                                                                        'maxBands')],
                                                                              'type': 'SEQUENCE '
                                                                                      'OF'},
                                                                             {'element': {'type': 'SupportedBandEUTRA-v9a0'},
                                                                              'name': 'supportedBandListEUTRA-v9a0',
                                                                              'optional': True,
                                                                              'size': [(1,
                                                                                        'maxBands')],
                                                                              'type': 'SEQUENCE '
                                                                                      'OF'},
                                                                             {'name': 'interFreqRSTDmeasurement-r10',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'additionalNeighbourCellInfoList-r10',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'prs-id-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'tp-separation-via-muting-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'additional-prs-config-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'prs-based-tbs-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'additionalPathsReport-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'densePrsConfig-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'maxSupportedPrsBandwidth-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('n6',
                                                                                          0),
                                                                                         ('n15',
                                                                                          1),
                                                                                         ('n25',
                                                                                          2),
                                                                                         ('n50',
                                                                                          3),
                                                                                         ('n75',
                                                                                          4),
                                                                                         ('n100',
                                                                                          5),
                                                                                         None]},
                                                                             {'name': 'prsOccGroup-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'prsFrequencyHopping-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'maxSupportedPrsConfigs-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('c2',
                                                                                          0),
                                                                                         ('c3',
                                                                                          1)]},
                                                                             {'name': 'periodicalReporting-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'multiPrbNprs-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('supported',
                                                                                          0)]},
                                                                             {'name': 'idleStateForMeasurements-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('required',
                                                                                          0)]},
                                                                             {'name': 'numberOfRXantennas-r14',
                                                                              'optional': True,
                                                                              'type': 'ENUMERATED',
                                                                              'values': [('rx1',
                                                                                          0),
                                                                                         None]}],
                                                                 'type': 'SEQUENCE'},
                                   'OTDOA-ProvideLocationInformation': {'members': [{'name': 'otdoaSignalMeasurementInformation',
                                                                                     'optional': True,
                                                                                     'type': 'OTDOA-SignalMeasurementInformation'},
                                                                                    {'name': 'otdoa-Error',
                                                                                     'optional': True,
                                                                                     'type': 'OTDOA-Error'},
                                                                                    None,
                                                                                    [{'name': 'otdoaSignalMeasurementInformation-NB-r14',
                                                                                      'optional': True,
                                                                                      'type': 'OTDOA-SignalMeasurementInformation-NB-r14'}]],
                                                                        'type': 'SEQUENCE'},
                                   'OTDOA-ReferenceCellInfo': {'members': [{'name': 'physCellId',
                                                                            'restricted-to': [(0,
                                                                                               503)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'cellGlobalId',
                                                                            'optional': True,
                                                                            'type': 'ECGI'},
                                                                           {'name': 'earfcnRef',
                                                                            'optional': True,
                                                                            'type': 'ARFCN-ValueEUTRA'},
                                                                           {'name': 'antennaPortConfig',
                                                                            'optional': True,
                                                                            'type': 'ENUMERATED',
                                                                            'values': [('ports1-or-2',
                                                                                        0),
                                                                                       ('ports4',
                                                                                        1),
                                                                                       None]},
                                                                           {'name': 'cpLength',
                                                                            'type': 'ENUMERATED',
                                                                            'values': [('normal',
                                                                                        0),
                                                                                       ('extended',
                                                                                        1),
                                                                                       None]},
                                                                           {'name': 'prsInfo',
                                                                            'optional': True,
                                                                            'type': 'PRS-Info'},
                                                                           None,
                                                                           [{'name': 'earfcnRef-v9a0',
                                                                             'optional': True,
                                                                             'type': 'ARFCN-ValueEUTRA-v9a0'}],
                                                                           [{'name': 'tpId-r14',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                4095)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'cpLengthCRS-r14',
                                                                             'optional': True,
                                                                             'type': 'ENUMERATED',
                                                                             'values': [('normal',
                                                                                         0),
                                                                                        ('extended',
                                                                                         1),
                                                                                        None]},
                                                                            {'name': 'sameMBSFNconfigRef-r14',
                                                                             'optional': True,
                                                                             'type': 'BOOLEAN'},
                                                                            {'name': 'dlBandwidth-r14',
                                                                             'optional': True,
                                                                             'type': 'ENUMERATED',
                                                                             'values': [('n6',
                                                                                         0),
                                                                                        ('n15',
                                                                                         1),
                                                                                        ('n25',
                                                                                         2),
                                                                                        ('n50',
                                                                                         3),
                                                                                        ('n75',
                                                                                         4),
                                                                                        ('n100',
                                                                                         5)]},
                                                                            {'element': {'type': 'PRS-Info'},
                                                                             'name': 'addPRSconfigRef-r14',
                                                                             'optional': True,
                                                                             'size': [(1,
                                                                                       'maxAddPRSconfig-r14')],
                                                                             'type': 'SEQUENCE '
                                                                                     'OF'}]],
                                                               'type': 'SEQUENCE'},
                                   'OTDOA-ReferenceCellInfoNB-r14': {'members': [{'name': 'physCellIdNB-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(0,
                                                                                                     503)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'cellGlobalIdNB-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ECGI'},
                                                                                 {'name': 'carrierFreqRef-r14',
                                                                                  'optional': True,
                                                                                  'type': 'CarrierFreq-NB-r14'},
                                                                                 {'name': 'earfcn-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ARFCN-ValueEUTRA-r14'},
                                                                                 {'name': 'eutra-NumCRS-Ports-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('ports1-or-2',
                                                                                              0),
                                                                                             ('ports4',
                                                                                              1)]},
                                                                                 {'name': 'otdoa-SIB1-NB-repetitions-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('r4',
                                                                                              0),
                                                                                             ('r8',
                                                                                              1),
                                                                                             ('r16',
                                                                                              2)]},
                                                                                 {'name': 'nprsInfo-r14',
                                                                                  'optional': True,
                                                                                  'type': 'PRS-Info-NB-r14'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'OTDOA-RequestAssistanceData': {'members': [{'name': 'physCellId',
                                                                                'restricted-to': [(0,
                                                                                                   503)],
                                                                                'type': 'INTEGER'},
                                                                               None,
                                                                               [{'name': 'adType-r14',
                                                                                 'named-bits': [('prs',
                                                                                                 '0'),
                                                                                                ('nprs',
                                                                                                 '1')],
                                                                                 'optional': True,
                                                                                 'size': [(1,
                                                                                           8)],
                                                                                 'type': 'BIT '
                                                                                         'STRING'}]],
                                                                   'type': 'SEQUENCE'},
                                   'OTDOA-RequestCapabilities': {'members': [None],
                                                                 'type': 'SEQUENCE'},
                                   'OTDOA-RequestLocationInformation': {'members': [{'name': 'assistanceAvailability',
                                                                                     'type': 'BOOLEAN'},
                                                                                    None,
                                                                                    [{'name': 'multipathRSTD-r14',
                                                                                      'optional': True,
                                                                                      'type': 'ENUMERATED',
                                                                                      'values': [('requested',
                                                                                                  0)]},
                                                                                     {'name': 'maxNoOfRSTDmeas-r14',
                                                                                      'optional': True,
                                                                                      'restricted-to': [(1,
                                                                                                         32)],
                                                                                      'type': 'INTEGER'}]],
                                                                        'type': 'SEQUENCE'},
                                   'OTDOA-SignalMeasurementInformation': {'members': [{'name': 'systemFrameNumber',
                                                                                       'size': [10],
                                                                                       'type': 'BIT '
                                                                                               'STRING'},
                                                                                      {'name': 'physCellIdRef',
                                                                                       'restricted-to': [(0,
                                                                                                          503)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'cellGlobalIdRef',
                                                                                       'optional': True,
                                                                                       'type': 'ECGI'},
                                                                                      {'name': 'earfcnRef',
                                                                                       'optional': True,
                                                                                       'type': 'ARFCN-ValueEUTRA'},
                                                                                      {'name': 'referenceQuality',
                                                                                       'optional': True,
                                                                                       'type': 'OTDOA-MeasQuality'},
                                                                                      {'name': 'neighbourMeasurementList',
                                                                                       'type': 'NeighbourMeasurementList'},
                                                                                      None,
                                                                                      [{'name': 'earfcnRef-v9a0',
                                                                                        'optional': True,
                                                                                        'type': 'ARFCN-ValueEUTRA-v9a0'}],
                                                                                      [{'name': 'tpIdRef-r14',
                                                                                        'optional': True,
                                                                                        'restricted-to': [(0,
                                                                                                           4095)],
                                                                                        'type': 'INTEGER'},
                                                                                       {'name': 'prsIdRef-r14',
                                                                                        'optional': True,
                                                                                        'restricted-to': [(0,
                                                                                                           4095)],
                                                                                        'type': 'INTEGER'},
                                                                                       {'name': 'additionalPathsRef-r14',
                                                                                        'optional': True,
                                                                                        'type': 'AdditionalPathList-r14'},
                                                                                       {'name': 'nprsIdRef-r14',
                                                                                        'optional': True,
                                                                                        'restricted-to': [(0,
                                                                                                           4095)],
                                                                                        'type': 'INTEGER'},
                                                                                       {'name': 'carrierFreqOffsetNB-Ref-r14',
                                                                                        'optional': True,
                                                                                        'type': 'CarrierFreqOffsetNB-r14'},
                                                                                       {'name': 'hyperSFN-r14',
                                                                                        'optional': True,
                                                                                        'size': [10],
                                                                                        'type': 'BIT '
                                                                                                'STRING'}]],
                                                                          'type': 'SEQUENCE'},
                                   'OTDOA-SignalMeasurementInformation-NB-r14': {'members': [{'name': 'systemFrameNumber-r14',
                                                                                              'size': [10],
                                                                                              'type': 'BIT '
                                                                                                      'STRING'},
                                                                                             {'name': 'physCellIdRef-r14',
                                                                                              'restricted-to': [(0,
                                                                                                                 503)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'cellGlobalIdRef-r14',
                                                                                              'optional': True,
                                                                                              'type': 'ECGI'},
                                                                                             {'name': 'earfcnRef-r14',
                                                                                              'optional': True,
                                                                                              'type': 'ARFCN-ValueEUTRA-r14'},
                                                                                             {'name': 'referenceQuality-r14',
                                                                                              'optional': True,
                                                                                              'type': 'OTDOA-MeasQuality'},
                                                                                             {'name': 'neighbourMeasurementList-r14',
                                                                                              'type': 'NeighbourMeasurementList-NB-r14'},
                                                                                             {'name': 'tpIdRef-r14',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 4095)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'prsIdRef-r14',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 4095)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'additionalPathsRef-r14',
                                                                                              'optional': True,
                                                                                              'type': 'AdditionalPathList-r14'},
                                                                                             {'name': 'nprsIdRef-r14',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 4095)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'carrierFreqOffsetNB-Ref-r14',
                                                                                              'optional': True,
                                                                                              'type': 'CarrierFreqOffsetNB-r14'},
                                                                                             {'name': 'hyperSFN-r14',
                                                                                              'optional': True,
                                                                                              'size': [10],
                                                                                              'type': 'BIT '
                                                                                                      'STRING'},
                                                                                             None],
                                                                                 'type': 'SEQUENCE'},
                                   'OTDOA-TargetDeviceErrorCauses': {'members': [{'name': 'cause',
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('undefined',
                                                                                              0),
                                                                                             ('assistance-data-missing',
                                                                                              1),
                                                                                             ('unableToMeasureReferenceCell',
                                                                                              2),
                                                                                             ('unableToMeasureAnyNeighbourCell',
                                                                                              3),
                                                                                             ('attemptedButUnableToMeasureSomeNeighbourCells',
                                                                                              4),
                                                                                             None]},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'PRS-Info': {'members': [{'name': 'prs-Bandwidth',
                                                             'type': 'ENUMERATED',
                                                             'values': [('n6',
                                                                         0),
                                                                        ('n15',
                                                                         1),
                                                                        ('n25',
                                                                         2),
                                                                        ('n50',
                                                                         3),
                                                                        ('n75',
                                                                         4),
                                                                        ('n100',
                                                                         5),
                                                                        None]},
                                                            {'name': 'prs-ConfigurationIndex',
                                                             'restricted-to': [(0,
                                                                                4095)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'numDL-Frames',
                                                             'type': 'ENUMERATED',
                                                             'values': [('sf-1',
                                                                         0),
                                                                        ('sf-2',
                                                                         1),
                                                                        ('sf-4',
                                                                         2),
                                                                        ('sf-6',
                                                                         3),
                                                                        None,
                                                                        ('sf-add-v1420',
                                                                         4)]},
                                                            None,
                                                            {'members': [{'name': 'po2-r9',
                                                                          'size': [2],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po4-r9',
                                                                          'size': [4],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po8-r9',
                                                                          'size': [8],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po16-r9',
                                                                          'size': [16],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         None,
                                                                         {'name': 'po32-v1420',
                                                                          'size': [32],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po64-v1420',
                                                                          'size': [64],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po128-v1420',
                                                                          'size': [128],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po256-v1420',
                                                                          'size': [256],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po512-v1420',
                                                                          'size': [512],
                                                                          'type': 'BIT '
                                                                                  'STRING'},
                                                                         {'name': 'po1024-v1420',
                                                                          'size': [1024],
                                                                          'type': 'BIT '
                                                                                  'STRING'}],
                                                             'name': 'prs-MutingInfo-r9',
                                                             'optional': True,
                                                             'type': 'CHOICE'},
                                                            [{'name': 'prsID-r14',
                                                              'optional': True,
                                                              'restricted-to': [(0,
                                                                                 4095)],
                                                              'type': 'INTEGER'},
                                                             {'name': 'add-numDL-Frames-r14',
                                                              'optional': True,
                                                              'restricted-to': [(1,
                                                                                 160)],
                                                              'type': 'INTEGER'},
                                                             {'name': 'prsOccGroupLen-r14',
                                                              'optional': True,
                                                              'type': 'ENUMERATED',
                                                              'values': [('g2',
                                                                          0),
                                                                         ('g4',
                                                                          1),
                                                                         ('g8',
                                                                          2),
                                                                         ('g16',
                                                                          3),
                                                                         ('g32',
                                                                          4),
                                                                         ('g64',
                                                                          5),
                                                                         ('g128',
                                                                          6),
                                                                         None]},
                                                             {'members': [{'name': 'nb2-r14',
                                                                           'restricted-to': [(0,
                                                                                              'maxAvailNarrowBands-Minus1-r14')],
                                                                           'type': 'INTEGER'},
                                                                          {'element': {'restricted-to': [(1,
                                                                                                          'maxAvailNarrowBands-Minus1-r14')],
                                                                                       'type': 'INTEGER'},
                                                                           'name': 'nb4-r14',
                                                                           'size': [3],
                                                                           'type': 'SEQUENCE '
                                                                                   'OF'}],
                                                              'name': 'prsHoppingInfo-r14',
                                                              'optional': True,
                                                              'type': 'CHOICE'}]],
                                                'type': 'SEQUENCE'},
                                   'PRS-Info-NB-r14': {'element': {'type': 'NPRS-Info-r14'},
                                                       'size': [(1,
                                                                 'maxCarrier-r14')],
                                                       'type': 'SEQUENCE OF'},
                                   'PeriodicalReportingCriteria': {'members': [{'default': 'ra-Infinity',
                                                                                'name': 'reportingAmount',
                                                                                'type': 'ENUMERATED',
                                                                                'values': [('ra1',
                                                                                            0),
                                                                                           ('ra2',
                                                                                            1),
                                                                                           ('ra4',
                                                                                            2),
                                                                                           ('ra8',
                                                                                            3),
                                                                                           ('ra16',
                                                                                            4),
                                                                                           ('ra32',
                                                                                            5),
                                                                                           ('ra64',
                                                                                            6),
                                                                                           ('ra-Infinity',
                                                                                            7)]},
                                                                               {'name': 'reportingInterval',
                                                                                'type': 'ENUMERATED',
                                                                                'values': [('noPeriodicalReporting',
                                                                                            0),
                                                                                           ('ri0-25',
                                                                                            1),
                                                                                           ('ri0-5',
                                                                                            2),
                                                                                           ('ri1',
                                                                                            3),
                                                                                           ('ri2',
                                                                                            4),
                                                                                           ('ri4',
                                                                                            5),
                                                                                           ('ri8',
                                                                                            6),
                                                                                           ('ri16',
                                                                                            7),
                                                                                           ('ri32',
                                                                                            8),
                                                                                           ('ri64',
                                                                                            9)]}],
                                                                   'type': 'SEQUENCE'},
                                   'Polygon': {'element': {'type': 'PolygonPoints'},
                                               'size': [(3, 15)],
                                               'type': 'SEQUENCE OF'},
                                   'PolygonPoints': {'members': [{'name': 'latitudeSign',
                                                                  'type': 'ENUMERATED',
                                                                  'values': [('north',
                                                                              0),
                                                                             ('south',
                                                                              1)]},
                                                                 {'name': 'degreesLatitude',
                                                                  'restricted-to': [(0,
                                                                                     8388607)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'degreesLongitude',
                                                                  'restricted-to': [(-8388608,
                                                                                     8388607)],
                                                                  'type': 'INTEGER'}],
                                                     'type': 'SEQUENCE'},
                                   'PositioningModes': {'members': [{'name': 'posModes',
                                                                     'named-bits': [('standalone',
                                                                                     '0'),
                                                                                    ('ue-based',
                                                                                     '1'),
                                                                                    ('ue-assisted',
                                                                                     '2')],
                                                                     'size': [(1,
                                                                               8)],
                                                                     'type': 'BIT '
                                                                             'STRING'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                   'ProvideAssistanceData': {'members': [{'members': [{'members': [{'name': 'provideAssistanceData-r9',
                                                                                                    'type': 'ProvideAssistanceData-r9-IEs'},
                                                                                                   {'name': 'spare3',
                                                                                                    'type': 'NULL'},
                                                                                                   {'name': 'spare2',
                                                                                                    'type': 'NULL'},
                                                                                                   {'name': 'spare1',
                                                                                                    'type': 'NULL'}],
                                                                                       'name': 'c1',
                                                                                       'type': 'CHOICE'},
                                                                                      {'members': [],
                                                                                       'name': 'criticalExtensionsFuture',
                                                                                       'type': 'SEQUENCE'}],
                                                                          'name': 'criticalExtensions',
                                                                          'type': 'CHOICE'}],
                                                             'type': 'SEQUENCE'},
                                   'ProvideAssistanceData-r9-IEs': {'members': [{'name': 'commonIEsProvideAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'CommonIEsProvideAssistanceData'},
                                                                                {'name': 'a-gnss-ProvideAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'A-GNSS-ProvideAssistanceData'},
                                                                                {'name': 'otdoa-ProvideAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'OTDOA-ProvideAssistanceData'},
                                                                                {'name': 'epdu-Provide-Assistance-Data',
                                                                                 'optional': True,
                                                                                 'type': 'EPDU-Sequence'},
                                                                                None,
                                                                                [{'name': 'sensor-ProvideAssistanceData-r14',
                                                                                  'optional': True,
                                                                                  'type': 'Sensor-ProvideAssistanceData-r14'},
                                                                                 {'name': 'tbs-ProvideAssistanceData-r14',
                                                                                  'optional': True,
                                                                                  'type': 'TBS-ProvideAssistanceData-r14'},
                                                                                 {'name': 'wlan-ProvideAssistanceData-r14',
                                                                                  'optional': True,
                                                                                  'type': 'WLAN-ProvideAssistanceData-r14'}]],
                                                                    'type': 'SEQUENCE'},
                                   'ProvideCapabilities': {'members': [{'members': [{'members': [{'name': 'provideCapabilities-r9',
                                                                                                  'type': 'ProvideCapabilities-r9-IEs'},
                                                                                                 {'name': 'spare3',
                                                                                                  'type': 'NULL'},
                                                                                                 {'name': 'spare2',
                                                                                                  'type': 'NULL'},
                                                                                                 {'name': 'spare1',
                                                                                                  'type': 'NULL'}],
                                                                                     'name': 'c1',
                                                                                     'type': 'CHOICE'},
                                                                                    {'members': [],
                                                                                     'name': 'criticalExtensionsFuture',
                                                                                     'type': 'SEQUENCE'}],
                                                                        'name': 'criticalExtensions',
                                                                        'type': 'CHOICE'}],
                                                           'type': 'SEQUENCE'},
                                   'ProvideCapabilities-r9-IEs': {'members': [{'name': 'commonIEsProvideCapabilities',
                                                                               'optional': True,
                                                                               'type': 'CommonIEsProvideCapabilities'},
                                                                              {'name': 'a-gnss-ProvideCapabilities',
                                                                               'optional': True,
                                                                               'type': 'A-GNSS-ProvideCapabilities'},
                                                                              {'name': 'otdoa-ProvideCapabilities',
                                                                               'optional': True,
                                                                               'type': 'OTDOA-ProvideCapabilities'},
                                                                              {'name': 'ecid-ProvideCapabilities',
                                                                               'optional': True,
                                                                               'type': 'ECID-ProvideCapabilities'},
                                                                              {'name': 'epdu-ProvideCapabilities',
                                                                               'optional': True,
                                                                               'type': 'EPDU-Sequence'},
                                                                              None,
                                                                              [{'name': 'sensor-ProvideCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'Sensor-ProvideCapabilities-r13'},
                                                                               {'name': 'tbs-ProvideCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'TBS-ProvideCapabilities-r13'},
                                                                               {'name': 'wlan-ProvideCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'WLAN-ProvideCapabilities-r13'},
                                                                               {'name': 'bt-ProvideCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'BT-ProvideCapabilities-r13'}]],
                                                                  'type': 'SEQUENCE'},
                                   'ProvideLocationInformation': {'members': [{'members': [{'members': [{'name': 'provideLocationInformation-r9',
                                                                                                         'type': 'ProvideLocationInformation-r9-IEs'},
                                                                                                        {'name': 'spare3',
                                                                                                         'type': 'NULL'},
                                                                                                        {'name': 'spare2',
                                                                                                         'type': 'NULL'},
                                                                                                        {'name': 'spare1',
                                                                                                         'type': 'NULL'}],
                                                                                            'name': 'c1',
                                                                                            'type': 'CHOICE'},
                                                                                           {'members': [],
                                                                                            'name': 'criticalExtensionsFuture',
                                                                                            'type': 'SEQUENCE'}],
                                                                               'name': 'criticalExtensions',
                                                                               'type': 'CHOICE'}],
                                                                  'type': 'SEQUENCE'},
                                   'ProvideLocationInformation-r9-IEs': {'members': [{'name': 'commonIEsProvideLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'CommonIEsProvideLocationInformation'},
                                                                                     {'name': 'a-gnss-ProvideLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'A-GNSS-ProvideLocationInformation'},
                                                                                     {'name': 'otdoa-ProvideLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'OTDOA-ProvideLocationInformation'},
                                                                                     {'name': 'ecid-ProvideLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'ECID-ProvideLocationInformation'},
                                                                                     {'name': 'epdu-ProvideLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'EPDU-Sequence'},
                                                                                     None,
                                                                                     [{'name': 'sensor-ProvideLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'Sensor-ProvideLocationInformation-r13'},
                                                                                      {'name': 'tbs-ProvideLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'TBS-ProvideLocationInformation-r13'},
                                                                                      {'name': 'wlan-ProvideLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'WLAN-ProvideLocationInformation-r13'},
                                                                                      {'name': 'bt-ProvideLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'BT-ProvideLocationInformation-r13'}]],
                                                                         'type': 'SEQUENCE'},
                                   'QoS': {'members': [{'name': 'horizontalAccuracy',
                                                        'optional': True,
                                                        'type': 'HorizontalAccuracy'},
                                                       {'name': 'verticalCoordinateRequest',
                                                        'type': 'BOOLEAN'},
                                                       {'name': 'verticalAccuracy',
                                                        'optional': True,
                                                        'type': 'VerticalAccuracy'},
                                                       {'name': 'responseTime',
                                                        'optional': True,
                                                        'type': 'ResponseTime'},
                                                       {'name': 'velocityRequest',
                                                        'type': 'BOOLEAN'},
                                                       None,
                                                       [{'name': 'responseTimeNB-r14',
                                                         'optional': True,
                                                         'type': 'ResponseTimeNB-r14'}]],
                                           'type': 'SEQUENCE'},
                                   'ReportingDuration': {'restricted-to': [(0,
                                                                            255)],
                                                         'type': 'INTEGER'},
                                   'ReqNavListInfo': {'members': [{'name': 'svReqList',
                                                                   'size': [64],
                                                                   'type': 'BIT '
                                                                           'STRING'},
                                                                  {'element': {'restricted-to': [(1,
                                                                                                  8)],
                                                                               'type': 'INTEGER'},
                                                                   'name': 'clockModelID-PrefList',
                                                                   'optional': True,
                                                                   'size': [(1,
                                                                             8)],
                                                                   'type': 'SEQUENCE '
                                                                           'OF'},
                                                                  {'element': {'restricted-to': [(1,
                                                                                                  8)],
                                                                               'type': 'INTEGER'},
                                                                   'name': 'orbitModelID-PrefList',
                                                                   'optional': True,
                                                                   'size': [(1,
                                                                             8)],
                                                                   'type': 'SEQUENCE '
                                                                           'OF'},
                                                                  {'name': 'addNavparamReq',
                                                                   'optional': True,
                                                                   'type': 'BOOLEAN'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                   'RequestAssistanceData': {'members': [{'members': [{'members': [{'name': 'requestAssistanceData-r9',
                                                                                                    'type': 'RequestAssistanceData-r9-IEs'},
                                                                                                   {'name': 'spare3',
                                                                                                    'type': 'NULL'},
                                                                                                   {'name': 'spare2',
                                                                                                    'type': 'NULL'},
                                                                                                   {'name': 'spare1',
                                                                                                    'type': 'NULL'}],
                                                                                       'name': 'c1',
                                                                                       'type': 'CHOICE'},
                                                                                      {'members': [],
                                                                                       'name': 'criticalExtensionsFuture',
                                                                                       'type': 'SEQUENCE'}],
                                                                          'name': 'criticalExtensions',
                                                                          'type': 'CHOICE'}],
                                                             'type': 'SEQUENCE'},
                                   'RequestAssistanceData-r9-IEs': {'members': [{'name': 'commonIEsRequestAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'CommonIEsRequestAssistanceData'},
                                                                                {'name': 'a-gnss-RequestAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'A-GNSS-RequestAssistanceData'},
                                                                                {'name': 'otdoa-RequestAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'OTDOA-RequestAssistanceData'},
                                                                                {'name': 'epdu-RequestAssistanceData',
                                                                                 'optional': True,
                                                                                 'type': 'EPDU-Sequence'},
                                                                                None,
                                                                                [{'name': 'sensor-RequestAssistanceData-r14',
                                                                                  'optional': True,
                                                                                  'type': 'Sensor-RequestAssistanceData-r14'},
                                                                                 {'name': 'tbs-RequestAssistanceData-r14',
                                                                                  'optional': True,
                                                                                  'type': 'TBS-RequestAssistanceData-r14'},
                                                                                 {'name': 'wlan-RequestAssistanceData-r14',
                                                                                  'optional': True,
                                                                                  'type': 'WLAN-RequestAssistanceData-r14'}]],
                                                                    'type': 'SEQUENCE'},
                                   'RequestCapabilities': {'members': [{'members': [{'members': [{'name': 'requestCapabilities-r9',
                                                                                                  'type': 'RequestCapabilities-r9-IEs'},
                                                                                                 {'name': 'spare3',
                                                                                                  'type': 'NULL'},
                                                                                                 {'name': 'spare2',
                                                                                                  'type': 'NULL'},
                                                                                                 {'name': 'spare1',
                                                                                                  'type': 'NULL'}],
                                                                                     'name': 'c1',
                                                                                     'type': 'CHOICE'},
                                                                                    {'members': [],
                                                                                     'name': 'criticalExtensionsFuture',
                                                                                     'type': 'SEQUENCE'}],
                                                                        'name': 'criticalExtensions',
                                                                        'type': 'CHOICE'}],
                                                           'type': 'SEQUENCE'},
                                   'RequestCapabilities-r9-IEs': {'members': [{'name': 'commonIEsRequestCapabilities',
                                                                               'optional': True,
                                                                               'type': 'CommonIEsRequestCapabilities'},
                                                                              {'name': 'a-gnss-RequestCapabilities',
                                                                               'optional': True,
                                                                               'type': 'A-GNSS-RequestCapabilities'},
                                                                              {'name': 'otdoa-RequestCapabilities',
                                                                               'optional': True,
                                                                               'type': 'OTDOA-RequestCapabilities'},
                                                                              {'name': 'ecid-RequestCapabilities',
                                                                               'optional': True,
                                                                               'type': 'ECID-RequestCapabilities'},
                                                                              {'name': 'epdu-RequestCapabilities',
                                                                               'optional': True,
                                                                               'type': 'EPDU-Sequence'},
                                                                              None,
                                                                              [{'name': 'sensor-RequestCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'Sensor-RequestCapabilities-r13'},
                                                                               {'name': 'tbs-RequestCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'TBS-RequestCapabilities-r13'},
                                                                               {'name': 'wlan-RequestCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'WLAN-RequestCapabilities-r13'},
                                                                               {'name': 'bt-RequestCapabilities-r13',
                                                                                'optional': True,
                                                                                'type': 'BT-RequestCapabilities-r13'}]],
                                                                  'type': 'SEQUENCE'},
                                   'RequestLocationInformation': {'members': [{'members': [{'members': [{'name': 'requestLocationInformation-r9',
                                                                                                         'type': 'RequestLocationInformation-r9-IEs'},
                                                                                                        {'name': 'spare3',
                                                                                                         'type': 'NULL'},
                                                                                                        {'name': 'spare2',
                                                                                                         'type': 'NULL'},
                                                                                                        {'name': 'spare1',
                                                                                                         'type': 'NULL'}],
                                                                                            'name': 'c1',
                                                                                            'type': 'CHOICE'},
                                                                                           {'members': [],
                                                                                            'name': 'criticalExtensionsFuture',
                                                                                            'type': 'SEQUENCE'}],
                                                                               'name': 'criticalExtensions',
                                                                               'type': 'CHOICE'}],
                                                                  'type': 'SEQUENCE'},
                                   'RequestLocationInformation-r9-IEs': {'members': [{'name': 'commonIEsRequestLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'CommonIEsRequestLocationInformation'},
                                                                                     {'name': 'a-gnss-RequestLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'A-GNSS-RequestLocationInformation'},
                                                                                     {'name': 'otdoa-RequestLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'OTDOA-RequestLocationInformation'},
                                                                                     {'name': 'ecid-RequestLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'ECID-RequestLocationInformation'},
                                                                                     {'name': 'epdu-RequestLocationInformation',
                                                                                      'optional': True,
                                                                                      'type': 'EPDU-Sequence'},
                                                                                     None,
                                                                                     [{'name': 'sensor-RequestLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'Sensor-RequestLocationInformation-r13'},
                                                                                      {'name': 'tbs-RequestLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'TBS-RequestLocationInformation-r13'},
                                                                                      {'name': 'wlan-RequestLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'WLAN-RequestLocationInformation-r13'},
                                                                                      {'name': 'bt-RequestLocationInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'BT-RequestLocationInformation-r13'}]],
                                                                         'type': 'SEQUENCE'},
                                   'ResponseTime': {'members': [{'name': 'time',
                                                                 'restricted-to': [(1,
                                                                                    128)],
                                                                 'type': 'INTEGER'},
                                                                None,
                                                                [{'name': 'responseTimeEarlyFix-r12',
                                                                  'optional': True,
                                                                  'restricted-to': [(1,
                                                                                     128)],
                                                                  'type': 'INTEGER'}]],
                                                    'type': 'SEQUENCE'},
                                   'ResponseTimeNB-r14': {'members': [{'name': 'timeNB-r14',
                                                                       'restricted-to': [(1,
                                                                                          512)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'responseTimeEarlyFixNB-r14',
                                                                       'optional': True,
                                                                       'restricted-to': [(1,
                                                                                          512)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'SBAS-ClockModel': {'members': [{'name': 'sbasTo',
                                                                    'restricted-to': [(0,
                                                                                       5399)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'sbasAgfo',
                                                                    'restricted-to': [(-2048,
                                                                                       2047)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'sbasAgf1',
                                                                    'restricted-to': [(-128,
                                                                                       127)],
                                                                    'type': 'INTEGER'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                   'SBAS-ID': {'members': [{'name': 'sbas-id',
                                                            'type': 'ENUMERATED',
                                                            'values': [('waas',
                                                                        0),
                                                                       ('egnos',
                                                                        1),
                                                                       ('msas',
                                                                        2),
                                                                       ('gagan',
                                                                        3),
                                                                       None]},
                                                           None],
                                               'type': 'SEQUENCE'},
                                   'SBAS-IDs': {'members': [{'name': 'sbas-IDs',
                                                             'named-bits': [('waas',
                                                                             '0'),
                                                                            ('egnos',
                                                                             '1'),
                                                                            ('msas',
                                                                             '2'),
                                                                            ('gagan',
                                                                             '3')],
                                                             'size': [(1, 8)],
                                                             'type': 'BIT '
                                                                     'STRING'},
                                                            None],
                                                'type': 'SEQUENCE'},
                                   'SV-ID': {'members': [{'name': 'satellite-id',
                                                          'restricted-to': [(0,
                                                                             63)],
                                                          'type': 'INTEGER'},
                                                         None],
                                             'type': 'SEQUENCE'},
                                   'SatListRelatedDataElement': {'members': [{'name': 'svID',
                                                                              'type': 'SV-ID'},
                                                                             {'name': 'iod',
                                                                              'size': [11],
                                                                              'type': 'BIT '
                                                                                      'STRING'},
                                                                             {'name': 'clockModelID',
                                                                              'optional': True,
                                                                              'restricted-to': [(1,
                                                                                                 8)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'orbitModelID',
                                                                              'optional': True,
                                                                              'restricted-to': [(1,
                                                                                                 8)],
                                                                              'type': 'INTEGER'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'SatListRelatedDataList': {'element': {'type': 'SatListRelatedDataElement'},
                                                              'size': [(1, 64)],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                   'Sensor-AssistanceDataList-r14': {'members': [{'name': 'refPressure-r14',
                                                                                  'restricted-to': [(-20000,
                                                                                                     10000)],
                                                                                  'type': 'INTEGER'},
                                                                                 {'name': 'refPosition-r14',
                                                                                  'optional': True,
                                                                                  'type': 'EllipsoidPointWithAltitudeAndUncertaintyEllipsoid'},
                                                                                 {'name': 'refTemperature-r14',
                                                                                  'optional': True,
                                                                                  'restricted-to': [(-64,
                                                                                                     63)],
                                                                                  'type': 'INTEGER'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'Sensor-AssistanceDataSupportList-r14': {'members': [None],
                                                                            'type': 'SEQUENCE'},
                                   'Sensor-Error-r13': {'members': [{'name': 'locationServerErrorCauses-r13',
                                                                     'type': 'Sensor-LocationServerErrorCauses-r13'},
                                                                    {'name': 'targetDeviceErrorCauses-r13',
                                                                     'type': 'Sensor-TargetDeviceErrorCauses-r13'},
                                                                    None],
                                                        'type': 'CHOICE'},
                                   'Sensor-LocationServerErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                         'type': 'ENUMERATED',
                                                                                         'values': [('undefined',
                                                                                                     0),
                                                                                                    None,
                                                                                                    ('assistanceDataNotSupportedByServer-v1420',
                                                                                                     1),
                                                                                                    ('assistanceDataSupportedButCurrentlyNotAvailableByServer-v1420',
                                                                                                     2)]},
                                                                                        None],
                                                                            'type': 'SEQUENCE'},
                                   'Sensor-MeasurementInformation-r13': {'members': [{'name': 'measurementReferenceTime-r13',
                                                                                      'optional': True,
                                                                                      'type': 'UTCTime'},
                                                                                     {'name': 'uncompensatedBarometricPressure-r13',
                                                                                      'optional': True,
                                                                                      'restricted-to': [(30000,
                                                                                                         115000)],
                                                                                      'type': 'INTEGER'},
                                                                                     None,
                                                                                     [{'members': [{'name': 'range-r14',
                                                                                                    'restricted-to': [(0,
                                                                                                                       1000)],
                                                                                                    'type': 'INTEGER'},
                                                                                                   {'name': 'confidence-r14',
                                                                                                    'restricted-to': [(1,
                                                                                                                       100)],
                                                                                                    'type': 'INTEGER'}],
                                                                                       'name': 'uncertainty-r14',
                                                                                       'optional': True,
                                                                                       'type': 'SEQUENCE'}]],
                                                                         'type': 'SEQUENCE'},
                                   'Sensor-ProvideAssistanceData-r14': {'members': [{'name': 'sensor-AssistanceDataList-r14',
                                                                                     'optional': True,
                                                                                     'type': 'Sensor-AssistanceDataList-r14'},
                                                                                    {'name': 'sensor-Error-r14',
                                                                                     'optional': True,
                                                                                     'type': 'Sensor-Error-r13'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                   'Sensor-ProvideCapabilities-r13': {'members': [{'name': 'sensor-Modes-r13',
                                                                                   'named-bits': [('standalone',
                                                                                                   '0'),
                                                                                                  ('ue-assisted',
                                                                                                   '1'),
                                                                                                  ('ue-based',
                                                                                                   '2')],
                                                                                   'size': [(1,
                                                                                             8)],
                                                                                   'type': 'BIT '
                                                                                           'STRING'},
                                                                                  None,
                                                                                  [{'name': 'sensor-AssistanceDataSupportList-r14',
                                                                                    'optional': True,
                                                                                    'type': 'Sensor-AssistanceDataSupportList-r14'},
                                                                                   {'name': 'periodicalReportingSupported-r14',
                                                                                    'optional': True,
                                                                                    'type': 'PositioningModes'},
                                                                                   {'name': 'idleStateForMeasurements-r14',
                                                                                    'optional': True,
                                                                                    'type': 'ENUMERATED',
                                                                                    'values': [('required',
                                                                                                0)]}]],
                                                                      'type': 'SEQUENCE'},
                                   'Sensor-ProvideLocationInformation-r13': {'members': [{'name': 'sensor-MeasurementInformation-r13',
                                                                                          'optional': True,
                                                                                          'type': 'Sensor-MeasurementInformation-r13'},
                                                                                         {'name': 'sensor-Error-r13',
                                                                                          'optional': True,
                                                                                          'type': 'Sensor-Error-r13'},
                                                                                         None],
                                                                             'type': 'SEQUENCE'},
                                   'Sensor-RequestAssistanceData-r14': {'members': [None],
                                                                        'type': 'SEQUENCE'},
                                   'Sensor-RequestCapabilities-r13': {'members': [None],
                                                                      'type': 'SEQUENCE'},
                                   'Sensor-RequestLocationInformation-r13': {'members': [{'name': 'uncompensatedBarometricPressureReq-r13',
                                                                                          'type': 'BOOLEAN'},
                                                                                         None,
                                                                                         [{'name': 'assistanceAvailability-r14',
                                                                                           'optional': True,
                                                                                           'type': 'BOOLEAN'}]],
                                                                             'type': 'SEQUENCE'},
                                   'Sensor-TargetDeviceErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                       'type': 'ENUMERATED',
                                                                                       'values': [('undefined',
                                                                                                   0),
                                                                                                  None,
                                                                                                  ('assistanceDataMissing-v1420',
                                                                                                   1)]},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                   'SequenceNumber': {'restricted-to': [(0,
                                                                         255)],
                                                      'type': 'INTEGER'},
                                   'StandardClockModelElement': {'members': [{'name': 'stanClockToc',
                                                                              'restricted-to': [(0,
                                                                                                 16383)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'stanClockAF2',
                                                                              'restricted-to': [(-32,
                                                                                                 31)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'stanClockAF1',
                                                                              'restricted-to': [(-1048576,
                                                                                                 1048575)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'stanClockAF0',
                                                                              'restricted-to': [(-1073741824,
                                                                                                 1073741823)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'stanClockTgd',
                                                                              'optional': True,
                                                                              'restricted-to': [(-512,
                                                                                                 511)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'sisa',
                                                                              'restricted-to': [(0,
                                                                                                 255)],
                                                                              'type': 'INTEGER'},
                                                                             {'name': 'stanModelID',
                                                                              'optional': True,
                                                                              'restricted-to': [(0,
                                                                                                 1)],
                                                                              'type': 'INTEGER'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                   'StandardClockModelList': {'element': {'type': 'StandardClockModelElement'},
                                                              'size': [(1, 2)],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                   'StoredNavListInfo': {'members': [{'name': 'gnss-WeekOrDay',
                                                                      'restricted-to': [(0,
                                                                                         4095)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'gnss-Toe',
                                                                      'restricted-to': [(0,
                                                                                         255)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 't-toeLimit',
                                                                      'restricted-to': [(0,
                                                                                         15)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'satListRelatedDataList',
                                                                      'optional': True,
                                                                      'type': 'SatListRelatedDataList'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'SupportedBandEUTRA': {'members': [{'name': 'bandEUTRA',
                                                                       'restricted-to': [(1,
                                                                                          'maxFBI')],
                                                                       'type': 'INTEGER'}],
                                                          'type': 'SEQUENCE'},
                                   'SupportedBandEUTRA-v9a0': {'members': [{'name': 'bandEUTRA-v9a0',
                                                                            'optional': True,
                                                                            'restricted-to': [('maxFBI-Plus1',
                                                                                               'maxFBI2')],
                                                                            'type': 'INTEGER'}],
                                                               'type': 'SEQUENCE'},
                                   'SupportedChannels-11a-r14': {'members': [{'name': 'ch34-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch36-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch38-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch40-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch42-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch44-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch46-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch48-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch52-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch56-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch60-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch64-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch149-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch153-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch157-r14',
                                                                              'type': 'BOOLEAN'},
                                                                             {'name': 'ch161-r14',
                                                                              'type': 'BOOLEAN'}],
                                                                 'type': 'SEQUENCE'},
                                   'SupportedChannels-11bg-r14': {'members': [{'name': 'ch1-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch2-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch3-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch4-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch5-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch6-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch7-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch8-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch9-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch10-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch11-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch12-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch13-r14',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch14-r14',
                                                                               'type': 'BOOLEAN'}],
                                                                  'type': 'SEQUENCE'},
                                   'TBS-AssistanceDataList-r14': {'members': [{'name': 'mbs-AssistanceDataList-r14',
                                                                               'optional': True,
                                                                               'type': 'MBS-AssistanceDataList-r14'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'TBS-Error-r13': {'members': [{'name': 'locationServerErrorCauses-r13',
                                                                  'type': 'TBS-LocationServerErrorCauses-r13'},
                                                                 {'name': 'targetDeviceErrorCauses-r13',
                                                                  'type': 'TBS-TargetDeviceErrorCauses-r13'},
                                                                 None],
                                                     'type': 'CHOICE'},
                                   'TBS-LocationServerErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                      'type': 'ENUMERATED',
                                                                                      'values': [('undefined',
                                                                                                  0),
                                                                                                 None,
                                                                                                 ('assistanceDataNotSupportedByServer-v1420',
                                                                                                  1),
                                                                                                 ('assistanceDataSupportedButCurrentlyNotAvailableByServer-v1420',
                                                                                                  2)]},
                                                                                     None],
                                                                         'type': 'SEQUENCE'},
                                   'TBS-MeasurementInformation-r13': {'members': [{'name': 'measurementReferenceTime-r13',
                                                                                   'optional': True,
                                                                                   'type': 'UTCTime'},
                                                                                  {'name': 'mbs-SgnMeasList-r13',
                                                                                   'optional': True,
                                                                                   'type': 'MBS-BeaconMeasList-r13'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'TBS-ProvideAssistanceData-r14': {'members': [{'name': 'tbs-AssistanceDataList-r14',
                                                                                  'optional': True,
                                                                                  'type': 'TBS-AssistanceDataList-r14'},
                                                                                 {'name': 'tbs-Error-r14',
                                                                                  'optional': True,
                                                                                  'type': 'TBS-Error-r13'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'TBS-ProvideCapabilities-r13': {'members': [{'name': 'tbs-Modes-r13',
                                                                                'named-bits': [('standalone',
                                                                                                '0'),
                                                                                               ('ue-assisted',
                                                                                                '1'),
                                                                                               ('ue-based',
                                                                                                '2')],
                                                                                'size': [(1,
                                                                                          8)],
                                                                                'type': 'BIT '
                                                                                        'STRING'},
                                                                               None,
                                                                               [{'name': 'mbs-AssistanceDataSupportList-r14',
                                                                                 'optional': True,
                                                                                 'type': 'MBS-AssistanceDataSupportList-r14'},
                                                                                {'name': 'periodicalReportingSupported-r14',
                                                                                 'optional': True,
                                                                                 'type': 'PositioningModes'},
                                                                                {'name': 'mbs-ConfigSupport-r14',
                                                                                 'named-bits': [('tb1',
                                                                                                 '0'),
                                                                                                ('tb2',
                                                                                                 '1'),
                                                                                                ('tb3',
                                                                                                 '2'),
                                                                                                ('tb4',
                                                                                                 '3')],
                                                                                 'optional': True,
                                                                                 'size': [(1,
                                                                                           8)],
                                                                                 'type': 'BIT '
                                                                                         'STRING'},
                                                                                {'name': 'mbs-IdleStateForMeasurements-r14',
                                                                                 'optional': True,
                                                                                 'type': 'ENUMERATED',
                                                                                 'values': [('required',
                                                                                             0)]}]],
                                                                   'type': 'SEQUENCE'},
                                   'TBS-ProvideLocationInformation-r13': {'members': [{'name': 'tbs-MeasurementInformation-r13',
                                                                                       'optional': True,
                                                                                       'type': 'TBS-MeasurementInformation-r13'},
                                                                                      {'name': 'tbs-Error-r13',
                                                                                       'optional': True,
                                                                                       'type': 'TBS-Error-r13'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                   'TBS-RequestAssistanceData-r14': {'members': [{'name': 'mbs-AlmanacAssistanceDataReq-r14',
                                                                                  'type': 'BOOLEAN'},
                                                                                 {'name': 'mbs-AcquisitionAssistanceDataReq-r14',
                                                                                  'type': 'BOOLEAN'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                   'TBS-RequestCapabilities-r13': {'members': [None],
                                                                   'type': 'SEQUENCE'},
                                   'TBS-RequestLocationInformation-r13': {'members': [{'name': 'mbsSgnMeasListReq-r13',
                                                                                       'type': 'BOOLEAN'},
                                                                                      None,
                                                                                      [{'name': 'mbsAssistanceAvailability-r14',
                                                                                        'optional': True,
                                                                                        'type': 'BOOLEAN'},
                                                                                       {'name': 'mbsRequestedMeasurements-r14',
                                                                                        'named-bits': [('rssi',
                                                                                                        '0')],
                                                                                        'optional': True,
                                                                                        'size': [(1,
                                                                                                  8)],
                                                                                        'type': 'BIT '
                                                                                                'STRING'}]],
                                                                          'type': 'SEQUENCE'},
                                   'TBS-TargetDeviceErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                    'type': 'ENUMERATED',
                                                                                    'values': [('undefined',
                                                                                                0),
                                                                                               ('thereWereNotEnoughMBSBeaconsReceived',
                                                                                                1),
                                                                                               None,
                                                                                               ('assistanceDataMissing-v1420',
                                                                                                2)]},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'TransactionNumber': {'restricted-to': [(0,
                                                                            255)],
                                                         'type': 'INTEGER'},
                                   'TriggeredReportingCriteria': {'members': [{'name': 'cellChange',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'reportingDuration',
                                                                               'type': 'ReportingDuration'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                   'UTC-ModelSet1': {'members': [{'name': 'gnss-Utc-A1',
                                                                  'restricted-to': [(-8388608,
                                                                                     8388607)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-A0',
                                                                  'restricted-to': [(-2147483648,
                                                                                     2147483647)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-Tot',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-WNt',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-DeltaTls',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-WNlsf',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-DN',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'gnss-Utc-DeltaTlsf',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'UTC-ModelSet2': {'members': [{'name': 'utcA0',
                                                                  'restricted-to': [(-32768,
                                                                                     32767)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcA1',
                                                                  'restricted-to': [(-4096,
                                                                                     4095)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcA2',
                                                                  'restricted-to': [(-64,
                                                                                     63)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcDeltaTls',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcTot',
                                                                  'restricted-to': [(0,
                                                                                     65535)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcWNot',
                                                                  'restricted-to': [(0,
                                                                                     8191)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcWNlsf',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcDN',
                                                                  'size': [4],
                                                                  'type': 'BIT '
                                                                          'STRING'},
                                                                 {'name': 'utcDeltaTlsf',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'UTC-ModelSet3': {'members': [{'name': 'nA',
                                                                  'restricted-to': [(1,
                                                                                     1461)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'tauC',
                                                                  'restricted-to': [(-2147483648,
                                                                                     2147483647)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'b1',
                                                                  'optional': True,
                                                                  'restricted-to': [(-1024,
                                                                                     1023)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'b2',
                                                                  'optional': True,
                                                                  'restricted-to': [(-512,
                                                                                     511)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'kp',
                                                                  'optional': True,
                                                                  'size': [2],
                                                                  'type': 'BIT '
                                                                          'STRING'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'UTC-ModelSet4': {'members': [{'name': 'utcA1wnt',
                                                                  'restricted-to': [(-8388608,
                                                                                     8388607)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcA0wnt',
                                                                  'restricted-to': [(-2147483648,
                                                                                     2147483647)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcTot',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcWNt',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcDeltaTls',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcWNlsf',
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcDN',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcDeltaTlsf',
                                                                  'restricted-to': [(-128,
                                                                                     127)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'utcStandardID',
                                                                  'restricted-to': [(0,
                                                                                     7)],
                                                                  'type': 'INTEGER'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'UTC-ModelSet5-r12': {'members': [{'name': 'utcA0-r12',
                                                                      'restricted-to': [(-2147483648,
                                                                                         2147483647)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'utcA1-r12',
                                                                      'restricted-to': [(-8388608,
                                                                                         8388607)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'utcDeltaTls-r12',
                                                                      'restricted-to': [(-128,
                                                                                         127)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'utcWNlsf-r12',
                                                                      'restricted-to': [(0,
                                                                                         255)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'utcDN-r12',
                                                                      'restricted-to': [(0,
                                                                                         255)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'utcDeltaTlsf-r12',
                                                                      'restricted-to': [(-128,
                                                                                         127)],
                                                                      'type': 'INTEGER'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'Velocity': {'members': [{'name': 'horizontalVelocity',
                                                             'type': 'HorizontalVelocity'},
                                                            {'name': 'horizontalWithVerticalVelocity',
                                                             'type': 'HorizontalWithVerticalVelocity'},
                                                            {'name': 'horizontalVelocityWithUncertainty',
                                                             'type': 'HorizontalVelocityWithUncertainty'},
                                                            {'name': 'horizontalWithVerticalVelocityAndUncertainty',
                                                             'type': 'HorizontalWithVerticalVelocityAndUncertainty'},
                                                            None],
                                                'type': 'CHOICE'},
                                   'VelocityTypes': {'members': [{'name': 'horizontalVelocity',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'horizontalWithVerticalVelocity',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'horizontalVelocityWithUncertainty',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'horizontalWithVerticalVelocityAndUncertainty',
                                                                  'type': 'BOOLEAN'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'VerticalAccuracy': {'members': [{'name': 'accuracy',
                                                                     'restricted-to': [(0,
                                                                                        127)],
                                                                     'type': 'INTEGER'},
                                                                    {'name': 'confidence',
                                                                     'restricted-to': [(0,
                                                                                        100)],
                                                                     'type': 'INTEGER'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                   'WLAN-AP-Data-r14': {'members': [{'name': 'wlan-AP-Identifier-r14',
                                                                     'type': 'WLAN-AP-Identifier-r13'},
                                                                    {'name': 'wlan-AP-Location-r14',
                                                                     'optional': True,
                                                                     'type': 'WLAN-AP-Location-r14'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                   'WLAN-AP-Identifier-r13': {'members': [{'name': 'bssid-r13',
                                                                           'size': [6],
                                                                           'type': 'OCTET '
                                                                                   'STRING'},
                                                                          {'name': 'ssid-r13',
                                                                           'optional': True,
                                                                           'size': [(1,
                                                                                     32)],
                                                                           'type': 'OCTET '
                                                                                   'STRING'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'WLAN-AP-Location-r14': {'members': [{'name': 'locationDataLCI-r14',
                                                                         'type': 'LocationDataLCI-r14'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                   'WLAN-DataSet-r14': {'members': [{'element': {'type': 'WLAN-AP-Data-r14'},
                                                                     'name': 'wlan-AP-List-r14',
                                                                     'size': [(1,
                                                                               'maxWLAN-AP-r14')],
                                                                     'type': 'SEQUENCE '
                                                                             'OF'},
                                                                    {'name': 'supportedChannels-11a-r14',
                                                                     'optional': True,
                                                                     'type': 'SupportedChannels-11a-r14'},
                                                                    {'name': 'supportedChannels-11bg-r14',
                                                                     'optional': True,
                                                                     'type': 'SupportedChannels-11bg-r14'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                   'WLAN-Error-r13': {'members': [{'name': 'locationServerErrorCauses-r13',
                                                                   'type': 'WLAN-LocationServerErrorCauses-r13'},
                                                                  {'name': 'targetDeviceErrorCauses-r13',
                                                                   'type': 'WLAN-TargetDeviceErrorCauses-r13'},
                                                                  None],
                                                      'type': 'CHOICE'},
                                   'WLAN-LocationServerErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                       'type': 'ENUMERATED',
                                                                                       'values': [('undefined',
                                                                                                   0),
                                                                                                  None,
                                                                                                  ('requestedADNotAvailable-v1420',
                                                                                                   1),
                                                                                                  ('notAllrequestedADAvailable-v1420',
                                                                                                   2)]},
                                                                                      None,
                                                                                      [{'name': 'apLocationDataUnavailable-r14',
                                                                                        'optional': True,
                                                                                        'type': 'NULL'}]],
                                                                          'type': 'SEQUENCE'},
                                   'WLAN-MeasurementElement-r13': {'members': [{'name': 'wlan-AP-Identifier-r13',
                                                                                'type': 'WLAN-AP-Identifier-r13'},
                                                                               {'name': 'rssi-r13',
                                                                                'optional': True,
                                                                                'restricted-to': [(-127,
                                                                                                   128)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'rtt-r13',
                                                                                'optional': True,
                                                                                'type': 'WLAN-RTT-r13'},
                                                                               {'name': 'apChannelFrequency-r13',
                                                                                'optional': True,
                                                                                'restricted-to': [(0,
                                                                                                   256)],
                                                                                'type': 'INTEGER'},
                                                                               {'name': 'servingFlag-r13',
                                                                                'optional': True,
                                                                                'type': 'BOOLEAN'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                   'WLAN-MeasurementInformation-r13': {'members': [{'name': 'measurementReferenceTime-r13',
                                                                                    'optional': True,
                                                                                    'type': 'UTCTime'},
                                                                                   {'name': 'wlan-MeasurementList-r13',
                                                                                    'optional': True,
                                                                                    'type': 'WLAN-MeasurementList-r13'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                   'WLAN-MeasurementList-r13': {'element': {'type': 'WLAN-MeasurementElement-r13'},
                                                                'size': [(1,
                                                                          'maxWLAN-AP-r13')],
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                                   'WLAN-ProvideAssistanceData-r14': {'members': [{'element': {'type': 'WLAN-DataSet-r14'},
                                                                                   'name': 'wlan-DataSet-r14',
                                                                                   'optional': True,
                                                                                   'size': [(1,
                                                                                             'maxWLAN-DataSets-r14')],
                                                                                   'type': 'SEQUENCE '
                                                                                           'OF'},
                                                                                  {'name': 'wlan-Error-r14',
                                                                                   'optional': True,
                                                                                   'type': 'WLAN-Error-r13'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'WLAN-ProvideCapabilities-r13': {'members': [{'name': 'wlan-Modes-r13',
                                                                                 'named-bits': [('standalone',
                                                                                                 '0'),
                                                                                                ('ue-assisted',
                                                                                                 '1'),
                                                                                                ('ue-based',
                                                                                                 '2')],
                                                                                 'size': [(1,
                                                                                           8)],
                                                                                 'type': 'BIT '
                                                                                         'STRING'},
                                                                                {'name': 'wlan-MeasSupported-r13',
                                                                                 'named-bits': [('rssi-r13',
                                                                                                 '0'),
                                                                                                ('rtt-r13',
                                                                                                 '1')],
                                                                                 'size': [(1,
                                                                                           8)],
                                                                                 'type': 'BIT '
                                                                                         'STRING'},
                                                                                None,
                                                                                [{'name': 'wlan-AP-AD-Supported-r14',
                                                                                  'named-bits': [('ap-identifier',
                                                                                                  '0'),
                                                                                                 ('ap-location',
                                                                                                  '1')],
                                                                                  'optional': True,
                                                                                  'size': [(1,
                                                                                            8)],
                                                                                  'type': 'BIT '
                                                                                          'STRING'},
                                                                                 {'name': 'periodicalReportingSupported-r14',
                                                                                  'optional': True,
                                                                                  'type': 'PositioningModes'},
                                                                                 {'name': 'idleStateForMeasurements-r14',
                                                                                  'optional': True,
                                                                                  'type': 'ENUMERATED',
                                                                                  'values': [('required',
                                                                                              0)]}]],
                                                                    'type': 'SEQUENCE'},
                                   'WLAN-ProvideLocationInformation-r13': {'members': [{'name': 'wlan-MeasurementInformation-r13',
                                                                                        'optional': True,
                                                                                        'type': 'WLAN-MeasurementInformation-r13'},
                                                                                       {'name': 'wlan-Error-r13',
                                                                                        'optional': True,
                                                                                        'type': 'WLAN-Error-r13'},
                                                                                       None],
                                                                           'type': 'SEQUENCE'},
                                   'WLAN-RTT-r13': {'members': [{'name': 'rttValue-r13',
                                                                 'restricted-to': [(0,
                                                                                    16777215)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'rttUnits-r13',
                                                                 'type': 'ENUMERATED',
                                                                 'values': [('microseconds',
                                                                             0),
                                                                            ('hundredsofnanoseconds',
                                                                             1),
                                                                            ('tensofnanoseconds',
                                                                             2),
                                                                            ('nanoseconds',
                                                                             3),
                                                                            ('tenthsofnanoseconds',
                                                                             4),
                                                                            None]},
                                                                {'name': 'rttAccuracy-r13',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    255)],
                                                                 'type': 'INTEGER'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                   'WLAN-RequestAssistanceData-r14': {'members': [{'name': 'requestedAD-r14',
                                                                                   'named-bits': [('ap-identifier',
                                                                                                   '0'),
                                                                                                  ('ap-location',
                                                                                                   '1')],
                                                                                   'size': [(1,
                                                                                             8)],
                                                                                   'type': 'BIT '
                                                                                           'STRING'},
                                                                                  {'element': {'type': 'WLAN-AP-Identifier-r13'},
                                                                                   'name': 'visibleAPs-r14',
                                                                                   'optional': True,
                                                                                   'size': [(1,
                                                                                             'maxVisibleAPs-r14')],
                                                                                   'type': 'SEQUENCE '
                                                                                           'OF'},
                                                                                  {'element': {'type': 'WLAN-AP-Identifier-r13'},
                                                                                   'name': 'wlan-AP-StoredData-r14',
                                                                                   'optional': True,
                                                                                   'size': [(1,
                                                                                             'maxKnownAPs-r14')],
                                                                                   'type': 'SEQUENCE '
                                                                                           'OF'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'WLAN-RequestCapabilities-r13': {'members': [None],
                                                                    'type': 'SEQUENCE'},
                                   'WLAN-RequestLocationInformation-r13': {'members': [{'name': 'requestedMeasurements-r13',
                                                                                        'named-bits': [('rssi',
                                                                                                        '0'),
                                                                                                       ('rtt',
                                                                                                        '1')],
                                                                                        'size': [(1,
                                                                                                  8)],
                                                                                        'type': 'BIT '
                                                                                                'STRING'},
                                                                                       None,
                                                                                       [{'name': 'assistanceAvailability-r14',
                                                                                         'optional': True,
                                                                                         'type': 'BOOLEAN'}]],
                                                                           'type': 'SEQUENCE'},
                                   'WLAN-TargetDeviceErrorCauses-r13': {'members': [{'name': 'cause-r13',
                                                                                     'type': 'ENUMERATED',
                                                                                     'values': [('undefined',
                                                                                                 0),
                                                                                                ('requestedMeasurementsNotAvailable',
                                                                                                 1),
                                                                                                ('notAllrequestedMeasurementsPossible',
                                                                                                 2),
                                                                                                None]},
                                                                                    {'name': 'wlan-AP-RSSI-MeasurementNotPossible-r13',
                                                                                     'optional': True,
                                                                                     'type': 'NULL'},
                                                                                    {'name': 'wlan-AP-RTT-MeasurementNotPossible-r13',
                                                                                     'optional': True,
                                                                                     'type': 'NULL'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'}},
                         'values': {'maxAddPRSconfig-r14': {'type': 'INTEGER',
                                                            'value': 2},
                                    'maxAvailNarrowBands-Minus1-r14': {'type': 'INTEGER',
                                                                       'value': 15},
                                    'maxBT-Beacon-r13': {'type': 'INTEGER',
                                                         'value': 32},
                                    'maxBands': {'type': 'INTEGER',
                                                 'value': 64},
                                    'maxCarrier-r14': {'type': 'INTEGER',
                                                       'value': 5},
                                    'maxCells-r14': {'type': 'INTEGER',
                                                     'value': 72},
                                    'maxEARFCN': {'type': 'INTEGER',
                                                  'value': 65535},
                                    'maxEARFCN-Plus1': {'type': 'INTEGER',
                                                        'value': 65536},
                                    'maxEARFCN2': {'type': 'INTEGER',
                                                   'value': 262143},
                                    'maxEPDU': {'type': 'INTEGER', 'value': 16},
                                    'maxFBI': {'type': 'INTEGER', 'value': 64},
                                    'maxFBI-Plus1': {'type': 'INTEGER',
                                                     'value': 65},
                                    'maxFBI2': {'type': 'INTEGER',
                                                'value': 256},
                                    'maxFreqLayers': {'type': 'INTEGER',
                                                      'value': 3},
                                    'maxKnownAPs-r14': {'type': 'INTEGER',
                                                        'value': 2048},
                                    'maxMBS-r14': {'type': 'INTEGER',
                                                   'value': 64},
                                    'maxPaths-r14': {'type': 'INTEGER',
                                                     'value': 2},
                                    'maxVisibleAPs-r14': {'type': 'INTEGER',
                                                          'value': 32},
                                    'maxWLAN-AP-r13': {'type': 'INTEGER',
                                                       'value': 64},
                                    'maxWLAN-AP-r14': {'type': 'INTEGER',
                                                       'value': 128},
                                    'maxWLAN-DataSets-r14': {'type': 'INTEGER',
                                                             'value': 8}}}}