EXPECTED = {'S1AP-CommonDataTypes': {'extensibility-implied': False,
                          'imports': {},
                          'object-classes': {},
                          'object-sets': {},
                          'tags': 'AUTOMATIC',
                          'types': {'Criticality': {'type': 'ENUMERATED',
                                                    'values': [('reject', 0),
                                                               ('ignore', 1),
                                                               ('notify', 2)]},
                                    'Presence': {'type': 'ENUMERATED',
                                                 'values': [('optional', 0),
                                                            ('conditional', 1),
                                                            ('mandatory', 2)]},
                                    'PrivateIE-ID': {'members': [{'name': 'local',
                                                                  'restricted-to': [(0,
                                                                                     65535)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'global',
                                                                  'type': 'OBJECT '
                                                                          'IDENTIFIER'}],
                                                     'type': 'CHOICE'},
                                    'ProcedureCode': {'restricted-to': [(0,
                                                                         255)],
                                                      'type': 'INTEGER'},
                                    'ProtocolExtensionID': {'restricted-to': [(0,
                                                                               65535)],
                                                            'type': 'INTEGER'},
                                    'ProtocolIE-ID': {'restricted-to': [(0,
                                                                         65535)],
                                                      'type': 'INTEGER'},
                                    'TriggeringMessage': {'type': 'ENUMERATED',
                                                          'values': [('initiating-message',
                                                                      0),
                                                                     ('successful-outcome',
                                                                      1),
                                                                     ('unsuccessfull-outcome',
                                                                      2)]}},
                          'values': {}},
 'S1AP-Constants': {'extensibility-implied': False,
                    'imports': {'S1AP-CommonDataTypes': ['ProcedureCode',
                                                         'ProtocolIE-ID']},
                    'object-classes': {},
                    'object-sets': {},
                    'tags': 'AUTOMATIC',
                    'types': {},
                    'values': {'id-Additional-GUTI': {'type': 'ProtocolIE-ID',
                                                      'value': 224},
                               'id-AdditionalCSFallbackIndicator': {'type': 'ProtocolIE-ID',
                                                                    'value': 187},
                               'id-AssistanceDataForPaging': {'type': 'ProtocolIE-ID',
                                                              'value': 211},
                               'id-BearerType': {'type': 'ProtocolIE-ID',
                                                 'value': 233},
                               'id-Bearers-SubjectToStatusTransfer-Item': {'type': 'ProtocolIE-ID',
                                                                           'value': 89},
                               'id-BroadcastCancelledAreaList': {'type': 'ProtocolIE-ID',
                                                                 'value': 141},
                               'id-BroadcastCompletedAreaList': {'type': 'ProtocolIE-ID',
                                                                 'value': 120},
                               'id-CE-mode-B-SupportIndicator': {'type': 'ProtocolIE-ID',
                                                                 'value': 242},
                               'id-CNDomain': {'type': 'ProtocolIE-ID',
                                               'value': 109},
                               'id-CSFallbackIndicator': {'type': 'ProtocolIE-ID',
                                                          'value': 108},
                               'id-CSG-Id': {'type': 'ProtocolIE-ID',
                                             'value': 127},
                               'id-CSG-IdList': {'type': 'ProtocolIE-ID',
                                                 'value': 128},
                               'id-CSGMembershipInfo': {'type': 'ProtocolIE-ID',
                                                        'value': 226},
                               'id-CSGMembershipStatus': {'type': 'ProtocolIE-ID',
                                                          'value': 146},
                               'id-Cause': {'type': 'ProtocolIE-ID',
                                            'value': 2},
                               'id-CellAccessMode': {'type': 'ProtocolIE-ID',
                                                     'value': 145},
                               'id-CellIdentifierAndCELevelForCECapableUEs': {'type': 'ProtocolIE-ID',
                                                                              'value': 212},
                               'id-CellTrafficTrace': {'type': 'ProcedureCode',
                                                       'value': 42},
                               'id-ConcurrentWarningMessageIndicator': {'type': 'ProtocolIE-ID',
                                                                        'value': 142},
                               'id-ConnectionEstablishmentIndication': {'type': 'ProcedureCode',
                                                                        'value': 54},
                               'id-Correlation-ID': {'type': 'ProtocolIE-ID',
                                                     'value': 156},
                               'id-Coverage-Level': {'type': 'ProtocolIE-ID',
                                                     'value': 250},
                               'id-CriticalityDiagnostics': {'type': 'ProtocolIE-ID',
                                                             'value': 58},
                               'id-DCN-ID': {'type': 'ProtocolIE-ID',
                                             'value': 246},
                               'id-DL-CP-SecurityInformation': {'type': 'ProtocolIE-ID',
                                                                'value': 253},
                               'id-DLCOUNTValueExtended': {'type': 'ProtocolIE-ID',
                                                           'value': 180},
                               'id-DLCOUNTValuePDCP-SNlength18': {'type': 'ProtocolIE-ID',
                                                                  'value': 218},
                               'id-DLNASPDUDeliveryAckRequest': {'type': 'ProtocolIE-ID',
                                                                 'value': 249},
                               'id-Data-Forwarding-Not-Possible': {'type': 'ProtocolIE-ID',
                                                                   'value': 143},
                               'id-DataCodingScheme': {'type': 'ProtocolIE-ID',
                                                       'value': 118},
                               'id-DeactivateTrace': {'type': 'ProcedureCode',
                                                      'value': 26},
                               'id-DefaultPagingDRX': {'type': 'ProtocolIE-ID',
                                                       'value': 137},
                               'id-Direct-Forwarding-Path-Availability': {'type': 'ProtocolIE-ID',
                                                                          'value': 79},
                               'id-DownlinkS1cdma2000tunnelling': {'type': 'ProcedureCode',
                                                                   'value': 19},
                               'id-E-RABAdmittedItem': {'type': 'ProtocolIE-ID',
                                                        'value': 20},
                               'id-E-RABAdmittedList': {'type': 'ProtocolIE-ID',
                                                        'value': 18},
                               'id-E-RABDataForwardingItem': {'type': 'ProtocolIE-ID',
                                                              'value': 14},
                               'id-E-RABFailedToBeReleasedList': {'type': 'ProtocolIE-ID',
                                                                  'value': 103},
                               'id-E-RABFailedToModifyList': {'type': 'ProtocolIE-ID',
                                                              'value': 32},
                               'id-E-RABFailedToModifyListBearerModConf': {'type': 'ProtocolIE-ID',
                                                                           'value': 205},
                               'id-E-RABFailedToReleaseList': {'type': 'ProtocolIE-ID',
                                                               'value': 34},
                               'id-E-RABFailedToResumeItemResumeReq': {'type': 'ProtocolIE-ID',
                                                                       'value': 236},
                               'id-E-RABFailedToResumeItemResumeRes': {'type': 'ProtocolIE-ID',
                                                                       'value': 238},
                               'id-E-RABFailedToResumeListResumeReq': {'type': 'ProtocolIE-ID',
                                                                       'value': 235},
                               'id-E-RABFailedToResumeListResumeRes': {'type': 'ProtocolIE-ID',
                                                                       'value': 237},
                               'id-E-RABFailedToSetupListBearerSURes': {'type': 'ProtocolIE-ID',
                                                                        'value': 29},
                               'id-E-RABFailedToSetupListCtxtSURes': {'type': 'ProtocolIE-ID',
                                                                      'value': 48},
                               'id-E-RABFailedToSetupListHOReqAck': {'type': 'ProtocolIE-ID',
                                                                     'value': 19},
                               'id-E-RABFailedtoSetupItemHOReqAck': {'type': 'ProtocolIE-ID',
                                                                     'value': 21},
                               'id-E-RABInformationListItem': {'type': 'ProtocolIE-ID',
                                                               'value': 78},
                               'id-E-RABItem': {'type': 'ProtocolIE-ID',
                                                'value': 35},
                               'id-E-RABModificationIndication': {'type': 'ProcedureCode',
                                                                  'value': 50},
                               'id-E-RABModify': {'type': 'ProcedureCode',
                                                  'value': 6},
                               'id-E-RABModifyItemBearerModConf': {'type': 'ProtocolIE-ID',
                                                                   'value': 204},
                               'id-E-RABModifyItemBearerModRes': {'type': 'ProtocolIE-ID',
                                                                  'value': 37},
                               'id-E-RABModifyListBearerModConf': {'type': 'ProtocolIE-ID',
                                                                   'value': 203},
                               'id-E-RABModifyListBearerModRes': {'type': 'ProtocolIE-ID',
                                                                  'value': 31},
                               'id-E-RABNotToBeModifiedItemBearerModInd': {'type': 'ProtocolIE-ID',
                                                                           'value': 202},
                               'id-E-RABNotToBeModifiedListBearerModInd': {'type': 'ProtocolIE-ID',
                                                                           'value': 201},
                               'id-E-RABRelease': {'type': 'ProcedureCode',
                                                   'value': 7},
                               'id-E-RABReleaseIndication': {'type': 'ProcedureCode',
                                                             'value': 8},
                               'id-E-RABReleaseItem': {'type': 'ProtocolIE-ID',
                                                       'value': 38},
                               'id-E-RABReleaseItemBearerRelComp': {'type': 'ProtocolIE-ID',
                                                                    'value': 15},
                               'id-E-RABReleaseItemHOCmd': {'type': 'ProtocolIE-ID',
                                                            'value': 49},
                               'id-E-RABReleaseListBearerRelComp': {'type': 'ProtocolIE-ID',
                                                                    'value': 69},
                               'id-E-RABReleasedList': {'type': 'ProtocolIE-ID',
                                                        'value': 110},
                               'id-E-RABSetup': {'type': 'ProcedureCode',
                                                 'value': 5},
                               'id-E-RABSetupItemBearerSURes': {'type': 'ProtocolIE-ID',
                                                                'value': 39},
                               'id-E-RABSetupItemCtxtSURes': {'type': 'ProtocolIE-ID',
                                                              'value': 50},
                               'id-E-RABSetupListBearerSURes': {'type': 'ProtocolIE-ID',
                                                                'value': 28},
                               'id-E-RABSetupListCtxtSURes': {'type': 'ProtocolIE-ID',
                                                              'value': 51},
                               'id-E-RABSubjecttoDataForwardingList': {'type': 'ProtocolIE-ID',
                                                                       'value': 12},
                               'id-E-RABToBeModifiedItemBearerModInd': {'type': 'ProtocolIE-ID',
                                                                        'value': 200},
                               'id-E-RABToBeModifiedItemBearerModReq': {'type': 'ProtocolIE-ID',
                                                                        'value': 36},
                               'id-E-RABToBeModifiedListBearerModInd': {'type': 'ProtocolIE-ID',
                                                                        'value': 199},
                               'id-E-RABToBeModifiedListBearerModReq': {'type': 'ProtocolIE-ID',
                                                                        'value': 30},
                               'id-E-RABToBeReleasedList': {'type': 'ProtocolIE-ID',
                                                            'value': 33},
                               'id-E-RABToBeReleasedListBearerModConf': {'type': 'ProtocolIE-ID',
                                                                         'value': 210},
                               'id-E-RABToBeSetupItemBearerSUReq': {'type': 'ProtocolIE-ID',
                                                                    'value': 17},
                               'id-E-RABToBeSetupItemCtxtSUReq': {'type': 'ProtocolIE-ID',
                                                                  'value': 52},
                               'id-E-RABToBeSetupItemHOReq': {'type': 'ProtocolIE-ID',
                                                              'value': 27},
                               'id-E-RABToBeSetupListBearerSUReq': {'type': 'ProtocolIE-ID',
                                                                    'value': 16},
                               'id-E-RABToBeSetupListCtxtSUReq': {'type': 'ProtocolIE-ID',
                                                                  'value': 24},
                               'id-E-RABToBeSetupListHOReq': {'type': 'ProtocolIE-ID',
                                                              'value': 53},
                               'id-E-RABToBeSwitchedDLItem': {'type': 'ProtocolIE-ID',
                                                              'value': 23},
                               'id-E-RABToBeSwitchedDLList': {'type': 'ProtocolIE-ID',
                                                              'value': 22},
                               'id-E-RABToBeSwitchedULItem': {'type': 'ProtocolIE-ID',
                                                              'value': 94},
                               'id-E-RABToBeSwitchedULList': {'type': 'ProtocolIE-ID',
                                                              'value': 95},
                               'id-E-RABtoReleaseListHOCmd': {'type': 'ProtocolIE-ID',
                                                              'value': 13},
                               'id-E-UTRAN-Trace-ID': {'type': 'ProtocolIE-ID',
                                                       'value': 86},
                               'id-ECGIListForRestart': {'type': 'ProtocolIE-ID',
                                                         'value': 182},
                               'id-ENBConfigurationUpdate': {'type': 'ProcedureCode',
                                                             'value': 29},
                               'id-EUTRAN-CGI': {'type': 'ProtocolIE-ID',
                                                 'value': 100},
                               'id-EUTRANRoundTripDelayEstimationInfo': {'type': 'ProtocolIE-ID',
                                                                         'value': 140},
                               'id-EmergencyAreaIDListForRestart': {'type': 'ProtocolIE-ID',
                                                                    'value': 190},
                               'id-EnhancedCoverageRestricted': {'type': 'ProtocolIE-ID',
                                                                 'value': 251},
                               'id-ErrorIndication': {'type': 'ProcedureCode',
                                                      'value': 15},
                               'id-ExpectedUEBehaviour': {'type': 'ProtocolIE-ID',
                                                          'value': 196},
                               'id-ExtendedRepetitionPeriod': {'type': 'ProtocolIE-ID',
                                                               'value': 144},
                               'id-GERANtoLTEHOInformationRes': {'type': 'ProtocolIE-ID',
                                                                 'value': 55},
                               'id-GUMMEI-ID': {'type': 'ProtocolIE-ID',
                                                'value': 75},
                               'id-GUMMEIList': {'type': 'ProtocolIE-ID',
                                                 'value': 154},
                               'id-GUMMEIType': {'type': 'ProtocolIE-ID',
                                                 'value': 170},
                               'id-GW-TransportLayerAddress': {'type': 'ProtocolIE-ID',
                                                               'value': 155},
                               'id-GWContextReleaseIndication': {'type': 'ProtocolIE-ID',
                                                                 'value': 164},
                               'id-Global-ENB-ID': {'type': 'ProtocolIE-ID',
                                                    'value': 59},
                               'id-HO-Cause': {'type': 'ProtocolIE-ID',
                                               'value': 168},
                               'id-HandoverCancel': {'type': 'ProcedureCode',
                                                     'value': 4},
                               'id-HandoverNotification': {'type': 'ProcedureCode',
                                                           'value': 2},
                               'id-HandoverPreparation': {'type': 'ProcedureCode',
                                                          'value': 0},
                               'id-HandoverResourceAllocation': {'type': 'ProcedureCode',
                                                                 'value': 1},
                               'id-HandoverRestrictionList': {'type': 'ProtocolIE-ID',
                                                              'value': 41},
                               'id-HandoverType': {'type': 'ProtocolIE-ID',
                                                   'value': 1},
                               'id-InformationOnRecommendedCellsAndENBsForPaging': {'type': 'ProtocolIE-ID',
                                                                                    'value': 213},
                               'id-InitialContextSetup': {'type': 'ProcedureCode',
                                                          'value': 9},
                               'id-Inter-SystemInformationTransferTypeEDT': {'type': 'ProtocolIE-ID',
                                                                             'value': 121},
                               'id-Inter-SystemInformationTransferTypeMDT': {'type': 'ProtocolIE-ID',
                                                                             'value': 122},
                               'id-Kill': {'type': 'ProcedureCode',
                                           'value': 43},
                               'id-KillAllWarningMessages': {'type': 'ProtocolIE-ID',
                                                             'value': 191},
                               'id-LHN-ID': {'type': 'ProtocolIE-ID',
                                             'value': 186},
                               'id-LPPa-PDU': {'type': 'ProtocolIE-ID',
                                               'value': 147},
                               'id-LocationReport': {'type': 'ProcedureCode',
                                                     'value': 33},
                               'id-LocationReportingControl': {'type': 'ProcedureCode',
                                                               'value': 31},
                               'id-LocationReportingFailureIndication': {'type': 'ProcedureCode',
                                                                         'value': 32},
                               'id-LoggedMBSFNMDT': {'type': 'ProtocolIE-ID',
                                                     'value': 197},
                               'id-M3Configuration': {'type': 'ProtocolIE-ID',
                                                      'value': 171},
                               'id-M4Configuration': {'type': 'ProtocolIE-ID',
                                                      'value': 172},
                               'id-M5Configuration': {'type': 'ProtocolIE-ID',
                                                      'value': 173},
                               'id-M6Configuration': {'type': 'ProtocolIE-ID',
                                                      'value': 220},
                               'id-M7Configuration': {'type': 'ProtocolIE-ID',
                                                      'value': 221},
                               'id-MDT-Location-Info': {'type': 'ProtocolIE-ID',
                                                        'value': 174},
                               'id-MDTConfiguration': {'type': 'ProtocolIE-ID',
                                                       'value': 162},
                               'id-MME-Group-ID': {'type': 'ProtocolIE-ID',
                                                   'value': 223},
                               'id-MME-UE-S1AP-ID': {'type': 'ProtocolIE-ID',
                                                     'value': 0},
                               'id-MME-UE-S1AP-ID-2': {'type': 'ProtocolIE-ID',
                                                       'value': 158},
                               'id-MMECPRelocationIndication': {'type': 'ProcedureCode',
                                                                'value': 61},
                               'id-MMEConfigurationTransfer': {'type': 'ProcedureCode',
                                                               'value': 41},
                               'id-MMEConfigurationUpdate': {'type': 'ProcedureCode',
                                                             'value': 30},
                               'id-MMEDirectInformationTransfer': {'type': 'ProcedureCode',
                                                                   'value': 38},
                               'id-MMERelaySupportIndicator': {'type': 'ProtocolIE-ID',
                                                               'value': 163},
                               'id-MMEStatusTransfer': {'type': 'ProcedureCode',
                                                        'value': 25},
                               'id-MMEname': {'type': 'ProtocolIE-ID',
                                              'value': 61},
                               'id-MSClassmark2': {'type': 'ProtocolIE-ID',
                                                   'value': 132},
                               'id-MSClassmark3': {'type': 'ProtocolIE-ID',
                                                   'value': 133},
                               'id-ManagementBasedMDTAllowed': {'type': 'ProtocolIE-ID',
                                                                'value': 165},
                               'id-ManagementBasedMDTPLMNList': {'type': 'ProtocolIE-ID',
                                                                 'value': 177},
                               'id-Masked-IMEISV': {'type': 'ProtocolIE-ID',
                                                    'value': 192},
                               'id-MessageIdentifier': {'type': 'ProtocolIE-ID',
                                                        'value': 111},
                               'id-MobilityInformation': {'type': 'ProtocolIE-ID',
                                                          'value': 175},
                               'id-Muting-Availability-Indication': {'type': 'ProtocolIE-ID',
                                                                     'value': 207},
                               'id-Muting-Pattern-Information': {'type': 'ProtocolIE-ID',
                                                                 'value': 208},
                               'id-NAS-DownlinkCount': {'type': 'ProtocolIE-ID',
                                                        'value': 126},
                               'id-NAS-PDU': {'type': 'ProtocolIE-ID',
                                              'value': 26},
                               'id-NASDeliveryIndication': {'type': 'ProcedureCode',
                                                            'value': 57},
                               'id-NASNonDeliveryIndication': {'type': 'ProcedureCode',
                                                               'value': 16},
                               'id-NASSecurityParametersfromE-UTRAN': {'type': 'ProtocolIE-ID',
                                                                       'value': 135},
                               'id-NASSecurityParameterstoE-UTRAN': {'type': 'ProtocolIE-ID',
                                                                     'value': 136},
                               'id-NB-IoT-DefaultPagingDRX': {'type': 'ProtocolIE-ID',
                                                              'value': 234},
                               'id-NB-IoT-Paging-eDRXInformation': {'type': 'ProtocolIE-ID',
                                                                    'value': 239},
                               'id-NB-IoT-UEIdentityIndexValue': {'type': 'ProtocolIE-ID',
                                                                  'value': 244},
                               'id-NumberofBroadcastRequest': {'type': 'ProtocolIE-ID',
                                                               'value': 115},
                               'id-OverloadResponse': {'type': 'ProtocolIE-ID',
                                                       'value': 101},
                               'id-OverloadStart': {'type': 'ProcedureCode',
                                                    'value': 34},
                               'id-OverloadStop': {'type': 'ProcedureCode',
                                                   'value': 35},
                               'id-PS-ServiceNotAvailable': {'type': 'ProtocolIE-ID',
                                                             'value': 150},
                               'id-PWSFailureIndication': {'type': 'ProcedureCode',
                                                           'value': 51},
                               'id-PWSRestartIndication': {'type': 'ProcedureCode',
                                                           'value': 49},
                               'id-PWSfailedECGIList': {'type': 'ProtocolIE-ID',
                                                        'value': 222},
                               'id-Paging': {'type': 'ProcedureCode',
                                             'value': 10},
                               'id-Paging-eDRXInformation': {'type': 'ProtocolIE-ID',
                                                             'value': 227},
                               'id-PagingPriority': {'type': 'ProtocolIE-ID',
                                                     'value': 151},
                               'id-PathSwitchRequest': {'type': 'ProcedureCode',
                                                        'value': 3},
                               'id-PrivacyIndicator': {'type': 'ProtocolIE-ID',
                                                       'value': 166},
                               'id-PrivateMessage': {'type': 'ProcedureCode',
                                                     'value': 39},
                               'id-ProSeAuthorized': {'type': 'ProtocolIE-ID',
                                                      'value': 195},
                               'id-ProSeUEtoNetworkRelaying': {'type': 'ProtocolIE-ID',
                                                               'value': 216},
                               'id-RAT-Type': {'type': 'ProtocolIE-ID',
                                               'value': 232},
                               'id-RRC-Establishment-Cause': {'type': 'ProtocolIE-ID',
                                                              'value': 134},
                               'id-RRC-Resume-Cause': {'type': 'ProtocolIE-ID',
                                                       'value': 245},
                               'id-ReceiveStatusOfULPDCPSDUsExtended': {'type': 'ProtocolIE-ID',
                                                                        'value': 181},
                               'id-ReceiveStatusOfULPDCPSDUsPDCP-SNlength18': {'type': 'ProtocolIE-ID',
                                                                               'value': 219},
                               'id-RecommendedCellItem': {'type': 'ProtocolIE-ID',
                                                          'value': 214},
                               'id-RecommendedENBItem': {'type': 'ProtocolIE-ID',
                                                         'value': 215},
                               'id-RegisteredLAI': {'type': 'ProtocolIE-ID',
                                                    'value': 159},
                               'id-RelativeMMECapacity': {'type': 'ProtocolIE-ID',
                                                          'value': 87},
                               'id-RelayNode-Indicator': {'type': 'ProtocolIE-ID',
                                                          'value': 160},
                               'id-RepetitionPeriod': {'type': 'ProtocolIE-ID',
                                                       'value': 114},
                               'id-RequestType': {'type': 'ProtocolIE-ID',
                                                  'value': 98},
                               'id-RerouteNASRequest': {'type': 'ProcedureCode',
                                                        'value': 52},
                               'id-Reset': {'type': 'ProcedureCode',
                                            'value': 14},
                               'id-ResetType': {'type': 'ProtocolIE-ID',
                                                'value': 92},
                               'id-RetrieveUEInformation': {'type': 'ProcedureCode',
                                                            'value': 58},
                               'id-Routing-ID': {'type': 'ProtocolIE-ID',
                                                 'value': 148},
                               'id-S-TMSI': {'type': 'ProtocolIE-ID',
                                             'value': 96},
                               'id-S1-Message': {'type': 'ProtocolIE-ID',
                                                 'value': 225},
                               'id-S1Setup': {'type': 'ProcedureCode',
                                              'value': 17},
                               'id-SIPTO-Correlation-ID': {'type': 'ProtocolIE-ID',
                                                           'value': 183},
                               'id-SIPTO-L-GW-TransportLayerAddress': {'type': 'ProtocolIE-ID',
                                                                       'value': 184},
                               'id-SON-Information-Report': {'type': 'ProtocolIE-ID',
                                                             'value': 206},
                               'id-SONConfigurationTransferECT': {'type': 'ProtocolIE-ID',
                                                                  'value': 129},
                               'id-SONConfigurationTransferMCT': {'type': 'ProtocolIE-ID',
                                                                  'value': 130},
                               'id-SRVCCHOIndication': {'type': 'ProtocolIE-ID',
                                                        'value': 125},
                               'id-SRVCCOperationNotPossible': {'type': 'ProtocolIE-ID',
                                                                'value': 243},
                               'id-SRVCCOperationPossible': {'type': 'ProtocolIE-ID',
                                                             'value': 124},
                               'id-SecurityContext': {'type': 'ProtocolIE-ID',
                                                      'value': 40},
                               'id-SecurityKey': {'type': 'ProtocolIE-ID',
                                                  'value': 73},
                               'id-SerialNumber': {'type': 'ProtocolIE-ID',
                                                   'value': 112},
                               'id-ServedDCNs': {'type': 'ProtocolIE-ID',
                                                 'value': 247},
                               'id-ServedGUMMEIs': {'type': 'ProtocolIE-ID',
                                                    'value': 105},
                               'id-ServedPLMNs': {'type': 'ProtocolIE-ID',
                                                  'value': 63},
                               'id-SignallingBasedMDTPLMNList': {'type': 'ProtocolIE-ID',
                                                                 'value': 178},
                               'id-Source-ToTarget-TransparentContainer': {'type': 'ProtocolIE-ID',
                                                                           'value': 104},
                               'id-Source-ToTarget-TransparentContainer-Secondary': {'type': 'ProtocolIE-ID',
                                                                                     'value': 138},
                               'id-SourceID': {'type': 'ProtocolIE-ID',
                                               'value': 3},
                               'id-SourceMME-GUMMEI': {'type': 'ProtocolIE-ID',
                                                       'value': 157},
                               'id-SourceMME-UE-S1AP-ID': {'type': 'ProtocolIE-ID',
                                                           'value': 88},
                               'id-SubscriberProfileIDforRFP': {'type': 'ProtocolIE-ID',
                                                                'value': 106},
                               'id-SupportedTAs': {'type': 'ProtocolIE-ID',
                                                   'value': 64},
                               'id-Synchronisation-Information': {'type': 'ProtocolIE-ID',
                                                                  'value': 209},
                               'id-TAI': {'type': 'ProtocolIE-ID', 'value': 67},
                               'id-TAIItem': {'type': 'ProtocolIE-ID',
                                              'value': 47},
                               'id-TAIList': {'type': 'ProtocolIE-ID',
                                              'value': 46},
                               'id-TAIListForRestart': {'type': 'ProtocolIE-ID',
                                                        'value': 188},
                               'id-Target-ToSource-TransparentContainer': {'type': 'ProtocolIE-ID',
                                                                           'value': 123},
                               'id-Target-ToSource-TransparentContainer-Secondary': {'type': 'ProtocolIE-ID',
                                                                                     'value': 139},
                               'id-TargetID': {'type': 'ProtocolIE-ID',
                                               'value': 4},
                               'id-Time-Synchronisation-Info': {'type': 'ProtocolIE-ID',
                                                                'value': 149},
                               'id-Time-UE-StayedInCell-EnhancedGranularity': {'type': 'ProtocolIE-ID',
                                                                               'value': 167},
                               'id-TimeToWait': {'type': 'ProtocolIE-ID',
                                                 'value': 65},
                               'id-TraceActivation': {'type': 'ProtocolIE-ID',
                                                      'value': 25},
                               'id-TraceCollectionEntityIPAddress': {'type': 'ProtocolIE-ID',
                                                                     'value': 131},
                               'id-TraceFailureIndication': {'type': 'ProcedureCode',
                                                             'value': 28},
                               'id-TraceStart': {'type': 'ProcedureCode',
                                                 'value': 27},
                               'id-TrafficLoadReductionIndication': {'type': 'ProtocolIE-ID',
                                                                     'value': 161},
                               'id-TransportInformation': {'type': 'ProtocolIE-ID',
                                                           'value': 185},
                               'id-Tunnel-Information-for-BBF': {'type': 'ProtocolIE-ID',
                                                                 'value': 176},
                               'id-UE-Level-QoS-Parameters': {'type': 'ProtocolIE-ID',
                                                              'value': 252},
                               'id-UE-RetentionInformation': {'type': 'ProtocolIE-ID',
                                                              'value': 228},
                               'id-UE-S1AP-IDs': {'type': 'ProtocolIE-ID',
                                                  'value': 99},
                               'id-UE-Usage-Type': {'type': 'ProtocolIE-ID',
                                                    'value': 230},
                               'id-UE-associatedLogicalS1-ConnectionItem': {'type': 'ProtocolIE-ID',
                                                                            'value': 91},
                               'id-UE-associatedLogicalS1-ConnectionListResAck': {'type': 'ProtocolIE-ID',
                                                                                  'value': 93},
                               'id-UECapabilityInfoIndication': {'type': 'ProcedureCode',
                                                                 'value': 22},
                               'id-UEContextModification': {'type': 'ProcedureCode',
                                                            'value': 21},
                               'id-UEContextModificationIndication': {'type': 'ProcedureCode',
                                                                      'value': 53},
                               'id-UEContextRelease': {'type': 'ProcedureCode',
                                                       'value': 23},
                               'id-UEContextReleaseRequest': {'type': 'ProcedureCode',
                                                              'value': 18},
                               'id-UEContextResume': {'type': 'ProcedureCode',
                                                      'value': 56},
                               'id-UEContextSuspend': {'type': 'ProcedureCode',
                                                       'value': 55},
                               'id-UEIdentityIndexValue': {'type': 'ProtocolIE-ID',
                                                           'value': 80},
                               'id-UEInformationTransfer': {'type': 'ProcedureCode',
                                                            'value': 59},
                               'id-UEPagingID': {'type': 'ProtocolIE-ID',
                                                 'value': 43},
                               'id-UERadioCapability': {'type': 'ProtocolIE-ID',
                                                        'value': 74},
                               'id-UERadioCapabilityForPaging': {'type': 'ProtocolIE-ID',
                                                                 'value': 198},
                               'id-UERadioCapabilityMatch': {'type': 'ProcedureCode',
                                                             'value': 48},
                               'id-UESecurityCapabilities': {'type': 'ProtocolIE-ID',
                                                             'value': 107},
                               'id-UESidelinkAggregateMaximumBitrate': {'type': 'ProtocolIE-ID',
                                                                        'value': 248},
                               'id-UEUserPlaneCIoTSupportIndicator': {'type': 'ProtocolIE-ID',
                                                                      'value': 241},
                               'id-UL-CP-SecurityInformation': {'type': 'ProtocolIE-ID',
                                                                'value': 254},
                               'id-ULCOUNTValueExtended': {'type': 'ProtocolIE-ID',
                                                           'value': 179},
                               'id-ULCOUNTValuePDCP-SNlength18': {'type': 'ProtocolIE-ID',
                                                                  'value': 217},
                               'id-UTRANtoLTEHOInformationRes': {'type': 'ProtocolIE-ID',
                                                                 'value': 57},
                               'id-UplinkS1cdma2000tunnelling': {'type': 'ProcedureCode',
                                                                 'value': 20},
                               'id-UserLocationInformation': {'type': 'ProtocolIE-ID',
                                                              'value': 189},
                               'id-V2XServicesAuthorized': {'type': 'ProtocolIE-ID',
                                                            'value': 240},
                               'id-VoiceSupportMatchIndicator': {'type': 'ProtocolIE-ID',
                                                                 'value': 169},
                               'id-WarningAreaList': {'type': 'ProtocolIE-ID',
                                                      'value': 113},
                               'id-WarningMessageContents': {'type': 'ProtocolIE-ID',
                                                             'value': 119},
                               'id-WarningSecurityInfo': {'type': 'ProtocolIE-ID',
                                                          'value': 117},
                               'id-WarningType': {'type': 'ProtocolIE-ID',
                                                  'value': 116},
                               'id-WriteReplaceWarning': {'type': 'ProcedureCode',
                                                          'value': 36},
                               'id-cdma2000HORequiredIndication': {'type': 'ProtocolIE-ID',
                                                                   'value': 84},
                               'id-cdma2000HOStatus': {'type': 'ProtocolIE-ID',
                                                       'value': 83},
                               'id-cdma2000OneXRAND': {'type': 'ProtocolIE-ID',
                                                       'value': 97},
                               'id-cdma2000OneXSRVCCInfo': {'type': 'ProtocolIE-ID',
                                                            'value': 102},
                               'id-cdma2000PDU': {'type': 'ProtocolIE-ID',
                                                  'value': 70},
                               'id-cdma2000RATType': {'type': 'ProtocolIE-ID',
                                                      'value': 71},
                               'id-cdma2000SectorID': {'type': 'ProtocolIE-ID',
                                                       'value': 72},
                               'id-downlinkNASTransport': {'type': 'ProcedureCode',
                                                           'value': 11},
                               'id-downlinkNonUEAssociatedLPPaTransport': {'type': 'ProcedureCode',
                                                                           'value': 46},
                               'id-downlinkUEAssociatedLPPaTransport': {'type': 'ProcedureCode',
                                                                        'value': 44},
                               'id-eNB-StatusTransfer-TransparentContainer': {'type': 'ProtocolIE-ID',
                                                                              'value': 90},
                               'id-eNB-UE-S1AP-ID': {'type': 'ProtocolIE-ID',
                                                     'value': 8},
                               'id-eNBCPRelocationIndication': {'type': 'ProcedureCode',
                                                                'value': 60},
                               'id-eNBConfigurationTransfer': {'type': 'ProcedureCode',
                                                               'value': 40},
                               'id-eNBDirectInformationTransfer': {'type': 'ProcedureCode',
                                                                   'value': 37},
                               'id-eNBIndirectX2TransportLayerAddresses': {'type': 'ProtocolIE-ID',
                                                                           'value': 193},
                               'id-eNBStatusTransfer': {'type': 'ProcedureCode',
                                                        'value': 24},
                               'id-eNBX2ExtendedTransportLayerAddresses': {'type': 'ProtocolIE-ID',
                                                                           'value': 153},
                               'id-eNBname': {'type': 'ProtocolIE-ID',
                                              'value': 60},
                               'id-extended-UEIdentityIndexValue': {'type': 'ProtocolIE-ID',
                                                                    'value': 231},
                               'id-initialUEMessage': {'type': 'ProcedureCode',
                                                       'value': 12},
                               'id-pagingDRX': {'type': 'ProtocolIE-ID',
                                                'value': 44},
                               'id-uE-HistoryInformationFromTheUE': {'type': 'ProtocolIE-ID',
                                                                     'value': 194},
                               'id-uEaggregateMaximumBitrate': {'type': 'ProtocolIE-ID',
                                                                'value': 66},
                               'id-uplinkNASTransport': {'type': 'ProcedureCode',
                                                         'value': 13},
                               'id-uplinkNonUEAssociatedLPPaTransport': {'type': 'ProcedureCode',
                                                                         'value': 47},
                               'id-uplinkUEAssociatedLPPaTransport': {'type': 'ProcedureCode',
                                                                      'value': 45},
                               'id-x2TNLConfigurationInfo': {'type': 'ProtocolIE-ID',
                                                             'value': 152},
                               'maxEARFCN': {'type': 'INTEGER',
                                             'value': 262143},
                               'maxPrivateIEs': {'type': 'INTEGER',
                                                 'value': 65535},
                               'maxProtocolExtensions': {'type': 'INTEGER',
                                                         'value': 65535},
                               'maxProtocolIEs': {'type': 'INTEGER',
                                                  'value': 65535},
                               'maxnoofBPLMNs': {'type': 'INTEGER', 'value': 6},
                               'maxnoofCSGs': {'type': 'INTEGER', 'value': 256},
                               'maxnoofCellID': {'type': 'INTEGER',
                                                 'value': 65535},
                               'maxnoofCellIDforMDT': {'type': 'INTEGER',
                                                       'value': 32},
                               'maxnoofCellinEAI': {'type': 'INTEGER',
                                                    'value': 65535},
                               'maxnoofCellinTAI': {'type': 'INTEGER',
                                                    'value': 65535},
                               'maxnoofCells': {'type': 'INTEGER', 'value': 16},
                               'maxnoofCellsforRestart': {'type': 'INTEGER',
                                                          'value': 256},
                               'maxnoofCellsineNB': {'type': 'INTEGER',
                                                     'value': 256},
                               'maxnoofDCNs': {'type': 'INTEGER', 'value': 32},
                               'maxnoofE-RABs': {'type': 'INTEGER',
                                                 'value': 256},
                               'maxnoofEPLMNs': {'type': 'INTEGER',
                                                 'value': 15},
                               'maxnoofEPLMNsPlusOne': {'type': 'INTEGER',
                                                        'value': 16},
                               'maxnoofEmergencyAreaID': {'type': 'INTEGER',
                                                          'value': 65535},
                               'maxnoofErrors': {'type': 'INTEGER',
                                                 'value': 256},
                               'maxnoofForbLACs': {'type': 'INTEGER',
                                                   'value': 4096},
                               'maxnoofForbTACs': {'type': 'INTEGER',
                                                   'value': 4096},
                               'maxnoofGroupIDs': {'type': 'INTEGER',
                                                   'value': 65535},
                               'maxnoofIndividualS1ConnectionsToReset': {'type': 'INTEGER',
                                                                         'value': 256},
                               'maxnoofMBSFNAreaMDT': {'type': 'INTEGER',
                                                       'value': 8},
                               'maxnoofMDTPLMNs': {'type': 'INTEGER',
                                                   'value': 16},
                               'maxnoofMMECs': {'type': 'INTEGER',
                                                'value': 256},
                               'maxnoofPLMNsPerMME': {'type': 'INTEGER',
                                                      'value': 32},
                               'maxnoofRATs': {'type': 'INTEGER', 'value': 8},
                               'maxnoofRecommendedCells': {'type': 'INTEGER',
                                                           'value': 16},
                               'maxnoofRecommendedENBs': {'type': 'INTEGER',
                                                          'value': 16},
                               'maxnoofRestartEmergencyAreaIDs': {'type': 'INTEGER',
                                                                  'value': 256},
                               'maxnoofRestartTAIs': {'type': 'INTEGER',
                                                      'value': 2048},
                               'maxnoofTACs': {'type': 'INTEGER', 'value': 256},
                               'maxnoofTAIforWarning': {'type': 'INTEGER',
                                                        'value': 65535},
                               'maxnoofTAIs': {'type': 'INTEGER', 'value': 256},
                               'maxnoofTAforMDT': {'type': 'INTEGER',
                                                   'value': 8},
                               'maxnoofeNBX2ExtTLAs': {'type': 'INTEGER',
                                                       'value': 16},
                               'maxnoofeNBX2GTPTLAs': {'type': 'INTEGER',
                                                       'value': 16},
                               'maxnoofeNBX2TLAs': {'type': 'INTEGER',
                                                    'value': 2}}},
 'S1AP-Containers': {'extensibility-implied': False,
                     'imports': {'S1AP-CommonDataTypes': ['Criticality',
                                                          'Presence',
                                                          'PrivateIE-ID',
                                                          'ProtocolExtensionID',
                                                          'ProtocolIE-ID'],
                                 'S1AP-Constants': ['maxPrivateIEs',
                                                    'maxProtocolExtensions',
                                                    'maxProtocolIEs']},
                     'object-classes': {'S1AP-PRIVATE-IES': {'members': [{'name': '&id',
                                                                          'type': 'PrivateIE-ID'},
                                                                         {'name': '&criticality',
                                                                          'type': 'Criticality'},
                                                                         {'name': '&Value',
                                                                          'type': 'OpenType'},
                                                                         {'name': '&presence',
                                                                          'type': 'Presence'}]},
                                        'S1AP-PROTOCOL-EXTENSION': {'members': [{'name': '&id',
                                                                                 'type': 'ProtocolExtensionID'},
                                                                                {'name': '&criticality',
                                                                                 'type': 'Criticality'},
                                                                                {'name': '&Extension',
                                                                                 'type': 'OpenType'},
                                                                                {'name': '&presence',
                                                                                 'type': 'Presence'}]},
                                        'S1AP-PROTOCOL-IES': {'members': [{'name': '&id',
                                                                           'type': 'ProtocolIE-ID'},
                                                                          {'name': '&criticality',
                                                                           'type': 'Criticality'},
                                                                          {'name': '&Value',
                                                                           'type': 'OpenType'},
                                                                          {'name': '&presence',
                                                                           'type': 'Presence'}]},
                                        'S1AP-PROTOCOL-IES-PAIR': {'members': [{'name': '&id',
                                                                                'type': 'ProtocolIE-ID'},
                                                                               {'name': '&firstCriticality',
                                                                                'type': 'Criticality'},
                                                                               {'name': '&FirstValue',
                                                                                'type': 'OpenType'},
                                                                               {'name': '&secondCriticality',
                                                                                'type': 'Criticality'},
                                                                               {'name': '&SecondValue',
                                                                                'type': 'OpenType'},
                                                                               {'name': '&presence',
                                                                                'type': 'Presence'}]}},
                     'object-sets': {},
                     'tags': 'AUTOMATIC',
                     'types': {'PrivateIE-Container': {'element': {'type': 'PrivateIE-Field'},
                                                       'size': [(1,
                                                                 'maxPrivateIEs')],
                                                       'type': 'SEQUENCE OF'},
                               'PrivateIE-Field': {'members': [{'name': 'id',
                                                                'table': {'type': 'IEsSetParam'},
                                                                'type': 'S1AP-PRIVATE-IES.&id'},
                                                               {'name': 'criticality',
                                                                'table': ['IEsSetParam',
                                                                          ['id']],
                                                                'type': 'S1AP-PRIVATE-IES.&criticality'},
                                                               {'name': 'value',
                                                                'table': ['IEsSetParam',
                                                                          ['id']],
                                                                'type': 'S1AP-PRIVATE-IES.&Value'}],
                                                   'type': 'SEQUENCE'},
                               'ProtocolExtensionContainer': {'element': {'type': 'ProtocolExtensionField'},
                                                              'size': [(1,
                                                                        'maxProtocolExtensions')],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                               'ProtocolExtensionField': {'members': [{'name': 'id',
                                                                       'table': {'type': 'ExtensionSetParam'},
                                                                       'type': 'S1AP-PROTOCOL-EXTENSION.&id'},
                                                                      {'name': 'criticality',
                                                                       'table': ['ExtensionSetParam',
                                                                                 ['id']],
                                                                       'type': 'S1AP-PROTOCOL-EXTENSION.&criticality'},
                                                                      {'name': 'extensionValue',
                                                                       'table': ['ExtensionSetParam',
                                                                                 ['id']],
                                                                       'type': 'S1AP-PROTOCOL-EXTENSION.&Extension'}],
                                                          'type': 'SEQUENCE'},
                               'ProtocolIE-Container': {'element': {'type': 'ProtocolIE-Field'},
                                                        'size': [(0,
                                                                  'maxProtocolIEs')],
                                                        'type': 'SEQUENCE OF'},
                               'ProtocolIE-ContainerList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                            'size': [('lowerBound',
                                                                      'upperBound')],
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                               'ProtocolIE-ContainerPair': {'element': {'type': 'ProtocolIE-FieldPair'},
                                                            'size': [(0,
                                                                      'maxProtocolIEs')],
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                               'ProtocolIE-ContainerPairList': {'element': {'type': 'ProtocolIE-ContainerPair'},
                                                                'size': [('lowerBound',
                                                                          'upperBound')],
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                               'ProtocolIE-Field': {'members': [{'name': 'id',
                                                                 'table': {'type': 'IEsSetParam'},
                                                                 'type': 'S1AP-PROTOCOL-IES.&id'},
                                                                {'name': 'criticality',
                                                                 'table': ['IEsSetParam',
                                                                           ['id']],
                                                                 'type': 'S1AP-PROTOCOL-IES.&criticality'},
                                                                {'name': 'value',
                                                                 'table': ['IEsSetParam',
                                                                           ['id']],
                                                                 'type': 'S1AP-PROTOCOL-IES.&Value'}],
                                                    'type': 'SEQUENCE'},
                               'ProtocolIE-FieldPair': {'members': [{'name': 'id',
                                                                     'table': {'type': 'IEsSetParam'},
                                                                     'type': 'S1AP-PROTOCOL-IES-PAIR.&id'},
                                                                    {'name': 'firstCriticality',
                                                                     'table': ['IEsSetParam',
                                                                               ['id']],
                                                                     'type': 'S1AP-PROTOCOL-IES-PAIR.&firstCriticality'},
                                                                    {'name': 'firstValue',
                                                                     'table': ['IEsSetParam',
                                                                               ['id']],
                                                                     'type': 'S1AP-PROTOCOL-IES-PAIR.&FirstValue'},
                                                                    {'name': 'secondCriticality',
                                                                     'table': ['IEsSetParam',
                                                                               ['id']],
                                                                     'type': 'S1AP-PROTOCOL-IES-PAIR.&secondCriticality'},
                                                                    {'name': 'secondValue',
                                                                     'table': ['IEsSetParam',
                                                                               ['id']],
                                                                     'type': 'S1AP-PROTOCOL-IES-PAIR.&SecondValue'}],
                                                        'type': 'SEQUENCE'},
                               'ProtocolIE-SingleContainer': {'type': 'ProtocolIE-Field'}},
                     'values': {}},
 'S1AP-IEs': {'extensibility-implied': False,
              'imports': {'S1AP-CommonDataTypes': ['Criticality',
                                                   'ProcedureCode',
                                                   'ProtocolIE-ID',
                                                   'TriggeringMessage'],
                          'S1AP-Constants': ['id-E-RABInformationListItem',
                                             'id-E-RABItem',
                                             'id-Bearers-SubjectToStatusTransfer-Item',
                                             'id-Time-Synchronisation-Info',
                                             'id-x2TNLConfigurationInfo',
                                             'id-eNBX2ExtendedTransportLayerAddresses',
                                             'id-MDTConfiguration',
                                             'id-Time-UE-StayedInCell-EnhancedGranularity',
                                             'id-HO-Cause',
                                             'id-M3Configuration',
                                             'id-M4Configuration',
                                             'id-M5Configuration',
                                             'id-MDT-Location-Info',
                                             'id-SignallingBasedMDTPLMNList',
                                             'id-MobilityInformation',
                                             'id-ULCOUNTValueExtended',
                                             'id-DLCOUNTValueExtended',
                                             'id-ReceiveStatusOfULPDCPSDUsExtended',
                                             'id-eNBIndirectX2TransportLayerAddresses',
                                             'id-Muting-Availability-Indication',
                                             'id-Muting-Pattern-Information',
                                             'id-Synchronisation-Information',
                                             'id-uE-HistoryInformationFromTheUE',
                                             'id-LoggedMBSFNMDT',
                                             'id-SON-Information-Report',
                                             'id-RecommendedCellItem',
                                             'id-RecommendedENBItem',
                                             'id-ProSeUEtoNetworkRelaying',
                                             'id-ULCOUNTValuePDCP-SNlength18',
                                             'id-DLCOUNTValuePDCP-SNlength18',
                                             'id-ReceiveStatusOfULPDCPSDUsPDCP-SNlength18',
                                             'id-M6Configuration',
                                             'id-M7Configuration',
                                             'id-RAT-Type',
                                             'maxnoofCSGs',
                                             'maxnoofE-RABs',
                                             'maxnoofErrors',
                                             'maxnoofBPLMNs',
                                             'maxnoofPLMNsPerMME',
                                             'maxnoofTACs',
                                             'maxnoofEPLMNs',
                                             'maxnoofEPLMNsPlusOne',
                                             'maxnoofForbLACs',
                                             'maxnoofForbTACs',
                                             'maxnoofCells',
                                             'maxnoofCellID',
                                             'maxnoofDCNs',
                                             'maxnoofEmergencyAreaID',
                                             'maxnoofTAIforWarning',
                                             'maxnoofCellinTAI',
                                             'maxnoofCellinEAI',
                                             'maxnoofeNBX2TLAs',
                                             'maxnoofeNBX2ExtTLAs',
                                             'maxnoofeNBX2GTPTLAs',
                                             'maxnoofRATs',
                                             'maxnoofGroupIDs',
                                             'maxnoofMMECs',
                                             'maxnoofTAforMDT',
                                             'maxnoofCellIDforMDT',
                                             'maxnoofMDTPLMNs',
                                             'maxnoofCellsforRestart',
                                             'maxnoofRestartTAIs',
                                             'maxnoofRestartEmergencyAreaIDs',
                                             'maxnoofMBSFNAreaMDT',
                                             'maxEARFCN',
                                             'maxnoofCellsineNB',
                                             'maxnoofRecommendedCells',
                                             'maxnoofRecommendedENBs'],
                          'S1AP-Containers': ['ProtocolExtensionContainer',
                                              '{',
                                              '}',
                                              'S1AP-PROTOCOL-EXTENSION',
                                              'ProtocolIE-SingleContainer',
                                              '{',
                                              '}',
                                              'S1AP-PROTOCOL-IES']},
              'object-classes': {},
              'object-sets': {'Additional-GUTI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'AllocationAndRetentionPriority-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                        'members': ['.']},
                              'AssistanceDataForPaging-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'AssistanceDataForRecommendedCells-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                           'members': ['.']},
                              'Bearers-SubjectToStatusTransfer-ItemExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                             'members': []},
                              'Bearers-SubjectToStatusTransfer-ItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                          'members': []},
                              'CGI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                             'members': ['.']},
                              'COUNTValueExtended-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'COUNTvalue-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                    'members': ['.']},
                              'COUNTvaluePDCP-SNlength18-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                   'members': ['.']},
                              'CSG-IdList-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'CancelledCellinEAI-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'CancelledCellinTAI-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'Cdma2000OneXSRVCCInfo-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                               'members': ['.']},
                              'CellBasedMDT-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                      'members': ['.']},
                              'CellID-Broadcast-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                               'members': ['.']},
                              'CellID-Cancelled-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                               'members': ['.']},
                              'CellIdentifierAndCELevelForCECapableUEs-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                 'members': ['.']},
                              'CellType-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                  'members': ['.']},
                              'CompletedCellinEAI-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'CompletedCellinTAI-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'CriticalityDiagnostics-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                'members': ['.']},
                              'CriticalityDiagnostics-IE-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                        'members': ['.']},
                              'DL-CP-SecurityInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                   'members': ['.']},
                              'E-RABInformationListIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                          'members': []},
                              'E-RABInformationListItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                  'members': ['.']},
                              'E-RABItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                   'members': ['.']},
                              'E-RABItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                               'members': []},
                              'E-RABQoSParameters-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'ENB-StatusTransfer-TransparentContainer-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                 'members': ['.']},
                              'ENBX2ExtTLA-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                     'members': ['.']},
                              'EUTRAN-CGI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                    'members': ['.']},
                              'EmergencyAreaID-Broadcast-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                        'members': ['.']},
                              'EmergencyAreaID-Cancelled-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                        'members': ['.']},
                              'ExpectedUEActivityBehaviour-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                     'members': ['.']},
                              'ExpectedUEBehaviour-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                             'members': ['.']},
                              'ForbiddenLAs-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                           'members': ['.']},
                              'ForbiddenTAs-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                           'members': ['.']},
                              'GBR-QosInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'GERAN-Cell-ID-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                       'members': ['.']},
                              'GUMMEI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                'members': ['.']},
                              'GlobalENB-ID-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                      'members': ['.']},
                              'HandoverRestrictionList-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'ImmediateMDT-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                      'members': []},
                              'InformationForCECapableUEs-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                    'members': ['.']},
                              'InformationOnRecommendedCellsAndENBsForPaging-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                       'members': ['.']},
                              'LAI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                             'members': ['.']},
                              'LastVisitedEUTRANCellInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                          'members': []},
                              'ListeningSubframePattern-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                  'members': ['.']},
                              'LoggedMBSFNMDT-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                        'members': ['.']},
                              'LoggedMDT-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                   'members': ['.']},
                              'M1PeriodicReporting-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                             'members': ['.']},
                              'M1ThresholdEventA2-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'M3Configuration-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'M4Configuration-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'M5Configuration-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'M6Configuration-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'M7Configuration-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'MBSFN-ResultToLogInfo-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                               'members': ['.']},
                              'MDT-Configuration-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                           'members': []},
                              'MDTMode-ExtensionIE': {'class': 'S1AP-PROTOCOL-IES',
                                                      'members': []},
                              'MutingPatternInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                  'members': ['.']},
                              'NB-IoT-Paging-eDRXInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                       'members': ['.']},
                              'Paging-eDRXInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                'members': ['.']},
                              'PagingAttemptInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                  'members': ['.']},
                              'ProSeAuthorized-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': []},
                              'RIMTransfer-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                     'members': ['.']},
                              'RLFReportInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                              'members': ['.']},
                              'RecommendedCellItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                         'members': []},
                              'RecommendedCellsForPaging-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                   'members': ['.']},
                              'RecommendedCellsForPagingItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                       'members': ['.']},
                              'RecommendedENBItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'RecommendedENBItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                        'members': []},
                              'RecommendedENBsForPaging-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                  'members': ['.']},
                              'RequestType-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                     'members': ['.']},
                              'S-TMSI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                'members': ['.']},
                              'SONConfigurationTransfer-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                  'members': []},
                              'SONInformation-ExtensionIE': {'class': 'S1AP-PROTOCOL-IES',
                                                             'members': []},
                              'SONInformationReply-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                             'members': []},
                              'SecurityContext-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'ServedDCNsItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                        'members': ['.']},
                              'ServedGUMMEIsItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                           'members': ['.']},
                              'SourceeNB-ID-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                      'members': ['.']},
                              'SourceeNB-ToTargeteNB-TransparentContainer-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                    'members': []},
                              'SupportedTAs-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                           'members': []},
                              'SynchronisationInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                    'members': ['.']},
                              'TABasedMDT-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                    'members': ['.']},
                              'TAI-Broadcast-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'TAI-Cancelled-Item-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'TAI-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                             'members': ['.']},
                              'TAIBasedMDT-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                     'members': ['.']},
                              'TargetRNC-ID-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                      'members': ['.']},
                              'TargeteNB-ID-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                      'members': ['.']},
                              'TargeteNB-ToSourceeNB-TransparentContainer-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                    'members': ['.']},
                              'TimeSynchronisationInfo-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': []},
                              'TraceActivation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': []},
                              'Tunnel-Information-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                            'members': ['.']},
                              'UE-S1AP-ID-pair-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                              'UE-Sidelink-Aggregate-MaximumBitrates-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                               'members': ['.']},
                              'UE-associatedLogicalS1-ConnectionItemExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                              'members': ['.']},
                              'UEAggregate-MaximumBitrates-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                     'members': ['.']},
                              'UESecurityCapabilities-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                'members': ['.']},
                              'UL-CP-SecurityInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                   'members': ['.']},
                              'UserLocationInformation-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                 'members': ['.']},
                              'V2XServicesAuthorized-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                               'members': ['.']},
                              'X2TNLConfigurationInfo-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                'members': []}},
              'tags': 'AUTOMATIC',
              'types': {'Additional-GUTI': {'members': [{'name': 'gUMMEI',
                                                         'type': 'GUMMEI'},
                                                        {'name': 'm-TMSI',
                                                         'type': 'M-TMSI'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'AdditionalCSFallbackIndicator': {'type': 'ENUMERATED',
                                                          'values': [('no-restriction',
                                                                      0),
                                                                     ('restriction',
                                                                      1),
                                                                     None]},
                        'AllocationAndRetentionPriority': {'members': [{'name': 'priorityLevel',
                                                                        'type': 'PriorityLevel'},
                                                                       {'name': 'pre-emptionCapability',
                                                                        'type': 'Pre-emptionCapability'},
                                                                       {'name': 'pre-emptionVulnerability',
                                                                        'type': 'Pre-emptionVulnerability'},
                                                                       {'name': 'iE-Extensions',
                                                                        'optional': True,
                                                                        'type': 'ProtocolExtensionContainer'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                        'AreaScopeOfMDT': {'members': [{'name': 'cellBased',
                                                        'type': 'CellBasedMDT'},
                                                       {'name': 'tABased',
                                                        'type': 'TABasedMDT'},
                                                       {'name': 'pLMNWide',
                                                        'type': 'NULL'},
                                                       None,
                                                       {'name': 'tAIBased',
                                                        'type': 'TAIBasedMDT'}],
                                           'type': 'CHOICE'},
                        'AssistanceDataForCECapableUEs': {'members': [{'name': 'cellIdentifierAndCELevelForCECapableUEs',
                                                                       'type': 'CellIdentifierAndCELevelForCECapableUEs'},
                                                                      {'name': 'iE-Extensions',
                                                                       'optional': True,
                                                                       'type': 'ProtocolExtensionContainer'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                        'AssistanceDataForPaging': {'members': [{'name': 'assistanceDataForRecommendedCells',
                                                                 'optional': True,
                                                                 'type': 'AssistanceDataForRecommendedCells'},
                                                                {'name': 'assistanceDataForCECapableUEs',
                                                                 'optional': True,
                                                                 'type': 'AssistanceDataForCECapableUEs'},
                                                                {'name': 'pagingAttemptInformation',
                                                                 'optional': True,
                                                                 'type': 'PagingAttemptInformation'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'AssistanceDataForRecommendedCells': {'members': [{'name': 'recommendedCellsForPaging',
                                                                           'type': 'RecommendedCellsForPaging'},
                                                                          {'name': 'iE-Extensions',
                                                                           'optional': True,
                                                                           'type': 'ProtocolExtensionContainer'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                        'BPLMNs': {'element': {'type': 'PLMNidentity'},
                                   'size': [(1, 'maxnoofBPLMNs')],
                                   'type': 'SEQUENCE OF'},
                        'BearerType': {'type': 'ENUMERATED',
                                       'values': [('non-IP', 0), None]},
                        'Bearers-SubjectToStatusTransfer-Item': {'members': [{'name': 'e-RAB-ID',
                                                                              'type': 'E-RAB-ID'},
                                                                             {'name': 'uL-COUNTvalue',
                                                                              'type': 'COUNTvalue'},
                                                                             {'name': 'dL-COUNTvalue',
                                                                              'type': 'COUNTvalue'},
                                                                             {'name': 'receiveStatusofULPDCPSDUs',
                                                                              'optional': True,
                                                                              'type': 'ReceiveStatusofULPDCPSDUs'},
                                                                             {'name': 'iE-Extensions',
                                                                              'optional': True,
                                                                              'type': 'ProtocolExtensionContainer'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                        'Bearers-SubjectToStatusTransferList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                'size': [(1,
                                                                          'maxnoofE-RABs')],
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                        'BitRate': {'restricted-to': [(0, 10000000000)],
                                    'type': 'INTEGER'},
                        'BroadcastCancelledAreaList': {'members': [{'name': 'cellID-Cancelled',
                                                                    'type': 'CellID-Cancelled'},
                                                                   {'name': 'tAI-Cancelled',
                                                                    'type': 'TAI-Cancelled'},
                                                                   {'name': 'emergencyAreaID-Cancelled',
                                                                    'type': 'EmergencyAreaID-Cancelled'},
                                                                   None],
                                                       'type': 'CHOICE'},
                        'BroadcastCompletedAreaList': {'members': [{'name': 'cellID-Broadcast',
                                                                    'type': 'CellID-Broadcast'},
                                                                   {'name': 'tAI-Broadcast',
                                                                    'type': 'TAI-Broadcast'},
                                                                   {'name': 'emergencyAreaID-Broadcast',
                                                                    'type': 'EmergencyAreaID-Broadcast'},
                                                                   None],
                                                       'type': 'CHOICE'},
                        'CE-mode-B-SupportIndicator': {'type': 'ENUMERATED',
                                                       'values': [('supported',
                                                                   0),
                                                                  None]},
                        'CELevel': {'type': 'OCTET STRING'},
                        'CGI': {'members': [{'name': 'pLMNidentity',
                                             'type': 'PLMNidentity'},
                                            {'name': 'lAC', 'type': 'LAC'},
                                            {'name': 'cI', 'type': 'CI'},
                                            {'name': 'rAC',
                                             'optional': True,
                                             'type': 'RAC'},
                                            {'name': 'iE-Extensions',
                                             'optional': True,
                                             'type': 'ProtocolExtensionContainer'},
                                            None],
                                'type': 'SEQUENCE'},
                        'CI': {'size': [2], 'type': 'OCTET STRING'},
                        'CNDomain': {'type': 'ENUMERATED',
                                     'values': [('ps', 0), ('cs', 1)]},
                        'COUNTValueExtended': {'members': [{'name': 'pDCP-SNExtended',
                                                            'type': 'PDCP-SNExtended'},
                                                           {'name': 'hFNModified',
                                                            'type': 'HFNModified'},
                                                           {'name': 'iE-Extensions',
                                                            'optional': True,
                                                            'type': 'ProtocolExtensionContainer'},
                                                           None],
                                               'type': 'SEQUENCE'},
                        'COUNTvalue': {'members': [{'name': 'pDCP-SN',
                                                    'type': 'PDCP-SN'},
                                                   {'name': 'hFN',
                                                    'type': 'HFN'},
                                                   {'name': 'iE-Extensions',
                                                    'optional': True,
                                                    'type': 'ProtocolExtensionContainer'},
                                                   None],
                                       'type': 'SEQUENCE'},
                        'COUNTvaluePDCP-SNlength18': {'members': [{'name': 'pDCP-SNlength18',
                                                                   'type': 'PDCP-SNlength18'},
                                                                  {'name': 'hFNforPDCP-SNlength18',
                                                                   'type': 'HFNforPDCP-SNlength18'},
                                                                  {'name': 'iE-Extensions',
                                                                   'optional': True,
                                                                   'type': 'ProtocolExtensionContainer'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                        'CSFallbackIndicator': {'type': 'ENUMERATED',
                                                'values': [('cs-fallback-required',
                                                            0),
                                                           None,
                                                           ('cs-fallback-high-priority',
                                                            1)]},
                        'CSG-Id': {'size': [27], 'type': 'BIT STRING'},
                        'CSG-IdList': {'element': {'type': 'CSG-IdList-Item'},
                                       'size': [(1, 'maxnoofCSGs')],
                                       'type': 'SEQUENCE OF'},
                        'CSG-IdList-Item': {'members': [{'name': 'cSG-Id',
                                                         'type': 'CSG-Id'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'CSGMembershipStatus': {'type': 'ENUMERATED',
                                                'values': [('member', 0),
                                                           ('not-member', 1)]},
                        'CancelledCellinEAI': {'element': {'type': 'CancelledCellinEAI-Item'},
                                               'size': [(1,
                                                         'maxnoofCellinEAI')],
                                               'type': 'SEQUENCE OF'},
                        'CancelledCellinEAI-Item': {'members': [{'name': 'eCGI',
                                                                 'type': 'EUTRAN-CGI'},
                                                                {'name': 'numberOfBroadcasts',
                                                                 'type': 'NumberOfBroadcasts'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'CancelledCellinTAI': {'element': {'type': 'CancelledCellinTAI-Item'},
                                               'size': [(1,
                                                         'maxnoofCellinTAI')],
                                               'type': 'SEQUENCE OF'},
                        'CancelledCellinTAI-Item': {'members': [{'name': 'eCGI',
                                                                 'type': 'EUTRAN-CGI'},
                                                                {'name': 'numberOfBroadcasts',
                                                                 'type': 'NumberOfBroadcasts'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'Cause': {'members': [{'name': 'radioNetwork',
                                               'type': 'CauseRadioNetwork'},
                                              {'name': 'transport',
                                               'type': 'CauseTransport'},
                                              {'name': 'nas',
                                               'type': 'CauseNas'},
                                              {'name': 'protocol',
                                               'type': 'CauseProtocol'},
                                              {'name': 'misc',
                                               'type': 'CauseMisc'},
                                              None],
                                  'type': 'CHOICE'},
                        'CauseMisc': {'type': 'ENUMERATED',
                                      'values': [('control-processing-overload',
                                                  0),
                                                 ('not-enough-user-plane-processing-resources',
                                                  1),
                                                 ('hardware-failure', 2),
                                                 ('om-intervention', 3),
                                                 ('unspecified', 4),
                                                 ('unknown-PLMN', 5),
                                                 None]},
                        'CauseNas': {'type': 'ENUMERATED',
                                     'values': [('normal-release', 0),
                                                ('authentication-failure', 1),
                                                ('detach', 2),
                                                ('unspecified', 3),
                                                None,
                                                ('csg-subscription-expiry',
                                                 4)]},
                        'CauseProtocol': {'type': 'ENUMERATED',
                                          'values': [('transfer-syntax-error',
                                                      0),
                                                     ('abstract-syntax-error-reject',
                                                      1),
                                                     ('abstract-syntax-error-ignore-and-notify',
                                                      2),
                                                     ('message-not-compatible-with-receiver-state',
                                                      3),
                                                     ('semantic-error', 4),
                                                     ('abstract-syntax-error-falsely-constructed-message',
                                                      5),
                                                     ('unspecified', 6),
                                                     None]},
                        'CauseRadioNetwork': {'type': 'ENUMERATED',
                                              'values': [('unspecified', 0),
                                                         ('tx2relocoverall-expiry',
                                                          1),
                                                         ('successful-handover',
                                                          2),
                                                         ('release-due-to-eutran-generated-reason',
                                                          3),
                                                         ('handover-cancelled',
                                                          4),
                                                         ('partial-handover',
                                                          5),
                                                         ('ho-failure-in-target-EPC-eNB-or-target-system',
                                                          6),
                                                         ('ho-target-not-allowed',
                                                          7),
                                                         ('tS1relocoverall-expiry',
                                                          8),
                                                         ('tS1relocprep-expiry',
                                                          9),
                                                         ('cell-not-available',
                                                          10),
                                                         ('unknown-targetID',
                                                          11),
                                                         ('no-radio-resources-available-in-target-cell',
                                                          12),
                                                         ('unknown-mme-ue-s1ap-id',
                                                          13),
                                                         ('unknown-enb-ue-s1ap-id',
                                                          14),
                                                         ('unknown-pair-ue-s1ap-id',
                                                          15),
                                                         ('handover-desirable-for-radio-reason',
                                                          16),
                                                         ('time-critical-handover',
                                                          17),
                                                         ('resource-optimisation-handover',
                                                          18),
                                                         ('reduce-load-in-serving-cell',
                                                          19),
                                                         ('user-inactivity',
                                                          20),
                                                         ('radio-connection-with-ue-lost',
                                                          21),
                                                         ('load-balancing-tau-required',
                                                          22),
                                                         ('cs-fallback-triggered',
                                                          23),
                                                         ('ue-not-available-for-ps-service',
                                                          24),
                                                         ('radio-resources-not-available',
                                                          25),
                                                         ('failure-in-radio-interface-procedure',
                                                          26),
                                                         ('invalid-qos-combination',
                                                          27),
                                                         ('interrat-redirection',
                                                          28),
                                                         ('interaction-with-other-procedure',
                                                          29),
                                                         ('unknown-E-RAB-ID',
                                                          30),
                                                         ('multiple-E-RAB-ID-instances',
                                                          31),
                                                         ('encryption-and-or-integrity-protection-algorithms-not-supported',
                                                          32),
                                                         ('s1-intra-system-handover-triggered',
                                                          33),
                                                         ('s1-inter-system-handover-triggered',
                                                          34),
                                                         ('x2-handover-triggered',
                                                          35),
                                                         None,
                                                         ('redirection-towards-1xRTT',
                                                          36),
                                                         ('not-supported-QCI-value',
                                                          37),
                                                         ('invalid-CSG-Id', 38),
                                                         ('release-due-to-pre-emption',
                                                          39)]},
                        'CauseTransport': {'type': 'ENUMERATED',
                                           'values': [('transport-resource-unavailable',
                                                       0),
                                                      ('unspecified', 1),
                                                      None]},
                        'Cdma2000HORequiredIndication': {'type': 'ENUMERATED',
                                                         'values': [('true', 0),
                                                                    None]},
                        'Cdma2000HOStatus': {'type': 'ENUMERATED',
                                             'values': [('hOSuccess', 0),
                                                        ('hOFailure', 1),
                                                        None]},
                        'Cdma2000OneXMEID': {'type': 'OCTET STRING'},
                        'Cdma2000OneXMSI': {'type': 'OCTET STRING'},
                        'Cdma2000OneXPilot': {'type': 'OCTET STRING'},
                        'Cdma2000OneXRAND': {'type': 'OCTET STRING'},
                        'Cdma2000OneXSRVCCInfo': {'members': [{'name': 'cdma2000OneXMEID',
                                                               'type': 'Cdma2000OneXMEID'},
                                                              {'name': 'cdma2000OneXMSI',
                                                               'type': 'Cdma2000OneXMSI'},
                                                              {'name': 'cdma2000OneXPilot',
                                                               'type': 'Cdma2000OneXPilot'},
                                                              {'name': 'iE-Extensions',
                                                               'optional': True,
                                                               'type': 'ProtocolExtensionContainer'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                        'Cdma2000PDU': {'type': 'OCTET STRING'},
                        'Cdma2000RATType': {'type': 'ENUMERATED',
                                            'values': [('hRPD', 0),
                                                       ('onexRTT', 1),
                                                       None]},
                        'Cdma2000SectorID': {'type': 'OCTET STRING'},
                        'Cell-Size': {'type': 'ENUMERATED',
                                      'values': [('verysmall', 0),
                                                 ('small', 1),
                                                 ('medium', 2),
                                                 ('large', 3),
                                                 None]},
                        'CellAccessMode': {'type': 'ENUMERATED',
                                           'values': [('hybrid', 0), None]},
                        'CellBasedMDT': {'members': [{'name': 'cellIdListforMDT',
                                                      'type': 'CellIdListforMDT'},
                                                     {'name': 'iE-Extensions',
                                                      'optional': True,
                                                      'type': 'ProtocolExtensionContainer'},
                                                     None],
                                         'type': 'SEQUENCE'},
                        'CellID-Broadcast': {'element': {'type': 'CellID-Broadcast-Item'},
                                             'size': [(1, 'maxnoofCellID')],
                                             'type': 'SEQUENCE OF'},
                        'CellID-Broadcast-Item': {'members': [{'name': 'eCGI',
                                                               'type': 'EUTRAN-CGI'},
                                                              {'name': 'iE-Extensions',
                                                               'optional': True,
                                                               'type': 'ProtocolExtensionContainer'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                        'CellID-Cancelled': {'element': {'type': 'CellID-Cancelled-Item'},
                                             'size': [(1, 'maxnoofCellID')],
                                             'type': 'SEQUENCE OF'},
                        'CellID-Cancelled-Item': {'members': [{'name': 'eCGI',
                                                               'type': 'EUTRAN-CGI'},
                                                              {'name': 'numberOfBroadcasts',
                                                               'type': 'NumberOfBroadcasts'},
                                                              {'name': 'iE-Extensions',
                                                               'optional': True,
                                                               'type': 'ProtocolExtensionContainer'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                        'CellIdListforMDT': {'element': {'type': 'EUTRAN-CGI'},
                                             'size': [(1,
                                                       'maxnoofCellIDforMDT')],
                                             'type': 'SEQUENCE OF'},
                        'CellIdentifierAndCELevelForCECapableUEs': {'members': [{'name': 'global-Cell-ID',
                                                                                 'type': 'EUTRAN-CGI'},
                                                                                {'name': 'cELevel',
                                                                                 'type': 'CELevel'},
                                                                                {'name': 'iE-Extensions',
                                                                                 'optional': True,
                                                                                 'type': 'ProtocolExtensionContainer'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                        'CellIdentity': {'size': [28], 'type': 'BIT STRING'},
                        'CellType': {'members': [{'name': 'cell-Size',
                                                  'type': 'Cell-Size'},
                                                 {'name': 'iE-Extensions',
                                                  'optional': True,
                                                  'type': 'ProtocolExtensionContainer'},
                                                 None],
                                     'type': 'SEQUENCE'},
                        'CompletedCellinEAI': {'element': {'type': 'CompletedCellinEAI-Item'},
                                               'size': [(1,
                                                         'maxnoofCellinEAI')],
                                               'type': 'SEQUENCE OF'},
                        'CompletedCellinEAI-Item': {'members': [{'name': 'eCGI',
                                                                 'type': 'EUTRAN-CGI'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'CompletedCellinTAI': {'element': {'type': 'CompletedCellinTAI-Item'},
                                               'size': [(1,
                                                         'maxnoofCellinTAI')],
                                               'type': 'SEQUENCE OF'},
                        'CompletedCellinTAI-Item': {'members': [{'name': 'eCGI',
                                                                 'type': 'EUTRAN-CGI'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'ConcurrentWarningMessageIndicator': {'type': 'ENUMERATED',
                                                              'values': [('true',
                                                                          0)]},
                        'Correlation-ID': {'size': [4], 'type': 'OCTET STRING'},
                        'Coverage-Level': {'type': 'ENUMERATED',
                                           'values': [('extendedcoverage', 0),
                                                      None]},
                        'CriticalityDiagnostics': {'members': [{'name': 'procedureCode',
                                                                'optional': True,
                                                                'type': 'ProcedureCode'},
                                                               {'name': 'triggeringMessage',
                                                                'optional': True,
                                                                'type': 'TriggeringMessage'},
                                                               {'name': 'procedureCriticality',
                                                                'optional': True,
                                                                'type': 'Criticality'},
                                                               {'name': 'iEsCriticalityDiagnostics',
                                                                'optional': True,
                                                                'type': 'CriticalityDiagnostics-IE-List'},
                                                               {'name': 'iE-Extensions',
                                                                'optional': True,
                                                                'type': 'ProtocolExtensionContainer'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                        'CriticalityDiagnostics-IE-Item': {'members': [{'name': 'iECriticality',
                                                                        'type': 'Criticality'},
                                                                       {'name': 'iE-ID',
                                                                        'type': 'ProtocolIE-ID'},
                                                                       {'name': 'typeOfError',
                                                                        'type': 'TypeOfError'},
                                                                       {'name': 'iE-Extensions',
                                                                        'optional': True,
                                                                        'type': 'ProtocolExtensionContainer'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                        'CriticalityDiagnostics-IE-List': {'element': {'type': 'CriticalityDiagnostics-IE-Item'},
                                                           'size': [(1,
                                                                     'maxnoofErrors')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                        'DCN-ID': {'restricted-to': [(0, 65535)],
                                   'type': 'INTEGER'},
                        'DL-CP-SecurityInformation': {'members': [{'name': 'dl-NAS-MAC',
                                                                   'type': 'DL-NAS-MAC'},
                                                                  {'name': 'iE-Extensions',
                                                                   'optional': True,
                                                                   'type': 'ProtocolExtensionContainer'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                        'DL-Forwarding': {'type': 'ENUMERATED',
                                          'values': [('dL-Forwarding-proposed',
                                                      0),
                                                     None]},
                        'DL-NAS-MAC': {'size': [16], 'type': 'BIT STRING'},
                        'DLNASPDUDeliveryAckRequest': {'type': 'ENUMERATED',
                                                       'values': [('requested',
                                                                   0),
                                                                  None]},
                        'Data-Forwarding-Not-Possible': {'type': 'ENUMERATED',
                                                         'values': [('data-Forwarding-not-Possible',
                                                                     0),
                                                                    None]},
                        'DataCodingScheme': {'size': [8], 'type': 'BIT STRING'},
                        'Direct-Forwarding-Path-Availability': {'type': 'ENUMERATED',
                                                                'values': [('directPathAvailable',
                                                                            0),
                                                                           None]},
                        'E-RAB-ID': {'restricted-to': [(0, 15), None],
                                     'type': 'INTEGER'},
                        'E-RABInformationList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                 'size': [(1, 'maxnoofE-RABs')],
                                                 'type': 'SEQUENCE OF'},
                        'E-RABInformationListItem': {'members': [{'name': 'e-RAB-ID',
                                                                  'type': 'E-RAB-ID'},
                                                                 {'name': 'dL-Forwarding',
                                                                  'optional': True,
                                                                  'type': 'DL-Forwarding'},
                                                                 {'name': 'iE-Extensions',
                                                                  'optional': True,
                                                                  'type': 'ProtocolExtensionContainer'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                        'E-RABItem': {'members': [{'name': 'e-RAB-ID',
                                                   'type': 'E-RAB-ID'},
                                                  {'name': 'cause',
                                                   'type': 'Cause'},
                                                  {'name': 'iE-Extensions',
                                                   'optional': True,
                                                   'type': 'ProtocolExtensionContainer'},
                                                  None],
                                      'type': 'SEQUENCE'},
                        'E-RABLevelQoSParameters': {'members': [{'name': 'qCI',
                                                                 'type': 'QCI'},
                                                                {'name': 'allocationRetentionPriority',
                                                                 'type': 'AllocationAndRetentionPriority'},
                                                                {'name': 'gbrQosInformation',
                                                                 'optional': True,
                                                                 'type': 'GBR-QosInformation'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'E-RABList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                      'size': [(1, 'maxnoofE-RABs')],
                                      'type': 'SEQUENCE OF'},
                        'E-UTRAN-Trace-ID': {'size': [8],
                                             'type': 'OCTET STRING'},
                        'EARFCN': {'restricted-to': [(0, 'maxEARFCN'), None],
                                   'type': 'INTEGER'},
                        'ECGI-List': {'element': {'type': 'EUTRAN-CGI'},
                                      'size': [(1, 'maxnoofCellsineNB')],
                                      'type': 'SEQUENCE OF'},
                        'ECGIList': {'element': {'type': 'EUTRAN-CGI'},
                                     'size': [(1, 'maxnoofCellID')],
                                     'type': 'SEQUENCE OF'},
                        'ECGIListForRestart': {'element': {'type': 'EUTRAN-CGI'},
                                               'size': [(1,
                                                         'maxnoofCellsforRestart')],
                                               'type': 'SEQUENCE OF'},
                        'ENB-ID': {'members': [{'name': 'macroENB-ID',
                                                'size': [20],
                                                'type': 'BIT STRING'},
                                               {'name': 'homeENB-ID',
                                                'size': [28],
                                                'type': 'BIT STRING'},
                                               None,
                                               {'name': 'short-macroENB-ID',
                                                'size': [18],
                                                'type': 'BIT STRING'},
                                               {'name': 'long-macroENB-ID',
                                                'size': [21],
                                                'type': 'BIT STRING'}],
                                   'type': 'CHOICE'},
                        'ENB-StatusTransfer-TransparentContainer': {'members': [{'name': 'bearers-SubjectToStatusTransferList',
                                                                                 'type': 'Bearers-SubjectToStatusTransferList'},
                                                                                {'name': 'iE-Extensions',
                                                                                 'optional': True,
                                                                                 'type': 'ProtocolExtensionContainer'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                        'ENB-UE-S1AP-ID': {'restricted-to': [(0, 16777215)],
                                           'type': 'INTEGER'},
                        'ENBIndirectX2TransportLayerAddresses': {'element': {'type': 'TransportLayerAddress'},
                                                                 'size': [(1,
                                                                           'maxnoofeNBX2TLAs')],
                                                                 'type': 'SEQUENCE '
                                                                         'OF'},
                        'ENBX2ExtTLA': {'members': [{'name': 'iPsecTLA',
                                                     'optional': True,
                                                     'type': 'TransportLayerAddress'},
                                                    {'name': 'gTPTLAa',
                                                     'optional': True,
                                                     'type': 'ENBX2GTPTLAs'},
                                                    {'name': 'iE-Extensions',
                                                     'optional': True,
                                                     'type': 'ProtocolExtensionContainer'},
                                                    None],
                                        'type': 'SEQUENCE'},
                        'ENBX2ExtTLAs': {'element': {'type': 'ENBX2ExtTLA'},
                                         'size': [(1, 'maxnoofeNBX2ExtTLAs')],
                                         'type': 'SEQUENCE OF'},
                        'ENBX2GTPTLAs': {'element': {'type': 'TransportLayerAddress'},
                                         'size': [(1, 'maxnoofeNBX2GTPTLAs')],
                                         'type': 'SEQUENCE OF'},
                        'ENBX2TLAs': {'element': {'type': 'TransportLayerAddress'},
                                      'size': [(1, 'maxnoofeNBX2TLAs')],
                                      'type': 'SEQUENCE OF'},
                        'ENBname': {'size': [(1, 150), None],
                                    'type': 'PrintableString'},
                        'EPLMNs': {'element': {'type': 'PLMNidentity'},
                                   'size': [(1, 'maxnoofEPLMNs')],
                                   'type': 'SEQUENCE OF'},
                        'EUTRAN-CGI': {'members': [{'name': 'pLMNidentity',
                                                    'type': 'PLMNidentity'},
                                                   {'name': 'cell-ID',
                                                    'type': 'CellIdentity'},
                                                   {'name': 'iE-Extensions',
                                                    'optional': True,
                                                    'type': 'ProtocolExtensionContainer'},
                                                   None],
                                       'type': 'SEQUENCE'},
                        'EUTRANRoundTripDelayEstimationInfo': {'restricted-to': [(0,
                                                                                  2047)],
                                                               'type': 'INTEGER'},
                        'EmergencyAreaID': {'size': [3],
                                            'type': 'OCTET STRING'},
                        'EmergencyAreaID-Broadcast': {'element': {'type': 'EmergencyAreaID-Broadcast-Item'},
                                                      'size': [(1,
                                                                'maxnoofEmergencyAreaID')],
                                                      'type': 'SEQUENCE OF'},
                        'EmergencyAreaID-Broadcast-Item': {'members': [{'name': 'emergencyAreaID',
                                                                        'type': 'EmergencyAreaID'},
                                                                       {'name': 'completedCellinEAI',
                                                                        'type': 'CompletedCellinEAI'},
                                                                       {'name': 'iE-Extensions',
                                                                        'optional': True,
                                                                        'type': 'ProtocolExtensionContainer'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                        'EmergencyAreaID-Cancelled': {'element': {'type': 'EmergencyAreaID-Cancelled-Item'},
                                                      'size': [(1,
                                                                'maxnoofEmergencyAreaID')],
                                                      'type': 'SEQUENCE OF'},
                        'EmergencyAreaID-Cancelled-Item': {'members': [{'name': 'emergencyAreaID',
                                                                        'type': 'EmergencyAreaID'},
                                                                       {'name': 'cancelledCellinEAI',
                                                                        'type': 'CancelledCellinEAI'},
                                                                       {'name': 'iE-Extensions',
                                                                        'optional': True,
                                                                        'type': 'ProtocolExtensionContainer'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                        'EmergencyAreaIDList': {'element': {'type': 'EmergencyAreaID'},
                                                'size': [(1,
                                                          'maxnoofEmergencyAreaID')],
                                                'type': 'SEQUENCE OF'},
                        'EmergencyAreaIDListForRestart': {'element': {'type': 'EmergencyAreaID'},
                                                          'size': [(1,
                                                                    'maxnoofRestartEmergencyAreaIDs')],
                                                          'type': 'SEQUENCE '
                                                                  'OF'},
                        'EncryptionAlgorithms': {'size': [16, None],
                                                 'type': 'BIT STRING'},
                        'EnhancedCoverageRestricted': {'type': 'ENUMERATED',
                                                       'values': [('restricted',
                                                                   0),
                                                                  None]},
                        'EventType': {'type': 'ENUMERATED',
                                      'values': [('direct', 0),
                                                 ('change-of-serve-cell', 1),
                                                 ('stop-change-of-serve-cell',
                                                  2),
                                                 None]},
                        'ExpectedActivityPeriod': {'restricted-to': [(1, 30),
                                                                     40,
                                                                     50,
                                                                     60,
                                                                     80,
                                                                     100,
                                                                     120,
                                                                     150,
                                                                     180,
                                                                     181,
                                                                     None],
                                                   'type': 'INTEGER'},
                        'ExpectedHOInterval': {'type': 'ENUMERATED',
                                               'values': [('sec15', 0),
                                                          ('sec30', 1),
                                                          ('sec60', 2),
                                                          ('sec90', 3),
                                                          ('sec120', 4),
                                                          ('sec180', 5),
                                                          ('long-time', 6),
                                                          None]},
                        'ExpectedIdlePeriod': {'restricted-to': [(1, 30),
                                                                 40,
                                                                 50,
                                                                 60,
                                                                 80,
                                                                 100,
                                                                 120,
                                                                 150,
                                                                 180,
                                                                 181,
                                                                 None],
                                               'type': 'INTEGER'},
                        'ExpectedUEActivityBehaviour': {'members': [{'name': 'expectedActivityPeriod',
                                                                     'optional': True,
                                                                     'type': 'ExpectedActivityPeriod'},
                                                                    {'name': 'expectedIdlePeriod',
                                                                     'optional': True,
                                                                     'type': 'ExpectedIdlePeriod'},
                                                                    {'name': 'sourceofUEActivityBehaviourInformation',
                                                                     'optional': True,
                                                                     'type': 'SourceOfUEActivityBehaviourInformation'},
                                                                    {'name': 'iE-Extensions',
                                                                     'optional': True,
                                                                     'type': 'ProtocolExtensionContainer'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                        'ExpectedUEBehaviour': {'members': [{'name': 'expectedActivity',
                                                             'optional': True,
                                                             'type': 'ExpectedUEActivityBehaviour'},
                                                            {'name': 'expectedHOInterval',
                                                             'optional': True,
                                                             'type': 'ExpectedHOInterval'},
                                                            {'name': 'iE-Extensions',
                                                             'optional': True,
                                                             'type': 'ProtocolExtensionContainer'},
                                                            None],
                                                'type': 'SEQUENCE'},
                        'Extended-UEIdentityIndexValue': {'size': [14],
                                                          'type': 'BIT STRING'},
                        'ExtendedRNC-ID': {'restricted-to': [(4096, 65535)],
                                           'type': 'INTEGER'},
                        'ExtendedRepetitionPeriod': {'restricted-to': [(4096,
                                                                        131071)],
                                                     'type': 'INTEGER'},
                        'ForbiddenInterRATs': {'type': 'ENUMERATED',
                                               'values': [('all', 0),
                                                          ('geran', 1),
                                                          ('utran', 2),
                                                          ('cdma2000', 3),
                                                          None,
                                                          ('geranandutran', 4),
                                                          ('cdma2000andutran',
                                                           5)]},
                        'ForbiddenLACs': {'element': {'type': 'LAC'},
                                          'size': [(1, 'maxnoofForbLACs')],
                                          'type': 'SEQUENCE OF'},
                        'ForbiddenLAs': {'element': {'type': 'ForbiddenLAs-Item'},
                                         'size': [(1, 'maxnoofEPLMNsPlusOne')],
                                         'type': 'SEQUENCE OF'},
                        'ForbiddenLAs-Item': {'members': [{'name': 'pLMN-Identity',
                                                           'type': 'PLMNidentity'},
                                                          {'name': 'forbiddenLACs',
                                                           'type': 'ForbiddenLACs'},
                                                          {'name': 'iE-Extensions',
                                                           'optional': True,
                                                           'type': 'ProtocolExtensionContainer'},
                                                          None],
                                              'type': 'SEQUENCE'},
                        'ForbiddenTACs': {'element': {'type': 'TAC'},
                                          'size': [(1, 'maxnoofForbTACs')],
                                          'type': 'SEQUENCE OF'},
                        'ForbiddenTAs': {'element': {'type': 'ForbiddenTAs-Item'},
                                         'size': [(1, 'maxnoofEPLMNsPlusOne')],
                                         'type': 'SEQUENCE OF'},
                        'ForbiddenTAs-Item': {'members': [{'name': 'pLMN-Identity',
                                                           'type': 'PLMNidentity'},
                                                          {'name': 'forbiddenTACs',
                                                           'type': 'ForbiddenTACs'},
                                                          {'name': 'iE-Extensions',
                                                           'optional': True,
                                                           'type': 'ProtocolExtensionContainer'},
                                                          None],
                                              'type': 'SEQUENCE'},
                        'GBR-QosInformation': {'members': [{'name': 'e-RAB-MaximumBitrateDL',
                                                            'type': 'BitRate'},
                                                           {'name': 'e-RAB-MaximumBitrateUL',
                                                            'type': 'BitRate'},
                                                           {'name': 'e-RAB-GuaranteedBitrateDL',
                                                            'type': 'BitRate'},
                                                           {'name': 'e-RAB-GuaranteedBitrateUL',
                                                            'type': 'BitRate'},
                                                           {'name': 'iE-Extensions',
                                                            'optional': True,
                                                            'type': 'ProtocolExtensionContainer'},
                                                           None],
                                               'type': 'SEQUENCE'},
                        'GERAN-Cell-ID': {'members': [{'name': 'lAI',
                                                       'type': 'LAI'},
                                                      {'name': 'rAC',
                                                       'type': 'RAC'},
                                                      {'name': 'cI',
                                                       'type': 'CI'},
                                                      {'name': 'iE-Extensions',
                                                       'optional': True,
                                                       'type': 'ProtocolExtensionContainer'},
                                                      None],
                                          'type': 'SEQUENCE'},
                        'GTP-TEID': {'size': [4], 'type': 'OCTET STRING'},
                        'GUMMEI': {'members': [{'name': 'pLMN-Identity',
                                                'type': 'PLMNidentity'},
                                               {'name': 'mME-Group-ID',
                                                'type': 'MME-Group-ID'},
                                               {'name': 'mME-Code',
                                                'type': 'MME-Code'},
                                               {'name': 'iE-Extensions',
                                                'optional': True,
                                                'type': 'ProtocolExtensionContainer'},
                                               None],
                                   'type': 'SEQUENCE'},
                        'GUMMEIList': {'element': {'type': 'GUMMEI'},
                                       'size': [(1, 'maxnoofMMECs')],
                                       'type': 'SEQUENCE OF'},
                        'GUMMEIType': {'type': 'ENUMERATED',
                                       'values': [('native', 0),
                                                  ('mapped', 1),
                                                  None]},
                        'GWContextReleaseIndication': {'type': 'ENUMERATED',
                                                       'values': [('true', 0),
                                                                  None]},
                        'Global-ENB-ID': {'members': [{'name': 'pLMNidentity',
                                                       'type': 'PLMNidentity'},
                                                      {'name': 'eNB-ID',
                                                       'type': 'ENB-ID'},
                                                      {'name': 'iE-Extensions',
                                                       'optional': True,
                                                       'type': 'ProtocolExtensionContainer'},
                                                      None],
                                          'type': 'SEQUENCE'},
                        'HFN': {'restricted-to': [(0, 1048575)],
                                'type': 'INTEGER'},
                        'HFNModified': {'restricted-to': [(0, 131071)],
                                        'type': 'INTEGER'},
                        'HFNforPDCP-SNlength18': {'restricted-to': [(0, 16383)],
                                                  'type': 'INTEGER'},
                        'HandoverRestrictionList': {'members': [{'name': 'servingPLMN',
                                                                 'type': 'PLMNidentity'},
                                                                {'name': 'equivalentPLMNs',
                                                                 'optional': True,
                                                                 'type': 'EPLMNs'},
                                                                {'name': 'forbiddenTAs',
                                                                 'optional': True,
                                                                 'type': 'ForbiddenTAs'},
                                                                {'name': 'forbiddenLAs',
                                                                 'optional': True,
                                                                 'type': 'ForbiddenLAs'},
                                                                {'name': 'forbiddenInterRATs',
                                                                 'optional': True,
                                                                 'type': 'ForbiddenInterRATs'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'HandoverType': {'type': 'ENUMERATED',
                                         'values': [('intralte', 0),
                                                    ('ltetoutran', 1),
                                                    ('ltetogeran', 2),
                                                    ('utrantolte', 3),
                                                    ('gerantolte', 4),
                                                    None]},
                        'IMSI': {'size': [(3, 8)], 'type': 'OCTET STRING'},
                        'ImmediateMDT': {'members': [{'name': 'measurementsToActivate',
                                                      'type': 'MeasurementsToActivate'},
                                                     {'name': 'm1reportingTrigger',
                                                      'type': 'M1ReportingTrigger'},
                                                     {'name': 'm1thresholdeventA2',
                                                      'optional': True,
                                                      'type': 'M1ThresholdEventA2'},
                                                     {'name': 'm1periodicReporting',
                                                      'optional': True,
                                                      'type': 'M1PeriodicReporting'},
                                                     {'name': 'iE-Extensions',
                                                      'optional': True,
                                                      'type': 'ProtocolExtensionContainer'},
                                                     None],
                                         'type': 'SEQUENCE'},
                        'InformationOnRecommendedCellsAndENBsForPaging': {'members': [{'name': 'recommendedCellsForPaging',
                                                                                       'type': 'RecommendedCellsForPaging'},
                                                                                      {'name': 'recommendENBsForPaging',
                                                                                       'type': 'RecommendedENBsForPaging'},
                                                                                      {'name': 'iE-Extensions',
                                                                                       'optional': True,
                                                                                       'type': 'ProtocolExtensionContainer'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                        'IntegrityProtectionAlgorithms': {'size': [16, None],
                                                          'type': 'BIT STRING'},
                        'IntendedNumberOfPagingAttempts': {'restricted-to': [(1,
                                                                              16),
                                                                             None],
                                                           'type': 'INTEGER'},
                        'InterfacesToTrace': {'size': [8],
                                              'type': 'BIT STRING'},
                        'KillAllWarningMessages': {'type': 'ENUMERATED',
                                                   'values': [('true', 0)]},
                        'L3-Information': {'type': 'OCTET STRING'},
                        'LAC': {'size': [2], 'type': 'OCTET STRING'},
                        'LAI': {'members': [{'name': 'pLMNidentity',
                                             'type': 'PLMNidentity'},
                                            {'name': 'lAC', 'type': 'LAC'},
                                            {'name': 'iE-Extensions',
                                             'optional': True,
                                             'type': 'ProtocolExtensionContainer'},
                                            None],
                                'type': 'SEQUENCE'},
                        'LHN-ID': {'size': [(32, 256)], 'type': 'OCTET STRING'},
                        'LPPa-PDU': {'type': 'OCTET STRING'},
                        'LastVisitedCell-Item': {'members': [{'name': 'e-UTRAN-Cell',
                                                              'type': 'LastVisitedEUTRANCellInformation'},
                                                             {'name': 'uTRAN-Cell',
                                                              'type': 'LastVisitedUTRANCellInformation'},
                                                             {'name': 'gERAN-Cell',
                                                              'type': 'LastVisitedGERANCellInformation'},
                                                             None],
                                                 'type': 'CHOICE'},
                        'LastVisitedEUTRANCellInformation': {'members': [{'name': 'global-Cell-ID',
                                                                          'type': 'EUTRAN-CGI'},
                                                                         {'name': 'cellType',
                                                                          'type': 'CellType'},
                                                                         {'name': 'time-UE-StayedInCell',
                                                                          'type': 'Time-UE-StayedInCell'},
                                                                         {'name': 'iE-Extensions',
                                                                          'optional': True,
                                                                          'type': 'ProtocolExtensionContainer'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                        'LastVisitedGERANCellInformation': {'members': [{'name': 'undefined',
                                                                         'type': 'NULL'},
                                                                        None],
                                                            'type': 'CHOICE'},
                        'LastVisitedUTRANCellInformation': {'type': 'OCTET '
                                                                    'STRING'},
                        'Links-to-log': {'type': 'ENUMERATED',
                                         'values': [('uplink', 0),
                                                    ('downlink', 1),
                                                    ('both-uplink-and-downlink',
                                                     2),
                                                    None]},
                        'ListeningSubframePattern': {'members': [{'name': 'pattern-period',
                                                                  'type': 'ENUMERATED',
                                                                  'values': [('ms1280',
                                                                              0),
                                                                             ('ms2560',
                                                                              1),
                                                                             ('ms5120',
                                                                              2),
                                                                             ('ms10240',
                                                                              3),
                                                                             None]},
                                                                 {'name': 'pattern-offset',
                                                                  'restricted-to': [(0,
                                                                                     10239),
                                                                                    None],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'iE-Extensions',
                                                                  'optional': True,
                                                                  'type': 'ProtocolExtensionContainer'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                        'LoggedMBSFNMDT': {'members': [{'name': 'loggingInterval',
                                                        'type': 'LoggingInterval'},
                                                       {'name': 'loggingDuration',
                                                        'type': 'LoggingDuration'},
                                                       {'name': 'mBSFN-ResultToLog',
                                                        'optional': True,
                                                        'type': 'MBSFN-ResultToLog'},
                                                       {'name': 'iE-Extensions',
                                                        'optional': True,
                                                        'type': 'ProtocolExtensionContainer'},
                                                       None],
                                           'type': 'SEQUENCE'},
                        'LoggedMDT': {'members': [{'name': 'loggingInterval',
                                                   'type': 'LoggingInterval'},
                                                  {'name': 'loggingDuration',
                                                   'type': 'LoggingDuration'},
                                                  {'name': 'iE-Extensions',
                                                   'optional': True,
                                                   'type': 'ProtocolExtensionContainer'},
                                                  None],
                                      'type': 'SEQUENCE'},
                        'LoggingDuration': {'type': 'ENUMERATED',
                                            'values': [('m10', 0),
                                                       ('m20', 1),
                                                       ('m40', 2),
                                                       ('m60', 3),
                                                       ('m90', 4),
                                                       ('m120', 5)]},
                        'LoggingInterval': {'type': 'ENUMERATED',
                                            'values': [('ms128', 0),
                                                       ('ms256', 1),
                                                       ('ms512', 2),
                                                       ('ms1024', 3),
                                                       ('ms2048', 4),
                                                       ('ms3072', 5),
                                                       ('ms4096', 6),
                                                       ('ms6144', 7)]},
                        'M-TMSI': {'size': [4], 'type': 'OCTET STRING'},
                        'M1PeriodicReporting': {'members': [{'name': 'reportInterval',
                                                             'type': 'ReportIntervalMDT'},
                                                            {'name': 'reportAmount',
                                                             'type': 'ReportAmountMDT'},
                                                            {'name': 'iE-Extensions',
                                                             'optional': True,
                                                             'type': 'ProtocolExtensionContainer'},
                                                            None],
                                                'type': 'SEQUENCE'},
                        'M1ReportingTrigger': {'type': 'ENUMERATED',
                                               'values': [('periodic', 0),
                                                          ('a2eventtriggered',
                                                           1),
                                                          None,
                                                          ('a2eventtriggered-periodic',
                                                           2)]},
                        'M1ThresholdEventA2': {'members': [{'name': 'measurementThreshold',
                                                            'type': 'MeasurementThresholdA2'},
                                                           {'name': 'iE-Extensions',
                                                            'optional': True,
                                                            'type': 'ProtocolExtensionContainer'},
                                                           None],
                                               'type': 'SEQUENCE'},
                        'M3Configuration': {'members': [{'name': 'm3period',
                                                         'type': 'M3period'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'M3period': {'type': 'ENUMERATED',
                                     'values': [('ms100', 0),
                                                ('ms1000', 1),
                                                ('ms10000', 2),
                                                None]},
                        'M4Configuration': {'members': [{'name': 'm4period',
                                                         'type': 'M4period'},
                                                        {'name': 'm4-links-to-log',
                                                         'type': 'Links-to-log'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'M4period': {'type': 'ENUMERATED',
                                     'values': [('ms1024', 0),
                                                ('ms2048', 1),
                                                ('ms5120', 2),
                                                ('ms10240', 3),
                                                ('min1', 4),
                                                None]},
                        'M5Configuration': {'members': [{'name': 'm5period',
                                                         'type': 'M5period'},
                                                        {'name': 'm5-links-to-log',
                                                         'type': 'Links-to-log'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'M5period': {'type': 'ENUMERATED',
                                     'values': [('ms1024', 0),
                                                ('ms2048', 1),
                                                ('ms5120', 2),
                                                ('ms10240', 3),
                                                ('min1', 4),
                                                None]},
                        'M6Configuration': {'members': [{'name': 'm6report-Interval',
                                                         'type': 'M6report-Interval'},
                                                        {'name': 'm6delay-threshold',
                                                         'optional': True,
                                                         'type': 'M6delay-threshold'},
                                                        {'name': 'm6-links-to-log',
                                                         'type': 'Links-to-log'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'M6delay-threshold': {'type': 'ENUMERATED',
                                              'values': [('ms30', 0),
                                                         ('ms40', 1),
                                                         ('ms50', 2),
                                                         ('ms60', 3),
                                                         ('ms70', 4),
                                                         ('ms80', 5),
                                                         ('ms90', 6),
                                                         ('ms100', 7),
                                                         ('ms150', 8),
                                                         ('ms300', 9),
                                                         ('ms500', 10),
                                                         ('ms750', 11),
                                                         None]},
                        'M6report-Interval': {'type': 'ENUMERATED',
                                              'values': [('ms1024', 0),
                                                         ('ms2048', 1),
                                                         ('ms5120', 2),
                                                         ('ms10240', 3),
                                                         None]},
                        'M7Configuration': {'members': [{'name': 'm7period',
                                                         'type': 'M7period'},
                                                        {'name': 'm7-links-to-log',
                                                         'type': 'Links-to-log'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'M7period': {'restricted-to': [(1, 60), None],
                                     'type': 'INTEGER'},
                        'MBSFN-ResultToLog': {'element': {'type': 'MBSFN-ResultToLogInfo'},
                                              'size': [(1,
                                                        'maxnoofMBSFNAreaMDT')],
                                              'type': 'SEQUENCE OF'},
                        'MBSFN-ResultToLogInfo': {'members': [{'name': 'mBSFN-AreaId',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  255)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'carrierFreq',
                                                               'type': 'EARFCN'},
                                                              {'name': 'iE-Extensions',
                                                               'optional': True,
                                                               'type': 'ProtocolExtensionContainer'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                        'MDT-Activation': {'type': 'ENUMERATED',
                                           'values': [('immediate-MDT-only', 0),
                                                      ('immediate-MDT-and-Trace',
                                                       1),
                                                      ('logged-MDT-only', 2),
                                                      None,
                                                      ('logged-MBSFN-MDT', 3)]},
                        'MDT-Configuration': {'members': [{'name': 'mdt-Activation',
                                                           'type': 'MDT-Activation'},
                                                          {'name': 'areaScopeOfMDT',
                                                           'type': 'AreaScopeOfMDT'},
                                                          {'name': 'mDTMode',
                                                           'type': 'MDTMode'},
                                                          {'name': 'iE-Extensions',
                                                           'optional': True,
                                                           'type': 'ProtocolExtensionContainer'},
                                                          None],
                                              'type': 'SEQUENCE'},
                        'MDT-Location-Info': {'size': [8],
                                              'type': 'BIT STRING'},
                        'MDTMode': {'members': [{'name': 'immediateMDT',
                                                 'type': 'ImmediateMDT'},
                                                {'name': 'loggedMDT',
                                                 'type': 'LoggedMDT'},
                                                None,
                                                {'name': 'mDTMode-Extension',
                                                 'type': 'MDTMode-Extension'}],
                                    'type': 'CHOICE'},
                        'MDTMode-Extension': {'type': 'ProtocolIE-SingleContainer'},
                        'MDTPLMNList': {'element': {'type': 'PLMNidentity'},
                                        'size': [(1, 'maxnoofMDTPLMNs')],
                                        'type': 'SEQUENCE OF'},
                        'MME-Code': {'size': [1], 'type': 'OCTET STRING'},
                        'MME-Group-ID': {'size': [2], 'type': 'OCTET STRING'},
                        'MME-UE-S1AP-ID': {'restricted-to': [(0, 4294967295)],
                                           'type': 'INTEGER'},
                        'MMEPagingTarget': {'members': [{'name': 'global-ENB-ID',
                                                         'type': 'Global-ENB-ID'},
                                                        {'name': 'tAI',
                                                         'type': 'TAI'},
                                                        None],
                                            'type': 'CHOICE'},
                        'MMERelaySupportIndicator': {'type': 'ENUMERATED',
                                                     'values': [('true', 0),
                                                                None]},
                        'MMEname': {'size': [(1, 150), None],
                                    'type': 'PrintableString'},
                        'MSClassmark2': {'type': 'OCTET STRING'},
                        'MSClassmark3': {'type': 'OCTET STRING'},
                        'ManagementBasedMDTAllowed': {'type': 'ENUMERATED',
                                                      'values': [('allowed', 0),
                                                                 None]},
                        'Masked-IMEISV': {'size': [64], 'type': 'BIT STRING'},
                        'MeasurementThresholdA2': {'members': [{'name': 'threshold-RSRP',
                                                                'type': 'Threshold-RSRP'},
                                                               {'name': 'threshold-RSRQ',
                                                                'type': 'Threshold-RSRQ'},
                                                               None],
                                                   'type': 'CHOICE'},
                        'MeasurementsToActivate': {'size': [8],
                                                   'type': 'BIT STRING'},
                        'MessageIdentifier': {'size': [16],
                                              'type': 'BIT STRING'},
                        'MobilityInformation': {'size': [32],
                                                'type': 'BIT STRING'},
                        'MutingAvailabilityIndication': {'type': 'ENUMERATED',
                                                         'values': [('available',
                                                                     0),
                                                                    ('unavailable',
                                                                     1),
                                                                    None]},
                        'MutingPatternInformation': {'members': [{'name': 'muting-pattern-period',
                                                                  'type': 'ENUMERATED',
                                                                  'values': [('ms0',
                                                                              0),
                                                                             ('ms1280',
                                                                              1),
                                                                             ('ms2560',
                                                                              2),
                                                                             ('ms5120',
                                                                              3),
                                                                             ('ms10240',
                                                                              4),
                                                                             None]},
                                                                 {'name': 'muting-pattern-offset',
                                                                  'optional': True,
                                                                  'restricted-to': [(0,
                                                                                     10239),
                                                                                    None],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'iE-Extensions',
                                                                  'optional': True,
                                                                  'type': 'ProtocolExtensionContainer'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                        'NAS-PDU': {'type': 'OCTET STRING'},
                        'NASSecurityParametersfromE-UTRAN': {'type': 'OCTET '
                                                                     'STRING'},
                        'NASSecurityParameterstoE-UTRAN': {'type': 'OCTET '
                                                                   'STRING'},
                        'NB-IoT-DefaultPagingDRX': {'type': 'ENUMERATED',
                                                    'values': [('v128', 0),
                                                               ('v256', 1),
                                                               ('v512', 2),
                                                               ('v1024', 3),
                                                               None]},
                        'NB-IoT-Paging-eDRX-Cycle': {'type': 'ENUMERATED',
                                                     'values': [('hf2', 0),
                                                                ('hf4', 1),
                                                                ('hf6', 2),
                                                                ('hf8', 3),
                                                                ('hf10', 4),
                                                                ('hf12', 5),
                                                                ('hf14', 6),
                                                                ('hf16', 7),
                                                                ('hf32', 8),
                                                                ('hf64', 9),
                                                                ('hf128', 10),
                                                                ('hf256', 11),
                                                                ('hf512', 12),
                                                                ('hf1024', 13),
                                                                None]},
                        'NB-IoT-Paging-eDRXInformation': {'members': [{'name': 'nB-IoT-paging-eDRX-Cycle',
                                                                       'type': 'NB-IoT-Paging-eDRX-Cycle'},
                                                                      {'name': 'nB-IoT-pagingTimeWindow',
                                                                       'optional': True,
                                                                       'type': 'NB-IoT-PagingTimeWindow'},
                                                                      {'name': 'iE-Extensions',
                                                                       'optional': True,
                                                                       'type': 'ProtocolExtensionContainer'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                        'NB-IoT-PagingTimeWindow': {'type': 'ENUMERATED',
                                                    'values': [('s1', 0),
                                                               ('s2', 1),
                                                               ('s3', 2),
                                                               ('s4', 3),
                                                               ('s5', 4),
                                                               ('s6', 5),
                                                               ('s7', 6),
                                                               ('s8', 7),
                                                               ('s9', 8),
                                                               ('s10', 9),
                                                               ('s11', 10),
                                                               ('s12', 11),
                                                               ('s13', 12),
                                                               ('s14', 13),
                                                               ('s15', 14),
                                                               ('s16', 15),
                                                               None]},
                        'NB-IoT-UEIdentityIndexValue': {'size': [12],
                                                        'type': 'BIT STRING'},
                        'NextPagingAreaScope': {'type': 'ENUMERATED',
                                                'values': [('same', 0),
                                                           ('changed', 1),
                                                           None]},
                        'NumberOfBroadcasts': {'restricted-to': [(0, 65535)],
                                               'type': 'INTEGER'},
                        'NumberofBroadcastRequest': {'restricted-to': [(0,
                                                                        65535)],
                                                     'type': 'INTEGER'},
                        'OldBSS-ToNewBSS-Information': {'type': 'OCTET STRING'},
                        'OverloadAction': {'type': 'ENUMERATED',
                                           'values': [('reject-non-emergency-mo-dt',
                                                       0),
                                                      ('reject-rrc-cr-signalling',
                                                       1),
                                                      ('permit-emergency-sessions-and-mobile-terminated-services-only',
                                                       2),
                                                      None,
                                                      ('permit-high-priority-sessions-and-mobile-terminated-services-only',
                                                       3),
                                                      ('reject-delay-tolerant-access',
                                                       4),
                                                      ('permit-high-priority-sessions-and-exception-reporting-and-mobile-terminated-services-only',
                                                       5),
                                                      ('not-accept-mo-data-or-delay-tolerant-access-from-CP-CIoT',
                                                       6)]},
                        'OverloadResponse': {'members': [{'name': 'overloadAction',
                                                          'type': 'OverloadAction'},
                                                         None],
                                             'type': 'CHOICE'},
                        'PDCP-SN': {'restricted-to': [(0, 4095)],
                                    'type': 'INTEGER'},
                        'PDCP-SNExtended': {'restricted-to': [(0, 32767)],
                                            'type': 'INTEGER'},
                        'PDCP-SNlength18': {'restricted-to': [(0, 262143)],
                                            'type': 'INTEGER'},
                        'PLMNidentity': {'type': 'TBCD-STRING'},
                        'PS-ServiceNotAvailable': {'type': 'ENUMERATED',
                                                   'values': [('ps-service-not-available',
                                                               0),
                                                              None]},
                        'PWSfailedECGIList': {'element': {'type': 'EUTRAN-CGI'},
                                              'size': [(1,
                                                        'maxnoofCellsineNB')],
                                              'type': 'SEQUENCE OF'},
                        'Paging-eDRX-Cycle': {'type': 'ENUMERATED',
                                              'values': [('hfhalf', 0),
                                                         ('hf1', 1),
                                                         ('hf2', 2),
                                                         ('hf4', 3),
                                                         ('hf6', 4),
                                                         ('hf8', 5),
                                                         ('hf10', 6),
                                                         ('hf12', 7),
                                                         ('hf14', 8),
                                                         ('hf16', 9),
                                                         ('hf32', 10),
                                                         ('hf64', 11),
                                                         ('hf128', 12),
                                                         ('hf256', 13),
                                                         None]},
                        'Paging-eDRXInformation': {'members': [{'name': 'paging-eDRX-Cycle',
                                                                'type': 'Paging-eDRX-Cycle'},
                                                               {'name': 'pagingTimeWindow',
                                                                'optional': True,
                                                                'type': 'PagingTimeWindow'},
                                                               {'name': 'iE-Extensions',
                                                                'optional': True,
                                                                'type': 'ProtocolExtensionContainer'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                        'PagingAttemptCount': {'restricted-to': [(1, 16), None],
                                               'type': 'INTEGER'},
                        'PagingAttemptInformation': {'members': [{'name': 'pagingAttemptCount',
                                                                  'type': 'PagingAttemptCount'},
                                                                 {'name': 'intendedNumberOfPagingAttempts',
                                                                  'type': 'IntendedNumberOfPagingAttempts'},
                                                                 {'name': 'nextPagingAreaScope',
                                                                  'optional': True,
                                                                  'type': 'NextPagingAreaScope'},
                                                                 {'name': 'iE-Extensions',
                                                                  'optional': True,
                                                                  'type': 'ProtocolExtensionContainer'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                        'PagingDRX': {'type': 'ENUMERATED',
                                      'values': [('v32', 0),
                                                 ('v64', 1),
                                                 ('v128', 2),
                                                 ('v256', 3),
                                                 None]},
                        'PagingPriority': {'type': 'ENUMERATED',
                                           'values': [('priolevel1', 0),
                                                      ('priolevel2', 1),
                                                      ('priolevel3', 2),
                                                      ('priolevel4', 3),
                                                      ('priolevel5', 4),
                                                      ('priolevel6', 5),
                                                      ('priolevel7', 6),
                                                      ('priolevel8', 7),
                                                      None]},
                        'PagingTimeWindow': {'type': 'ENUMERATED',
                                             'values': [('s1', 0),
                                                        ('s2', 1),
                                                        ('s3', 2),
                                                        ('s4', 3),
                                                        ('s5', 4),
                                                        ('s6', 5),
                                                        ('s7', 6),
                                                        ('s8', 7),
                                                        ('s9', 8),
                                                        ('s10', 9),
                                                        ('s11', 10),
                                                        ('s12', 11),
                                                        ('s13', 12),
                                                        ('s14', 13),
                                                        ('s15', 14),
                                                        ('s16', 15),
                                                        None]},
                        'PedestrianUE': {'type': 'ENUMERATED',
                                         'values': [('authorized', 0),
                                                    ('not-authorized', 1),
                                                    None]},
                        'Port-Number': {'size': [2], 'type': 'OCTET STRING'},
                        'Pre-emptionCapability': {'type': 'ENUMERATED',
                                                  'values': [('shall-not-trigger-pre-emption',
                                                              0),
                                                             ('may-trigger-pre-emption',
                                                              1)]},
                        'Pre-emptionVulnerability': {'type': 'ENUMERATED',
                                                     'values': [('not-pre-emptable',
                                                                 0),
                                                                ('pre-emptable',
                                                                 1)]},
                        'PriorityLevel': {'named-numbers': {'highest': 1,
                                                            'lowest': 14,
                                                            'no-priority': 15,
                                                            'spare': 0},
                                          'restricted-to': [(0, 15)],
                                          'type': 'INTEGER'},
                        'PrivacyIndicator': {'type': 'ENUMERATED',
                                             'values': [('immediate-MDT', 0),
                                                        ('logged-MDT', 1),
                                                        None]},
                        'ProSeAuthorized': {'members': [{'name': 'proSeDirectDiscovery',
                                                         'optional': True,
                                                         'type': 'ProSeDirectDiscovery'},
                                                        {'name': 'proSeDirectCommunication',
                                                         'optional': True,
                                                         'type': 'ProSeDirectCommunication'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'ProSeDirectCommunication': {'type': 'ENUMERATED',
                                                     'values': [('authorized',
                                                                 0),
                                                                ('not-authorized',
                                                                 1),
                                                                None]},
                        'ProSeDirectDiscovery': {'type': 'ENUMERATED',
                                                 'values': [('authorized', 0),
                                                            ('not-authorized',
                                                             1),
                                                            None]},
                        'ProSeUEtoNetworkRelaying': {'type': 'ENUMERATED',
                                                     'values': [('authorized',
                                                                 0),
                                                                ('not-authorized',
                                                                 1),
                                                                None]},
                        'QCI': {'restricted-to': [(0, 255)], 'type': 'INTEGER'},
                        'RAC': {'size': [1], 'type': 'OCTET STRING'},
                        'RAT-Type': {'type': 'ENUMERATED',
                                     'values': [('nbiot', 0), None]},
                        'RIMInformation': {'type': 'OCTET STRING'},
                        'RIMRoutingAddress': {'members': [{'name': 'gERAN-Cell-ID',
                                                           'type': 'GERAN-Cell-ID'},
                                                          None,
                                                          {'name': 'targetRNC-ID',
                                                           'type': 'TargetRNC-ID'},
                                                          {'name': 'eHRPD-Sector-ID',
                                                           'size': [16],
                                                           'type': 'OCTET '
                                                                   'STRING'}],
                                              'type': 'CHOICE'},
                        'RIMTransfer': {'members': [{'name': 'rIMInformation',
                                                     'type': 'RIMInformation'},
                                                    {'name': 'rIMRoutingAddress',
                                                     'optional': True,
                                                     'type': 'RIMRoutingAddress'},
                                                    {'name': 'iE-Extensions',
                                                     'optional': True,
                                                     'type': 'ProtocolExtensionContainer'},
                                                    None],
                                        'type': 'SEQUENCE'},
                        'RLFReportInformation': {'members': [{'name': 'uE-RLF-Report-Container',
                                                              'type': 'UE-RLF-Report-Container'},
                                                             {'name': 'uE-RLF-Report-Container-for-extended-bands',
                                                              'optional': True,
                                                              'type': 'UE-RLF-Report-Container-for-extended-bands'},
                                                             {'name': 'iE-Extensions',
                                                              'optional': True,
                                                              'type': 'ProtocolExtensionContainer'},
                                                             None],
                                                 'type': 'SEQUENCE'},
                        'RNC-ID': {'restricted-to': [(0, 4095)],
                                   'type': 'INTEGER'},
                        'RRC-Container': {'type': 'OCTET STRING'},
                        'RRC-Establishment-Cause': {'type': 'ENUMERATED',
                                                    'values': [('emergency', 0),
                                                               ('highPriorityAccess',
                                                                1),
                                                               ('mt-Access', 2),
                                                               ('mo-Signalling',
                                                                3),
                                                               ('mo-Data', 4),
                                                               None,
                                                               ('delay-TolerantAccess',
                                                                5),
                                                               ('mo-VoiceCall',
                                                                6),
                                                               ('mo-ExceptionData',
                                                                7)]},
                        'ReceiveStatusOfULPDCPSDUsExtended': {'size': [(1,
                                                                        16384)],
                                                              'type': 'BIT '
                                                                      'STRING'},
                        'ReceiveStatusOfULPDCPSDUsPDCP-SNlength18': {'size': [(1,
                                                                               131072)],
                                                                     'type': 'BIT '
                                                                             'STRING'},
                        'ReceiveStatusofULPDCPSDUs': {'size': [4096],
                                                      'type': 'BIT STRING'},
                        'RecommendedCellItem': {'members': [{'name': 'eUTRAN-CGI',
                                                             'type': 'EUTRAN-CGI'},
                                                            {'name': 'timeStayedInCell',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                4095)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'iE-Extensions',
                                                             'optional': True,
                                                             'type': 'ProtocolExtensionContainer'},
                                                            None],
                                                'type': 'SEQUENCE'},
                        'RecommendedCellList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                'size': [(1,
                                                          'maxnoofRecommendedCells')],
                                                'type': 'SEQUENCE OF'},
                        'RecommendedCellsForPaging': {'members': [{'name': 'recommendedCellList',
                                                                   'type': 'RecommendedCellList'},
                                                                  {'name': 'iE-Extensions',
                                                                   'optional': True,
                                                                   'type': 'ProtocolExtensionContainer'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                        'RecommendedENBItem': {'members': [{'name': 'mMEPagingTarget',
                                                            'type': 'MMEPagingTarget'},
                                                           {'name': 'iE-Extensions',
                                                            'optional': True,
                                                            'type': 'ProtocolExtensionContainer'},
                                                           None],
                                               'type': 'SEQUENCE'},
                        'RecommendedENBList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                               'size': [(1,
                                                         'maxnoofRecommendedENBs')],
                                               'type': 'SEQUENCE OF'},
                        'RecommendedENBsForPaging': {'members': [{'name': 'recommendedENBList',
                                                                  'type': 'RecommendedENBList'},
                                                                 {'name': 'iE-Extensions',
                                                                  'optional': True,
                                                                  'type': 'ProtocolExtensionContainer'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                        'RelativeMMECapacity': {'restricted-to': [(0, 255)],
                                                'type': 'INTEGER'},
                        'RelayNode-Indicator': {'type': 'ENUMERATED',
                                                'values': [('true', 0), None]},
                        'RepetitionPeriod': {'restricted-to': [(0, 4095)],
                                             'type': 'INTEGER'},
                        'ReportAmountMDT': {'type': 'ENUMERATED',
                                            'values': [('r1', 0),
                                                       ('r2', 1),
                                                       ('r4', 2),
                                                       ('r8', 3),
                                                       ('r16', 4),
                                                       ('r32', 5),
                                                       ('r64', 6),
                                                       ('rinfinity', 7)]},
                        'ReportArea': {'type': 'ENUMERATED',
                                       'values': [('ecgi', 0), None]},
                        'ReportIntervalMDT': {'type': 'ENUMERATED',
                                              'values': [('ms120', 0),
                                                         ('ms240', 1),
                                                         ('ms480', 2),
                                                         ('ms640', 3),
                                                         ('ms1024', 4),
                                                         ('ms2048', 5),
                                                         ('ms5120', 6),
                                                         ('ms10240', 7),
                                                         ('min1', 8),
                                                         ('min6', 9),
                                                         ('min12', 10),
                                                         ('min30', 11),
                                                         ('min60', 12)]},
                        'RequestType': {'members': [{'name': 'eventType',
                                                     'type': 'EventType'},
                                                    {'name': 'reportArea',
                                                     'type': 'ReportArea'},
                                                    {'name': 'iE-Extensions',
                                                     'optional': True,
                                                     'type': 'ProtocolExtensionContainer'},
                                                    None],
                                        'type': 'SEQUENCE'},
                        'Routing-ID': {'restricted-to': [(0, 255)],
                                       'type': 'INTEGER'},
                        'S-TMSI': {'members': [{'name': 'mMEC',
                                                'type': 'MME-Code'},
                                               {'name': 'm-TMSI',
                                                'type': 'M-TMSI'},
                                               {'name': 'iE-Extensions',
                                                'optional': True,
                                                'type': 'ProtocolExtensionContainer'},
                                               None],
                                   'type': 'SEQUENCE'},
                        'SONConfigurationTransfer': {'members': [{'name': 'targeteNB-ID',
                                                                  'type': 'TargeteNB-ID'},
                                                                 {'name': 'sourceeNB-ID',
                                                                  'type': 'SourceeNB-ID'},
                                                                 {'name': 'sONInformation',
                                                                  'type': 'SONInformation'},
                                                                 {'name': 'iE-Extensions',
                                                                  'optional': True,
                                                                  'type': 'ProtocolExtensionContainer'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                        'SONInformation': {'members': [{'name': 'sONInformationRequest',
                                                        'type': 'SONInformationRequest'},
                                                       {'name': 'sONInformationReply',
                                                        'type': 'SONInformationReply'},
                                                       None,
                                                       {'name': 'sONInformation-Extension',
                                                        'type': 'SONInformation-Extension'}],
                                           'type': 'CHOICE'},
                        'SONInformation-Extension': {'type': 'ProtocolIE-SingleContainer'},
                        'SONInformationReply': {'members': [{'name': 'x2TNLConfigurationInfo',
                                                             'optional': True,
                                                             'type': 'X2TNLConfigurationInfo'},
                                                            {'name': 'iE-Extensions',
                                                             'optional': True,
                                                             'type': 'ProtocolExtensionContainer'},
                                                            None],
                                                'type': 'SEQUENCE'},
                        'SONInformationReport': {'members': [{'name': 'rLFReportInformation',
                                                              'type': 'RLFReportInformation'},
                                                             None],
                                                 'type': 'CHOICE'},
                        'SONInformationRequest': {'type': 'ENUMERATED',
                                                  'values': [('x2TNL-Configuration-Info',
                                                              0),
                                                             None,
                                                             ('time-Synchronisation-Info',
                                                              1),
                                                             ('activate-Muting',
                                                              2),
                                                             ('deactivate-Muting',
                                                              3)]},
                        'SRVCCHOIndication': {'type': 'ENUMERATED',
                                              'values': [('pSandCS', 0),
                                                         ('cSonly', 1),
                                                         None]},
                        'SRVCCOperationNotPossible': {'type': 'ENUMERATED',
                                                      'values': [('notPossible',
                                                                  0),
                                                                 None]},
                        'SRVCCOperationPossible': {'type': 'ENUMERATED',
                                                   'values': [('possible', 0),
                                                              None]},
                        'SecurityContext': {'members': [{'name': 'nextHopChainingCount',
                                                         'restricted-to': [(0,
                                                                            7)],
                                                         'type': 'INTEGER'},
                                                        {'name': 'nextHopParameter',
                                                         'type': 'SecurityKey'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'SecurityKey': {'size': [256], 'type': 'BIT STRING'},
                        'SerialNumber': {'size': [16], 'type': 'BIT STRING'},
                        'ServedDCNs': {'element': {'type': 'ServedDCNsItem'},
                                       'size': [(0, 'maxnoofDCNs')],
                                       'type': 'SEQUENCE OF'},
                        'ServedDCNsItem': {'members': [{'name': 'dCN-ID',
                                                        'type': 'DCN-ID'},
                                                       {'name': 'relativeDCNCapacity',
                                                        'type': 'RelativeMMECapacity'},
                                                       {'name': 'iE-Extensions',
                                                        'optional': True,
                                                        'type': 'ProtocolExtensionContainer'},
                                                       None],
                                           'type': 'SEQUENCE'},
                        'ServedGUMMEIs': {'element': {'type': 'ServedGUMMEIsItem'},
                                          'size': [(1, 'maxnoofRATs')],
                                          'type': 'SEQUENCE OF'},
                        'ServedGUMMEIsItem': {'members': [{'name': 'servedPLMNs',
                                                           'type': 'ServedPLMNs'},
                                                          {'name': 'servedGroupIDs',
                                                           'type': 'ServedGroupIDs'},
                                                          {'name': 'servedMMECs',
                                                           'type': 'ServedMMECs'},
                                                          {'name': 'iE-Extensions',
                                                           'optional': True,
                                                           'type': 'ProtocolExtensionContainer'},
                                                          None],
                                              'type': 'SEQUENCE'},
                        'ServedGroupIDs': {'element': {'type': 'MME-Group-ID'},
                                           'size': [(1, 'maxnoofGroupIDs')],
                                           'type': 'SEQUENCE OF'},
                        'ServedMMECs': {'element': {'type': 'MME-Code'},
                                        'size': [(1, 'maxnoofMMECs')],
                                        'type': 'SEQUENCE OF'},
                        'ServedPLMNs': {'element': {'type': 'PLMNidentity'},
                                        'size': [(1, 'maxnoofPLMNsPerMME')],
                                        'type': 'SEQUENCE OF'},
                        'Source-ToTarget-TransparentContainer': {'type': 'OCTET '
                                                                         'STRING'},
                        'SourceBSS-ToTargetBSS-TransparentContainer': {'type': 'OCTET '
                                                                               'STRING'},
                        'SourceOfUEActivityBehaviourInformation': {'type': 'ENUMERATED',
                                                                   'values': [('subscription-information',
                                                                               0),
                                                                              ('statistics',
                                                                               1),
                                                                              None]},
                        'SourceRNC-ToTargetRNC-TransparentContainer': {'type': 'OCTET '
                                                                               'STRING'},
                        'SourceeNB-ID': {'members': [{'name': 'global-ENB-ID',
                                                      'type': 'Global-ENB-ID'},
                                                     {'name': 'selected-TAI',
                                                      'type': 'TAI'},
                                                     {'name': 'iE-Extensions',
                                                      'optional': True,
                                                      'type': 'ProtocolExtensionContainer'}],
                                         'type': 'SEQUENCE'},
                        'SourceeNB-ToTargeteNB-TransparentContainer': {'members': [{'name': 'rRC-Container',
                                                                                    'type': 'RRC-Container'},
                                                                                   {'name': 'e-RABInformationList',
                                                                                    'optional': True,
                                                                                    'type': 'E-RABInformationList'},
                                                                                   {'name': 'targetCell-ID',
                                                                                    'type': 'EUTRAN-CGI'},
                                                                                   {'name': 'subscriberProfileIDforRFP',
                                                                                    'optional': True,
                                                                                    'type': 'SubscriberProfileIDforRFP'},
                                                                                   {'name': 'uE-HistoryInformation',
                                                                                    'type': 'UE-HistoryInformation'},
                                                                                   {'name': 'iE-Extensions',
                                                                                    'optional': True,
                                                                                    'type': 'ProtocolExtensionContainer'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                        'StratumLevel': {'restricted-to': [(0, 3), None],
                                         'type': 'INTEGER'},
                        'SubscriberProfileIDforRFP': {'restricted-to': [(1,
                                                                         256)],
                                                      'type': 'INTEGER'},
                        'SupportedTAs': {'element': {'type': 'SupportedTAs-Item'},
                                         'size': [(1, 'maxnoofTACs')],
                                         'type': 'SEQUENCE OF'},
                        'SupportedTAs-Item': {'members': [{'name': 'tAC',
                                                           'type': 'TAC'},
                                                          {'name': 'broadcastPLMNs',
                                                           'type': 'BPLMNs'},
                                                          {'name': 'iE-Extensions',
                                                           'optional': True,
                                                           'type': 'ProtocolExtensionContainer'},
                                                          None],
                                              'type': 'SEQUENCE'},
                        'SynchronisationInformation': {'members': [{'name': 'sourceStratumLevel',
                                                                    'optional': True,
                                                                    'type': 'StratumLevel'},
                                                                   {'name': 'listeningSubframePattern',
                                                                    'optional': True,
                                                                    'type': 'ListeningSubframePattern'},
                                                                   {'name': 'aggressoreCGI-List',
                                                                    'optional': True,
                                                                    'type': 'ECGI-List'},
                                                                   {'name': 'iE-Extensions',
                                                                    'optional': True,
                                                                    'type': 'ProtocolExtensionContainer'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                        'SynchronisationStatus': {'type': 'ENUMERATED',
                                                  'values': [('synchronous', 0),
                                                             ('asynchronous',
                                                              1),
                                                             None]},
                        'TABasedMDT': {'members': [{'name': 'tAListforMDT',
                                                    'type': 'TAListforMDT'},
                                                   {'name': 'iE-Extensions',
                                                    'optional': True,
                                                    'type': 'ProtocolExtensionContainer'},
                                                   None],
                                       'type': 'SEQUENCE'},
                        'TAC': {'size': [2], 'type': 'OCTET STRING'},
                        'TAI': {'members': [{'name': 'pLMNidentity',
                                             'type': 'PLMNidentity'},
                                            {'name': 'tAC', 'type': 'TAC'},
                                            {'name': 'iE-Extensions',
                                             'optional': True,
                                             'type': 'ProtocolExtensionContainer'},
                                            None],
                                'type': 'SEQUENCE'},
                        'TAI-Broadcast': {'element': {'type': 'TAI-Broadcast-Item'},
                                          'size': [(1, 'maxnoofTAIforWarning')],
                                          'type': 'SEQUENCE OF'},
                        'TAI-Broadcast-Item': {'members': [{'name': 'tAI',
                                                            'type': 'TAI'},
                                                           {'name': 'completedCellinTAI',
                                                            'type': 'CompletedCellinTAI'},
                                                           {'name': 'iE-Extensions',
                                                            'optional': True,
                                                            'type': 'ProtocolExtensionContainer'},
                                                           None],
                                               'type': 'SEQUENCE'},
                        'TAI-Cancelled': {'element': {'type': 'TAI-Cancelled-Item'},
                                          'size': [(1, 'maxnoofTAIforWarning')],
                                          'type': 'SEQUENCE OF'},
                        'TAI-Cancelled-Item': {'members': [{'name': 'tAI',
                                                            'type': 'TAI'},
                                                           {'name': 'cancelledCellinTAI',
                                                            'type': 'CancelledCellinTAI'},
                                                           {'name': 'iE-Extensions',
                                                            'optional': True,
                                                            'type': 'ProtocolExtensionContainer'},
                                                           None],
                                               'type': 'SEQUENCE'},
                        'TAIBasedMDT': {'members': [{'name': 'tAIListforMDT',
                                                     'type': 'TAIListforMDT'},
                                                    {'name': 'iE-Extensions',
                                                     'optional': True,
                                                     'type': 'ProtocolExtensionContainer'},
                                                    None],
                                        'type': 'SEQUENCE'},
                        'TAIListForRestart': {'element': {'type': 'TAI'},
                                              'size': [(1,
                                                        'maxnoofRestartTAIs')],
                                              'type': 'SEQUENCE OF'},
                        'TAIListforMDT': {'element': {'type': 'TAI'},
                                          'size': [(1, 'maxnoofTAforMDT')],
                                          'type': 'SEQUENCE OF'},
                        'TAIListforWarning': {'element': {'type': 'TAI'},
                                              'size': [(1,
                                                        'maxnoofTAIforWarning')],
                                              'type': 'SEQUENCE OF'},
                        'TAListforMDT': {'element': {'type': 'TAC'},
                                         'size': [(1, 'maxnoofTAforMDT')],
                                         'type': 'SEQUENCE OF'},
                        'TBCD-STRING': {'size': [3], 'type': 'OCTET STRING'},
                        'Target-ToSource-TransparentContainer': {'type': 'OCTET '
                                                                         'STRING'},
                        'TargetBSS-ToSourceBSS-TransparentContainer': {'type': 'OCTET '
                                                                               'STRING'},
                        'TargetID': {'members': [{'name': 'targeteNB-ID',
                                                  'type': 'TargeteNB-ID'},
                                                 {'name': 'targetRNC-ID',
                                                  'type': 'TargetRNC-ID'},
                                                 {'name': 'cGI', 'type': 'CGI'},
                                                 None],
                                     'type': 'CHOICE'},
                        'TargetRNC-ID': {'members': [{'name': 'lAI',
                                                      'type': 'LAI'},
                                                     {'name': 'rAC',
                                                      'optional': True,
                                                      'type': 'RAC'},
                                                     {'name': 'rNC-ID',
                                                      'type': 'RNC-ID'},
                                                     {'name': 'extendedRNC-ID',
                                                      'optional': True,
                                                      'type': 'ExtendedRNC-ID'},
                                                     {'name': 'iE-Extensions',
                                                      'optional': True,
                                                      'type': 'ProtocolExtensionContainer'},
                                                     None],
                                         'type': 'SEQUENCE'},
                        'TargetRNC-ToSourceRNC-TransparentContainer': {'type': 'OCTET '
                                                                               'STRING'},
                        'TargeteNB-ID': {'members': [{'name': 'global-ENB-ID',
                                                      'type': 'Global-ENB-ID'},
                                                     {'name': 'selected-TAI',
                                                      'type': 'TAI'},
                                                     {'name': 'iE-Extensions',
                                                      'optional': True,
                                                      'type': 'ProtocolExtensionContainer'},
                                                     None],
                                         'type': 'SEQUENCE'},
                        'TargeteNB-ToSourceeNB-TransparentContainer': {'members': [{'name': 'rRC-Container',
                                                                                    'type': 'RRC-Container'},
                                                                                   {'name': 'iE-Extensions',
                                                                                    'optional': True,
                                                                                    'type': 'ProtocolExtensionContainer'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                        'Threshold-RSRP': {'restricted-to': [(0, 97)],
                                           'type': 'INTEGER'},
                        'Threshold-RSRQ': {'restricted-to': [(0, 34)],
                                           'type': 'INTEGER'},
                        'Time-UE-StayedInCell': {'restricted-to': [(0, 4095)],
                                                 'type': 'INTEGER'},
                        'Time-UE-StayedInCell-EnhancedGranularity': {'restricted-to': [(0,
                                                                                        40950)],
                                                                     'type': 'INTEGER'},
                        'TimeSynchronisationInfo': {'members': [{'name': 'stratumLevel',
                                                                 'type': 'StratumLevel'},
                                                                {'name': 'synchronisationStatus',
                                                                 'type': 'SynchronisationStatus'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'TimeToWait': {'type': 'ENUMERATED',
                                       'values': [('v1s', 0),
                                                  ('v2s', 1),
                                                  ('v5s', 2),
                                                  ('v10s', 3),
                                                  ('v20s', 4),
                                                  ('v60s', 5),
                                                  None]},
                        'TraceActivation': {'members': [{'name': 'e-UTRAN-Trace-ID',
                                                         'type': 'E-UTRAN-Trace-ID'},
                                                        {'name': 'interfacesToTrace',
                                                         'type': 'InterfacesToTrace'},
                                                        {'name': 'traceDepth',
                                                         'type': 'TraceDepth'},
                                                        {'name': 'traceCollectionEntityIPAddress',
                                                         'type': 'TransportLayerAddress'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'TraceDepth': {'type': 'ENUMERATED',
                                       'values': [('minimum', 0),
                                                  ('medium', 1),
                                                  ('maximum', 2),
                                                  ('minimumWithoutVendorSpecificExtension',
                                                   3),
                                                  ('mediumWithoutVendorSpecificExtension',
                                                   4),
                                                  ('maximumWithoutVendorSpecificExtension',
                                                   5),
                                                  None]},
                        'TrafficLoadReductionIndication': {'restricted-to': [(1,
                                                                              99)],
                                                           'type': 'INTEGER'},
                        'TransportInformation': {'members': [{'name': 'transportLayerAddress',
                                                              'type': 'TransportLayerAddress'},
                                                             {'name': 'uL-GTP-TEID',
                                                              'type': 'GTP-TEID'},
                                                             None],
                                                 'type': 'SEQUENCE'},
                        'TransportLayerAddress': {'size': [(1, 160), None],
                                                  'type': 'BIT STRING'},
                        'TunnelInformation': {'members': [{'name': 'transportLayerAddress',
                                                           'type': 'TransportLayerAddress'},
                                                          {'name': 'uDP-Port-Number',
                                                           'optional': True,
                                                           'type': 'Port-Number'},
                                                          {'name': 'iE-Extensions',
                                                           'optional': True,
                                                           'type': 'ProtocolExtensionContainer'},
                                                          None],
                                              'type': 'SEQUENCE'},
                        'TypeOfError': {'type': 'ENUMERATED',
                                        'values': [('not-understood', 0),
                                                   ('missing', 1),
                                                   None]},
                        'UE-HistoryInformation': {'element': {'type': 'LastVisitedCell-Item'},
                                                  'size': [(1, 'maxnoofCells')],
                                                  'type': 'SEQUENCE OF'},
                        'UE-HistoryInformationFromTheUE': {'type': 'OCTET '
                                                                   'STRING'},
                        'UE-RLF-Report-Container': {'type': 'OCTET STRING'},
                        'UE-RLF-Report-Container-for-extended-bands': {'type': 'OCTET '
                                                                               'STRING'},
                        'UE-RetentionInformation': {'type': 'ENUMERATED',
                                                    'values': [('ues-retained',
                                                                0),
                                                               None]},
                        'UE-S1AP-ID-pair': {'members': [{'name': 'mME-UE-S1AP-ID',
                                                         'type': 'MME-UE-S1AP-ID'},
                                                        {'name': 'eNB-UE-S1AP-ID',
                                                         'type': 'ENB-UE-S1AP-ID'},
                                                        {'name': 'iE-Extensions',
                                                         'optional': True,
                                                         'type': 'ProtocolExtensionContainer'},
                                                        None],
                                            'type': 'SEQUENCE'},
                        'UE-S1AP-IDs': {'members': [{'name': 'uE-S1AP-ID-pair',
                                                     'type': 'UE-S1AP-ID-pair'},
                                                    {'name': 'mME-UE-S1AP-ID',
                                                     'type': 'MME-UE-S1AP-ID'},
                                                    None],
                                        'type': 'CHOICE'},
                        'UE-Usage-Type': {'restricted-to': [(0, 255)],
                                          'type': 'INTEGER'},
                        'UE-associatedLogicalS1-ConnectionItem': {'members': [{'name': 'mME-UE-S1AP-ID',
                                                                               'optional': True,
                                                                               'type': 'MME-UE-S1AP-ID'},
                                                                              {'name': 'eNB-UE-S1AP-ID',
                                                                               'optional': True,
                                                                               'type': 'ENB-UE-S1AP-ID'},
                                                                              {'name': 'iE-Extensions',
                                                                               'optional': True,
                                                                               'type': 'ProtocolExtensionContainer'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                        'UEAggregateMaximumBitrate': {'members': [{'name': 'uEaggregateMaximumBitRateDL',
                                                                   'type': 'BitRate'},
                                                                  {'name': 'uEaggregateMaximumBitRateUL',
                                                                   'type': 'BitRate'},
                                                                  {'name': 'iE-Extensions',
                                                                   'optional': True,
                                                                   'type': 'ProtocolExtensionContainer'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                        'UEIdentityIndexValue': {'size': [10],
                                                 'type': 'BIT STRING'},
                        'UEPagingID': {'members': [{'name': 's-TMSI',
                                                    'type': 'S-TMSI'},
                                                   {'name': 'iMSI',
                                                    'type': 'IMSI'},
                                                   None],
                                       'type': 'CHOICE'},
                        'UERadioCapability': {'type': 'OCTET STRING'},
                        'UERadioCapabilityForPaging': {'type': 'OCTET STRING'},
                        'UESecurityCapabilities': {'members': [{'name': 'encryptionAlgorithms',
                                                                'type': 'EncryptionAlgorithms'},
                                                               {'name': 'integrityProtectionAlgorithms',
                                                                'type': 'IntegrityProtectionAlgorithms'},
                                                               {'name': 'iE-Extensions',
                                                                'optional': True,
                                                                'type': 'ProtocolExtensionContainer'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                        'UESidelinkAggregateMaximumBitrate': {'members': [{'name': 'uESidelinkAggregateMaximumBitRate',
                                                                           'type': 'BitRate'},
                                                                          {'name': 'iE-Extensions',
                                                                           'optional': True,
                                                                           'type': 'ProtocolExtensionContainer'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                        'UEUserPlaneCIoTSupportIndicator': {'type': 'ENUMERATED',
                                                            'values': [('supported',
                                                                        0),
                                                                       None]},
                        'UL-CP-SecurityInformation': {'members': [{'name': 'ul-NAS-MAC',
                                                                   'type': 'UL-NAS-MAC'},
                                                                  {'name': 'ul-NAS-Count',
                                                                   'type': 'UL-NAS-Count'},
                                                                  {'name': 'iE-Extensions',
                                                                   'optional': True,
                                                                   'type': 'ProtocolExtensionContainer'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                        'UL-NAS-Count': {'size': [5], 'type': 'BIT STRING'},
                        'UL-NAS-MAC': {'size': [16], 'type': 'BIT STRING'},
                        'UserLocationInformation': {'members': [{'name': 'eutran-cgi',
                                                                 'type': 'EUTRAN-CGI'},
                                                                {'name': 'tai',
                                                                 'type': 'TAI'},
                                                                {'name': 'iE-Extensions',
                                                                 'optional': True,
                                                                 'type': 'ProtocolExtensionContainer'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                        'V2XServicesAuthorized': {'members': [{'name': 'vehicleUE',
                                                               'optional': True,
                                                               'type': 'VehicleUE'},
                                                              {'name': 'pedestrianUE',
                                                               'optional': True,
                                                               'type': 'PedestrianUE'},
                                                              {'name': 'iE-Extensions',
                                                               'optional': True,
                                                               'type': 'ProtocolExtensionContainer'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                        'VehicleUE': {'type': 'ENUMERATED',
                                      'values': [('authorized', 0),
                                                 ('not-authorized', 1),
                                                 None]},
                        'VoiceSupportMatchIndicator': {'type': 'ENUMERATED',
                                                       'values': [('supported',
                                                                   0),
                                                                  ('not-supported',
                                                                   1),
                                                                  None]},
                        'WarningAreaList': {'members': [{'name': 'cellIDList',
                                                         'type': 'ECGIList'},
                                                        {'name': 'trackingAreaListforWarning',
                                                         'type': 'TAIListforWarning'},
                                                        {'name': 'emergencyAreaIDList',
                                                         'type': 'EmergencyAreaIDList'},
                                                        None],
                                            'type': 'CHOICE'},
                        'WarningMessageContents': {'size': [(1, 9600)],
                                                   'type': 'OCTET STRING'},
                        'WarningSecurityInfo': {'size': [50],
                                                'type': 'OCTET STRING'},
                        'WarningType': {'size': [2], 'type': 'OCTET STRING'},
                        'X2TNLConfigurationInfo': {'members': [{'name': 'eNBX2TransportLayerAddresses',
                                                                'type': 'ENBX2TLAs'},
                                                               {'name': 'iE-Extensions',
                                                                'optional': True,
                                                                'type': 'ProtocolExtensionContainer'},
                                                               None],
                                                   'type': 'SEQUENCE'}},
              'values': {}},
 'S1AP-PDU-Contents': {'extensibility-implied': False,
                       'imports': {'S1AP-Constants': ['id-AssistanceDataForPaging',
                                                      'id-uEaggregateMaximumBitrate',
                                                      'id-BearerType',
                                                      'id-Cause',
                                                      'id-CellAccessMode',
                                                      'id-CellIdentifierAndCELevelForCECapableUEs',
                                                      'id-cdma2000HORequiredIndication',
                                                      'id-cdma2000HOStatus',
                                                      'id-cdma2000OneXSRVCCInfo',
                                                      'id-cdma2000OneXRAND',
                                                      'id-cdma2000PDU',
                                                      'id-cdma2000RATType',
                                                      'id-cdma2000SectorID',
                                                      'id-EUTRANRoundTripDelayEstimationInfo',
                                                      'id-CNDomain',
                                                      'id-ConcurrentWarningMessageIndicator',
                                                      'id-CriticalityDiagnostics',
                                                      'id-CSFallbackIndicator',
                                                      'id-CSG-Id',
                                                      'id-CSG-IdList',
                                                      'id-CSGMembershipStatus',
                                                      'id-Data-Forwarding-Not-Possible',
                                                      'id-DefaultPagingDRX',
                                                      'id-Direct-Forwarding-Path-Availability',
                                                      'id-Global-ENB-ID',
                                                      'id-EUTRAN-CGI',
                                                      'id-eNBname',
                                                      'id-eNB-StatusTransfer-TransparentContainer',
                                                      'id-eNB-UE-S1AP-ID',
                                                      'id-GERANtoLTEHOInformationRes',
                                                      'id-GUMMEI-ID',
                                                      'id-GUMMEIType',
                                                      'id-HandoverRestrictionList',
                                                      'id-HandoverType',
                                                      'id-Masked-IMEISV',
                                                      'id-InformationOnRecommendedCellsAndENBsForPaging',
                                                      'id-InitialContextSetup',
                                                      'id-Inter-SystemInformationTransferTypeEDT',
                                                      'id-Inter-SystemInformationTransferTypeMDT',
                                                      'id-LPPa-PDU',
                                                      'id-NAS-DownlinkCount',
                                                      'id-ManagementBasedMDTAllowed',
                                                      'id-ManagementBasedMDTPLMNList',
                                                      'id-MMEname',
                                                      'id-MME-UE-S1AP-ID',
                                                      'id-MSClassmark2',
                                                      'id-MSClassmark3',
                                                      'id-NAS-PDU',
                                                      'id-NASSecurityParametersfromE-UTRAN',
                                                      'id-NASSecurityParameterstoE-UTRAN',
                                                      'id-OverloadResponse',
                                                      'id-pagingDRX',
                                                      'id-PagingPriority',
                                                      'id-RelativeMMECapacity',
                                                      'id-RequestType',
                                                      'id-Routing-ID',
                                                      'id-E-RABAdmittedItem',
                                                      'id-E-RABAdmittedList',
                                                      'id-E-RABDataForwardingItem',
                                                      'id-E-RABFailedToModifyList',
                                                      'id-E-RABFailedToReleaseList',
                                                      'id-E-RABFailedtoSetupItemHOReqAck',
                                                      'id-E-RABFailedToSetupListBearerSURes',
                                                      'id-E-RABFailedToSetupListCtxtSURes',
                                                      'id-E-RABFailedToSetupListHOReqAck',
                                                      'id-E-RABFailedToBeReleasedList',
                                                      'id-E-RABFailedToResumeListResumeReq',
                                                      'id-E-RABFailedToResumeItemResumeReq',
                                                      'id-E-RABFailedToResumeListResumeRes',
                                                      'id-E-RABFailedToResumeItemResumeRes',
                                                      'id-E-RABModify',
                                                      'id-E-RABModifyItemBearerModRes',
                                                      'id-E-RABModifyListBearerModRes',
                                                      'id-E-RABRelease',
                                                      'id-E-RABReleaseItemBearerRelComp',
                                                      'id-E-RABReleaseItemHOCmd',
                                                      'id-E-RABReleaseListBearerRelComp',
                                                      'id-E-RABReleaseIndication',
                                                      'id-E-RABSetup',
                                                      'id-E-RABSetupItemBearerSURes',
                                                      'id-E-RABSetupItemCtxtSURes',
                                                      'id-E-RABSetupListBearerSURes',
                                                      'id-E-RABSetupListCtxtSURes',
                                                      'id-E-RABSubjecttoDataForwardingList',
                                                      'id-E-RABToBeModifiedItemBearerModReq',
                                                      'id-E-RABToBeModifiedListBearerModReq',
                                                      'id-E-RABToBeModifiedListBearerModInd',
                                                      'id-E-RABToBeModifiedItemBearerModInd',
                                                      'id-E-RABNotToBeModifiedListBearerModInd',
                                                      'id-E-RABNotToBeModifiedItemBearerModInd',
                                                      'id-E-RABModifyListBearerModConf',
                                                      'id-E-RABModifyItemBearerModConf',
                                                      'id-E-RABFailedToModifyListBearerModConf',
                                                      'id-E-RABToBeReleasedListBearerModConf',
                                                      'id-E-RABToBeReleasedList',
                                                      'id-E-RABReleasedList',
                                                      'id-E-RABToBeSetupItemBearerSUReq',
                                                      'id-E-RABToBeSetupItemCtxtSUReq',
                                                      'id-E-RABToBeSetupItemHOReq',
                                                      'id-E-RABToBeSetupListBearerSUReq',
                                                      'id-E-RABToBeSetupListCtxtSUReq',
                                                      'id-E-RABToBeSetupListHOReq',
                                                      'id-E-RABToBeSwitchedDLItem',
                                                      'id-E-RABToBeSwitchedDLList',
                                                      'id-E-RABToBeSwitchedULList',
                                                      'id-E-RABToBeSwitchedULItem',
                                                      'id-E-RABtoReleaseListHOCmd',
                                                      'id-ProSeAuthorized',
                                                      'id-SecurityKey',
                                                      'id-SecurityContext',
                                                      'id-ServedGUMMEIs',
                                                      'id-SONConfigurationTransferECT',
                                                      'id-SONConfigurationTransferMCT',
                                                      'id-Source-ToTarget-TransparentContainer',
                                                      'id-Source-ToTarget-TransparentContainer-Secondary',
                                                      'id-SourceMME-UE-S1AP-ID',
                                                      'id-SRVCCOperationNotPossible',
                                                      'id-SRVCCOperationPossible',
                                                      'id-SRVCCHOIndication',
                                                      'id-SubscriberProfileIDforRFP',
                                                      'id-SupportedTAs',
                                                      'id-S-TMSI',
                                                      'id-TAI',
                                                      'id-TAIItem',
                                                      'id-TAIList',
                                                      'id-Target-ToSource-TransparentContainer',
                                                      'id-Target-ToSource-TransparentContainer-Secondary',
                                                      'id-TargetID',
                                                      'id-TimeToWait',
                                                      'id-TraceActivation',
                                                      'id-TrafficLoadReductionIndication',
                                                      'id-E-UTRAN-Trace-ID',
                                                      'id-UEIdentityIndexValue',
                                                      'id-UEPagingID',
                                                      'id-UERadioCapability',
                                                      'id-UERadioCapabilityForPaging',
                                                      'id-UTRANtoLTEHOInformationRes',
                                                      'id-UE-associatedLogicalS1-ConnectionListResAck',
                                                      'id-UE-associatedLogicalS1-ConnectionItem',
                                                      'id-UE-RetentionInformation',
                                                      'id-UESecurityCapabilities',
                                                      'id-UE-S1AP-IDs',
                                                      'id-V2XServicesAuthorized',
                                                      'id-ResetType',
                                                      'id-MessageIdentifier',
                                                      'id-SerialNumber',
                                                      'id-WarningAreaList',
                                                      'id-RepetitionPeriod',
                                                      'id-NumberofBroadcastRequest',
                                                      'id-WarningType',
                                                      'id-WarningSecurityInfo',
                                                      'id-DataCodingScheme',
                                                      'id-WarningMessageContents',
                                                      'id-BroadcastCompletedAreaList',
                                                      'id-BroadcastCancelledAreaList',
                                                      'id-RRC-Establishment-Cause',
                                                      'id-TraceCollectionEntityIPAddress',
                                                      'maxnoofTAIs',
                                                      'maxnoofErrors',
                                                      'maxnoofE-RABs',
                                                      'maxnoofIndividualS1ConnectionsToReset',
                                                      'maxnoofEmergencyAreaID',
                                                      'maxnoofCellID',
                                                      'maxnoofTAIforWarning',
                                                      'maxnoofCellinTAI',
                                                      'maxnoofCellinEAI',
                                                      'id-ExtendedRepetitionPeriod',
                                                      'id-PS-ServiceNotAvailable',
                                                      'id-RegisteredLAI',
                                                      'id-GUMMEIList',
                                                      'id-SourceMME-GUMMEI',
                                                      'id-MME-UE-S1AP-ID-2',
                                                      'id-GW-TransportLayerAddress',
                                                      'id-RelayNode-Indicator',
                                                      'id-Correlation-ID',
                                                      'id-MMERelaySupportIndicator',
                                                      'id-GWContextReleaseIndication',
                                                      'id-PrivacyIndicator',
                                                      'id-VoiceSupportMatchIndicator',
                                                      'id-Tunnel-Information-for-BBF',
                                                      'id-SIPTO-Correlation-ID',
                                                      'id-SIPTO-L-GW-TransportLayerAddress',
                                                      'id-KillAllWarningMessages',
                                                      'id-TransportInformation',
                                                      'id-LHN-ID',
                                                      'id-UserLocationInformation',
                                                      'id-AdditionalCSFallbackIndicator',
                                                      'id-ECGIListForRestart',
                                                      'id-TAIListForRestart',
                                                      'id-EmergencyAreaIDListForRestart',
                                                      'id-ExpectedUEBehaviour',
                                                      'id-Paging-eDRXInformation',
                                                      'id-extended-UEIdentityIndexValue',
                                                      'id-CSGMembershipInfo',
                                                      'id-MME-Group-ID',
                                                      'id-Additional-GUTI',
                                                      'id-S1-Message',
                                                      'id-PWSfailedECGIList',
                                                      'id-PWSFailureIndication',
                                                      'id-UE-Usage-Type',
                                                      'id-UEUserPlaneCIoTSupportIndicator',
                                                      'id-NB-IoT-DefaultPagingDRX',
                                                      'id-NB-IoT-Paging-eDRXInformation',
                                                      'id-CE-mode-B-SupportIndicator',
                                                      'id-NB-IoT-UEIdentityIndexValue',
                                                      'id-RRC-Resume-Cause',
                                                      'id-DCN-ID',
                                                      'id-ServedDCNs',
                                                      'id-UESidelinkAggregateMaximumBitrate',
                                                      'id-DLNASPDUDeliveryAckRequest',
                                                      'id-Coverage-Level',
                                                      'id-EnhancedCoverageRestricted',
                                                      'id-UE-Level-QoS-Parameters',
                                                      'id-DL-CP-SecurityInformation',
                                                      'id-UL-CP-SecurityInformation'],
                                   'S1AP-Containers': ['PrivateIE-Container',
                                                       '{',
                                                       '}',
                                                       'ProtocolExtensionContainer',
                                                       '{',
                                                       '}',
                                                       'ProtocolIE-Container',
                                                       '{',
                                                       '}',
                                                       'ProtocolIE-ContainerList',
                                                       '{',
                                                       '}',
                                                       'ProtocolIE-ContainerPair',
                                                       '{',
                                                       '}',
                                                       'ProtocolIE-ContainerPairList',
                                                       '{',
                                                       '}',
                                                       'ProtocolIE-SingleContainer',
                                                       '{',
                                                       '}',
                                                       'S1AP-PRIVATE-IES',
                                                       'S1AP-PROTOCOL-EXTENSION',
                                                       'S1AP-PROTOCOL-IES',
                                                       'S1AP-PROTOCOL-IES-PAIR'],
                                   'S1AP-IEs': ['UEAggregateMaximumBitrate',
                                                'BearerType',
                                                'Cause',
                                                'CellAccessMode',
                                                'Cdma2000HORequiredIndication',
                                                'Cdma2000HOStatus',
                                                'Cdma2000OneXSRVCCInfo',
                                                'Cdma2000OneXRAND',
                                                'Cdma2000PDU',
                                                'Cdma2000RATType',
                                                'Cdma2000SectorID',
                                                'EUTRANRoundTripDelayEstimationInfo',
                                                'CNDomain',
                                                'ConcurrentWarningMessageIndicator',
                                                'CriticalityDiagnostics',
                                                'CSFallbackIndicator',
                                                'CSG-Id',
                                                'CSG-IdList',
                                                'CSGMembershipStatus',
                                                'Data-Forwarding-Not-Possible',
                                                'Direct-Forwarding-Path-Availability',
                                                'Global-ENB-ID',
                                                'EUTRAN-CGI',
                                                'ENBname',
                                                'ENB-StatusTransfer-TransparentContainer',
                                                'ENB-UE-S1AP-ID',
                                                'ExtendedRepetitionPeriod',
                                                'GTP-TEID',
                                                'GUMMEI',
                                                'GUMMEIType',
                                                'HandoverRestrictionList',
                                                'HandoverType',
                                                'Masked-IMEISV',
                                                'LAI',
                                                'LPPa-PDU',
                                                'ManagementBasedMDTAllowed',
                                                'MDTPLMNList',
                                                'MMEname',
                                                'MMERelaySupportIndicator',
                                                'MME-UE-S1AP-ID',
                                                'MSClassmark2',
                                                'MSClassmark3',
                                                'NAS-PDU',
                                                'NASSecurityParametersfromE-UTRAN',
                                                'NASSecurityParameterstoE-UTRAN',
                                                'OverloadResponse',
                                                'PagingDRX',
                                                'PagingPriority',
                                                'PLMNidentity',
                                                'ProSeAuthorized',
                                                'RIMTransfer',
                                                'RelativeMMECapacity',
                                                'RequestType',
                                                'E-RAB-ID',
                                                'E-RABLevelQoSParameters',
                                                'E-RABList',
                                                'RelayNode-Indicator',
                                                'Routing-ID',
                                                'SecurityKey',
                                                'SecurityContext',
                                                'ServedGUMMEIs',
                                                'SONConfigurationTransfer',
                                                'Source-ToTarget-TransparentContainer',
                                                'SourceBSS-ToTargetBSS-TransparentContainer',
                                                'SourceeNB-ToTargeteNB-TransparentContainer',
                                                'SourceRNC-ToTargetRNC-TransparentContainer',
                                                'SubscriberProfileIDforRFP',
                                                'SRVCCOperationNotPossible',
                                                'SRVCCOperationPossible',
                                                'SRVCCHOIndication',
                                                'SupportedTAs',
                                                'TAI',
                                                'Target-ToSource-TransparentContainer',
                                                'TargetBSS-ToSourceBSS-TransparentContainer',
                                                'TargeteNB-ToSourceeNB-TransparentContainer',
                                                'TargetID',
                                                'TargetRNC-ToSourceRNC-TransparentContainer',
                                                'TimeToWait',
                                                'TraceActivation',
                                                'TrafficLoadReductionIndication',
                                                'E-UTRAN-Trace-ID',
                                                'TransportLayerAddress',
                                                'UEIdentityIndexValue',
                                                'UEPagingID',
                                                'UERadioCapability',
                                                'UERadioCapabilityForPaging',
                                                'UE-RetentionInformation',
                                                'UE-S1AP-IDs',
                                                'UE-associatedLogicalS1-ConnectionItem',
                                                'UESecurityCapabilities',
                                                'S-TMSI',
                                                'MessageIdentifier',
                                                'SerialNumber',
                                                'WarningAreaList',
                                                'RepetitionPeriod',
                                                'NumberofBroadcastRequest',
                                                'WarningType',
                                                'WarningSecurityInfo',
                                                'DataCodingScheme',
                                                'WarningMessageContents',
                                                'BroadcastCompletedAreaList',
                                                'RRC-Establishment-Cause',
                                                'BroadcastCancelledAreaList',
                                                'PS-ServiceNotAvailable',
                                                'GUMMEIList',
                                                'Correlation-ID',
                                                'GWContextReleaseIndication',
                                                'PrivacyIndicator',
                                                'VoiceSupportMatchIndicator',
                                                'TunnelInformation',
                                                'KillAllWarningMessages',
                                                'TransportInformation',
                                                'LHN-ID',
                                                'UserLocationInformation',
                                                'AdditionalCSFallbackIndicator',
                                                'ECGIListForRestart',
                                                'TAIListForRestart',
                                                'EmergencyAreaIDListForRestart',
                                                'ExpectedUEBehaviour',
                                                'Paging-eDRXInformation',
                                                'Extended-UEIdentityIndexValue',
                                                'MME-Group-ID',
                                                'Additional-GUTI',
                                                'PWSfailedECGIList',
                                                'CellIdentifierAndCELevelForCECapableUEs',
                                                'AssistanceDataForPaging',
                                                'InformationOnRecommendedCellsAndENBsForPaging',
                                                'UE-Usage-Type',
                                                'UEUserPlaneCIoTSupportIndicator',
                                                'NB-IoT-DefaultPagingDRX',
                                                'NB-IoT-Paging-eDRXInformation',
                                                'CE-mode-B-SupportIndicator',
                                                'NB-IoT-UEIdentityIndexValue',
                                                'V2XServicesAuthorized',
                                                'DCN-ID',
                                                'ServedDCNs',
                                                'UESidelinkAggregateMaximumBitrate',
                                                'DLNASPDUDeliveryAckRequest',
                                                'Coverage-Level',
                                                'EnhancedCoverageRestricted',
                                                'DL-CP-SecurityInformation',
                                                'UL-CP-SecurityInformation']},
                       'object-classes': {},
                       'object-sets': {'CSGMembershipInfo-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                    'members': ['.']},
                                       'CellTrafficTraceIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                               'members': []},
                                       'ConnectionEstablishmentIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                'members': []},
                                       'DeactivateTraceIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                              'members': []},
                                       'DownlinkNASTransport-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                    'members': []},
                                       'DownlinkNonUEAssociatedLPPaTransport-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                    'members': []},
                                       'DownlinkS1cdma2000tunnellingIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'DownlinkUEAssociatedLPPaTransport-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                 'members': []},
                                       'E-RABAdmittedItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                    'members': ['.']},
                                       'E-RABAdmittedItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                'members': []},
                                       'E-RABDataForwardingItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                          'members': ['.']},
                                       'E-RABDataForwardingItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'E-RABFailedToResumeItemResumeReq-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                   'members': ['.']},
                                       'E-RABFailedToResumeItemResumeReqIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                               'members': []},
                                       'E-RABFailedToResumeItemResumeRes-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                   'members': ['.']},
                                       'E-RABFailedToResumeItemResumeResIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                               'members': []},
                                       'E-RABFailedToSetupItemHOReqAckExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                'members': ['.']},
                                       'E-RABFailedtoSetupItemHOReqAckIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                             'members': []},
                                       'E-RABModificationConfirmIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'E-RABModificationIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                          'members': []},
                                       'E-RABModifyItemBearerModConfExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                              'members': ['.']},
                                       'E-RABModifyItemBearerModConfIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'E-RABModifyItemBearerModResExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                             'members': ['.']},
                                       'E-RABModifyItemBearerModResIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                          'members': []},
                                       'E-RABModifyRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                 'members': []},
                                       'E-RABModifyResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                  'members': []},
                                       'E-RABNotToBeModifiedItemBearerModInd-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                       'members': ['.']},
                                       'E-RABNotToBeModifiedItemBearerModIndIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                   'members': []},
                                       'E-RABReleaseCommandIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                  'members': []},
                                       'E-RABReleaseIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                     'members': []},
                                       'E-RABReleaseItemBearerRelCompExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                               'members': ['.']},
                                       'E-RABReleaseItemBearerRelCompIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                            'members': []},
                                       'E-RABReleaseResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                   'members': []},
                                       'E-RABSetupItemBearerSUResExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                           'members': ['.']},
                                       'E-RABSetupItemBearerSUResIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                        'members': []},
                                       'E-RABSetupItemCtxtSUResExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                         'members': ['.']},
                                       'E-RABSetupItemCtxtSUResIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'E-RABSetupRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                'members': []},
                                       'E-RABSetupResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                 'members': []},
                                       'E-RABToBeModifiedItemBearerModInd-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                    'members': ['.']},
                                       'E-RABToBeModifiedItemBearerModIndIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                'members': []},
                                       'E-RABToBeModifiedItemBearerModReqIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                'members': []},
                                       'E-RABToBeModifyItemBearerModReqExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                                 'members': []},
                                       'E-RABToBeSetupItemBearerSUReqExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                               'members': []},
                                       'E-RABToBeSetupItemBearerSUReqIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                            'members': []},
                                       'E-RABToBeSetupItemCtxtSUReqExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                             'members': []},
                                       'E-RABToBeSetupItemCtxtSUReqIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                          'members': []},
                                       'E-RABToBeSetupItemHOReq-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                          'members': []},
                                       'E-RABToBeSetupItemHOReqIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'E-RABToBeSwitchedDLItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                          'members': ['.']},
                                       'E-RABToBeSwitchedDLItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'E-RABToBeSwitchedULItem-ExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                                          'members': ['.']},
                                       'E-RABToBeSwitchedULItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'ENBCPRelocationIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                        'members': []},
                                       'ENBConfigurationTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'ENBConfigurationUpdateAcknowledgeIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                'members': []},
                                       'ENBConfigurationUpdateFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                            'members': []},
                                       'ENBConfigurationUpdateIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                     'members': []},
                                       'ENBDirectInformationTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'ENBStatusTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                'members': []},
                                       'ErrorIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                              'members': []},
                                       'HandoverCancelAcknowledgeIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                        'members': []},
                                       'HandoverCancelIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                             'members': []},
                                       'HandoverCommandIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                              'members': []},
                                       'HandoverFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                              'members': []},
                                       'HandoverNotifyIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                             'members': []},
                                       'HandoverPreparationFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'HandoverRequestAcknowledgeIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'HandoverRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                              'members': []},
                                       'HandoverRequiredIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                               'members': []},
                                       'InitialContextSetupFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'InitialContextSetupRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'InitialContextSetupResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                          'members': []},
                                       'InitialUEMessage-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                'members': []},
                                       'KillRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                          'members': []},
                                       'KillResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                           'members': []},
                                       'LocationReportIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                             'members': []},
                                       'LocationReportingControlIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'LocationReportingFailureIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                 'members': []},
                                       'MMECPRelocationIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                        'members': []},
                                       'MMEConfigurationTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'MMEConfigurationUpdateAcknowledgeIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                'members': []},
                                       'MMEConfigurationUpdateFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                            'members': []},
                                       'MMEConfigurationUpdateIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                     'members': []},
                                       'MMEDirectInformationTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'MMEStatusTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                'members': []},
                                       'NASDeliveryIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                    'members': ['.']},
                                       'NASNonDeliveryIndication-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                        'members': []},
                                       'OverloadStartIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                            'members': []},
                                       'OverloadStopIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                           'members': []},
                                       'PWSFailureIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                   'members': []},
                                       'PWSRestartIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                   'members': []},
                                       'PagingIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                     'members': []},
                                       'PathSwitchRequestAcknowledgeIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'PathSwitchRequestFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'PathSwitchRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                'members': []},
                                       'PrivateMessageIEs': {'class': 'S1AP-PRIVATE-IES',
                                                             'members': ['.']},
                                       'RerouteNASRequest-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                 'members': []},
                                       'ResetAcknowledgeIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                               'members': []},
                                       'ResetIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                    'members': []},
                                       'RetrieveUEInformationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                    'members': []},
                                       'S1SetupFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                             'members': []},
                                       'S1SetupRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                             'members': []},
                                       'S1SetupResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                              'members': []},
                                       'TAIItemExtIEs': {'class': 'S1AP-PROTOCOL-EXTENSION',
                                                         'members': ['.']},
                                       'TAIItemIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                      'members': []},
                                       'TraceFailureIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                     'members': []},
                                       'TraceStartIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                         'members': []},
                                       'UE-associatedLogicalS1-ConnectionItemRes': {'class': 'S1AP-PROTOCOL-IES',
                                                                                    'members': []},
                                       'UE-associatedLogicalS1-ConnectionItemResAck': {'class': 'S1AP-PROTOCOL-IES',
                                                                                       'members': []},
                                       'UECapabilityInfoIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'UEContextModificationConfirmIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'UEContextModificationFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'UEContextModificationIndicationIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                              'members': []},
                                       'UEContextModificationRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                           'members': []},
                                       'UEContextModificationResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                            'members': []},
                                       'UEContextReleaseCommand-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'UEContextReleaseComplete-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                        'members': []},
                                       'UEContextReleaseRequest-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'UEContextResumeFailureIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                     'members': []},
                                       'UEContextResumeRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                     'members': []},
                                       'UEContextResumeResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'UEContextSuspendRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                      'members': []},
                                       'UEContextSuspendResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                       'members': []},
                                       'UEInformationTransferIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                    'members': []},
                                       'UERadioCapabilityMatchRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                            'members': []},
                                       'UERadioCapabilityMatchResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                             'members': []},
                                       'UplinkNASTransport-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                  'members': []},
                                       'UplinkNonUEAssociatedLPPaTransport-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                                  'members': []},
                                       'UplinkS1cdma2000tunnellingIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'UplinkUEAssociatedLPPaTransport-IEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                               'members': []},
                                       'WriteReplaceWarningRequestIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                         'members': []},
                                       'WriteReplaceWarningResponseIEs': {'class': 'S1AP-PROTOCOL-IES',
                                                                          'members': []}},
                       'tags': 'AUTOMATIC',
                       'types': {'CSGMembershipInfo': {'members': [{'name': 'cSGMembershipStatus',
                                                                    'type': 'CSGMembershipStatus'},
                                                                   {'name': 'cSG-Id',
                                                                    'type': 'CSG-Id'},
                                                                   {'name': 'cellAccessMode',
                                                                    'optional': True,
                                                                    'type': 'CellAccessMode'},
                                                                   {'name': 'pLMNidentity',
                                                                    'optional': True,
                                                                    'type': 'PLMNidentity'},
                                                                   {'name': 'iE-Extensions',
                                                                    'optional': True,
                                                                    'type': 'ProtocolExtensionContainer'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'CellTrafficTrace': {'members': [{'name': 'protocolIEs',
                                                                   'type': 'ProtocolIE-Container'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                 'ConnectionEstablishmentIndication': {'members': [{'name': 'protocolIEs',
                                                                                    'type': 'ProtocolIE-Container'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                 'DeactivateTrace': {'members': [{'name': 'protocolIEs',
                                                                  'type': 'ProtocolIE-Container'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                 'DownlinkNASTransport': {'members': [{'name': 'protocolIEs',
                                                                       'type': 'ProtocolIE-Container'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                 'DownlinkNonUEAssociatedLPPaTransport': {'members': [{'name': 'protocolIEs',
                                                                                       'type': 'ProtocolIE-Container'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                 'DownlinkS1cdma2000tunnelling': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'DownlinkUEAssociatedLPPaTransport': {'members': [{'name': 'protocolIEs',
                                                                                    'type': 'ProtocolIE-Container'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                 'E-RAB-IE-ContainerList': {'type': 'ProtocolIE-ContainerList'},
                                 'E-RAB-IE-ContainerPairList': {'type': 'ProtocolIE-ContainerPairList'},
                                 'E-RABAdmittedItem': {'members': [{'name': 'e-RAB-ID',
                                                                    'type': 'E-RAB-ID'},
                                                                   {'name': 'transportLayerAddress',
                                                                    'type': 'TransportLayerAddress'},
                                                                   {'name': 'gTP-TEID',
                                                                    'type': 'GTP-TEID'},
                                                                   {'name': 'dL-transportLayerAddress',
                                                                    'optional': True,
                                                                    'type': 'TransportLayerAddress'},
                                                                   {'name': 'dL-gTP-TEID',
                                                                    'optional': True,
                                                                    'type': 'GTP-TEID'},
                                                                   {'name': 'uL-TransportLayerAddress',
                                                                    'optional': True,
                                                                    'type': 'TransportLayerAddress'},
                                                                   {'name': 'uL-GTP-TEID',
                                                                    'optional': True,
                                                                    'type': 'GTP-TEID'},
                                                                   {'name': 'iE-Extensions',
                                                                    'optional': True,
                                                                    'type': 'ProtocolExtensionContainer'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'E-RABAdmittedList': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABDataForwardingItem': {'members': [{'name': 'e-RAB-ID',
                                                                          'type': 'E-RAB-ID'},
                                                                         {'name': 'dL-transportLayerAddress',
                                                                          'optional': True,
                                                                          'type': 'TransportLayerAddress'},
                                                                         {'name': 'dL-gTP-TEID',
                                                                          'optional': True,
                                                                          'type': 'GTP-TEID'},
                                                                         {'name': 'uL-TransportLayerAddress',
                                                                          'optional': True,
                                                                          'type': 'TransportLayerAddress'},
                                                                         {'name': 'uL-GTP-TEID',
                                                                          'optional': True,
                                                                          'type': 'GTP-TEID'},
                                                                         {'name': 'iE-Extensions',
                                                                          'optional': True,
                                                                          'type': 'ProtocolExtensionContainer'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'E-RABFailedToResumeItemResumeReq': {'members': [{'name': 'e-RAB-ID',
                                                                                   'type': 'E-RAB-ID'},
                                                                                  {'name': 'cause',
                                                                                   'type': 'Cause'},
                                                                                  {'name': 'iE-Extensions',
                                                                                   'optional': True,
                                                                                   'type': 'ProtocolExtensionContainer'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                 'E-RABFailedToResumeItemResumeRes': {'members': [{'name': 'e-RAB-ID',
                                                                                   'type': 'E-RAB-ID'},
                                                                                  {'name': 'cause',
                                                                                   'type': 'Cause'},
                                                                                  {'name': 'iE-Extensions',
                                                                                   'optional': True,
                                                                                   'type': 'ProtocolExtensionContainer'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                 'E-RABFailedToResumeListResumeReq': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABFailedToResumeListResumeRes': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABFailedToSetupItemHOReqAck': {'members': [{'name': 'e-RAB-ID',
                                                                                 'type': 'E-RAB-ID'},
                                                                                {'name': 'cause',
                                                                                 'type': 'Cause'},
                                                                                {'name': 'iE-Extensions',
                                                                                 'optional': True,
                                                                                 'type': 'ProtocolExtensionContainer'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                 'E-RABFailedtoSetupListHOReqAck': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABModificationConfirm': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'E-RABModificationIndication': {'members': [{'name': 'protocolIEs',
                                                                              'type': 'ProtocolIE-Container'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                 'E-RABModifyItemBearerModConf': {'members': [{'name': 'e-RAB-ID',
                                                                               'type': 'E-RAB-ID'},
                                                                              {'name': 'iE-Extensions',
                                                                               'optional': True,
                                                                               'type': 'ProtocolExtensionContainer'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'E-RABModifyItemBearerModRes': {'members': [{'name': 'e-RAB-ID',
                                                                              'type': 'E-RAB-ID'},
                                                                             {'name': 'iE-Extensions',
                                                                              'optional': True,
                                                                              'type': 'ProtocolExtensionContainer'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                 'E-RABModifyListBearerModConf': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                  'size': [(1,
                                                                            'maxnoofE-RABs')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                                 'E-RABModifyListBearerModRes': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                 'size': [(1,
                                                                           'maxnoofE-RABs')],
                                                                 'type': 'SEQUENCE '
                                                                         'OF'},
                                 'E-RABModifyRequest': {'members': [{'name': 'protocolIEs',
                                                                     'type': 'ProtocolIE-Container'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                 'E-RABModifyResponse': {'members': [{'name': 'protocolIEs',
                                                                      'type': 'ProtocolIE-Container'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                 'E-RABNotToBeModifiedItemBearerModInd': {'members': [{'name': 'e-RAB-ID',
                                                                                       'type': 'E-RAB-ID'},
                                                                                      {'name': 'transportLayerAddress',
                                                                                       'type': 'TransportLayerAddress'},
                                                                                      {'name': 'dL-GTP-TEID',
                                                                                       'type': 'GTP-TEID'},
                                                                                      {'name': 'iE-Extensions',
                                                                                       'optional': True,
                                                                                       'type': 'ProtocolExtensionContainer'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                 'E-RABNotToBeModifiedListBearerModInd': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABReleaseCommand': {'members': [{'name': 'protocolIEs',
                                                                      'type': 'ProtocolIE-Container'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                 'E-RABReleaseIndication': {'members': [{'name': 'protocolIEs',
                                                                         'type': 'ProtocolIE-Container'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                 'E-RABReleaseItemBearerRelComp': {'members': [{'name': 'e-RAB-ID',
                                                                                'type': 'E-RAB-ID'},
                                                                               {'name': 'iE-Extensions',
                                                                                'optional': True,
                                                                                'type': 'ProtocolExtensionContainer'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                 'E-RABReleaseListBearerRelComp': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                   'size': [(1,
                                                                             'maxnoofE-RABs')],
                                                                   'type': 'SEQUENCE '
                                                                           'OF'},
                                 'E-RABReleaseResponse': {'members': [{'name': 'protocolIEs',
                                                                       'type': 'ProtocolIE-Container'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                 'E-RABSetupItemBearerSURes': {'members': [{'name': 'e-RAB-ID',
                                                                            'type': 'E-RAB-ID'},
                                                                           {'name': 'transportLayerAddress',
                                                                            'type': 'TransportLayerAddress'},
                                                                           {'name': 'gTP-TEID',
                                                                            'type': 'GTP-TEID'},
                                                                           {'name': 'iE-Extensions',
                                                                            'optional': True,
                                                                            'type': 'ProtocolExtensionContainer'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                 'E-RABSetupItemCtxtSURes': {'members': [{'name': 'e-RAB-ID',
                                                                          'type': 'E-RAB-ID'},
                                                                         {'name': 'transportLayerAddress',
                                                                          'type': 'TransportLayerAddress'},
                                                                         {'name': 'gTP-TEID',
                                                                          'type': 'GTP-TEID'},
                                                                         {'name': 'iE-Extensions',
                                                                          'optional': True,
                                                                          'type': 'ProtocolExtensionContainer'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'E-RABSetupListBearerSURes': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                               'size': [(1,
                                                                         'maxnoofE-RABs')],
                                                               'type': 'SEQUENCE '
                                                                       'OF'},
                                 'E-RABSetupListCtxtSURes': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                             'size': [(1,
                                                                       'maxnoofE-RABs')],
                                                             'type': 'SEQUENCE '
                                                                     'OF'},
                                 'E-RABSetupRequest': {'members': [{'name': 'protocolIEs',
                                                                    'type': 'ProtocolIE-Container'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'E-RABSetupResponse': {'members': [{'name': 'protocolIEs',
                                                                     'type': 'ProtocolIE-Container'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                 'E-RABSubjecttoDataForwardingList': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABToBeModifiedItemBearerModInd': {'members': [{'name': 'e-RAB-ID',
                                                                                    'type': 'E-RAB-ID'},
                                                                                   {'name': 'transportLayerAddress',
                                                                                    'type': 'TransportLayerAddress'},
                                                                                   {'name': 'dL-GTP-TEID',
                                                                                    'type': 'GTP-TEID'},
                                                                                   {'name': 'iE-Extensions',
                                                                                    'optional': True,
                                                                                    'type': 'ProtocolExtensionContainer'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                 'E-RABToBeModifiedItemBearerModReq': {'members': [{'name': 'e-RAB-ID',
                                                                                    'type': 'E-RAB-ID'},
                                                                                   {'name': 'e-RABLevelQoSParameters',
                                                                                    'type': 'E-RABLevelQoSParameters'},
                                                                                   {'name': 'nAS-PDU',
                                                                                    'type': 'NAS-PDU'},
                                                                                   {'name': 'iE-Extensions',
                                                                                    'optional': True,
                                                                                    'type': 'ProtocolExtensionContainer'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                 'E-RABToBeModifiedListBearerModInd': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABToBeModifiedListBearerModReq': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                       'size': [(1,
                                                                                 'maxnoofE-RABs')],
                                                                       'type': 'SEQUENCE '
                                                                               'OF'},
                                 'E-RABToBeSetupItemBearerSUReq': {'members': [{'name': 'e-RAB-ID',
                                                                                'type': 'E-RAB-ID'},
                                                                               {'name': 'e-RABlevelQoSParameters',
                                                                                'type': 'E-RABLevelQoSParameters'},
                                                                               {'name': 'transportLayerAddress',
                                                                                'type': 'TransportLayerAddress'},
                                                                               {'name': 'gTP-TEID',
                                                                                'type': 'GTP-TEID'},
                                                                               {'name': 'nAS-PDU',
                                                                                'type': 'NAS-PDU'},
                                                                               {'name': 'iE-Extensions',
                                                                                'optional': True,
                                                                                'type': 'ProtocolExtensionContainer'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                 'E-RABToBeSetupItemCtxtSUReq': {'members': [{'name': 'e-RAB-ID',
                                                                              'type': 'E-RAB-ID'},
                                                                             {'name': 'e-RABlevelQoSParameters',
                                                                              'type': 'E-RABLevelQoSParameters'},
                                                                             {'name': 'transportLayerAddress',
                                                                              'type': 'TransportLayerAddress'},
                                                                             {'name': 'gTP-TEID',
                                                                              'type': 'GTP-TEID'},
                                                                             {'name': 'nAS-PDU',
                                                                              'optional': True,
                                                                              'type': 'NAS-PDU'},
                                                                             {'name': 'iE-Extensions',
                                                                              'optional': True,
                                                                              'type': 'ProtocolExtensionContainer'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                 'E-RABToBeSetupItemHOReq': {'members': [{'name': 'e-RAB-ID',
                                                                          'type': 'E-RAB-ID'},
                                                                         {'name': 'transportLayerAddress',
                                                                          'type': 'TransportLayerAddress'},
                                                                         {'name': 'gTP-TEID',
                                                                          'type': 'GTP-TEID'},
                                                                         {'name': 'e-RABlevelQosParameters',
                                                                          'type': 'E-RABLevelQoSParameters'},
                                                                         {'name': 'iE-Extensions',
                                                                          'optional': True,
                                                                          'type': 'ProtocolExtensionContainer'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'E-RABToBeSetupListBearerSUReq': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                   'size': [(1,
                                                                             'maxnoofE-RABs')],
                                                                   'type': 'SEQUENCE '
                                                                           'OF'},
                                 'E-RABToBeSetupListCtxtSUReq': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                 'size': [(1,
                                                                           'maxnoofE-RABs')],
                                                                 'type': 'SEQUENCE '
                                                                         'OF'},
                                 'E-RABToBeSetupListHOReq': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABToBeSwitchedDLItem': {'members': [{'name': 'e-RAB-ID',
                                                                          'type': 'E-RAB-ID'},
                                                                         {'name': 'transportLayerAddress',
                                                                          'type': 'TransportLayerAddress'},
                                                                         {'name': 'gTP-TEID',
                                                                          'type': 'GTP-TEID'},
                                                                         {'name': 'iE-Extensions',
                                                                          'optional': True,
                                                                          'type': 'ProtocolExtensionContainer'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'E-RABToBeSwitchedDLList': {'type': 'E-RAB-IE-ContainerList'},
                                 'E-RABToBeSwitchedULItem': {'members': [{'name': 'e-RAB-ID',
                                                                          'type': 'E-RAB-ID'},
                                                                         {'name': 'transportLayerAddress',
                                                                          'type': 'TransportLayerAddress'},
                                                                         {'name': 'gTP-TEID',
                                                                          'type': 'GTP-TEID'},
                                                                         {'name': 'iE-Extensions',
                                                                          'optional': True,
                                                                          'type': 'ProtocolExtensionContainer'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'E-RABToBeSwitchedULList': {'type': 'E-RAB-IE-ContainerList'},
                                 'ENBCPRelocationIndication': {'members': [{'name': 'protocolIEs',
                                                                            'type': 'ProtocolIE-Container'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                 'ENBConfigurationTransfer': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'ENBConfigurationUpdate': {'members': [{'name': 'protocolIEs',
                                                                         'type': 'ProtocolIE-Container'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                 'ENBConfigurationUpdateAcknowledge': {'members': [{'name': 'protocolIEs',
                                                                                    'type': 'ProtocolIE-Container'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                 'ENBConfigurationUpdateFailure': {'members': [{'name': 'protocolIEs',
                                                                                'type': 'ProtocolIE-Container'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                 'ENBDirectInformationTransfer': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'ENBStatusTransfer': {'members': [{'name': 'protocolIEs',
                                                                    'type': 'ProtocolIE-Container'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'ErrorIndication': {'members': [{'name': 'protocolIEs',
                                                                  'type': 'ProtocolIE-Container'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                 'HandoverCancel': {'members': [{'name': 'protocolIEs',
                                                                 'type': 'ProtocolIE-Container'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                 'HandoverCancelAcknowledge': {'members': [{'name': 'protocolIEs',
                                                                            'type': 'ProtocolIE-Container'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                 'HandoverCommand': {'members': [{'name': 'protocolIEs',
                                                                  'type': 'ProtocolIE-Container'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                 'HandoverFailure': {'members': [{'name': 'protocolIEs',
                                                                  'type': 'ProtocolIE-Container'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                 'HandoverNotify': {'members': [{'name': 'protocolIEs',
                                                                 'type': 'ProtocolIE-Container'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                 'HandoverPreparationFailure': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'HandoverRequest': {'members': [{'name': 'protocolIEs',
                                                                  'type': 'ProtocolIE-Container'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                 'HandoverRequestAcknowledge': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'HandoverRequired': {'members': [{'name': 'protocolIEs',
                                                                   'type': 'ProtocolIE-Container'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                 'InitialContextSetupFailure': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'InitialContextSetupRequest': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'InitialContextSetupResponse': {'members': [{'name': 'protocolIEs',
                                                                              'type': 'ProtocolIE-Container'},
                                                                             None],
                                                                 'type': 'SEQUENCE'},
                                 'InitialUEMessage': {'members': [{'name': 'protocolIEs',
                                                                   'type': 'ProtocolIE-Container'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                 'Inter-SystemInformationTransferType': {'members': [{'name': 'rIMTransfer',
                                                                                      'type': 'RIMTransfer'},
                                                                                     None],
                                                                         'type': 'CHOICE'},
                                 'KillRequest': {'members': [{'name': 'protocolIEs',
                                                              'type': 'ProtocolIE-Container'},
                                                             None],
                                                 'type': 'SEQUENCE'},
                                 'KillResponse': {'members': [{'name': 'protocolIEs',
                                                               'type': 'ProtocolIE-Container'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                                 'LocationReport': {'members': [{'name': 'protocolIEs',
                                                                 'type': 'ProtocolIE-Container'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                 'LocationReportingControl': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'LocationReportingFailureIndication': {'members': [{'name': 'protocolIEs',
                                                                                     'type': 'ProtocolIE-Container'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                 'MMECPRelocationIndication': {'members': [{'name': 'protocolIEs',
                                                                            'type': 'ProtocolIE-Container'},
                                                                           None],
                                                               'type': 'SEQUENCE'},
                                 'MMEConfigurationTransfer': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'MMEConfigurationUpdate': {'members': [{'name': 'protocolIEs',
                                                                         'type': 'ProtocolIE-Container'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                 'MMEConfigurationUpdateAcknowledge': {'members': [{'name': 'protocolIEs',
                                                                                    'type': 'ProtocolIE-Container'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                 'MMEConfigurationUpdateFailure': {'members': [{'name': 'protocolIEs',
                                                                                'type': 'ProtocolIE-Container'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                 'MMEDirectInformationTransfer': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'MMEStatusTransfer': {'members': [{'name': 'protocolIEs',
                                                                    'type': 'ProtocolIE-Container'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'NASDeliveryIndication': {'members': [{'name': 'protocolIEs',
                                                                        'type': 'ProtocolIE-Container'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                 'NASNonDeliveryIndication': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'OverloadStart': {'members': [{'name': 'protocolIEs',
                                                                'type': 'ProtocolIE-Container'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                 'OverloadStop': {'members': [{'name': 'protocolIEs',
                                                               'type': 'ProtocolIE-Container'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                                 'PWSFailureIndication': {'members': [{'name': 'protocolIEs',
                                                                       'type': 'ProtocolIE-Container'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                 'PWSRestartIndication': {'members': [{'name': 'protocolIEs',
                                                                       'type': 'ProtocolIE-Container'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                 'Paging': {'members': [{'name': 'protocolIEs',
                                                         'type': 'ProtocolIE-Container'},
                                                        None],
                                            'type': 'SEQUENCE'},
                                 'PathSwitchRequest': {'members': [{'name': 'protocolIEs',
                                                                    'type': 'ProtocolIE-Container'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'PathSwitchRequestAcknowledge': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'PathSwitchRequestFailure': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'PrivateMessage': {'members': [{'name': 'privateIEs',
                                                                 'type': 'PrivateIE-Container'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                 'ProtocolError-IE-ContainerList': {'type': 'ProtocolIE-ContainerList'},
                                 'RerouteNASRequest': {'members': [{'name': 'protocolIEs',
                                                                    'type': 'ProtocolIE-Container'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                 'Reset': {'members': [{'name': 'protocolIEs',
                                                        'type': 'ProtocolIE-Container'},
                                                       None],
                                           'type': 'SEQUENCE'},
                                 'ResetAcknowledge': {'members': [{'name': 'protocolIEs',
                                                                   'type': 'ProtocolIE-Container'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                 'ResetAll': {'type': 'ENUMERATED',
                                              'values': [('reset-all', 0),
                                                         None]},
                                 'ResetType': {'members': [{'name': 's1-Interface',
                                                            'type': 'ResetAll'},
                                                           {'name': 'partOfS1-Interface',
                                                            'type': 'UE-associatedLogicalS1-ConnectionListRes'},
                                                           None],
                                               'type': 'CHOICE'},
                                 'RetrieveUEInformation': {'members': [{'name': 'protocolIEs',
                                                                        'type': 'ProtocolIE-Container'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                 'S1SetupFailure': {'members': [{'name': 'protocolIEs',
                                                                 'type': 'ProtocolIE-Container'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                 'S1SetupRequest': {'members': [{'name': 'protocolIEs',
                                                                 'type': 'ProtocolIE-Container'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                 'S1SetupResponse': {'members': [{'name': 'protocolIEs',
                                                                  'type': 'ProtocolIE-Container'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                 'TAIItem': {'members': [{'name': 'tAI',
                                                          'type': 'TAI'},
                                                         {'name': 'iE-Extensions',
                                                          'optional': True,
                                                          'type': 'ProtocolExtensionContainer'},
                                                         None],
                                             'type': 'SEQUENCE'},
                                 'TAIList': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                             'size': [(1, 'maxnoofTAIs')],
                                             'type': 'SEQUENCE OF'},
                                 'TraceFailureIndication': {'members': [{'name': 'protocolIEs',
                                                                         'type': 'ProtocolIE-Container'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                 'TraceStart': {'members': [{'name': 'protocolIEs',
                                                             'type': 'ProtocolIE-Container'},
                                                            None],
                                                'type': 'SEQUENCE'},
                                 'UE-associatedLogicalS1-ConnectionListRes': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                              'size': [(1,
                                                                                        'maxnoofIndividualS1ConnectionsToReset')],
                                                                              'type': 'SEQUENCE '
                                                                                      'OF'},
                                 'UE-associatedLogicalS1-ConnectionListResAck': {'element': {'type': 'ProtocolIE-SingleContainer'},
                                                                                 'size': [(1,
                                                                                           'maxnoofIndividualS1ConnectionsToReset')],
                                                                                 'type': 'SEQUENCE '
                                                                                         'OF'},
                                 'UECapabilityInfoIndication': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'UEContextModificationConfirm': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'UEContextModificationFailure': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'UEContextModificationIndication': {'members': [{'name': 'protocolIEs',
                                                                                  'type': 'ProtocolIE-Container'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                 'UEContextModificationRequest': {'members': [{'name': 'protocolIEs',
                                                                               'type': 'ProtocolIE-Container'},
                                                                              None],
                                                                  'type': 'SEQUENCE'},
                                 'UEContextModificationResponse': {'members': [{'name': 'protocolIEs',
                                                                                'type': 'ProtocolIE-Container'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                 'UEContextReleaseCommand': {'members': [{'name': 'protocolIEs',
                                                                          'type': 'ProtocolIE-Container'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'UEContextReleaseComplete': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'UEContextReleaseRequest': {'members': [{'name': 'protocolIEs',
                                                                          'type': 'ProtocolIE-Container'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'UEContextResumeFailure': {'members': [{'name': 'protocolIEs',
                                                                         'type': 'ProtocolIE-Container'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                 'UEContextResumeRequest': {'members': [{'name': 'protocolIEs',
                                                                         'type': 'ProtocolIE-Container'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                 'UEContextResumeResponse': {'members': [{'name': 'protocolIEs',
                                                                          'type': 'ProtocolIE-Container'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'UEContextSuspendRequest': {'members': [{'name': 'protocolIEs',
                                                                          'type': 'ProtocolIE-Container'},
                                                                         None],
                                                             'type': 'SEQUENCE'},
                                 'UEContextSuspendResponse': {'members': [{'name': 'protocolIEs',
                                                                           'type': 'ProtocolIE-Container'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                 'UEInformationTransfer': {'members': [{'name': 'protocolIEs',
                                                                        'type': 'ProtocolIE-Container'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                 'UERadioCapabilityMatchRequest': {'members': [{'name': 'protocolIEs',
                                                                                'type': 'ProtocolIE-Container'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                 'UERadioCapabilityMatchResponse': {'members': [{'name': 'protocolIEs',
                                                                                 'type': 'ProtocolIE-Container'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                 'UplinkNASTransport': {'members': [{'name': 'protocolIEs',
                                                                     'type': 'ProtocolIE-Container'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                 'UplinkNonUEAssociatedLPPaTransport': {'members': [{'name': 'protocolIEs',
                                                                                     'type': 'ProtocolIE-Container'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                 'UplinkS1cdma2000tunnelling': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'UplinkUEAssociatedLPPaTransport': {'members': [{'name': 'protocolIEs',
                                                                                  'type': 'ProtocolIE-Container'},
                                                                                 None],
                                                                     'type': 'SEQUENCE'},
                                 'WriteReplaceWarningRequest': {'members': [{'name': 'protocolIEs',
                                                                             'type': 'ProtocolIE-Container'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                 'WriteReplaceWarningResponse': {'members': [{'name': 'protocolIEs',
                                                                              'type': 'ProtocolIE-Container'},
                                                                             None],
                                                                 'type': 'SEQUENCE'}},
                       'values': {}},
 'S1AP-PDU-Descriptions': {'extensibility-implied': False,
                           'imports': {'S1AP-CommonDataTypes': ['Criticality',
                                                                'ProcedureCode'],
                                       'S1AP-Constants': ['id-CellTrafficTrace',
                                                          'id-DeactivateTrace',
                                                          'id-downlinkUEAssociatedLPPaTransport',
                                                          'id-downlinkNASTransport',
                                                          'id-downlinkNonUEAssociatedLPPaTransport',
                                                          'id-DownlinkS1cdma2000tunnelling',
                                                          'id-eNBStatusTransfer',
                                                          'id-ErrorIndication',
                                                          'id-HandoverCancel',
                                                          'id-HandoverNotification',
                                                          'id-HandoverPreparation',
                                                          'id-HandoverResourceAllocation',
                                                          'id-InitialContextSetup',
                                                          'id-initialUEMessage',
                                                          'id-ENBConfigurationUpdate',
                                                          'id-Kill',
                                                          'id-LocationReportingControl',
                                                          'id-LocationReportingFailureIndication',
                                                          'id-LocationReport',
                                                          'id-eNBDirectInformationTransfer',
                                                          'id-MMEConfigurationUpdate',
                                                          'id-MMEDirectInformationTransfer',
                                                          'id-MMEStatusTransfer',
                                                          'id-NASNonDeliveryIndication',
                                                          'id-OverloadStart',
                                                          'id-OverloadStop',
                                                          'id-Paging',
                                                          'id-PathSwitchRequest',
                                                          'id-PrivateMessage',
                                                          'id-Reset',
                                                          'id-S1Setup',
                                                          'id-E-RABModify',
                                                          'id-E-RABModificationIndication',
                                                          'id-E-RABRelease',
                                                          'id-E-RABReleaseIndication',
                                                          'id-E-RABSetup',
                                                          'id-TraceFailureIndication',
                                                          'id-TraceStart',
                                                          'id-UECapabilityInfoIndication',
                                                          'id-UEContextModification',
                                                          'id-UEContextRelease',
                                                          'id-UEContextReleaseRequest',
                                                          'id-UERadioCapabilityMatch',
                                                          'id-uplinkUEAssociatedLPPaTransport',
                                                          'id-uplinkNASTransport',
                                                          'id-uplinkNonUEAssociatedLPPaTransport',
                                                          'id-UplinkS1cdma2000tunnelling',
                                                          'id-WriteReplaceWarning',
                                                          'id-eNBConfigurationTransfer',
                                                          'id-MMEConfigurationTransfer',
                                                          'id-PWSRestartIndication',
                                                          'id-UEContextModificationIndication',
                                                          'id-RerouteNASRequest',
                                                          'id-PWSFailureIndication',
                                                          'id-UEContextSuspend',
                                                          'id-UEContextResume',
                                                          'id-ConnectionEstablishmentIndication',
                                                          'id-NASDeliveryIndication',
                                                          'id-RetrieveUEInformation',
                                                          'id-UEInformationTransfer',
                                                          'id-eNBCPRelocationIndication',
                                                          'id-MMECPRelocationIndication'],
                                       'S1AP-PDU-Contents': ['CellTrafficTrace',
                                                             'DeactivateTrace',
                                                             'DownlinkUEAssociatedLPPaTransport',
                                                             'DownlinkNASTransport',
                                                             'DownlinkNonUEAssociatedLPPaTransport',
                                                             'DownlinkS1cdma2000tunnelling',
                                                             'ENBDirectInformationTransfer',
                                                             'ENBStatusTransfer',
                                                             'ENBConfigurationUpdate',
                                                             'ENBConfigurationUpdateAcknowledge',
                                                             'ENBConfigurationUpdateFailure',
                                                             'ErrorIndication',
                                                             'HandoverCancel',
                                                             'HandoverCancelAcknowledge',
                                                             'HandoverCommand',
                                                             'HandoverFailure',
                                                             'HandoverNotify',
                                                             'HandoverPreparationFailure',
                                                             'HandoverRequest',
                                                             'HandoverRequestAcknowledge',
                                                             'HandoverRequired',
                                                             'InitialContextSetupFailure',
                                                             'InitialContextSetupRequest',
                                                             'InitialContextSetupResponse',
                                                             'InitialUEMessage',
                                                             'KillRequest',
                                                             'KillResponse',
                                                             'LocationReportingControl',
                                                             'LocationReportingFailureIndication',
                                                             'LocationReport',
                                                             'MMEConfigurationUpdate',
                                                             'MMEConfigurationUpdateAcknowledge',
                                                             'MMEConfigurationUpdateFailure',
                                                             'MMEDirectInformationTransfer',
                                                             'MMEStatusTransfer',
                                                             'NASNonDeliveryIndication',
                                                             'OverloadStart',
                                                             'OverloadStop',
                                                             'Paging',
                                                             'PathSwitchRequest',
                                                             'PathSwitchRequestAcknowledge',
                                                             'PathSwitchRequestFailure',
                                                             'PrivateMessage',
                                                             'Reset',
                                                             'ResetAcknowledge',
                                                             'S1SetupFailure',
                                                             'S1SetupRequest',
                                                             'S1SetupResponse',
                                                             'E-RABModifyRequest',
                                                             'E-RABModifyResponse',
                                                             'E-RABModificationIndication',
                                                             'E-RABModificationConfirm',
                                                             'E-RABReleaseCommand',
                                                             'E-RABReleaseResponse',
                                                             'E-RABReleaseIndication',
                                                             'E-RABSetupRequest',
                                                             'E-RABSetupResponse',
                                                             'TraceFailureIndication',
                                                             'TraceStart',
                                                             'UECapabilityInfoIndication',
                                                             'UEContextModificationFailure',
                                                             'UEContextModificationRequest',
                                                             'UEContextModificationResponse',
                                                             'UEContextReleaseCommand',
                                                             'UEContextReleaseComplete',
                                                             'UEContextReleaseRequest',
                                                             'UERadioCapabilityMatchRequest',
                                                             'UERadioCapabilityMatchResponse',
                                                             'UplinkUEAssociatedLPPaTransport',
                                                             'UplinkNASTransport',
                                                             'UplinkNonUEAssociatedLPPaTransport',
                                                             'UplinkS1cdma2000tunnelling',
                                                             'WriteReplaceWarningRequest',
                                                             'WriteReplaceWarningResponse',
                                                             'ENBConfigurationTransfer',
                                                             'MMEConfigurationTransfer',
                                                             'PWSRestartIndication',
                                                             'UEContextModificationIndication',
                                                             'UEContextModificationConfirm',
                                                             'RerouteNASRequest',
                                                             'PWSFailureIndication',
                                                             'UEContextSuspendRequest',
                                                             'UEContextSuspendResponse',
                                                             'UEContextResumeRequest',
                                                             'UEContextResumeResponse',
                                                             'UEContextResumeFailure',
                                                             'ConnectionEstablishmentIndication',
                                                             'NASDeliveryIndication',
                                                             'RetrieveUEInformation',
                                                             'UEInformationTransfer',
                                                             'ENBCPRelocationIndication',
                                                             'MMECPRelocationIndication']},
                           'object-classes': {'S1AP-ELEMENTARY-PROCEDURE': {'members': [{'name': '&InitiatingMessage',
                                                                                         'type': 'OpenType'},
                                                                                        {'name': '&SuccessfulOutcome',
                                                                                         'type': 'OpenType'},
                                                                                        {'name': '&UnsuccessfulOutcome',
                                                                                         'type': 'OpenType'},
                                                                                        {'name': '&procedureCode',
                                                                                         'type': 'ProcedureCode'},
                                                                                        {'name': '&criticality',
                                                                                         'type': 'Criticality'}]}},
                           'object-sets': {'S1AP-ELEMENTARY-PROCEDURES': {'class': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                          'members': []},
                                           'S1AP-ELEMENTARY-PROCEDURES-CLASS-1': {'class': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                                  'members': ['handoverPreparation',
                                                                                              'handoverResourceAllocation',
                                                                                              'pathSwitchRequest',
                                                                                              'e-RABSetup',
                                                                                              'e-RABModify',
                                                                                              'e-RABRelease',
                                                                                              'initialContextSetup',
                                                                                              'handoverCancel',
                                                                                              'kill',
                                                                                              'reset',
                                                                                              's1Setup',
                                                                                              'uEContextModification',
                                                                                              'uEContextRelease',
                                                                                              'eNBConfigurationUpdate',
                                                                                              'mMEConfigurationUpdate',
                                                                                              'writeReplaceWarning',
                                                                                              ',',
                                                                                              '.',
                                                                                              ',',
                                                                                              'uERadioCapabilityMatch',
                                                                                              'e-RABModificationIndication',
                                                                                              'uEContextModificationIndication',
                                                                                              'uEContextSuspend',
                                                                                              'uEContextResume']},
                                           'S1AP-ELEMENTARY-PROCEDURES-CLASS-2': {'class': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                                  'members': ['handoverNotification',
                                                                                              'e-RABReleaseIndication',
                                                                                              'paging',
                                                                                              'downlinkNASTransport',
                                                                                              'initialUEMessage',
                                                                                              'uplinkNASTransport',
                                                                                              'errorIndication',
                                                                                              'nASNonDeliveryIndication',
                                                                                              'uEContextReleaseRequest',
                                                                                              'downlinkS1cdma2000tunnelling',
                                                                                              'uplinkS1cdma2000tunnelling',
                                                                                              'uECapabilityInfoIndication',
                                                                                              'eNBStatusTransfer',
                                                                                              'mMEStatusTransfer',
                                                                                              'deactivateTrace',
                                                                                              'traceStart',
                                                                                              'traceFailureIndication',
                                                                                              'cellTrafficTrace',
                                                                                              'locationReportingControl',
                                                                                              'locationReportingFailureIndication',
                                                                                              'locationReport',
                                                                                              'overloadStart',
                                                                                              'overloadStop',
                                                                                              'eNBDirectInformationTransfer',
                                                                                              'mMEDirectInformationTransfer',
                                                                                              'eNBConfigurationTransfer',
                                                                                              'mMEConfigurationTransfer',
                                                                                              'privateMessage',
                                                                                              ',',
                                                                                              '.',
                                                                                              ',',
                                                                                              'downlinkUEAssociatedLPPaTransport',
                                                                                              'uplinkUEAssociatedLPPaTransport',
                                                                                              'downlinkNonUEAssociatedLPPaTransport',
                                                                                              'uplinkNonUEAssociatedLPPaTransport',
                                                                                              'pWSRestartIndication',
                                                                                              'rerouteNASRequest',
                                                                                              'pWSFailureIndication',
                                                                                              'connectionEstablishmentIndication',
                                                                                              'nASDeliveryIndication',
                                                                                              'retrieveUEInformation',
                                                                                              'uEInformationTransfer',
                                                                                              'eNBCPRelocationIndication',
                                                                                              'mMECPRelocationIndication']}},
                           'tags': 'AUTOMATIC',
                           'types': {'InitiatingMessage': {'members': [{'name': 'procedureCode',
                                                                        'table': {'type': 'S1AP-ELEMENTARY-PROCEDURES'},
                                                                        'type': 'S1AP-ELEMENTARY-PROCEDURE.&procedureCode'},
                                                                       {'name': 'criticality',
                                                                        'table': ['S1AP-ELEMENTARY-PROCEDURES',
                                                                                  ['procedureCode']],
                                                                        'type': 'S1AP-ELEMENTARY-PROCEDURE.&criticality'},
                                                                       {'name': 'value',
                                                                        'table': ['S1AP-ELEMENTARY-PROCEDURES',
                                                                                  ['procedureCode']],
                                                                        'type': 'S1AP-ELEMENTARY-PROCEDURE.&InitiatingMessage'}],
                                                           'type': 'SEQUENCE'},
                                     'S1AP-PDU': {'members': [{'name': 'initiatingMessage',
                                                               'type': 'InitiatingMessage'},
                                                              {'name': 'successfulOutcome',
                                                               'type': 'SuccessfulOutcome'},
                                                              {'name': 'unsuccessfulOutcome',
                                                               'type': 'UnsuccessfulOutcome'},
                                                              None],
                                                  'type': 'CHOICE'},
                                     'SuccessfulOutcome': {'members': [{'name': 'procedureCode',
                                                                        'table': {'type': 'S1AP-ELEMENTARY-PROCEDURES'},
                                                                        'type': 'S1AP-ELEMENTARY-PROCEDURE.&procedureCode'},
                                                                       {'name': 'criticality',
                                                                        'table': ['S1AP-ELEMENTARY-PROCEDURES',
                                                                                  ['procedureCode']],
                                                                        'type': 'S1AP-ELEMENTARY-PROCEDURE.&criticality'},
                                                                       {'name': 'value',
                                                                        'table': ['S1AP-ELEMENTARY-PROCEDURES',
                                                                                  ['procedureCode']],
                                                                        'type': 'S1AP-ELEMENTARY-PROCEDURE.&SuccessfulOutcome'}],
                                                           'type': 'SEQUENCE'},
                                     'UnsuccessfulOutcome': {'members': [{'name': 'procedureCode',
                                                                          'table': {'type': 'S1AP-ELEMENTARY-PROCEDURES'},
                                                                          'type': 'S1AP-ELEMENTARY-PROCEDURE.&procedureCode'},
                                                                         {'name': 'criticality',
                                                                          'table': ['S1AP-ELEMENTARY-PROCEDURES',
                                                                                    ['procedureCode']],
                                                                          'type': 'S1AP-ELEMENTARY-PROCEDURE.&criticality'},
                                                                         {'name': 'value',
                                                                          'table': ['S1AP-ELEMENTARY-PROCEDURES',
                                                                                    ['procedureCode']],
                                                                          'type': 'S1AP-ELEMENTARY-PROCEDURE.&UnsuccessfulOutcome'}],
                                                             'type': 'SEQUENCE'}},
                           'values': {'cellTrafficTrace': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                           'value': None},
                                      'connectionEstablishmentIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                            'value': None},
                                      'deactivateTrace': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                          'value': None},
                                      'downlinkNASTransport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                               'value': None},
                                      'downlinkNonUEAssociatedLPPaTransport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                               'value': None},
                                      'downlinkS1cdma2000tunnelling': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                       'value': None},
                                      'downlinkUEAssociatedLPPaTransport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                            'value': None},
                                      'e-RABModificationIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                      'value': None},
                                      'e-RABModify': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                      'value': None},
                                      'e-RABRelease': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                       'value': None},
                                      'e-RABReleaseIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                 'value': None},
                                      'e-RABSetup': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                     'value': None},
                                      'eNBCPRelocationIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                    'value': None},
                                      'eNBConfigurationTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                   'value': None},
                                      'eNBConfigurationUpdate': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                 'value': None},
                                      'eNBDirectInformationTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                       'value': None},
                                      'eNBStatusTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                            'value': None},
                                      'errorIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                          'value': None},
                                      'handoverCancel': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                         'value': None},
                                      'handoverNotification': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                               'value': None},
                                      'handoverPreparation': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                              'value': None},
                                      'handoverResourceAllocation': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                     'value': None},
                                      'initialContextSetup': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                              'value': None},
                                      'initialUEMessage': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                           'value': None},
                                      'kill': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                               'value': None},
                                      'locationReport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                         'value': None},
                                      'locationReportingControl': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                   'value': None},
                                      'locationReportingFailureIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                             'value': None},
                                      'mMECPRelocationIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                    'value': None},
                                      'mMEConfigurationTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                   'value': None},
                                      'mMEConfigurationUpdate': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                 'value': None},
                                      'mMEDirectInformationTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                       'value': None},
                                      'mMEStatusTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                            'value': None},
                                      'nASDeliveryIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                'value': None},
                                      'nASNonDeliveryIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                   'value': None},
                                      'overloadStart': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                        'value': None},
                                      'overloadStop': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                       'value': None},
                                      'pWSFailureIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                               'value': None},
                                      'pWSRestartIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                               'value': None},
                                      'paging': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                 'value': None},
                                      'pathSwitchRequest': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                            'value': None},
                                      'privateMessage': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                         'value': None},
                                      'rerouteNASRequest': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                            'value': None},
                                      'reset': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                'value': None},
                                      'retrieveUEInformation': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                'value': None},
                                      's1Setup': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                  'value': None},
                                      'traceFailureIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                 'value': None},
                                      'traceStart': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                     'value': None},
                                      'uECapabilityInfoIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                     'value': None},
                                      'uEContextModification': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                'value': None},
                                      'uEContextModificationIndication': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                          'value': None},
                                      'uEContextRelease': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                           'value': None},
                                      'uEContextReleaseRequest': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                  'value': None},
                                      'uEContextResume': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                          'value': None},
                                      'uEContextSuspend': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                           'value': None},
                                      'uEInformationTransfer': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                'value': None},
                                      'uERadioCapabilityMatch': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                 'value': None},
                                      'uplinkNASTransport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                             'value': None},
                                      'uplinkNonUEAssociatedLPPaTransport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                             'value': None},
                                      'uplinkS1cdma2000tunnelling': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                     'value': None},
                                      'uplinkUEAssociatedLPPaTransport': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                                          'value': None},
                                      'writeReplaceWarning': {'type': 'S1AP-ELEMENTARY-PROCEDURE',
                                                              'value': None}}}}