EXPECTED = {'IEEE1609dot2': {'extensibility-implied': False,
                  'imports': {'IEEE1609dot2BaseTypes': ['CrlSeries',
                                                        'EccP256CurvePoint',
                                                        'EciesP256EncryptedKey',
                                                        'EncryptionKey',
                                                        'GeographicRegion',
                                                        'GroupLinkageValue',
                                                        'HashAlgorithm',
                                                        'HashedId3',
                                                        'HashedId8',
                                                        'HashedId32',
                                                        'Hostname',
                                                        'IValue',
                                                        'LinkageValue',
                                                        'Opaque',
                                                        'Psid',
                                                        'PsidSsp',
                                                        'PsidSspRange',
                                                        'PublicEncryptionKey',
                                                        'PublicVerificationKey',
                                                        'SequenceOfPsidSsp',
                                                        'SequenceOfPsidSspRange',
                                                        'ServiceSpecificPermissions',
                                                        'Signature',
                                                        'SubjectAssurance',
                                                        'SymmetricEncryptionKey',
                                                        'ThreeDLocation',
                                                        'Time64',
                                                        'Uint3',
                                                        'Uint8',
                                                        'Uint16',
                                                        'Uint32',
                                                        'ValidityPeriod']},
                  'object-classes': {},
                  'object-sets': {},
                  'tags': 'AUTOMATIC',
                  'types': {'AesCcmCiphertext': {'members': [{'name': 'nonce',
                                                              'size': [12],
                                                              'type': 'OCTET '
                                                                      'STRING'},
                                                             {'name': 'ccmCiphertext',
                                                              'type': 'Opaque'}],
                                                 'type': 'SEQUENCE'},
                            'Certificate': {'restricted-to': [{'type': 'ImplicitCertificate'},
                                                              {'type': 'ExplicitCertificate'}],
                                            'type': 'CertificateBase'},
                            'CertificateBase': {'members': [{'name': 'version',
                                                             'restricted-to': [3],
                                                             'type': 'Uint8'},
                                                            {'name': 'type',
                                                             'type': 'CertificateType'},
                                                            {'name': 'issuer',
                                                             'type': 'IssuerIdentifier'},
                                                            {'name': 'toBeSigned',
                                                             'type': 'ToBeSignedCertificate'},
                                                            {'name': 'signature',
                                                             'optional': True,
                                                             'type': 'Signature'}],
                                                'type': 'SEQUENCE'},
                            'CertificateId': {'members': [{'name': 'linkageData',
                                                           'type': 'LinkageData'},
                                                          {'name': 'name',
                                                           'type': 'Hostname'},
                                                          {'name': 'binaryId',
                                                           'size': [(1, 64)],
                                                           'type': 'OCTET '
                                                                   'STRING'},
                                                          {'name': 'none',
                                                           'type': 'NULL'},
                                                          None],
                                              'type': 'CHOICE'},
                            'CertificateType': {'type': 'ENUMERATED',
                                                'values': [('explicit', 0),
                                                           ('implicit', 1),
                                                           None]},
                            'Countersignature': {'type': 'Ieee1609Dot2Data',
                                                 'with-components': [None,
                                                                     ('content',
                                                                      {'with-components': [None,
                                                                                           ('signedData',
                                                                                            {'with-components': [None,
                                                                                                                 ('tbsData',
                                                                                                                  {'with-components': [None,
                                                                                                                                       ('payload',
                                                                                                                                        {'with-components': [None,
                                                                                                                                                             ('data',
                                                                                                                                                              'ABSENT'),
                                                                                                                                                             ('extDataHash',
                                                                                                                                                              'PRESENT')]}),
                                                                                                                                       ('headerInfo',
                                                                                                                                        {'with-components': [None,
                                                                                                                                                             ('generationTime',
                                                                                                                                                              'PRESENT'),
                                                                                                                                                             ('expiryTime',
                                                                                                                                                              'ABSENT'),
                                                                                                                                                             ('generationLocation',
                                                                                                                                                              'ABSENT'),
                                                                                                                                                             ('p2pcdLearningRequest',
                                                                                                                                                              'ABSENT'),
                                                                                                                                                             ('missingCrlIdentifier',
                                                                                                                                                              'ABSENT'),
                                                                                                                                                             ('encryptionKey',
                                                                                                                                                              'ABSENT')]})]})]})]})]},
                            'EncryptedData': {'members': [{'name': 'recipients',
                                                           'type': 'SequenceOfRecipientInfo'},
                                                          {'name': 'ciphertext',
                                                           'type': 'SymmetricCiphertext'}],
                                              'type': 'SEQUENCE'},
                            'EncryptedDataEncryptionKey': {'members': [{'name': 'eciesNistP256',
                                                                        'type': 'EciesP256EncryptedKey'},
                                                                       {'name': 'eciesBrainpoolP256r1',
                                                                        'type': 'EciesP256EncryptedKey'},
                                                                       None],
                                                           'type': 'CHOICE'},
                            'EndEntityType': {'named-bits': [('app', '0'),
                                                             ('enrol', '1')],
                                              'size': [8],
                                              'type': 'BIT STRING'},
                            'ExplicitCertificate': {'type': 'CertificateBase',
                                                    'with-components': [None,
                                                                        ('type',
                                                                         'explicit'),
                                                                        ('toBeSigned',
                                                                         {'with-components': [None,
                                                                                              ('verifyKeyIndicator',
                                                                                               {'with-components': [['verificationKey']]})]}),
                                                                        ('signature',
                                                                         'PRESENT')]},
                            'HashedData': {'members': [{'name': 'sha256HashedData',
                                                        'size': [32],
                                                        'type': 'OCTET STRING'},
                                                       None],
                                           'type': 'CHOICE'},
                            'HeaderInfo': {'members': [{'name': 'psid',
                                                        'type': 'Psid'},
                                                       {'name': 'generationTime',
                                                        'optional': True,
                                                        'type': 'Time64'},
                                                       {'name': 'expiryTime',
                                                        'optional': True,
                                                        'type': 'Time64'},
                                                       {'name': 'generationLocation',
                                                        'optional': True,
                                                        'type': 'ThreeDLocation'},
                                                       {'name': 'p2pcdLearningRequest',
                                                        'optional': True,
                                                        'type': 'HashedId3'},
                                                       {'name': 'missingCrlIdentifier',
                                                        'optional': True,
                                                        'type': 'MissingCrlIdentifier'},
                                                       {'name': 'encryptionKey',
                                                        'optional': True,
                                                        'type': 'EncryptionKey'},
                                                       None],
                                           'type': 'SEQUENCE'},
                            'Ieee1609Dot2Content': {'members': [{'name': 'unsecuredData',
                                                                 'type': 'Opaque'},
                                                                {'name': 'signedData',
                                                                 'type': 'SignedData'},
                                                                {'name': 'encryptedData',
                                                                 'type': 'EncryptedData'},
                                                                {'name': 'signedCertificateRequest',
                                                                 'type': 'Opaque'},
                                                                None],
                                                    'type': 'CHOICE'},
                            'Ieee1609Dot2Data': {'members': [{'name': 'protocolVersion',
                                                              'restricted-to': [3],
                                                              'type': 'Uint8'},
                                                             {'name': 'content',
                                                              'type': 'Ieee1609Dot2Content'}],
                                                 'type': 'SEQUENCE'},
                            'ImplicitCertificate': {'type': 'CertificateBase',
                                                    'with-components': [None,
                                                                        ('type',
                                                                         'implicit'),
                                                                        ('toBeSigned',
                                                                         {'with-components': [None,
                                                                                              ('verifyKeyIndicator',
                                                                                               {'with-components': [['reconstructionValue']]})]}),
                                                                        ('signature',
                                                                         'ABSENT')]},
                            'IssuerIdentifier': {'members': [{'name': 'sha256AndDigest',
                                                              'type': 'HashedId8'},
                                                             {'name': 'self',
                                                              'type': 'HashAlgorithm'},
                                                             None],
                                                 'type': 'CHOICE'},
                            'LinkageData': {'members': [{'name': 'iCert',
                                                         'type': 'IValue'},
                                                        {'name': 'linkage-value',
                                                         'type': 'LinkageValue'},
                                                        {'name': 'group-linkage-value',
                                                         'optional': True,
                                                         'type': 'GroupLinkageValue'}],
                                            'type': 'SEQUENCE'},
                            'MissingCrlIdentifier': {'members': [{'name': 'cracaId',
                                                                  'type': 'HashedId3'},
                                                                 {'name': 'crlSeries',
                                                                  'type': 'CrlSeries'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                            'PKRecipientInfo': {'members': [{'name': 'recipientId',
                                                             'type': 'HashedId8'},
                                                            {'name': 'encKey',
                                                             'type': 'EncryptedDataEncryptionKey'}],
                                                'type': 'SEQUENCE'},
                            'PreSharedKeyRecipientInfo': {'type': 'HashedId8'},
                            'PsidGroupPermissions': {'members': [{'name': 'appPermissions',
                                                                  'type': 'SubjectPermissions'},
                                                                 {'default': 1,
                                                                  'name': 'minChainDepth',
                                                                  'type': 'INTEGER'},
                                                                 {'default': 0,
                                                                  'name': 'chainDepthRange',
                                                                  'type': 'INTEGER'},
                                                                 {'default': ['app'],
                                                                  'name': 'eeType',
                                                                  'type': 'EndEntityType'}],
                                                     'type': 'SEQUENCE'},
                            'RecipientInfo': {'members': [{'name': 'pskRecipInfo',
                                                           'type': 'PreSharedKeyRecipientInfo'},
                                                          {'name': 'symmRecipInfo',
                                                           'type': 'SymmRecipientInfo'},
                                                          {'name': 'certRecipInfo',
                                                           'type': 'PKRecipientInfo'},
                                                          {'name': 'signedDataRecipInfo',
                                                           'type': 'PKRecipientInfo'},
                                                          {'name': 'rekRecipInfo',
                                                           'type': 'PKRecipientInfo'}],
                                              'type': 'CHOICE'},
                            'SequenceOfCertificate': {'element': {'type': 'Certificate'},
                                                      'type': 'SEQUENCE OF'},
                            'SequenceOfPsidGroupPermissions': {'element': {'type': 'PsidGroupPermissions'},
                                                               'type': 'SEQUENCE '
                                                                       'OF'},
                            'SequenceOfRecipientInfo': {'element': {'type': 'RecipientInfo'},
                                                        'type': 'SEQUENCE OF'},
                            'SignedData': {'members': [{'name': 'hashId',
                                                        'type': 'HashAlgorithm'},
                                                       {'name': 'tbsData',
                                                        'type': 'ToBeSignedData'},
                                                       {'name': 'signer',
                                                        'type': 'SignerIdentifier'},
                                                       {'name': 'signature',
                                                        'type': 'Signature'}],
                                           'type': 'SEQUENCE'},
                            'SignedDataPayload': {'members': [{'name': 'data',
                                                               'optional': True,
                                                               'type': 'Ieee1609Dot2Data'},
                                                              {'name': 'extDataHash',
                                                               'optional': True,
                                                               'type': 'HashedData'},
                                                              None],
                                                  'type': 'SEQUENCE',
                                                  'with-components': [None,
                                                                      ('extDataHash',
                                                                       'PRESENT')]},
                            'SignerIdentifier': {'members': [{'name': 'digest',
                                                              'type': 'HashedId8'},
                                                             {'name': 'certificate',
                                                              'type': 'SequenceOfCertificate'},
                                                             {'name': 'self',
                                                              'type': 'NULL'},
                                                             None],
                                                 'type': 'CHOICE'},
                            'SubjectPermissions': {'members': [{'name': 'explicit',
                                                                'type': 'SequenceOfPsidSspRange'},
                                                               {'name': 'all',
                                                                'type': 'NULL'},
                                                               None],
                                                   'type': 'CHOICE'},
                            'SymmRecipientInfo': {'members': [{'name': 'recipientId',
                                                               'type': 'HashedId8'},
                                                              {'name': 'encKey',
                                                               'type': 'SymmetricCiphertext'}],
                                                  'type': 'SEQUENCE'},
                            'SymmetricCiphertext': {'members': [{'name': 'aes128ccm',
                                                                 'type': 'AesCcmCiphertext'},
                                                                None],
                                                    'type': 'CHOICE'},
                            'ToBeSignedCertificate': {'members': [{'name': 'id',
                                                                   'type': 'CertificateId'},
                                                                  {'name': 'cracaId',
                                                                   'type': 'HashedId3'},
                                                                  {'name': 'crlSeries',
                                                                   'type': 'CrlSeries'},
                                                                  {'name': 'validityPeriod',
                                                                   'type': 'ValidityPeriod'},
                                                                  {'name': 'region',
                                                                   'optional': True,
                                                                   'type': 'GeographicRegion'},
                                                                  {'name': 'assuranceLevel',
                                                                   'optional': True,
                                                                   'type': 'SubjectAssurance'},
                                                                  {'name': 'appPermissions',
                                                                   'optional': True,
                                                                   'type': 'SequenceOfPsidSsp'},
                                                                  {'name': 'certIssuePermissions',
                                                                   'optional': True,
                                                                   'type': 'SequenceOfPsidGroupPermissions'},
                                                                  {'name': 'certRequestPermissions',
                                                                   'optional': True,
                                                                   'type': 'SequenceOfPsidGroupPermissions'},
                                                                  {'name': 'canRequestRollover',
                                                                   'optional': True,
                                                                   'type': 'NULL'},
                                                                  {'name': 'encryptionKey',
                                                                   'optional': True,
                                                                   'type': 'PublicEncryptionKey'},
                                                                  {'name': 'verifyKeyIndicator',
                                                                   'type': 'VerificationKeyIndicator'},
                                                                  None],
                                                      'type': 'SEQUENCE',
                                                      'with-components': [None,
                                                                          ('certRequestPermissions',
                                                                           'PRESENT')]},
                            'ToBeSignedData': {'members': [{'name': 'payload',
                                                            'type': 'SignedDataPayload'},
                                                           {'name': 'headerInfo',
                                                            'type': 'HeaderInfo'}],
                                               'type': 'SEQUENCE'},
                            'VerificationKeyIndicator': {'members': [{'name': 'verificationKey',
                                                                      'type': 'PublicVerificationKey'},
                                                                     {'name': 'reconstructionValue',
                                                                      'type': 'EccP256CurvePoint'},
                                                                     None],
                                                         'type': 'CHOICE'}},
                  'values': {}},
 'IEEE1609dot2-Peer2Peer': {'extensibility-implied': False,
                            'imports': {'IEEE1609dot2': ['Certificate'],
                                        'IEEE1609dot2BaseTypes': ['Uint8']},
                            'object-classes': {},
                            'object-sets': {},
                            'tags': 'AUTOMATIC',
                            'types': {'CaCertP2pPDU': {'element': {'type': 'Certificate'},
                                                       'type': 'SEQUENCE OF'},
                                      'Ieee1609dot2Peer2PeerPDU': {'members': [{'name': 'version',
                                                                                'restricted-to': [1],
                                                                                'type': 'Uint8'},
                                                                               {'members': [{'name': 'caCerts',
                                                                                             'type': 'CaCertP2pPDU'},
                                                                                            None],
                                                                                'name': 'content',
                                                                                'type': 'CHOICE'}],
                                                                   'type': 'SEQUENCE'}},
                            'values': {}},
 'IEEE1609dot2BaseTypes': {'extensibility-implied': False,
                           'imports': {},
                           'object-classes': {},
                           'object-sets': {},
                           'tags': 'AUTOMATIC',
                           'types': {'BasePublicEncryptionKey': {'members': [{'name': 'eciesNistP256',
                                                                              'type': 'EccP256CurvePoint'},
                                                                             {'name': 'eciesBrainpoolP256r1',
                                                                              'type': 'EccP256CurvePoint'},
                                                                             None],
                                                                 'type': 'CHOICE'},
                                     'CircularRegion': {'members': [{'name': 'center',
                                                                     'type': 'TwoDLocation'},
                                                                    {'name': 'radius',
                                                                     'type': 'Uint16'}],
                                                        'type': 'SEQUENCE'},
                                     'CountryAndRegions': {'members': [{'name': 'countryOnly',
                                                                        'type': 'CountryOnly'},
                                                                       {'name': 'regions',
                                                                        'type': 'SequenceOfUint8'}],
                                                           'type': 'SEQUENCE'},
                                     'CountryAndSubregions': {'members': [{'name': 'country',
                                                                           'type': 'CountryOnly'},
                                                                          {'name': 'regionAndSubregions',
                                                                           'type': 'SequenceOfRegionAndSubregions'}],
                                                              'type': 'SEQUENCE'},
                                     'CountryOnly': {'type': 'Uint16'},
                                     'CrlSeries': {'type': 'Uint16'},
                                     'Duration': {'members': [{'name': 'microseconds',
                                                               'type': 'Uint16'},
                                                              {'name': 'milliseconds',
                                                               'type': 'Uint16'},
                                                              {'name': 'seconds',
                                                               'type': 'Uint16'},
                                                              {'name': 'minutes',
                                                               'type': 'Uint16'},
                                                              {'name': 'hours',
                                                               'type': 'Uint16'},
                                                              {'name': 'sixtyHours',
                                                               'type': 'Uint16'},
                                                              {'name': 'years',
                                                               'type': 'Uint16'}],
                                                  'type': 'CHOICE'},
                                     'EccP256CurvePoint': {'members': [{'name': 'x-only',
                                                                        'size': [32],
                                                                        'type': 'OCTET '
                                                                                'STRING'},
                                                                       {'name': 'fill',
                                                                        'type': 'NULL'},
                                                                       {'name': 'compressed-y-0',
                                                                        'size': [32],
                                                                        'type': 'OCTET '
                                                                                'STRING'},
                                                                       {'name': 'compressed-y-1',
                                                                        'size': [32],
                                                                        'type': 'OCTET '
                                                                                'STRING'},
                                                                       {'members': [{'name': 'x',
                                                                                     'size': [32],
                                                                                     'type': 'OCTET '
                                                                                             'STRING'},
                                                                                    {'name': 'y',
                                                                                     'size': [32],
                                                                                     'type': 'OCTET '
                                                                                             'STRING'}],
                                                                        'name': 'uncompressed',
                                                                        'type': 'SEQUENCE'}],
                                                           'type': 'CHOICE'},
                                     'EcdsaP256Signature': {'members': [{'name': 'r',
                                                                         'type': 'EccP256CurvePoint'},
                                                                        {'name': 's',
                                                                         'size': [32],
                                                                         'type': 'OCTET '
                                                                                 'STRING'}],
                                                            'type': 'SEQUENCE'},
                                     'EciesP256EncryptedKey': {'members': [{'name': 'v',
                                                                            'type': 'EccP256CurvePoint'},
                                                                           {'name': 'c',
                                                                            'size': [16],
                                                                            'type': 'OCTET '
                                                                                    'STRING'},
                                                                           {'name': 't',
                                                                            'size': [16],
                                                                            'type': 'OCTET '
                                                                                    'STRING'}],
                                                               'type': 'SEQUENCE'},
                                     'ElevInt': {'type': 'Uint16'},
                                     'Elevation': {'type': 'ElevInt'},
                                     'EncryptionKey': {'members': [{'name': 'public',
                                                                    'type': 'PublicEncryptionKey'},
                                                                   {'name': 'symmetric',
                                                                    'type': 'SymmetricEncryptionKey'}],
                                                       'type': 'CHOICE'},
                                     'GeographicRegion': {'members': [{'name': 'circularRegion',
                                                                       'type': 'CircularRegion'},
                                                                      {'name': 'rectangularRegion',
                                                                       'type': 'SequenceOfRectangularRegion'},
                                                                      {'name': 'polygonalRegion',
                                                                       'type': 'PolygonalRegion'},
                                                                      {'name': 'identifiedRegion',
                                                                       'type': 'SequenceOfIdentifiedRegion'},
                                                                      None],
                                                          'type': 'CHOICE'},
                                     'GroupLinkageValue': {'members': [{'name': 'jValue',
                                                                        'size': [4],
                                                                        'type': 'OCTET '
                                                                                'STRING'},
                                                                       {'name': 'value',
                                                                        'size': [9],
                                                                        'type': 'OCTET '
                                                                                'STRING'}],
                                                           'type': 'SEQUENCE'},
                                     'HashAlgorithm': {'type': 'ENUMERATED',
                                                       'values': [('sha256', 0),
                                                                  None]},
                                     'HashedId10': {'size': [10],
                                                    'type': 'OCTET STRING'},
                                     'HashedId3': {'size': [3],
                                                   'type': 'OCTET STRING'},
                                     'HashedId32': {'size': [32],
                                                    'type': 'OCTET STRING'},
                                     'HashedId4': {'size': [4],
                                                   'type': 'OCTET STRING'},
                                     'HashedId8': {'size': [8],
                                                   'type': 'OCTET STRING'},
                                     'Hostname': {'size': [(0, 255)],
                                                  'type': 'UTF8String'},
                                     'IValue': {'type': 'Uint16'},
                                     'IdentifiedRegion': {'members': [{'name': 'countryOnly',
                                                                       'type': 'CountryOnly'},
                                                                      {'name': 'countryAndRegions',
                                                                       'type': 'CountryAndRegions'},
                                                                      {'name': 'countryAndSubregions',
                                                                       'type': 'CountryAndSubregions'},
                                                                      None],
                                                          'type': 'CHOICE'},
                                     'KnownLatitude': {'restricted-to': [('min',
                                                                          'max')],
                                                       'type': 'NinetyDegreeInt'},
                                     'KnownLongitude': {'restricted-to': [('min',
                                                                           'max')],
                                                        'type': 'OneEightyDegreeInt'},
                                     'LaId': {'size': [2],
                                              'type': 'OCTET STRING'},
                                     'Latitude': {'type': 'NinetyDegreeInt'},
                                     'LinkageSeed': {'size': [16],
                                                     'type': 'OCTET STRING'},
                                     'LinkageValue': {'size': [9],
                                                      'type': 'OCTET STRING'},
                                     'Longitude': {'type': 'OneEightyDegreeInt'},
                                     'NinetyDegreeInt': {'named-numbers': {'max': 900000000,
                                                                           'min': -900000000,
                                                                           'unknown': 900000001},
                                                         'restricted-to': [(-900000000,
                                                                            900000001)],
                                                         'type': 'INTEGER'},
                                     'OneEightyDegreeInt': {'named-numbers': {'max': 1800000000,
                                                                              'min': -1799999999,
                                                                              'unknown': 1800000001},
                                                            'restricted-to': [(-1799999999,
                                                                               1800000001)],
                                                            'type': 'INTEGER'},
                                     'Opaque': {'type': 'OCTET STRING'},
                                     'PolygonalRegion': {'element': {'type': 'TwoDLocation'},
                                                         'size': [(3, 'MAX')],
                                                         'type': 'SEQUENCE OF'},
                                     'Psid': {'restricted-to': [(0, 'MAX')],
                                              'type': 'INTEGER'},
                                     'PsidSsp': {'members': [{'name': 'psid',
                                                              'type': 'Psid'},
                                                             {'name': 'ssp',
                                                              'optional': True,
                                                              'type': 'ServiceSpecificPermissions'}],
                                                 'type': 'SEQUENCE'},
                                     'PsidSspRange': {'members': [{'name': 'psid',
                                                                   'type': 'Psid'},
                                                                  {'name': 'sspRange',
                                                                   'optional': True,
                                                                   'type': 'SspRange'}],
                                                      'type': 'SEQUENCE'},
                                     'PublicEncryptionKey': {'members': [{'name': 'supportedSymmAlg',
                                                                          'type': 'SymmAlgorithm'},
                                                                         {'name': 'publicKey',
                                                                          'type': 'BasePublicEncryptionKey'}],
                                                             'type': 'SEQUENCE'},
                                     'PublicVerificationKey': {'members': [{'name': 'ecdsaNistP256',
                                                                            'type': 'EccP256CurvePoint'},
                                                                           {'name': 'ecdsaBrainpoolP256r1',
                                                                            'type': 'EccP256CurvePoint'},
                                                                           None],
                                                               'type': 'CHOICE'},
                                     'RectangularRegion': {'members': [{'name': 'northWest',
                                                                        'type': 'TwoDLocation'},
                                                                       {'name': 'southEast',
                                                                        'type': 'TwoDLocation'}],
                                                           'type': 'SEQUENCE'},
                                     'RegionAndSubregions': {'members': [{'name': 'region',
                                                                          'type': 'Uint8'},
                                                                         {'name': 'subregions',
                                                                          'type': 'SequenceOfUint16'}],
                                                             'type': 'SEQUENCE'},
                                     'SequenceOfIdentifiedRegion': {'element': {'type': 'IdentifiedRegion'},
                                                                    'type': 'SEQUENCE '
                                                                            'OF'},
                                     'SequenceOfOctetString': {'element': {'size': [(0,
                                                                                     'MAX')],
                                                                           'type': 'OCTET '
                                                                                   'STRING'},
                                                               'size': [(0,
                                                                         'MAX')],
                                                               'type': 'SEQUENCE '
                                                                       'OF'},
                                     'SequenceOfPsid': {'element': {'type': 'Psid'},
                                                        'type': 'SEQUENCE OF'},
                                     'SequenceOfPsidSsp': {'element': {'type': 'PsidSsp'},
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                                     'SequenceOfPsidSspRange': {'element': {'type': 'PsidSspRange'},
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                                     'SequenceOfRectangularRegion': {'element': {'type': 'RectangularRegion'},
                                                                     'type': 'SEQUENCE '
                                                                             'OF'},
                                     'SequenceOfRegionAndSubregions': {'element': {'type': 'RegionAndSubregions'},
                                                                       'type': 'SEQUENCE '
                                                                               'OF'},
                                     'SequenceOfUint16': {'element': {'type': 'Uint16'},
                                                          'type': 'SEQUENCE '
                                                                  'OF'},
                                     'SequenceOfUint3': {'element': {'type': 'Uint3'},
                                                         'type': 'SEQUENCE OF'},
                                     'SequenceOfUint8': {'element': {'type': 'Uint8'},
                                                         'type': 'SEQUENCE OF'},
                                     'ServiceSpecificPermissions': {'members': [{'name': 'opaque',
                                                                                 'size': [(0,
                                                                                           'MAX')],
                                                                                 'type': 'OCTET '
                                                                                         'STRING'},
                                                                                None],
                                                                    'type': 'CHOICE'},
                                     'Signature': {'members': [{'name': 'ecdsaNistP256Signature',
                                                                'type': 'EcdsaP256Signature'},
                                                               {'name': 'ecdsaBrainpoolP256r1Signature',
                                                                'type': 'EcdsaP256Signature'},
                                                               None],
                                                   'type': 'CHOICE'},
                                     'SspRange': {'members': [{'name': 'opaque',
                                                               'type': 'SequenceOfOctetString'},
                                                              {'name': 'all',
                                                               'type': 'NULL'},
                                                              None],
                                                  'type': 'CHOICE'},
                                     'SubjectAssurance': {'size': [1],
                                                          'type': 'OCTET '
                                                                  'STRING'},
                                     'SymmAlgorithm': {'type': 'ENUMERATED',
                                                       'values': [('aes128Ccm',
                                                                   0),
                                                                  None]},
                                     'SymmetricEncryptionKey': {'members': [{'name': 'aes128Ccm',
                                                                             'size': [16],
                                                                             'type': 'OCTET '
                                                                                     'STRING'},
                                                                            None],
                                                                'type': 'CHOICE'},
                                     'ThreeDLocation': {'members': [{'name': 'latitude',
                                                                     'type': 'Latitude'},
                                                                    {'name': 'longitude',
                                                                     'type': 'Longitude'},
                                                                    {'name': 'elevation',
                                                                     'type': 'Elevation'}],
                                                        'type': 'SEQUENCE'},
                                     'Time32': {'type': 'Uint32'},
                                     'Time64': {'type': 'Uint64'},
                                     'TwoDLocation': {'members': [{'name': 'latitude',
                                                                   'type': 'Latitude'},
                                                                  {'name': 'longitude',
                                                                   'type': 'Longitude'}],
                                                      'type': 'SEQUENCE'},
                                     'Uint16': {'restricted-to': [(0, 65535)],
                                                'type': 'INTEGER'},
                                     'Uint3': {'restricted-to': [(0, 7)],
                                               'type': 'INTEGER'},
                                     'Uint32': {'restricted-to': [(0,
                                                                   4294967295)],
                                                'type': 'INTEGER'},
                                     'Uint64': {'restricted-to': [(0,
                                                                   18446744073709551615)],
                                                'type': 'INTEGER'},
                                     'Uint8': {'restricted-to': [(0, 255)],
                                               'type': 'INTEGER'},
                                     'UnknownLatitude': {'restricted-to': ['unknown'],
                                                         'type': 'NinetyDegreeInt'},
                                     'UnknownLongitude': {'restricted-to': ['unknown'],
                                                          'type': 'OneEightyDegreeInt'},
                                     'ValidityPeriod': {'members': [{'name': 'start',
                                                                     'type': 'Time32'},
                                                                    {'name': 'duration',
                                                                     'type': 'Duration'}],
                                                        'type': 'SEQUENCE'}},
                           'values': {}},
 'IEEE1609dot2Crl': {'extensibility-implied': False,
                     'imports': {'IEEE1609dot2': ['Ieee1609Dot2Data'],
                                 'IEEE1609dot2BaseTypes': ['Psid', 'Opaque'],
                                 'IEEE1609dot2CrlBaseTypes': ['CrlContents']},
                     'object-classes': {},
                     'object-sets': {},
                     'tags': 'AUTOMATIC',
                     'types': {'CrlPsid': {'restricted-to': [135],
                                           'type': 'Psid'},
                               'SecuredCrl': {'type': 'Ieee1609Dot2Data',
                                              'with-components': [None,
                                                                  ('content',
                                                                   {'with-components': [('signedData',
                                                                                         {'with-components': [None,
                                                                                                              ('tbsData',
                                                                                                               {'with-components': [('payload',
                                                                                                                                     {'with-components': [None,
                                                                                                                                                          ('data',
                                                                                                                                                           {'with-components': [None,
                                                                                                                                                                                ('content',
                                                                                                                                                                                 {'with-components': [['unsecuredData',
                                                                                                                                                                                                       'CONTAINING',
                                                                                                                                                                                                       [{'type': 'CrlContents'},
                                                                                                                                                                                                        []]]]})]})]}),
                                                                                                                                    ('headerInfo',
                                                                                                                                     {'with-components': [None,
                                                                                                                                                          ('psid',
                                                                                                                                                           {'type': 'CrlPsid'}),
                                                                                                                                                          ('generationTime',
                                                                                                                                                           'ABSENT'),
                                                                                                                                                          ('expiryTime',
                                                                                                                                                           'ABSENT'),
                                                                                                                                                          ('generationLocation',
                                                                                                                                                           'ABSENT'),
                                                                                                                                                          ('p2pcdLearningRequest',
                                                                                                                                                           'ABSENT'),
                                                                                                                                                          ('missingCrlIdentifier',
                                                                                                                                                           'ABSENT'),
                                                                                                                                                          ('encryptionKey',
                                                                                                                                                           'ABSENT')]})]})]})]})]}},
                     'values': {}},
 'IEEE1609dot2CrlBaseTypes': {'extensibility-implied': False,
                              'imports': {'IEEE1609dot2BaseTypes': ['CrlSeries',
                                                                    'GeographicRegion',
                                                                    'HashedId8',
                                                                    'HashedId10',
                                                                    'IValue',
                                                                    'LaId',
                                                                    'LinkageSeed',
                                                                    'Opaque',
                                                                    'Psid',
                                                                    'Signature',
                                                                    'Time32',
                                                                    'Uint3',
                                                                    'Uint8',
                                                                    'Uint16',
                                                                    'Uint32',
                                                                    'ValidityPeriod']},
                              'object-classes': {},
                              'object-sets': {},
                              'tags': 'AUTOMATIC',
                              'types': {'CrlContents': {'members': [{'name': 'version',
                                                                     'restricted-to': [1],
                                                                     'type': 'Uint8'},
                                                                    {'name': 'crlSeries',
                                                                     'type': 'CrlSeries'},
                                                                    {'name': 'cracaId',
                                                                     'type': 'HashedId8'},
                                                                    {'name': 'issueDate',
                                                                     'type': 'Time32'},
                                                                    {'name': 'nextCrl',
                                                                     'type': 'Time32'},
                                                                    {'name': 'priorityInfo',
                                                                     'type': 'CrlPriorityInfo'},
                                                                    {'members': [{'name': 'fullHashCrl',
                                                                                  'type': 'ToBeSignedHashIdCrl'},
                                                                                 {'name': 'deltaHashCrl',
                                                                                  'type': 'ToBeSignedHashIdCrl'},
                                                                                 {'name': 'fullLinkedCrl',
                                                                                  'type': 'ToBeSignedLinkageValueCrl'},
                                                                                 {'name': 'deltaLinkedCrl',
                                                                                  'type': 'ToBeSignedLinkageValueCrl'},
                                                                                 None],
                                                                     'name': 'typeSpecific',
                                                                     'type': 'CHOICE'}],
                                                        'type': 'SEQUENCE'},
                                        'CrlPriorityInfo': {'members': [{'name': 'priority',
                                                                         'optional': True,
                                                                         'type': 'Uint8'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                        'GroupCrlEntry': {'members': [{'name': 'iMax',
                                                                       'type': 'Uint16'},
                                                                      {'name': 'la1Id',
                                                                       'type': 'LaId'},
                                                                      {'name': 'linkageSeed1',
                                                                       'type': 'LinkageSeed'},
                                                                      {'name': 'la2Id',
                                                                       'type': 'LaId'},
                                                                      {'name': 'linkageSeed2',
                                                                       'type': 'LinkageSeed'}],
                                                          'type': 'SEQUENCE'},
                                        'HashBasedRevocationInfo': {'members': [{'name': 'id',
                                                                                 'type': 'HashedId10'},
                                                                                {'name': 'expiry',
                                                                                 'type': 'Time32'}],
                                                                    'type': 'SEQUENCE'},
                                        'IMaxGroup': {'members': [{'name': 'iMax',
                                                                   'type': 'Uint16'},
                                                                  {'name': 'contents',
                                                                   'type': 'SequenceOfIndividualRevocation'}],
                                                      'type': 'SEQUENCE'},
                                        'IndividualRevocation': {'members': [{'name': 'linkage-seed1',
                                                                              'type': 'LinkageSeed'},
                                                                             {'name': 'linkage-seed2',
                                                                              'type': 'LinkageSeed'}],
                                                                 'type': 'SEQUENCE'},
                                        'JMaxGroup': {'members': [{'name': 'jmax',
                                                                   'type': 'Uint8'},
                                                                  {'element': {'type': 'LAGroup'},
                                                                   'name': 'contents',
                                                                   'type': 'SEQUENCE '
                                                                           'OF'}],
                                                      'type': 'SEQUENCE'},
                                        'LAGroup': {'members': [{'name': 'la1Id',
                                                                 'type': 'LaId'},
                                                                {'name': 'la2Id',
                                                                 'type': 'LaId'},
                                                                {'name': 'contents',
                                                                 'type': 'SequenceOfIMaxGroup'}],
                                                    'type': 'SEQUENCE'},
                                        'SequenceOfGroupCrlEntry': {'element': {'type': 'GroupCrlEntry'},
                                                                    'type': 'SEQUENCE '
                                                                            'OF'},
                                        'SequenceOfHashBasedRevocationInfo': {'element': {'type': 'HashBasedRevocationInfo'},
                                                                              'type': 'SEQUENCE '
                                                                                      'OF'},
                                        'SequenceOfIMaxGroup': {'element': {'type': 'IMaxGroup'},
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                                        'SequenceOfIndividualRevocation': {'element': {'type': 'IndividualRevocation'},
                                                                           'type': 'SEQUENCE '
                                                                                   'OF'},
                                        'SequenceOfJMaxGroup': {'element': {'type': 'JMaxGroup'},
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                                        'SequenceOfLAGroup': {'element': {'type': 'LAGroup'},
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                                        'ToBeSignedHashIdCrl': {'members': [{'name': 'crlSerial',
                                                                             'type': 'Uint32'},
                                                                            {'name': 'entries',
                                                                             'type': 'SequenceOfHashBasedRevocationInfo'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                        'ToBeSignedLinkageValueCrl': {'members': [{'name': 'iRev',
                                                                                   'type': 'IValue'},
                                                                                  {'name': 'indexWithinI',
                                                                                   'type': 'Uint8'},
                                                                                  {'name': 'individual',
                                                                                   'optional': True,
                                                                                   'type': 'SequenceOfJMaxGroup'},
                                                                                  {'name': 'groups',
                                                                                   'optional': True,
                                                                                   'type': 'SequenceOfGroupCrlEntry'},
                                                                                  None],
                                                                      'type': 'SEQUENCE',
                                                                      'with-components': [None,
                                                                                          ('groups',
                                                                                           'PRESENT')]}},
                              'values': {}},
 'IEEE1609dot2CrlSsp': {'extensibility-implied': False,
                        'imports': {'IEEE1609dot2BaseTypes': ['CrlSeries',
                                                              'Uint8']},
                        'object-classes': {},
                        'object-sets': {},
                        'tags': 'AUTOMATIC',
                        'types': {'CracaType': {'type': 'ENUMERATED',
                                                'values': [('isCraca', 0),
                                                           ('issuerIsCraca',
                                                            1)]},
                                  'CrlSsp': {'members': [{'name': 'version',
                                                          'restricted-to': [1],
                                                          'type': 'Uint8'},
                                                         {'name': 'associatedCraca',
                                                          'type': 'CracaType'},
                                                         {'name': 'crls',
                                                          'type': 'PermissibleCrls'},
                                                         None],
                                             'type': 'SEQUENCE'},
                                  'PermissibleCrls': {'element': {'type': 'CrlSeries'},
                                                      'type': 'SEQUENCE OF'}},
                        'values': {}}}