/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.hadoop.io;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.tensorflow.hadoop.io.TFRecordIOConf;
import org.tensorflow.hadoop.util.TFRecordWriter;

public class TFRecordFileOutputFormat
extends FileOutputFormat<BytesWritable, NullWritable> {
    public RecordWriter<BytesWritable, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Path file = this.getDefaultWorkFile(context, "");
        FileSystem fs = file.getFileSystem(conf);
        int bufferSize = TFRecordIOConf.getBufferSize(conf);
        final FSDataOutputStream fsdos = fs.create(file, true, bufferSize);
        final TFRecordWriter writer = new TFRecordWriter((DataOutput)fsdos);
        return new RecordWriter<BytesWritable, NullWritable>(){

            public void write(BytesWritable key, NullWritable value) throws IOException, InterruptedException {
                writer.write(key.getBytes(), 0, key.getLength());
            }

            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                fsdos.close();
            }
        };
    }
}

