/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.hadoop.util;

import java.util.zip.Checksum;
import org.apache.hadoop.util.PureJavaCrc32C;

public class Crc32C
implements Checksum {
    private static final int MASK_DELTA = -1568478504;
    private PureJavaCrc32C crc32C = new PureJavaCrc32C();

    public static int maskedCrc32c(byte[] data) {
        return Crc32C.maskedCrc32c(data, 0, data.length);
    }

    public static int maskedCrc32c(byte[] data, int offset, int length) {
        Crc32C crc32c = new Crc32C();
        crc32c.update(data, offset, length);
        return crc32c.getMaskedValue();
    }

    public static int mask(int crc) {
        return (crc >>> 15 | crc << 17) + -1568478504;
    }

    public static int unmask(int maskedCrc) {
        int rot = maskedCrc - -1568478504;
        return rot >>> 17 | rot << 15;
    }

    public int getMaskedValue() {
        return Crc32C.mask(this.getIntValue());
    }

    public int getIntValue() {
        return (int)this.getValue();
    }

    @Override
    public void update(int b) {
        this.crc32C.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.crc32C.update(b, off, len);
    }

    @Override
    public long getValue() {
        return this.crc32C.getValue();
    }

    @Override
    public void reset() {
        this.crc32C.reset();
    }
}

