/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.spark.datasources.tfrecords;

import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.tensorflow.example.Example;
import org.tensorflow.example.SequenceExample;
import org.tensorflow.hadoop.io.TFRecordFileOutputFormat;
import org.tensorflow.spark.datasources.tfrecords.DefaultSource$;
import org.tensorflow.spark.datasources.tfrecords.TensorflowRelation;
import org.tensorflow.spark.datasources.tfrecords.TensorflowRelation$;
import org.tensorflow.spark.datasources.tfrecords.serde.DefaultTfRecordRowEncoder$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u00015\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003%!hM]3d_J$7O\u0003\u0002\u0006\r\u0005YA-\u0019;bg>,(oY3t\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005QA/\u001a8t_J4Gn\\<\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\b\u0015?\t*\u0003CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016;5\taC\u0003\u0002\u00181\u000591o\\;sG\u0016\u001c(BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000fmQ!\u0001\b\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tqbC\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\bCA\u000b!\u0013\t\tcCA\rDe\u0016\fG/\u00192mKJ+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u000b$\u0013\t!cC\u0001\tSK2\fG/[8o!J|g/\u001b3feB\u0011QCJ\u0005\u0003OY\u0011acU2iK6\f'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"\u0001\f\u0001\u000e\u0003\tAQA\f\u0001\u0005B=\n\u0011b\u001d5peRt\u0015-\\3\u0015\u0003A\u0002\"!\r\u001b\u000f\u0005=\u0011\u0014BA\u001a\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0002\u0002\"\u0002\u001d\u0001\t\u0003J\u0014AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u0006uu\u001a\u0005*\u0014\t\u0003+mJ!\u0001\u0010\f\u0003\u0019\t\u000b7/\u001a*fY\u0006$\u0018n\u001c8\t\u000by:\u0004\u0019A \u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002A\u00036\t\u0001$\u0003\u0002C1\tQ1+\u0015'D_:$X\r\u001f;\t\u000b\u0011;\u0004\u0019A#\u0002\t5|G-\u001a\t\u0003\u0001\u001aK!a\u0012\r\u0003\u0011M\u000bg/Z'pI\u0016DQ!S\u001cA\u0002)\u000b!\u0002]1sC6,G/\u001a:t!\u0011\t4\n\r\u0019\n\u000513$aA'ba\")aj\u000ea\u0001\u001f\u0006!A-\u0019;b!\t\u0001fL\u0004\u0002R9:\u0011!k\u0017\b\u0003'js!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\ta\"\"\u0003\u0002\b7%\u0011\u0011DG\u0005\u0003;b\tq\u0001]1dW\u0006<W-\u0003\u0002`A\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003;bAQA\u0019\u0001\u0005\n\r\fAa]1wKR\u0019AmZ?\u0011\u0005=)\u0017B\u00014\u0011\u0005\u0011)f.\u001b;\t\u000b!\f\u0007\u0019A5\u0002\u0011\u0019,\u0017\r^;sKN\u00042A[7p\u001b\u0005Y'B\u00017\u001b\u0003\r\u0011H\rZ\u0005\u0003].\u00141A\u0015#E!\u0011y\u0001O\u001d>\n\u0005E\u0004\"A\u0002+va2,'\u0007\u0005\u0002tq6\tAO\u0003\u0002vm\u0006\u0011\u0011n\u001c\u0006\u0003on\ta\u0001[1e_>\u0004\u0018BA=u\u00055\u0011\u0015\u0010^3t/JLG/\u00192mKB\u00111o_\u0005\u0003yR\u0014ABT;mY^\u0013\u0018\u000e^1cY\u0016DQA`1A\u0002A\nA\u0001]1uQ\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0011aD:bm\u0016$\u0015n\u001d;sS\n,H/\u001a3\u0015\u0013\u0011\f)!a\u0002\u0002\n\u0005-\u0001\"\u00025\u0000\u0001\u0004I\u0007\"\u0002@\u0000\u0001\u0004\u0001\u0004\"\u0002 \u0000\u0001\u0004y\u0004\"\u0002#\u0000\u0001\u0004)\u0005bBA\b\u0001\u0011%\u0011\u0011C\u0001\ng\u00064X\rT8dC2$r\u0001ZA\n\u0003+\tI\u0002\u0003\u0004i\u0003\u001b\u0001\r!\u001b\u0005\b\u0003/\ti\u00011\u00011\u0003%awnY1m!\u0006$\b\u000e\u0003\u0004E\u0003\u001b\u0001\r!\u0012\u0005\u0007q\u0001!\t%!\b\u0015\u000fi\ny\"!\t\u0002$!1a(a\u0007A\u0002}Ba!SA\u000e\u0001\u0004Q\u0005\u0002CA\u0013\u00037\u0001\r!a\n\u0002\rM\u001c\u0007.Z7b!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u00171\u0005)A/\u001f9fg&!\u0011\u0011GA\u0016\u0005)\u0019FO];diRK\b/\u001a\u0005\u0007q\u0001!\t%!\u000e\u0015\r\u0005]\u0012QHA !\ra\u0013\u0011H\u0005\u0004\u0003w\u0011!A\u0005+f]N|'O\u001a7poJ+G.\u0019;j_:DaAPA\u001a\u0001\u0004y\u0004BB%\u00024\u0001\u0007!jB\u0004\u0002D\tA\t!!\u0012\u0002\u001b\u0011+g-Y;miN{WO]2f!\ra\u0013q\t\u0004\u0007\u0003\tA\t!!\u0013\u0014\u0007\u0005\u001dc\u0002C\u0004*\u0003\u000f\"\t!!\u0014\u0015\u0005\u0005\u0015\u0003\u0002CA)\u0003\u000f\"I!a\u0015\u0002']\u0014\u0018\u000e^3QCJ$\u0018\u000e^5p]2{7-\u00197\u0015\u0015\u0005U\u00131NA8\u0003k\n9\b\u0005\u0004\u0002X\u0005}\u0013Q\r\b\u0005\u00033\niFD\u0002V\u00037J\u0011!E\u0005\u0003;BIA!!\u0019\u0002d\tA\u0011\n^3sCR|'O\u0003\u0002^!A\u0019q\"a\u001a\n\u0007\u0005%\u0004CA\u0002J]RD\u0001\"!\u001c\u0002P\u0001\u0007\u0011QM\u0001\u0006S:$W\r\u001f\u0005\t\u0003c\ny\u00051\u0001\u0002t\u0005!\u0001/\u0019:u!\u0015\t9&a\u0018p\u0011\u001d\t9\"a\u0014A\u0002ABa\u0001RA(\u0001\u0004)\u0005\u0002CA>\u0003\u000f\"I!! \u0002-]\u0014\u0018\u000e^3QCJ$\u0018\u000e^5p]2{7-\u00197Gk:$b!a \u0002\u0006\u0006\u001d\u0005#C\b\u0002\u0002\u0006\u0015\u00141OA+\u0013\r\t\u0019\t\u0005\u0002\n\rVt7\r^5p]JBq!a\u0006\u0002z\u0001\u0007\u0001\u0007\u0003\u0004E\u0003s\u0002\r!\u0012")
public class DefaultSource
implements DataSourceRegister,
CreatableRelationProvider,
RelationProvider,
SchemaRelationProvider {
    public String shortName() {
        return "tfrecords";
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        String string;
        block6: {
            block5: {
                RDD features;
                String path;
                block4: {
                    path = (String)parameters.apply((Object)"path");
                    String recordType = (String)parameters.getOrElse((Object)"recordType", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Example";
                        }
                    });
                    features = data.rdd().map((Function1)new Serializable(this, recordType){
                        public static final long serialVersionUID = 0L;
                        private final String recordType$1;

                        public final Tuple2<BytesWritable, NullWritable> apply(Row row) {
                            block4: {
                                Tuple2 tuple2;
                                block3: {
                                    String string;
                                    block2: {
                                        string = this.recordType$1;
                                        if (!"Example".equals(string)) break block2;
                                        Example example = DefaultTfRecordRowEncoder$.MODULE$.encodeExample(row);
                                        tuple2 = new Tuple2((Object)new BytesWritable(example.toByteArray()), (Object)NullWritable.get());
                                        break block3;
                                    }
                                    if (!"SequenceExample".equals(string)) break block4;
                                    SequenceExample sequenceExample = DefaultTfRecordRowEncoder$.MODULE$.encodeSequenceExample(row);
                                    tuple2 = new Tuple2((Object)new BytesWritable(sequenceExample.toByteArray()), (Object)NullWritable.get());
                                }
                                return tuple2;
                            }
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported recordType ", ": recordType can be Example or SequenceExample"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.recordType$1})));
                        }
                        {
                            this.recordType$1 = recordType$1;
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    string = (String)parameters.getOrElse((Object)"writeLocality", (Function0)new $anonfun$3(this));
                    if (!"distributed".equals(string)) break block4;
                    this.saveDistributed((RDD<Tuple2<BytesWritable, NullWritable>>)features, path, sqlContext, mode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!"local".equals(string)) break block6;
                this.saveLocal((RDD<Tuple2<BytesWritable, NullWritable>>)features, path, mode);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return new TensorflowRelation(parameters, TensorflowRelation$.MODULE$.apply$default$2(), sqlContext.sparkSession());
        }
        if (string != null) {
            String string2 = string;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected 'distributed' or 'local', got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2})));
        }
        throw new MatchError((Object)string);
    }

    private void save(RDD<Tuple2<BytesWritable, NullWritable>> features, String path) {
        RDD<Tuple2<BytesWritable, NullWritable>> x$2 = features;
        ClassTag x$3 = ClassTag$.MODULE$.apply(BytesWritable.class);
        ClassTag x$4 = ClassTag$.MODULE$.apply(NullWritable.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$2);
        Object x$5 = null;
        RDD$.MODULE$.rddToPairRDDFunctions(x$2, x$3, x$4, null).saveAsNewAPIHadoopFile(path, ClassTag$.MODULE$.apply(TFRecordFileOutputFormat.class));
    }

    private void saveDistributed(RDD<Tuple2<BytesWritable, NullWritable>> features, String path, SQLContext sqlContext, SaveMode mode) {
        SaveMode saveMode;
        block10: {
            block8: {
                BoxedUnit boxedUnit;
                boolean pathExists;
                block9: {
                    block7: {
                        Configuration hadoopConf = sqlContext.sparkContext().hadoopConfiguration();
                        Path outputPath = new Path(path);
                        FileSystem fs = outputPath.getFileSystem(hadoopConf);
                        Path qualifiedOutputPath = outputPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
                        pathExists = fs.exists(qualifiedOutputPath);
                        saveMode = mode;
                        if (!SaveMode.Overwrite.equals(saveMode)) break block7;
                        fs.delete(qualifiedOutputPath, true);
                        this.save(features, path);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (SaveMode.Append.equals(saveMode)) {
                        throw new IllegalArgumentException("Append mode is not supported");
                    }
                    if (!SaveMode.ErrorIfExists.equals(saveMode)) break block9;
                    if (pathExists) {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path ", " already exists. SaveMode: ErrorIfExists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                    }
                    this.save(features, path);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    break block8;
                }
                if (!SaveMode.Ignore.equals(saveMode)) break block10;
                if (!pathExists) {
                    this.save(features, path);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
            }
            return;
        }
        throw new MatchError((Object)saveMode);
    }

    private void saveLocal(RDD<Tuple2<BytesWritable, NullWritable>> features, String localPath, SaveMode mode) {
        String cleanedPath = ((Object)Paths.get(localPath, new String[0]).toAbsolutePath()).toString();
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null)) {
            throw new IllegalArgumentException("Append mode is not supported in local write mode");
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Overwrite;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null)) {
            throw new IllegalArgumentException("Overwrite mode is not supported in local write mode");
        }
        Function2<Object, Iterator<Tuple2<BytesWritable, NullWritable>>, Iterator<Object>> f = DefaultSource$.MODULE$.org$tensorflow$spark$datasources$tfrecords$DefaultSource$$writePartitionLocalFun(localPath, mode);
        features.mapPartitionsWithIndex(f, features.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).collect();
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        return new TensorflowRelation(parameters, (Option<StructType>)new Some((Object)schema), sqlContext.sparkSession());
    }

    public TensorflowRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return new TensorflowRelation(parameters, TensorflowRelation$.MODULE$.apply$default$2(), sqlContext.sparkSession());
    }
}

