"""
    Institution Identifiers

    The Insitution Identifiers API provides a mapping between identifiers used in various University databases. The current known database namespaces are:  * `insts.lookup.cam.ac.uk` - [Lookup](https://www.lookup.cam.ac.uk/) instids. * `institution.v1.human-resources.university.identifiers.cam.ac.uk` -   identifiers used in the Human Resources (HR) database. * `institution.v1.student.university.identifiers.cam.ac.uk` - identifiers used   in the Student Information System (SIS) database.  The API provides a single endpoint which can be used to retrieve the current reports as a JSON document. For example, on a machine with [curl](https://curl.se/) installed:  ``` $ curl -o mapping.json https://api.apps.cam.ac.uk/institutions/mapping/v1 ```  The API is useful if you need to reconcile records drawn from multiple databases and determine which institutions are equivalent between them.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: devops@uis.cam.ac.uk
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.inst_identifier_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.inst_identifier_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.inst_identifier_client.model.mapping_response import MappingResponse


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_mapping_endpoint = _Endpoint(
            settings={
                'response_type': (MappingResponse,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/',
                'operation_id': 'get_mapping',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_mapping(
        self,
        **kwargs
    ):
        """Get latest mapping.  # noqa: E501

        Retrieve the most recent institution mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mapping(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MappingResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_mapping_endpoint.call_with_http_info(**kwargs)

