import * as cdk from '@aws-cdk/core';
export interface Notification {
    /**
     * Prefix title for slack message
     */
    readonly stageName?: string;
    /**
     * Slack webhook url from ssm parameter
     */
    readonly ssmSlackWebHookUrl?: string;
    /**
     * google chat webhook url from ssm parameter
     */
    readonly ssmGoogleChatWebHookUrl?: string;
    /**
     * telegram webhook url from from ssm parameter
     * the URL is not include text query string
     */
    readonly ssmTelegramWebHookUrl?: string;
}
export interface GitHubTokenFromSecretsManager {
    /**
     * Arn with other type of secrets
     */
    readonly secretsManagerArn?: string;
    /**
     * SecretKey
     */
    readonly secretKey?: string;
}
export interface CodePipelineBadgeNotificationProps {
    /**
     * AWS CodePipeline arn
     */
    readonly pipelineArn: string;
    /**
     * AWS Secret Manager id or arn
     */
    readonly gitHubTokenFromSecretsManager?: GitHubTokenFromSecretsManager;
    /**
     * Notification
     */
    readonly notification?: Notification;
}
export declare class CodePipelineBadgeNotification extends cdk.Construct {
    badgeUrl: string;
    codePipelineLink: string;
    constructor(scope: cdk.Construct, id: string, props: CodePipelineBadgeNotificationProps);
    private createCodePipelineEventLambdaFunction;
    private tagResource;
}
