import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [glue](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglue.html).
 *
 * @experimental
 */
export declare class Glue extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [glue](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglue.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create one or more partitions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchCreatePartition
     *
     * @experimental
     */
    toBatchCreatePartition(): this;
    /**
     * (experimental) Grants permission to delete one or more connections.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-BatchDeleteConnection
     *
     * @experimental
     */
    toBatchDeleteConnection(): this;
    /**
     * (experimental) Grants permission to delete one or more partitions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchDeletePartition
     *
     * @experimental
     */
    toBatchDeletePartition(): this;
    /**
     * (experimental) Grants permission to delete one or more tables.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-BatchDeleteTable
     *
     * @experimental
     */
    toBatchDeleteTable(): this;
    /**
     * (experimental) Grants permission to delete one or more versions of a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTableVersion
     *
     * @experimental
     */
    toBatchDeleteTableVersion(): this;
    /**
     * (experimental) Grants permission to retrieve one or more crawlers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-BatchGetCrawlers
     *
     * @experimental
     */
    toBatchGetCrawlers(): this;
    /**
     * (experimental) Grants permission to retrieve one or more development endpoints.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-BatchGetDevEndpoints
     *
     * @experimental
     */
    toBatchGetDevEndpoints(): this;
    /**
     * (experimental) Grants permission to retrieve one or more jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-BatchGetJobs
     *
     * @experimental
     */
    toBatchGetJobs(): this;
    /**
     * (experimental) Grants permission to retrieve one or more partitions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchGetPartition
     *
     * @experimental
     */
    toBatchGetPartition(): this;
    /**
     * (experimental) Grants permission to retrieve one or more triggers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-BatchGetTriggers
     *
     * @experimental
     */
    toBatchGetTriggers(): this;
    /**
     * (experimental) Grants permission to retrieve one or more workflows.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-BatchGetWorkflows
     *
     * @experimental
     */
    toBatchGetWorkflows(): this;
    /**
     * (experimental) Grants permission to stop one or more job runs for a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-BatchStopStartJobRun
     *
     * @experimental
     */
    toBatchStopJobRun(): this;
    /**
     * (experimental) Grants permission to stop a running ML Task Run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-CancelMLTaskRun
     *
     * @experimental
     */
    toCancelMLTaskRun(): this;
    /**
     * (experimental) Grants permission to retrieve a check the validity of schema version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CheckSchemaVersionValidity
     *
     * @experimental
     */
    toCheckSchemaVersionValidity(): this;
    /**
     * (experimental) Grants permission to create a classifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-CreateClassifier
     *
     * @experimental
     */
    toCreateClassifier(): this;
    /**
     * (experimental) Grants permission to create a connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-CreateConnection
     *
     * @experimental
     */
    toCreateConnection(): this;
    /**
     * (experimental) Grants permission to create a crawler.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-CreateCrawler
     *
     * @experimental
     */
    toCreateCrawler(): this;
    /**
     * (experimental) Grants permission to create a database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-CreateDatabase
     *
     * @experimental
     */
    toCreateDatabase(): this;
    /**
     * (experimental) Grants permission to create a development endpoint.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-CreateDevEndpoint
     *
     * @experimental
     */
    toCreateDevEndpoint(): this;
    /**
     * (experimental) Grants permission to create a job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-CreateJob
     *
     * @experimental
     */
    toCreateJob(): this;
    /**
     * (experimental) Grants permission to create an ML Transform.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-CreateMLTransform
     *
     * @experimental
     */
    toCreateMLTransform(): this;
    /**
     * (experimental) Grants permission to create a partition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-CreatePartition
     *
     * @experimental
     */
    toCreatePartition(): this;
    /**
     * (experimental) Grants permission to create a new schema registry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CreateRegistry
     *
     * @experimental
     */
    toCreateRegistry(): this;
    /**
     * (experimental) Grants permission to create a new schema container.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CreateSchema
     *
     * @experimental
     */
    toCreateSchema(): this;
    /**
     * (experimental) Grants permission to create a script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-CreateScript
     *
     * @experimental
     */
    toCreateScript(): this;
    /**
     * (experimental) Grants permission to create a security configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-CreateSecurityConfiguration
     *
     * @experimental
     */
    toCreateSecurityConfiguration(): this;
    /**
     * (experimental) Grants permission to create a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-CreateTable
     *
     * @experimental
     */
    toCreateTable(): this;
    /**
     * (experimental) Grants permission to create a trigger.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-CreateTrigger
     *
     * @experimental
     */
    toCreateTrigger(): this;
    /**
     * (experimental) Grants permission to create a function definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-CreateUserDefinedFunction
     *
     * @experimental
     */
    toCreateUserDefinedFunction(): this;
    /**
     * (experimental) Grants permission to create a workflow.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-CreateWorkflow
     *
     * @experimental
     */
    toCreateWorkflow(): this;
    /**
     * (experimental) Grants permission to delete a classifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-DeleteClassifier
     *
     * @experimental
     */
    toDeleteClassifier(): this;
    /**
     * (experimental) Grants permission to delete a connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-DeleteConnection
     *
     * @experimental
     */
    toDeleteConnection(): this;
    /**
     * (experimental) Grants permission to delete a crawler.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-DeleteCrawler
     *
     * @experimental
     */
    toDeleteCrawler(): this;
    /**
     * (experimental) Grants permission to delete a database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-DeleteDatabase
     *
     * @experimental
     */
    toDeleteDatabase(): this;
    /**
     * (experimental) Grants permission to delete a development endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-DeleteDevEndpoint
     *
     * @experimental
     */
    toDeleteDevEndpoint(): this;
    /**
     * (experimental) Grants permission to delete a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-DeleteJob
     *
     * @experimental
     */
    toDeleteJob(): this;
    /**
     * (experimental) Grants permission to delete an ML Transform.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-DeleteMLTransform
     *
     * @experimental
     */
    toDeleteMLTransform(): this;
    /**
     * (experimental) Grants permission to delete a partition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-DeletePartition
     *
     * @experimental
     */
    toDeletePartition(): this;
    /**
     * (experimental) Grants permission to delete a schema registry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteRegistry
     *
     * @experimental
     */
    toDeleteRegistry(): this;
    /**
     * (experimental) Grants permission to delete a resource policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-DeleteResourcePolicy
     *
     * @experimental
     */
    toDeleteResourcePolicy(): this;
    /**
     * (experimental) Grants permission to delete a schema container.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteSchema
     *
     * @experimental
     */
    toDeleteSchema(): this;
    /**
     * (experimental) Grants permission to delete a range of schema versions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteSchemaVersions
     *
     * @experimental
     */
    toDeleteSchemaVersions(): this;
    /**
     * (experimental) Grants permission to delete a security configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-DeleteSecurityConfiguration
     *
     * @experimental
     */
    toDeleteSecurityConfiguration(): this;
    /**
     * (experimental) Grants permission to delete a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTable
     *
     * @experimental
     */
    toDeleteTable(): this;
    /**
     * (experimental) Grants permission to delete a version of a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTableVersion
     *
     * @experimental
     */
    toDeleteTableVersion(): this;
    /**
     * (experimental) Grants permission to delete a trigger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-DeleteTrigger
     *
     * @experimental
     */
    toDeleteTrigger(): this;
    /**
     * (experimental) Grants permission to delete a function definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-DeleteUserDefinedFunction
     *
     * @experimental
     */
    toDeleteUserDefinedFunction(): this;
    /**
     * (experimental) Grants permission to delete a workflow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-DeleteWorkflow
     *
     * @experimental
     */
    toDeleteWorkflow(): this;
    /**
     * (experimental) Grants permission to retrieve the catalog import status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-migration.html#aws-glue-api-catalog-migration-GetCatalogImportStatus
     *
     * @experimental
     */
    toGetCatalogImportStatus(): this;
    /**
     * (experimental) Grants permission to retrieve a classifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-GetClassifier
     *
     * @experimental
     */
    toGetClassifier(): this;
    /**
     * (experimental) Grants permission to list all classifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-GetClassifiers
     *
     * @experimental
     */
    toGetClassifiers(): this;
    /**
     * (experimental) Grants permission to retrieve a connection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-GetConnection
     *
     * @experimental
     */
    toGetConnection(): this;
    /**
     * (experimental) Grants permission to retrieve a list of connections.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-GetConnections
     *
     * @experimental
     */
    toGetConnections(): this;
    /**
     * (experimental) Grants permission to retrieve a crawler.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawler
     *
     * @experimental
     */
    toGetCrawler(): this;
    /**
     * (experimental) Grants permission to retrieve metrics about crawlers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawlerMetrics
     *
     * @experimental
     */
    toGetCrawlerMetrics(): this;
    /**
     * (experimental) Grants permission to retrieve all crawlers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawlers
     *
     * @experimental
     */
    toGetCrawlers(): this;
    /**
     * (experimental) Grants permission to retrieve catalog encryption settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetDataCatalogEncryptionSettings
     *
     * @experimental
     */
    toGetDataCatalogEncryptionSettings(): this;
    /**
     * (experimental) Grants permission to retrieve a database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-GetDatabase
     *
     * @experimental
     */
    toGetDatabase(): this;
    /**
     * (experimental) Grants permission to retrieve all databases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-GetDatabases
     *
     * @experimental
     */
    toGetDatabases(): this;
    /**
     * (experimental) Grants permission to transform a script into a directed acyclic graph (DAG).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetDataflowGraph
     *
     * @experimental
     */
    toGetDataflowGraph(): this;
    /**
     * (experimental) Grants permission to retrieve a development endpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-GetDevEndpoint
     *
     * @experimental
     */
    toGetDevEndpoint(): this;
    /**
     * (experimental) Grants permission to retrieve all development endpoints.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-GetDevEndpoints
     *
     * @experimental
     */
    toGetDevEndpoints(): this;
    /**
     * (experimental) Grants permission to retrieve a job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-GetJob
     *
     * @experimental
     */
    toGetJob(): this;
    /**
     * (experimental) Grants permission to retrieve a job bookmark.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-job-GetJobBookmark
     *
     * @experimental
     */
    toGetJobBookmark(): this;
    /**
     * (experimental) Grants permission to retrieve a job run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-GetJobRun
     *
     * @experimental
     */
    toGetJobRun(): this;
    /**
     * (experimental) Grants permission to retrieve all job runs of a job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-GetJobRuns
     *
     * @experimental
     */
    toGetJobRuns(): this;
    /**
     * (experimental) Grants permission to retrieve all current jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-GetJobs
     *
     * @experimental
     */
    toGetJobs(): this;
    /**
     * (experimental) Grants permission to retrieve an ML Task Run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTaskRun
     *
     * @experimental
     */
    toGetMLTaskRun(): this;
    /**
     * (experimental) Grants permission to retrieve all ML Task Runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTaskRuns
     *
     * @experimental
     */
    toGetMLTaskRuns(): this;
    /**
     * (experimental) Grants permission to retrieve an ML Transform.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTransform
     *
     * @experimental
     */
    toGetMLTransform(): this;
    /**
     * (experimental) Grants permission to retrieve all ML Transforms.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTransforms
     *
     * @experimental
     */
    toGetMLTransforms(): this;
    /**
     * (experimental) Grants permission to create a mapping.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetMapping
     *
     * @experimental
     */
    toGetMapping(): this;
    /**
     * (experimental) Grants permission to retrieve a partition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetPartition
     *
     * @experimental
     */
    toGetPartition(): this;
    /**
     * (experimental) Grants permission to retrieve the partitions of a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetPartitions
     *
     * @experimental
     */
    toGetPartitions(): this;
    /**
     * (experimental) Grants permission to retrieve a mapping for a script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetPlan
     *
     * @experimental
     */
    toGetPlan(): this;
    /**
     * (experimental) Grants permission to retrieve a schema registry.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetRegistry
     *
     * @experimental
     */
    toGetRegistry(): this;
    /**
     * (experimental) Grants permission to retrieve a resource policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetResourcePolicy
     *
     * @experimental
     */
    toGetResourcePolicy(): this;
    /**
     * (experimental) Grants permission to retrieve a schema container.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchema
     *
     * @experimental
     */
    toGetSchema(): this;
    /**
     * (experimental) Grants permission to retrieve a schema version based on schema definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaByDefinition
     *
     * @experimental
     */
    toGetSchemaByDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve a schema version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaVersion
     *
     * @experimental
     */
    toGetSchemaVersion(): this;
    /**
     * (experimental) Grants permission to compare two schema versions in schema registry.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaVersionsDiff
     *
     * @experimental
     */
    toGetSchemaVersionsDiff(): this;
    /**
     * (experimental) Grants permission to retrieve a security configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetSecurityConfiguration
     *
     * @experimental
     */
    toGetSecurityConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve one or more security configurations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetSecurityConfigurations
     *
     * @experimental
     */
    toGetSecurityConfigurations(): this;
    /**
     * (experimental) Grants permission to retrieve a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTable
     *
     * @experimental
     */
    toGetTable(): this;
    /**
     * (experimental) Grants permission to retrieve a version of a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTableVersion
     *
     * @experimental
     */
    toGetTableVersion(): this;
    /**
     * (experimental) Grants permission to retrieve a list of versions of a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTableVersions
     *
     * @experimental
     */
    toGetTableVersions(): this;
    /**
     * (experimental) Grants permission to retrieve the tables in a database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTables
     *
     * @experimental
     */
    toGetTables(): this;
    /**
     * (experimental) Grants permission to retrieve all tags associated with a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-UntagResource
     *
     * @experimental
     */
    toGetTags(): this;
    /**
     * (experimental) Grants permission to retrieve a trigger.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-GetTrigger
     *
     * @experimental
     */
    toGetTrigger(): this;
    /**
     * (experimental) Grants permission to retrieve the triggers associated with a job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-GetTriggers
     *
     * @experimental
     */
    toGetTriggers(): this;
    /**
     * (experimental) Grants permission to retrieve a function definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-GetUserDefinedFunction
     *
     * @experimental
     */
    toGetUserDefinedFunction(): this;
    /**
     * (experimental) Grants permission to retrieve multiple function definitions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-GetUserDefinedFunctions
     *
     * @experimental
     */
    toGetUserDefinedFunctions(): this;
    /**
     * (experimental) Grants permission to retrieve a workflow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflow
     *
     * @experimental
     */
    toGetWorkflow(): this;
    /**
     * (experimental) Grants permission to retrieve a workflow run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRun
     *
     * @experimental
     */
    toGetWorkflowRun(): this;
    /**
     * (experimental) Grants permission to retrieve workflow run properties.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRunProperties
     *
     * @experimental
     */
    toGetWorkflowRunProperties(): this;
    /**
     * (experimental) Grants permission to retrieve all runs of a workflow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRuns
     *
     * @experimental
     */
    toGetWorkflowRuns(): this;
    /**
     * (experimental) Grants permission to import an Athena data catalog into AWS Glue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-migration.html#aws-glue-api-catalog-migration-ImportCatalogToGlue
     *
     * @experimental
     */
    toImportCatalogToGlue(): this;
    /**
     * (experimental) Grants permission to retrieve all crawlers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-ListCrawlers
     *
     * @experimental
     */
    toListCrawlers(): this;
    /**
     * (experimental) Grants permission to retrieve all development endpoints.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-ListDevEndpoints
     *
     * @experimental
     */
    toListDevEndpoints(): this;
    /**
     * (experimental) Grants permission to retrieve all current jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-ListJobs
     *
     * @experimental
     */
    toListJobs(): this;
    /**
     * (experimental) Grants permission to retrieve all ML Transforms.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-ListMLTransforms
     *
     * @experimental
     */
    toListMLTransforms(): this;
    /**
     * (experimental) Grants permission to retrieve a list of schema registries.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListRegistries
     *
     * @experimental
     */
    toListRegistries(): this;
    /**
     * (experimental) Grants permission to retrieve a list of schema versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListSchemaVersions
     *
     * @experimental
     */
    toListSchemaVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of schema containers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListSchemas
     *
     * @experimental
     */
    toListSchemas(): this;
    /**
     * (experimental) Grants permission to retrieve all triggers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-ListTriggers
     *
     * @experimental
     */
    toListTriggers(): this;
    /**
     * (experimental) Grants permission to retrieve all workflows.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ListWorkflows
     *
     * @experimental
     */
    toListWorkflows(): this;
    /**
     * (experimental) Grants permission to update catalog encryption settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-PutDataCatalogEncryptionSettings
     *
     * @experimental
     */
    toPutDataCatalogEncryptionSettings(): this;
    /**
     * (experimental) Grants permission to update a resource policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-PutResourcePolicy
     *
     * @experimental
     */
    toPutResourcePolicy(): this;
    /**
     * (experimental) Grants permission to add metadata to schema version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-PutSchemaVersionMetadata
     *
     * @experimental
     */
    toPutSchemaVersionMetadata(): this;
    /**
     * (experimental) Grants permission to update workflow run properties.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-PutWorkflowRunProperties
     *
     * @experimental
     */
    toPutWorkflowRunProperties(): this;
    /**
     * (experimental) Grants permission to fetch metadata for a schema version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-QuerySchemaVersionMetadata
     *
     * @experimental
     */
    toQuerySchemaVersionMetadata(): this;
    /**
     * (experimental) Grants permission to create a new schema version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-RegisterSchemaVersion
     *
     * @experimental
     */
    toRegisterSchemaVersion(): this;
    /**
     * (experimental) Grants permission to remove metadata from schema version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-RemoveSchemaVersionMetadata
     *
     * @experimental
     */
    toRemoveSchemaVersionMetadata(): this;
    /**
     * (experimental) Grants permission to reset a job bookmark.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-ResetJobBookmark
     *
     * @experimental
     */
    toResetJobBookmark(): this;
    /**
     * (experimental) Grants permission to retrieve the tables in the catalog.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-SearchTables
     *
     * @experimental
     */
    toSearchTables(): this;
    /**
     * (experimental) Grants permission to start a crawler.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StartCrawler
     *
     * @experimental
     */
    toStartCrawler(): this;
    /**
     * (experimental) Grants permission to change the schedule state of a crawler to SCHEDULED.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-StartCrawlerSchedule
     *
     * @experimental
     */
    toStartCrawlerSchedule(): this;
    /**
     * (experimental) Grants permission to start an Export Labels ML Task Run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartExportLabelsTaskRun
     *
     * @experimental
     */
    toStartExportLabelsTaskRun(): this;
    /**
     * (experimental) Grants permission to start an Import Labels ML Task Run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartImportLabelsTaskRun
     *
     * @experimental
     */
    toStartImportLabelsTaskRun(): this;
    /**
     * (experimental) Grants permission to start running a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-StartJobRun
     *
     * @experimental
     */
    toStartJobRun(): this;
    /**
     * (experimental) Grants permission to start an Evaluation ML Task Run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartMLEvaluationTaskRun
     *
     * @experimental
     */
    toStartMLEvaluationTaskRun(): this;
    /**
     * (experimental) Grants permission to start a Labeling Set Generation ML Task Run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartMLLabelingSetGenerationTaskRun
     *
     * @experimental
     */
    toStartMLLabelingSetGenerationTaskRun(): this;
    /**
     * (experimental) Grants permission to start a trigger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-StartTrigger
     *
     * @experimental
     */
    toStartTrigger(): this;
    /**
     * (experimental) Grants permission to start running a workflow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StartWorkflowRun
     *
     * @experimental
     */
    toStartWorkflowRun(): this;
    /**
     * (experimental) Grants permission to stop a running crawler.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StopCrawler
     *
     * @experimental
     */
    toStopCrawler(): this;
    /**
     * (experimental) Grants permission to set the schedule state of a crawler to NOT_SCHEDULED.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-StopCrawlerSchedule
     *
     * @experimental
     */
    toStopCrawlerSchedule(): this;
    /**
     * (experimental) Grants permission to stop a trigger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-StopTrigger
     *
     * @experimental
     */
    toStopTrigger(): this;
    /**
     * (experimental) Grants permission to add tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-TagResource
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags associated with a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-UntagResource
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a classifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-UpdateClassifier
     *
     * @experimental
     */
    toUpdateClassifier(): this;
    /**
     * (experimental) Grants permission to update a connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-UpdateConnection
     *
     * @experimental
     */
    toUpdateConnection(): this;
    /**
     * (experimental) Grants permission to update a crawler.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-UpdateCrawler
     *
     * @experimental
     */
    toUpdateCrawler(): this;
    /**
     * (experimental) Grants permission to update the schedule of a crawler.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-UpdateCrawlerSchedule
     *
     * @experimental
     */
    toUpdateCrawlerSchedule(): this;
    /**
     * (experimental) Grants permission to update a database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-UpdateDatabase
     *
     * @experimental
     */
    toUpdateDatabase(): this;
    /**
     * (experimental) Grants permission to update a development endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-UpdateDevEndpoint
     *
     * @experimental
     */
    toUpdateDevEndpoint(): this;
    /**
     * (experimental) Grants permission to update a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateJob
     *
     * @experimental
     */
    toUpdateJob(): this;
    /**
     * (experimental) Grants permission to update an ML Transform.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-UpdateMLTransform
     *
     * @experimental
     */
    toUpdateMLTransform(): this;
    /**
     * (experimental) Grants permission to update a partition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-UpdatePartition
     *
     * @experimental
     */
    toUpdatePartition(): this;
    /**
     * (experimental) Grants permission to update a schema registry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-UpdateRegistry
     *
     * @experimental
     */
    toUpdateRegistry(): this;
    /**
     * (experimental) Grants permission to update a schema container.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-UpdateSchema
     *
     * @experimental
     */
    toUpdateSchema(): this;
    /**
     * (experimental) Grants permission to update a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-UpdateTable
     *
     * @experimental
     */
    toUpdateTable(): this;
    /**
     * (experimental) Grants permission to update a trigger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-UpdateTrigger
     *
     * @experimental
     */
    toUpdateTrigger(): this;
    /**
     * (experimental) Grants permission to update a function definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-UpdateUserDefinedFunction
     *
     * @experimental
     */
    toUpdateUserDefinedFunction(): this;
    /**
     * (experimental) Grants permission to update a workflow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-UpdateWorkflow
     *
     * @experimental
     */
    toUpdateWorkflow(): this;
    /**
     * (experimental) Grants permission to use an ML Transform from within a Glue ETL Script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html
     *
     * @experimental
     */
    toUseMLTransforms(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type catalog to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCatalog(account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type database to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDatabase(databaseName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type table to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTable(databaseName: string, tableName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type tableversion to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param tableVersionName - Identifier for the tableVersionName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTableversion(databaseName: string, tableName: string, tableVersionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type connection to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param connectionName - Identifier for the connectionName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConnection(connectionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type userdefinedfunction to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param userDefinedFunctionName - Identifier for the userDefinedFunctionName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onUserdefinedfunction(databaseName: string, userDefinedFunctionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type devendpoint to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param devEndpointName - Identifier for the devEndpointName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDevendpoint(devEndpointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type job to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param jobName - Identifier for the jobName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onJob(jobName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type trigger to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param triggerName - Identifier for the triggerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrigger(triggerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type crawler to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param crawlerName - Identifier for the crawlerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCrawler(crawlerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type workflow to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param workflowName - Identifier for the workflowName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkflow(workflowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type mlTransform to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param transformId - Identifier for the transformId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMlTransform(transformId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type registry to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param registryName - Identifier for the registryName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRegistry(registryName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type schema to the statement.
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSchema(schemaName: string, account?: string, region?: string, partition?: string): this;
}
