import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [greengrass](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotgreengrass.html).
 *
 * @experimental
 */
export declare class Greengrass extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [greengrass](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotgreengrass.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate a role with a group.
     *
     * The role's permissions must allow Greengrass core Lambda functions and connectors to perform actions in other AWS services.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/associateroletogroup-put.html
     *
     * @experimental
     */
    toAssociateRoleToGroup(): this;
    /**
     * (experimental) Grants permission to associate a role with your account.
     *
     * AWS IoT Greengrass uses this role to access your Lambda functions and AWS IoT resources.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/associateserviceroletoaccount-put.html
     *
     * @experimental
     */
    toAssociateServiceRoleToAccount(): this;
    /**
     * (experimental) Grants permission to create a connector definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createconnectordefinition-post.html
     *
     * @experimental
     */
    toCreateConnectorDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing connector definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createconnectordefinitionversion-post.html
     *
     * @experimental
     */
    toCreateConnectorDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to create a core definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createcoredefinition-post.html
     *
     * @experimental
     */
    toCreateCoreDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing core definition.
     *
     * Greengrass groups must each contain exactly one Greengrass core.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createcoredefinitionversion-post.html
     *
     * @experimental
     */
    toCreateCoreDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to create a deployment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createdeployment-post.html
     *
     * @experimental
     */
    toCreateDeployment(): this;
    /**
     * (experimental) Grants permission to create a device definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createdevicedefinition-post.html
     *
     * @experimental
     */
    toCreateDeviceDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing device definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createdevicedefinitionversion-post.html
     *
     * @experimental
     */
    toCreateDeviceDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to create a Lambda function definition to be used in a group that contains a list of Lambda functions and their configurations.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createfunctiondefinition-post.html
     *
     * @experimental
     */
    toCreateFunctionDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing Lambda function definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createfunctiondefinitionversion-post.html
     *
     * @experimental
     */
    toCreateFunctionDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to create a group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/creategroup-post.html
     *
     * @experimental
     */
    toCreateGroup(): this;
    /**
     * (experimental) Grants permission to create a CA for the group, or rotate the existing CA.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/creategroupcertificateauthority-post.html
     *
     * @experimental
     */
    toCreateGroupCertificateAuthority(): this;
    /**
     * (experimental) Grants permission to create a version of a group that has already been defined.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/creategroupversion-post.html
     *
     * @experimental
     */
    toCreateGroupVersion(): this;
    /**
     * (experimental) Grants permission to create a logger definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createloggerdefinition-post.html
     *
     * @experimental
     */
    toCreateLoggerDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing logger definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createloggerdefinitionversion-post.html
     *
     * @experimental
     */
    toCreateLoggerDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to create a resource definition that contains a list of resources to be used in a group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createresourcedefinition-post.html
     *
     * @experimental
     */
    toCreateResourceDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing resource definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createresourcedefinitionversion-post.html
     *
     * @experimental
     */
    toCreateResourceDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to create an AWS IoT job that will trigger your Greengrass cores to update the software they are running.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createsoftwareupdatejob-post.html
     *
     * @experimental
     */
    toCreateSoftwareUpdateJob(): this;
    /**
     * (experimental) Grants permission to create a subscription definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createsubscriptiondefinition-post.html
     *
     * @experimental
     */
    toCreateSubscriptionDefinition(): this;
    /**
     * (experimental) Grants permission to create a version of an existing subscription definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/createsubscriptiondefinitionversion-post.html
     *
     * @experimental
     */
    toCreateSubscriptionDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to delete a connector definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deleteconnectordefinition-delete.html
     *
     * @experimental
     */
    toDeleteConnectorDefinition(): this;
    /**
     * (experimental) Grants permission to delete a core definition.
     *
     * Deleting a definition that is currently in use in a deployment affects future deployments.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deletecoredefinition-delete.html
     *
     * @experimental
     */
    toDeleteCoreDefinition(): this;
    /**
     * (experimental) Grants permission to delete a device definition.
     *
     * Deleting a definition that is currently in use in a deployment affects future deployments.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deletedevicedefinition-delete.html
     *
     * @experimental
     */
    toDeleteDeviceDefinition(): this;
    /**
     * (experimental) Grants permission to delete a Lambda function definition.
     *
     * Deleting a definition that is currently in use in a deployment affects future deployments.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deletefunctiondefinition-delete.html
     *
     * @experimental
     */
    toDeleteFunctionDefinition(): this;
    /**
     * (experimental) Grants permission to delete a group that is not currently in use in a deployment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deletegroup-delete.html
     *
     * @experimental
     */
    toDeleteGroup(): this;
    /**
     * (experimental) Grants permission to delete a logger definition.
     *
     * Deleting a definition that is currently in use in a deployment affects future deployments.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deleteloggerdefinition-delete.html
     *
     * @experimental
     */
    toDeleteLoggerDefinition(): this;
    /**
     * (experimental) Grants permission to delete a resource definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deleteresourcedefinition-delete.html
     *
     * @experimental
     */
    toDeleteResourceDefinition(): this;
    /**
     * (experimental) Grants permission to delete a subscription definition.
     *
     * Deleting a definition that is currently in use in a deployment affects future deployments.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/deletesubscriptiondefinition-delete.html
     *
     * @experimental
     */
    toDeleteSubscriptionDefinition(): this;
    /**
     * (experimental) Grants permission to disassociate the role from a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/disassociaterolefromgroup-delete.html
     *
     * @experimental
     */
    toDisassociateRoleFromGroup(): this;
    /**
     * (experimental) Grants permission to disassociate the service role from an account. Without a service role, deployments will not work.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/disassociateservicerolefromaccount-delete.html
     *
     * @experimental
     */
    toDisassociateServiceRoleFromAccount(): this;
    /**
     * (experimental) Grants permission to retrieve information required to connect to a Greengrass core.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-discover-api.html
     *
     * @experimental
     */
    toDiscover(): this;
    /**
     * (experimental) Grants permission to retrieve the role associated with a group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getassociatedrole-get.html
     *
     * @experimental
     */
    toGetAssociatedRole(): this;
    /**
     * (experimental) Grants permission to return the status of a bulk deployment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getbulkdeploymentstatus-get.html
     *
     * @experimental
     */
    toGetBulkDeploymentStatus(): this;
    /**
     * (experimental) Grants permission to retrieve the connectivity information for a core.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getconnectivityinfo-get.html
     *
     * @experimental
     */
    toGetConnectivityInfo(): this;
    /**
     * (experimental) Grants permission to retrieve information about a connector definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getconnectordefinition-get.html
     *
     * @experimental
     */
    toGetConnectorDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a connector definition version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getconnectordefinitionversion-get.html
     *
     * @experimental
     */
    toGetConnectorDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about a core definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getcoredefinition-get.html
     *
     * @experimental
     */
    toGetCoreDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a core definition version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getcoredefinitionversion-get.html
     *
     * @experimental
     */
    toGetCoreDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to return the status of a deployment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getdeploymentstatus-get.html
     *
     * @experimental
     */
    toGetDeploymentStatus(): this;
    /**
     * (experimental) Grants permission to retrieve information about a device definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getdevicedefinition-get.html
     *
     * @experimental
     */
    toGetDeviceDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a device definition version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getdevicedefinitionversion-get.html
     *
     * @experimental
     */
    toGetDeviceDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about a Lambda function definition, such as its creation time and latest version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getfunctiondefinition-get.html
     *
     * @experimental
     */
    toGetFunctionDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a Lambda function definition version, such as which Lambda functions are included in the version and their configurations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getfunctiondefinitionversion-get.html
     *
     * @experimental
     */
    toGetFunctionDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about a group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html
     *
     * @experimental
     */
    toGetGroup(): this;
    /**
     * (experimental) Grants permission to return the public key of the CA associated with a group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getgroupcertificateauthority-get.html
     *
     * @experimental
     */
    toGetGroupCertificateAuthority(): this;
    /**
     * (experimental) Grants permission to retrieve the current configuration for the CA used by a group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getgroupcertificateconfiguration-get.html
     *
     * @experimental
     */
    toGetGroupCertificateConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve information about a group version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getgroupversion-get.html
     *
     * @experimental
     */
    toGetGroupVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about a logger definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getloggerdefinition-get.html
     *
     * @experimental
     */
    toGetLoggerDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a logger definition version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getloggerdefinitionversion-get.html
     *
     * @experimental
     */
    toGetLoggerDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about a resource definition, such as its creation time and latest version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getresourcedefinition-get.html
     *
     * @experimental
     */
    toGetResourceDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a resource definition version, such as which resources are included in the version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getresourcedefinitionversion-get.html
     *
     * @experimental
     */
    toGetResourceDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to retrieve the service role that is attached to an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getserviceroleforaccount-get.html
     *
     * @experimental
     */
    toGetServiceRoleForAccount(): this;
    /**
     * (experimental) Grants permission to retrieve information about a subscription definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getsubscriptiondefinition-get.html
     *
     * @experimental
     */
    toGetSubscriptionDefinition(): this;
    /**
     * (experimental) Grants permission to retrieve information about a subscription definition version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/getsubscriptiondefinitionversion-get.html
     *
     * @experimental
     */
    toGetSubscriptionDefinitionVersion(): this;
    /**
     * (experimental) Grants permission to retrieve a paginated list of the deployments that have been started in a bulk deployment operation and their current deployment status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listbulkdeploymentdetailedreports-get.html
     *
     * @experimental
     */
    toListBulkDeploymentDetailedReports(): this;
    /**
     * (experimental) Grants permission to retrieve a list of bulk deployments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listbulkdeployments-get.html
     *
     * @experimental
     */
    toListBulkDeployments(): this;
    /**
     * (experimental) Grants permission to list the versions of a connector definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listconnectordefinitionversions-get.html
     *
     * @experimental
     */
    toListConnectorDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of connector definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listconnectordefinitions-get.html
     *
     * @experimental
     */
    toListConnectorDefinitions(): this;
    /**
     * (experimental) Grants permission to list the versions of a core definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listcoredefinitionversions-get.html
     *
     * @experimental
     */
    toListCoreDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of core definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listcoredefinitions-get.html
     *
     * @experimental
     */
    toListCoreDefinitions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of all deployments for a group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listdeployments-get.html
     *
     * @experimental
     */
    toListDeployments(): this;
    /**
     * (experimental) Grants permission to list the versions of a device definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listdevicedefinitionversions-get.html
     *
     * @experimental
     */
    toListDeviceDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of device definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listdevicedefinitions-get.html
     *
     * @experimental
     */
    toListDeviceDefinitions(): this;
    /**
     * (experimental) Grants permission to list the versions of a Lambda function definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listfunctiondefinitionversions-get.html
     *
     * @experimental
     */
    toListFunctionDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of Lambda function definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listfunctiondefinitions-get.html
     *
     * @experimental
     */
    toListFunctionDefinitions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of current CAs for a group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listgroupcertificateauthorities-get.html
     *
     * @experimental
     */
    toListGroupCertificateAuthorities(): this;
    /**
     * (experimental) Grants permission to list the versions of a group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listgroupversions-get.html
     *
     * @experimental
     */
    toListGroupVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html
     *
     * @experimental
     */
    toListGroups(): this;
    /**
     * (experimental) Grants permission to list the versions of a logger definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listloggerdefinitionversions-get.html
     *
     * @experimental
     */
    toListLoggerDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of logger definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listloggerdefinitions-get.html
     *
     * @experimental
     */
    toListLoggerDefinitions(): this;
    /**
     * (experimental) Grants permission to list the versions of a resource definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listresourcedefinitionversions-get.html
     *
     * @experimental
     */
    toListResourceDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of resource definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listresourcedefinitions-get.html
     *
     * @experimental
     */
    toListResourceDefinitions(): this;
    /**
     * (experimental) Grants permission to list the versions of a subscription definition.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listsubscriptiondefinitionversions-get.html
     *
     * @experimental
     */
    toListSubscriptionDefinitionVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of subscription definitions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listsubscriptiondefinitions-get.html
     *
     * @experimental
     */
    toListSubscriptionDefinitions(): this;
    /**
     * (experimental) Grants permission to list the tags for a resource.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/listtagsforresource-get.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to reset a group's deployments.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/resetdeployments-post.html
     *
     * @experimental
     */
    toResetDeployments(): this;
    /**
     * (experimental) Grants permission to deploy multiple groups in one operation.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/startbulkdeployment-post.html
     *
     * @experimental
     */
    toStartBulkDeployment(): this;
    /**
     * (experimental) Grants permission to stop the execution of a bulk deployment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/stopbulkdeployment-put.html
     *
     * @experimental
     */
    toStopBulkDeployment(): this;
    /**
     * (experimental) Grants permission to add tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/tagresource-post.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/untagresource-delete.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the connectivity information for a Greengrass core.
     *
     * Any devices that belong to the group that has this core will receive this information in order to find the location of the core and connect to it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updateconnectivityinfo-put.html
     *
     * @experimental
     */
    toUpdateConnectivityInfo(): this;
    /**
     * (experimental) Grants permission to update a connector definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updateconnectordefinition-put.html
     *
     * @experimental
     */
    toUpdateConnectorDefinition(): this;
    /**
     * (experimental) Grants permission to update a core definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updatecoredefinition-put.html
     *
     * @experimental
     */
    toUpdateCoreDefinition(): this;
    /**
     * (experimental) Grants permission to update a device definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updatedevicedefinition-put.html
     *
     * @experimental
     */
    toUpdateDeviceDefinition(): this;
    /**
     * (experimental) Grants permission to update a Lambda function definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updatefunctiondefinition-put.html
     *
     * @experimental
     */
    toUpdateFunctionDefinition(): this;
    /**
     * (experimental) Grants permission to update a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updategroup-put.html
     *
     * @experimental
     */
    toUpdateGroup(): this;
    /**
     * (experimental) Grants permission to update the certificate expiry time for a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updategroupcertificateconfiguration-put.html
     *
     * @experimental
     */
    toUpdateGroupCertificateConfiguration(): this;
    /**
     * (experimental) Grants permission to update a logger definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updateloggerdefinition-put.html
     *
     * @experimental
     */
    toUpdateLoggerDefinition(): this;
    /**
     * (experimental) Grants permission to update a resource definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updateresourcedefinition-put.html
     *
     * @experimental
     */
    toUpdateResourceDefinition(): this;
    /**
     * (experimental) Grants permission to update a subscription definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/updatesubscriptiondefinition-put.html
     *
     * @experimental
     */
    toUpdateSubscriptionDefinition(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type connectivityInfo to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-connectivityinfo.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConnectivityInfo(thingName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type artifact to the statement.
     *
     * @param groupId - Identifier for the groupId.
     * @param deploymentId - Identifier for the deploymentId.
     * @param artifactId - Identifier for the artifactId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onArtifact(groupId: string, deploymentId: string, artifactId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type certificateAuthority to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-sec.html
     *
     * @param groupId - Identifier for the groupId.
     * @param certificateAuthorityId - Identifier for the certificateAuthorityId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCertificateAuthority(groupId: string, certificateAuthorityId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deployment to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-createdeploymentrequest.html
     *
     * @param groupId - Identifier for the groupId.
     * @param deploymentId - Identifier for the deploymentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDeployment(groupId: string, deploymentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type bulkDeployment to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/developerguide/bulk-deploy-cli.html
     *
     * @param bulkDeploymentId - Identifier for the bulkDeploymentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBulkDeployment(bulkDeploymentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type group to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-groupinformation.html
     *
     * @param groupId - Identifier for the groupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGroup(groupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type groupVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-groupversion.html
     *
     * @param groupId - Identifier for the groupId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGroupVersion(groupId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type coreDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-core.html
     *
     * @param coreDefinitionId - Identifier for the coreDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCoreDefinition(coreDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type coreDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-coredefinitionversion.html
     *
     * @param coreDefinitionId - Identifier for the coreDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCoreDefinitionVersion(coreDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deviceDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-device.html
     *
     * @param deviceDefinitionId - Identifier for the deviceDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeviceDefinition(deviceDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deviceDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-devicedefinitionversion.html
     *
     * @param deviceDefinitionId - Identifier for the deviceDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDeviceDefinitionVersion(deviceDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type functionDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-function.html
     *
     * @param functionDefinitionId - Identifier for the functionDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFunctionDefinition(functionDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type functionDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-functiondefinitionversion.html
     *
     * @param functionDefinitionId - Identifier for the functionDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFunctionDefinitionVersion(functionDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type subscriptionDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-subscription.html
     *
     * @param subscriptionDefinitionId - Identifier for the subscriptionDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSubscriptionDefinition(subscriptionDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type subscriptionDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-subscriptiondefinitionversion.html
     *
     * @param subscriptionDefinitionId - Identifier for the subscriptionDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSubscriptionDefinitionVersion(subscriptionDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type loggerDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-logger.html
     *
     * @param loggerDefinitionId - Identifier for the loggerDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLoggerDefinition(loggerDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type loggerDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-loggerdefinitionversion.html
     *
     * @param loggerDefinitionId - Identifier for the loggerDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onLoggerDefinitionVersion(loggerDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resourceDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-resource.html
     *
     * @param resourceDefinitionId - Identifier for the resourceDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResourceDefinition(resourceDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resourceDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-resourcedefinitionversion.html
     *
     * @param resourceDefinitionId - Identifier for the resourceDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onResourceDefinitionVersion(resourceDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type connectorDefinition to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-connector.html
     *
     * @param connectorDefinitionId - Identifier for the connectorDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConnectorDefinition(connectorDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type connectorDefinitionVersion to the statement.
     *
     * https://docs.aws.amazon.com/greengrass/latest/apireference/definitions-connectordefinitionversion.html
     *
     * @param connectorDefinitionId - Identifier for the connectorDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConnectorDefinitionVersion(connectorDefinitionId: string, versionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type thing to the statement.
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onThing(thingName: string, account?: string, region?: string, partition?: string): this;
}
