import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [lightsail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlightsail.html).
 *
 * @experimental
 */
export declare class Lightsail extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [lightsail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlightsail.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Creates a static IP address that can be attached to an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_AllocateStaticIp.html
     *
     * @experimental
     */
    toAllocateStaticIp(): this;
    /**
     * (experimental) Attaches a disk to an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_AttachDisk.html
     *
     * @experimental
     */
    toAttachDisk(): this;
    /**
     * (experimental) Attaches one or more instances to a load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_AttachInstancesToLoadBalancer.html
     *
     * @experimental
     */
    toAttachInstancesToLoadBalancer(): this;
    /**
     * (experimental) Attaches a TLS certificate to a load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_AttachLoadBalancerTlsCertificate.html
     *
     * @experimental
     */
    toAttachLoadBalancerTlsCertificate(): this;
    /**
     * (experimental) Attaches a static IP address to an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_AttachStaticIp.html
     *
     * @experimental
     */
    toAttachStaticIp(): this;
    /**
     * (experimental) Closes a public port of an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CloseInstancePublicPorts.html
     *
     * @experimental
     */
    toCloseInstancePublicPorts(): this;
    /**
     * (experimental) Copies a snapshot from one AWS Region to another in Amazon Lightsail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CopySnapshot.html
     *
     * @experimental
     */
    toCopySnapshot(): this;
    /**
     * (experimental) Creates a new Amazon EC2 instance from an exported Amazon Lightsail snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateCloudFormationStack.html
     *
     * @experimental
     */
    toCreateCloudFormationStack(): this;
    /**
     * (experimental) Creates a disk.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateDisk.html
     *
     * @experimental
     */
    toCreateDisk(): this;
    /**
     * (experimental) Creates a disk from snapshot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateDiskFromSnapshot.html
     *
     * @experimental
     */
    toCreateDiskFromSnapshot(): this;
    /**
     * (experimental) Creates a disk snapshot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateDiskSnapshot.html
     *
     * @experimental
     */
    toCreateDiskSnapshot(): this;
    /**
     * (experimental) Creates a domain resource for the specified domain name.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateDomain.html
     *
     * @experimental
     */
    toCreateDomain(): this;
    /**
     * (experimental) Creates one or more DNS record entries for a domain resource: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateDomainEntry.html
     *
     * @experimental
     */
    toCreateDomainEntry(): this;
    /**
     * (experimental) Creates an instance snapshot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateInstanceSnapshot.html
     *
     * @experimental
     */
    toCreateInstanceSnapshot(): this;
    /**
     * (experimental) Creates one or more instances.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateInstances.html
     *
     * @experimental
     */
    toCreateInstances(): this;
    /**
     * (experimental) Creates one or more instances based on an instance snapshot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateInstancesFromSnapshot.html
     *
     * @experimental
     */
    toCreateInstancesFromSnapshot(): this;
    /**
     * (experimental) Creates a key pair used to authenticate and connect to an instance.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateKeyPair.html
     *
     * @experimental
     */
    toCreateKeyPair(): this;
    /**
     * (experimental) Creates a load balancer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateLoadBalancer.html
     *
     * @experimental
     */
    toCreateLoadBalancer(): this;
    /**
     * (experimental) Creates a load balancer TLS certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateLoadBalancerTlsCertificate.html
     *
     * @experimental
     */
    toCreateLoadBalancerTlsCertificate(): this;
    /**
     * (experimental) Creates a new relational database.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateRelationalDatabase.html
     *
     * @experimental
     */
    toCreateRelationalDatabase(): this;
    /**
     * (experimental) Creates a new relational database from a snapshot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateRelationalDatabaseFromSnapshot.html
     *
     * @experimental
     */
    toCreateRelationalDatabaseFromSnapshot(): this;
    /**
     * (experimental) Creates a relational database snapshot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateRelationalDatabaseSnapshot.html
     *
     * @experimental
     */
    toCreateRelationalDatabaseSnapshot(): this;
    /**
     * (experimental) Deletes a disk.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteDisk.html
     *
     * @experimental
     */
    toDeleteDisk(): this;
    /**
     * (experimental) Deletes a disk snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteDiskSnapshot.html
     *
     * @experimental
     */
    toDeleteDiskSnapshot(): this;
    /**
     * (experimental) Deletes a domain resource and all of its DNS records.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteDomain.html
     *
     * @experimental
     */
    toDeleteDomain(): this;
    /**
     * (experimental) Deletes a DNS record entry for a domain resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteDomainEntry.html
     *
     * @experimental
     */
    toDeleteDomainEntry(): this;
    /**
     * (experimental) Deletes an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteInstance.html
     *
     * @experimental
     */
    toDeleteInstance(): this;
    /**
     * (experimental) Deletes an instance snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteInstanceSnapshot.html
     *
     * @experimental
     */
    toDeleteInstanceSnapshot(): this;
    /**
     * (experimental) Deletes a key pair used to authenticate and connect to an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteKeyPair.html
     *
     * @experimental
     */
    toDeleteKeyPair(): this;
    /**
     * (experimental) Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteKnownHostKeys.html
     *
     * @experimental
     */
    toDeleteKnownHostKeys(): this;
    /**
     * (experimental) Deletes a load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteLoadBalancer.html
     *
     * @experimental
     */
    toDeleteLoadBalancer(): this;
    /**
     * (experimental) Deletes a load balancer TLS certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteLoadBalancerTlsCertificate.html
     *
     * @experimental
     */
    toDeleteLoadBalancerTlsCertificate(): this;
    /**
     * (experimental) Deletes a relational database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteRelationalDatabase.html
     *
     * @experimental
     */
    toDeleteRelationalDatabase(): this;
    /**
     * (experimental) Deletes relational database snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteRelationalDatabaseSnapshot.html
     *
     * @experimental
     */
    toDeleteRelationalDatabaseSnapshot(): this;
    /**
     * (experimental) Detaches a disk from an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DetachDisk.html
     *
     * @experimental
     */
    toDetachDisk(): this;
    /**
     * (experimental) Detaches one or more instances from a load balancer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DetachInstancesFromLoadBalancer.html
     *
     * @experimental
     */
    toDetachInstancesFromLoadBalancer(): this;
    /**
     * (experimental) Detaches a static IP from an instance to which it is attached.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DetachStaticIp.html
     *
     * @experimental
     */
    toDetachStaticIp(): this;
    /**
     * (experimental) Downloads the default key pair used to authenticate and connect to instances in a specific AWS Region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html
     *
     * @experimental
     */
    toDownloadDefaultKeyPair(): this;
    /**
     * (experimental) Exports an Amazon Lightsail snapshot to Amazon EC2.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ExportSnapshot.html
     *
     * @experimental
     */
    toExportSnapshot(): this;
    /**
     * (experimental) Returns the names of all active (not deleted) resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetActiveNames.html
     *
     * @experimental
     */
    toGetActiveNames(): this;
    /**
     * (experimental) Returns a list of instance images, or blueprints.
     *
     * You can use a blueprint to create a new instance already running a specific operating system, as well as a pre-installed application or development stack. The software that runs on your instance depends on the blueprint you define when creating the instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBlueprints.html
     *
     * @experimental
     */
    toGetBlueprints(): this;
    /**
     * (experimental) Returns a list of instance bundles.
     *
     * You can use a bundle to create a new instance with a set of performance specifications, such as CPU count, disk size, RAM size, and network transfer allowance. The cost of your instance depends on the bundle you define when creating the instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBundles.html
     *
     * @experimental
     */
    toGetBundles(): this;
    /**
     * (experimental) Returns information about all CloudFormation stacks used to create Amazon EC2 resources from exported Amazon Lightsail snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetCloudFormationStackRecords.html
     *
     * @experimental
     */
    toGetCloudFormationStackRecords(): this;
    /**
     * (experimental) Returns information about a disk.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetDisk.html
     *
     * @experimental
     */
    toGetDisk(): this;
    /**
     * (experimental) Returns information about a disk snapshot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetDiskSnapshot.html
     *
     * @experimental
     */
    toGetDiskSnapshot(): this;
    /**
     * (experimental) Returns information about all disk snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetDiskSnapshots.html
     *
     * @experimental
     */
    toGetDiskSnapshots(): this;
    /**
     * (experimental) Returns information about all disks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetDisks.html
     *
     * @experimental
     */
    toGetDisks(): this;
    /**
     * (experimental) Returns DNS records for a domain resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetDomain.html
     *
     * @experimental
     */
    toGetDomain(): this;
    /**
     * (experimental) Returns DNS records for all domain resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetDomains.html
     *
     * @experimental
     */
    toGetDomains(): this;
    /**
     * (experimental) Returns information about all records to export Amazon Lightsail snapshots to Amazon EC2.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetExportSnapshotRecords.html
     *
     * @experimental
     */
    toGetExportSnapshotRecords(): this;
    /**
     * (experimental) Returns information about an instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstance.html
     *
     * @experimental
     */
    toGetInstance(): this;
    /**
     * (experimental) Returns temporary keys you can use to authenticate and connect to an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstanceAccessDetails.html
     *
     * @experimental
     */
    toGetInstanceAccessDetails(): this;
    /**
     * (experimental) Returns the data points for the specified metric of an instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstanceMetricData.html
     *
     * @experimental
     */
    toGetInstanceMetricData(): this;
    /**
     * (experimental) Returns the port states of an instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstancePortStates.html
     *
     * @experimental
     */
    toGetInstancePortStates(): this;
    /**
     * (experimental) Returns information about an instance snapshot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstanceSnapshot.html
     *
     * @experimental
     */
    toGetInstanceSnapshot(): this;
    /**
     * (experimental) Returns information about all instance snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstanceSnapshots.html
     *
     * @experimental
     */
    toGetInstanceSnapshots(): this;
    /**
     * (experimental) Returns the state of an instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstanceState.html
     *
     * @experimental
     */
    toGetInstanceState(): this;
    /**
     * (experimental) Returns information about all instances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetInstances.html
     *
     * @experimental
     */
    toGetInstances(): this;
    /**
     * (experimental) Returns information about a key pair.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetKeyPair.html
     *
     * @experimental
     */
    toGetKeyPair(): this;
    /**
     * (experimental) Returns information about all key pairs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetKeyPairs.html
     *
     * @experimental
     */
    toGetKeyPairs(): this;
    /**
     * (experimental) Returns information about a load balancer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancer.html
     *
     * @experimental
     */
    toGetLoadBalancer(): this;
    /**
     * (experimental) Returns the data points for the specified metric of a load balancer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancerMetricData.html
     *
     * @experimental
     */
    toGetLoadBalancerMetricData(): this;
    /**
     * (experimental) Returns information about a load balancer TLS certificate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DeleteLoadBalancerTlsCertificate.html
     *
     * @experimental
     */
    toGetLoadBalancerTlsCertificates(): this;
    /**
     * (experimental) Returns information about load balancers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancers.html
     *
     * @experimental
     */
    toGetLoadBalancers(): this;
    /**
     * (experimental) Returns information about an operation.
     *
     * Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetOperation.html
     *
     * @experimental
     */
    toGetOperation(): this;
    /**
     * (experimental) Returns information about all operations.
     *
     * Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetOperations.html
     *
     * @experimental
     */
    toGetOperations(): this;
    /**
     * (experimental) Returns operations for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetOperationsForResource.html
     *
     * @experimental
     */
    toGetOperationsForResource(): this;
    /**
     * (experimental) Returns a list of all valid AWS Regions for Amazon Lightsail.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html
     *
     * @experimental
     */
    toGetRegions(): this;
    /**
     * (experimental) Returns information about a relational database.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabase.html
     *
     * @experimental
     */
    toGetRelationalDatabase(): this;
    /**
     * (experimental) Returns a list of relational database images, or blueprints.
     *
     * You can use a blueprint to create a new database running a specific database engine. The database engine that runs on your database depends on the blueprint you define when creating the relational database.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseBlueprints.html
     *
     * @experimental
     */
    toGetRelationalDatabaseBlueprints(): this;
    /**
     * (experimental) Returns a list of relational database bundles.
     *
     * You can use a bundle to create a new database with a set of performance specifications, such as CPU count, disk size, RAM size, network transfer allowance, and standard of high availability. The cost of your database depends on the bundle you define when creating the relational database.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseBundles.html
     *
     * @experimental
     */
    toGetRelationalDatabaseBundles(): this;
    /**
     * (experimental) Returns events for a relational database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseEvents.html
     *
     * @experimental
     */
    toGetRelationalDatabaseEvents(): this;
    /**
     * (experimental) Returns events for the specified log stream of a relational database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseLogEvents.html
     *
     * @experimental
     */
    toGetRelationalDatabaseLogEvents(): this;
    /**
     * (experimental) Returns the log streams available for a relational database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseLogStreams.html
     *
     * @experimental
     */
    toGetRelationalDatabaseLogStreams(): this;
    /**
     * (experimental) Returns the master user password of a relational database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseMasterUserPassword.html
     *
     * @experimental
     */
    toGetRelationalDatabaseMasterUserPassword(): this;
    /**
     * (experimental) Returns the data points for the specified metric of a relational database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseMetricData.html
     *
     * @experimental
     */
    toGetRelationalDatabaseMetricData(): this;
    /**
     * (experimental) Returns the parameters of a relational database.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseParameters.html
     *
     * @experimental
     */
    toGetRelationalDatabaseParameters(): this;
    /**
     * (experimental) Returns information about a relational database snapshot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseSnapshot.html
     *
     * @experimental
     */
    toGetRelationalDatabaseSnapshot(): this;
    /**
     * (experimental) Returns information about all relational database snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabaseSnapshots.html
     *
     * @experimental
     */
    toGetRelationalDatabaseSnapshots(): this;
    /**
     * (experimental) Return information about all relational databases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRelationalDatabases.html
     *
     * @experimental
     */
    toGetRelationalDatabases(): this;
    /**
     * (experimental) Returns information about a static IP.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetStaticIp.html
     *
     * @experimental
     */
    toGetStaticIp(): this;
    /**
     * (experimental) Returns information about all static IPs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetStaticIps.html
     *
     * @experimental
     */
    toGetStaticIps(): this;
    /**
     * (experimental) Imports a public key from a key pair.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ImportKeyPair.html
     *
     * @experimental
     */
    toImportKeyPair(): this;
    /**
     * (experimental) Returns a boolean value indicating whether the Amazon Lightsail virtual private cloud (VPC) is peered.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_IsVpcPeered.html
     *
     * @experimental
     */
    toIsVpcPeered(): this;
    /**
     * (experimental) Adds, or opens a public port of an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_OpenInstancePublicPorts.html
     *
     * @experimental
     */
    toOpenInstancePublicPorts(): this;
    /**
     * (experimental) Tries to peer the Amazon Lightsail virtual private cloud (VPC) with the default VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PeerVpc.html
     *
     * @experimental
     */
    toPeerVpc(): this;
    /**
     * (experimental) Sets the specified open ports for an instance, and closes all ports for every protocol not included in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PutInstancePublicPorts.html
     *
     * @experimental
     */
    toPutInstancePublicPorts(): this;
    /**
     * (experimental) Reboots an instance that is in a running state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_RebootInstance.html
     *
     * @experimental
     */
    toRebootInstance(): this;
    /**
     * (experimental) Reboots a relational database that is in a running state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_RebootRelationalDatabase.html
     *
     * @experimental
     */
    toRebootRelationalDatabase(): this;
    /**
     * (experimental) Deletes a static IP.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ReleaseStaticIp.html
     *
     * @experimental
     */
    toReleaseStaticIp(): this;
    /**
     * (experimental) Starts an instance that is in a stopped state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_StartInstance.html
     *
     * @experimental
     */
    toStartInstance(): this;
    /**
     * (experimental) Starts a relational database that is in a stopped state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_StartRelationalDatabase.html
     *
     * @experimental
     */
    toStartRelationalDatabase(): this;
    /**
     * (experimental) Stops an instance that is in a running state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_StopInstance.html
     *
     * @experimental
     */
    toStopInstance(): this;
    /**
     * (experimental) Stops a relational database that is in a running state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_StopRelationalDatabase.html
     *
     * @experimental
     */
    toStopRelationalDatabase(): this;
    /**
     * (experimental) Tags a resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Attempts to unpeer the Amazon Lightsail virtual private cloud (VPC) from the default VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UnpeerVpc.html
     *
     * @experimental
     */
    toUnpeerVpc(): this;
    /**
     * (experimental) Untags a resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates a domain recordset after it is created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateDomainEntry.html
     *
     * @experimental
     */
    toUpdateDomainEntry(): this;
    /**
     * (experimental) Updates a load balancer attribute, such as the health check path and session stickiness.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DetachInstancesFromLoadBalancer.html
     *
     * @experimental
     */
    toUpdateLoadBalancerAttribute(): this;
    /**
     * (experimental) Updates a relational database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateRelationalDatabase.html
     *
     * @experimental
     */
    toUpdateRelationalDatabase(): this;
    /**
     * (experimental) Updates the parameters of a relational database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateRelationalDatabaseParameters.html
     *
     * @experimental
     */
    toUpdateRelationalDatabaseParameters(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Domain to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_Domain.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDomain(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Instance to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_Instance.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInstance(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type InstanceSnapshot to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_InstanceSnapshot.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInstanceSnapshot(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type KeyPair to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_KeyPair.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onKeyPair(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type StaticIp to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_StaticIp.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStaticIp(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Disk to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_Disk.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDisk(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type DiskSnapshot to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DiskSnapshot.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDiskSnapshot(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type LoadBalancer to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_LoadBalancer.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLoadBalancer(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type PeeredVpc to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/PeeredVpc.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPeeredVpc(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type LoadBalancerTlsCertificate to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/LoadBalancerTlsCertificate.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onLoadBalancerTlsCertificate(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ExportSnapshotRecord to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ExportSnapshotRecord.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onExportSnapshotRecord(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type CloudFormationStackRecord to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CloudFormationStackRecord.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCloudFormationStackRecord(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type RelationalDatabase to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_RelationalDatabase.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRelationalDatabase(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type RelationalDatabaseSnapshot to the statement.
     *
     * https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_RelationalDatabaseSnapshot.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRelationalDatabaseSnapshot(id: string, account?: string, region?: string, partition?: string): this;
}
