import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [transcribe](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranscribe.html).
 *
 * @experimental
 */
export declare class Transcribe extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [transcribe](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranscribe.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a new custom language model.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateLanguageModel.html
     *
     * @experimental
     */
    toCreateLanguageModel(): this;
    /**
     * (experimental) Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     *
     * @experimental
     */
    toCreateMedicalVocabulary(): this;
    /**
     * (experimental) Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     *
     * @experimental
     */
    toCreateVocabulary(): this;
    /**
     * (experimental) Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     *
     * @experimental
     */
    toCreateVocabularyFilter(): this;
    /**
     * (experimental) Grants permission to delete a previously created custom language model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteLanguageModel.html
     *
     * @experimental
     */
    toDeleteLanguageModel(): this;
    /**
     * (experimental) Grants permission to delete a previously submitted medical transcription job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html
     *
     * @experimental
     */
    toDeleteMedicalTranscriptionJob(): this;
    /**
     * (experimental) Grants permission to delete a medical vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html
     *
     * @experimental
     */
    toDeleteMedicalVocabulary(): this;
    /**
     * (experimental) Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html
     *
     * @experimental
     */
    toDeleteTranscriptionJob(): this;
    /**
     * (experimental) Grants permission to delete a vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html
     *
     * @experimental
     */
    toDeleteVocabulary(): this;
    /**
     * (experimental) Grants permission to delete a vocabulary filter from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html
     *
     * @experimental
     */
    toDeleteVocabularyFilter(): this;
    /**
     * (experimental) Grants permission to return information about a custom language model.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DescribeLanguageModel.html
     *
     * @experimental
     */
    toDescribeLanguageModel(): this;
    /**
     * (experimental) Grants permission to return information about a medical transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html
     *
     * @experimental
     */
    toGetMedicalTranscriptionJob(): this;
    /**
     * (experimental) Grants permission to get information about a medical vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html
     *
     * @experimental
     */
    toGetMedicalVocabulary(): this;
    /**
     * (experimental) Grants permission to return information about a transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html
     *
     * @experimental
     */
    toGetTranscriptionJob(): this;
    /**
     * (experimental) Grants permission to to get information about a vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html
     *
     * @experimental
     */
    toGetVocabulary(): this;
    /**
     * (experimental) Grants permission to get information about a vocabulary filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html
     *
     * @experimental
     */
    toGetVocabularyFilter(): this;
    /**
     * (experimental) Grants permission to list custom language models.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListLanguageModels.html
     *
     * @experimental
     */
    toListLanguageModels(): this;
    /**
     * (experimental) Grants permission to list medical transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html
     *
     * @experimental
     */
    toListMedicalTranscriptionJobs(): this;
    /**
     * (experimental) Grants permission to return a list of medical vocabularies that match the specified criteria.
     *
     * If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html
     *
     * @experimental
     */
    toListMedicalVocabularies(): this;
    /**
     * (experimental) Grants permission to list transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html
     *
     * @experimental
     */
    toListTranscriptionJobs(): this;
    /**
     * (experimental) Grants permission to return a list of vocabularies that match the specified criteria.
     *
     * If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html
     *
     * @experimental
     */
    toListVocabularies(): this;
    /**
     * (experimental) Grants permission to return a list of vocabulary filters that match the specified criteria.
     *
     * If no criteria are specified, returns the at most 5 vocabulary filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html
     *
     * @experimental
     */
    toListVocabularyFilters(): this;
    /**
     * (experimental) Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html
     *
     * @experimental
     */
    toStartMedicalStreamTranscription(): this;
    /**
     * (experimental) Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html
     *
     * @experimental
     */
    toStartMedicalStreamTranscriptionWebSocket(): this;
    /**
     * (experimental) Grants permission to start an asynchronous job to transcribe medical speech to text.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html
     *
     * @experimental
     */
    toStartMedicalTranscriptionJob(): this;
    /**
     * (experimental) Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html
     *
     * @experimental
     */
    toStartStreamTranscription(): this;
    /**
     * (experimental) Grants permission to start a websocket stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html
     *
     * @experimental
     */
    toStartStreamTranscriptionWebSocket(): this;
    /**
     * (experimental) Grants permission to start an asynchronous job to transcribe speech to text.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifOutputBucketName()
     * - .ifOutputEncryptionKMSKeyId()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html
     *
     * @experimental
     */
    toStartTranscriptionJob(): this;
    /**
     * (experimental) Grants permission to update an existing medical vocabulary with new values.
     *
     * The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html
     *
     * @experimental
     */
    toUpdateMedicalVocabulary(): this;
    /**
     * (experimental) Grants permission to update an existing vocabulary with new values.
     *
     * The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html
     *
     * @experimental
     */
    toUpdateVocabulary(): this;
    /**
     * (experimental) Grants permission to update an existing vocabulary filter with new values.
     *
     * The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html
     *
     * @experimental
     */
    toUpdateVocabularyFilter(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Enables you to control access based on the output bucket name included in the request.
     *
     * Applies to actions:
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOutputBucketName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Enables you to control access based on the KMS key id included in the request.
     *
     * Applies to actions:
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOutputEncryptionKMSKeyId(value: string | string[], operator?: Operator | string): this;
}
