"use strict";
// This file is used in the base variant of the package: iam-floyd
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementBase = void 0;
/**
 * (experimental) Base class for the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementBase {
    /**
     * @experimental
     */
    constructor(sid) {
        /**
         * @experimental
         */
        this.sid = '';
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = '';
        if (typeof sid !== 'undefined') {
            this.sid = sid;
        }
    }
    /**
     * (experimental) JSON-ify the policy statement.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toJSON() {
        const statement = {};
        if (this.sid.length) {
            statement.Sid = this.sid;
        }
        return statement;
    }
}
exports.PolicyStatementBase = PolicyStatementBase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMS1iYXNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiMS1iYXNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxrRUFBa0U7Ozs7Ozs7O0FBS2xFLE1BQWEsbUJBQW1COzs7O0lBUTlCLFlBQVksR0FBWTs7OztRQVBqQixRQUFHLEdBQUcsRUFBRSxDQUFDOzs7Ozs7UUFLVCxrQkFBYSxHQUFHLEVBQUUsQ0FBQztRQUd4QixJQUFJLE9BQU8sR0FBRyxLQUFLLFdBQVcsRUFBRTtZQUM5QixJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztTQUNoQjtJQUNILENBQUM7Ozs7Ozs7O0lBUU0sTUFBTTtRQUNYLE1BQU0sU0FBUyxHQUFRLEVBQUUsQ0FBQztRQUUxQixJQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFO1lBQ25CLFNBQVMsQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQztTQUMxQjtRQUVELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7Q0FDRjtBQTdCRCxrREE2QkMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBUaGlzIGZpbGUgaXMgdXNlZCBpbiB0aGUgYmFzZSB2YXJpYW50IG9mIHRoZSBwYWNrYWdlOiBpYW0tZmxveWRcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFBvbGljeVN0YXRlbWVudEJhc2Uge1xuICBwdWJsaWMgc2lkID0gJyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJyc7XG5cbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgaWYgKHR5cGVvZiBzaWQgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgICB0aGlzLnNpZCA9IHNpZDtcbiAgICB9XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cbiAgcHVibGljIHRvSlNPTigpOiBhbnkge1xuICAgIGNvbnN0IHN0YXRlbWVudDogYW55ID0ge307XG5cbiAgICBpZiAodGhpcy5zaWQubGVuZ3RoKSB7XG4gICAgICBzdGF0ZW1lbnQuU2lkID0gdGhpcy5zaWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIHN0YXRlbWVudDtcbiAgfVxufVxuIl19