# CryptoSolve

This is a tool that generates and verifies cryptographic modes of operation using symbolic methods.

![Screenshot of Web Tool](data:image/png;base64,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)

## Install

To get started you should make sure that your environment is setup.

<u>Clone the repository</u>

```bash
git clone https://github.com/symcollab/CryptoSolve
cd CryptoSolve
```

<u>Create a virtual environment</u>

```bash
python3 -m venv senv
```

<u>Set your terminal session to use that environment</u>

```bash
source senv/bin/activate
```

<u>Install moe package</u>

```bash
./install_packages
```

If you encounter any permission errors, edit the file to look like the following instead,

```bash
pip install --user directoryname/
```

Now you can run the examples! In the future, don't forget to `source` the environment every time you open a new terminal session.

## Usage

The following commands are then in your path:

- moe_tool : Runs the command line version of the tool
- moe_website : Runs the website version of the tool

## Libraries Included

CryptoSolve is built upon several libraries that can be used standalone for other areas in Unification and automated reasoning.

### MOE

This module builds upon the rest of the modules defined below in order to express cryptographic modes of operation symbolically. The user can interface with this module via the web, terminal, or GUI application.

### Algebra

A term algebra library that defines a term recursively. Contains useful operations on terms such as substitution, and interfaces into sympy and general strings.

### Rewrite

The rewrite library contains contains rewrite rules that can operate over the terms in the algebra library. It also can produce variants given a set of rewrite rules, and can narrow one term into another.

### Unification

This module contains unification over terms modulo several popular theories. Currently AC Unification, Boolean Unification, EAC Unification, Syntactic Unification, and others are defined.

### Theories

Various data structures and their properties defined as rewrite rules are defined in this module. This module can be further extended in order to define an automated theorem prover for objects such as natural numbers, booleans, and lists.